static char TMRectangles_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/keysymdef.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern int
PtInRect C_P_ARGS((XPoint *p, netXSRectangle *r));

extern int
RectXRect C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern int
RectInRect C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern netXSRectangle *
MergeRects C_P_ARGS((netXSRectangle *r, netXSRectangle *s));

extern netXSRectangle *
MergeRectPt C_P_ARGS((netXSRectangle *r, XPoint *p));

extern XPoint
LineXRect C_P_ARGS((XPoint *p1, XPoint *p2, netXSRectangle *rect));

C_PROTOS_END_EXTERN

#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))

/*
 * net rectangle routines
 */
int
PtInRect (p, r)
register XPoint *p;
register netXSRectangle *r;
{
	return (p -> x >= r -> x &&
		p -> x < (r -> x + r -> width) &&
		p -> y >= r -> y &&
		p -> y < (r -> y + r -> height));
}

int
RectXRect (r, s)
register netXSRectangle *r;
register netXSRectangle *s;
{
	return (r -> x < (s -> x + s -> width) &&
		s -> x < (r -> x + r -> width) &&
		r -> y < (s -> y + s -> height) &&
		s -> y < (r -> y + r -> height));
}

int
RectInRect (r, s)
register netXSRectangle *r;
register netXSRectangle *s;
{
	return (r -> x >= s -> x &&
		(r -> x + r -> width) <= (s -> x + s -> width) &&
		r -> y >= s -> y &&
		(r -> y + r -> height) <= (s -> y + s -> height));
}

netXSRectangle *
MergeRects (r, s)
register netXSRectangle *r;
register netXSRectangle *s;
{
	short width, height;

	width = MAX (r -> x + r -> width, s -> x + s -> width);
	height = MAX (r -> y + r -> height, s -> y + s -> height);
	r -> x = MIN (r -> x, s -> x);
	r -> y = MIN (r -> y, s -> y);
	r -> width = width - r -> x;
	r -> height = height - r -> y;

	return r;
}

netXSRectangle *
MergeRectPt (r, p)
register netXSRectangle *r;
register XPoint *p;
{
	if (p -> x < r -> x)
	{
		r -> width += r -> x - p -> x;
		r -> x = p -> x;
	}
	else if (p -> x > r -> x + r -> width)
		r -> width = p -> x - r -> x;

	if (p -> y < r -> y)
	{
		r -> height += r -> y - p -> y;
		r -> y = p -> y;
	}
	else if (p -> y > r -> y + r -> height)
		r -> height = p -> y - r -> y;

	return r;
}

XPoint
LineXRect (p1, p2, rect)
XPoint *p1;
XPoint *p2;
netXSRectangle *rect;
{
	static XPoint ret_point;
	double testx, testy;
	double a, b;

	/*
	 * assume that p2 is within the rectangle
	 */

	/*
	 * vertical line
	 */
	if (p1 -> x == p2 -> x)
	{
		if (PtInRect (p1, rect) == FALSE)
		{
			if (p1 -> y < rect -> y)
				ret_point.y = rect -> y;
			else if (p1 -> y > rect -> y + rect -> height)
				ret_point.y = rect -> y + rect -> height;

			ret_point.x = p1 -> x;

			return ret_point;
		}
		else
		{
			/* a little better than a guess */
			int midx = rect -> x + rect -> width / 2;
			int midy = rect -> y + rect -> height / 2;
			int dx1 = abs (p1 -> x - midx);
			int dy1 = abs (p1 -> y - midy);
			int dx2 = abs (p2 -> x - midx);
			int dy2 = abs (p2 -> y - midy);

			if (dx1 <= dx2 && dy1 <= dy2)
				return ret_point = *p1;
			else
				return ret_point = *p2;
		}
	}

	/*
	 * horizontal line
	 */
	if (p1 -> y == p2 -> y)
	{
		if (PtInRect (p1, rect) == FALSE)
		{
			if (p1 -> x < rect -> x)
				ret_point.x = rect -> x;
			else if (p1 -> x > rect -> x + rect -> width)
				ret_point.x = rect -> x + rect -> width;

			ret_point.y = p1 -> y;

			return ret_point;
		}
		else
		{
			/* a little better than a guess */
			int midx = rect -> x + rect -> width / 2;
			int midy = rect -> y + rect -> height / 2;
			int dx1 = abs (p1 -> x - midx);
			int dy1 = abs (p1 -> y - midy);
			int dx2 = abs (p2 -> x - midx);
			int dy2 = abs (p2 -> y - midy);

			if (dx1 <= dx2 && dy1 <= dy2)
				return ret_point = *p1;
			else
				return ret_point = *p2;
		}
	}

	/*
	 * line with a slope and intercept y = ax + b
	 */
	a = (double) (p1 -> y - p2 -> y) / (double) (p1 -> x - p2 -> x);
	b = (double) p1 -> y - (a * (double) p1 -> x);

	/*
	 * positive slope
	 */
	if (a > 0.000000)
	{
		/*
		 * upper right
		 */
		if (p2 -> x > p1 -> x)
		{
			testx = ((double) rect -> y - b) / a + 0.5;
			if (testx >= rect -> x &&
			    testx <= (double) (rect -> x + rect -> width))
			{
				ret_point.x = testx;
				ret_point.y = rect -> y;
				return ret_point;
			}
			ret_point.x = rect -> x;
			ret_point.y = a * ret_point.x + b + 0.5;
			return ret_point;
		}
		/*
		 * lower left
		 */
		testy = a * (double) (rect -> x + rect -> width) + b + 0.5;
		if (testy >= rect -> y &&
		    testy <= (double) (rect -> y + rect -> height))
		{
			ret_point.x = rect -> x + rect -> width;
			ret_point.y = testy;
			return ret_point;
		}
		ret_point.y = rect -> y + rect -> height;
		ret_point.x = ((double) ret_point.y - b) / a + 0.5;
		return ret_point;
	}

	/*
	 * negative slope
	 */
	/*
	 * lower right
	 */
	if (p2 -> x < p1 -> x)
	{
		testy = a * (rect -> x + rect -> width) + b + 0.5;
		if (testy >= rect -> y &&
		    testy <= (double) (rect -> y + rect -> height))
		{
			ret_point.x = rect -> x + rect -> width;
			ret_point.y = testy;
			return ret_point;
		}
		ret_point.y = rect -> y;
		ret_point.x = ((double) ret_point.y - b) / a + 0.5;
		return ret_point;
	}

	/*
	 * upper left
	 */
	testx = ((double) (rect -> y + rect -> height) - b) / a + 0.5;
	if (testx >= rect -> x &&
	    testx <= (double) (rect -> x + rect -> width))
	{
		ret_point.x = testx;
		ret_point.y = rect -> y + rect -> height;
		return ret_point;
	}
	ret_point.x = rect -> x;
	ret_point.y = a * ret_point.x + b + 0.5;
	return ret_point;
}
