.so pictures
.Cl 3
.nr Hs 4
.nr Hb 4
.nr Hu 7
.nr Cl 3
.de CW
.sp 0.1i
.DS L N
.in 0.25i
.ft CW
..
.de CN
.ft P
.in -0.25i
.sp 0.1i
.DE
..
'	\" Parameters for .iS and .iE macros.
.nr iI 0.150i
.nr iO 0.075i
.nr iL \n(.lu-\n(iIu-\n(iIu+\n(iOu+\n(iOu
'
'	\" .iS title [1] [1] [1]
'	\" If $2 != 1, print the title in the upper RH corner.
'	\" If $3 == 1, use DF instead of DS.
'	\" If $4 == 1, print line numbers.
.de iS
.nr iX 0
.ds i1 \\$1
.nr i2 \\$2
.nr i3 \\$3
.nr i4 \\$4
.if \\n(i4=1 .nr iX \w'\f(CW00000\fP'
.br
.nf
.ft CW
.if \\n(i4=1 .nm 1 5 2
.di nG
..
.de iE
.if \\n(i4=1 .nm
.ft R
.fi
.br
.di
.nr || \\n(dnu+1v
.if \\n(||u>=\\n(.tu .bp
.ds iT "\|\|\f(CW\\*(i1\fR\|\|
.nr iG \w'\\*(iT'u
.if \\n(i4=1 .nr iL \\n(iL+\\n(iI
.if !\\n(i3=1 .br
.if !\\n(i3=1 .if !\\n(i2=1 .if (\\n(.i+\\n(.n+\\n(iG)<(\\n(.l-1.25i) .sp -.5
.if !\\n(i3=1 .DS
.if \\n(i3=1 .DF
.if !\\n(i4=1 .in +\n(iIu
.if !\\n(i2=1 \{\
.sp
\h'\\n(iLu-\n(iOu-\\n(iGu'\v'-0.075v'\\*(iT\v'0.075v'\h'-\\n(iGu'\L'-1'\l'\\n(iGu\(ul'\L'1'\}
.mk iS
.nG
.sp .15v
.mk iE
.nr iH \\n(iEu-\\n(iSu
.sp -1
\h'-\n(iOu+\\n(iXu'\L'-\\n(iHu'\l'(\\n(iLu-\\n(iXu)\(ul'\L'\\n(iHu'\l'(-\\n(iLu+\\n(iXu)\(ul'
.if !\\n(i4=1 .in -\n(iIu
.DE
.if \\n(i4=1 .nr iL \\n(iL-\\n(iI
..
.nr Cl 5
.PH ""
.PF ""
.S 24 26
.ce 3
An X* Window System Based
Network Widget:
Release 2.2
.sp
.PH "''- \\\\nP -''"
.S 16 18
.I
.ce 5
Doug Blewett
Margaret Kilduff

AT&T Bell Laboratoris
Murray Hill, New Jersey
.sp
.S 10 12
.FS *
X Toolkit (Xt) and X Window System are trademarks of the Massachusetts
Institute of Technology.
.FE
.H 1 "Introduction"
.BP xnode.ps 2.5 2.75 r 0 "" "\f3Figure \n+(Fg.\fP  A network application."
Network (i.e.  telephony) applications commonly need to display and
allow the end user to manipulate graphs.  An application, for example,
may need to display switching equipment and lines that connect this
equipment.  Such a graph can be thought of as a list of nodes and a
list of links or edges connecting those nodes.  The nodes or switches
usually have varied graphical representations.  Often the nodes are
represented by some form of icon and have a textual label.  The links
or communication lines between nodes are primarily represented by
drawing lines between the nodes.  The lines often have some gratuitous
use of color and line drawing style, for example red dotted lines.
.P
Network applications are not the only applications that require this
sort of facility.  Interactive applications based on networks or
graphs are common.  Code browsers and hypertext[1] systems often
require similar interactive graphs.  For example, a code inspection
system may wish to represent the interconnection of
.ne 29
modules or features as a directed graph.  Likewise hypertext systems
commonly use graphs to represent the information links between
concepts.
.P
This widget diverges sharply from the current activity in widget
construction which has concentrated on simple widget types such as
labels and buttons.  In an approach based on levels of detail, we have
also exposed internal data structures and low level functions from the
widget.  This allows the application developer to do limited widget
programming with a minimum of effort.  The widget also allows
applications to be constructed using arbitrary shaped graphics objects
for both nodes and links.
.P
This second release of the widget was motivated by feedback we have
gotten from application developers.  This release includes a number of
feature enhancements, bug fixes, and sample programs.
.BL
.LI
There is a new resource file interface that allows nodes and links to
be specified and manipulated using widget resources.  This is
essentially an X resource based description language for programming
nodes and links.
.LI
Node titles and symbols can now include arbitrarily shaped (and clipped)
pixmaps.  This is useful for systems that one does not usually
envision as graph based applications, for example directory browsers.
.LI
Arrows, splines, oblongs, and ellipses are now all supported directly
in the widget, rather than requiring application supplied functions.
.LI
There are a number of enhancements to the dragging and rubberbanding
operations.
.LI
We have doubled the number of examples.  One of these is a birds eye
filter that allows an application to have a miniature network control
a huge network.  This is a very useful scheme for navigating through a
large graph.  Actions in either network appear in both networks.
.LE
.P
The preferred environment for writing graphics applications is the X
.BP xnet.ps 3 3 l 0 "" "\f3Figure \n+(Fg.\fP  Directed graph applications."
window system[2] from MIT.  And in the X world the preferred way to
write applications includes three levels of programming handled by
three separate libraries.  The lowest level is the X library, which
provides a thin veneer over the X protocol.  The next level is the X
toolkit[3], Xt.  Xt hides many of the difficult interface problems and
improves performance while encouraging a C based object oriented
style.  On top of these two libraries is the arena in which most X
applications developers spend the majority of their time and effort -
the widget level.  There is one X library, one Xt library, and a dozen
or so widget libraries[4,5,6].
.P
It is clear that the ultimate widget library is yet to be designed.
Worse yet is that the majority of the work on widgets has been in the
simple widget types, for example push button style widgets.
Application writers in many cases are forced to become widget writers
because the widgets needed to write applications do not yet exist or
the current widgets are too expensive to use.  In our network example,
if each node and link in a graph is constructed using a widget, the
application will require significant space in the application process
and the X server.  One of the solutions to this problem is to
encourage widget writers to produce more complex and/or application
oriented widgets.  This is essentially the tack that we have taken
writing our network widget.  This paper is a description and a manual
for our network widget with the underlying message that widget writers
should write more complex, application oriented, widgets.
.H 1 "Widget Overview"
As stated above, the purpose of our network widget is to display
directed graphs or networks.  We conceptualize a network as a set of
points or vertices and the lines or edges that connect them.  The
points we call nodes and the edges we call links from the terms used
in the description of hypertext networks.  Nodes are composed of an
(x,y) position, a symbol, and a title.  Graphically the symbol is
often a single hieroglyph or character in an odd font centered over
the node.  The title appears to the right of the node position and is
often a symbolic name associated with the node, for example the name
of a town.  The links between nodes are most often simple lines that
are used to show some form of connectivity between nodes.
.P
Our network widget has four data structures that it takes as input
other than the usual fonts, colors, and window dressing.  The four
data structures are linked list of nodes, a linked list of links
between nodes, a linked list of polygons for the background, and an
image for the background.  All of these are optional.  An application,
for example, may specify a list of nodes and a list of polygons and
omit the list of links and the background image.
.P
Applications using the network widget tend to be differentiated in the
presentation of nodes and links.  This is as one would expect.  Each
application has its own demands in terms of the translation from
graphics object to application specific semantics.  This always
presents a problem to generic graphical tools.  How can the tool be
efficient and effective and still allow for application specific
customization?
.H 2 "Displaying Nodes and Links"
In building a general purpose widget we would like to keep the simple
things easy to do and the more complex things slightly harder to do.
The common alternative is to produce an interface for the developer
which presents all of the complexity of the system for all activities.
There are three levels of detail that the application developer may
use to specify the behavior of the network widget.  In the first
level, the 90 percent functionality level, application developers
simply create linked lists of nodes and links which are handed to the
widget in the normal Xt object oriented fashion via widget resources.
Setting up two nodes for New York and Chicago might look something
like the following:
.iS 0 1
	nodes[0].type = 0;
	nodes[0].pf.x = 0.890625;
	nodes[0].pf.y = 0.658203;
	nodes[0].title.name = "New York";
	nodes[0].symbol.name = "*";
	nodes[0].next = &nodes[1];

	nodes[1].type = 0;
	nodes[1].pf.x = 0.667969;
	nodes[1].pf.y = 0.601562;
	nodes[1].title.name = "Chicago";
	nodes[1].symbol.name = (char *) NULL;
	nodes[1].next = (netNode *) NULL;
.iE
.ce 1
.FG "Nodes for New York and Chicago."
.P
New York will have a symbol of ``*'' and Chicago will have no
graphically visible symbol.  The title associated with each town will,
of course, be the respective town name.  By default, the network
widget places the title to the right of the node position.  The symbol
.BP example1.ps 2 2 r 0 "" "\f3Figure \n+(Fg.\fP  Two node example."
is centered over the position.  This default behavior may be
overridden by doing a small amount of additional work.
.P
Notice that the coordinates are floating point numbers.  All of the
externally visible coordinates are in real world coordinates (i.e.,
the origin (0,0) of the display is in the lower left and (1,1) is in
the upper right).  The widget handles all scaling.  The network and
backgrounds are re-scaled by the widget whenever a reshape event
occurs.  Zooming in and out is handled by resetting the width and
height of the widget with the X Toolkit function XtSetvalues().
.P
The fonts and colors in which the symbols, titles, and links are
displayed are resources that are settable by the application.  There
are other resources that can be used to change the background of the
symbols and titles and other commonly used display parameters.  The
type field associated with each node controls the common interactive
and display behaviors.  The interactive attributes of the node include
whether or not it may be selected or moved.  The application may also
specify that the symbol or title is to be boxed or circled.  Boxing of
titles and symbols is useful for highlighting nodes.
.P
Links are easier to set up than nodes.  Links obtain their position
information from the nodes they interconnect.  The following four
assignment statements can be used to set up a link between the New York
and Chicago nodes that we created above.
.iS 0 1
	links[0].type = 0;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = (netLink *) NULL;
.iE
.ce 1
.FG "Link between New York and Chicago."
.P
As nodes and links are maintained as linked lists, notice that the
\f(CWnext\fP field in both examples above is used to point to
subsequent entries in the list.  The last entry in each list is always
a NULL pointer.  This linked list approach makes it easy for the
application to add and remove elements.
.H 2 "Labels and Lines: The Next Level of Detail"
The next level of detail allows the application developer to specify
parameters for specific nodes or links.  For symbols and titles
extended attributes may be specified in a netLabel structure.  The
netLabel structure allows the developer to specify attributes such as
a specific font, color, drawing function, boxing parameters, line
style, and line width.  Each symbol and each title may have an
associated netLabel structure.  The following code demonstrates the
use of the netLabel structure to augment a netNode.
.iS 0 1
	nodes[4].type = NETSYMBOLISLABEL | NETBOXTITLE;
	nodes[4].pf.x = 0.273438;
	nodes[4].pf.y = 0.515625;
	nodes[4].title.name = "Salt Lake City";

	nodes[4].symbol.label = &labels[0];
	bzero (&labels[0], sizeof (netLabel));
	labels[0].type = NETBOXSYMBOL | NETFONT | NETFOREGROUND;
	labels[0].name = "A";
	labels[0].font = "vxms-37";
	if ((labels[0].foreground = GetPixelVal (toplevel, "Sienna"))
	     == NULL)
	{
		fprintf (stderr, "Cannot allocate pixel value.\\\\n");
		exit (1);
	}
.iE
.ce 1
.FG "netLabel structure used to augment a node."
.P
The Salt Lake City node will include a title, "Salt Lake City", that
will be boxed.  The symbol for the node is specified in the netLabel
structure.  The netLabel structure is being used to specify a boxed
symbol with a specific font and foreground color.  The font we
are using is vxms-37, a large gothic font.  The color is Sienna.  The
symbol will appear as a large, boxed, ``A'' centered over the Salt
Lake City position, (0.273438, 0.515625).
.P
The link equivalent of the netLabel structure is the netLine.  It may
be used to specify an alternate color, drawing style, line width, and
line style.
.iS 0 1
	links[7].type = NETLINKISLINE;
	links[7].A = &nodes[7];
	links[7].B = &nodes[5];
	links[7].line.line = &lines[0];
	bzero (&lines[0], sizeof (netLine));
	lines[0].type = NETFOREGROUND | NETLINE_WIDTH | NETLINE_STYLE;
	lines[0].line_width = 4;
	lines[0].line_style = LineOnOffDash;
	lines[0].foreground = BlackPixel (XtDisplay (toplevel),
				 XDefaultScreen (XtDisplay (toplevel)));
.iE
.ce 1
.FG "netLine structure used to augment a Link."
.P
The preceding example modifies a link between nodes 7 and 5.  The link
will appear as a 4 pixel wide, dashed, black line.
.H 2 "Application Supplied Procedures: The Next Level of Detail"
The third level of detail allows the application developer to specify
arbitrary graphics and interactive behavior for the nodes and links.
To do this the application supplies a procedure.  The following node
example will provide the default behavior we demonstrated above at
level one for a node containing only a symbol.
.iS 0 1
	nodes[6].type = NETSYMBOLISPROC;
	nodes[6].pf.x = 0.082031;
	nodes[6].pf.y = 0.636719;
	nodes[6].application_ptr = (caddr_t) "Portland";
	nodes[6].title.name = (char *) NULL;
	nodes[6].symbol.draw_proc = symbol_draw_proc;
.iE
.ce 1
.FG "Node drawing procedure set up code."
.P
The code above sets up a node for the town of Portland.  In this case
we are going to use "Portland" as a symbol and the node will have no
title.  Notice that we are using the application_ptr field in the node
structure for pointing to the "Portland" string.  We will use this
string later in the procedure symbol_draw_proc().  We set the node up
to use the procedure by assigning the nodes[6].symbol.draw_proc to the
procedure address.
.P
.iS 0 1
netDrawProc
symbol_draw_proc (type, w, node, d, xor, clip_rect)
int type;
Widget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	node -> type &= ~(NETSYMBOLISPROC);
	node -> symbol.name = (char *) node -> application_ptr;

	switch (type)
	{
	case NETPROCINIT:
		netInitializeSymbol (w, node);
		break;

	case NETPROCSIZE:
		netSetSymbolRect (w, node);
		break;

	case NETPROCDRAW:
		netDrawSymbol (w, node, d, xor, clip_rect);
		break;

	case NETPROCPICK:
		{
		NetPickArgs *pick_args = (netPickArgs *) d;
		
		pick_args -> return_value = PtInRect (pick_args -> p,
						      &node -> s);
		break;
		}

	case NETPROCDESTROY:
		netDestroySymbol (w, node);
		break;
	}

	node -> type |= NETSYMBOLISPROC;
	node -> symbol.draw_proc = symbol_draw_proc;
}
.iE
.ce 1
.FG "Sample node drawing procedure."
.P
The application supplied function must handle the 5 cases shown above.
This can be done by ``inheriting'' the procedures as we have done
above by using functions supplied with the widget or by supplying
appropriate replacement code.  This level of detail essentially allows
the application developer to do limited widget level programming.  The
following actions must be supplied in each node procedure.
.BL
.LI
\f(CWNETPROCINIT\fP
.P
This entry is used to perform any allocation, for example arrays or
graphics contexts.
.sp
.LI
\f(CWNETPROCSIZE\fP
.P
This entry is used to set the size of the object.  The rectangle
node->s is used to determine repainting and selection behavior for
symbols.
.sp
.LI
\f(CWNETPROCDRAW\fP
.P
This is used to redraw the object.  All drawing should be within the
node->s rectangle.
.sp
.LI
\f(CWNETPROCPICK\fP
.P
This entry handles selection.  The arguments and return value are
passed through the netPickArgs structure.  The widget packages
includes functions for manipulating points and rectangles.  PtInRect()
is one of the supplied functions.
.sp
.LI
\f(CWNETPROCDESTROY\fP
.P
This entry is used to perform any de-allocation that may be required.
All memory that was allocated for the object should be freed here.
.LE
.P
To change the function above to draw symbols that are enclosed in an
ellipse (adding NETELLIPSESYMBOL to the type field will do this with
builtin routines) we would have to change the drawing entry to
something like the following:
.iS 0 1
	case NETPROCDRAW:
		/* set clip rect in the GC */

		XDrawArc (XtDisplay (w), d,
			  xor ? xor_gc : gc,
			  node -> s.x, node -> s.y,
			  node -> s.width - 1, node -> s.height - 1,
			  0, 360 * 64);

		netDrawSymbol (w, node, d, xor, clip_rect);

		/* unset clip rect in the GC */
		break;
.iE
.ce 1
.FG "Elliptical symbol drawing procedure."
.P
This entry requires that we create two graphics contexts in the
initialization entry and we probably also want to increase the size of
the enclosing rectangle in the NETPROCSIZE entry.
.H 2 "Widget Backgrounds"
The background is often as important as the network drawn upon it.
The network widget supports two types of background graphics.  The
first that is painted is provided by an optional X image.  Images are
a good choice for backgrounds as they can be repainted quickly and
they can include detail that would be too tedious and/or time
consuming to produce from other graphics operations.  We commonly use
maps that have been scanned.  If the widget dimensions do not match
the image dimensions the image will be sampled to produce an image of
the correct dimensions.  We have a new, portable, high speed sampling
routine.  This routine can be accessed from the application code if
required.
.P
The second type of background is provided by a list of polygons.  The
polygons used by our network widget consist of simply an array of
points and a named color, such as ``red.''  Polygons are an attractive
alternative to a background image in terms of memory consumption and
in terms of data that must be transmitted to the X server.
.H 1 "A Detailed Look at the Widget"
The rest of this paper concentrates on the application programmers
interface to the widget.  We first discuss the X Toolkit resources
that the network widget contains.  Most developers will only need the
resource level description.  Following the resource description of the
widget, we will discuss the visible data structures and then the
application accessible functions.
.H 2 "Xt Translations and Resources"
The behavior of a widget is determined by two data structures: the
widget's default translation table and the widget's resource lists.
The default translation table gives a good glimpse at the sort of
functionality the widget provides to the application in response to
events.  The default translation may be modified by the application.
The widget resource list contains the parameters available for
modification by the application.  Arguments to widgets are passed in
via the resource access mechanisms.
.P
The default translation for the network widget is as follows:
.TS
center box, tab(;);
lB lB.
Event;Action
_
.T&
l l.

<EnterWindow>;enter()
<LeaveWindow>;leave()
<Btn1Down>;netaction(point)
<Btn1Motion>;netaction(drag)
<Btn1Up>;netaction(update)
<Btn2Down>;netaction(point)
<Btn2Motion>;netaction(rubberband)
<Btn2Up>;netaction(update)
<Btn3Down>;netaction(point)
<Btn3Motion>;netaction(expensiverubberband)
<Btn3Up>;netaction(update)

.TE
.ce 1
.TB "Network widget default translation table."
.P
Note that the selection of objects, links or nodes, is handled by
pointing.  The drag and rubberband actions are different styles used
for moving nodes.
.P
.ne 40
The following table contains the new resources the network widget
introduces above the common ones found in the core widget.
.S -2 -2
.TS
center box, tab(;);
lB lB lB lB.
Name;Type;Default;Description
_
.T&
lB l l l.

XtNnetSymbolForeground;Pixel;"black";foreground color for symbols
XtNnetTitleForeground;Pixel;"black";foreground color for titles
XtNnetLinkForeground;Pixel;"black";foreground color for links

XtNnetSymbolFont;XFontStruct *;"fixed";font for symbols
XtNnetTitleFont;XFontStruct *;"fixed";font for titles

XtNnetProcPoint;Pointer;NULL;Callback on button down
XtNnetProcDrag;Pointer;NULL;Callback on button movement
XtNnetProcUpdate;Pointer;NULL;Callback on button release

XtNnetNodeList;Pointer;NULL;linked list of Nodes
XtNnetLinkList;Pointer;NULL;linked list of Links
XtNnetMapPolygons;Pointer;NULL;linked list of Mappolygons
XtNnetPolygonsAsLines;Boolean;False;draw lines not polygons
XtNnetImage;XImage *;NULL;image for the widget background

XtNnetTitleHorizSpace;Integer;3;horizontal space for boxed titles
XtNnetTitleVertSpace;Integer;3;vertical space for boxed titles
XtNnetSymbolHorizSpace;Integer;3;horizontal space for boxed symbols
XtNnetSymbolVertSpace;Integer;3;vertical space for boxed symbols

XtNnetTitleBackgroundPixmap;Pixmap;NULL;Pixmap for filled titles
XtNnetDrawTitleBackground;Boolean;False;draw title backgrounds
XtNnetSymbolBackgroundPixmap;Pixmap;NULL;Pixmap for filled symbols
XtNnetDrawSymbolBackground;Boolean;False;draw symbol backgrounds

XtNnetDoUpdates;Boolean;True;keep the network upto date

XtNnetAllNodes;Pointer;NULL;Nodes currently in use
XtNnetAllLinks;Pointer;NULL;Links currently in use

XtNnetApplicationPtr;Pointer;NULL;Pointer for application use

XtNnetAddNodes;Pointer;NULL;add nodes via resources
XtNnetRemoveNodes;Pointer;NULL;remove nodes via resources
XtNnetUpdateNodes;Pointer;NULL;update nodes via resources

XtNnetAddLinks;Pointer;NULL;add links via resources
XtNnetRemoveLinks;Pointer;NULL;remove links via resources
XtNnetUpdateLinks;Pointer;NULL;update links via resources

XtNnetSelectionType;Integer;NULL;selection action type
XtNnetDataType;Integer;NULL;node or link
XtNnetSelectedNode;netNode *;NULL;selected node
XtNnetSelectedLink;netLink *;NULL;selected link
XtNnetMouseX;Integer;NULL;mouse X position
XtNnetMouseY;Integer;NULL;mouse Y position
XtNnetOldX;Float;NULL;node's previous X
XtNnetOldY;Float;NULL;node's previous Y

.TE
.S +2 +2
.ce 1
.TB "Network widget resources."
.P
The callbacks, Point, Drag, and Update, implement a simple model to
handle button down, movement, and button up mouse events.  The data
structure handed back to the application includes the type of object
selected and the specific object instance (i.e., pointer to a link or
a node).  See the discussion under data structures on netCallbackData.
.P
The resources for adding, updating, and removing nodes and links act
essentially as subroutine calls when they are set.  See the discussion
on the function \f(CWnetResourcesInitialize()\fP below in section 3.4.
.H 2 "Data Structures"
In this section we will discuss the data structures used by the
network widget.  Two data structures, the netNode and the netLink,
account for the majority of the application supplied data activity.
The netLabel and the netLine data structures are optionally used to
further parameterize netNode's and netLink's.  netXSRectangle, a
signed rectangle, and netXFPoint, a floating point point or position,
are included in the netNode structure.  XImage, the Xlib defined
client side data structure, and the netMapPolygon are used for
creating network backgrounds.  netPickArgs is a data structure used in
application supplied extension routines.  And Finally netCallbackData
is a data structure handed to all callback routines.  This section
will cover these structures in the order listed here.
.H 3 "netNodes"
In our system, networks are composed of nodes and links.  A node is a
position with an associated title and symbol.  The following figure
contains the netNode structure.
.iS 0 1
typedef struct netNode
{
	/* flags */
	unsigned long type;

	/* position in real world space */
	netXFPoint pf;

	/* title */
	union
	{
		char *name;
		netLabel *label;
		netDrawProc (*draw_proc) ();
	} title;

	/* symbol */
	union
	{
		char *name;
		netLabel *label;
		netDrawProc (*draw_proc) ();
	} symbol;

	/* pointer for application use */
	caddr_t application_ptr;

	/* extension fields */
	XPoint p;
	netXSRectangle t;
	netXSRectangle s;
	short t_width;
	short s_width;

	/* the next element of the list */
	struct netNode *next;
} netNode;
.iE
.ce 1
.FG "The netNode data structure."
.P
.BL
.LI
\f(CWtype\fP is used to select options for display and selection
behavior of the node.  The type field may include any combination of
the following mask bits:
.BL
.LI
\f(CWNETBOXTITLE\fP and \f(CWNETBOXSYMBOL\fP \(en enclose the title or
symbol with a bounding box.  \f(CWNETELLIPSETITLE\fP,
\f(CWNETCIRCLETITLE\fP, \f(CWNETOBLONGTITLE\fP,
\f(CWNETELLIPSESYMBOL\fP, \f(CWNETCIRCLESYMBOL\fP, and
\f(CWNETOBLONGSYMBOL\fP enclose the title or symbol with the
specified shape.
.LI
\f(CWNETUNCONSTRAINED\fP \(en the node may be moved out of the widget's
window.
.LI
\f(CWNETUNMOVEABLE\fP \(en the node may not be moved.
.LI
\f(CWNETUNTOUCHABLE\fP \(en do not allow the node to be selected.
.LI
\f(CWNETTITLEISLABEL\fP and \f(CWNETSYMBOLISLABEL\fP \(en a netLabel
structure is supplied for the specified element.
.LI
\f(CWNETTITLEISPROC\fP and \f(CWNETSYMBOLISPROC\fP \(en an extension
procedure is supplied for the specified element.
.LE
.LI
\f(CWpf\fP is the position of the node supplied in real world
coordinates.
.LI
\f(CWtitle\fP and \f(CWsymbol unions\fP are elements to define the
representation of the indicated title or symbol.  Obviously, only one
element of the union may be supplied.  The \f(CWname\fP field is used
to supply a character string, the \f(CWlabel\fP field is used to
supply a \f(CWnetLabel\fP structure, and the \f(CWdraw_proc\fP field is
used to supply a procedure.
.LI
\f(CWapplication_ptr\fP is an extra pointer that may be used by the
application to store data associated with the node.
.LI
The \f(CWextension fields\fP contain data that are used internally by
the widget and are available for applications that write extension
procedures.
.LI
\f(CWnext\fP \(en the pointer to the next netNode or NULL.
.LE
.H 3 "netLinks"
netLinks are the elements that connect nodes in a network.  netLinks
have the following structure:
.iS 0 1
typedef struct netLink
{
	/* flags */
	unsigned long type;

	/* end points */
	netNode *A;
	netNode *B;

	/* line */
	union
	{
		netLine *line;
		netDrawProc (*draw_proc) ();
	} line;

	/* pointer for application use */
	caddr_t application_ptr;

	/* extension fields */
	netXSRectangle l;

	/* cache arrow heads */
	XPoint arrowA[3];
	XPoint arrowB[3];

	/* the next element of the list */
	struct netLink *next;
} netLink;
.iE
.ce 1
.FG "The netLink data structure."
.P
.BL
.LI
\f(CWtype\fP is used to select options for display and selection
behavior of the link.  The type field may include any combination of
the following mask bits:
.BL
.LI
\f(CWNETARROWALINK\fP and \f(CWNETARROWBLINK\fP \(en arrow heads are
placed at A and/or B ends of the netLink.
.LI
\f(CWNETSPLINELINK\fP \(en the link will be drawn as a spline.
.LI
\f(CWNETUNTOUCHABLE\fP \(en do not allow the link to be selected.
.LI
\f(CWNETLINKISLINE\fP \(en a netLine structure is supplied for the
link.
.LI
\f(CWNETLINKISPROC\fP \(en an extension procedure is supplied for
the link.
.LE
.P
.LI
\f(CWnetNode *A, *B\fP \(en these are the node endpoints for the link.
.LI
\f(CWline union\fP is used to define the representation of the link.
Obviously, only one element of the union may be supplied or the union
may be ignored.  The \f(CWline\fP field is used to supply a
\f(CWLine\fP structure, and the \f(CWdraw_proc\fP field is used to
supply a procedure.
.LI
\f(CWapplication_ptr\fP is an extra pointer that may be used by the
application to store data associated with the link.
.LI
The \f(CWextension fields\fP contain data that are used internally by
the widget and is available for applications that write extension
procedures.
.LI
\f(CWnext\fP \(en the pointer to the next netLink or NULL.
.LE
.H 3 "netLabels"
netLabels are used to further parameterize the display of titles and
symbols.  The netLabel is somewhat like the XGCValues structure used
to create graphics contexts in X.  netLabels should be cleared using
memclr() or bzero() before they are used.
.iS 0 1
typedef struct
{
	/* flags */
	unsigned long type;

	/* string to be displayed */
	char *name;

	/* GC related values */
	int graphics_function;
	Pixel foreground;
	int line_width;
	int line_style;
	char *font;

	/* display modifiers */
	int box_hspace;
	int box_vspace;
	Pixmap box_background;
	Pixmap pixmap;
	Pixmap pixmap_mask;

	/* private */
	netXSRectangle pixmap_rect;
	netXSRectangle string_rect;
	XFontStruct *font_struct;
	XCharStruct string_size;
	GC gc;
	GC background_gc;
	GC xor_gc;
} netLabel;
.iE
.ce 1
.FG "The netLabel data structure."
.P
.BL
.LI
\f(CWtype\fP is used to enable the display parameters from within the
netLabel structure.  \f(CWtype\fP may assume the following values:
.BL
.LI
\f(CWNETBOXTITLE\fP and \f(CWNETBOXSYMBOL\fP \(en enclose the title or
symbol with a bounding box.  \f(CWNETELLIPSETITLE\fP,
\f(CWNETCIRCLETITLE\fP, \f(CWNETOBLONGTITLE\fP,
\f(CWNETELLIPSESYMBOL\fP, \f(CWNETCIRCLESYMBOL\fP, and
\f(CWNETOBLONGSYMBOL\fP enclose the title or symbol with the specified
shape.
.LI
\f(CWNETGRAPHICS_FUNCTION\fP \(en the graphics function, for example
GXinvert, is used to draw the title or symbol has been supplied.
.LI
\f(CWNETFOREGROUND\fP \(en the foreground pixel color has been
supplied.
.LI
\f(CWNETLINE_WIDTH\fP \(en the line drawing width has been supplied.
This will affect boxes drawn around boxed titles and symbols.
.LI
\f(CWNETLINE_STYLE\fP \(en the line drawing style, for example
LineOnOffDash, has been supplied.  This will affect boxes drawn around
boxed titles and symbols.
.LI
\f(CWNETFONT\fP \(en a font name has been supplied.  The network
handles loading the font.  The title or symbol will be written using
this font.
.LI
\f(CWNETBOXHSPACE\fP and \f(CWNETBOXVSPACE\fP \(en these specify the
horizontal and vertical space to be added around boxed titles and
symbols.
.LI
\f(CWNETBGSUPPLIED\fP \(en a background pixmap has been supplied.
.LI
\f(CWNETPIXMAP\fP \(en a pixmap has been supplied.  If the pixmap_mask
is not NULL, then it will be used as the mask for displaying the
pixmap.
.LE
.P
.LI
\f(CWname\fP \(en this string is the text to be displayed for the
title or symbol.
.LI
\f(CWgraphics_function\fP \(en the graphics function to be
used to draw the title or symbol.
.LI
\f(CWforeground\fP \(en the foreground pixel color to be used
to draw the title or symbol.
.LI
\f(CWline_width\fP \(en the line width to be used for boxing
the title or symbol.
.LI
\f(CWline_style\fP \(en the line style to be used for the
lines used to box the title or symbol.
.LI
\f(CWfont\fP \(en the name of the font, for example "fixed",
to be used to print the symbol or title name string.
.LI
\f(CWbox_hspace\fP and \f(CWbox_vspace\fP \(en these are the
horizontal and vertical padding values for boxed titles and symbols.
.LI
\f(CWbox_background\fP \(en a pixmap to be used for filling
the background for symbols and titles.
.LI
\f(CWpixmap\fP and \f(CWpixmap_mask\fP \(en this pixmap will be used
as the figure for the title or symbol.  If the \f(CWpixmap_mask\fP is
not NULL, then it will be used as the mask for displaying the pixmap.
.LI
\f(CWprivate data\fP \(en this data includes font and graphics context
data used for displaying the title or symbol.  The network widget
handles allocating and deallocating this data.
.LE
.H 3 "netLines"
Lines are used to further parameterize the display of links.  The
netLine is somewhat like the XGCValues structure used to create
graphics contexts in X.  netLines should be cleared using memclr() or
bzero() before they are used.
.iS 0 1
typedef struct
{
	/* flags */
	unsigned long type;

	/* GC related values */
	int graphics_function;
	Pixel foreground;
	int line_width;
	int line_style;

	/* spline points */
	netXFPoint *spline_points;

	/* private */
	GC gc;
	GC xor_gc;
	XPoint *_spline_points;
	int _spline_count;
} Line;
.iE
.ce 1
.FG "The netLine data structure."
.P
.BL
.LI
\f(CWtype\fP is used to enable the display parameters from within the
netLine structure.  \f(CWtype\fP may assume the following values:
.BL
.LI
\f(CWNETARROWALINK\fP and \f(CWNETARROWBLINK\fP \(en arrow heads are
placed at A and/or B ends of the netLink.
.LI
\f(CWNETSPLINELINK\fP \(en the link will be drawn as a spline.
.LI
\f(CWNETSPLINEPOINTS\fP \(en the spline points array will be used for
generating the spline.
.LI
\f(CWNETGRAPHICS_FUNCTION\fP \(en the graphics function, for example
GXinvert, used to draw the link.
.LI
\f(CWNETFOREGROUND\fP \(en the foreground pixel color has been
supplied.
.LI
\f(CWNETLINE_WIDTH\fP \(en the line drawing width has been supplied.
.LI
\f(CWNETLINE_STYLE\fP \(en the line drawing style, for example
LineOnOffDash, has been supplied.
.LE
.P
.LI
\f(CWgraphics_function\fP \(en the graphics function to be
used to draw the link.
.LI
\f(CWforeground\fP \(en the foreground pixel color to be used
to draw the link.
.LI
\f(CWline_width\fP \(en the line width to be used for boxing
the link.
.LI
\f(CWline_style\fP \(en the line style to be used for the
lines used to box the link.
.LI
\f(CWspline_points\fP \(en an array of points for drawing a spline.
This array must be terminated by the point (-999.0, -999.0).  The
points are in the same unit coordinate space as the node positions.
The first and the last points are usually the node A and node B
positions.
.LI
\f(CWprivate data\fP \(en this data includes graphics contexts used
for displaying the link.  The network widget handles allocating and
deallocating this data.
.LE
.H 3 "netXSRectangles"
The netXSRectangle structure is similar to the standard X rectangle
except that the width and height are signed shorts.  This is a coding
convenience for use with signed arithmetic.
.iS 0 1
typedef struct
{
	short x;
	short y;
	short width;
	short height;
} netXSRectangle;
.iE
.ce 1
.FG "The netXSRectangle data structure."
.H 3 "netXFPoints"
The netXFPoint structure is used to store a position specified in
floating point values.
.iS 0 1
typedef struct
{
	float x;
	float y;
} netXFPoint;
.iE
.ce 1
.FG "The netXFPoint data structure."
.P
The \f(CWx\fP and \f(CWy\fP values are in real world coordinates.  This
is a coordinate system where (0,0) is in the lower left corner and
(1,1) is in the upper right corner.
.H 3 "netMapPolygons"
netMapPolygons are used for drawing the widget background.  The
netMapPolygons are set up as a NULL terminated linked list.  There is
a default disk format that may be invoked by running the String to
netMapPolygon converter.
.iS 0 1
typedef struct netMapPolygon
{
	/* polygon color and points */
	char *color;
	netXFPoint *points;
	int npoints;

	/* the next element of the list */
	struct netMapPolygon *next;

	/* private */
	GC gc;
	XPoint *p;
	netXSRectangle r;
} netMapPolygon;
.iE
.ce 1
.FG "The netMapPolygon data structure."
.BL
.LI
\f(CWcolor\fP \(en a string containing a color name, for
example "red".
.LI
\f(CWpoints\fP \(en the array of points that describes the
polygon.
.LI
\f(CWnpoints\fP \(en the length of the \f(CWpoints\fP array.
.LI
\f(CWnext\fP \(en the pointer to the next polygon or NULL.
.LI
\f(CWprivate data\fP \(en this data includes graphics contexts, an
array of scaled points, and the polygons bounding rectangle.  The
network widget handles allocating and deallocating this data.
.H 3 "netPickArgs"
netPickArgs is a structure used to pass data to and from an
application supplied drawing procedure.
.iS 0 1
typedef struct
{
	XPoint *p;
	int return_value;
} netPickArgs;
.iE
.ce 1
.FG "The netPickArgs data structure."
.P
It includes the point where the mouse button was pressed and includes
an integer used as a boolean.  The boolean flags whether or not the
current node is under the specified point.
.H 3 "netCallbackData"
netCallbackData is a structure passed into all network widget Callback
routines.  It contains the information necessary for the Callback
routine to respond to activity within the widget.
.iS 0 1
typedef struct
{
	int selection_type;
	int data_type;
	netNode *selected_node;
	netLink *selected_link;
	int mouse_x;
	int mouse_y;
	float old_x;
	float old_y;
	netNode *nodes;
	netLink *links;
} netCallbackData;
.iE
.ce 1
.FG "The netCallbackData data structure."
.P
.BL
.LI
\f(CWselection_type\fP \(en this integer specifies the type of action
that has occurred.  \f(CWselection_type\fP may assume four values,
\f(CWNETSELECTED\fP (AKA point), \f(CWNETDRAGGED\fP,
\f(CWNETRUBBERBAND\fP, and \f(CWNETUPDATED\fP.
.LI
\f(CWdata_type\fP \(en this integer specifies the type of object that
has been selected.  \f(CWdata_type\fP may assume four values
\f(CWNETTITLE\fP, \f(CWNETSYMBOL\fP, \f(CWNETLINK\fP, and NULL.
.LI
\f(CWselected_node\fP \(en a pointer to the selected node if
any.
.LI
\f(CWselected_link\fP \(en a pointer to the selected link if
any.
.LI
\f(CWmouse_x\fP \(en the scaled current position of the mouse's X
coordinate.
.LI
\f(CWmouse_y\fP \(en the scaled current position of the mouse's Y
coordinate.
.LI
\f(CWold_x\fP \(en the unscaled previous position of the mouse's X
coordinate.
.LI
\f(CWold_y\fP \(en the unscaled previous position of the mouse's Y
coordinate.
.LI
\f(CWnodes\fP \(en the linked list of nodes currently being used by
the widget.
.LI
\f(CWlinks\fP \(en the linked list of links currently being used by
the widget.
.LE
.H 2 "Application Accessible Routines"
The network widget has a large number of application accessible
routines.  These routines can be loosely described as belonging to one
of three groups.  The first group is for managing the lists of active
nodes and links.  This group allows the application to freely alter
the nodes and links and add and remove objects from these lists.  This
first group of routines are commonly used from Callback routines.
.P
The second group of routines are best described as general purpose
utilities.  These routines help the application to efficiently handle
points and rectangles.  There is also some minimal support for X
images for the widget background.
.P
The last group of routines is provided for developers who wish to
write extension routines.  Extension routines, as we mentioned in the
overview, allow the application developer to do limited widget
programming, specifically display and selection of nodes and links.
These routines allow the application to use arbitrary graphics for
nodes and links and allow the selection of nodes and links to go
beyond simple shapes.  This group of routines is fairly large as it
covers most of the internal routines for maintaining nodes and links.
.H 3 "Adding, Removing, and Updating Active Links and Nodes"
This group of routines is for manipulating active nodes and links.
There are three operations supported here: add, remove, and update.
Update allows the application to change all of the parameters
associated with an active element.  There are two objects upon which
these operations are applied, links and nodes.  This essentially
provides a three by two table of operations by objects.  Each of the
operations is performed as an atomic operation for the widget.  That
is, there is no coalescing of operations.  The widget is always in
step with the state of the objects as specified by the application.
For performance, some applications may wish to apply some operations
on more than one object at a time.  For this reason all of the six
cells of the operation by object table has a plural and singular form.
.P
.iS netAddLink[s] 0
void
netAddLink (w, new_link, add_type, previous_link)
NetWidget w;
netLink *new_link;
int add_type;
netLink *previous_link;

void
netAddLinks (w, count, new_links, add_types, previous_links)
NetWidget w;
int count;
netLink *new_links[];
int add_types[];
netLink *previous_links[];
.iE
These functions allow the application to add new links to the widgets
linked list of active netLinks.  \f(CWadd_type\fP specifies where in the
list the new links are to be added.  \f(CWadd_type\fP must be one of
the following values:
.BL
.LI
\f(CWNETADDFIRST\fP \(en add the element as the first item of the
list.
.LI
\f(CWNETADDLAST\fP \(en add the element as the last element of the
list.
.LI
\f(CWNETADDPREVIOUS\fP \(en add the element after the
\f(CWprevious_link\fP.
.LE
.P
Selection of links is based on their order in the list.  Links at the
front of the list have precedence over links at the end of the list.
.P
.iS netAddNode[s] 0
void
netAddNode (w, new_node, add_type, previous_node)
NetWidget w;
netNode *new_node;
int add_type;
netNode *previous_node;

void
netAddNodes (w, count, new_nodes, add_types, previous_nodes)
NetWidget w;
int count;
netNode *new_nodes[];
int add_types[];
netNode *previous_nodes[];
.iE
These functions allow the application to add new nodes to the widgets
linked list of active netNodes.  As in \f(CWnetAddLink[s]\fP
\f(CWadd_type\fP specifies where in the list the new nodes are to be
added.  Nodes at the front of the list are displayed first.  As nodes
have depth, subsequent nodes appear in front of prior nodes in the
list.  Selection of nodes is based on which node is visible at the
selection location (i.e., which node is on top where on top is
equivalent to later in the list).
.P
.iS netRemoveLink[s] 0
void
netRemoveLink (w, old_link)
NetWidget w;
netLink *old_link;

void
netRemoveLinks (w, count, old_links)
NetWidget w;
int count;
netLink *old_links[];
.iE
These functions allow the application to remove active links.
.P
.iS netRemoveNode[s] 0
void
netRemoveNode (w, old_node)
NetWidget w;
netNode *old_node;

void
netRemoveNodes (w, count, old_nodes)
NetWidget w;
int count;
netNode *old_nodes[];
.iE
These functions allow the application to remove active nodes.
.P
.iS netUpdateLink[s] 0
void
netUpdateLink (w, new_link, src_link)
NetWidget w;
netLink *new_link;
netLink *src_link;

void
netUpdateLinks (w, count, new_links, src_link_ptrs)
NetWidget w;
int count;
netLink new_links[];
netLink **src_link_ptrs;

void
netUpdateLinkPtrs (w, count, new_links, src_link_ptrs)
NetWidget w;
int count;
netLink **new_links;
netLink **src_link_ptrs;
.iE
These functions allow the application to update active links.  This is
a common practice in applications which wish to highlight or color
links in response to some external events, such as mouse behavior or
database activity.
.P
.iS netUpdateNode[s] 0
void
netUpdateNode (w, new_node, src_node)
NetWidget w;
netNode *new_node;
netNode *src_node;

void
netUpdateNodes (w, count, new_nodes, src_nodes)
NetWidget w;
netNode new_nodes[];
netNode **src_nodes;

void
netUpdateNodePtrs (w, count, new_nodes, src_nodes)
NetWidget w;
int count;
netNode **new_nodes;
netNode **src_nodes;
.iE
These functions allow the application to update active nodes.  This is
a common practice in applications which wish to highlight or color
nodes in response to some external events, such as mouse behavior or
database activity.
.P
.H 3 "General Purpose Rectangle, Image, and Pixmap Support"
.iS PtInRect 0
int
PtInRect (p, r)
XPoint *p;
netXSRectangle *r;
.iE
This function returns \f(CWTRUE\fP when the point is included within
the bounds of the specified rectangle.
.P
.iS RectXRect 0
int
RectXRect (r, s)
netXSRectangle *r;
netXSRectangle *s;
.iE
This function returns \f(CWTRUE\fP when the rectangles intersect.
.P
.iS RectInRect 0
int
RectInRect (r, s)
netXSRectangle *r;
netXSRectangle *s;
.iE
This function returns \f(CWTRUE\fP when rectangle \f(CWr\fP is
included within rectangle \f(CWs\fP.
.P
.iS MergeRects 0
netXSRectangle *
MergeRects (r, s)
netXSRectangle *r;
netXSRectangle *s;
.iE
This function merges rectangle \f(CWs\fP into rectangle \f(CWr\fP.
The resulting rectangle encompasses both the old \f(CWr\fP and
\f(CWs\fP rectangles.  \f(CWr\fP is returned.
.P
.iS MergeRectPt 0
netXSRectangle *
MergeRectPt (r, p)
netXSRectangle *r;
XPoint *p;
.iE
This function merges point \f(CWp\fP into rectangle \f(CWr\fP.  The
resulting rectangle encompasses both the old rectangle \f(CWr\fP and
point \f(CWp\fP.  \f(CWr\fP is returned.
.P
.iS SampleImage 0
void
SampleImage (in, out)
XImage *in;
XImage *out;
.iE
This function copies the image \f(CWin\fP to the image \f(CWout\fP.
The resulting image is scaled up or down to the size of image
\f(CWin\fP.  Scaling is performed via a sampling algorithm.
.P
.iS netCreateImage 0
XImage *
netCreateImage (display, out_width, out_height)
Display *display;
int out_width;
int out_height;
.iE
This function creates an image of the given width and height that
matches the parameters of the specified display.
.P
.iS XwCreateTile 0
Pixmap
XwCreateTile (screen, foreground, background, tileType)
Screen *screen;
Pixel foreground;
Pixel background;
int tileType;
.iE
This is a function from the HP widget set as it was donated to the X
consortium for X11 release 3.  The routine creates and caches pixmaps
that are useful as background textures for nodes.  \f(CWtileType\fP
must be one of the following values:
.BL
.LI
\f(CWXwFOREGROUND\fP \(en the pixmap will be filled solid using the
foreground color.
.LI
\f(CWXwBACKGROUND\fP \(en the pixmap will be filled solid using the
background color.
.LI
\f(CWXw25_FOREGROUND\fP, \f(CWXw50_FOREGROUND\fP,
\f(CWXw75_FOREGROUND\fP \(en the pixmap will be filled the specified
percentage using the foreground color.
.LI
\f(CWXwVERTICAL_TILE\fP, \f(CWXwHORIZONTAL_TILE\fP,
\f(CWXwSLANT_RIGHT\fP, \f(CWXwSLANT_LEFT\fP \(en the pixmap will be
filled with the specified striped pattern.
.LI
\f(CWXwDITHER\fIN\fP\fP \(en the pixmap will be a dithered pattern.
\fIN\fP is a number between 0 and 256 inclusive.
.LE
.H 3 "Extension Support"
The functions in this section are supplied to help application
developers write extension procedures as described in section 2.3.
These functions are from the third level of detail in the widget and
allow the application developer to specify arbitrary graphics and
interactive behavior for the nodes and links.  To do this the
application supplies a procedure that handles the fiive requests or
messages to the link or node: initialize, size, draw, select, and
destroy.  The following five sections describe the default routines
provided with the widget.
.H 4 "Initialization Routines"
.iS "netInitializeLink netInitializeSymbol netInitializeTitle" 0
void
netInitializeLink (w, link)
NetWidget w;
netLink *link;

void
netInitializeSymbol (w, node)
NetWidget w;
netNode *node;

void
netInitializeTitle (w, node)
NetWidget w;
netNode *node;
.iE
These routines handle node and link initial data allocation and
initialization.  This may include the allocation of X related
structures such as graphics contexts.
.br
.H 4 "Size Routines"
.iS "netSetLinkRect netSetLinkRect netSetSymbolRect" 0
void
netSetLinkRect (w, link)
NetWidget w;
netLink *link;

void
netSetSymbolRect (w, node)
NetWidget w;
netNode *node;

void
netSetTitleRect (w, node)
NetWidget w;
netNode *node;
.iE
These routines set node and link rectangles.  These rectangles are
used for selection and update requests.  These routines do not
allocate data.
.H 4 "Draw Routines"
.iS "netDrawLink netDrawSymbol netDrawTitle" 0
void
netDrawLink (w, link, d, xor, clip_rect)
NetWidget w;
netLink *link;
Drawable d;
int xor;
netXSRectangle *clip_rect;

void
netDrawSymbol (w, node, d, xor, clip_rect)
NetWidget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;

void
netDrawTitle (w, node, d, xor, clip_rect)
NetWidget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
.iE
These routines may be used to generate the graphics associated with
the links and nodes.  The specified object is drawn within the
specified widget context on the given drawable.  The drawable is
usually the widget window.  When the flag \f(CWxor\fP is true the
drawing will be done in \f(CWGXxor\fP or \f(CWGXinvert\fP mode.  If
the clipping rectangle is non-NULL, then all graphics operations will
be clipped to the specified rectangle.  A clipping rectangle is
constructed by the widget when a small part of the network is to be
updated.  \f(CWxor\fP mode is used to flash selected nodes and links
and when objects are moved interactively.
.H 4 "Pick Routines"
.iS netPickLink 0
int
netPickLink (w, link, x, y)
NetWidget w;
netLink *link;
int x, y;
.iE
This function returns TRUE if the position (x, y) is within the
widgets definition of ``close'' with respect to the specified link.
This routine allows application supplied links to use a definition of
``close'' consistent with the built-in link support.
.P
.iS "netPickLinks netPickTitles netPickSymbols netPickTitlesAndSymbols" 0
netLink *
netPickLinks (w, x, y)
NetWidget w;
int x, y;

netNode *
netPickTitles (w, x, y)
NetWidget w;
int x, y;

netNode *
netPickSymbols (w, x, y)
NetWidget w;
int x, y;

void
netPickTitlesAndSymbols (w, x, y, return_type, return_node)
NetWidget w;
register int x, y;
int *return_type;
netNode **return_node;

.iE
These routines are used by the widget to select a link or node from a
mouse position within the widget window.  The routines return a
pointer to the selected object or NULL if no object is found at that
position.
.H 4 "Destroy Routines"
Routines in this group are used to deallocate space created by the
widget.
.iS "netDestroyLink netDestroySymbol netDestroyTitle" 0
void
netDestroyLink (w, link)
NetWidget w;
netLink *link;

void
netDestroySymbol (w, node)
NetWidget w;
netNode *node;

void
netDestroyTitle (w, node)
NetWidget w;
netNode *node;
.iE
These routines free all data associated with nodes and links including
the X related structures such as graphics contexts.
.iS "netDestroyLabel netDestroyLine" 0
void
netDestroyLabel (w, label)
NetWidget w;
netLabel *label;

void
netDestroyLine (w, line)
NetWidget w;
netLine *line;
.iE
These routines free all data associated with node and link augmenting
structures, netLines and netLabels.  Destroying the associated node or
link will cause these routines to be called appropriately.
.iS "netDestroyMap netDestroyPolygon" 0
void
netDestroyMap (w)
NetWidget w;

void
netDestroyPolygon (w, mpi)
NetWidget w;
netMapPolygon *mpi;
.iE
These routines are used to free the storage associated with the widget
background.  \f(CWnetDestroyMap\fP will deallocate the list of
polygons.  \f(CWnetDestroyPolygon\fP can be used to free the memory
associated with one polygon.  XImages may be freed using
\f(CWXDestroyImage\fP.
.H 2 "The X Resource Interface to the Network Widget"
Creating nodes and links by hand in C can be a time consuming
activity.  One would like to be able to specify these data structures
in a form that is as convenient and simple as X resources: essentially
a network description language based on the X resource syntax.  We
implemented this interface by adding resources to the widget and a set
of type converters.  The type converters convert strings to netNode
and netLink structures by searching the per process X resource
database.  This mechanism is installed in an Xt based application by
running the function \f(CWnetResourcesInitialize()\fP.
.H 3 "Converting Resources into Nodes and Links"
Using the \f(CWnetResourcesInitialize()\fP mechanism, the following X
resource code can be used to describe three nodes:
.iS 0 1
    a.x: .5
    a.y: .5
    a.titleName: first title

    b.type: circlesymbol
    b.x: .6
    b.y: .6
    b.titleName: next title
    b.symbolName: *

    c.x: .7
    c.y: .7
    c.titleName: last title
.iE
.ce 1
.FG "An X Resource Description of Three Nodes."
.P
Node \f(CWa\fP is a node at (0.5, 0.5) with no symbol and the title,
``first\ title''.  Notice that the type flag and the symbol name
retrieved from the database are NULL as no values were specified for
these items.  Node \f(CWb\fP is a node at (0.6, 0.6) with the symbol
``*'' and the title, ``next\ title''.
.P
Default fields can be specified using the resource database wild
carding operator, \f(CW*\fP.  For example, \f(CW*symboName:\ X\fP
would set all of the un-assigned symbol names to \f(CWX\fP.
Specifically setting the symbol, with
\f(CWnode_name.symbolName:\ string\fP would override the default setting.
.P
Once the data defining the links and nodes is in the resource
database, the application needs a way of naming and/or specifying
links and nodes within a string.  Strings are used as arguments for
widget operations (e.g. adding or updating a list of nodes).  There
are three ways to specify a list of nodes or links.
.P
.iS 0 1

    a b c

    file: file-name

    resource: resource-name

.iE
.ce 1
.FG "Three Methods for Specifying Links and Nodes."
.P
The first method is a simple white space separated list of resources
names.  Each name is extracted from the list and looked up in the
resource database.  If the string has the prefix \f(CWfile:\fP, then
the list is read from the named file.  Names in the file may be
separated by white space and/or newlines.  The last method assumes
that the list is contained in the resource database under the
specified resource name.
.P
The type converters actually do the work of changing a string like "a\ b\ c"
into a list of nodes or links.  There are a number of ways to
have the type converters triggered and get ones node and link resource
descriptions to produce links and nodes in the widget.  The converters
are run when the value of one of the widget ``operation'' resources
(i.e. add, update, remove) is \f(CWinitialized\fP from the per process
resource database.
.P
Of course, all of the usual X resource mechanisms will work: xrdb,
Xdefaults, an application defaults file, using the Xrm functions
directly prior to creating the widget, and -xrm entries on the command
line.  The resource entry must be of the usual form
\f(CWwidget.operation:\ nodes\fP, where \f(CWwidget\fP is the resource
equivalent of the widget name and \f(CWnodes\fP would be the list of
nodes (e.g. ``a b c'' in our examples above).  The operation names are
the \f(CWXtN\fP resource name entries from the following table.
.TS
center box, tab(;);
cB s s
cB cB cB.
Network Widget Node and Link Manipulation Resources
=
Resource Name;Resource Class;Resource Type
_
.T&
l l l.

XtNnetAddNodes;XtCNetAddNodes;XtRNetNodeAddArray
XtNnetRemoveNodes;XtCNetRemoveNodes;XtRNetNodeRemoveArray
XtNnetUpdateNodes;XtCNetUpdateNodes;XtRNetNodeUpdateArray

XtNnetAddLinks;XtCNetAddLinks;XtRNetLinkAddArray
XtNnetRemoveLinks;XtCNetRemoveLinks;XtRNetLinkRemoveArray
XtNnetUpdateLinks;XtCNetUpdateLinks;XtRNetLinkUpdateArray

.TE
.ce 1
.TB "Network Widget Link and Node Manipulation Resource Fields."
.P
As can be seen in the table, there are three operations, Add, Remove,
and Update, for both nodes and links.  Again these can be set using a
resource database entry prior to creating the widget.
.P
Once the program and widget are running, one can run the converters
directly from application code as following example demonstrates:
.P
.iS 0 1

    from_value.addr = "a b c";
    from_value.size = strlen ((char *) from_value.addr) + 1;
    XtConvert (netwidget, XtRString, &from_value,
	    XtRNetNodeAddArray, &to_value);

    if (to_value.size != sizeof (netNodePtr))
            return;

    nodes = *((netNodePtr *) to_value.addr);
    XtSetArg (args[0], XtNnetAddNodes, nodes);
    XtSetValues (netwidget, args, 1);

.iE
.ce 1
.FG "Creating Nodes with XtConvert() from Application Code."
.P
The resource mechanism is complete in that it allows access to all of
the network widget netNode and netLink options including netLabel and
netLine parameterization.  However, to fully utilize the pixmap
facilities a String to Pixmap converter has to be supplied in the
application code.  X does not have a standard Pixmap format.
.H 3 "X Resources as C Data Structures"
The following figure can be used to compare the C based description of
a node with a resource based description.
.iS 0 1

    /*
     * C node
     */
    nodes[5].type = NETOBLONGSYMBOL | NETUNMOVEABLE;
    nodes[5].pf.x = 0.50;
    nodes[5].pf.y = 0.20;
    nodes[5].title.name = (char *) NULL;
    nodes[5].symbol.name = "1.1.2.1";

    !!!
    !!! X resource node
    !!!
    nodes.5.type: oblongsymbol unmoveable
    nodes.5.x: 0.50
    nodes.5.y: 0.20
    nodes.5.symbolName: 1.1.2.1

.iE
.ce 1
.FG "Creating a Node Using C and X Resources."

To convert from a C based approach to an X resource based approach one
has to do a small amount of fiddling with the structure element names.
Notice how \f(CWsymbol.name\fP becomes \f(CWsymbolName\fP.  In
selecting these names we attempted to deviate as little as possible
from the structures described in this paper and when we did to follow
a simple set of rules.  In the X world, element names that are
composed of a list of words use capitalization where it is common to
see underlines in C.  The C variable \f(CWthe_list_of_names\fP becomes
\f(CWtheListOfNames\fP for example.  Structures were also flattened as
much as possible.  \f(CWpf.x\fP becomes simply \f(CWx\fP.
.P
The following tables describe the resource database data structures
and how they relate to the equivalent C structures.

.TS
center box, tab(;);
cB s s
cB cB cB.
netNode Resource Fields
=
Resource Name;C Equivalent Element;Resource Content
_
.T&
l l l.

type;type;list of node flags
x;pf.x;X position of the node
y;pf.y;Y position of the node
titleName;title.name;title string
titleLabel;title.label;title parameter resource
symbolName;symbol.name;symbol name
symbolLabel;symbol.label;symbol parameter resource
applicationPtr;application_ptr;application use

.TE
.ce 1
.TB "netNode Resource Fields."

.TS
center box, tab(;);
cB s s
cB cB cB.
netLabel Resource Fields
=
Resource Name;C Equivalent Element;Resource Content
_
.T&
l l l.

type;type;list of label flags
name;name;string for the title or symbol
graphicsFunction;graphics_function;X graphics code
foreground;foreground;foreground color
lineWidth;line_width;line width
lineStyle;line_style;line style
font;font;font name
boxHorizSpace;box_hspace;horizontal padding
boxVertSpace; box_vspace;vertical padding
boxBackground;box_background;background texture name
pixmap;pixmap;pixmap (icon) name
pixmapMask;pixmap_mask;pixmap mask name

.TE
.ce 1
.TB "netLabel Resource Fields."

.TS
center box, tab(;);
cB s s
cB cB cB.
netLink Resource Fields
=
Resource Name;C Equivalent Element;Resource Content
_
.T&
l l l.

type;type;list of link flags
A;A;node A name
B;B;node B name
line;line;link parameter resource
applicationPtr;application_ptr;application use

.TE
.ce 1
.TB "netLink Resource Fields."

.TS
center box, tab(;);
cB s s
cB cB cB.
netLine Resource Fields
=
Resource Name;C Equivalent Element;Resource Content
_
.T&
l l l.

type;type;list of line flags
graphicsFunction;graphics_function;X graphics code
foreground;foreground;foreground color
lineWidth;line_width;line width
lineStyle;line_style;line style

.TE
.ce 1
.TB "netLine Resource Fields."
.H 3 "Resource Type Fields"
The type fields for nodes, links, labels, and lines control the
interpretation of these structures \(en as they do in the hand crafted
C versions.  The format of the tokens (flags or constants) used for
specifying options have been streamlined a bit to make then easier to
enter.  For example, the C constant \f(CWNETBOXTITLE\fP can be entered
as \f(CWboxtitle\fP.  The \f(CWNET\fP prefix has been dropped and
character comparisons are caseless.  \f(CWBoxTitle\fP is equivalent to
\f(CWboxtitle\fP.
.P
The following tables contain the tokens that are accepted in the
various type fields and the C equivalent constants.
.TS
center box, tab(;);
cB s
cB cB.
netNode Resource Type Flags
=
Resource Flags;C Equivalent Constants
_
.T&
l l.

boxtitle;NETBOXTITLE
boxsymbol;NETBOXSYMBOL
ellipsetitle;NETELLIPSETITLE
ellipsesymbol;NETELLIPSESYMBOL
circletitle;NETCIRCLETITLE
circlesymbol;NETCIRCLESYMBOL
oblongtitle;NETOBLONGTITLE
oblongsymbol;NETOBLONGSYMBOL

unconstrained;NETUNCONSTRAINED
unmoveable;NETUNMOVEABLE
untouchable;NETUNTOUCHABLE

titleislabel;NETTITLEISLABEL
symbolislabel;NETSYMBOLISLABEL

.TE
.ce 1
.TB "netNode Resource Type Flags."
.P

.TS
center box, tab(;);
cB s
cB cB.
netLink Resource Type Flags
=
Resource Flags;C Equivalent Constants
_
.T&
l l.

untouchable;NETUNTOUCHABLE
linkisline;NETLINKISLINE
splinelink;NETSPLINELINK
arrowalink;NETARROWALINK
arrowblink;NETARROWBLINK

.TE
.ce 1
.TB "netLink Resource Type Flags."
.P

.TS
center box, tab(;);
cB s
cB cB.
netLabel and netLine Resource Type Flags
=
Resource Flags;C Equivalent Constants
_
.T&
l l.

boxtitle;NETBOXTITLE
boxsymbol;NETBOXSYMBOL
ellipsetitle;NETELLIPSETITLE
ellipsesymbol;NETELLIPSESYMBOL
circletitle;NETCIRCLETITLE
circlesymbol;NETCIRCLESYMBOL
oblongtitle;NETOBLONGTITLE
oblongsymbol;NETOBLONGSYMBOL

graphicsfunction;NETGRAPHICS_FUNCTION
foreground;NETFOREGROUND
linewidth;NETLINE_WIDTH
linestyle;NETLINE_STYLE
font;NETFONT
boxhorizspace;NETBOXHORIZSPACE
boxvertspace;NETBOXVERTSPACE
bgsupplied;NETBGSUPPLIED
boxbackground;NETBGSUPPLIED
pixmap;NETPIXMAP

splinelink;NETSPLINELINK
splinepoints;NETSPLINEPOINTS
arrowalink;NETARROWALINK
arrowblink;NETARROWBLINK

.TE
.ce 1
.TB "netLabel and netLine Resource Type Flags."
.P

.TS
center box, tab(;);
cB s
cB cB.
X Graphics Function Resource Type Flags
=
Resource Flags;C Equivalent Constants
_
.T&
l l.

clear;GXclear
and;GXand
andreverse;GXandReverse
copy;GXcopy
andinverted;GXandInverted
noop;GXnoop
xor;GXxor
or;GXor
nor;GXnor
equiv;GXequiv
invert;GXinvert
orreverse;GXorReverse
copyinverted;GXcopyInverted
orinverted;GXorInverted
nand;GXnand
set;GXset

.TE
.ce 1
.TB "X Graphics Function Resource Type Flags."
.P

.TS
center box, tab(;);
cB s s
cB cB.
Line Style Resource Type Flags
=
Resource Flags;C Equivalent Constants
_
.T&
l l.

solid;LineSolid
onoffdash;LineOnOffDash
doubledash;LineDoubleDash

.TE
.ce 1
.TB "Line Style Resource Type Flags."
.H 3 "Some Subtle Points When Using Resources"
Creating nodes and links using resources involves a bit of trickery.
Unlike the C data structures, the resource descriptions of the nodes
do not keep in sync with the nodes that have been created.  The
position of the nodes may change, making the specification in the
database invalid.  Running the converter for \f(CWXtRNetNode\fP to
\f(CWXtRString\fP will, as a side effect, update the resource
database.  Of course, an application could also easily update the
resource database itself using \f(CWXrmPutLineResource()\fP or one of
the other \f(CWXrm\fP functions.
.P
All of the nodes will be synchronized by running the
\f(CWXtRNetNodeList\fP to \f(CWXtRString\fP conversion.  This
conversion also places an entry in the database that contains the list
of all of the active nodes.  The string that is returned from the
conversion contains the name of the resource, in the form
\f(CWresource:nodes.0x<widget id>\fP.
.P
Links do not contain any data that changes as a result of end user
interaction.  Converters are provided for \f(CWXtRNetLink\fP and
\f(CWXtRNetLinkList\fP to \f(CWXtRString\fP, but they have no link
specific side effects.
.P
.ne 15
The correspondence between link and node names and link and node
pointers is maintained in a two way hash table.  The hash table may be
accessed by pointer or name.  We found that this interface was by far
superior in performance to one relying on the resource database.  This
is mainly due to the fact that our interface can be easily open coded
in our access function.  Supplying our own conversion system also
meant that we did not have to add things to the database.  We did not
muddy the water so to speak.
.H 1 "Conclusion"
We have written a widget that allows applications to easily handle
directed graph or network oriented data structures.  This widget
diverges sharply from the current activity in widget construction
which has concentrated on simple widget types such as labels and
buttons.  In an approach based on levels of detail, we have also
exposed internal data structures and low level functions from the
widget.  This allows the application developer to do limited widget
programming with a minimum of effort.  The widget allows applications
to use arbitrary shaped graphics objects for both nodes and links.
.SK
.H 1 "References"
.RL
.LI
Conklin, J., ``Hypertext: An Introduction and Survey,'' IEEE Computer,
vol 20, no. 9, pp. 17-41, September 1987.
.LI
Scheifler, Robert W. and Jim Gettys, ``The X Window System,'' ACM
Transactions on Graphics, vol. 5, no. 2, pp. 79-109, April, 1986.
.LI
McCormack, Joel and Paul Asente, ``Using the X Toolkit or How to Write
a Widget,'' in Proceedings of the Summer, 1988 USENIX Conference, pp.
1-13.
.LI
``AT&T OPEN LOOK\(tm Graphical User Interface, Specification Guide,
Release 1.0,'' May 1, 1989.
.LI
``OSF Motif Toolkit External Specifications, Revision 1.11,'' June 28,
1989.
.LI
``Programming With the HP X Widgets, Professional Programmer's
Release,'' April, 1988.
.LI
Blewett, C.D., Kilduff, M. and Srinivasan, J. ``An X Widget for
Displaying Directed Graphs and Networks,'' TM11229-891211-14.
.LE
.TC 1 1 0 1
