static char TMnetAddLnks_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netAddLinks C_P_ARGS((NetWidget w, int count, netLink **new_links,
		      int *add_types, netLink **previous_links));

C_PROTOS_END_EXTERN

void
netAddLinks (w, count, new_links, add_types, previous_links)
NetWidget w;
int count;
netLink **new_links;
int *add_types;
netLink **previous_links;
{
	register netLink *link;
	register netNode *node;
	Widget rw = (Widget) w;
	Window window = XtWindow (rw);
	register netLink *new_link;
	netXSRectangle n;
	int i;
	register netLink **currListPtr;
	
	if (new_links == NULL)
	    return;

	for (i = 0; i < count ; i++)
	{
		new_link = new_links[i];
		
		if (new_link == NULL)
			continue;
		
		/* BEGIN HGK additions - 3/21/90 */
		if ((new_link->A == NULL)|| (new_link->B == NULL)){
			XtWarning("Can't add link to null node \n");
			continue;
		}
		/* END HGK additions */
		
		/* BEGIN HGK additions - 5/24/90 */
		if (XtIsRealized(rw)) {
			/* END HGK additions */
			
			
			netInitializeLink (w, new_link);
			netSetLinkRect (w, new_link);
			netDrawLink (w, new_link, window, FALSE, (netXSRectangle *) NULL);
			if (i == 0)
				n = new_link -> l;
			else
				MergeRects (&n, &new_link -> l);
			
			/* BEGIN HGK additions - 5/24/90 */
			currListPtr = &(w->net.Link_List);
		} else {
			currListPtr = &(w->net.linklist); /* not yet realized */
		}
		/* END HGK additions */
		
		switch (add_types[i])
		{
		case NETADDFIRST:
			new_link -> next = *currListPtr;
			*currListPtr = new_link;
			break;
			
		case NETADDLAST:
			link = *currListPtr;
			if (link == NULL)
			{
				*currListPtr = new_link;
				new_link -> next = (netLink *) NULL;
				break;
			}
			while (link -> next)
				link = link -> next;
			
			link -> next = new_link;
			new_link -> next = (netLink *) NULL;
			break;
			
		case NETADDPREVIOUS:
			new_link -> next = previous_links[i] -> next;
			previous_links[i] -> next = new_link;
			break;
		}
	}
	
	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized(rw))
		return;
	/* END HGK changes */
	
	if (w -> net.do_updates == False)
	    return;

	if (n.x < 0)
	{
		n.width += n.x;
		n.x = 0;
	}
	if (n.y < 0)
	{
		n.height += n.y;
		n.y = 0;
	}
	
	node = w -> net.Node_List;
	while (node)
	{
		if (RectXRect (&n, &node -> s))
			netDrawSymbol (w, node, window, FALSE,
				       &n);
		if (RectXRect (&n, &node -> t))
			netDrawTitle (w, node, window, FALSE,
				      &n);
		
		node = node -> next;
	}
}
