static char TMnetAddNd_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netAddNodes C_P_ARGS((NetWidget w, int count, netNode **new_nodes,
		      int *add_types, netNode **previous_nodes));

C_PROTOS_END_EXTERN

void
netAddNodes (w, count, new_nodes, add_types, previous_nodes)
NetWidget w;
int count;
netNode **new_nodes;
int *add_types;
netNode **previous_nodes;
{
	register netNode *node;
	Widget rw = (Widget) w;
	Window window = XtWindow (w);
	register netNode *new_node;
	int i;
	netXSRectangle n, t;
	register netNode **currListPtr;
	
	if (new_nodes == NULL)
	    return;

	for (i = 0; i < count ; i++)
	{
		new_node = new_nodes[i];
		
		if (new_node == NULL)
			continue;
		
		/* BEGIN HGK additions - 5/24/90 */
		if (XtIsRealized(rw)) {
			/* END HGK additions */
			
			netInitializeSymbol (w, new_node);
			netSetSymbolRect (w, new_node);
			netInitializeTitle (w, new_node);
			netSetTitleRect (w, new_node);
			if (w -> net.do_updates == False)
			{
			    netDrawSymbol (w, new_node, window, FALSE,
					   (netXSRectangle *) NULL);
			    netDrawTitle (w, new_node, window, FALSE,
					  (netXSRectangle *) NULL);
			}
			else
			{
			    if (i == 0)
				netGetNodeRect (new_node, &n);
			    else
				MergeRects (&n, netGetNodeRect (new_node, &t));
			}
			
			/* BEGIN HGK additions - 5/24/90 */
			currListPtr = &(w->net.Node_List);
		} else {
			currListPtr = &(w->net.nodelist); /* not yet realized */
		}
		/* END HGK additions */

		switch (add_types[i])
		{
		case NETADDFIRST:
			new_node -> next = *currListPtr;
			*currListPtr = new_node;
			break;
			
		case NETADDLAST:
			node = *currListPtr;
			if (node == NULL)
			{
				*currListPtr = new_node;
				new_node -> next = (netNode *) NULL;
				break;
			}
			while (node -> next)
				node = node -> next;
			
			node -> next = new_node;
			new_node -> next = (netNode *) NULL;
			break;
			
		case NETADDPREVIOUS:
			new_node -> next = previous_nodes[i] -> next;
			previous_nodes[i] -> next = new_node;
			break;
		}
	}

	/* BEGIN HGK additions - 5/24/90 */
	if (!XtIsRealized(rw))
		return;
	/* END HGK additions */
	
	if (w -> net.do_updates == False)
	    return;

	node = w -> net.Node_List;
	while (node)
	{
		if (RectXRect (&node -> s, &n))
			netDrawSymbol (w, node, window, FALSE, &n);
		
		if (RectXRect (&node -> t, &n))
			netDrawTitle (w, node, window, FALSE, &n);
		
		node = node -> next;
	}				
}
