static char TMnetResources_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>

#include "Net.h"
#include "NetP.h"

/*
 * node and link hash table constants
 */
#define HASH_BIT_COUNT		(6) /* 2^n hash buckets */
#define HASH_TABLE_SIZE		(1 << HASH_BIT_COUNT)
#define HASH_TABLE_MASK		(HASH_TABLE_SIZE - 1)

/*
 * hash function - assume that malloc'ed nodes are word aligned
 */
#define HASH_FUNCTION(x)	(((int) (x) >> 2) & HASH_TABLE_MASK)

/*
 * structure for keeping track of nodes and links by widget
 */
typedef unsigned char netHashIndex;

typedef struct netResourcesObjectEntry
{
	struct netResourcesObjectEntry *hash_object_prev;
	struct netResourcesObjectEntry *hash_object_next;
	int hash_object_index;
	struct netResourcesObjectEntry *hash_name_prev;
	struct netResourcesObjectEntry *hash_name_next;
	int hash_name_index;
	Widget widget;
	int type;
	caddr_t object;
	int object_id;
	int name_length;
	char name[1];
} netResourcesObjectEntry;

/*
 * Data for routines to handle the conversion of strings to the
 * appropriate type fields for nodes, links, labels, and lines.
 */
typedef struct
{
	XrmQuark quark;
	int bits;
} netMatchBits;

typedef struct
{
	char *Line;
	int LineLength;
	int Type;
	int BitComparisonType;
	int SwitchType;
	int WhatToWhat;
} netMatchVars;

enum
{
	netNODEtype = 1,
	netLINKtype,
	netLABELtype,
	netLINEtype,
	netGRAPHICSFUNCTIONtype,
	netLINESTYLEtype
};

enum
{
	LineToType = 1,
	TypeToLine
};

enum
{
	UseAnd = 1,
	UseEqual
};

/*
 * functions
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netResourcesInitialize C_P_NO_ARGS();

static void
netResourcesClassInitialize C_P_NO_ARGS();

static void
netInitializeResources C_P_ARGS((NetWidget request, NetWidget new,
				 ArgList args, Cardinal * num_args));

static void
netStringWarning C_P_ARGS((char *format, char *string));

static Boolean
netResourcesSetValues C_P_ARGS((NetWidget current, NetWidget request,
				NetWidget new_widget, ArgList args,
				Cardinal *num_args));

static void
netResourcesRealize C_P_ARGS((NetWidget w, Mask *valueMask,
			      XSetWindowAttributes *attributes));

static void
netResourcesDestroy C_P_ARGS((Widget w));

static void
netConvertTypeFields C_P_ARGS((netMatchVars *match));

static Boolean
netConvertStringToNodeType C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToLinkType C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToLabelType C_P_ARGS((Display *display, XrmValue *args,
				      Cardinal *num_args, XrmValuePtr fromVal,
				      XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToLineType C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToGraphicsFunctionType C_P_ARGS((Display *display,
						 XrmValue *args,
						 Cardinal *num_args,
						 XrmValuePtr fromVal,
						 XrmValuePtr toVal,
						 XtPointer data));

static Boolean
netConvertStringToLineStyleType C_P_ARGS((Display *display, XrmValue *args,
					  Cardinal *num_args,
					  XrmValuePtr fromVal,
					  XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToNode C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr fromVal,
				 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToLink C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr fromVal,
				 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertNodeToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr fromVal,
				 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertLinkToString C_P_ARGS((Display *display, XrmValue *args,
				 Cardinal *num_args, XrmValuePtr fromVal,
				 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertNodeListToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertLinkListToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToNodeAddArray C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr fromVal,
					 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToNodeUpdateArray C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr fromVal,
					    XrmValuePtr toVal,
					    XtPointer data));

static Boolean
netConvertStringToNodeRemoveArray C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr fromVal,
					    XrmValuePtr toVal,
					    XtPointer data));

static Boolean
netConvertStringToLinkAddArray C_P_ARGS((Display *display, XrmValue *args,
					 Cardinal *num_args,
					 XrmValuePtr fromVal,
					 XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertStringToLinkUpdateArray C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr fromVal,
					    XrmValuePtr toVal,
					    XtPointer data));

static Boolean
netConvertStringToLinkRemoveArray C_P_ARGS((Display *display, XrmValue *args,
					    Cardinal *num_args,
					    XrmValuePtr fromVal,
					    XrmValuePtr toVal,
					    XtPointer data));

static Boolean
netConvertWriteOnlyArrayToString C_P_ARGS((Display *display, XrmValue *args,
					   Cardinal *num_args,
					   XrmValuePtr fromVal,
					   XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertSelectionTypeToString C_P_ARGS((Display *display, XrmValue *args,
					  Cardinal *num_args,
					  XrmValuePtr fromVal,
					  XrmValuePtr toVal, XtPointer data));

static Boolean
netConvertDataTypeToString C_P_ARGS((Display *display, XrmValue *args,
				     Cardinal *num_args, XrmValuePtr fromVal,
				     XrmValuePtr toVal, XtPointer data));

static caddr_t *
netCreateObjectArray C_P_ARGS((Widget w, int object_type, char *string,
			       int create, int update_the_db));

static void
netCompileResourceList C_P_ARGS((XtResourceList xres, int xres_length));

static caddr_t
netResourcesDBToObject C_P_ARGS((Widget w, char *name, int object_type,
				int create, int update_the_db));

static void
netResources C_P_ARGS((Widget widget, char *base, XrmResourceList rx,
		       Cardinal num_resources, XrmHashTable *search_list));

static void
netAppendNodeList C_P_ARGS((NetWidget request));

static void
netUpdateNodeList C_P_ARGS((NetWidget request));

static void
netRemoveNodeList C_P_ARGS((NetWidget request));

static void
netAppendLinkList C_P_ARGS((NetWidget request));

static void
netUpdateLinkList C_P_ARGS((NetWidget request));

static void
netRemoveLinkList C_P_ARGS((NetWidget request));

static netResourcesObjectEntry *
netAccessResourceTable C_P_ARGS((Widget widget, int type, caddr_t object,
				 char *name, int access_type));

extern double atof C_P_ARGS((const char *));

C_PROTOS_END_EXTERN

/*
 * object types
 */
enum
{
	netNodeObject = 1,
	netLabelObject,
	netLinkObject,
	netLineObject
};

enum
{
	netHashCreate = 1,
	netHashFindNameToObject,
	netHashFindObjectToName,
	netHashRemoveByName,
	netHashRemoveByObject,
	netHashRemoveAll
};

extern NetClassRec netClassRec;
NetResourcesClassRec netResourcesClassRec = {
  {
	/* core fields */
	(WidgetClass) &netClassRec,		/* superclass		 */
	"Net",					/* class_name            */
	sizeof (NetResourcesRec),		/* size                  */
	(XtProc) netResourcesClassInitialize,	/* class_initialize      */
	(XtWidgetClassProc) NULL,   		/* class_part_initialize */
	FALSE,					/* class_inited          */
	(XtInitProc) netInitializeResources,	/* initialize            */
	(XtArgsProc) NULL,		        /* initialize_hook       */
	(XtRealizeProc) netResourcesRealize,	/* realize               */
	(XtActionsRec *) NULL,			/* actions               */
	0,					/* num_actions           */
	(XtResource *) NULL,			/* resources             */
	0,					/* num_resources         */
	NULLQUARK,				/* xrm_class             */
	TRUE,					/* compress_motion       */
	TRUE,					/* compress_exposure     */
	TRUE,					/* compress_enterleave   */
	FALSE,					/* visible_interest      */
	(XtWidgetProc) netResourcesDestroy,	/* destroy               */
	(XtWidgetProc) XtInheritResize,		/* resize                */
	(XtExposeProc) XtInheritExpose,		/* expose                */
	(XtSetValuesFunc) netResourcesSetValues,/* set_values            */
	(XtArgsFunc) NULL,	                /* set_values_hook       */
	(XtAlmostProc) XtInheritSetValuesAlmost,/* set_values_almost     */
	(XtArgsProc) NULL,		        /* get_values_hook       */
	(XtAcceptFocusProc) NULL,		/* accept_focus          */
        (XtVersionType) XtVersion,              /* version               */
	NULL,					/* callback_private      */
        XtInheritTranslations,	                /* tm_table              */
        (XtGeometryHandler) NULL,               /* query_geometry        */
  },
#ifdef OPENLOOK
  {					/* primitive class     */
      NULL,				/* can_accept_focus    */
      XtInheritHighlightHandler,	/* highlight_handler   */
      XtInheritTraversalHandler,	/* traversal_handler   */
      NULL,				/* register_focus      */
      XtInheritActivateFunc,		/* activate            */
      NULL,				/* event_procs	       */
      0,				/* num_event_procs     */
      OlVersion,			/* version             */
      NULL				/* extension           */
  },
#endif /* OPENLOOK */
#ifdef HP_WIDGETS
  {
      NULL,         /* Primitive border_highlight   */
      NULL,         /* Primitive border_unhighlight */
      NULL,         /* Primitive select_proc        */
      NULL,         /* Primitive release_proc       */
      NULL,         /* Primitive toggle_proc        */
  },
#endif /* HP_WIDGETS */
#ifdef MOTIF
  {
      NULL,
  },
#endif
  {		    /* net class */
      (int) NULL
  },
  {		    /* net resources class */
      (int) NULL
  }
};

WidgetClass netResourcesWidgetClass = (WidgetClass) &netResourcesClassRec;

void
netResourcesInitialize ()
{
	extern NetClassRec netClassRec;

	/*
	 * install the new setvalues routine
	 */
	netClassRec.core_class.set_values =
	    (XtSetValuesFunc) netResourcesSetValues;
	netClassRec.core_class.realize =
	    (XtRealizeProc) netResourcesRealize;

	netResourcesClassInitialize ();
}

static void
netResourcesClassInitialize ()
{
	/*
         * allow complete access via resources.
         */
	static XtConvertArgRec contextConvertArgs [] =
	{
	        {
			XtWidgetBaseOffset,
			(XtPointer)XtOffset(Widget, core.self),
			sizeof(Widget),
		},
	};

	/*
	 * install the netwidget specific converters
	 */
	/*
	 * string to type fields for nodes, label, links, and lines
	 */
	XtSetTypeConverter (XtRString, XtRNetNodeType,
			    (XtTypeConverter) netConvertStringToNodeType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLinkType,
			    (XtTypeConverter) netConvertStringToLinkType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLabelType,
			    (XtTypeConverter) netConvertStringToLabelType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLineType,
			    (XtTypeConverter) netConvertStringToLineType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * string to graphics function and line style
	 */
	XtSetTypeConverter (XtRString, XtRNetGraphicsFunction,
			    (XtTypeConverter) netConvertStringToGraphicsFunctionType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLineStyle,
			    (XtTypeConverter) netConvertStringToLineStyleType,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * string to node and link
	 */
	XtSetTypeConverter (XtRString, XtRNetNode,
			    (XtTypeConverter) netConvertStringToNode,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLink,
			    (XtTypeConverter) netConvertStringToLink,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * node and link to string
	 */
	XtSetTypeConverter (XtRNetNode, XtRString,
			    (XtTypeConverter) netConvertNodeToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetLink, XtRString,
			    (XtTypeConverter) netConvertLinkToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * node and link lists to string
	 */
	XtSetTypeConverter (XtRNetNodeList, XtRString,
			    (XtTypeConverter) netConvertNodeListToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetLinkList, XtRString,
			    (XtTypeConverter) netConvertLinkListToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * string to write only resources - for running XtSetValues()
	 *                                  action routines.
	 */
	XtSetTypeConverter (XtRString, XtRNetNodeAddArray,
			    (XtTypeConverter) netConvertStringToNodeAddArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetNodeUpdateArray,
			    (XtTypeConverter) netConvertStringToNodeUpdateArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetNodeRemoveArray,
			    (XtTypeConverter) netConvertStringToNodeRemoveArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLinkAddArray,
			    (XtTypeConverter) netConvertStringToLinkAddArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLinkUpdateArray,
			    (XtTypeConverter) netConvertStringToLinkUpdateArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRString, XtRNetLinkRemoveArray,
			    (XtTypeConverter) netConvertStringToLinkRemoveArray,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * write only resources to string - all return null
	 */
	XtSetTypeConverter (XtRNetNodeAddArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetNodeUpdateArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetNodeRemoveArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetLinkAddArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetLinkUpdateArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetLinkRemoveArray, XtRString,
			    (XtTypeConverter) netConvertWriteOnlyArrayToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	/*
	 * read only resources to string
	 */
	XtSetTypeConverter (XtRNetSelectionType, XtRString,
			    (XtTypeConverter) netConvertSelectionTypeToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);

	XtSetTypeConverter (XtRNetDataType, XtRString,
			    (XtTypeConverter) netConvertDataTypeToString,
			    contextConvertArgs, XtNumber (contextConvertArgs),
			    XtCacheNone, NULL);
}

static void
netInitializeResources (request, new, args, num_args)
NetWidget request;			/* what the client asked for */
NetWidget new;				/* what they get */
ArgList args;
Cardinal * num_args;
{
    if (request -> core.width == 0)
    {
	if (request -> net.net_image != NULL)
	    new -> core.width =
		request -> net.net_image -> width;
	else
	    new -> core.width = 512;
    }

    if (request -> core.height == 0)
    {
	if (request -> net.net_image != NULL)
	    new -> core.height =
		request -> net.net_image -> height;
	else
	    new -> core.height = 512;
    }
    new -> net.second_pass = FALSE;
    new -> net.allocated_symbolfont = FALSE;
    new -> net.allocated_titlefont = FALSE;
    new -> net.action_data.selection_type = 0;
    new -> net.action_data.data_type = 0;
    new -> net.Map_Polygons = (netMapPolygon *) NULL;
    new -> net.Net_Image = (XImage *) NULL;
    new -> net.gcsymbols_background = (GC) NULL;
    new -> net.gctitles_background = (GC) NULL;

    netResourcesSetValues (request, request, new, args, num_args);
}

static void
netStringWarning (format, string)
char *format;
char *string;
{
	char *ptr = (char *) XtMalloc (strlen (format) + strlen (string) + 16);

	sprintf (ptr, format, string);
	XtWarning (ptr);
	XtFree ((char *) ptr);
}

static Boolean
netResourcesSetValues (current, request, new_widget, args, num_args)
NetWidget current;
NetWidget request;
NetWidget new_widget;
ArgList args;
Cardinal *num_args;
{
	int redraw = FALSE;
	int symbolgc = FALSE;
	int titlegc = FALSE;
	int linkgc = FALSE;
	int backgroundgc = FALSE;
	int init_symbol = FALSE;
	int init_title = FALSE;
	int init_link = FALSE;
	Arg arg;
	Pixel current_background;
	Pixel request_background;

	XSync (XtDisplay (current), FALSE);

	if (request -> net.symbolfont_struct !=
	    current -> net.symbolfont_struct)
	{
	    init_symbol = symbolgc = redraw = TRUE;
	    if (current -> net.allocated_symbolfont)
	    {
		XFreeFontInfo ((char **) NULL,
			       current -> net.symbolfont_struct, 1);

		request -> net.allocated_symbolfont = False;
	    }
	}
	else
	if (request -> net.symbolforeground !=
	    current -> net.symbolforeground)
		init_symbol = symbolgc = redraw = TRUE;
/*
 * pixmap and offset support added by jags july 26, 1989
 */
	else
	if (request -> net.draw_symbolbackground !=
	    current -> net.draw_symbolbackground)
		init_symbol = symbolgc = redraw = TRUE;
	else
	if (request -> net.symbolbackground_pixmap !=
	    current -> net.symbolbackground_pixmap)
		init_symbol = symbolgc = redraw = TRUE;
	else
	if (request -> net.internal_sheight !=
	    current -> net.internal_sheight)
		init_symbol = redraw = TRUE;
	else
	if (request -> net.internal_swidth !=
	    current -> net.internal_swidth)
		init_symbol = redraw = TRUE;
/*
 * end addition by jags july 26 1989
 */
	if (request -> net.titlefont_struct !=
	    current -> net.titlefont_struct)
	{
	    init_title = titlegc = redraw = TRUE;
	    if (current -> net.allocated_titlefont)
	    {
		XFreeFontInfo ((char **) NULL,
			       current -> net.titlefont_struct, 1);

		request -> net.allocated_titlefont = False;
	    }
	}
	else
	if (request -> net.titleforeground !=
	    current -> net.titleforeground)
		init_title = titlegc = redraw = TRUE;
/*
 * pixmap and offset support added by jags july 26, 1989
 */
	else
	if (request -> net.draw_titlebackground !=
	    current -> net.draw_titlebackground)
		init_title = titlegc = redraw = TRUE;
	else
	if (request -> net.titlebackground_pixmap !=
	    current -> net.titlebackground_pixmap)
		init_title = titlegc = redraw = TRUE;
	else
	if (request -> net.internal_theight !=
	    current -> net.internal_theight)
		init_title = redraw = TRUE;
	else
	if (request -> net.internal_twidth !=
	    current -> net.internal_twidth)
		init_title = redraw = TRUE;
/*
 * end addition by jags july 26 1989
 */
	if (request -> net.linkforeground !=
	    current -> net.linkforeground)
		init_link = linkgc = redraw = TRUE;

	if (XtIsRealized ((Widget) current))
	{
	    XtSetArg (arg, XtNbackground, &request_background);
	    XtGetValues ((Widget) request, &arg, 1);
	    XtSetArg (arg, XtNbackground, &current_background);
	    XtGetValues ((Widget) current, &arg, 1);
	    if (current_background != request_background)
		backgroundgc = redraw = TRUE;
	}
	if (request -> net.nodelist != current -> net.nodelist ||
	    init_title || init_symbol)
	{
		if (XtIsRealized((Widget) current))
		{
			netNode *node;

			redraw = TRUE;
			if (request -> net.nodelist == NULL &&
			    request -> net.Node_List)
				node = ((netNode *) request -> net.Node_List);
			else
			{
				init_title = init_symbol = TRUE;
				node = ((netNode *) request -> net.nodelist);
				request -> net.Node_List = node;
				request -> net.nodelist = NULL;
			}
			while (node)
			{
				if (init_symbol)
				{
					netInitializeSymbol (request, node);
					netSetSymbolRect (request, node);
				}
				if (init_title)
				{
					netInitializeTitle (request, node);
					netSetTitleRect (request, node);
				}
				node = node -> next;
			}
		}
		else
			request->net.Node_List = NULL;
	}

	if (request -> net.linklist != current -> net.linklist || init_link)
	{
		if (XtIsRealized ((Widget) current))
		{
			netLink *link;

			redraw = TRUE;
			if (request -> net.linklist == NULL &&
			    request -> net.Link_List)
				link = ((netLink *) request -> net.Link_List);
			else
			{
				link = ((netLink *) request -> net.linklist);
				request -> net.Link_List = link;
				request -> net.linklist = NULL;
			}
			while (link)
			{
				netInitializeLink (request, link);
				netSetLinkRect (request, link);
				link = link -> next;
			}
		}
		else
			request -> net.Link_List = NULL;
	}

	if (request -> net.mappolygons !=
	    current -> net.mappolygons)
	{
		redraw = TRUE;
		netInitializeMap (request);
	}

	if (request -> net.net_image &&
	    request -> net.net_image -> data &&
	    request -> net.net_image != current -> net.net_image)
	{
		redraw = TRUE;
		if (request -> net.Net_Image)
			XDestroyImage (request -> net.Net_Image);

		if (request -> core.width !=
		    request -> net.net_image -> width ||
		    request -> core.height !=
		    request -> net.net_image -> height)
		{
			request -> net.Net_Image = netCreateImage (XtDisplay (request),
						request -> core.width,
						request -> core.height);

			if (request -> net.Net_Image == NULL)
			{
				request -> net.net_image = (XImage *) NULL;
				XtWarning ("Cannot allocate image for net widget.");
			}
			else
				SampleImage (request -> net.net_image,
					     request -> net.Net_Image);
		}
		else
			request -> net.Net_Image = (XImage *) NULL;
	}

	/*
	 * node and link manipulation functions
	 */
	if (request -> net.addnodes != NULL)
		netAppendNodeList (request); /* calls netAddNodes() */

	if (request -> net.updatenodes != NULL)
		netUpdateNodeList (request); /* calls netUpdateNodes() */

	if (request -> net.removenodes != NULL)
		netRemoveNodeList (request); /* calls netRemoveNodes() */

	if (request -> net.addlinks != NULL)
		netAppendLinkList (request); /* calls netAddLinks() */

	if (request -> net.updatelinks != NULL)
		netUpdateLinkList (request); /* calls netUpdateLinks() */

	if (request -> net.removelinks != NULL)
		netRemoveLinkList (request); /* calls netRemoveLinks() */

	new_widget -> net = request -> net;	/* Install everything */

	if (symbolgc || titlegc || linkgc || backgroundgc)
		netCreateGCs (new_widget, symbolgc, titlegc, linkgc, backgroundgc);

	return (redraw);
}

static void
netResourcesRealize (w, valueMask, attributes)
NetWidget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	netNode *node;
	netLink *link;

#ifdef HP_WIDGETS
	_XwRealize ((Widget) w, valueMask, attributes);
#else
	XtCreateWindow ((Widget) w, InputOutput, (Visual *)CopyFromParent,
			*valueMask, attributes);
#endif /* HP_WIDGETS */


	XDefineCursor (XtDisplay (w), XtWindow (w),
		       XCreateFontCursor (XtDisplay (w), XC_left_ptr));

	w -> net.second_pass = FALSE;
	w -> net.allocated_symbolfont = FALSE;
	w -> net.allocated_titlefont = FALSE;
	w -> net.action_data.selection_type = 0;
	w -> net.action_data.data_type = 0;
	w -> net.Map_Polygons = (netMapPolygon *) NULL;
	w -> net.Net_Image = (XImage *) NULL;
/*
 * pixmap support added by jags july 26, 1989
 */
	if (w -> net.titlebackground_pixmap == (Pixmap) NULL)
		w -> net.titlebackground_pixmap =
			XwCreateTile (XtScreen((Widget)w),
				      w -> net.titleforeground,
				      w -> core.background_pixel,
				      Xw25_FOREGROUND);

	if (w -> net.symbolbackground_pixmap == (Pixmap) NULL)
		w -> net.symbolbackground_pixmap =
			XwCreateTile (XtScreen((Widget)w),
				      w -> net.symbolforeground,
				      w -> core.background_pixel,
				      Xw25_FOREGROUND);

	netCreateGCs (w, TRUE, TRUE, TRUE, TRUE);

	node = ((netNode *) w -> net.nodelist);
	w -> net.Node_List = node;
	w -> net.nodelist = NULL;
	while (node)
	{
		netInitializeSymbol (w, node);
		netSetSymbolRect (w, node);
		netInitializeTitle (w, node);
		netSetTitleRect (w, node);
		node = node -> next;
	}

	link = ((netLink *) w -> net.linklist);
	w -> net.Link_List = link;
	w -> net.linklist = NULL;
	while (link)
	{
		netInitializeLink (w, link);
		netSetLinkRect (w, link);
		link = link -> next;
	}

	/*
	 * node and link manipulation functions
	 */
	if (w -> net.addnodes != NULL)
		netAppendNodeList (w); /* calls netAddNodes() */

	if (w -> net.updatenodes != NULL)
		netUpdateNodeList (w); /* calls netUpdateNodes() */

	if (w -> net.removenodes != NULL)
		netRemoveNodeList (w); /* calls netRemoveNodes() */

	if (w -> net.addlinks != NULL)
		netAppendLinkList (w); /* calls netAddLinks() */

	if (w -> net.updatelinks != NULL)
		netUpdateLinkList (w); /* calls netUpdateLinks() */

	if (w -> net.removelinks != NULL)
		netRemoveLinkList (w); /* calls netRemoveLinks() */

	netInitializeMap (w);

	if (w -> net.net_image && w -> net.net_image -> data)
	{
		if (w -> core.width != w -> net.net_image -> width ||
		    w -> core.height != w -> net.net_image -> height)
		{
			w -> net.Net_Image = netCreateImage (XtDisplay (w),
						w -> core.width,
						w -> core.height);

			if (w -> net.Net_Image == NULL)
			{
				w -> net.net_image = (XImage *) NULL;
				XtWarning ("Cannot allocate image for net widget.");
			}
			else
				SampleImage (w -> net.net_image,
					     w -> net.Net_Image);
		}
		else
			w -> net.Net_Image = (XImage *) NULL;
	}
}

static void
netResourcesDestroy (w)
Widget w;
{
    netAccessResourceTable (w, 0, (caddr_t) NULL, (char *) NULL,
			    netHashRemoveAll);
}

/*
 * routines to handle the conversion of strings to the appropriate type
 * fields for nodes, links, labels, and lines
 */
static void
netConvertTypeFields (match)
netMatchVars *match;
{
	static netMatchBits node_switch[16];
	static netMatchBits link_switch[7];
	static netMatchBits label_switch[23];
	static netMatchBits graphics_function_switch[17];
	static netMatchBits line_style_switch[4];
	static int initialized = FALSE;
	int type;
	char *ptr, *token;
	char end;
	XrmQuark quark_token;
	netMatchBits *switch_list, *switch_ptr;

	if (initialized == FALSE)
	{
		/*
		 * shared quarks
		 */
		XrmQuark XtQNetBoxTitle;
		XrmQuark XtQNetBoxSymbol;
		XrmQuark XtQNetEllipseTitle;
		XrmQuark XtQNetEllipseSymbol;
		XrmQuark XtQNetCircleTitle;
		XrmQuark XtQNetCircleSymbol;
		XrmQuark XtQNetOblongTitle;
		XrmQuark XtQNetOblongSymbol;
		XrmQuark XtQNetUntouchable;
		XrmQuark XtQNetSplineLink;
		XrmQuark XtQNetSplinePoints;
		XrmQuark XtQNetArrowALink;
		XrmQuark XtQNetArrowBLink;

		initialized = TRUE;

		/*
		 * create shared non-terminal quarks
		 */
		XtQNetBoxTitle = XrmStringToQuark ("boxtitle");
		XtQNetBoxSymbol = XrmStringToQuark ("boxsymbol");
		XtQNetEllipseTitle = XrmStringToQuark ("ellipsetitle");
		XtQNetEllipseSymbol = XrmStringToQuark ("ellipsesymbol");
		XtQNetCircleTitle = XrmStringToQuark ("circletitle");
		XtQNetCircleSymbol = XrmStringToQuark ("circlesymbol");
		XtQNetOblongTitle = XrmStringToQuark ("oblongtitle");
		XtQNetOblongSymbol = XrmStringToQuark ("oblongsymbol");
		XtQNetUntouchable = XrmStringToQuark ("untouchable");
		XtQNetSplineLink = XrmStringToQuark ("splinelink");
		XtQNetSplinePoints = XrmStringToQuark ("splinepoints");
		XtQNetArrowALink = XrmStringToQuark ("arrowalink");
		XtQNetArrowBLink = XrmStringToQuark ("arrowblink");
		/*
		 * node table
		 */
		node_switch[0].quark = XtQNetBoxTitle;
		node_switch[0].bits = NETBOXTITLE;
		node_switch[1].quark = XtQNetBoxSymbol;
		node_switch[1].bits = NETBOXSYMBOL;
		node_switch[2].quark = XtQNetEllipseTitle;
		node_switch[2].bits = NETELLIPSETITLE;
		node_switch[3].quark = XtQNetEllipseSymbol;
		node_switch[3].bits = NETELLIPSESYMBOL;
		node_switch[4].quark = XtQNetCircleTitle;
		node_switch[4].bits = NETCIRCLETITLE;
		node_switch[5].quark = XtQNetCircleSymbol;
		node_switch[5].bits = NETCIRCLESYMBOL;
		node_switch[6].quark = XtQNetOblongTitle;
		node_switch[6].bits = NETOBLONGTITLE;
		node_switch[7].quark = XtQNetOblongSymbol;
		node_switch[7].bits = NETOBLONGSYMBOL;

		node_switch[8].quark = XrmStringToQuark ("constrainx");
		node_switch[8].bits = NETCONSTRAINX;
		node_switch[9].quark = XrmStringToQuark ("constrainy");
		node_switch[9].bits = NETCONSTRAINY;
		node_switch[10].quark = XrmStringToQuark ("unconstrained");
		node_switch[10].bits = NETUNCONSTRAINED;

		node_switch[11].quark = XrmStringToQuark ("unmoveable");
		node_switch[11].bits = NETUNMOVEABLE;
		node_switch[12].quark = XtQNetUntouchable;
		node_switch[12].bits = NETUNTOUCHABLE;
		node_switch[13].quark = XrmStringToQuark ("titleislabel");
		node_switch[13].bits = NETTITLEISLABEL;
		node_switch[14].quark = XrmStringToQuark ("symbolislabel");
		node_switch[14].bits = NETSYMBOLISLABEL;
		node_switch[15].quark = 0;
		node_switch[15].bits = 0;
		/*
		 * link table
		 */
		link_switch[0].quark = XtQNetUntouchable;
		link_switch[0].bits = NETUNTOUCHABLE;
		link_switch[1].quark = XrmStringToQuark ("linkisline");
		link_switch[1].bits = NETLINKISLINE;
		link_switch[2].quark = XtQNetSplineLink;
		link_switch[2].bits = NETSPLINELINK;
		link_switch[3].quark = XtQNetSplinePoints;
		link_switch[3].bits = NETSPLINEPOINTS;
		link_switch[4].quark = XtQNetArrowALink;
		link_switch[4].bits = NETARROWALINK;
		link_switch[5].quark = XtQNetArrowBLink;
		link_switch[5].bits = NETARROWBLINK;
		link_switch[6].quark = 0;
		link_switch[6].bits = 0;
		/*
		 * label and line table
		 */
		label_switch[0].quark = XtQNetBoxTitle;
		label_switch[0].bits = NETBOXTITLE;
		label_switch[1].quark = XtQNetBoxSymbol;
		label_switch[1].bits = NETBOXSYMBOL;
		label_switch[2].quark = XtQNetEllipseTitle;
		label_switch[2].bits = NETELLIPSETITLE;
		label_switch[3].quark = XtQNetEllipseSymbol;
		label_switch[3].bits = NETELLIPSESYMBOL;
		label_switch[4].quark = XtQNetCircleTitle;
		label_switch[4].bits = NETCIRCLETITLE;
		label_switch[5].quark = XtQNetCircleSymbol;
		label_switch[5].bits = NETCIRCLESYMBOL;
		label_switch[6].quark = XtQNetOblongTitle;
		label_switch[6].bits = NETOBLONGTITLE;
		label_switch[7].quark = XtQNetOblongSymbol;
		label_switch[7].bits = NETOBLONGSYMBOL;
		label_switch[8].quark = XrmStringToQuark ("graphicsfunction");
		label_switch[8].bits = NETGRAPHICS_FUNCTION;
		label_switch[9].quark = XrmStringToQuark ("foreground");
		label_switch[9].bits = NETFOREGROUND;
		label_switch[10].quark = XrmStringToQuark ("linewidth");
		label_switch[10].bits = NETLINE_WIDTH;
		label_switch[11].quark = XrmStringToQuark ("linestyle");
		label_switch[11].bits = NETLINE_STYLE;
		label_switch[12].quark = XrmStringToQuark ("font");
		label_switch[12].bits = NETFONT;
		label_switch[13].quark = XrmStringToQuark ("boxhorizspace");
		label_switch[13].bits = NETBOXHORIZSPACE;
		label_switch[14].quark = XrmStringToQuark ("boxvertspace");
		label_switch[14].bits = NETBOXVERTSPACE;
		label_switch[15].quark = XrmStringToQuark ("bgsupplied");
		label_switch[15].bits = NETBGSUPPLIED;
		label_switch[16].quark = XrmStringToQuark ("boxbackground");
		label_switch[16].bits = NETBGSUPPLIED;
		label_switch[17].quark = XrmStringToQuark ("pixmap");
		label_switch[17].bits = NETPIXMAP;
		label_switch[18].quark = XtQNetSplineLink;
		label_switch[18].bits = NETSPLINELINK;
		label_switch[19].quark = XtQNetSplinePoints;
		label_switch[19].bits = NETSPLINEPOINTS;
		label_switch[20].quark = XtQNetArrowALink;
		label_switch[20].bits = NETARROWALINK;
		label_switch[21].quark = XtQNetArrowBLink;
		label_switch[21].bits = NETARROWBLINK;
		label_switch[22].quark = 0;
		label_switch[22].bits = 0;
		/*
		 * graphics functions
		 */
		graphics_function_switch[0].quark =
			XrmStringToQuark ("clear");
		graphics_function_switch[0].bits = GXclear;
		graphics_function_switch[1].quark =
			XrmStringToQuark ("and");
		graphics_function_switch[1].bits = GXand;
		graphics_function_switch[2].quark =
			XrmStringToQuark ("andreverse");
		graphics_function_switch[2].bits = GXandReverse;
		graphics_function_switch[3].quark =
			XrmStringToQuark ("copy");
		graphics_function_switch[3].bits = GXcopy;
		graphics_function_switch[4].quark =
			XrmStringToQuark ("andinverted");
		graphics_function_switch[4].bits = GXandInverted;
		graphics_function_switch[5].quark =
			XrmStringToQuark ("noop");
		graphics_function_switch[5].bits = GXnoop;
		graphics_function_switch[6].quark =
			XrmStringToQuark ("xor");
		graphics_function_switch[6].bits = GXxor;
		graphics_function_switch[7].quark = XrmStringToQuark ("or");
		graphics_function_switch[7].bits = GXor;
		graphics_function_switch[8].quark = XrmStringToQuark ("nor");
		graphics_function_switch[8].bits = GXnor;
		graphics_function_switch[9].quark =
			XrmStringToQuark ("equiv");
		graphics_function_switch[9].bits = GXequiv;
		graphics_function_switch[10].quark =
			XrmStringToQuark ("invert");
		graphics_function_switch[10].bits = GXinvert;
		graphics_function_switch[11].quark =
			XrmStringToQuark ("orreverse");
		graphics_function_switch[11].bits = GXorReverse;
		graphics_function_switch[12].quark =
			XrmStringToQuark ("copyinverted");
		graphics_function_switch[12].bits = GXcopyInverted;
		graphics_function_switch[13].quark =
			XrmStringToQuark ("orinverted");
		graphics_function_switch[13].bits = GXorInverted;
		graphics_function_switch[14].quark =
			XrmStringToQuark ("nand");
		graphics_function_switch[14].bits = GXnand;
		graphics_function_switch[15].quark =
			XrmStringToQuark ("set");
		graphics_function_switch[15].bits = GXset;
		graphics_function_switch[16].quark = 0;
		graphics_function_switch[16].bits = 0;
		/*
		 * line style
		 */
		line_style_switch[0].quark = XrmStringToQuark ("solid");
		line_style_switch[0].bits = LineSolid;
		line_style_switch[1].quark = XrmStringToQuark ("onoffdash");
		line_style_switch[1].bits = LineOnOffDash;
		line_style_switch[2].quark = XrmStringToQuark ("doubledash");
		line_style_switch[2].bits = LineDoubleDash;
		line_style_switch[3].quark = 0;
		line_style_switch[3].bits = 0;
	}

	if (match -> WhatToWhat == LineToType)
		match -> Type = 0;
	else
		if (match -> LineLength > 0)
			match -> Line[0] = '\0';

	switch (match -> SwitchType)
	{
	case netNODEtype:
		switch_list = node_switch;
		break;
	case netLINKtype:
		switch_list = link_switch;
		break;
	case netLABELtype:
	case netLINEtype:
		switch_list = label_switch;
		break;
	case netGRAPHICSFUNCTIONtype:
		switch_list = graphics_function_switch;
		break;
	case netLINESTYLEtype:
		switch_list = line_style_switch;
		break;
	default:
		return;
	}

	if (match -> WhatToWhat == TypeToLine)
	{
		char *line_ptr = match -> Line;
		char *quark_ptr;
		int quark_length;

		type = match -> Type;
		for (switch_ptr = switch_list; switch_ptr -> quark;
		     switch_ptr++)
		{
			if ((match -> BitComparisonType == UseAnd &&
			     type & switch_ptr -> bits) ||
			    (match -> BitComparisonType == UseEqual &&
			     type == switch_ptr -> bits))
			{
				quark_ptr =
					XrmQuarkToString (switch_ptr -> quark);
				quark_length = strlen (quark_ptr);
				if ((line_ptr - match -> Line) + quark_length >
				    match -> LineLength)
				{
       XtWarning ("The buffer is too small for type to string conversion.");
       					return;
				}
				sprintf (line_ptr, "%s ", quark_ptr);
				line_ptr += quark_length;
			}
		}
		if (line_ptr > match -> Line)
			line_ptr[-1] = '\0';
		return;
	}

	type = 0;
	ptr = match -> Line;
	while (*ptr)
	{
		while (*ptr && isspace (*ptr))
			ptr++;
		if (*ptr == '\0')
			break;
		token = ptr;
		while (*ptr && isspace (*ptr) == FALSE)
		{
			if (isupper (*ptr))
				*ptr = tolower (*ptr);
			ptr++;
		}
		end = *ptr;
		*ptr = '\0';
		quark_token = XrmStringToQuark (token);
		*ptr = end;
		for (switch_ptr = switch_list; switch_ptr -> quark;
		     switch_ptr++)
		{
			if (quark_token == switch_ptr -> quark)
			{
				type |= switch_ptr -> bits;
				break;
			}
		}
	}
	match -> Type = type;
}

static Boolean
netConvertStringToNodeType (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netNODEtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToLinkType (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netLINKtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToLabelType (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netLABELtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToLineType (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netLINEtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToGraphicsFunctionType (display, args, num_args, fromVal,
					toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netGRAPHICSFUNCTIONtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToLineStyleType (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	if ((char *) fromVal -> addr)
	{
		netMatchVars data;

		data.Line = (char *) fromVal -> addr;
		data.SwitchType = netLINESTYLEtype;
		data.WhatToWhat = LineToType;
		netConvertTypeFields (&data);
		netConverterReturn (int, toVal, data.Type);
	}
	return False;
}

static Boolean
netConvertStringToNode (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netNodePtrPtr nodes;
	netNodePtr node;

	w = *((Widget *)args[0].addr);
	if ((nodes = (netNodePtrPtr)
	     netCreateObjectArray (w, netNodeObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	node = *nodes;
	XtFree ((char *) nodes);
	netConverterReturn (netNodePtr, toVal, node);
}

static Boolean
netConvertStringToLink (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netLinkPtrPtr links;
	netLinkPtr link;

	w = *((Widget *)args[0].addr);
	if ((links = (netLinkPtrPtr)
	     netCreateObjectArray (w, netLinkObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	link = *links;
	XtFree ((char *) links);
	netConverterReturn (netLinkPtr, toVal, link);
}

static Boolean
netConvertNodeToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	NetWidget w;
	netNode *node;
	netResourcesObjectEntry *entry;
	static char *buf = (char *) NULL;
	static int buf_length = 0;
	static int node_id = (int) NULL;
	static float x = 0.0;
	static float y = 0.0;
	XrmDatabase db = XtDatabase(display);

	w = *((NetWidget *)args[0].addr);
	node = (netNode *) *((netNode **) fromVal -> addr);
	if (node == (netNode *) NULL)
		netConverterReturnString (toVal, "", 1);

	entry = netAccessResourceTable ((Widget) w, netNodeObject,
					(caddr_t) node, (char *) NULL,
					netHashFindObjectToName);

	if (entry == (netResourcesObjectEntry *) NULL)
	{
		XtWarning ("Attempt to access an unregistered node ignored.");
		netConverterReturnString (toVal, "", 1);
	}

	/*
	 * as a side effect update the X and Y resource entries for the node
	 */
	if (entry -> object_id != node_id)
	{
		node_id = entry -> object_id;

		x = node -> pf.x + 1; /* make sure they differ */
		y = node -> pf.y + 1;

		if (buf_length < (entry -> name_length + 64))
		{
				/* multiples of 128 */
			buf_length =
				(entry -> name_length + 64 + 128) & ~(127);
			buf = XtRealloc (buf, buf_length);
		}
	}

	if (node -> pf.x != x)
	{
		sprintf (buf, "%s.%s: %f", entry -> name, XtNnodeX,
			 x = node -> pf.x); /* assignment */
		XrmPutLineResource (&db, buf);
	}
	if (node -> pf.y != y)
	{
		sprintf (buf, "%s.%s: %f", entry -> name, XtNnodeY,
			 y = node -> pf.y); /* assignment */
		XrmPutLineResource (&db, buf);
	}

	netConverterReturnString (toVal, entry -> name, entry -> name_length);
}

static Boolean
netConvertLinkToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	NetWidget w;
	netLink *link;
	netResourcesObjectEntry *entry;

	w = *((NetWidget *)args[0].addr);
	link = (netLink *) *((netLink **) fromVal -> addr);
	if (link == (netLink *) NULL)
		netConverterReturnString (toVal, "", 1);

	entry = netAccessResourceTable ((Widget) w, netLinkObject,
					(caddr_t) link, (char *) NULL,
					netHashFindObjectToName);

	if (entry == (netResourcesObjectEntry *) NULL)
	{
		XtWarning ("Attempt to access an unregistered link ignored.");
		netConverterReturnString (toVal, "", 1);
	}

	netConverterReturnString (toVal, entry -> name, entry -> name_length);
}

static Boolean
netConvertNodeListToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	static char *buf = (char *) NULL;
	static int buf_length = 0;
	XrmDatabase db = XtDatabase(display);
	NetWidget w;
	netNodePtr node_list;
	netNode *node, *previous, *next;
	netResourcesObjectEntry *entry;
	float x;
	float y;
	int resource_length;
	char *ptr;

	w = *((NetWidget *)args[0].addr);
	node_list = (netNodePtr) *((netNodePtr *) fromVal -> addr);
	if (node_list == (netNodePtr) NULL)
		netConverterReturnString (toVal, "", 1);

	node = node_list;
	resource_length = 0;
	while (node)
	{
		entry = netAccessResourceTable ((Widget) w, netNodeObject,
						(caddr_t) node, (char *) NULL,
						netHashFindObjectToName);

		if (entry == (netResourcesObjectEntry *) NULL)
		{
		 XtWarning ("Attempt to access an unregistered node ignored.");
		 node = node -> next;
		 continue;
		}

		/*
		 * as a side effect update the X and Y resource entries
		 */
		if (buf_length < (entry -> name_length + 64))
		{
				/* multiples of 128 */
			buf_length =
				(entry -> name_length + 64 + 128) & ~(127);
			buf = XtRealloc (buf, buf_length);
		}

		sprintf (buf, "%s.%s: %f", entry -> name, XtNnodeX,
			 x = node -> pf.x); /* assignment */
		XrmPutLineResource (&db, buf);

		sprintf (buf, "%s.%s: %f", entry -> name, XtNnodeY,
			 y = node -> pf.y); /* assignment */
		XrmPutLineResource (&db, buf);

		resource_length += entry -> name_length;
		node = node -> next;
	}

	/*
	 * reverse the list
	 */
	node = node_list;
	previous = (netNode *) NULL;
	while (node)
	{
		next = node -> next;
		node -> next = previous;
		previous = node;
		node = next;
	}
	if (previous)
		node_list = previous;

	/*
	 * nodes.hex_number: a b c
	 * nodes.0xffffffff: a b c
	 *  6   +   10     + 2
	 */
	resource_length += 18;
	if (buf_length < resource_length)
		buf = XtRealloc (buf, resource_length);

	sprintf (buf, "nodes.0x%x: ", w);
	ptr = buf + strlen (buf);
	node = node_list;
	while (node)
	{
		entry = netAccessResourceTable ((Widget) w, netNodeObject,
						(caddr_t) node, (char *) NULL,
						netHashFindObjectToName);

		if (entry == (netResourcesObjectEntry *) NULL)
		{
			node = node -> next;
			continue;
		}

		buf_length = entry -> name_length - 1;
		memcpy (ptr, entry -> name, buf_length);
		ptr += buf_length;
		*ptr++ = ' ';
		
		node = node -> next;
	}
	*(ptr - 1) = '\0';
	XrmPutLineResource (&db, buf);

	/*
	 * reverse the list
	 */
	node = node_list;
	previous = (netNode *) NULL;
	while (node)
	{
		next = node -> next;
		node -> next = previous;
		previous = node;
		node = next;
	}

	/* return string is "resource:nodes.hex_number */
	buf_length = 32;
	buf = XtRealloc (buf, buf_length);
	sprintf (buf, "resource:nodes.0x%x", w);
	netConverterReturnString (toVal, buf, buf_length);
}

static Boolean
netConvertLinkListToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	static char *buf = (char *) NULL;
	static int buf_length = 0;
	XrmDatabase db = XtDatabase(display);
	NetWidget w;
	netLinkPtr link_list;
	netLink *link, *previous, *next;
	netResourcesObjectEntry *entry;
	float x;
	float y;
	int resource_length;
	char *ptr;

	w = *((NetWidget *)args[0].addr);
	link_list = (netLinkPtr) *((netLinkPtr *) fromVal -> addr);
	if (link_list == (netLinkPtr) NULL)
		netConverterReturnString (toVal, "", 1);

	link = link_list;
	resource_length = 0;
	while (link)
	{
		entry = netAccessResourceTable ((Widget) w, netLinkObject,
						(caddr_t) link, (char *) NULL,
						netHashFindObjectToName);

		if (entry == (netResourcesObjectEntry *) NULL)
		{
		 XtWarning ("Attempt to access an unregistered link ignored.");
		 link = link -> next;
		 continue;
		}

		resource_length += entry -> name_length;
		link = link -> next;
	}

	/*
	 * reverse the list
	 */
	link = link_list;
	previous = (netLink *) NULL;
	while (link)
	{
		next = link -> next;
		link -> next = previous;
		previous = link;
		link = next;
	}
	if (previous)
		link_list = previous;

	/*
	 * links.hex_number: a b c
	 * links.0xffffffff: a b c
	 *  6   +   10     + 2
	 */
	resource_length += 18;
	if (buf_length < resource_length)
		buf = XtRealloc (buf, resource_length);

	sprintf (buf, "links.0x%x: ", w);
	ptr = buf + strlen (buf);
	link = link_list;
	while (link)
	{
		entry = netAccessResourceTable ((Widget) w, netLinkObject,
						(caddr_t) link, (char *) NULL,
						netHashFindObjectToName);

		if (entry == (netResourcesObjectEntry *) NULL)
		{
			link = link -> next;
			continue;
		}

		buf_length = entry -> name_length - 1;
		memcpy (ptr, entry -> name, buf_length);
		ptr += buf_length;
		*ptr++ = ' ';
		
		link = link -> next;
	}
	*(ptr - 1) = '\0';
	XrmPutLineResource (&db, buf);

	/*
	 * reverse the list
	 */
	link = link_list;
	previous = (netLink *) NULL;
	while (link)
	{
		next = link -> next;
		link -> next = previous;
		previous = link;
		link = next;
	}

	/* return string is "resource:links.hex_number */
	buf_length = 32;
	buf = XtRealloc (buf, buf_length);
	sprintf (buf, "resource:links.0x%x", w);
	netConverterReturnString (toVal, buf, buf_length);
}

static Boolean
netConvertStringToNodeAddArray (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netNodePtrPtr node;

	w = *((Widget *)args[0].addr);
	if ((node = (netNodePtrPtr)
	     netCreateObjectArray (w, netNodeObject,
				   fromVal -> addr, True, True)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netNodePtrPtr, toVal, node);
}

static Boolean
netConvertStringToNodeUpdateArray (display, args, num_args, fromVal, toVal,
				   data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netNodePtrPtrPtr node_arrays = (netNodePtrPtrPtr)
		XtMalloc (sizeof (netNodePtrPtr) * 2);

	w = *((Widget *)args[0].addr);
	if ((node_arrays[0] = (netNodePtrPtr)
	     netCreateObjectArray (w, netNodeObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		XtFree ((char *) node_arrays);
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}

	if ((node_arrays[1] = (netNodePtrPtr)
	     netCreateObjectArray (w, netNodeObject,
				   fromVal -> addr, True, False)) == NULL)
	{
		XtFree ((char *) node_arrays[0]);
		XtFree ((char *) node_arrays);
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netNodePtrPtrPtr, toVal, node_arrays);
}

static Boolean
netConvertStringToNodeRemoveArray (display, args, num_args, fromVal, toVal,
				   data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netNode **nodes;

	w = *((Widget *)args[0].addr);
	if ((nodes = (netNodePtrPtr)
	     netCreateObjectArray (w, netNodeObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netNodePtrPtr, toVal, nodes);
}

static Boolean
netConvertStringToLinkAddArray (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netLinkPtrPtr link;

	w = *((Widget *)args[0].addr);
	if ((link = (netLinkPtrPtr) netCreateObjectArray (w, netLinkObject,
						       fromVal -> addr,
						       True, True)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netLinkPtrPtr, toVal, link);
}

static Boolean
netConvertStringToLinkUpdateArray (display, args, num_args, fromVal, toVal,
				   data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netLinkPtrPtrPtr link_arrays = (netLinkPtrPtrPtr)
		XtMalloc (sizeof (netLinkPtrPtr) * 2);

	w = *((Widget *)args[0].addr);
	if ((link_arrays[0] = (netLinkPtrPtr)
	     netCreateObjectArray (w, netLinkObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		XtFree ((char *) link_arrays);
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}

	if ((link_arrays[1] = (netLinkPtrPtr)
	     netCreateObjectArray (w, netLinkObject,
				   fromVal -> addr, True, False)) == NULL)
	{
		XtFree ((char *) link_arrays[0]);
		XtFree ((char *) link_arrays);
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netLinkPtrPtrPtr, toVal, link_arrays);
}

static Boolean
netConvertStringToLinkRemoveArray (display, args, num_args, fromVal, toVal,
				   data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	Widget	w;
	netLinkPtrPtr links;

	w = *((Widget *)args[0].addr);
	if ((links = (netLinkPtrPtr)
	     netCreateObjectArray (w, netLinkObject,
				   fromVal -> addr, False, False)) == NULL)
	{
		toVal -> size = 0;
		toVal -> addr = (caddr_t) NULL;
		return False;
	}
	netConverterReturn (netLinkPtrPtr, toVal, links);
}

static Boolean
netConvertWriteOnlyArrayToString (display, args, num_args, fromVal, toVal,
				  data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	netConverterReturnString (toVal, "", 1); /* null string */
}

static Boolean
netConvertSelectionTypeToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	int selection_type;
	char *return_string;
	int return_string_length;

	selection_type = (int) *((int *) fromVal -> addr);
	switch (selection_type)
	{
	case NETSELECTED:
		return_string = "selected";
		return_string_length = 9;
		break;
	case NETDRAGGED:
		return_string = "dragged";
		return_string_length = 8;
		break;
	case NETRUBBERBAND:
		return_string = "rubberband";
		return_string_length = 11;
		break;
	case NETEXPENSIVERUBBERBAND:
		return_string = "expensiverubberband";
		return_string_length = 20;
		break;
	case NETUPDATED:
		return_string = "updated";
		return_string_length = 8;
		break;
	default:
		return_string = "None";
		return_string_length = 5;
		break;
	}

	netConverterReturnString (toVal, return_string, return_string_length);
}

static Boolean
netConvertDataTypeToString (display, args, num_args, fromVal, toVal, data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer data;
{
	int data_type;
	char *return_string;
	int return_string_length;

	data_type = (int) *((int *) fromVal -> addr);
	switch (data_type)
	{
	case NETTITLE:
		return_string = "title";
		return_string_length = 6;
		break;
	case NETSYMBOL:
		return_string = "symbol";
		return_string_length = 7;
		break;
	case NETLINK:
		return_string = "link";
		return_string_length = 5;
		break;
	default:
		return_string = "None";
		return_string_length = 5;
		break;
	}

	netConverterReturnString (toVal, return_string, return_string_length);
}

static caddr_t *
netCreateObjectArray (w, object_type, string, create, update_the_db)
Widget w;
int object_type;
char *string;
int create;
int update_the_db;
{
	char *name;
	register char *ptr;
	register char end;
	char *buf = (char *) NULL;
	caddr_t *object_array;
	int object_array_size;
	int object_array_count;
	caddr_t *object_ptr;
	static unsigned char switch_table[256];	/* initialized to zero */
	static XrmQuark XtQstring_quark;

	if (XtQstring_quark == (XrmQuark) NULL)
	    XtQstring_quark = XrmStringToQuark (XtRString);

	switch_table['\0'] = FALSE;
	switch_table['\t'] = TRUE;
	switch_table['\n'] = TRUE;
	switch_table[' '] = TRUE;
	switch_table[':'] = TRUE;

	/*
	 * the list of names that are looked up in the resource
	 * database can be supplied in three forms:
	 *  directly, indirectly through a resource, or from a file
	 *
	 * direct:
	 *	a b c
	 *
	 * indirect:
	 *	resource:xx
	 * (xx in the resource database may specified as xx:a b c)
	 *
	 * file:
	 *	file:list.dat
	 * (list.dat may contain lines with a b c)
	 */
	/*
	 * list from a file
	 */
	if (strncmp (string, "file:", 5) == 0)
	{
		FILE *fp;
		struct stat file_stats;

		/*
		 * drop any leading white space
		 */
		ptr = string + 5;
		while (switch_table[*ptr])
			ptr++;

		if ((fp = fopen (ExpandFileName (ptr), "r")) == NULL ||
		    fstat (fileno (fp), &file_stats) == -1)
		{
			netStringWarning ("Cannot open the list file: %s",
					  ptr);
			if (fp)
				fclose (fp);
			return (caddr_t *) NULL;
		}
		buf = (char *) XtMalloc (file_stats.st_size + 16);
		memset (buf, (char) 0, file_stats.st_size + 16);
		fread (buf, 1, file_stats.st_size, fp);
		fclose (fp);
		ptr = buf;
	}
	/*
	 * list from the resource database
	 */
	else if (strncmp (string, "resource:", 9) == 0)
	{
		XrmString value_type;
		XrmValue value_return;

		/*
		 * drop any leading white space
		 */
		ptr = string + 9;
		while (switch_table[*ptr])
			ptr++;

		if (XrmGetResource (XtDatabase (XtDisplay (w)),
				    ptr, "String",
				    &value_type, &value_return) &&
		    (value_return.size > 0 &&
		     XrmStringToQuark (value_type) == XtQstring_quark))
		{
			ptr = value_return.addr;
		}
		else
		{
			netStringWarning ("Cannot read the resource: %s", ptr);
			return (caddr_t *) NULL;
		}
	}
	/*
	 * the list is contained in this string
	 */
	else
		ptr = string;

	/*
	 * process each object
	 */
	object_array_size = 0;
	object_array_count = 0;
	object_array = (caddr_t *) NULL;

	while (*ptr)
	{
		/*
		 * drop any leading white space
		 */
		switch_table['\0'] = FALSE;
		while (switch_table[*ptr])
			ptr++;

		if (*ptr == '\0')
			break;

		/*
		 * find the end of this name
		 */
		name = ptr;
		switch_table['\0'] = TRUE;
		while (switch_table[*ptr] == FALSE)
			ptr++;

		if (ptr == name)
			continue;

		/*
		 * check the return array size - add one for the trailing NULL
		 */
		if ((object_array_count + 1) >= object_array_size)
		{
			if (object_array_size == 0)
				object_array_size = 32; /* 128 bytes */
			else
				object_array_size <<= 2;
			object_array = (caddr_t *) XtRealloc ((char *) object_array,
							  sizeof (caddr_t) *
							  object_array_size);
			object_ptr = &object_array[object_array_count];
		}

		/*
		 * get the object and add it to the array
		 */
		end = *ptr;
		*ptr = '\0';
		*object_ptr = (caddr_t) netResourcesDBToObject (w, name,
							    object_type,
							    create,
							    update_the_db);
		if (*object_ptr)
		{
			object_ptr++;
			object_array_count++;
		}
		*ptr = end;
	}
	/*
	 * the array is null terminated
	 */
	*object_ptr = (caddr_t) NULL;

	/*
	 * free the read buffer
	 */
	if (buf)
		XtFree (buf);

	if (object_array_count == 0)
	{
		XtFree ((char *) object_array);
		return (caddr_t *) NULL;
	}
	return object_array;
}

static XtResource xNodeResources [] = {
{				/* 0 */
	XtNtype, XtCType, XtRNetNodeType, sizeof (int),
	XtOffset (netNodePtr, type),
	XtRString, NULL
},
{				/* 1 */
	XtNnodeX, XtCNodeX, XtRFloat, sizeof (float),
	XtOffset (netNodePtr, pf.x),
	XtRString, "0.0"
},
{				/* 2 */
	XtNnodeY, XtCNodeY, XtRFloat, sizeof (float),
	XtOffset (netNodePtr, pf.y),
	XtRString, "0.0"
},
{				/* 3 */
	XtNapplicationPtr, XtCApplicationPtr, XtRString, sizeof (caddr_t),
	XtOffset (netNodePtr, application_ptr),
	XtRString, NULL
},

{				/* 4 */
	XtNtitleName, XtCTitleName, XtRString, sizeof (caddr_t),
	XtOffset (netNodePtr, title.name),
	XtRString, NULL
},
{				/* 5 */
	XtNsymbolName, XtCSymbolName, XtRString, sizeof (caddr_t),
	XtOffset (netNodePtr, symbol.name),
	XtRString, NULL
},
{				/* 6 */
	XtNtitleLabel, XtCTitleLabel, XtRString, sizeof (caddr_t),
	XtOffset (netNodePtr, title.label),
	XtRString, NULL
},
{				/* 7 */
	XtNsymbolLabel, XtCSymbolLabel, XtRString, sizeof (caddr_t),
	XtOffset (netNodePtr, symbol.label),
	XtRString, NULL
},
};

static XtResource xLabelResources [] = {
{				/* 0 */
	XtNtype, XtCLabelType, XtRNetLabelType, sizeof (int),
	XtOffset (netLabelPtr, type),
	XtRString, NULL
},
{				/* 1 */
	XtNname, XtCName, XtRString, sizeof (caddr_t),
	XtOffset (netLabelPtr, name),
	XtRString, NULL
},
{				/* 2 */
	XtNgraphicsFunction, XtCGraphicsFunction, XtRNetGraphicsFunction,
	sizeof (int), XtOffset (netLabelPtr, graphics_function),
	XtRString, NULL
},
{				/* 3 */
	XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
	XtOffset (netLabelPtr, foreground),
	XtRString, NULL
},
{				/* 4 */
	XtNlineWidth, XtCLineWidth, XtRInt, sizeof (int),
	XtOffset (netLabelPtr, line_width),
	XtRString, NULL
},
{				/* 5 */
	XtNlineStyle, XtCLineStyle, XtRNetLineStyle, sizeof (int),
	XtOffset (netLabelPtr, line_style),
	XtRString, NULL
},
{				/* 6 */
	XtNfont, XtCFont, XtRString, sizeof (char *),
	XtOffset (netLabelPtr, font),
	XtRString, NULL
},
{				/* 7 */
	XtNboxHorizSpace, XtCBoxHorizSpace, XtRInt, sizeof (int),
	XtOffset (netLabelPtr, box_hspace),
	XtRString, NULL
},
{				/* 8 */
	XtNboxVertSpace, XtCBoxVertSpace, XtRInt, sizeof (int),
	XtOffset (netLabelPtr, box_vspace),
	XtRString, NULL
},
{				/* 9 */
	XtNboxBackground, XtCBoxBackground, XtRPixmap, sizeof (Pixmap),
	XtOffset (netLabelPtr, box_background),
	XtRString, NULL
},
{				/* 10 */
	XtNpixmap, XtCPixmap, XtRPixmap, sizeof (Pixmap),
	XtOffset (netLabelPtr, pixmap),
	XtRString, NULL
},
{				/* 11 */
	XtNpixmapMask, XtCPixmapMask, XtRBitmap, sizeof (Pixmap),
	XtOffset (netLabelPtr, pixmap_mask),
	XtRString, NULL
},
};

static XtResource xLinkResources [] = {
{				/* 0 */
	XtNtype, XtCLinkType, XtRNetLinkType, sizeof (int),
	XtOffset (netLinkPtr, type),
	XtRString, NULL
},
{				/* 1 */
	XtNA, XtCNode, XtRNetNode, sizeof (netNode *),
	XtOffset (netLinkPtr, A),
	XtRString, NULL
},
{				/* 2 */
	XtNB, XtCNode, XtRNetNode, sizeof (netNode *),
	XtOffset (netLinkPtr, B),
	XtRString, NULL
},
{				/* 3 */
	XtNline, XtCLine, XtRString, sizeof (char *),
	XtOffset (netLinkPtr, line),
	XtRString, NULL
},
{				/* 4 */
	XtNapplicationPtr, XtCApplicationPtr, XtRString, sizeof (caddr_t),
	XtOffset (netLinkPtr, application_ptr),
	XtRString, NULL
},
};

static XtResource xLinkNodeNamesResources [] = {
{				/* 0 */
	XtNA, XtCNode, XtRString, sizeof (char *),
	XtOffset (netLinkPtr, application_ptr),
	XtRString, NULL
},
{				/* 1 */
	XtNB, XtCNode, XtRString, sizeof (char *),
	XtOffset (netLinkPtr, next),
	XtRString, NULL
},
};

static XtResource xLineResources [] = {
{				/* 0 */
	XtNtype, XtCLineType, XtRNetLineType, sizeof (int),
	XtOffset (netLinePtr, type),
	XtRInt, NULL
},
{				/* 1 */
	XtNgraphicsFunction, XtCGraphicsFunction, XtRNetGraphicsFunction,
	sizeof (int), XtOffset (netLinePtr, graphics_function),
	XtRInt, NULL
},
{				/* 2 */
	XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
	XtOffset (netLinePtr, foreground),
	XtRInt, NULL
},
{				/* 3 */
	XtNlineWidth, XtCLineWidth, XtRInt, sizeof (int),
	XtOffset (netLinePtr, line_width),
	XtRInt, NULL
},
{				/* 4 */
	XtNlineStyle, XtCLineStyle, XtRNetLineStyle, sizeof (int),
	XtOffset (netLinePtr, line_style),
	XtRInt, NULL
},
{				/* 5 */
	XtNsplinePoints, XtCSplinePoints, XtRString, sizeof (char *),
	XtOffset (netLinePtr, spline_points),
	XtRInt, NULL
},
};

static void
netCompileResourceList (xres, xres_length)
register XtResourceList xres;
register int xres_length;
{
	register XrmResourceList xrmres = (XrmResourceList) xres;

	for (; xres_length > 0; xres++, xres_length--, xrmres++)
	{
		xrmres->xrm_name =
			XrmStringToName(xres -> resource_name);

#ifdef EXACT_MATCH_ONLY		/* should be faster */
		xrmres->xrm_class = NULLQUARK;
#else
		xrmres->xrm_class =
			XrmStringToClass(xres -> resource_class);
#endif	/* EXACT_MATCH_ONLY */

		xrmres->xrm_type =
			XrmStringToQuark(xres -> resource_type);

#ifdef CRAY1
		xrmres->xrm_offset =
			-(xres -> resource_offset * sizeof(long) + 1);
#else
		xrmres->xrm_offset = -xres -> resource_offset - 1;
#endif

		xrmres->xrm_default_type =
			XrmStringToQuark(xres -> default_type);
	}
}

static caddr_t
netResourcesDBToObject (w, name, object_type, create, update_the_db)
Widget w;
char *name;
int object_type;
int create;
int update_the_db;
{
	XrmClass class_list[1];
	static XrmName *name_list = (XrmName *) NULL;
	static int name_list_size = 0;
	static XrmHashTable *search_list = (XrmHashTable *) NULL;
	static int search_list_size = 0;
	register char *ptr0, *ptr1, end;
	register int name_count;
	XrmDatabase db = XtDatabase(XtDisplay(w));
	netResourcesObjectEntry *entry;
	static int initialized = FALSE;
	static unsigned char switch_table[256];	/* initialized to zero */

	if (initialized == FALSE)
	{
		initialized = TRUE;
		netCompileResourceList (xNodeResources,
					XtNumber (xNodeResources));
		netCompileResourceList (xLabelResources,
					XtNumber (xLabelResources));
		netCompileResourceList (xLinkResources,
					XtNumber (xLinkResources));
		netCompileResourceList (xLinkNodeNamesResources,
					XtNumber (xLinkNodeNamesResources));
		netCompileResourceList (xLineResources,
					XtNumber (xLineResources));
		switch_table['\0'] = TRUE;
		switch_table['.'] = TRUE;
		switch_table['*'] = TRUE;
	}

	/*
	 * probe the search list for existing objects
	 */
	if (create == FALSE)
	{
		switch (object_type)
		{
		case netNodeObject:
		case netLinkObject:
			entry = netAccessResourceTable (w, object_type,
							(caddr_t) NULL,
							name,
						      netHashFindNameToObject);
			if (entry)
				return entry -> object;
			/* fall trhough */
		case netLabelObject:
		case netLineObject:
		default:
			return (caddr_t) NULL;
		}
	}

	/*
	 * parse the incoming name
	 */
	name_count = 0;
	ptr0 = ptr1 = name;
	for (;;)
	{
		if (switch_table [*ptr1])
		{
			if ((name_count + 1) >= name_list_size)
			{
				name_list_size += 8;
				name_list = (XrmName *)
					XtRealloc ((char *) name_list,
						   sizeof (XrmName) *
						   name_list_size);
			}
			end = *ptr1;
			*ptr1 = '\0';
			name_list[name_count] = XrmStringToName (ptr0);
			name_count++;
			*ptr1 = end;
			if (end == '\0')
				break;
			ptr0 = ptr1 + 1;
		}
		ptr1++;
	}

	name_list[name_count] = NULLQUARK;
	class_list[0] = NULLQUARK;

	/*
	 * Ask the resource manager for a list of database levels
	 * for subsequent searchs
	 */
	while (search_list == (XrmHashTable *) NULL ||
	       !XrmQGetSearchList(db, name_list, class_list,
				  search_list, search_list_size))
	{
		search_list_size += 512;
		search_list = (XrmHashTable *)
			XtRealloc ((char *) search_list,
				   sizeof (XrmHashTable) * search_list_size);
	}

	/*
	 * probe the search list for the details of the new objects
	 */
	switch (object_type)
	{
	case netNodeObject:
	{
		netNode *node;

		node = (netNode *) XtMalloc (sizeof (netNode));
		memset (node, (char) 0, sizeof (netNode));

		if (update_the_db)
		{
			entry = netAccessResourceTable (w, object_type,
							(caddr_t) node, name,
							netHashCreate);

			if (entry -> object != (caddr_t) node)
			{
				netStringWarning ("Attempt to add a Node name that is already in use: %s.", name);
				XtFree ((char *) node);
				return (caddr_t) NULL;
			}
		}

		netResources (w, (char *) node,
			      (XrmResourceList) xNodeResources,
			      4,
			      search_list);

		if ((node -> type & NETTITLEISLABEL) == 0)
		{
			netResources (w, (char *) node,
				      (XrmResourceList) &xNodeResources[4],
				      1,
				      search_list);

			if (node -> title.name)
			    node -> title.name =
				XtNewString (node -> title.name);
		}
		else
			netResources (w, (char *) node,
				      (XrmResourceList) &xNodeResources[6],
				      1,
				      search_list);

		if ((node -> type & NETSYMBOLISLABEL) == 0)
		{
			netResources (w, (char *) node,
				      (XrmResourceList) &xNodeResources[5],
				      1,
				      search_list);

			if (node -> symbol.name)
			    node -> symbol.name =
				XtNewString (node -> symbol.name);
		}
		else
			netResources (w, (char *) node,
				      (XrmResourceList) &xNodeResources[7],
				      1,
				      search_list);

		if (node -> application_ptr)
		    node -> application_ptr =
			XtNewString (node -> application_ptr);

		/*
		 * now that we have finished with the resources, we can
		 * use the function again.
		 */
		if (node -> type & NETTITLEISLABEL)
		{
			node -> title.label = (netLabel *)
				netResourcesDBToObject (w, node -> title.name,
						       netLabelObject, create,
						       update_the_db);
		}
		if (node -> type & NETSYMBOLISLABEL)
		{
			node -> symbol.label = (netLabel *)
				netResourcesDBToObject (w, node -> symbol.name,
						       netLabelObject, create,
						       update_the_db);
		}
		return (caddr_t) node;
	}
	case netLabelObject:
	{
		netLabel *label;

		label = (netLabel *) XtMalloc (sizeof (netLabel));
		memset (label, (char) 0, sizeof (netLabel));

		netResources (w, (char *) label,
			      (XrmResourceList) xLabelResources,
			      12,
			      search_list);

		if (label -> name)
		    label -> name = XtNewString (label -> name);
		if (label -> font)
		    label -> font = XtNewString (label -> font);

		return (caddr_t) label;
	}
	case netLinkObject:
	{
		netLink *link;

		link = (netLink *) XtMalloc (sizeof (netLink));
		memset (link, (char) 0, sizeof (netLink));

		if (update_the_db)
		{
			entry = netAccessResourceTable (w, object_type,
							(caddr_t) link, name,
							netHashCreate);

			if (entry -> object != (caddr_t) link)
			{
				netStringWarning ("Attempt to add a Link name that is already in use: %s.", name);
				XtFree ((char *) link);
				return (caddr_t) NULL;
			}
		}

		netResources (w, (char *) link,
			      (XrmResourceList) xLinkResources,
			      5,
			      search_list);

		if (link -> A == (netNode *) NULL ||
		    link -> B == (netNode *) NULL)
		{
			netStringWarning ("Attempt to create a Link with an invalid Node: %s", name);

			netResources (w, (char *) link,
				      (XrmResourceList) xLinkNodeNamesResources,
				      2,
				      search_list);

			if (link -> A == (netNode *) NULL)
			{
				if ((ptr0 = link -> application_ptr) ==
				    (char *) NULL)
					ptr0 = "";

				netStringWarning ("Node A does not exist: %s",
						  ptr0);
						  
			}
			if (link -> B == (netNode *) NULL)
			{
				if ((ptr0 = (char *) link -> next) ==
				    (char *) NULL)
					ptr0 = "";

				netStringWarning ("Node B does not exist: %s",
						  ptr0);
						  
			}

			if (update_the_db)
				netAccessResourceTable ((Widget) w,
							netLinkObject,
							(caddr_t) link, name,
							netHashRemoveByObject);
			XtFree ((char *) link);
			return (caddr_t) NULL;
		}

		if (link -> application_ptr)
		    link -> application_ptr =
			XtNewString (link -> application_ptr);

		if (link -> type & NETLINKISLINE)
		{
			link -> line.line = (netLine *)
				netResourcesDBToObject (w,
					       (char *) link -> line.line,
						       netLineObject, create,
						       update_the_db);
		}
		return (caddr_t) link;
	}
	case netLineObject:
	{
		netLine *line;

		line = (netLine *) XtMalloc (sizeof (netLine));
		memset (line, (char) 0, sizeof (netLine));

		netResources (w, (char *) line,
			      (XrmResourceList) xLineResources, 5,
			      search_list);

		if (line -> type & NETSPLINEPOINTS)
		{
		    netResources (w, (char *) line,
				  (XrmResourceList) &xLineResources[5], 1,
				  search_list);

		    if (line -> spline_points)
		    {
			float x;
			int count = 0;
			int spline_count = 0;

			ptr0 = (char *) line -> spline_points;
			name_count = 0;
			line -> spline_points = (netXFPoint *) NULL;

			while (*ptr0)
			{
			    if (*ptr0 == ' ' || *ptr0 == '\t')
			    {
				while (*ptr0 == ' ' || *ptr0 == '\t')
				    ptr0++;
			    }
			    if (*ptr0 && *ptr0 != ' ' && *ptr0 != '\t')
			    {
				if (count + 1 >= spline_count)
				{
				    spline_count += 8;
				    line -> spline_points = (netXFPoint *)
					XtRealloc ((char *) line -> spline_points,
						   sizeof (netXFPoint) *
						   spline_count);
				}

				x = atof (ptr0);
				if (name_count & 1)
				{
				    line -> spline_points[count].y = x;
				    count++;
				}
				else
				{
				    line -> spline_points[count].x = x;
				}

				name_count++;

				while (*ptr0 && *ptr0 != ' ' && *ptr0 != '\t')
				    ptr0++;

			    }
			}
			line -> spline_points[count].x = -999.0;
			line -> spline_points[count].y = -999.0;
			count++;
			if (count != spline_count)
			    line -> spline_points = (netXFPoint *)
				XtRealloc ((char *) line -> spline_points,
					   sizeof (netXFPoint) * count);
		    }
		}
		return (caddr_t) line;
	}
	}
	return (caddr_t) NULL;	/* gulp */
}

/*
 * hacked up version from $x/lib/Xt/Resources.c
 */
static void
netResources (widget, base, rx, num_resources, search_list)
Widget widget;
char *base;
XrmResourceList rx;
Cardinal num_resources;
XrmHashTable *search_list;
{
	XrmQuark rawType;
	XrmValue rawValue;
	XrmValue value;
	XrmValue *pv = &value;
	register int j;
	register XrmRepresentation xrm_type;
	/*
	 * conversion variables
	 */
	char	char_val;
	short	short_val;
	int	int_val;
	long	long_val;
	char*	char_ptr;
	/*
	 * flags
	 */
	Boolean	already_copied;
	Boolean have_value;
	/*
	 * types
	 */
	static XrmClass	QBoolean = (XrmClass) NULL;
	static XrmClass	QString, QCallProc, QImmediate;

	if (QBoolean == (XrmClass) NULL)
	{
		QBoolean = XrmStringToClass (XtCBoolean);
		QString = XrmStringToClass (XtCString);
		QCallProc = XrmStringToRepresentation (XtRCallProc);
		QImmediate = XrmStringToRepresentation (XtRImmediate);
	}

	for (j = 0; j < num_resources; j++, rx++)
	{
		xrm_type = rx->xrm_type;

		already_copied = False;
		have_value = False;

		if (XrmQGetSearchResource(search_list,
					  rx->xrm_name, rx->xrm_class,
					  &rawType, &value))
		{
			if (rawType != xrm_type)
			{
				rawValue = value; /* was *pv */
				value.size = rx->xrm_size;
				value.addr = (caddr_t)
					(base - rx->xrm_offset - 1);
				already_copied = have_value =
					_XtConvert (widget,
						    rawType, &rawValue,
						    xrm_type, &value,
						    NULL);
			}
			else
				have_value = True;
		}
		if (!have_value &&
		    ((rx->xrm_default_type == QImmediate) ||
		     (rx->xrm_default_type == xrm_type)   ||
		     (rx->xrm_default_addr != NULL)))
		{
			register XrmRepresentation xrm_default_type;

			/*
			 * Convert default value to proper type
			 */
			xrm_default_type = rx->xrm_default_type;
#ifdef DO_CALL_PROCS
			if (xrm_default_type == QCallProc)
			{
#ifdef CRAY
				if ( (int) Cjumpp != (int) Cjump)
					(*(XtResourceDefaultProc)
					 (((int)(rx->xrm_default_addr))<<2))
						(widget,-(rx->xrm_offset+1),
						 pv);
				else
#endif
					(*(XtResourceDefaultProc)
					 (rx->xrm_default_addr))
						(widget,-(rx->xrm_offset+1),
						 pv);

			}
			else
#endif /* DO_CALL_PROCS */
			if (xrm_default_type == QImmediate)
			{
				/*
				 * XtRImmediate == XtRString
				 * for type XtRString
				 */
				if (xrm_type == QString) {
					pv->addr = rx->xrm_default_addr;
				} else if (rx->xrm_size == sizeof(int)) {
					int_val = (int)(long)rx->xrm_default_addr;
					pv->addr = (caddr_t) &int_val;
				} else if (rx->xrm_size == sizeof(short)) {
					short_val = (short)(long)rx->xrm_default_addr;
					pv->addr = (caddr_t) &short_val;
				} else if (rx->xrm_size == sizeof(char)) {
					char_val = (char)(long)rx->xrm_default_addr;
					pv->addr = (caddr_t) &char_val;
				} else if (rx->xrm_size == sizeof(long)) {
					long_val = (long)rx->xrm_default_addr;
					pv->addr = (caddr_t) &long_val;
				} else if (rx->xrm_size == sizeof(char*)) {
					char_ptr = (char*)rx->xrm_default_addr;
					pv->addr = (caddr_t) &char_ptr;
				} else {
					pv->addr = (caddr_t) &(rx->xrm_default_addr);
				}
			} else if (xrm_default_type == xrm_type) {
				pv->addr = rx->xrm_default_addr;
			} else {
				rawValue.addr = rx->xrm_default_addr;
				if (xrm_default_type == QString) {
					rawValue.size = strlen((char *)rawValue.addr) + 1;
				} else {
					rawValue.size = sizeof(XtPointer);
				}
				value.size = rx->xrm_size;
				value.addr = (caddr_t)(base - rx->xrm_offset - 1);
				already_copied =
					_XtConvert(widget, xrm_default_type,
						   &rawValue, xrm_type, &value,
						   NULL);
			}
		}
		if (!already_copied)
		{
			if (xrm_type == QString) {
				*((String*)(base - rx->xrm_offset - 1)) =
					pv->addr;
			} else {
				if (pv->addr != NULL) {
					memcpy(base - rx->xrm_offset - 1,
					      pv->addr,
					      rx->xrm_size);
				} else {
					/*
					 * didn't get value,
					 * initialize to NULL...
					 */
					memset(base - rx->xrm_offset - 1,
					      (char) 0,
					      rx->xrm_size);
				}
			}
		}
	}
}

static void
netAppendNodeList (request)
NetWidget request;
{
	register netNode **node_array_ptr;
	register int *node_array_types;
	register int node_array_count;
	int *ptr;

	node_array_ptr = request -> net.addnodes;
	while (*node_array_ptr)
		node_array_ptr++;
	node_array_count = node_array_ptr - request -> net.addnodes;

	node_array_types = ptr = (int *) XtMalloc (node_array_count *
						   sizeof (int));
	node_array_ptr = request -> net.addnodes;
	while (*node_array_ptr)
	{
		*node_array_types++ = NETADDFIRST;
		node_array_ptr++;
	}
	netAddNodes (request, node_array_count, request -> net.addnodes, ptr,
		     NULL);
	XtFree ((char *) request -> net.addnodes);
	request -> net.addnodes = NULL;
	XtFree ((char *) ptr);
}

static void
netUpdateNodeList (request)
NetWidget request;
{
	register netNode **node_array_ptr0; /* installed list */
	register netNode **node_array_ptr1; /* new list */
	register netNode *node;

	node_array_ptr0 = request -> net.updatenodes[0];
	while (*node_array_ptr0)
		node_array_ptr0++;

	node_array_ptr1 = request -> net.updatenodes[1];
	while (*node_array_ptr1)
		node_array_ptr1++;

	if (node_array_ptr0 - request -> net.updatenodes[0] !=
	    node_array_ptr1 - request -> net.updatenodes[1])
	{
		XtWarning ("The old and new Node update list do not match.");
		node_array_ptr1 = request -> net.updatenodes[1];
		while (node = *node_array_ptr1)
		{
			XtFree ((char *) node -> application_ptr);
			if (node -> type & NETTITLEISLABEL)
			{
			    XtFree ((char *) node -> title.label -> name);
			    XtFree ((char *) node -> title.label -> font);
			    XtFree ((char *) node -> title.label);
			}
			else
			    XtFree ((char *) node -> title.name);

			if (node -> type & NETSYMBOLISLABEL)
			{
			    XtFree ((char *) node -> symbol.label -> name);
			    XtFree ((char *) node -> symbol.label -> font);
			    XtFree ((char *) node -> symbol.label);
			}
			else
			    XtFree ((char *) node -> symbol.name);

			XtFree ((char *) node);
			node_array_ptr1++;
		}
		XtFree ((char *) request -> net.updatenodes[0]);
		XtFree ((char *) request -> net.updatenodes[1]);
		XtFree ((char *) request -> net.updatenodes);
		request -> net.updatenodes = (netNodePtr **) NULL;
		return;
	}

	node_array_ptr0 = request -> net.updatenodes[0];
	while (node = *node_array_ptr0)
	{
	    XtFree ((char *) node -> application_ptr);
	    if (node -> type & NETTITLEISLABEL)
	    {
		netDestroyLabel (request, node -> title.label);
		XtFree ((char *) node -> title.label -> name);
		XtFree ((char *) node -> title.label -> font);
		XtFree ((char *) node -> title.label);
	    }
	    else
		XtFree ((char *) node -> title.name);

	    if (node -> type & NETSYMBOLISLABEL)
	    {
		netDestroyLabel (request, node -> symbol.label);
		XtFree ((char *) node -> symbol.label -> name);
		XtFree ((char *) node -> symbol.label -> font);
		XtFree ((char *) node -> symbol.label);
	    }
	    else
		XtFree ((char *) node -> symbol.name);

	    node_array_ptr0++;
	}

	netUpdateNodePtrs (request,
			   node_array_ptr0 - request -> net.updatenodes[0],
			   request -> net.updatenodes[1],
			   request -> net.updatenodes[0]);

	node_array_ptr1 = request -> net.updatenodes[1];
	while (*node_array_ptr1)
		XtFree ((char *) *node_array_ptr1++);
	XtFree ((char *) request -> net.updatenodes[0]);
	XtFree ((char *) request -> net.updatenodes[1]);
	XtFree ((char *) request -> net.updatenodes);
	request -> net.updatenodes = (netNodePtr **) NULL;
}

static void
netRemoveNodeList (request)
NetWidget request;
{
	register netLink *link;
	register netNode **node_array_ptr;
	register netNode *node;
	int marked = FALSE;
	int link_count;
	netLink **link_array;
	netLink **link_ptr;

	node_array_ptr = request -> net.removenodes;
	link_count = 0;
	while (node = *node_array_ptr)
	{
		link = request -> net.Link_List;
		while (link)
		{
			link -> type &= ~(NETMARKBIT);
			if (link -> A == node || link -> B == node)
			{
				/* mark the link as removed */
				link -> type |= NETMARKBIT;
				link_count++;
				marked = TRUE;
			}
			link = link -> next;
		}
		node_array_ptr++;
	}
	if (marked)
	{
		link_array = (netLink **) XtMalloc (sizeof (netLink **) *
						    (link_count + 1));
		link_ptr = link_array;
		link = request -> net.Link_List;
		while (link)
		{
			if (link -> type & NETMARKBIT)
			{
			    link -> type &= ~(NETMARKBIT);
			    *link_ptr++ = link;
			}
			link = link -> next;
		}
		*link_ptr = (netLink *) NULL;
	}
	netRemoveNodes (request, node_array_ptr - request -> net.removenodes,
			request -> net.removenodes);

	node_array_ptr = request -> net.removenodes;
	while (node = *node_array_ptr)
	{
		netAccessResourceTable ((Widget) request, netNodeObject,
					(caddr_t) node, (char *) NULL,
					netHashRemoveByObject);

		XtFree ((char *) node -> application_ptr);
		if (node -> type & NETTITLEISLABEL)
		{
		    XtFree ((char *) node -> title.label -> name);
		    XtFree ((char *) node -> title.label -> font);
		    XtFree ((char *) node -> title.label);
		}
		else
		    XtFree ((char *) node -> title.name);

		if (node -> type & NETSYMBOLISLABEL)
		{
		    XtFree ((char *) node -> symbol.label -> name);
		    XtFree ((char *) node -> symbol.label -> font);
		    XtFree ((char *) node -> symbol.label);
		}
		else
		    XtFree ((char *) node -> symbol.name);

		XtFree ((char *) node);

		node_array_ptr++;
	}

	XtFree ((char *) request -> net.removenodes);

	if (marked)
	{
	    link_ptr = link_array;
	    while (link = *link_ptr)
	    {
		netAccessResourceTable ((Widget) request, netLinkObject,
					(caddr_t) link, (char *) NULL,
					netHashRemoveByObject);

		XtFree ((char *) link -> application_ptr);
		if (link -> type & NETLINKISLINE)
		{
		    XtFree ((char *) link -> line.line -> spline_points);
		    XtFree ((char *) link -> line.line);
		}
		XtFree ((char *) link);
		link_ptr++;
	    }
	    XtFree ((char *) link_array);
	}

	request -> net.removenodes = NULL;
}

static void
netAppendLinkList (request)
NetWidget request;
{
	register netLink **link_array_ptr;
	register int *link_array_types;
	register int link_array_count;
	int *ptr;

	link_array_ptr = request -> net.addlinks;
	while (*link_array_ptr)
		link_array_ptr++;
	link_array_count = link_array_ptr - request -> net.addlinks;

	link_array_types = ptr = (int *) XtMalloc (link_array_count *
						   sizeof (int));
	link_array_ptr = request -> net.addlinks;
	while (*link_array_ptr)
	{
		*link_array_types++ = NETADDLAST;
		link_array_ptr++;
	}
	netAddLinks (request, link_array_count, request -> net.addlinks, ptr,
		     NULL);
	XtFree ((char *) request -> net.addlinks);
	request -> net.addlinks = NULL;
	XtFree ((char *) ptr);
}

static void
netUpdateLinkList (request)
NetWidget request;
{
	register netLink **link_array_ptr0;
	register netLink **link_array_ptr1;
	register netLink *link;

	link_array_ptr0 = request -> net.updatelinks[0];
	while (*link_array_ptr0)
		link_array_ptr0++;

	link_array_ptr1 = request -> net.updatelinks[1];
	while (*link_array_ptr1)
		link_array_ptr1++;

	if (link_array_ptr0 - request -> net.updatelinks[0] !=
	    link_array_ptr1 - request -> net.updatelinks[1])
	{
		XtWarning ("The old and new Link update list do not match.");
		link_array_ptr1 = request -> net.updatelinks[1];
		while (link = *link_array_ptr1)
		{
			XtFree ((char *) link -> application_ptr);
			if (link -> type & NETLINKISLINE)
			{
			    XtFree ((char *) link -> line.line ->
				    spline_points);
			    XtFree ((char *) link -> line.line);
			}
			XtFree ((char *) link);
			link_array_ptr1++;
		}
		XtFree ((char *) request -> net.updatelinks[0]);
		XtFree ((char *) request -> net.updatelinks[1]);
		XtFree ((char *) request -> net.updatelinks);
		request -> net.updatelinks = (netLinkPtr **) NULL;
		return;
	}

	link_array_ptr0 = request -> net.updatelinks[0];
	while (link = *link_array_ptr0)
	{
	    XtFree ((char *) link -> application_ptr);
	    if (link -> type & NETLINKISLINE)
	    {
		netDestroyLine (request, link -> line.line);
		XtFree ((char *) link -> line.line -> spline_points);
		XtFree ((char *) link -> line.line);
		link -> line.line = (netLine *) NULL;
		link -> type &= ~(NETLINKISLINE);
	    }
		
	    link_array_ptr0++;
	}

	netUpdateLinkPtrs (request,
			   link_array_ptr0 - request -> net.updatelinks[0],
			   request -> net.updatelinks[1],
			   request -> net.updatelinks[0]);

	link_array_ptr1 = request -> net.updatelinks[1];
	while (*link_array_ptr1)
		XtFree ((char *) *link_array_ptr1++);
	XtFree ((char *) request -> net.updatelinks[0]);
	XtFree ((char *) request -> net.updatelinks[1]);
	XtFree ((char *) request -> net.updatelinks);
	request -> net.updatelinks = (netLinkPtr **) NULL;
}

static void
netRemoveLinkList (request)
NetWidget request;
{
	register netLink *link;
	register netLink **link_array_ptr;

	link_array_ptr = request -> net.removelinks;
	while (*link_array_ptr)
		link_array_ptr++;

	netRemoveLinks (request, link_array_ptr - request -> net.removelinks,
			request -> net.removelinks);

	link_array_ptr = request -> net.removelinks;
	while (link = *link_array_ptr)
	{
		netAccessResourceTable ((Widget) request, netLinkObject,
					(caddr_t) link, (char *) NULL,
					netHashRemoveByObject);

		XtFree ((char *) link -> application_ptr);
		if (link -> type & NETLINKISLINE)
		{
		    XtFree ((char *) link -> line.line -> spline_points);
		    XtFree ((char *) link -> line.line);
		}
		XtFree ((char *) link);
		link_array_ptr++;
	}

	XtFree ((char *) request -> net.removelinks);
	request -> net.removelinks = NULL;
}

static netResourcesObjectEntry *
netAccessResourceTable (widget, type, object, name, access_type)
Widget widget;
int type;
caddr_t object;
register char *name;
int access_type;
{
	netHashIndex hash_object_index = 0;
	register netHashIndex hash_name_index = 0;
	register netResourcesObjectEntry *entry_ptr;
	register char *name_ptr;
	netResourcesObjectEntry **hash_object_ptr;
	netResourcesObjectEntry **hash_name_ptr;
	int name_length = 0;
	static netResourcesObjectEntry *netResourcesNameTable[HASH_TABLE_SIZE];
	static netResourcesObjectEntry *netResourcesObjectTable[HASH_TABLE_SIZE];
	static object_count = 0;
	/*
	 * this is a hashing scheme described in Pearson, Peter.
	 * Fast Hashing of Variable Length Text Strings,
	 * Communications of the ACM 33, 6 (June 1990), 677-681.
	 */
	static unsigned char T[] =
	{
		1,  14, 110,  25,  97, 174, 132, 119,
		138, 170, 125, 118,  27, 233, 140,  51,

		87, 197, 177, 107, 234, 169,  56,  68,
		30,   7, 173,  73, 188,  40,  36,  65,

		49, 213, 104, 190,  57, 211, 148, 223,
		48, 115,  15,   2,  67, 186, 210,  28,

		12, 181, 103,  70,  22,  58,  75,  78,
		183, 167, 238, 157, 124, 147, 172, 144,

		176, 161, 141,  86,  60,  66, 128,  83,
		156, 241,  79,  46, 168, 198,  41, 254,

		178,  85, 253, 237, 250, 154, 133,  88,
		35, 206,  95, 116, 252, 192,  54, 221,

		102, 218, 255, 240,  82, 106, 158, 201,
		61,   3,  89,   9,  42, 155, 159,  93,

		166,  80,  50,  34, 175, 195, 100,  99,
		26, 150,  16, 145,   4,  33,   8, 189,

		121,  64,  77,  72, 208, 245, 130, 122,
		143,  55, 105, 134,  29, 164, 185, 194,

		193, 239, 101, 242,   5, 171, 126,  11,
		74,  59, 137, 228, 108, 191, 232, 139,

		6,  24,  81,  20, 127,  17,  91,  92,
		251, 151, 225, 207,  21,  98, 113, 112,

		84, 226,  18, 214, 199, 187,  13,  32,
		94, 220, 224, 212, 247, 204, 196,  43,

		249, 236,  45, 244, 111, 182, 153, 136,
		129,  90, 217, 202,  19, 165, 231,  71,

		230, 142,  96, 227,  62, 179, 246, 114,
		162,  53, 160, 215, 205, 180,  47, 109,

		44,  38,  31, 149, 135,   0, 216,  52,
		63,  23,  37,  69,  39, 117, 146, 184,

		163, 200, 222, 235, 248, 243, 219,  10,
		152, 131, 123, 229, 203,  76, 120, 209
		};
#ifdef DEBUGGING_STUFF
#define DEBUGGING_STUFF
	{
		int i;
		
		for (i = 0; i < HASH_TABLE_SIZE; i++)
		{
			entry_ptr = netResourcesObjectTable[i];
			while (entry_ptr)
			{
			printf ("name=%s type=%d widget=%x object=%x\n",
					entry_ptr -> name,
					entry_ptr -> type,
					entry_ptr -> widget,
					entry_ptr -> object);
				
				entry_ptr = entry_ptr -> hash_object_next;
			}
		}
		printf ("\n");
	}
#endif
	if (access_type == netHashRemoveAll)
	{
	    int i;
	    int type;
	    caddr_t object;
	    netNode *node;
	    netLink *link;
	    NetWidget nw = (NetWidget) widget;

	    for (i = 0; i < HASH_TABLE_SIZE; i++)
	    {
		entry_ptr = netResourcesObjectTable[i];
		while (entry_ptr)
		{
		    if (entry_ptr -> widget != widget -> core.self)
		    {
			entry_ptr = entry_ptr -> hash_object_next;
			continue;
		    }

		    type = entry_ptr -> type;
		    object = entry_ptr -> object;
		    netAccessResourceTable (widget, entry_ptr -> type,
					    entry_ptr -> object,
					    entry_ptr -> name,
					    netHashRemoveByObject);

		    if (type == netNodeObject)
		    {
			node = (netNode *) object;
			netDestroySymbol ((NetWidget) widget, node);
			netDestroyTitle ((NetWidget) widget, node);
			XtFree ((char *) node -> application_ptr);
			if (node -> type & NETTITLEISLABEL)
			{
			    XtFree ((char *) node -> title.label -> name);
			    XtFree ((char *) node -> title.label -> font);
			    XtFree ((char *) node -> title.label);
			}
			else
			    XtFree ((char *) node -> title.name);

			if (node -> type & NETSYMBOLISLABEL)
			{
			    XtFree ((char *) node -> symbol.label -> name);
			    XtFree ((char *) node -> symbol.label -> font);
			    XtFree ((char *) node -> symbol.label);
			}
			else
			    XtFree ((char *) node -> symbol.name);

			XtFree ((char *) node);
		    }
		    else
		    {
			link = (netLink *) object;
			netDestroyLink ((NetWidget) widget, link);
			XtFree ((char *) link -> application_ptr);
			if (link -> type & NETLINKISLINE)
			{
			    XtFree ((char *) link -> line.line ->
				    spline_points);
			    XtFree ((char *) link -> line.line);
			}

			XtFree ((char *) link);
		    }
		    entry_ptr = netResourcesObjectTable[i];
		}
	    }
	    nw -> net.Node_List = NULL;
	    nw -> net.Link_List = NULL;
	    return (netResourcesObjectEntry *) NULL;
	}

	/*
	 * calculate the name hash value
	 */
	if (access_type == netHashCreate ||
	    access_type == netHashFindNameToObject ||
	    access_type == netHashRemoveByName)
	{
		if (name)
		{
			for (name_ptr = name; *name_ptr != '\0';)
				hash_name_index = T[hash_name_index ^
						    *name_ptr++];

			name_length = name_ptr - name + 1;
		}
		hash_name_index &= HASH_TABLE_MASK;
		hash_name_ptr = &netResourcesNameTable[hash_name_index];
	}

	/*
	 * calculate the object hash value
	 */
	if (access_type == netHashCreate ||
	    access_type == netHashFindObjectToName ||
	    access_type == netHashRemoveByObject)
	{
		hash_object_index = HASH_FUNCTION(object);
		hash_object_ptr = &netResourcesObjectTable[hash_object_index];
	}

	/*
	 * Look for the string in the name hash table
	 */
	if (access_type == netHashFindNameToObject ||
	    access_type == netHashRemoveByName ||
	    access_type == netHashCreate)
	{
		register char this_char;
		register char *entry_name_ptr;

		for (entry_ptr = *hash_name_ptr; entry_ptr;
		     entry_ptr = entry_ptr -> hash_name_next)
		{
			if (entry_ptr -> widget == widget -> core.self &&
			    entry_ptr -> type == type &&
			    entry_ptr -> name_length == name_length)
			{
				for (entry_name_ptr = entry_ptr -> name,
				     name_ptr = name;
				     ((this_char = *name_ptr) != 0) &&
				     (this_char == *entry_name_ptr);
				     ++name_ptr, ++entry_name_ptr)
					;

				if (this_char == *entry_name_ptr)
				{
	/*
	 * netHashFindNameToObject
	 */
	if (access_type == netHashFindNameToObject)
		return entry_ptr;

	/*
	 * netHashCreate
	 */
	if (access_type == netHashCreate)
		return entry_ptr;

	/*
	 * netHashRemoveByName
	 */
	if (entry_ptr -> hash_name_prev)
		entry_ptr -> hash_name_prev -> hash_name_next =
			entry_ptr -> hash_name_next;
	else
		*hash_name_ptr = entry_ptr -> hash_name_next;

	if (entry_ptr -> hash_name_next)
	{
		if (entry_ptr -> hash_name_prev)
			entry_ptr -> hash_name_next -> hash_name_prev =
				entry_ptr -> hash_name_prev;
		else
			entry_ptr -> hash_name_next -> hash_name_prev =
				(netResourcesObjectEntry *) NULL;
	}

	if (entry_ptr -> hash_object_prev)
		entry_ptr -> hash_object_prev -> hash_object_next =
			entry_ptr -> hash_object_next;
	else
		netResourcesObjectTable[entry_ptr -> hash_object_index] =
			entry_ptr -> hash_object_next;

	if (entry_ptr -> hash_object_next)
	{
		if (entry_ptr -> hash_object_prev)
			entry_ptr -> hash_object_next -> hash_object_prev =
				entry_ptr -> hash_object_prev;
		else
			entry_ptr -> hash_object_next -> hash_object_prev =
				(netResourcesObjectEntry *) NULL;
	}

	XtFree ((char *) entry_ptr);
	return (netResourcesObjectEntry *) TRUE;
				}
			}		/* end if */
		}			/* end for */

		if (access_type == netHashRemoveByObject)
		{
			netStringWarning ("Removal of network object failed: %s", name);
			return (netResourcesObjectEntry *) NULL;
		}

		if (access_type == netHashFindNameToObject)
			return (netResourcesObjectEntry *) NULL;

		/* create drops through */
	}

	if (access_type == netHashFindObjectToName ||
	    access_type == netHashRemoveByObject)
	{
		for (entry_ptr = *hash_object_ptr; entry_ptr;
		     entry_ptr = entry_ptr -> hash_object_next)
		{
			if (entry_ptr -> widget == widget -> core.self &&
			    entry_ptr -> type == type &&
			    entry_ptr -> object == object)
			{
	/*
	 * netHashFindObjectToName
	 */
	if (access_type == netHashFindObjectToName)
		return entry_ptr;

	/*
	 * netHashRemoveByObject
	 */
	if (entry_ptr -> hash_object_prev)
		entry_ptr -> hash_object_prev -> hash_object_next =
			entry_ptr -> hash_object_next;
	else
		*hash_object_ptr = entry_ptr -> hash_object_next;

	if (entry_ptr -> hash_object_next)
	{
		if (entry_ptr -> hash_object_prev)
			entry_ptr -> hash_object_next -> hash_object_prev =
				entry_ptr -> hash_object_prev;
		else
			entry_ptr -> hash_object_next -> hash_object_prev =
				(netResourcesObjectEntry *) NULL;
	}

	if (entry_ptr -> hash_name_prev)
		entry_ptr -> hash_name_prev -> hash_name_next =
			entry_ptr -> hash_name_next;
	else
		netResourcesNameTable[entry_ptr -> hash_name_index] =
			entry_ptr -> hash_name_next;

	if (entry_ptr -> hash_name_next)
	{
		if (entry_ptr -> hash_name_prev)
			entry_ptr -> hash_name_next -> hash_name_prev =
				entry_ptr -> hash_name_prev;
		else
			entry_ptr -> hash_name_next -> hash_name_prev =
				(netResourcesObjectEntry *) NULL;
	}

	XtFree ((char *) entry_ptr);
	return (netResourcesObjectEntry *) TRUE;
			}
		}

		if (access_type == netHashRemoveByObject)
			XtWarning ("Removal of network object failed.");
		return (netResourcesObjectEntry *) NULL;
	}

	/*
	 * netHashCreate: add the object to the hash tables
	 */
	entry_ptr = (netResourcesObjectEntry *)
		XtMalloc (sizeof (netResourcesObjectEntry) + name_length);
	entry_ptr -> object_id = ++object_count;
	entry_ptr -> hash_object_index = hash_object_index;
	entry_ptr -> hash_object_prev = (netResourcesObjectEntry *) NULL;
	entry_ptr -> hash_object_next = *hash_object_ptr;
	if (*hash_object_ptr)
		(*hash_object_ptr) -> hash_object_prev = entry_ptr;
	*hash_object_ptr = entry_ptr;
	entry_ptr -> hash_name_index = hash_name_index;
	entry_ptr -> hash_name_prev = (netResourcesObjectEntry *) NULL;
	entry_ptr -> hash_name_next = *hash_name_ptr;
	if (*hash_name_ptr)
		(*hash_name_ptr) -> hash_name_prev = entry_ptr;
	*hash_name_ptr = entry_ptr;
	entry_ptr -> widget = widget -> core.self;
	entry_ptr -> type = type;
	entry_ptr -> object = object;
	entry_ptr -> name_length = name_length;
	memcpy (entry_ptr -> name, name, name_length);

	return entry_ptr;
}
