static char TMnetRmvNd_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>

#include "Net.h"
#include "NetP.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
netRemoveNode C_P_ARGS((NetWidget w, netNode *old_node));

C_PROTOS_END_EXTERN

void
netRemoveNode (w, old_node)
NetWidget w;
netNode *old_node;
{
	Widget rw = (Widget) w;
	Window window = XtWindow (rw);
	XExposeEvent expose_event;
	register netNode *node;
	netNode *node_previous, *node_temp;
	register netLink *link;
	netLink *link_previous, *link_temp;
	netXSRectangle n;
	netXSRectangle t;
	
	if (old_node == NULL)
	    return;

	/* BEGIN HGK changes - 5/24/90 */
	if (XtIsRealized(rw))
		node = w -> net.Node_List;
	else
		node = w -> net.nodelist;
	
	node_previous = (netNode *) NULL;
	while (node && node != old_node) {
		node_previous = node;
		node = node -> next;
	}
	/* END HGK changes */
	
	if (node == NULL)
	{
		XtWarning ("Cannot find node to be removed.");
		old_node -> next = (netNode *) NULL;
		return;
	}
	
	/* BEGIN HGK changes - 5/24/90 */
	if (!XtIsRealized(rw)) {
		/* remove node */
		if (node_previous) 
			node_previous->next = node->next;
		else
			w->net.nodelist = node->next; /* remove first node */
		
		/* remove links incident on this node */
		link = w -> net.linklist;
		link_previous = (netLink *) NULL;
		while (link)
		{
			if (link -> A == old_node || link -> B == old_node)
				if (link_previous)
					link_previous -> next = link -> next;
				else
					w -> net.linklist = link -> next;
			link_previous = link;
			link = link -> next;
		}
		return;	/* DONE */
	}
	/* END HGK changes */
	
	old_node -> type |= (NETMARKBIT | NETMOVED);
	if (w -> net.do_updates == True)
	{
	    netGetNodeRect (old_node, &n);
	    
	    /*
	     * find the links that use this node
	     */
	    link = w -> net.Link_List;
	    while (link)
	    {
		if (link -> A == old_node || link -> B == old_node)
		{
		    MergeRects (&n, &link -> l);
		    link -> type |= (NETMARKBIT | NETMOVED);
		}
		link = link -> next;
	    }
	    
	    if (n.x < 0)
	    {
		n.width += n.x;
		n.x = 0;
	    }
	    if (n.y < 0)
	    {
		n.height += n.y;
		n.y = 0;
	    }
	    
	    expose_event.type = Expose;
	    expose_event.x = n.x;
	    expose_event.y = n.y;
	    expose_event.width = n.width;
	    expose_event.height = n.height;
	    netShowNetworkBackground (w, &expose_event, FALSE);
	}	

	link_previous = (netLink *) NULL;
	link = w -> net.Link_List;
	while (link)
	{
		if (link -> type & NETMOVED)
		{
			if (link_previous)
				link_previous -> next = link -> next;
			else
				w -> net.Link_List = link -> next;
			link -> type &= ~(NETMARKBIT | NETMOVED);
			link_temp = link -> next;
			netDestroyLink (w, link);
			link = link_temp;
			continue;
		}
		
		if (w -> net.do_updates == True &&
		    RectXRect (&n, &link -> l))
			netDrawLink (w, link, window, FALSE, &n);

		link_previous = link;
		link = link -> next;
	}
	
	node_previous = (netNode *) NULL;
	node = w -> net.Node_List;
	while (node)
	{
		if (node -> type & NETMOVED)
		{
			if (node_previous)
				node_previous -> next = node -> next;
			else
				w -> net.Node_List = node -> next;
			node -> type &= ~(NETMARKBIT | NETMOVED);
			node_temp = node -> next;
			netDestroySymbol (w, node);
			netDestroyTitle (w, node);
			node = node_temp;
			continue;
		}
		
		if (w -> net.do_updates == True)
		{
		    if (RectXRect (&node -> s, &n))
			netDrawSymbol (w, node, window, FALSE, &n);
		    
		    if (RectXRect (&node -> t, &n))
			netDrawTitle (w, node, window, FALSE, &n);
		}
		node_previous = node;
		node = node -> next;
	}
}
