static char TMoldSampleImg_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

/*
 * this is a switch and do while version of SampleImage().
 * A nested do while breaks some C compilers.
 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
SampleImage C_P_ARGS((XImage *in, XImage *out));

C_PROTOS_END_EXTERN

#define MIN(x, y)		((x) <= (y) ? (x) : (y))
#define MAX(x, y)		((x) >= (y) ? (x) : (y))

/*
 * SampleImage: integer interpolation;
 *         new image may be larger or smaller than original;
 *
 */
#define OnePixel() \
		x = (x_fctr * i) >> 9; \
		if (x == lastx) \
		{ \
			XPutPixel (out, i, j, pixel); \
		} \
		else \
		{ \
			pixel = XGetPixel (in, x, y); \
			XPutPixel (out, i, j, pixel); \
			lastx = x; \
		} \
		i++; \


#define OneLine() \
		y = (y_fctr * j) >> 9; \
		if (y == lasty) \
		{ \
			char *ptr; \
 \
			ptr = out -> data + out -> bytes_per_line * (j - 1); \
			memcpy (ptr + out -> bytes_per_line, ptr, \
				out -> bytes_per_line); \
		} \
		else if (out -> width == in -> width) \
		{ \
			memcpy (out -> data + out -> bytes_per_line * j, \
				in -> data + in -> bytes_per_line * y, \
				MIN (in -> bytes_per_line,\
				     out -> bytes_per_line)); \
			lasty = y; \
		} \
		else \
		{ \
			register int x, lastx; \
			register int i; \
			register Pixel pixel; \
 \
			lastx = -1; \
			i = 0; \
			switch (out -> width & 7) \
			{ \
				do \
				{ \
						OnePixel (); \
				case 7:		OnePixel (); \
				case 6:		OnePixel (); \
				case 5:		OnePixel (); \
				case 4:		OnePixel (); \
				case 3:		OnePixel (); \
				case 2:		OnePixel (); \
				case 1:		OnePixel (); \
				case 0:		; \
				} while (i < out -> width); \
			} \
			lasty = y; \
		} \
		j++; \

void
SampleImage (in, out)
register XImage *in;
register XImage *out;
{
	register int y, lasty;
	register int j;
	register long x_fctr, y_fctr;

	XtWarning ("Sampling Image.");

	x_fctr = (in -> width << 9) / (out -> width);
	y_fctr = (in -> height << 9) / (out -> height);

	lasty = -1;
	j = 0;
	switch (out -> height & 7)
	{
		do
		{
				OneLine ();
		case 7:		OneLine ();
		case 6:		OneLine ();
		case 5:		OneLine ();
		case 4:		OneLine ();
		case 3:		OneLine ();
		case 2:		OneLine ();
		case 1:		OneLine ();
		case 0:		;
		} while (j < out -> height);
	}

	XtWarning ("Sampling Image Completed.");
}
