static char TMxnet1_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#include <Xol/Form.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/PButton.h>
#include <Xw/Arrow.h>
#include <Xw/Valuator.h>
#include <Xw/ScrollBar.h>
#include <Xw/SWindow.h>
#include <Xw/SText.h>
#include <Xw/TextEdit.h>
#include <Xw/BBoard.h>
#include <Xw/Form.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#endif /* MOTIF */

#ifdef OPENLOOK
#define INITIALIZE		OlInitialize
#define FORMWDG			formWidgetClass
#define PBUTTONWDG		oblongButtonWidgetClass
#define SCROLLEDWINDOWWDG	scrolledWindowWidgetClass
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#define INITIALIZE		XtInitialize
#define FORMWDG			XwformWidgetClass
#define PBUTTONWDG		XwpushButtonWidgetClass
#define SCROLLEDWINDOWWDG	XwswindowWidgetClass
#endif /* HP_WIDGETS */

#ifdef MOTIF
#define INITIALIZE		XtInitialize
#define FORMWDG			xmFormWidgetClass
#define PBUTTONWDG		xmPushButtonWidgetClass
#define SCROLLEDWINDOWWDG	xmScrolledWindowWidgetClass
#endif /* MOTIF */

#include "Net.h"

typedef struct InputLine
{
	NetWidget w;
	FILE *fp;
	XtInputId id;
	int rows;
	int width, height;
	int node_width, node_height;
	XImage *image;
	XImage *sampled_image;
	Pixel background, foreground;
	Pixmap bitmap;
	Pixmap pixmap;
	netNode *nodes;
	char *file;
	struct InputLine *next;
} InputLine;

static InputLine *input;	/* it is a demo */

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static netMapPolygon *
chess_polygons C_P_ARGS((int rows, char *color));

static void
chess_messages C_P_ARGS((InputLine *input, int *source, XtInputId id));

static XImage *
BitmapFileToXImage C_P_ARGS((Display *display, char *filename));

static Pixel
CVTColorToPixel C_P_ARGS((Widget w, char *color));

static Pixmap
BitmapFileToPixmap C_P_ARGS((Display *display, char *filename,
			     unsigned int *ret_width,
			     unsigned int *ret_height));

static Pixmap
BitmapToPixmap C_P_ARGS((Display *display, Pixmap bitmap,
			 Pixel foreground, Pixel background,
			 int width, int height));

static Pixmap
ImageToBitmap C_P_ARGS((Display *display, XImage *image));

static Pixmap
PixmapToBitmap C_P_ARGS((Display *display, Pixmap pixmap,
			 int width, int height));

static NetDrawProc
symbol_draw_proc C_P_ARGS((int type, Widget w, netNode *node,
			   Drawable d, int xor, netXSRectangle *clip_rect));

C_PROTOS_END_EXTERN

/*
 * Report the syntax
 */
Syntax (call)
char *call;
{
    fprintf (stderr, "%s: usage\n %s rows bitmap-file fifo-name\n",
	     call, call);
    exit (1);
}

void
main (argc, argv)
int argc;
char **argv;
{
	Arg args[32];
	int i;
	Widget toplevel, form, netwidget;
	netMapPolygon *maps;
	XFontStruct *font_struct;
	int rows;
	char *ptr;

	/*
	 * initialize and parse the arguments
	 */
	toplevel = INITIALIZE (argv[0], "Test", NULL, 0, &argc, argv);

	if (argc != 4)
	    Syntax (argv[0]);

	/*
	 * rows
	 */
	rows = atoi (argv[1]);
	if (rows < 1  || rows > 512)
	{
	    fprintf (stderr, "%s: rows not in the range of 1 to 512: %d\n",
		     argv[0], rows);
	    Syntax (argv[0]);
	}

	/*
	 * the input fifo
	 */
	ptr = (char *) XtMalloc (32 + strlen (argv[3]));
	sprintf (ptr, "echo > %s &\n", argv[3]);
	system (ptr);
	XtFree (ptr);
	input = (InputLine *) XtMalloc (sizeof (InputLine));
	bzero ((char *) input, sizeof (InputLine));
	input -> fp = fopen (argv[3], "r");
	if (input -> fp == NULL)
	{
	    fprintf (stderr, "%s: Cannot open fifo: %s.\n", argv[0], argv[3]);
	    Syntax (argv[0]);
	}
	input -> file = argv[3];
	input -> id = XtAppAddInput (XtWidgetToApplicationContext (toplevel),
				     (int) fileno (input -> fp),
				     (XtPointer) XtInputReadMask,
				     (XtInputCallbackProc) chess_messages,
				     (XtPointer) input);
	/*
	 * image for the queen
	 */
	input -> image = BitmapFileToXImage (XtDisplay (toplevel), argv[2]);
	if (input -> image == (XImage *) NULL)
	    Syntax (argv[0]);
	input -> foreground = CVTColorToPixel (toplevel, "red");
	input -> background = CVTColorToPixel (toplevel, "purple");

	/*
	 * add the data to the input struct
	 */
	input -> rows = rows;
	input -> nodes = (netNode *) XtMalloc (sizeof(netNode) * rows * rows);
	bzero ((char *) input -> nodes, sizeof(netNode) * rows * rows);

#ifndef MOTIF
	/*
	 * the form widget
	 */
	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	form = XtCreateManagedWidget ("Form", FORMWDG, toplevel, args, i);

	/*
	 * the display widget
	 */
	i = 0;
	XtSetArg (args[i], XtNxRefWidget, form); i++;
	XtSetArg (args[i], XtNyRefWidget, form); i++;

	XtSetArg (args[i], XtNxResizable, True); i++;
	XtSetArg (args[i], XtNxAttachRight, True); i++;

	XtSetArg (args[i], XtNyResizable, True); i++;
	XtSetArg (args[i], XtNyAttachBottom, True); i++;
#else
	form = toplevel;
#endif /* MOTIF */

	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	maps = chess_polygons (rows, "grey80");
	XtSetArg (args[i], XtNnetMapPolygons, maps); i++;
/*
	font_struct = XLoadQueryFont (XtDisplay (toplevel), "*chess*");
	if (font_struct == NULL)
	{
	    fprintf (stderr, "%s: Cannot load the chess font.\n", argv[0]);
	    exit (1);
	}
	XtSetArg (args[i], XtNnetSymbolFont, font_struct); i++;
*/
	netwidget = XtCreateManagedWidget ("net",
					   netWidgetClass,
					   form,
					   args, i);

	input -> w = (NetWidget) netwidget;

	XtRealizeWidget (toplevel);

	XtMainLoop ();
}

static netMapPolygon *
chess_polygons (rows, color)
int rows;
char *color;
{
    double x0, y0, x1, y1;
    double t = rows;
    int npoints = 5;
    int i, j;
    netMapPolygon *mp;
    netMapPolygon *top = (netMapPolygon *) NULL;

    for (i = 0; i < rows; i++)
    {
	for (j = i & 01; j < rows; j += 2)
	{
	    x0 = (double) i / t;
	    x1 = (double) (i+1) / t;
	    y0 = (double) j / t;
	    y1 = (double) (j+1) / t;
	    
	    mp = (netMapPolygon *) XtMalloc (sizeof (netMapPolygon));
	    mp -> points = (netXFPoint *)
		XtMalloc (sizeof (netXFPoint) * npoints);
	    mp -> p = (XPoint *) XtMalloc (sizeof (XPoint) * npoints);
	    mp -> npoints = npoints;
	    mp -> color = color;
	    mp -> next = top;
	    top = mp;
	    mp -> points[0].x = x0;
	    mp -> points[0].y = y0;
	    mp -> points[1].x = x1;
	    mp -> points[1].y = y0;
	    mp -> points[2].x = x1;
	    mp -> points[2].y = y1;
	    mp -> points[3].x = x0;
	    mp -> points[3].y = y1;
	    mp -> points[4].x = x0;
	    mp -> points[4].y = y0;
	}
    }
    return top;
}

enum {
    SELMAN_ADD = 1,
    SELMAN_REMOVE,
    SELMAN_CLEAR,
    SELMAN_EXIT
    };

/*
 * XtAppAddInput() function
 */
static void
chess_messages (input, source, id)
InputLine *input;
int *source;
XtInputId id;
{
    char buffer[BUFSIZ];
    int type;
    int n, col, row, allnodes;
    double x, y;
    double half_step = 1.0 / ((double) input -> rows * 2.0);
    char *ptr;

    while (fgets (buffer, BUFSIZ, input -> fp) != NULL)
    {
	/*
	 * lex
	 */
	if (strncmp (buffer, "xtent.XtAdd:", 12) == 0)
	{
	    type = SELMAN_ADD;
	    ptr = buffer + 12;
	}
	else if (strncmp (buffer, "xtent.XtRemove:", 15) == 0)
	{
	    type = SELMAN_REMOVE;
	    ptr = buffer + 15;
	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	}
	else if (strncmp (buffer, "xtent.XtClear:", 14) == 0)
	{
	    type = SELMAN_CLEAR;
	    ptr = "1";
	}
	else if (strncmp (buffer, "xtent.XtExit:", 13) == 0)
	{
	    type = SELMAN_EXIT;
	    ptr = "1";
	}
	else
	    return;
	n = atoi (ptr);

	/*
	 * Selman uses 1 (rather than 0) based arrays
	 */
	allnodes = input -> rows * input -> rows;
	if (n < 1 || n > allnodes)
	{
	    fprintf (stderr,
		     "Node number out of range for %s: %d\n",
		     (type == SELMAN_ADD) ? "xtent.XtAdd" : "xtent.XtRemove",
		     n);
	    return;
	}

	n--;

	switch (type)
	{
	case SELMAN_ADD:
	    if (input -> nodes[n].symbol.name)
		break;

	    col = n / input -> rows;
	    row = n % input -> rows;
	    x = (double) row / (double) input -> rows + half_step;
	    y = (double) col / (double) input -> rows + half_step;

	    input -> nodes[n].type = NETSYMBOLISPROC;
	    input -> nodes[n].pf.x = x;
	    input -> nodes[n].pf.y = y;
	    input -> nodes[n].symbol.name = "B";
	    input -> nodes[n].symbol.draw_proc = symbol_draw_proc;
	    netAddNode (input -> w, &input -> nodes[n],
			NETADDFIRST, (netNode *) NULL);
	    break;

	case SELMAN_REMOVE:
	    if (!input -> nodes[n].symbol.name)
		break;
	    netRemoveNode (input -> w, &input -> nodes[n]);
	    input -> nodes[n].symbol.name = (char *) NULL;
	    break;

	case SELMAN_CLEAR:
	    for (n = 0; n < allnodes; n++)
	    {
		if (!input -> nodes[n].symbol.name)
		    continue;
		netRemoveNode (input -> w, &input -> nodes[n]);
		input -> nodes[n].symbol.name = (char *) NULL;
	    }
	    break;

	case SELMAN_EXIT:
	    exit (0);
	}

    }
    clearerr (input -> fp);
}

static XImage *
BitmapFileToXImage (display, filename)
Display *display;
char *filename;
{
	Pixmap pixmap;
	XImage *image;
	unsigned int width, height;
	XRectangle rect;

	pixmap = BitmapFileToPixmap (display, filename, &width, &height);
	if (pixmap == (Pixmap) NULL)
	    return (XImage *) NULL;

	rect.x = rect.y = 0; rect.width = width; rect.height = height;
	image = XGetImage (display, pixmap,
			   rect.x, rect.y, rect.width, rect.height,
			   AllPlanes, XYPixmap);

	XFreePixmap (display, pixmap);

	return image;
}

static Pixel
CVTColorToPixel (w, color)
Widget w;
char *color;
{
	XrmValue from_value, to_value;
	
	from_value.size = strlen (color);
	from_value.addr = color;
	to_value.size = 0;
	to_value.addr = (caddr_t) NULL;
	
	XtConvert (w, XtRString, &from_value,
		   XtRPixel, &to_value);
	
	if (to_value.size && to_value.addr)
		return *((Pixel *) to_value.addr);

	return (Pixel) NULL;
}

static Pixmap
BitmapFileToPixmap (display, filename, ret_width, ret_height)
Display *display;
char *filename;
unsigned int *ret_width;
unsigned int *ret_height;
{
	Pixmap bitmap;
	Pixmap pixmap;
	int screen = DefaultScreen (display);
	int depth = DefaultDepth (display, screen);
	Window root = RootWindow (display, screen);
	int x_hot, y_hot;
	Pixel foreground;
	Pixel background;

	/*
	 * bitmaps may include colors: file(foreground,background)
	 */
	foreground = BlackPixel (display, screen);
	background = WhitePixel (display, screen);

	if (XReadBitmapFile (display, root, filename,
			     ret_width, ret_height, &bitmap, &x_hot, &y_hot) !=
	    BitmapSuccess)
	{
		fprintf (stderr, "%s: Cannot read the bitmap file: %s.\n",
			 "demo", filename);
		return (Pixmap) NULL;
	}
	if (depth == 1)
		return bitmap;

	pixmap = BitmapToPixmap (display, bitmap, foreground, background,
				 *ret_width, *ret_height);
	if (pixmap == (Pixmap) NULL)
	{
		fprintf (stderr,
			 "%s: Cannot create the pixmap from the file: %s.\n",
			 "demo", filename);
	}

	XFreePixmap (display, bitmap);

	return pixmap;
}

static Pixmap
BitmapToPixmap (display, bitmap, foreground, background, width, height)
Display *display;
Pixmap bitmap;
Pixel foreground;
Pixel background;
int width;
int height;
{
	Pixmap pixmap;
	int screen = DefaultScreen (display);
	int depth = DefaultDepth (display, screen);
	Window root = RootWindow (display, screen);
	GC gc;
	XGCValues gcvalues;

	pixmap = XCreatePixmap (display, root, width, height, depth);
	
	if (pixmap == (Pixmap) NULL)
		return pixmap;

	gcvalues.function = GXcopy;
	gcvalues.foreground = foreground;
	gcvalues.background = background;
	gc = XCreateGC (display, root,
			GCFunction | GCForeground | GCBackground,
			&gcvalues);

	XCopyPlane (display, bitmap, pixmap, gc,
		    0, 0, width, height, 0, 0, 1L);
	
	XFreeGC (display, gc);

	return (pixmap);
}

static Pixmap
ImageToBitmap (display, image)
Display *display;
XImage *image;
{
	Pixmap pixmap;
	Pixmap bitmap;
	int screen = DefaultScreen (display);
	Window root = RootWindow (display, screen);
	int depth = DefaultDepth (display, screen);
	GC gc;
	XGCValues gcvalues;

	pixmap = XCreatePixmap (display, root, 
				image -> width, image -> height,
				depth);
	
	if (pixmap == (Pixmap) NULL)
		return pixmap;

	gcvalues.function = GXcopy;
	gcvalues.plane_mask = AllPlanes;
	gcvalues.foreground = BlackPixel (display, screen);
	gcvalues.background = WhitePixel (display, screen);
	gc = XCreateGC (display, pixmap,
			GCFunction | GCPlaneMask | GCForeground | GCBackground,
			&gcvalues);

	XPutImage (display, pixmap, gc, image, 0, 0, 0, 0,
		   image -> width, image -> height);

	XFreeGC (display, gc);

	if (depth == 1)
	    return pixmap;

	bitmap = PixmapToBitmap (display, pixmap, image -> width,
				 image -> height);

	XFreePixmap (display, pixmap);

	return (bitmap);
}

static Pixmap
PixmapToBitmap (display, pixmap, width, height)
Display *display;
Pixmap pixmap;
int width;
int height;
{
	Pixmap bitmap;
	int screen = DefaultScreen (display);
	Window root = RootWindow (display, screen);
	GC gc;
	XGCValues gcvalues;

	bitmap = XCreatePixmap (display, root, width, height, 1);
	
	if (bitmap == (Pixmap) NULL)
		return bitmap;

	gcvalues.function = GXcopy;
	gcvalues.plane_mask = 1;
	gcvalues.foreground = BlackPixel (display, screen);
	gcvalues.background = WhitePixel (display, screen);
	gc = XCreateGC (display, bitmap,
			GCFunction | GCPlaneMask | GCForeground | GCBackground,
			&gcvalues);
	
	XCopyPlane (display, pixmap, bitmap, gc,
		    0, 0, width, height, 0, 0, 1L);

	XFreeGC (display, gc);

	return (bitmap);
}

#define BORDER_WIDTH	(2)

static NetDrawProc
symbol_draw_proc (type, w, node, d, xor, clip_rect)
int type;
Widget w;
netNode *node;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
    static Pixmap background = NULL;
    XGCValues gcValues;
    static GC gc = NULL;
    static GC xor_gc = NULL;
    GC lgc;
    static int reference_count = 0;
    Dimension width, height;
    int i;
    Arg args[16];
    XPoint dp;
    netXSRectangle sp;

    node -> type &= ~(NETSYMBOLISPROC);
    node -> symbol.name = (char *) node -> application_ptr;

    switch (type)
    {
    case NETPROCINIT:
	if (reference_count == 0)
	{
	    gcValues.function = GXcopy;
	    gcValues.foreground = CVTColorToPixel (w, "red");
	    if (gc == NULL)
		gc = XCreateGC (XtDisplay (w), XtWindow (w),
				GCFunction | GCForeground, &gcValues);

	    gcValues.function = NET_GXXOR_OP;
	    if (xor_gc == NULL)
		xor_gc = XCreateGC (XtDisplay (w), XtWindow (w),
				    GCFunction | GCForeground, &gcValues);
	}
	reference_count++;
	
	netInitializeSymbol ((NetWidget) w, node);
	break;

    case NETPROCSIZE:
	i = 0;
	XtSetArg (args[i], XtNwidth, &width); i++;
	XtSetArg (args[i], XtNheight, &height); i++;
	XtGetValues (w, args, i);
	if (width != input -> width || height != input -> height)
	{
	    Display *display = XtDisplay (w);
	    int screen = DefaultScreen (display);
	    int depth = DefaultDepth (display, screen);

	    input -> width = width;
	    input -> height = height;
	    input -> node_width = (width / input -> rows) - BORDER_WIDTH * 2;
	    input -> node_height = (height / input -> rows) - BORDER_WIDTH * 2;
	    if (input -> node_width < 1)
		input -> node_width = 1;
	    if (input -> node_height < 1)
		input -> node_height = 1;

	    if (input -> sampled_image)
	    {
		XtFree (input -> sampled_image -> data);
		input -> sampled_image -> data = (char *) NULL;
		XDestroyImage (input -> sampled_image);
	    }

	    input -> sampled_image =
		XCreateImage (display, DefaultVisual (display, screen),
			      depth, /* depth */
			      (depth > 1) ? ZPixmap : XYPixmap,
			      0,
			      (char *) NULL,
			      input -> node_width, input -> node_height,
			      8,
			      0);

	    input -> sampled_image -> data
		= (char *) XtMalloc (input -> sampled_image -> bytes_per_line *
				     input -> sampled_image -> height);

	    SampleImage (input -> image, input -> sampled_image);

	    if (input -> bitmap)
		XFreePixmap (XtDisplay (w), input -> bitmap);
	    if (input -> pixmap)
		XFreePixmap (XtDisplay (w), input -> pixmap);

	    input -> bitmap = ImageToBitmap (XtDisplay (w),
					     input -> sampled_image);

	    input -> pixmap = BitmapToPixmap (XtDisplay (w), input -> bitmap,
					      input -> foreground,
					      input -> background,
					      input -> node_width,
					      input -> node_height);
	}
	netSetSymbolRect ((NetWidget) w, node);
	node -> s.x = node -> p.x - input -> node_width / 2;
	node -> s.y = node -> p.y - input -> node_height / 2;
	node -> s.width = input -> node_width;
	node -> s.height = input -> node_height;
	break;

    case NETPROCDRAW:
	netDrawSymbol ((NetWidget) w, node, d, xor, clip_rect);

	if (xor)
	    lgc = xor_gc;
	else
	    lgc = gc;

	gcValues.clip_mask = input -> bitmap;
	gcValues.clip_x_origin = node -> p.x - input -> node_width / 2;
	gcValues.clip_y_origin = node -> p.y - input -> node_height / 2;
	XChangeGC (XtDisplay (w), lgc,
		   GCClipMask | GCClipXOrigin | GCClipYOrigin, &gcValues);

	sp.x = sp.y = 0;
	sp.width = input -> node_width;
	sp.height = input -> node_height;
	dp.x = node -> p.x - input -> node_width / 2;
	dp.y = node -> p.y - input -> node_height / 2;
	if (clip_rect && RectInRect (&node -> s, clip_rect) == FALSE)
	{
	    int delta;
	    
	    if (dp.x < clip_rect -> x)
	    {
		delta = clip_rect -> x - dp.x;
		sp.width -= delta;
		sp.x = delta;
		dp.x = clip_rect -> x;
	    }
	    if (dp.y < clip_rect -> y)
	    {
		delta = clip_rect -> y - dp.y;
		sp.height -= delta;
		sp.y = delta;
		dp.y = clip_rect -> y;
	    }
	    if (dp.x + sp.width >
		clip_rect -> x + clip_rect -> width)
		sp.width = clip_rect -> x +
		    clip_rect -> width - dp.x;
	    if (dp.y + sp.height >
		clip_rect -> y + clip_rect -> height)
		sp.height = clip_rect -> y +
		    clip_rect -> height - dp.y;
	}

	XCopyArea (XtDisplay (w), input -> pixmap, d, lgc,
		   (int) sp.x, (int) sp.y,
		   (int) sp.width, (int) sp.height,
		   (int) dp.x, (int) dp.y);
	break;

    case NETPROCPICK:
    {
	NetPickArgs *pick_args = (NetPickArgs *) d;

	pick_args -> return_value = PtInRect (pick_args -> p,
					      &node -> s);
	break;
    }

    case NETPROCDESTROY:
	netDestroySymbol ((NetWidget) w, node);
	if (--reference_count)
	    break;
	if (gc)
	{
	    XFreeGC (XtDisplay (w), gc);
	    gc = (GC) NULL;
	}
	if (xor_gc)
	{
	    XFreeGC (XtDisplay (w), xor_gc);
	    xor_gc = (GC) NULL;
	}
	break;
    }

    node -> type |= NETSYMBOLISPROC;
    node -> symbol.draw_proc = symbol_draw_proc;
}
