static char TMxnet4_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"
#include <math.h>

#define MAX(a,b)	((a > b) ? a : b)
#define MIN(a,b)	((a < b) ? a : b)

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static Pixel
GetPixel C_P_ARGS((Widget w, char *str));

static NetDrawProc
link_draw_proc C_P_ARGS((int type, Widget w, netLink *link, Drawable d,
			 int xor, netXSRectangle *clip_rect));

static void
SplineDraw C_P_ARGS((Widget widget, Drawable d, GC gc, int offset_x,
		     int offset_y, XPoint *p, int n));

static int
SplineCheck C_P_ARGS((int x, int y, int offset_x, int offset_y, XPoint *p,
		      int n));

C_PROTOS_END_EXTERN

void
main (argc, argv)
int argc;
char **argv;
{
	extern NetDrawProc link_draw_proc ();
	static netNode nodes[6]; /* use static to get zero'ed memory */
	static netLink links[5];
	Arg args[10];
	int i;
	Widget toplevel, scrolledwindow, netwidget;
	Pixmap background_pixmap;

#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	nodes[0].type = NETBOXSYMBOL;
	nodes[0].pf.x = 0.5;
	nodes[0].pf.y = 0.80;
	nodes[0].title.name = (char *) NULL;
	nodes[0].symbol.name = "1";
	nodes[0].next = &nodes[1];

	nodes[1].type = NETBOXSYMBOL;
	nodes[1].pf.x = 0.25;
	nodes[1].pf.y = 0.60;
	nodes[1].title.name = (char *) NULL;
	nodes[1].symbol.name = "1.1";
	nodes[1].next = &nodes[2];

	nodes[2].type = NETBOXSYMBOL;
	nodes[2].pf.x = 0.75;
	nodes[2].pf.y = 0.60;
	nodes[2].title.name = (char *) NULL;
	nodes[2].symbol.name = "1.2";
	nodes[2].next = &nodes[3];

	nodes[3].type = NETBOXSYMBOL;
	nodes[3].pf.x = 0.25;
	nodes[3].pf.y = 0.40;
	nodes[3].title.name = (char *) NULL;
	nodes[3].symbol.name = "1.1.1";
	nodes[3].next = &nodes[4];

	nodes[4].type = NETBOXSYMBOL;
	nodes[4].pf.x = 0.50;
	nodes[4].pf.y = 0.40;
	nodes[4].title.name = (char *) NULL;
	nodes[4].symbol.name = "1.1.2";
	nodes[4].next = &nodes[5];

	nodes[5].type = NETBOXSYMBOL;
	nodes[5].pf.x = 0.50;
	nodes[5].pf.y = 0.20;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "1.1.2.1";
	nodes[5].next = (netNode *) NULL;

	links[0].type = NETLINEISPROC;
	links[0].line.draw_proc = link_draw_proc;
	links[0].A = &nodes[0];
	links[0].B = &nodes[1];
	links[0].next = &links[1];

	links[1].type = NETLINEISPROC;
	links[1].line.draw_proc = link_draw_proc;
	links[1].A = &nodes[0];
	links[1].B = &nodes[2];
	links[1].next = &links[2];

	links[2].type = NETLINEISPROC;
	links[2].line.draw_proc = link_draw_proc;
	links[2].A = &nodes[1];
	links[2].B = &nodes[3];
	links[2].next = &links[3];

	links[3].type = NETLINEISPROC;
	links[3].line.draw_proc = link_draw_proc;
	links[3].A = &nodes[1];
	links[3].B = &nodes[4];
	links[3].next = &links[4];

	links[4].type = NETLINEISPROC;
	links[4].line.draw_proc = link_draw_proc;
	links[4].A = &nodes[4];
	links[4].B = &nodes[5];
	links[4].next = (netLink *) NULL;

	background_pixmap = XwCreateTile (XtScreen (toplevel),
					  WhitePixel (XtDisplay (toplevel), 0),
					  BlackPixel (XtDisplay (toplevel), 0),
					  XwSLANT_LEFT);
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap,
		  background_pixmap); i++;
        XtSetArg (args[i], XtNnetSymbolForeground,
		  BlackPixel (XtDisplay (toplevel), 0)); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;

	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

	XtMainLoop ();
}

static Pixel
GetPixel (w, str)
Widget w;
char *str;
{
	XColor xch, xce;
	Display *display = XtDisplay (w);

	if (XAllocNamedColor (display,
			      DefaultColormap (display,
					       DefaultScreen (display)),
			      str,
			      &xch, &xce))
		return xch.pixel;
	
	return (Pixel) NULL;
}

static NetDrawProc
link_draw_proc (type, w, link, d, xor, clip_rect)
int type;
Widget w;
netLink *link;
Drawable d;
int xor;
netXSRectangle *clip_rect;
{
	XGCValues gcValues;
	static GC gc = NULL;
	static GC xor_gc = NULL;
	XPoint p_spline[5];
	static int reference_count = 0;

	link -> type &= ~(NETLINEISPROC);
	link -> line.line = (netLine *) link -> application_ptr;
	
	switch (type)
	{
	case NETPROCINIT:
		reference_count++;

		gcValues.function = GXcopy;
		gcValues.foreground = GetPixel (w, "black");
		if (gc == NULL)
			gc = XCreateGC (XtDisplay (w), XtWindow (w),
					GCFunction | GCForeground,
					&gcValues);
		gcValues.function = NET_GXXOR_OP;
		if (xor_gc == NULL)
			xor_gc = XCreateGC (XtDisplay (w), XtWindow (w),
					    GCFunction | GCForeground,
					    &gcValues);
		
		netInitializeLink ((NetWidget) w, link);
		break;
		
	case NETPROCSIZE:
		netSetLinkRect ((NetWidget) w, link);
		link -> l.width += 2; /* add spline extra */
		link -> l.height += 2;
		break;
		
	case NETPROCDRAW:
		if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
			XSetClipRectangles (XtDisplay (w),
					    xor ? xor_gc : gc,
					    0, 0, (XRectangle *) clip_rect,
					    1, YXBanded);
		p_spline[0].x = link -> B -> p.x;
		p_spline[0].y = link -> B -> p.y;
		p_spline[1].x = link -> A -> p.x;
		p_spline[1].y = link -> B -> p.y;
		p_spline[2].x = link -> A -> p.x;
		p_spline[2].y = link -> A -> p.y;
		p_spline[4] = p_spline[3] = p_spline[2];
		SplineDraw (w, d, xor ? xor_gc : gc, 1, 1, p_spline, 3);
		if (clip_rect && RectInRect (&link -> l, clip_rect) == FALSE)
		{
			XGCValues xgcvalues;

			xgcvalues.clip_mask = None;
			XChangeGC (XtDisplay (w), xor ? xor_gc : gc,
				   GCClipMask, &xgcvalues);
		}
		break;
		
	case NETPROCPICK:
	{
		NetPickArgs *pick_args = (NetPickArgs *) d;
		
		p_spline[0].x = link -> B -> p.x;
		p_spline[0].y = link -> B -> p.y;
		p_spline[1].x = link -> A -> p.x;
		p_spline[1].y = link -> B -> p.y;
		p_spline[2].x = link -> A -> p.x;
		p_spline[2].y = link -> A -> p.y;
		p_spline[4] = p_spline[3] = p_spline[2];
		
		if (SplineCheck (pick_args -> p -> x, pick_args -> p -> y,
				 1, 1, p_spline, 3))
		{
			pick_args -> return_value = TRUE;
			break;
		}
		
		if ((pick_args -> p -> y == link -> A -> p.y &&
		     pick_args -> p -> x >= MIN (link -> A -> p.x,
						 link -> B -> p.x) &&
		     pick_args -> p -> x <= MAX (link -> A -> p.x,
						 link -> B -> p.x)) ||
		    (pick_args -> p -> x == link -> B -> p.x &&
		     pick_args -> p -> y >= MIN (link -> A -> p.y,
						 link -> B -> p.y) &&
		     pick_args -> p -> y <= MAX (link -> A -> p.y,
						 link -> B -> p.y)))
		{
			pick_args -> return_value = TRUE;
			break;
		}
		
		pick_args -> return_value = netPickLink ((NetWidget) w, link,
							 pick_args -> p -> x,
							 pick_args -> p -> y);
		break;
	}
		
	case NETPROCDESTROY:
		netDestroyLink ((NetWidget) w, link);
		if (--reference_count)
			break;
		if (gc)
		{
			XFreeGC (XtDisplay (w), gc);
			gc = (GC) NULL;
		}
		if (xor_gc)
		{
			XFreeGC (XtDisplay (w), xor_gc);
			xor_gc = (GC) NULL;
		}
		break;
	}
	
	link -> type |= NETLINEISPROC;
	link -> line.draw_proc = link_draw_proc;
}

/*
 * spline routine from cip
 */
#define SCALE (long) 1000
#define STEPS 10

static void
SplineDraw (widget, d, gc, offset_x, offset_y, p, n)
Widget widget;
Drawable d;
GC gc;
int offset_x, offset_y; 
register XPoint *p;
int n;
{
	register long w, t1, t2, t3; 
	register int i, j; 
	XPoint q;
	XPoint pcurrent;		/* Current point */
	
	if (p != (XPoint *) NULL)
	{
		pcurrent.x = p[0].x + offset_x;
		pcurrent.y = p[0].y + offset_y;
		
		for (i = 0; i < n - 1; i++)
		{
			for (j = 0; j < STEPS; j++)
			{
				w = SCALE * j / STEPS;
				t1 = w * w / (2 * SCALE);
				w = w - SCALE / 2;
				t2 = 3 * SCALE / 4 - w * w / SCALE;
				w = w - SCALE / 2;
				t3 = w * w / (2 * SCALE);
				q.x = offset_x +
					(t1 * p[i+2].x + t2 * p[i+1].x +
					 t3 * p[i].x + SCALE / 2) / SCALE;
				q.y = offset_y +
					(t1 * p[i+2].y + t2 * p[i+1].y +
					 t3 * p[i].y + SCALE / 2) / SCALE;
				XDrawLine (XtDisplay (widget), d, gc,
					   pcurrent.x, pcurrent.y,
					   q.x, q.y);
				pcurrent = q;
			}
		}
	}
}

#define CLOSE (5 * (offset_x + offset_y + 1) / 2)

static int
SplineCheck (x, y, offset_x, offset_y, p, n)
int x;
int y;
int offset_x, offset_y; 
register XPoint *p;
int n;
{
	register long w, t1, t2, t3; 
	register int i, j; 
	XPoint q;
	
	if (p != (XPoint *) NULL)
	{
		for (i = 0; i < n - 1; i++)
		{
			for (j = 0; j < STEPS; j++)
			{
				w = SCALE * j / STEPS;
				t1 = w * w / (2 * SCALE);
				w = w - SCALE / 2;
				t2 = 3 * SCALE / 4 - w * w / SCALE;
				w = w - SCALE / 2;
				t3 = w * w / (2 * SCALE);
				q.x = offset_x +
					(t1 * p[i+2].x + t2 * p[i+1].x +
					 t3 * p[i].x + SCALE / 2) / SCALE;
				q.y = offset_y +
					(t1 * p[i+2].y + t2 * p[i+1].y +
					 t3 * p[i].y + SCALE / 2) / SCALE;
				if (x >= q.x - CLOSE && x <= q.x + CLOSE &&
				    y >= q.y - CLOSE && y <= q.y + CLOSE)
					return TRUE;
			}
		}
	}
	return FALSE;
}
