static char TMxnet6_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/StaticText.h>
#include <Xol/OlStrings.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/ScrollBar.h>
#include <Xw/BBoard.h>
#include <Xw/Valuator.h>
#include <Xw/Arrow.h>
#include <Xw/SWindow.h>
#endif /* HP_WIDGETS */

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#endif /* MOTIF */

#include "Net.h"
#include <math.h>

#define MAX(a,b)	((a > b) ? a : b)
#define MIN(a,b)	((a < b) ? a : b)

enum { MARY, HAD, A, LITTLE, LAMB };

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
main C_P_ARGS((int argc, char **argv));

static XtCallbackProc
net_point C_P_ARGS((NetWidget w, caddr_t closure, NetCallbackData *data));

C_PROTOS_END_EXTERN

void
main (argc, argv)
int argc;
char **argv;
{
	XtCallbackProc net_point ();
	static netNode nodes[14]; /* use static to get zero'ed memory */
	static netLink links[13];
	Arg args[10];
	int i;
	Widget toplevel, scrolledwindow, netwidget;
	XtCallbackRec toll_call[16];
	Pixel back;
	Pixmap background;
	int link_count = 0;


#ifdef OPENLOOK
	toplevel = OlInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#else
	toplevel = XtInitialize (argv[0], "Test", NULL, 0, &argc, argv);
#endif /* OPENLOOK */

	i = 0;
	XtSetArg (args[i], XtNwidth, 250); i++;
	XtSetArg (args[i], XtNheight, 250); i++;
#ifdef OPENLOOK
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						scrolledWindowWidgetClass,
						toplevel, args, i);
	/*
	 * patch for OpenWindows 3.0
	 */
	if (netwidget = XtNameToWidget (scrolledwindow, "BulletinBoard"))
	{
	    i = 0;
	    XtSetArg (args[i], XtNlayout, OL_MINIMIZE); i++;
	    XtSetValues (netwidget, args, i);
	}
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						XwswindowWidgetClass,
						toplevel, args, i);
#endif /* HP_WIDGETS */

#ifdef MOTIF
	XtSetArg (args[i], XmNscrollingPolicy, XmAUTOMATIC); i++;
        XtSetArg (args[i], XmNvisualPolicy, XmVARIABLE); i++;
	scrolledwindow = XtCreateManagedWidget ("ScrolledWindow",
						xmScrolledWindowWidgetClass,
						toplevel, args, i);
#endif /* MOTIF */

	nodes[MARY].type = 0 /*NETBOXSYMBOL*/;
	nodes[MARY].pf.x = 0.20;
	nodes[MARY].pf.y = 0.20;
	nodes[MARY].title.name = (char *) NULL;
	nodes[MARY].symbol.name = "Mary";
	nodes[MARY].next = &nodes[1];

	nodes[HAD].type = 0 /*NETBOXSYMBOL*/;
	nodes[HAD].pf.x = 0.35;
	nodes[HAD].pf.y = 0.20;
	nodes[HAD].title.name = (char *) NULL;
	nodes[HAD].symbol.name = "had";
	nodes[HAD].next = &nodes[2];

	nodes[A].type = 0 /*NETBOXSYMBOL*/;
	nodes[A].pf.x = 0.50;
	nodes[A].pf.y = 0.20;
	nodes[A].title.name = (char *) NULL;
	nodes[A].symbol.name = "a";
	nodes[A].next = &nodes[3];

	nodes[LITTLE].type = 0 /*NETBOXSYMBOL*/;
	nodes[LITTLE].pf.x = 0.65;
	nodes[LITTLE].pf.y = 0.20;
	nodes[LITTLE].title.name = (char *) NULL;
	nodes[LITTLE].symbol.name = "little";
	nodes[LITTLE].next = &nodes[4];

	nodes[LAMB].type = 0 /*NETBOXSYMBOL*/;
	nodes[LAMB].pf.x = 0.80;
	nodes[LAMB].pf.y = 0.20;
	nodes[LAMB].title.name = (char *) NULL;
	nodes[LAMB].symbol.name = "lamb.";
	nodes[LAMB].next = &nodes[5];

	nodes[5].type = 0 /*NETBOXSYMBOL*/;
	nodes[5].pf.x = 0.45;
	nodes[5].pf.y = 0.70;
	nodes[5].title.name = (char *) NULL;
	nodes[5].symbol.name = "S";
	nodes[5].next = &nodes[6];

	nodes[6].type = 0 /*NETBOXSYMBOL*/;
	nodes[6].pf.x = nodes[MARY].pf.x;
	nodes[6].pf.y = 0.30;
	nodes[6].title.name = (char *) NULL;
	nodes[6].symbol.name = "NP";
	nodes[6].next = &nodes[7];

	links[link_count].type = 0;
	links[link_count].A = &nodes[5];
	links[link_count].B = &nodes[6];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	links[link_count].type = 0;
	links[link_count].A = &nodes[6];
	links[link_count].B = &nodes[MARY];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[7].type = 0 /*NETBOXSYMBOL*/;
	nodes[7].pf.x = 0.5;
	nodes[7].pf.y = 0.60;
	nodes[7].title.name = (char *) NULL;
	nodes[7].symbol.name = "VP";
	nodes[7].next = &nodes[8];

	links[link_count].type = 0;
	links[link_count].A = &nodes[5];
	links[link_count].B = &nodes[7];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[8].type = 0 /*NETBOXSYMBOL*/;
	nodes[8].pf.x = nodes[HAD].pf.x;
	nodes[8].pf.y = 0.30;
	nodes[8].title.name = (char *) NULL;
	nodes[8].symbol.name = "V";
	nodes[8].next = &nodes[9];

	links[link_count].type = 0;
	links[link_count].A = &nodes[7];
	links[link_count].B = &nodes[8];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	links[link_count].type = 0;
	links[link_count].A = &nodes[8];
	links[link_count].B = &nodes[HAD];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[9].type = 0 /*NETBOXSYMBOL*/;
	nodes[9].pf.x = 0.625;
	nodes[9].pf.y = 0.50;
	nodes[9].title.name = (char *) NULL;
	nodes[9].symbol.name = "NP";
	nodes[9].next = &nodes[10];

	links[link_count].type = 0;
	links[link_count].A = &nodes[7];
	links[link_count].B = &nodes[9];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[10].type = 0 /*NETBOXSYMBOL*/;
	nodes[10].pf.x = nodes[A].pf.x;
	nodes[10].pf.y = 0.30;
	nodes[10].title.name = (char *) NULL;
	nodes[10].symbol.name = "DET";
	nodes[10].next = &nodes[11];

	links[link_count].type = 0;
	links[link_count].A = &nodes[9];
	links[link_count].B = &nodes[10];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	links[link_count].type = 0;
	links[link_count].A = &nodes[10];
	links[link_count].B = &nodes[A];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[11].type = 0 /*NETBOXSYMBOL*/;
	nodes[11].pf.x = 0.725;
	nodes[11].pf.y = 0.40;
	nodes[11].title.name = (char *) NULL;
	nodes[11].symbol.name = "N(bar)";
	nodes[11].next = &nodes[12];

	links[link_count].type = 0;
	links[link_count].A = &nodes[9];
	links[link_count].B = &nodes[11];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[12].type = 0 /*NETBOXSYMBOL*/;
	nodes[12].pf.x = nodes[LITTLE].pf.x;
	nodes[12].pf.y = 0.30;
	nodes[12].title.name = (char *) NULL;
	nodes[12].symbol.name = "A";
	nodes[12].next = &nodes[13];

	links[link_count].type = 0;
	links[link_count].A = &nodes[11];
	links[link_count].B = &nodes[12];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	links[link_count].type = 0;
	links[link_count].A = &nodes[12];
	links[link_count].B = &nodes[LITTLE];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	nodes[13].type = 0 /*NETBOXSYMBOL*/;
	nodes[13].pf.x = nodes[LAMB].pf.x;
	nodes[13].pf.y = 0.30;
	nodes[13].title.name = (char *) NULL;
	nodes[13].symbol.name = "N";
	nodes[13].next = (netNode *) NULL;

	links[link_count].type = 0;
	links[link_count].A = &nodes[11];
	links[link_count].B = &nodes[13];
	links[link_count].next = &links[link_count + 1];
	link_count++;

	links[link_count].type = 0;
	links[link_count].A = &nodes[13];
	links[link_count].B = &nodes[LAMB];
	links[link_count].next = (netLink *) NULL;

	XtSetArg (args[0], XtNbackground, &back);
	XtGetValues (toplevel, args, 1);
	background = XwCreateTile (XtScreen (toplevel),
				   WhitePixel (XtDisplay (toplevel), 0),
				   back,
				   XwBACKGROUND);
	i = 0;
	XtSetArg (args[i], XtNnetNodeList, nodes); i++;
	XtSetArg (args[i], XtNnetLinkList, links); i++;
	XtSetArg (args[i], XtNwidth, 350); i++;
	XtSetArg (args[i], XtNheight, 350); i++;
	XtSetArg (args[i], XtNnetDrawSymbolBackground, TRUE); i++;
	XtSetArg (args[i], XtNnetSymbolBackgroundPixmap, background); i++;
	toll_call[0].callback = (XtCallbackProc) net_point;
	toll_call[0].closure = (caddr_t) NULL;
	toll_call[1].callback = (XtCallbackProc) NULL;
	toll_call[1].closure = NULL;
	XtSetArg (args[i], XtNnetProcPoint, toll_call); i++;

	netwidget = XtCreateManagedWidget (argv[0],
					   netWidgetClass,
					   scrolledwindow,
					   args, i);

	XtRealizeWidget (toplevel);

	XtMainLoop ();
}

static XtCallbackProc
net_point (w, closure, data)
NetWidget w;
caddr_t closure;
NetCallbackData *data;
{
	if (data -> data_type == NETSYMBOL) /* skip all but symbols */
		printf ("x=%f,y=%f\n",
			data -> selected_node -> pf.x,
			data -> selected_node -> pf.y);
}
