static char TMSMRaster_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

/*
 * this is a modified version of HP's static raster widget.  This
 * widget is a static magnifed raster (cough).  It differs in two ways
 * from the widget as it was originally shipped by HP.  The update
 * routine has been touched up a bit to improve its performance.
 * Routines have been added to handle magnification and "minification"
 * based on the magnification resource.
 *
 * Blewett AT&T
 */

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        SMRaster.c
 **
 **   Project:     X Widgets (Part II)
 **
 **   Description: Code/Definitions for Static Raster Widget
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *****************************************************************************/


/*
 * Include files & Static Routine Definitions
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>

#ifdef OPENLOOK
#include <Xol/OpenLook.h>
#include <Xol/Font.h>
#endif /* OPENLOOK */

#ifdef HP_WIDGETS
#include <Xw/Xw.h>
#include <Xw/XwP.h>
#endif /* HP_WIDGETS */

#include "SMRaster.h"
#include "SMRasterP.h"

#define MIN(x, y)		((x) <= (y) ? (x) : (y))
#define MAX(x, y)		((x) >= (y) ? (x) : (y))

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static void
ClassInitialize C_P_NO_ARGS();

static double
SMRatof C_P_ARGS((char *ptr));

static void
InitSMRaster C_P_ARGS((XwSMRasterWidget request, XwSMRasterWidget new,
		       ArgList args, Cardinal *p_num_args));

static void
Realize C_P_ARGS((XwSMRasterWidget w, Mask *p_valueMask,
		  XSetWindowAttributes *attributes));

static void
ShowSR C_P_ARGS((XwSMRasterWidget w, XExposeEvent *event, GC gc));

static void
draw_image C_P_ARGS((XwSMRasterWidget w, GC gc, XImage *image, int mag,
		     int src_x, int src_y, int WOffset, int HOffset,
		     int width, int height));

static void
magnify C_P_ARGS((XwSMRasterWidget w, GC gc, XImage *image, int mag,
		  int src_x, int src_y, int WOffset, int HOffset,
		  int width, int height));

static void
SMRasterDestroy C_P_ARGS(( XwSMRasterWidget srw));

static void
Select C_P_ARGS((XwSMRasterWidget w, XEvent *event));

static void
Release C_P_ARGS((XwSMRasterWidget w, XEvent *event));

/*  Boolean last promoted to int */
static Boolean
SetValues C_P_ARGS((Widget current, Widget request, Widget new,
		    C_Promoted_Boolean last));

static void
SMRExpose C_P_ARGS((XwSMRasterWidget w, XExposeEvent *event));

static void
BuildNormGC C_P_ARGS((XwSMRasterWidget srw));

static void
BuildInvGC C_P_ARGS((XwSMRasterWidget srw));

extern void
UnmapSMRasterWidget C_P_ARGS((XwSMRasterWidget w));

extern void
MapSMRasterWidget C_P_ARGS((XwSMRasterWidget w));

static XImage *
LocalCreateImage C_P_ARGS((Display *display, int out_width, int out_height));

C_PROTOS_END_EXTERN

/****************
 *
 * Translation Tables.
 *
 ****************/

static char defaultTranslations[] = 
#ifdef HP_WIDGETS
    "<EnterWindow>:     enter()\n\
     <LeaveWindow>:     leave()\n\
     <Btn1Down>:        select()\n\
     <Btn1Up>:          release()\n\
     <KeyDown>Select:   select() \n\
     <KeyUp>Select:     release()";
#else
    "<Btn1Down>:        select()\n\
     <Btn1Up>:          release()\n\
     <KeyDown>Select:   select() \n\
     <KeyUp>Select:     release()";
#endif /* HP_WIDGETS */


static XtActionsRec actionsList[] =
{
#ifdef HP_WIDGETS
  { "enter",   (XtActionProc) _XwPrimitiveEnter   },
  { "leave",   (XtActionProc) _XwPrimitiveLeave   },
#endif /* HP_WIDGETS */
  { "select",  (XtActionProc) Select  },
  { "release", (XtActionProc) Release },

};



/*************************************<->*************************************
 *
 *   Resource List.
 *
 *   Provides default resource settings for instances of this class.
 *   To get full set of default settings, examine resouce list of super
 *   classes of this class.
 *
 *
 *************************************<->***********************************/

static XtResource resources[] =
{
   {
     XtNsRimage, XtCSRimage, XtRImage, sizeof(XImage *),
     XtOffset (XwSMRasterWidget, smraster.image),
     XtRImage, NULL
   },
   {
     XtNinvertOnSelect, XtCInvertOnSelect, XtRBoolean, sizeof(Boolean),
     XtOffset (XwSMRasterWidget, smraster.invert),
     XtRString,"TRUE"
   },
   {
     XtNshowSelected, XtCShowSelected, XtRBoolean, sizeof(Boolean),
     XtOffset (XwSMRasterWidget, smraster.showme),
     XtRString,"TRUE"
   },
   {
     XtNset, XtCSet, XtRBoolean, sizeof(Boolean),
     XtOffset (XwSMRasterWidget, smraster.poked),
     XtRString,"FALSE"
   },
   {
     XtNsMRmagnification, XtCSMRmagnification, XtRString,
     sizeof (String), XtOffset (XwSMRasterWidget, smraster.magstr),
     XtRString, "1"
   },
#ifndef HP_WIDGETS
   {
     XtNselect, XtCCallback, XtRCallback, sizeof(caddr_t),
     XtOffset (XwSMRasterWidget, smraster.select),
     XtRPointer, (caddr_t) NULL
   },

   {
     XtNrelease, XtCCallback, XtRCallback, sizeof(caddr_t),
     XtOffset (XwSMRasterWidget, smraster.release),
     XtRPointer, (caddr_t) NULL
   },
#endif
};



/*************************************<->*************************************
 *
 *   StaticRaster Class Structure
 *
 *************************************<->***********************************/

SMRasterClassRec smrasterClassRec =
{
   {
#ifdef HP_WIDGETS
	(WidgetClass) &XwprimitiveClassRec,	/* superclass            */
#else
	(WidgetClass) &(widgetClassRec),	/* superclass		 */
#endif /* HP_WIDGETS */
      "StaticRaster",                   /* class_name	     */	
      sizeof(SMRasterRec),              /* widget_size	     */	
      ClassInitialize,                  /* class_initialize  */    
      NULL,		                /* class_part_initialize  */    
      FALSE,                            /* class_inited      */	
      (XtInitProc) InitSMRaster,        /* initialize	     */	
      NULL,                             /* initialize hook   */
      (XtRealizeProc) Realize,          /* realize	     */	
      actionsList,                      /* actions           */	
      XtNumber(actionsList),            /* num_actions	     */	
      resources,                        /* resources	     */	
      XtNumber(resources),              /* num_resources     */	
      NULLQUARK,                        /* xrm_class	     */	
      TRUE,                             /* compress_motion   */	
      TRUE,                             /* compress_exposure */
      TRUE,                             /* compress_enterleave */
      FALSE,                            /* visible_interest  */	
      (XtWidgetProc) SMRasterDestroy,   /* destroy           */	
      NULL,                             /* resize            */	
      (XtExposeProc) SMRExpose,         /* expose            */	
      (XtSetValuesFunc) SetValues,      /* set_values	         */	
      NULL,                             /* set_values_hook       */
      XtInheritSetValuesAlmost,         /* set_values_almost     */
      NULL,                             /* get_values_hook       */
      NULL,                             /* accept_focus	         */	
      XtVersion,                        /* version               */
      NULL,                             /* callback private      */
      defaultTranslations,              /* tm_table              */
      NULL,                             /* query_geometry        */
   },
#ifdef HP_WIDGETS
   {
      NULL,         /* Primitive border_highlight   */
      NULL,         /* Primitive border_unhighlight */
      NULL,         /* Primitive select_proc        */
      NULL,         /* Primitive release_proc       */
      NULL,         /* Primitive toggle_proc        */
   },
#endif /* HP_WIDGETS */
   {
       0,         /* Static Raster class part - unused */
   },
};

WidgetClass XwsmrasterWidgetClass = (WidgetClass) &smrasterClassRec;
WidgetClass XwstaticMagnifyingRasterWidgetClass = (WidgetClass) &smrasterClassRec;



/************************************************************************
 *
 *  ClassInitialize
 *
 *   Description:
 *   -----------
 *    Set fields in primitive class part of our class record so that
 *    the traversal code can invoke our select/release procedures (note
 *    that for this class toggle is a empty proc).
 *
 *************************************<->***********************************/
static void
ClassInitialize()
{
#ifdef HP_WIDGETS
   smrasterClassRec.primitive_class.select_proc = (XtWidgetProc) Select;
   smrasterClassRec.primitive_class.release_proc = (XtWidgetProc) Release;
   smrasterClassRec.primitive_class.toggle_proc = (XtWidgetProc) NULL;
#endif /* HP_WIDGETS */
}


/*************************************<->*************************************
 *
 *  InitSMRaster
 *
 *   Description:
 *   -----------
 *     This is the static raster instance initialize procedure. 
 *     It sets up the appropriate graphic contexts and looks for a 0,0
 *     size. If the core size is 0,0, the dimensions are reset to the
 *     image height and width.
 *
 *   Inputs:
 *   ------
 *     request  = original instance record;
 *
 *     new      = instance record with modifications induced by
 *                other initialize routines, changes are made to this
 *                record;
 *
 *     args     = argument list specified in XtCreateWidget;
 *
 *     num_args = argument count;
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *
 *************************************<->***********************************/

static double
SMRatof (ptr)
char *ptr;
{
    extern double atof ();
    double x;
    long lx;

    x = atof (ptr);
    if (x < 0.0)
	x = -x;
    if (x >= 1.0)
    {
	lx = x;
	x = lx;
    }
    if (x == 0.0)
	x = 1.0;
    if (x > 99.0)
	x = 99.0;
    return x;
}

static void
InitSMRaster (request, new, args, p_num_args)
XwSMRasterWidget request, new;
ArgList args;
Cardinal *p_num_args;
{
    char *ptr;

    request -> smraster.magnification = SMRatof (request -> smraster.magstr);
    sprintf (request -> smraster.magstr_store, "%.2f",
	     request -> smraster.magnification);
    request -> smraster.magstr = request -> smraster.magstr_store;
    ptr = &request -> smraster.magstr[strlen (request -> smraster.magstr) - 1];
    while (*ptr == '0')
    {
	*ptr = '\0';
	ptr--;
    }
    if (*ptr == '.')
	*ptr = '\0';

    new -> smraster.magnification = SMRatof (new -> smraster.magstr);
    sprintf (new -> smraster.magstr_store, "%.2f",
	     new -> smraster.magnification);
    new -> smraster.magstr = new -> smraster.magstr_store;
    ptr = &new -> smraster.magstr[strlen (new -> smraster.magstr) - 1];
    while (*ptr == '0')
    {
	*ptr = '\0';
	ptr--;
    }
    if (*ptr == '.')
	*ptr = '\0';

    new -> smraster.smallimage = (XImage *) NULL;

    if (request->core.width == 0)
	if (request->smraster.image != NULL)
	    new->core.width += (request->smraster.image->width *
				request->smraster.magnification);
	else
	    new->core.width += 10;

    if (request->core.height == 0 )
        if (request->smraster.image != NULL)
	    new->core.height += (request->smraster.image->height *
				 request->smraster.magnification);
	else
	    new->core.height += 10;

    if (new->smraster.image && new->smraster.image->data &&
	new->smraster.magnification < 1.0)
    {
	XImage *out;
	int width;
	int height;

	width = new -> smraster.image -> width *
	    new->smraster.magnification + 0.5;
	height = new -> smraster.image -> height *
	    new->smraster.magnification + 0.5;
	    
	out = LocalCreateImage (XtDisplay (new), width, height);
	    
	if (out != (XImage *) NULL)
	{
	    SampleImage (new -> smraster.image, out);
	    new -> smraster.smallimage = out;
	}
    }
    
    BuildInvGC(new);
    BuildNormGC(new);
}


/*************************************<->*************************************
 *
 *  Realize
 *
 *   Description:
 *   -----------
 *     Creates the window for this static raster instance.  Sets bit gravity
 *     so that on resize static raster is repainted.
 *
 *   Inputs:
 *   ------
 *     w  =  widget to be realized.
 *
 *     valueMask = contains event mask for this window/widget.
 *
 *     attributes = window attributes for this window/widget.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XCreateWindow()
 *************************************<->***********************************/

static void
Realize(w, p_valueMask, attributes)
register XwSMRasterWidget w;
Mask *p_valueMask;
XSetWindowAttributes *attributes;
{

    Mask valueMask = *p_valueMask;

    valueMask |= CWBitGravity;
    attributes->bit_gravity = ForgetGravity;

    XtCreateWindow((Widget) w,InputOutput, (Visual *)CopyFromParent,
		   valueMask, attributes);
    w->smraster.ismapped = True;
}


/****************************************************************
 *
 *  ShowSR
 *
 *   Description:
 *   -----------
 *     Redraw the static raster image. If the window we are trying to fit in
 *     is too small, the image is clipped. If it's too big, the image is
 *     centered within the window.
 *
 *   Inputs:
 *   ------
 *     w  =  widget to be drawn.
 *     event = XEvent structure
 *     gc = GC to use
 ****************************************************************/
static void
ShowSR(w, event, gc)
register  XwSMRasterWidget w;
XExposeEvent *event;
GC gc;
{
    int dst_x;
    int dst_y;
    int display_width;
    int display_height;
    int image_width;
    int image_height;
    int src_x = 0;
    int src_y = 0;

    if (w -> smraster.ismapped == False ||
	w -> smraster.image == NULL ||
	w -> smraster.image -> data == NULL ||
	XtIsRealized ((Widget) w) == False)
	return;

    if (w -> smraster.magnification < 1.0)
    {
	display_width = w -> smraster.smallimage -> width;
	display_height = w -> smraster.smallimage -> height;
    }
    else
    {
	display_width = w -> smraster.image -> width *
	    w -> smraster.magnification + 0.5;
	display_height = w -> smraster.image -> height *
	    w -> smraster.magnification + 0.5;
    }

#ifdef HP_WIDGETS
    dst_y = dst_x = (int) w -> primitive.highlight_thickness;
#else
    dst_y = dst_x = 0;
#endif /* HP_WIDGETS */

    image_width = display_width + (dst_x * 2);
    image_height = display_height + (dst_y * 2);

    /*
     * If the width and height aren't exact matches,
     * then clip or center as needed.
     */
    
    if (image_width != w -> core.width)
    {
	if (image_width < (int) w -> core.width) /* Too small - center it */
	    dst_x += ((int) w -> core.width - image_width) / 2;
	else			/* Clip it */
	    display_width = w -> core.width - (dst_x * 2);
    }
    if (image_height != w -> core.height)
    {
	if (image_height < (int) w -> core.height) /* Too small - center it */
	    dst_y += ((int) w -> core.height - image_height) / 2;
	else			/* Clip it */
	    display_height = w -> core.height - (dst_y * 2);
    }
    
    if (event && event -> type == Expose)
    {
	int delta;

	if (dst_x < event -> x)
	{
	    delta = event -> x - dst_x;
	    dst_x = event -> x;
	    src_x += delta;
	    display_width -= delta;
	    if (display_width <= 0)
		return;
	}
	if (dst_y < event -> y)
	{
	    delta = event -> y - dst_y;
	    dst_y = event -> y;
	    src_y += delta;
	    display_height -= delta;
	    if (display_height <= 0)
		return;
	}

	if ((event -> x + event -> width) < (src_x + display_width))
	    display_width = (event -> x + event -> width) - src_x;
	if ((event -> y + event -> height) < (src_y + display_height))
	    display_height = (event -> y + event -> height) - src_y;
    }

    if (w -> smraster.magnification == 1.0 ||
	w -> smraster.magnification == 0.0)
    {
	XPutImage (XtDisplay (w), XtWindow (w), gc, w -> smraster.image,
		   src_x, src_y, dst_x, dst_y,
		   display_width, display_height);
    }
    else if (w -> smraster.magnification < 1.0)
    {
	XPutImage (XtDisplay (w), XtWindow(w), gc,
		   w -> smraster.smallimage,
		   src_x, src_y, dst_x, dst_y,
		   display_width, display_height);
    }
    else
    {
	magnify (w, gc, w -> smraster.image,
		 (int) (w -> smraster.magnification + 0.5),
		 src_x, src_y,
		 dst_x, dst_y,
		 display_width, display_height);
    }

#ifdef HP_WIDGETS
    /*
     * We don't want to lose the highlight on redisplay
     * do we?
     */
    if (w -> primitive.highlighted)
    {
	_XwHighlightBorder(w);
	w -> primitive.display_highlighted = TRUE;
    }
    else if (w -> primitive.display_highlighted)
    {
	_XwUnhighlightBorder(w);
	w -> primitive.display_highlighted = FALSE;
    }
#endif /* HP_WIDGETS */
}

#define DATASIZ		(32 * 1024)

static void
draw_image (w, gc, image, mag,
	    src_x, src_y,
	    WOffset, HOffset,
	    width, height)
XwSMRasterWidget w;
GC gc;
XImage *image;
int mag;
int src_x;
int src_y;
int WOffset;
int HOffset;
int width;
int height;
{
    register int i;
    register int j;
    int x;
    int y;
    int end_x;
    int end_y;
    register long bits;
    int screen = DefaultScreen (XtDisplay (w));
    XImage *large_image;
    static char *data = NULL;
    char *lptr;
    int lx;
    int end_lx;

    if (data == (char *) NULL &&
	(data = (char *) malloc (DATASIZ)) == (char *) NULL)
    {
	XtWarning ("Cannot allocate image space.\n");
	return;
    }
	
    lx = (image -> depth * width + 7) / 8;
    large_image = XCreateImage (XtDisplay (w),
				DefaultVisual (XtDisplay (w),
					       screen),
				image -> depth, 
				ZPixmap,
				0, /* Offset */
				data,
				width, height,
				8, /* line quantum */
				lx);
	
    if (large_image == (XImage *) NULL)
    {
	XtWarning ("Cannot allocate image space.\n");
	return;
    }
	
    lptr = data;
    end_y = (src_y + height + mag - 1) / mag;
    if (end_y > image -> height)
	end_y = image -> height;
    end_x = (src_x + width + mag - 1) / mag;
    if (end_x > image -> width)
	end_x = image -> width;
    for (j = src_y / mag, y = 0; j < end_y; j++, y += mag)
    {
	for (i = src_x / mag, x = 0; i < end_x; i++, x += mag)
	{
	    bits = (*image -> f.get_pixel) (image, i, j);
	    end_lx = x + mag;
	    for (lx = x; lx < end_lx; lx++)
		(*large_image -> f.put_pixel)
		    (large_image, lx, y, bits);
	}
		
	for (i = 1; (i < mag) && (y + i < height); i++)
	    memcpy (lptr + large_image -> bytes_per_line * i,
		    lptr, large_image -> bytes_per_line);
		
	lptr += (large_image -> bytes_per_line * mag);
    }
    XPutImage (XtDisplay(w), XtWindow(w), gc, large_image,
	       0, 0, WOffset, HOffset,
	       width, height);

    large_image -> data = (char *) NULL;
    XDestroyImage (large_image);
}

/*
 * The magnifier routine - this uses a very simple pixel replication
 * scheme.  DATASIZ is the size of the image data space.
 */

static void
magnify (w, gc, image, mag,
	 src_x, src_y,
	 WOffset, HOffset,
	 width, height)
XwSMRasterWidget w;
GC gc;
XImage *image;
int mag;
int src_x;
int src_y;
int WOffset;
int HOffset;
int width;
int height;
{
    register int i;
    register int j;
    int x;
    int y;

    i = (src_x % mag);
    src_x -= i;
    width += i;
    WOffset -= i;
    i = (src_y % mag);
    src_y -= i;
    height += i;
    HOffset -= i;
	
    if (image -> depth > 1)
    {
	int len;
	int lx;

	lx = (image -> depth * width + 7) / 8;
	len = lx * height;
		
	if (len > DATASIZ)
	{
	    int dy;

	    if ((DATASIZ / lx) < mag)
	    {
		magnify (w, gc, image, mag,
			 src_x, src_y,
			 WOffset, HOffset,
			 width / 2, height);
		magnify (w, gc, image, mag,
			 src_x + width / 2, src_y,
			 WOffset + width / 2, HOffset,
			 (width + 1) / 2, height);
		return;
	    }

	    i = DATASIZ / lx;
	    for (j = 0; j < height; j += i)
	    {
		draw_image (w, gc, image, mag,
			    src_x, src_y,
			    WOffset, HOffset,
			    width,
			    (j + i < height) ? i : (height - j));

		HOffset += i;
		src_y += i;
		dy = (src_y % mag);
		if (dy < i)
		{
		    src_y -= dy;
		    height += dy;
		    HOffset -= dy;
		}

	    }
	    return;
	}
	draw_image (w, gc, image, mag, src_x, src_y, WOffset, HOffset,
		    width, height);
    }
    else
    {
	int end_x;
	int end_y;
	register long bits;
	register long obits;
	int count, starting_x;
	int screen = DefaultScreen (XtDisplay ((Widget) w));
	long white = WhitePixel (XtDisplay ((Widget) w), screen);

	end_y = (src_y + height + mag - 1) / mag;
	if (end_y > image -> height)
	    end_y = image -> height;
	end_x = (src_x + width + mag - 1) / mag;
	if (end_x > image -> width)
	    end_x = image -> width;

	for (j = src_y / mag, y = src_y; j < end_y;
	     j++, y += mag)
	{
	    obits = (*image -> f.get_pixel) (image, src_x / mag, j);
	    count = 0;
	    starting_x = src_x;
	    for (i = src_x / mag, x = src_x; i < end_x;
		 i++, x += mag)
	    {
		bits = (*image -> f.get_pixel) (image, i, j);
		if (bits == obits)
		{
		    if (count == 0)
			starting_x = x;
		    count++;
		}
		else if (count)
		{
		    if (obits != white)
			XFillRectangle (XtDisplay((Widget) w),
					XtWindow ((Widget) w),
					gc,
					starting_x, y,
					count * mag,
					mag);
		    count = 1;
		    starting_x = x;
		    obits = bits;
		}
	    }
	    if (count && obits != white)
		XFillRectangle (XtDisplay((Widget) w),
				XtWindow ((Widget) w),
				gc,
				starting_x, y,
				count * mag,
				mag);
	}
    }
}

/*************************************<->*************************************
 *
 *  SMRasterDestroy
 *
 *   Description:
 *   -----------
 *     Free up the GC's and stuff on destroy.
 *
 *************************************<->***********************************/
static void
SMRasterDestroy (srw)
  XwSMRasterWidget srw;
{
   XtDestroyGC (srw->smraster.NormalGC);
   XtDestroyGC (srw->smraster.InverseGC);
}


/****************************************************************
 *
 *  Event Routines.
 *
 *       Select - Call the callback when the left button goes down.
 *
 *       Release - Call the callback when the left button goes up.
 *
 ****************************************************************/


static void
Select(w,event)
XwSMRasterWidget w;
XEvent *event;
{
    w->smraster.poked = TRUE;
    if (w->smraster.invert)
	ShowSR(w,NULL,w->smraster.InverseGC);
	
    XtCallCallbacks((Widget) w,XtNselect,event);
}

static void
Release(w,event)
XwSMRasterWidget w;
XEvent *event;
{
    w->smraster.poked = FALSE;
    if (w->smraster.invert)
	ShowSR(w,NULL,w->smraster.NormalGC);

    XtCallCallbacks((Widget) w,XtNrelease,event);
}


/*************************************<->*************************************
 *
 *  SetValues(current, request, new, last)
 *
 *   Description:
 *   -----------
 *     This is the set values procedure for the static raster class.
 *
 *
 *   Inputs:
 *   ------
 *    current = original widget;
 *    request = copy of current (?);
 *    new = copy of request which reflects changes made to it by
 *          set values procedures of its superclasses;
 *    last = TRUE if this is the last set values procedure to be called.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *     XwGeomCheck;
 *************************************<->***********************************/

static Boolean
SetValues(current, request, new, last)
Widget current;
Widget request;
Widget new;
Boolean last;
{
    XwSMRasterWidget cw = (XwSMRasterWidget) current;
    XwSMRasterWidget nw = (XwSMRasterWidget) new;
    Boolean  flag = FALSE;	/* our return value */
    int ht; 
    char *ptr;

    ht = 0;

    /* First call the library routine to check geometry deltas */
    /*    flag = XwGeomCheck(cw,nw,last);*/
    
#ifdef HP_WIDGETS
    if (cw->primitive.foreground != nw->primitive.foreground ||
	cw->core.background_pixel != nw->core.background_pixel)
	flag = TRUE;
#else
    if (cw->core.background_pixel != nw->core.background_pixel)
	flag = TRUE;
#endif /* HP_WIDGETS */

    if (nw->smraster.magstr)
	nw -> smraster.magnification = SMRatof (nw -> smraster.magstr);
    else
	nw -> smraster.magnification = SMRatof (cw -> smraster.magstr_store);
    sprintf (nw -> smraster.magstr_store, "%.2f",
	     nw -> smraster.magnification);
    nw -> smraster.magstr = nw -> smraster.magstr_store;
    ptr = &nw -> smraster.magstr[strlen (nw -> smraster.magstr) - 1];
    while (*ptr == '0')
    {
	*ptr = '\0';
	ptr--;
    }
    if (*ptr == '.')
	*ptr = '\0';

    if ((cw -> smraster.magnification != nw -> smraster.magnification ||
	 cw -> smraster.image != nw -> smraster.image ||
	 cw -> smraster.image -> data != nw -> smraster.image -> data) &&
	nw -> smraster.magnification < 1.0 &&
	nw -> smraster.image != NULL && nw -> smraster.image -> data != NULL)
    {
	XImage *out;
	int width;
	int height;

	width = nw -> smraster.image -> width *
	    nw -> smraster.magnification + 0.5;
	height = nw -> smraster.image -> height *
	    nw -> smraster.magnification + 0.5;
	    
	out = LocalCreateImage (XtDisplay (nw), width, height);
	    
	if (out != (XImage *) NULL)
	{
	    SampleImage (nw -> smraster.image, out);
	    if (nw -> smraster.smallimage)
		XDestroyImage (nw -> smraster.smallimage);
	    nw -> smraster.smallimage = out;
	}
	else
	    nw->smraster.magnification = cw->smraster.magnification;
    }
    
    if (cw->smraster.magnification != nw->smraster.magnification ||
	cw->smraster.image != nw->smraster.image ||
	cw->smraster.image->data != nw->smraster.image->data 
#ifdef HP_WIDGETS
	|| nw->primitive.recompute_size
#endif /* HP_WIDGETS */
	)
    {
	int mag = nw->smraster.magnification;

	if (nw->smraster.magnification < 1.0)
	{
	    nw->core.width = nw->smraster.smallimage->width + ht;
	    nw->core.height = nw->smraster.smallimage->height + ht;
	}
	else
	{
	    nw->core.width = nw->smraster.image->width *
		mag + ht;
	    nw->core.height = nw->smraster.image->height *
		mag + ht;
	}
	flag = TRUE;
    }
    if (cw->smraster.invert != nw->smraster.invert)
	flag = TRUE;
    
    return flag;
}

static void
SMRExpose (w, event)
XwSMRasterWidget w;
XExposeEvent *event;
{
    ShowSR(w, event, w->smraster.NormalGC);
}


/*************************************<->*************************************
 *
 *  BuildNormGC(srw)
 *    XwSMRasterWidget  srw;
 *
 *   Description:
 *   -----------
 *      Uses the widget specific foreground to generate the "normal"
 *      graphic context.  Note that this is a XToolkit sharable GC.
 *      Creates the needed GC and sets ptr. in instance record.
 *
 *   Inputs:
 *   ------
 *     srw = widget instance.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XtGetGC
 *************************************<->***********************************/

static void
BuildNormGC(srw)
XwSMRasterWidget srw;
{
    XGCValues	values;

#ifdef HP_WIDGETS
    values.foreground	= srw->primitive.foreground;
#else
    values.foreground	= BlackPixelOfScreen(XtScreen(srw));
#endif /* HP_WIDGETS */
    values.background   = srw->core.background_pixel;
    values.line_width   = 1;

    srw->smraster.NormalGC = XtGetGC((Widget)srw,
				     GCForeground | GCBackground,
				     &values);
}

/*************************************<->*************************************
 *
 *  void BuildInvGC(srw)
 *          XwSMRasterWidget  srw;
 *
 *   Description:
 *   -----------
 *
 *   Inputs:
 *   ------
 *     srw = widget instance.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XwGetGC
 *************************************<->***********************************/

static void
BuildInvGC(srw)
XwSMRasterWidget srw;
{
    XGCValues	values;
    values.foreground	= srw->core.background_pixel;
#ifdef HP_WIDGETS
    values.background   = srw->primitive.foreground;
#endif /* HP_WIDGETS */
    srw->smraster.InverseGC = XtGetGC((Widget)srw,
#ifdef HP_WIDGETS
				      (unsigned) GCForeground |
				      (unsigned) GCBackground,
#else
				      (unsigned) GCForeground,
#endif /* HP_WIDGETS */
				      &values);
}

void
UnmapSMRasterWidget (w)
register XwSMRasterWidget w;
{
    w->smraster.ismapped = False;
    XtUnmapWidget (w);
}

void
MapSMRasterWidget (w)
register XwSMRasterWidget w;
{
    w->smraster.ismapped = True;
    XtMapWidget (w);
}

static XImage *
LocalCreateImage (display, out_width, out_height)
Display *display;
int out_width;
int out_height;
{
    XImage *out;
    int screen = DefaultScreen (display);
    int depth = DefaultDepth (display, screen);
    char *err_ptr = "Cannot allocate image space.";

    out = XCreateImage (display, DefaultVisual (display, screen),
			depth,
			(depth > 1) ? ZPixmap : XYPixmap,
			0,	/* offset */
			(char *) NULL,
			out_width, out_height,
			8,	/* bitmap quantum */
			0);

    if (out == (XImage *) NULL)
	XtError (err_ptr);

    out -> data = (char *) XtMalloc (out -> bytes_per_line *
				     out -> height);
    return out;
}
