'	\" indexing variables and functions
.nr IX 1	\" set to 1 to get index terms on page bottoms
.de XI	\" the index macro.  period.
.ie '\\n(.z'' .tm ix: \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9	\\nP
.el \\!.ix \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
....ie '\\n(.z'' .as IX "  \\$1 \\$2 \\$3  //
....el \\!.ix \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
..
'	\" load the picture macros
.so pictures
'	\" constant width macros
.de CW
.sp 0.1i
.DS L N
.in 0.25i
.ft CW
..
.de CN
.ft P
.in -0.25i
.sp 0.1i
.DE
..
'	\" boxed figures - parameters and .iS and .iE macros.
.nr iI 0.150i
.nr iO 0.075i
.nr iL \n(.lu-\n(iIu-\n(iIu+\n(iOu+\n(iOu
'
'	\" .iS title [1] [1] [1]
'	\" If $2 != 1, print the title in the upper RH corner.
'	\" If $3 == 1, use DF instead of DS.
'	\" If $4 == 1, print line numbers.
.de iS
.ne 8
.nr iX 0
.ds i1 \\$1
.nr i2 \\$2
.nr i3 \\$3
.nr i4 \\$4
.if \\n(i4=1 .nr iX \w'\f(CW00000\fP'
.br
.XI \\$1
.nf
.ft CW
.if \\n(i4=1 .nm 1 5 2
.di nG
..
.de iE
.if \\n(i4=1 .nm
.ft R
.fi
.br
.di
.nr || \\n(dnu+1v
.if \\n(||u>=\\n(.tu .bp
.ds iT "\|\|\f(CW\\*(i1\fR\|\|
.nr iG \w'\\*(iT'u
.if \\n(i4=1 .nr iL \\n(iL+\\n(iI
.if !\\n(i3=1 .br
.if !\\n(i3=1 .if !\\n(i2=1 .if (\\n(.i+\\n(.n+\\n(iG)<(\\n(.l-1.25i) .sp -.5
.if !\\n(i3=1 .DS
.if \\n(i3=1 .DF
.if !\\n(i4=1 .in +\n(iIu
.if !\\n(i2=1 \{\
.sp
\h'\\n(iLu-\n(iOu-\\n(iGu'\v'-0.075v'\\*(iT\v'0.075v'\h'-\\n(iGu'\L'-1'\l'\\n(iGu\(ul'\L'1'\}
.mk iS
.nG
.sp .15v
.mk iE
.nr iH \\n(iEu-\\n(iSu
.sp -1
\h'-\n(iOu+\\n(iXu'\L'-\\n(iHu'\l'(\\n(iLu-\\n(iXu)\(ul'\L'\\n(iHu'\l'(-\\n(iLu+\\n(iXu)\(ul'
.if !\\n(i4=1 .in -\n(iIu
.DE
.if \\n(i4=1 .nr iL \\n(iL-\\n(iI
..
.nr Cl 5
.PH ""
.PF ""
.S 24 26
.ce 4
Xtent Release 3.2:
A Messaging Protocol and
Specification Language for
X* Toolkit Based Applications
.sp
.PH "''- \\\\nP -''"
.S 16 18
.I
.ce 10
Doug Blewett
Bob Addessi
Scott Anderson
Connie Clark
Ken Hicks
Margaret Kilduff
Susan Udovic

AT&T Bell Laboratoris
Murray Hill, New Jersey
.sp
.S 10 12
.FS *
X Toolkit (Xt) and X Window System are trademarks of the Massachusetts
Institute of Technology.
.FE
.H 1 "Introduction: problems addressed by xtent"
We[9] have taken a ``software tools'' approach to writing graphics
applications.  By this statement we want to emphasize that we produce
applications from collections of reusable processes.  In implementing
this approach we were faced with two problems.  First we had to
actually write the reusable processes.  It is well known that writing
graphics applications is a very labor intensive task.  To get over
this ``startup hurdle'' we have created an executable specification
system that allows us to quickly produce X Toolkit (Xt)/widget[1,2]
.XI "toolkit"
based applications.  Unlike other specification systems, ours does
not limit applications to a subset of Xt functionality.  Any program
that can be written using Xt and widget libraries can be specified
with our system.
.P
The second problem we faced in our graphics software tools
environment was what to use as a common protocol for controlling
.XI "protocol"
these collections of processes.  Ideally a protocol should be terse,
efficient, reliable, and extensible.  Adding ``extensible'' to the
list usually breaks the other constraints.  The protocol we have
selected is that of a macro interpreter modeled around the syntax of X
.XI "syntax"
.XI "macro interpreter"
resource files.  Values stored in the per process resource database
.XI "resource database"
and resource values in widgets may be manipulated as strings.  As the
protocol is embodied in a simple programming language, expressions can
.XI "protocol"
be sent to be evaluated in the context of the remote graphics process.
Similarly, functions can be downloaded into a process to reduce the
need for distributing large quantities of data.
.P
Specification systems and protocols abound.  What makes the xtent
specification system and the xtent protocol somewhat unique is that
.XI "protocol"
they are both based on the same simple language.  This allows us to
incrementally or interactively develop Xt applications as well as
query and arbitrarily modify the state of running applications.  As
the system is based on a distributed protocol, we only need to port
the interprocess communication library to provide application
.XI "communication"
interfaces to other languages.  With Lisp, for example, we send xtent
.XI "using xtent with Lisp"
specifications to the Xt processes and return Lisp.  We do not have to
rewrite the widget and Xt libraries in Lisp.  The language provided by
xtent from our initial uses seems to be a good mix of the declarative,
specification based style and a traditional small programming
language.
.P
This is the fourth release of xtent.  As well as the usual bug fixes,
performance enhancements, and huge list of added functions and
features we have added the following:
.BL
.LI
Dot, ``.'', may be used in lieu of the program name.
\f(CWxtent.XtPrint:yes\fP becomes \f(CW.XtPrint:yes\fP.  This makes
the interface more terse and a bit easier to use interactively.
.LI
Widget sets \(en it is now much easier to add specific widgets and
switch widget sets.
.LI
Improved resource database format, formal parameters and locals,
renaming and copying of functions, application level inspection of the
call or argument stack, and program control and debugging features.
.LI
Improved handling of nested macros.
.LI
Programmer assists \(en too many to mention including a VARARGS style
function interface to the widget creation functions.
.LE
.P
We would like to thank the development groups that have worked so
diligently with us on the first release and those who tested and
advised us on the beta version for this release.
.P
As we mentioned above, the syntax of xtent is based on the X resource
.XI "syntax"
file format.  The resource file format has a number of benefits.  It
is important for us that the xtent application and end user interfaces
fit cleanly into the X world.  First of all, most X users are familiar
with the syntax and semantics of resource files.  Second the syntax is
simple, which makes it easy to write and quick to parse.  And finally, it
is portable across machine architectures.  The X resource file format
seems to be a good one for our purposes.
.P
The xtent system can be used in three forms: a stand alone
specification interpreter, a subroutine package for specifying
widgets, and/or as a subroutine package for use as a protocol
.XI "protocol"
converter.  The most popular use is as a stand alone specification
interpreter.  The examples that decorate this paper were produced with
the interpreter.  The interpreter can be used in concert with other
programs via the IPC mechanisms.  When used as a library, xtent may be
.XI "IPC"
used as a specification system for creating widgets or as an IPC
protocol handler.  When used as a specification system, applications
use xtent to handle the drudgery of manipulating widgets.  Once the
.XI "drudgery"
widgets are created, C functions may be used for callbacks and other
application specific processing.  xtent and C coexist well together.
As a protocol handler, xtent may be added to existing applications so
that the applications may be more easily reused.  We will cover these
three uses in more detail in the paper.
.P
In section 2 of this paper we will describe how xtent is used as a
specification system and as a protocol for
.XI "protocol"
interprocess communication.  Section 3 gives a more indepth view of
.XI "communication"
xtent as a language.  Section 4 lists the functions that are
supported by xtent.  Section 5 details the different methods for using
xtent.  This paper assumes that the reader has some familiarity with
the X graphics systems.  To use this paper as a manual for creating
widget based applications, the reader should also have a copy of the
X Toolkit Intrinsics manual and the man pages for the widgets that
.XI "toolkit"
will be used in the applications.  The Xt manual will be useful for
getting a detailed description of the toolkit functions.  The widget
man pages list and describe the widget resources.  xtent can be used
to examine the widget resource list, but the manual is required for
the detailed description.
.br
.BP snap.ps 4.69 6.00 c 0 "" "\f3Figure \n+(Fg.\fP  xtent based applications."
.EP
.H 1 "xtent as a Specification System"
.XI "xtent specifications"
Unfortunately there is no hard and fast definition for specification
systems.  Generally they are systems that allow for applications to be
described at a higher level of abstraction and/or faster than would
normally occur by directly programming them.  Specification systems
usually have a declarative rather than procedural style.
Specification systems are usually based in something that could be
called a language, albeit usually one lacking for doing traditional
programming.
.H 2 "Using X Resources for Function Call Based Specifications"
All X programs use X resources.  They are \fIthe\fP method for
parameterizing X based programs.  Each X application contains a simple
in memory resource database which is consulted for initializing
graphic objects.  The resources themselves resemble C structured data
types.  The following is a sample of five resource database input
lines:
.CW
    red: #FF0000

    A.B.x: 10
    A.B.y: 9
    A.B.color: green
    A*Sensitive: True
.CN
.ne 3
The first line sets the variable \f(CWred\fP to the string
\f(CW#FF0000\fP.  The next four lines create a \f(CWB\fP structure
within a structure \f(CWA\fP.  The \f(CWB\fP structure includes x and y
values and a color.  The last entry says that under the \f(CWA\fP
structure, any structure that contains a \f(CWSensitive\fP element set
the default value to \f(CWTrue\fP.
.P
.XI "xtent specifications"
X resource files meet the declarative and high level criteria for a
specification language.  X resource files are in fact at a much higher
level of abstraction than the equivalent C code.  The following piece
of resource code is a good example:
.CW
    *font: 6x13B
.CN
This line will result in the font \f(CW6x13B\fP being used wherever
.XI "font"
a font is required, but not explicitly specified (within Xt/widget
based applications).  Of course, this sort of parameterization is
inherently declarative.
.P
The resource mechanism is definitely limited in terms of its use as a
programming language.  We mean this to be humorous, as resource files
.XI "humorous"
are not used by the majority of the X community for anything other
than specifying parameters.  The parameterization, however, has a simple
object-oriented style that can be extended for programming.  Consider
the following line:
.CW
    xtent.allowShellResize: True
.CN
This line allows the toplevel window (actually shell widget) to be
.XI "toplevel widget"
resized when it is required by the application.  The sense of the line
is to set a variable, \f(CWallowShellResize\fP, associated with the
application \f(CWxtent\fP to \f(CWTrue\fP.  Notice that this implies
that the string \f(CWTrue\fP will be converted to an appropriate type.
In object-oriented terms, one could also say, that the
\f(CWallowShellResize\fP procedure associated with the object
\f(CWxtent\fP is called with or sent the message \f(CWTrue\fP.
.XI "function arguments as messages"
.P
This object/message notion can also be written in a style more closely
.XI "function arguments as messages"
matching that of C++:
.CW
    object.procedure: message (or arguments)
.CN
Using this syntax and semantics we have added all of the procedures
.XI "syntax"
required to do Xt level specifications (and then some).
\f(CWXtCreateManagedWidget()\fP, one of the functions used to create
widgets, might be used in applications as follows:
.CW
    xtent.Hello.XtCreateManagedWidget: pushButton
.CN
The line causes a widget with the name ``Hello'' to be created.  The
parent widget is the toplevel widget for the \f(CWxtent\fP
.XI "toplevel widget"
.XI "parent widget"
application.  The widget class is \f(CWpushButton\fP.  The C
interface to the X toolkit (Xt) uses the following function call to
create the widget.
.XI "widget class"
.XI "toolkit"
.CW
        Hello = XtCreateManagedWidget ("Hello",
                                       XwpushButtonWidgetClass,
                                       parent,
                                       args, arg-count);
.CN
The C based \f(CWXtCreateManagedWidget()\fP interface has four more
parameters.  Using the xtent format, the name is given on the left
hand or object side of the expression.  As widget names are
hierarchical*, the parent widget name is included in the widget name,
and so it
.XI "parent widget"
.FS *
The widgets in Xt applications form a tree-like data structure.  The
toplevel or shell widgets have child widgets, which may also have
.XI "toplevel widget"
children.  A pushbutton widget, within a form widget, within the
toplevel xtent widget might be specified by the following string,
\f(CWxtent.form.button\fP.
.FE
does not have to be provided.  In the C version, the \f(CWargs\fP
array is for setting widget resources.  The standard resource
mechanism handles that for us.  On a function by function basis, xtent
can be argued to be conceptually simpler.
.P
As an aside, the one line xtent entry above is all that is required to
specify a complete (one widget) Xt program.  The same program written
directly in C using the X toolkit takes about a page and a half of
.XI "toolkit"
code.  Using X alone takes 5 or 6 pages.
.P
Some Xt functions require more than one argument.  In those cases
xtent uses a syntax that is similar to that used by \f(CWC\fP.
.XI "syntax"
.CW
 xtent.image.XtTranslateCoords: (25, 33, x, y)
.CN
The line above calls the function \f(CWXtTranslateCoords()\fP for the
widget \f(CWxtent.image\fP.  It has four arguments.  The line above is
used to translate widget specific coordinates into display specific
coordinates.  \f(CWXtTranslateCoords\fP always takes four arguments.
However, some functions, for example \f(CWXtGetValues\fP take a
variable number of arguments.  These \f(CWVARARGS\fP style functions
are handled as they are in C.  Arguments are simply added by
separating the arguments by commas.
.P
xtent can be used to handle the arbitrary programming tasks.  See the
sections describing functions for program control, calculations,
string manipulation, and input and output.  The usual ``Hello World!''
example can be written as follows:
.CW
 xtent.XtPrint: Hello World!
.CN
xtent is of course best at manipulating widgets.

.H 2 "What's a Widget"
Widgets are graphical objects that behave something like processes.
Each application runs a list of widgets much as a workstation
operating system runs a list of processes.  Also as one may have many
copies of a single program running, one may have many copies of a
specific widget class, say a push button, running in a given
application.  The widgets execute or run when events occur (e.g.
keyboard or mouse input or redraw or exposure requests).  The
following is an application that copies all selections as they are
created.
.br
.BP clip.ps 2.77 5.00 c 0 "" "\f3Figure \n+(Fg.\fP  xtent electric clipboard."
.EP
Everything that is seen in the application above is a widget.
Printing the list of widgets allows us to look at the tree of widgets
that make up the application.  The first line below runs the file of
xtent commands and the second line tells xtent to print the list of
widgets.
.CW
    $ xtentol clipboard.xt
    xtent.XtPrintWidgets:
    \fIxtent.form\fP
    \fIxtent.form.buttons\fP
    \fIxtent.form.buttons.previous\fP
    \fIxtent.form.buttons.next\fP
    \fIxtent.form.buttons.delete\fP
    \fIxtent.form.buttons.pause\fP
    \fIxtent.form.buttons.continue\fP
    \fIxtent.form.buttons.exit\fP
    \fIxtent.form.sw\fP
    \fIxtent.form.sw.ScrolledWindowClipWindow\fP
    \fIxtent.form.sw.ScrolledWindowClipWindow.edit\fP
    \fIxtent.form.sw.VertScrollBar\fP
    \fIxtent.form.sw.HorScrollBar\fP
.CN
Each level of the dotted notation is a widget.  The first string,
\f(CWxtent\fP is the toplevel shell widget that is created by
initializing the application.  This string matches the program name.
The next two strings, \f(CWform\fP and \f(CWbuttons\fP, are composite
widgets, widgets that contain other widgets.  The buttons area is used
to contain the row of action buttons that controls the application.
The exit button on the far right of the screen, is
\f(CWxtent.form.buttons.exit\fP.  Notice that all widgets can be
described via this dotted notation and that it also matches the
notation used by the resource database.
.P
\f(CWxtent.form.sw\fP is a scrolled window in this example.  It
contains scrollbars and a drawing area for displaying a large
widget.  In this case the large widget is a text widget used to
display and edit the current selection.
.P
Parameters to widgets, like arguments to processes, are provided when
the widget is created.  These parameters may be provided in the call
to the widget creation function or may be placed in the resource
database.  Unlike processes, the widget variables (also known as
widget resources) that are set by these parameters can be set and
examined after the widget has been created.  We will briefly mention
this in the next section.

.H 2 "Variables in Resource Files and Widgets"
.XI "variables in resource files"
In all X widget based programs, there are two sets of data that can
loosely be called databases.  These are the per process resource
database and the variables or widget resources associated with the
widgets in the process.
.XI "resource database"
The per process resource database is the amalgam of four sources: the
resources placed on the root window with xrdb, input from application
specific resource files, \f(CW-xrm\fP command line options, and
application specified resources.  Input from these sources is applied
in the same order as we have listed them.  As with any real database
the last entry overrides all previous entries.
.P
The other databases in each process are composed of the variables
associated with the widgets.  Each widget class has an advertised set
of variables
.XI "widget class"
associated with it.  These variables or widget resources are created
for each widget instance.  Widget resources are normally set and
retrieved with the C functions \f(CWXtSetValues()\fP and
\f(CWXtGetValues()\fP.  This interface is the essential element in the
object-oriented applications interface to the widgets.
.P
Accessing variables in the resource database and widget resources can
.XI "resource database"
be somewhat tedious from C based applications.  To retrieve a variable
from a widget, an application must setup an argument block, call
\f(CWXtGetValues()\fP with a pointer to the correct value type, and
.XI "C pointers"
then convert the returned value (if any) to the required type.
.P
xtent allows applications to access variables in the two databases by
name and work with the values as simple strings.  Values in the
resource database can be accessed with \f(CW^(resource-name)\fP.
.XI "resource database"
.CW
 image-name: megan.tif
 outputfile: megan.ps

 xtent.XtWriteImage: (^(image-name), ^(outputfile),\\\\ 
                      postscript)
.CN
The line above writes an image to an output file in PostScript format.
.XI "PostScript"
.XI "images"
The name of the image is retrieved from the resource variable
\f(CWimage-name\fP and the output file name is retrieved from
\f(CWoutputfile\fP.  Notice that the string ``postscript'' does not
require any quoting.  All arguments in xtent are treated as strings.
.XI "quoting"
.P
Resources values in widgets can be accessed with
\f(CW^{widget.resource-name}\fP.
.CW
 xtent.form.input.XtWarpPointer: (^{xtent.form.input.width},\\\\ 
                                  ^{xtent.form.input.height})
.CN
The line above moves (i.e. warps) the mouse pointer to the lower right
.XI "mouse pointer"
hand corner of the widget, \f(CWxtent.form.input\fP.  This is done by
setting the cursor position to the width and height of the widget.
.XI "cursor"
This would take 5 or 10 lines of C to perform this same function.
.H 2 "Data as Program"
.XI "data as program"
Code can be stored in the resource database and later executed.  This
.XI "resource database"
provides a system reminiscent of Lisp where there is little
.XI "Lisp like features"
differentiation made between code and data.
.CW
 widget-switch:\\\\#
   xtent.Xt_Eval:
   (
     input-style: file,
     xtent.form.switch.set.XtSetValue: True
   )
 #
.CN
The lines above create a resource database entry for the variable
\f(CWwidget-switch\fP.  The value of the variable is a bit of xtent
code that will set the variable \f(CWinput-style\fP to \f(CWfile\fP
and set the widget resource \f(CWset\fP in the widget
\f(CWxtent.form.switch\fP to \f(CWTrue\fP.  \f(CWXt_Eval\fP is a
function that allows groups of xtent lines to be executed, similar to
\f(CWlambda\fP in Lisp or \f(CW{ ... }\fP in C.  Lines are comma
separated arguments to the \f(CWXt_Eval\fP function.
.XI "Lisp lambda"
.P
Code put into the resource database may be subsequently executed by
.XI "resource database"
referring to it through its associated variable name.  Of course, the
code may also be treated as any other database entry.  It can be
retrieved and updated just like any other piece of data.  The
following line shows how the entry above might be used in an
application.
.CW
 xtent.file.select.XtAddCallback: ^(widget-switch)
.CN
This line sets up a Callback for the widget \f(CWxtent.file\fP on the
.XI "callback"
widgets \f(CWselect\fP internal event or state.  Callbacks are the X
Toolkits method for doing procedural attachment.  This allows an
application to run a piece of application specific code when a
particular event occurs within a widget.  The line above will result
in the code under the variable \f(CWwidget-switch\fP being executed
when the widget is selected with a mouse or other pointing device.
.br
.ne 6
.H 2 "Application Supplied Functions"
.XI  "application supplied functions"
Builtin functions in xtent are executed by including them in lines of
.XI "builtin functions"
the form:
.CW
 xtent.widgetName.Xt\fIFunctionName\fP: args
.CN
Applications may also add functions to xtent.  The following adds a
function that prints a parameter N times.
.CW
 xtent.XtAddFunction: (PrintN, PrintN-script, n, arg)

 PrintN-script:\\\\#
  xtent.Xt_Eval:
  (
    xtent.XtLocalVariables: (i),
    xtent.XtIterate: (i, <, 0, ^(n), 1, xtent.XtPrint: ^(arg))
  )
 #
.CN
The body of the function is found under the resource database variable
.XI "print"
.XI "resource database"
\f(CWPrintN-script\fP.  Entering \f(CWxtent.XtPrintN:(3, AT&T)\fP will
result in \f(CWAT&T\fP being printed 3 times.
.CW
 xtent.XtPrintN:(3, AT&T)
 \fIAT&T\fP
 \fIAT&T\fP
 \fIAT&T\fP
.CN
Notice that the variable \f(CWn\fP is bound to the number 3 and the
variable \f(CWarg\fP is bound to the string \f(CWAT&T\fP when this
command is issued.  These variables are reset to their former values,
if any, when the function returns.
.H 1 "xtent Language Details"
.XI "xtent language details"
.H 2 "Function Call Syntax"
.XI "function call syntax"
Our intent in writing xtent was to produce a complete system in terms
of coverage of Xt while doing as little damage as possible to the
syntax and semantics of X resources.  Standard resource lines are
.XI "syntax"
treated as if they had been entered by \f(CWxrdb\fP or a defaults
file.  This constrains the sorts of expressions that can be used in
the system, but can be viewed as a feature in that the parsing is very
simple and can be made to be fast.  Lines that are to be interpreted
as xtent function calls all have the form:
.CW
   xtent.\fI<widget>\fP.Xt\fI<function name>\fP: \fIarguments\fP
.CN
The first token,\f(CWxtent\fP, is the program name and can be
abbreviated by simply starting the line with a ``.'':
.CW
   .\fI<widget>\fP.Xt\fI<function name>\fP: \fIarguments\fP
.CN
The \f(CWXt\fP prefix to the function name allows xtent to distinguish
a function call from a database assignment.  For example,
.CW
  .Print: wow
.CN
Adds an entry to the resource database.  The variable,
\f(CWxtent.Print\fP is assigned the value \f(CWwow\fP.  Where:
.CW
  .XtPrint: wow
.CN
calls the print function and causes the string \f(CWwow\fP to be
printed.  All function calls must at a minimum have the program name
or dot as the first token and the function name must be preceded by
the string \f(CWXt\fP.  This matches the scheme in the X Toolkit \(en
all functions start with the \f(CWXt\fP prefix.
.H 2 "xtent Program Flow"
.XI "program flow"
xtent has the usual set of programming constructs that allow for the
definition of functions, looping, and branching.  See the section on
``Program Control and Function Definition'' for the complete list of
functions.  As all expressions in xtent are function calls, there is
no control flow specific syntax to be learned.
.XI "syntax"
.P
xtent functions and program control occur within the context of the X
Toolkit model.  The toolkit expects applications to initialize the
tool kit, create widgets (graphics objects), and then hand control off
to the X Toolkit event loop.  \f(CWXtMainLoop()\fP is the widget event
dispatcher loop.  As is mentioned above, when \f(CWXtMainLoop()\fP is
in control, Xt works like an operating system that schedules widgets
to run much like a real operating system schedules processes.
Application supplied code is called when it is required.  This is
accomplished by registering pieces of code (callbacks) with Xt.  The
application supplied code is run for example when an event occurs or a
state changes in a widget.
.P
Again, all Xt programs have three main parts:
.AL 1
.LI
initialize the toolkit and the connection to the X server.
.LI
construct resources and create widgets and callbacks.
.LI
realize and run the widgets \(en realize the widgets and pass control
over to the toolkit in \f(CWXtMainLoop\fP.
.LE
.P
The following is C pseudo code for the typical Xt based program:
.CW
    void main (int arc, char** arv)
    {
       /* part 1 */
       xtent = toplevel = XtInitialize (...);

       /* part 2 */
       for (all widgets)
       {
          XtSetArg (...);
          w = XtCreateManagedWidget (...,
                      set initial state);
          XtAddCallback (w, ...);
       }

       /* part 3 */
       XtRealizeWidget (top);
       XtMainLoop ();
    }
.CN
.P
In xtent parts 1 and 3 of the Xt model are provided automatically \(en
that is the Xt functions are called when they are needed by xtent on
behalf of the application.  The application may also call these
functions, but need not.  In xtent, initialization (step 1) occurs
when the toplevel widget is first required.  This is usually when the
first widget is created.  Step 3 is completed at the end of input,
usually when the end of file is encountered on the input file.  This
leaves step 2, population of the resource database and creation of
widgets.  Most xtent programs consist only of entries added to the
resource database followed by calls to XtCreateManagedWidget and
XtAddCallback.
.P
xtent delays creating the toplevel widget until it is absolutely
.XI "toplevel widget"
required.  Because xtent works in a linear top to bottom fashion,
resources that will affect a widget should be entered prior to the
creation of the widget.  As the toplevel widget is just another
widget, the application can change the behavior of the toplevel widget
and hence the toplevel window with the resource mechanism.  Resources
that affect the toplevel widget, such as \f(CWallowShellResize\fP or
\f(CWwidth\fP, should be placed at the top of the file or entered
first.  The toplevel widget may be explicitly created by including
the line:
.CW
    xtent.XtInitialize:
 or
    .XtInitialize:
.CN
\f(CWXtInitialize\fP is the Xt function that implements step 1 above.
.P
The following is an example of a complete xtent program:
.CW
    .button.label: Exit
    .button.background: red
    .button.XtCreateManagedWidget: button
    .button.select.XtAddCallback: .XtExit:
.CN
The first two lines set the label to ``Exit'' and the background color
to ``red''.  The third line creates the widget and the fourth line
adds an action to the widget's list of functions.  When the button is
selected the program will exit.
.H 2 "All Program Variables are in the Resource Database"
The resource database is used very heavily.  First, we have shown that
resources are used
.XI "resource database"
to specify widget parameters by the usual widget resource mechanism.
Resources that match widget resource names are used as the values for
instantiating new widgets.  Second, we have shown that resources
are also used to store bits of xtent code.  This allows applications
to create the equivalent of functions or subroutines that can be
reused.  The most pervasive use of the resource database is in the
xtent function call mechanisms.  Arguments to functions may be
strings, values from widgets, or values from the resource database.
All of the free variables used by xtent are supplied by the resource
database.  Further values returned from functions are placed in the
resource database.  The following line might be used by an application
to retrieve the width and height of a widget, \f(CWxtent.widget\fP.
.CW
 xtent.widget.XtGetValues: (width, this.width, height, this.height)
.CN
The width and height values for the widget are placed in
\f(CWthis.width\fP and \f(CWthis.height\fP in the resource database.
These values may be referred to within expressions with the macros,
\f(CW^(this.width)\fP and \f(CW^(this.height)\fP.
.H 2 "Macro Expansion"
.XI "macro expansion"
There are five rules for describing macro expansion.
.AL 1
.LI
The left side of all expressions is always macro expanded:
.CW
   a: wow
   ^(a): 23
   .XtPrint: ^(wow)
   \fI23\fP
.CN
The second line above evaluates to \f(CWwow: 23\fP.  And one can see
that when the value of \f(CWwow\fP is printed, it is 23.
.LI
The right side of resource assignments is NOT evaluated.  Resource
assignments should be thought of as a function that does not evaluate
its argument.
.CW
   a: ^(Megan)
   .XtPrint: ^(a)
   \fI^(Megan)\fP
.CN
.LI
Arguments to functions are expanded as each function is run
\(en unless the function has some specific other scheme.  By
convention, functions that are prefixed with \f(CWXt_\fP do not
evaluate code bodies that are supplied to them as arguments.
.P
For example, XtEval macro expands each line as it is evaluated \(en
the entire line \(en left and right sides.  Each line is an argument
to the XtEval function.  As an aside, Xt_Eval is the preferred form
and it does not macro expand its arguments.  Generally the Xt_ form of
each control function is preferred.
.LI
Backslash, ``\\'', can be used to quote the following character.  It is
commonly used to quote a single resource variable access.
.CW
   name: Megan
   .XtPrint: ^(name)
   \fIMegan\fP

   .XtPrint: \\\\^(name)
   \fI^(name)\fP
.CN
.LI
Tilde, \f(CW~\fP, may be used to disable expansion for an argument or
for an item within an argument.  \f(CW~\fP as the first letter of an
argument to a function will disable macro expansion of the entire
argument.  Tilde as the first letter of a parenthesized resource
variable macro, will cause the macro to not be expanded.
.CW
   a: 23
   .XtPrint: out->^(a)<-
   \fIout->23<-\fP

   .XtPrint: ~out->^(a)<-
   \fIout->^(a)<-\fP

   .XtPrint: out->~^(a)<-
   \fIout->~23<-\fP

   .XtPrint: out->^(~^(a))<-
   \fIout->^(a)<-\fP
.CN
.LE
.P
Macro expansion of the left hand or object side, from rule 1 above, is
a very useful feature as the widget names can get quite long.  The
following example creates a net widget with a width of 250 and a
height of 350.
.CW
    w: xtent.form.scrolledWindow*net
    ^(w).width: 250
    ^(w).height: 350
    ^(w).XtCreateManagedWidget: net
.CN
Notice that the last element of the value of \f(CWw\fP, \f(CWnet\fP,
is denoted with an astrix.  In this example, we could have used a
period and gotten the same result.  The astrix is useful for managing
widgets contained within composite widgets, such as a scrolled window.
Composite widgets often create intervening widgets, usually bulletin
boards.  The astrix is a short hand way to get at the target widget
without mentioning all of the hidden intervening widgets.
.H 2 "Line Quoting"
.XI "line quoting"
Multi-line resource entries, usually functions, can be troublesome to
enter if each line has to be quoted.  The sequence ``\\#'' at the end
of a line starts a multi-line entry and a single ``#'' in column one
ends the entry.
.CW
    .XtPrint:\\\\#
     one
     two
     three
    #
    \fI one two three\fP

    .XtPrint:\\\\ 
     one\\\\ 
     two\\\\ 
     three
    \fI one two three\fP
.CN
The two print commands above will produce the same output.  The first
uses the multi-line quoting technique.  The second quotes each line.
.H 2 "Nested Function Calls"
.XI "nested function calls"
All expressions in xtent are function call invocations.  Application
supplied functions and builtin functions are indistinguishable.  This
makes for a very simple programming model.  The return value from any
function call (i.e. any expression) can be used as an argument to
another function using the following syntax \f(CW^[function-call]\fP.
What follows is the typical recursive factorial:
.CW
   .XtAddFunction: (Fact, fact-script, x)

   fact-script: \\\\# 
    .XtIf: (^(x), <=, 1, .XtReturn: 1, 
     .XtCalc: (^(x), ^[.XtFact: ^[.XtCalc:(^(x), --, RET)]], *, RET))
   #

   .XtPrint: Fact:6 = ^[.XtFact: 6]
   \fIFact:6 = 720\fP
.CN
.XI "return values from functions"
.P
As can be seen in the factorial example, \f(CWXtReturn\fP sets the
return value associated with application supplied functions.  For this
factorial, if x is less than or equal to 1, the the function returns
1.  \f(CWXtCalc\fP is a stack or \f(CWForth\fP like the calculation
function.  It has a return operator, \f(CWRET\fP.  All other builtin
functions, with one return value, will return the value, if no
resource database variable is specified.  The following example
demonstrates how this might be used for a typical function:
.CW
    .a.b.c.XtIsWidget: result
    .XtPrint: result=^(result)
    \fIresult=False\fP

    .XtPrint: result=^[.a.b.c.XtIsWidget:]
    \fIresult=False\fP
.CN
.H 2 "Context Specific Variables"
.XI "context specific variables"
Xt application code uses the notion of callback functions extensively
\(en widget callbacks, event handlers, selection converters, timeout
handlers, etc.  Callbacks are situations where a call is made from a
library routine back into application supplied code.  The application
supplied callback routines must have a fixed set of formal parameters.
The formal parameters act as a protocol between the system code and
the application code.  For each type of callback the protocol is
different.  For example, the parameters for event handlers are
different than those for timeouts and different than those for widget
specific callbacks.
.XI "callback variables"
.XI "callback arguments"
.XI "callback parameters"
.P
For each callback type the application has to create a function whose
formal parameters match those that are expected by the system.  This
can be a tedious and error prone task.  Lets look at an example.  The
following is a prototype for an Xt event handler function:
.CW
 void (*EventHandlerProc) (Widget, XtPointer, XEvent *, Boolean *);
.CN
Installing an event handler in C first requires that one write a
separate function that matches the specific prototype.  In this
example we will name the function \f(CWeventhandlerproc\fP.  Then one
calls an installation function:
.CW
 XtAddEventHandler (w, eh -> event_mask,
                    eh -> nonmaskable,
                    eventhandlerproc,
                    data);
.CN
.br
\f(CWeventhandlerproc\fP may be a one line function call, for example:
.CW
 EventHandlerProc
 eventhandlerproc (Widget widget, XtPointer p, XEvent *e, Boolean *c)
 {
      f (widget, "this case", c);
 }
.CN
One would like to be able to use an arbitrary function ``f'' or code
body in the call to XtAddEventHandler().  Our system allows
application developers to do this by creating environments where the
formal parameters are automatically added to the scope of the
function.  The equivalent in C would look something like the
following:
.CW
 XtAddEventHandler (w, eh -> event_mask,
                    eh -> nonmaskable,
                    f (<event\-widget>, "this case", 
                       <event\-boolean>));
.CN
Where f will be evaluated in the context of servicing the event.  The
trick here is in getting the variables \f(CW<event\-widget>\fP and
\f(CW<event\-boolean>\fP to be automatically generated in the context
of the event handling code.  In xtent we call these variables context
specific variables.
.P
In xtent we could install our event handling function with the
following bit of code.
.CW
 ^(w).Xt_AddEventHandler: (^(eh.event_mask),
                           ^(eh.nonmaskable),
                           .Xtf: (^(%event.widget), "this case",
                                  %event.continue-to-dispatch))
.CN
.P
.ne 38
The following table contains a list of all of the context specific
variables for use with the X Toolkit.
.TS
center doublebox, tab(;);
cB cB
l l.
Context Variable; Callback Context
_

%callback.widget; all widget callbacks
%callback.calldata; all widgets callbacks

%selection.widget; XtGetSelectionValue
%selection.atom; XtGetSelectionValue
%selection.type; XtGetSelectionValue
%selection.value; XtGetSelectionValue
%selection.length; XtGetSelectionValue
%selection.format; XtGetSelectionValue

%convertSelection.widget; convert for *OwnSelection
%convertSelection.selection; convert for *OwnSelection
%convertSelection.target; convert for *OwnSelection
%convertSelection.string; convert for *OwnSelection
%convertSelection.string; convert for *OwnSelection

%loseSelection.widget; lose for *OwnSelection
%loseSelection.selection; lose for *OwnSelection

%doneSelection.widget; done for *OwnSelection
%doneSelection.selection; done for *OwnSelection

%event.widget; XtAddEventHandler
%event.pointer; XtAddEventHandler
%event.continue-to-dispatch; XtAddEventHandler

%action.event; all widget translations

.TE
.ce 1
.TB "Context Variables for Xt Functions"
.P
The following table contains a list of all of the context specific
variables for use with the Motif* widget set.
.FS *
Motif is a trademark of the Open Software Foundation.
.FE
.TS
center doublebox, tab(;);
cB cB
l l.
Context Variable; Motif Context
_

%cutPaste.widget; Clipboard cut/paste copy function
%cutPaste.data-id; Clipboard cut/paste copy function
%cutPaste.private; Clipboard cut/paste copy function
%cutPaste.reason; Clipboard cut/paste copy function

.TE
.ce 1
.TB "Context Variables for Motif Functions"
.P
.ne 48
The following table contains a list of all of the context specific
variables for use with the OpenLook widget set.
.TS
center doublebox, tab(;);
cB cB
l l.
Context Variable; OpenLook Context
_

%help.widget; application supplied help
%help.flatitem; application supplied help
%help.x; application supplied help
%help.y; application supplied help

%drag-and-drop.widget; OlDnDPreviewAnimateCallback
%drag-and-drop.eventcode; OlDnDPreviewAnimateCallback
%drag-and-drop.time-stamp; OlDnDPreviewAnimateCallback
%drag-and-drop.sensitivity; OlDnDPreviewAnimateCallback

%trigger.widget; OlDnDTriggerMessageNotify
%triggerwindow; OlDnDTriggerMessageNotify
%trigger.root-x; OlDnDTriggerMessageNotify
%trigger.root-y; OlDnDTriggerMessageNotify
%trigger.selection; OlDnDTriggerMessageNotify
%trigger.time-stamp; OlDnDTriggerMessageNotify
%trigger.dropsite-id; OlDnDTriggerMessageNotify
%trigger.operation; OlDnDTriggerMessageNotify
%trigger.send-done; OlDnDTriggerMessageNotify
%trigger.forwarded; OlDnDTriggerMessageNotify

%preview.widget; OlDnDPreviewMessageNotify
%preview.window; OlDnDPreviewMessageNotify
%preview.root-x; OlDnDPreviewMessageNotify
%preview.root-y; OlDnDPreviewMessageNotify
%preview.operation; OlDnDPreviewMessageNotify
%preview.time-stamp; OlDnDPreviewMessageNotify
%preview.dropsite-id; OlDnDPreviewMessageNotify
%preview.forwarded; OlDnDPreviewMessageNotify

%protocol-action.widget; OlDnDProtocolActionCallback
%protocol-action.selection; OlDnDProtocolActionCallback
%protocol-action.protocol-action; OlDnDProtocolActionCallback
%protocol-action.flag; OlDnDProtocolActionCallback

%transaction.widget; OlDnDTransactionStateCallback
%transaction.selection; OlDnDTransactionStateCallback
%transaction.state; OlDnDTransactionStateCallback
%transaction.time-stamp; OlDnDTransactionStateCallback

.TE
.ce 1
.TB "Context Variables for OpenLook Functions"

.ne 17
.H 1 "xtent Builtin Functions"
.XI "builtin functions"
In this section we tersely describe each of the builtin functions
included within xtent.  The description includes a few line
description of each function and a list of its arguments.  The
arguments for most functions can be strings containing specific
values, for example the word \f(CWTrue\fP, or terms that will be macro
.XI "macro expansion"
expanded, for example a resource database entry such as
.XI "resource database"
^(input-source).  The functions are listed below using the resource
database syntax to emphasize that the arguments are macro expanded
.XI "syntax"
prior to calling the function.
.P
xtent supports all of the Xt functions that are used to manipulate
widgets.  It also has functions for handling Athena, HP, Motif, and
OpenLook widget sets.  There are also many functions that we have
found useful in writing applications.  Functions are very easy to add
to xtent.  We imagine that the list of useful functions will grow as
time goes by.  The next section lists the Xt functions.
.FS *
There are three popular widget sets: AT&T's Open Look[3], OSF's
Motif[4], and MIT's Athena widget set[5].  The HP[6] widget set also
has a following.  The widget specific code in xtent is a list of
widget class names and a list of the header
.XI "widget class"
files that support those widgets.  Adding a well written widget should
only take a few minutes work.
.FE
.br
.ne 40
.H 2 "Xt Functions"
.XI "X Toolkit functions"
.XI "Xt functions"
The following table contains the names of the Xt functions that are
currently implemented under xtent.  The functions are described in the
order in which they appear in this table.  To fully understand this
section, an application developer should have a copy of the X11 Xt
manual and the appropriate widget set* documentation at hand.
.TS
center doublebox, tab(;);
l l l.

XtAddCallback;Xt_AddCallback;XtAddCallbackWithArgs;
Xt_AddCallbackWithArgs;XtAddEventHandler;Xt_AddEventHandler;
XtAddGrab;XtAddRawEventHandler;XtAppAddAction;
XtAppAddInput;XtAppAddInputNonBlocking;XtAppAddTimeOut;
Xt_AppAddTimeOut;XtAppAddWorkProc;Xt_AppAddWorkProc;
XtAppCreateShell;XtAppError;XtAppErrorMsg;
XtAppMainLoop;XtAppWarning;XtAppWarningMsg;
XtAugmentTranslations;Xt_AugmentTranslations;XtBuildEventMask;
XtCallCallbacks;XtClass;XtCreateManagedWidget;
XtCreatePopupShell;XtCreateWidget;XtDestroyWidget;
XtConfigureWidget;XtDisOwnSelection;XtGetMultiClickTime;
XtGetSelectionValue;Xt_GetSelectionValue;XtGetValue;
XtGetValues;XtGetValueWithType;XtGrabButton;
XtGrabKey;XtGrabKeyboard;XtGrabPointer;
XtHasCallbacks;XtInitialize;XtInsertEventHandler;
Xt_InsertEventHandler;XtInsertRawEventHandler;Xt_InsertRawEventHandler;
XtInstallAccelerators;XtInstallAllAccelerators;XtIsComposite;
XtIsManaged;XtIsRealized;XtLastTimestampProcessed;
XtManageChild;XtManageChildren;XtMapWidget;
XtMoveWidget;XtOverrideTranslations;Xt_OverrideTranslations;
XtOwnSelection;Xt_OwnSelection;XtParent;
XtPopdown;XtPopup;XtPopupSpringLoaded;
XtRealizeWidget;XtRemoveAllCallbacks;XtRemoveCallback;
XtRemoveEventHandler;XtRemoveGrab;XtRemoveInput;
XtRemoveRawEventHandler;XtRemoveTimeOut;XtRemoveWorkProc;
XtReplaceTranslations;Xt_ReplaceTranslations;XtResizeWidget;
XtSetKeyboardFocus;XtSetMappedWhenManaged;XtSetMultiClickTime;
XtSetSensitive;XtSetValue;XtSetValues;
XtSetValueWithType;XtTranslateCoords;XtUngrabButton;
XtUngrabKey;XtUngrabKeyBoard;XtUngrabPointer;
XtUninstallTranslations;XtUnmanageChild;XtUnmanageChildren;
XtUnmapWidget;XtUnrealizeWidget;XtVaCreateWidget;
XtVaCreateManagedWidget;XtVaCreatePopupShell;XtWindow;
XtWindowToWidget;

.TE
.ce 1
.TB "X Toolkit Functions"

.iS XtAddCallback 0
xtent.widget.callback-name.XtAddCallback: ^(callback-code)
.iE
This function installs a callback under the specified callback name.
.XI "callback"
Any xtent statement may be used for the \f(CWcallback-code\fP.

.iS Xt_AddCallback 0
xtent.widget.callback-name.Xt_AddCallback: ^(callback-code)
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
installing it under the named callback state.  Otherwise this function
behaves as \f(CWXtAddCallback\fP.

.iS XtAddCallbackWithArgs 0
xtent.widget.callback-name.XtAddCallbackWithArgs: (^(callback-code),
                                                   ...)
.iE
This function installs a callback under the specified callback name.
.XI "callback"
Any xtent statement may be used for the \f(CWcallback-code\fP.  The
rest of the arguments to the function are used to initialize variables
that can be used in the callback code.
.P
.ne 8
The following code demonstrates how the extra arguments are used:
.CW
 xtent.widget.select.XtAddCallbackWithArgs: (^(code),\\\\ 
     Widget, w,\\\\ 
     CallData, Int, x,\\\\ 
     ClientData, selection-set, type)
.CN
There are four keywords that are recognized, \f(CWWidget, ClientData,
CallData,\fP and \f(CWCallDataPtr\fP.
.XI "calldata"
.BL
.LI
\f(CWWidget\fP \(en When this keyword is used, the following variable
is set to the name of the widget.  In our example above, \f(CWw\fP
will be set to \f(CWxtent.widget\fP when the callback code is
.XI "callback"
executed.
.LI
\f(CWClientData\fP \(en When this keyword is used, the next argument is
the client data and the argument following it is the variable name.
The named variable will be assigned the supplied client data when the
callback code is executed.  In our example above, \f(CWtype\fP will be
.XI "callback"
assigned \f(CWselection-set\fP.
.LI
\f(CWCallData\fP \(en Some callbacks pass data to the callback
.XI "callback"
function via a calldata parameter.  When this keyword is used, the
.XI "calldata"
argument immediately following the \f(CWCallData\fP keyword is the
type of the calldata parameter and the argument following that is the
variable name.  The named variable will be assigned the value of the
calldata parameter when the callback code is executed.  Of course the
.XI "callback"
value will be converted to a string.  In our example above, \f(CWx\fP
will be assigned the integer value of the parameter.
.LI
\f(CWCallDataPtr\fP \(en This keyword is used when the calldata
.XI "calldata"
parameter is a pointer to the specified type.  Otherwise,
.XI "C pointers"
\f(CWCallDataPtr\fP keyword behaves exactly as the \f(CWCallData\fP
keyword.
.LE
.P
Keyword argument groups may appear in any order and are all optional.
If the application wishes to not use any of the keyword arguments,
then \f(CWXtAddCallbackWithArgs\fP will have the same behavior as
\f(CWXtAddCallback\fP.  The keywords may also be used more than once.
An application, for example, may wish to set a number of clientdata
parameters or perform multiple type conversions on the calldata.
.XI "calldata"


.iS Xt_AddCallbackWithArgs 0
xtent.widget.callback-name.Xt_AddCallbackWithArgs: (^(callback-code),
                                                   ...)
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
installing it under the named callback state.  Otherwise this function
behaves as \f(CWXtAddCallbackWithArgs\fP.

.iS XtAddEventHandler 0
xtent.widget.XtAddEventHandler: (^(event),
                                 ^(bool-nonmaskable-events),
                                 ^(event-code))
.iE
This function adds an event handler for the specified event for the
.XI "events"
.XI "macro expansion"
named widget.  Any xtent statement may be used for the
\f(CWevent-code\fP.

.iS Xt_AddEventHandler 0
xtent.widget.Xt_AddEventHandler: (^(event),
                                  ^(bool-nonmaskable-events),
                                  ^(event-code))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtAddEventHandler\fP.

.iS XtAddGrab 0
xtent.widget.XtAddGrab: (^(bool-exclusive), ^(bool-spring-loaded))
.iE
.XI "keyboard handling"
.XI "mouse pointer"
This function adds a keyboard grab to the named widget.
\f(CWbool-exclusive\fP specifies whether user events should be
dispatched exclusively to this widget or also to previous widgets in
the cascade.  \f(CWspring-loaded\fP specifies whether this widget was
popped up because the user pressed a pointer button.

.iS XtAddRawEventHandler 0
xtent.widget.XtAddRawEventHandler: (^(event),
                                    ^(bool-nonmaskable-events),
                                    ^(event-code))
.iE
This function follows the same semantics as \f(CWXtAddEventHandler\fP
with the exception that it does not affect the widget's event mask and
.XI "event mask"
it does not cause \f(CWXSelectInput()\fP to be called.

.iS Xt_AddRawEventHandler 0
xtent.widget.Xt_AddRawEventHandler: (^(event),
                                    ^(bool-nonmaskable-events),
                                    ^(event-code))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtRawAddEventHandler\fP.

.iS XtAppAddAction 0
xtent.XtAppAddAction: ^(action-name)
.iE
This function adds an action name to the list of names that can be
used in translation tables.  These names are symbolic entry points
that can be used in widget translations.
.XI "translations"

.iS XtAppAddInput 0
xtent.XtAppAddInput: ^(input-source)
.iE
This function opens the file specified in the \f(CWinput-source\fP
variable for reading.  When input appears from the file, it is read as
xtent code.

.iS XtAppAddInputNonBlocking 0
xtent.XtAppAddInputNonBlocking: ^(input-source)
.iE
This function opens the file specified in the \f(CWinput-source\fP
variable for reading.  When input appears from the file, it is read as
xtent code.  The file is opened for nonblocking reads.  Care should be
taken to avoid selecting files that cannot tolerate the nonblocking
setting.

.iS XtAppAddTimeOut 0
xtent.XtAppAddTimeOut: (^(interval), ^(timeout-code))
.iE
This function adds a timeout that will be run in the \f(CWinterval\fP
.XI "timeouts"
milliseconds.  The code specified in \f(CWtimeout-code\fP will be run
.XI "milliseconds"
when the time elapses.

.iS Xt_AppAddTimeOut 0
xtent.Xt_AppAddTimeOut: (^(interval), ^(timeout-code))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtAppAddTimeOut\fP.

.iS XtAppAddWorkProc 0
xtent.XtAppAddWorkProc: ^(work-proc-code)
.iE
This function adds code that will be run whenever the application is
.XI "workprocs"
idle.

.iS Xt_AppAddWorkProc 0
xtent.Xt_AppAddWorkProc: ^(work-proc-code)
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtAppAddWorkProc\fP.

.iS XtAppCreateShell 0
xtent.widget.XtAppCreateShell: ^(widget-class-name)
.iE
.XI "widget class"
.XI "toplevel widget"
This function creates an application shell of the class specified in
\f(CWwidget-class-name\fP.  xtent manages the list of toplevel shell
names.  \f(CWwidget\fP is used as the name of the new shell.

.iS XtAppError 0
xtent.XtAppError: <error message>
.iE
.XI "print"
.XI "macro expansion"
.XI "error messages"
This function macro expands and prints the error message line, and
then exits.

.iS XtAppErrorMsg 0
xtent.XtAppErrorMsg: (^(name), ^(type), ^(class),
                      ^(default), ^(message))
.iE
This function calls the standard Xt error message routine.
.XI "error messages"

.iS XtAppMainLoop 0
xtent.XtAppMainLoop:
.iE
This function calls the Xt event handling loop \f(CWXtAppMainLoop\fP.
.XI "events"
The function is an infinite loop and hence does not return.  The xtent
.XI "loop"
interpreter will call this routine by default at the end of the input
file if any widgets have been created.

.iS XtAppWarning 0
xtent.widget.XtAppWarning: <warning message>
.iE
This function macro expands and prints the warning message line.
.XI "warning messages"
.XI "print"
.XI "macro expansion"

.iS XtAppWarningMsg 0
xtent.widget.XtAppWarningMsg: (^(name), ^(type), ^(class),
                               ^(default), ^(message))
.iE
This function calls the standard Xt warning message routine.
.XI "warning messages"

.iS XtAugmentTranslations 0
xtent.widget.XtAugmentTranslations: <translation table>
.iE
This function augments the translation table for the specified widget.
.P
Translations may also be entered as resources with the following
operators, \f(CW#replace\fP, \f(CW#augment\fP, and \f(CWoverride\fP.
For historical reasons, these resources must be evaluated as is shown
in the following example:
.CW
 xtent.XtEval: (xtent.widget.translations: #override\\\\#
   <EnterNotify>: DoThis("xtent.XtPrint: <Enter>") OlAction()\\\\n
   <LeaveNotify>: DoThis("xtent.XtPrint: <Leave>") OlAction())
 #
.CN

.iS Xt_AugmentTranslations 0
xtent.widget.Xt_AugmentTranslations: <translation table>
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtAugmentTranslations\fP.

.iS XtBuildEventMask 0
xtent.widget.XtBuildEventMask: ^(return-variable-name)
.iE
This function places the value of the widget event mask under the
.XI "event mask"
resource variable \f(CWreturn-variable-name\fP.

.iS XtCallCallbacks 0
xtent.widget.named-callback.XtCallCallbacks:
.iE
This function calls the Callbacks associated with the
\f(CWnamed-callback\fP for the specified widget.  This is something
.XI "callback"
like an indirect group or parallel function call to the widget
callback list.

.iS XtClass 0
xtent.widget.XtClass: ^(return-variable)
.iE
This function places the widget class name in the named variable.
.XI "widget class"

.iS XtConfigureWidget 0
xtent.widget.XtConfigureWidget: (^(x), ^(y),
                                 ^(width), ^(height),
                                 ^(borderwidth))
.iE
This function changes the widgets position, width, height, and
borderwidth to the specified values.  This function should be used
sparingly, as it was designed to be used by composite widgets on its
children.

.iS XtCreateManagedWidget 0
xtent.widget.XtCreateManagedWidget: ^(widget-class)
.iE
This function creates a managed widget with the specified widget
class.  This function is the primary mechanism for creating new
.XI "widget class"
widgets.

.iS XtCreatePopupShell 0
xtent.widget.XtCreatePopupShell: ^(widget-class)
.iE
This function creates a shell widget with the specified widget class.
.XI "widget class"
.XI "popup"

.iS XtCreateWidget 0
xtent.widget.XtCreateWidget: ^(widget-class)
.iE
This function creates an unmanaged widget with the specified widget
class.
.XI "widget class"

.iS XtDestroyWidget 0
xtent.widget.XtDestroyWidget:
.iE
This function destroys the specified widget.

.iS XtDisownSelection 0
xtent.widget.XtDisownSelection: ^(atom)

xtent.widget.XtDisownSelection: (^(atom), ^(time-stamp-id))
.iE
This function disowns the selection and supporting callback associated
with the specified atom.  The time stamp ID defaults to the value
returned by XtLastTimestamp() if the time stamp is \f(CW-\fP or null.
See XtOwnSelection.

.iS XtGetMultiClickTime 0
xtent.XtGetMultiClickTime: ^(return-variable-name)
.iE
This function places the time in milliseconds of a multi-click event
.XI "multi-click"
.XI "milliseconds"
in the named variable.  Clicks separated by a time period longer than
this value are seen as separate events.

.iS XtGetSelectionValue 0
xtent.widget.XtGetSelectionValue: (^(atom),
                                   ^(callback-code),
                                   ^(time-stamp-id))
.iE
This function registers the callback code to get the selection
associated with the specified atom.  The callback code is executed
once.  The time-stamp is an optional field.  If no time stamp is
supplied, the function defaults to the last timestamp processed by Xt.
The following example retrieves the current selection.
.CW
  .XtGetSelectionValue: (PRIMARY, .XtGetAndPrint:)

  ...

  !!!
  !!! callback function for printing new selections
  !!!
  .XtAddFunction: (GetAndPrint, GetAndPrint)
  GetAndPrint: .Xt_Eval:\#
  (
   .XtLocalVariables: (test),

   .XtCalc: (^(%selection.length), 0, >,
             ^(lastSelection), ^(%selection.value), !=,
             &&, test, =),

   .Xt_If: (^(test), ==, True, .Xt_Eval:
           (
              .XtSet: (lastSelection, ^(%selection.value)),
              .XtPrint: Selection=^(%selection.value)
           ))
 )
.CN

.iS Xt_GetSelectionValue 0
xtent.widget.Xt_GetSelectionValue: (^(atom),
                                    ^(callback-code),
                                    ^(time-stamp))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtGetSelectionValue\fP.

.iS XtGetValue 0
xtent.widget.resource-name.XtGetValue: ^(return-variable-name)
.iE
This function places the value of the named widget resource in the
named return variable.  All values are converted and returned as
strings.

.iS XtGetValues 0
xtent.widget.XtGetValues: (^(resource-name1), ^(return-variable-name1)
                           ^(resource-name2), ^(return-variable-name2)
                           ^(resource-name3), ^(return-variable-name3)
                          ...
.iE
This is a VARARGS (i.e. unspecified argument count) interface to
\f(CWXtGetValues\fP.  This function places the values of the named
widget resources in the named return variables.  All values are
converted and returned as strings.

.iS XtGetValueWithType 0
xtent.widget.resource-name.XtGetValueWithType: (^(variable-type),
                                         ^(return-variable-name))
.iE
This function places the value of the named widget resource in the
named return variable.  The type of the variable is taken from the
first variable, rather than looking it up in the resource list of the
widget.  All values are converted and returned as strings.

.iS XtGrabButton 0
xtent.widget.XtGrabButton: (^(button), ^(modifiers),
                            ^(boole-owner-events),
                            ^(event-mask),
                            ^(pointer-mode),
                            ^(keyboard-mode),
                            ^(confine-to-widget),
                            ^(cursor-name))
.iE
This function sets up a passive grab of a single pointer button.  A
.XI "mouse pointer"
null widget name or \f(CWNone\fP may be used to specify that the grab
is to use \f(CWxtent.widget\fP.  \f(CWNone\fP may also be used as the
cursor name.
.XI "cursor"

.iS XtGrabKey 0
xtent.widget.XtGrabKey: (^(keycode), ^(modifiers),
                         ^(boole-owner-events),
                         ^(pointer-mode),
                         ^(keyboard-mode))
.iE
This function sets up a passive grab of a single key.
.XI "mouse pointer"

.iS XtGrabKeyboard 0
xtent.widget.XtGrabKeyboard: (^(boole-owner-events),
                              ^(pointer-mode),
                              ^(keyboard-mode),
                              ^(time))
.iE
This function actively grabs the keyboard.
.XI "keyboard handling"
.XI "mouse pointer"

.iS XtGrabPointer 0
xtent.widget.XtGrabPointer: (^(boole-owner-events),
                             ^(event-mask),
                             ^(pointer-mode),
                             ^(keyboard-mode),
                             ^(confine-to-widget),
                             ^(cursor-name),
                             ^(time))
.iE
This function actively grabs the pointer.
.XI "mouse pointer"

.iS XtHasCallbacks 0
xtent.widget.callback-name.XtHasCallbacks: ^(return-variable)
.iE
This function sets the value of the return variable to \f(CWNoList\fP,
\f(CWHasNone\fP, or \f(CWHasSome\fP depending on the state of the
widget and the specified Callback.
.XI "callback"

.iS XtInitialize 0
xtent.XtInitialize:
.iE
This function forces the initialization of the toolkit.  The toplevel
.XI "toplevel widget"
.XI "toolkit"
.XI "initialization"
widget is guaranteed to exist after this call.  The interpreter will
automatically initialize the toplevel widget so this function need not
be called in most applications.

.iS XtInsertEventHandler 0
xtent.widget.XtInsertEventHandler: (^(event),
                                    ^(bool-nonmaskable-events),
                                    ^(event-code),
                                    ^(position))
.iE
This function adds an event handler for the specified event for the
.XI "event handler"
named widget as does \f(CWXtAddEventHandler\fP, except a position may
be specified.  This is used to control the order of execution of the
handlers.  \f(CWposition\fP may be either \f(CWXtListTail\fP or
\f(CWXtListHead\fP.

.iS Xt_InsertEventHandler 0
xtent.widget.Xt_InsertEventHandler: (^(event),
                                     ^(bool-nonmaskable-events),
                                     ^(event-code),
                                     ^(position))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtInsertEventHandler\fP.


.iS XtInsertRawEventHandler 0
xtent.widget.XtInsertRawEventHandler: (^(event),
                                       ^(bool-nonmaskable-events),
                                       ^(event-code),
                                       ^(position))
.iE
This is the raw event version of \f(CWXtInsertEventHandler\fP.  See
the entry above on \f(CWXtAddEventHandler\fP.

.iS Xt_InsertRawEventHandler 0
xtent.widget.Xt_InsertRawEventHandler: (^(event),
                                        ^(bool-nonmaskable-events),
                                        ^(event-code),
                                        ^(position))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtInsertRawEventHandler\fP.

.iS XtInstallAccelerators 0
xtent.widget.XtInstallAccelerators: ^(source-widget)
.iE
.XI "keyboard handling"
.XI "accelerators"
This function installs the keyboard accelerators from the source
widget.

.iS XtInstallAllAccelerators 0
xtent.widget.XtInstallAllAccelerators: ^(source-widget)
.iE
.XI "keyboard handling"
.XI "accelerators"
This function installs the keyboard accelerators from the source
widget and all of the source widget's descendants.

.iS XtIsComposite 0
xtent.widget.XtIsComposite: ^(return-variable)
.iE
This function sets the return variable to \f(CWTrue\fP if the widget
is a composite widget (e.g. a form) or \f(CWFalse\fP if it is not.

.iS XtIsManaged 0
xtent.widget.XtIsManaged: ^(return-variable)
.iE
This function sets the return variable to \f(CWTrue\fP if the widget
is being managed or \f(CWFalse\fP if it is not.

.iS XtIsRealized 0
xtent.widget.XtIsRealized: ^(return-variable)
.iE
This function sets the return variable to \f(CWTrue\fP if the widget
has been realized or \f(CWFalse\fP if it has not.

.iS XtLastTimestampProcessed 0
xtent.XtLastTimestampProcessed: ^(return-timestamp-id)
.iE
This function returns the time stamp of the last X event.  These
values are used for communication and drag and drop operations.

.iS XtManageChild 0
xtent.widget.XtManageChild:
.iE
This function sets the widget to be managed.

.iS XtManageChildren 0
xtent.widget.XtManageChildren: (^(widget-list-name),
                                ^(widget-count-name))
.iE
This function manages a list of widgets.  The widget list and the
length of the list are retrieved from the widget's resource list.  The
names provided are used to request the list and the count from the
widget.

.iS XtMapWidget 0
xtent.widget.XtMapWidget:
.iE
This function maps the specified widget.

.iS XtMoveWidget 0
xtent.widget.XtMoveWidget: (^(x), ^(y))
.iE
This function moves the widget to the specified (x, y) position.  This
function is rarely used.  The recommended technique for moving a
widget is to set the widget's x and y resources using
\f(CWXtSetValues\fP.

.iS XtOverrideTranslations 0
xtent.widget.XtOverrideTranslations: <translation table>
.iE
This function overrides the translation table for the specified
widget.
.XI "macro expansion"
.P
Translations may also be entered as resources with the following
operators, \f(CW#replace\fP, \f(CW#augment\fP, and \f(CWoverride\fP.
For historical reasons, these resources must be evaluated as is shown
in the following example:
.CW
 xtent.XtEval: (xtent.widget.translations: #override\\\\#
   <EnterNotify>: DoThis("xtent.XtPrint: <Enter>") OlAction()\\\\n
   <LeaveNotify>: DoThis("xtent.XtPrint: <Leave>") OlAction())
 #
.CN

.iS Xt_OverrideTranslations 0
xtent.widget.Xt_OverrideTranslations: <translation table>
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtOverrideTranslations\fP.

.iS XtOwnSelection 0
xtent.XtOwnSelection: (^(atom),
                       ^(convert-callback-code),
                       ^(lose-callback-code),
                       ^(done-callback-code))

xtent.XtOwnSelection: (^(atom),
                       ^(convert-callback-code),
                       ^(lose-callback-code),
                       ^(done-callback-code),
                       ^(time-stamp-id))
.iE
This function allows an application to supply a selection.  The most
commonly used selection is PRIMARY, the selection associated with
selecting text and graphical objects.  The
\f(CWconvert-callback-code\fP will be run when another process
requests the named selection.  \f(CWlose-callback-code\fP will be run
when the ownership of the selection is transferred to another process.
And, \f(CWdone-callback-code\fP will be run after each transfer of the
selection is completed.  The time stamp ID defaults to the value
returned by XtLastTimestamp() if the time stamp is \f(CW-\fP or null.
.CW
  .XtOwnSelection: (PRIMARY, .XtConvert:, .XtLose:, .XtDone:)
  ...

  !!!
  !!! convert callback for returning the current selection
  !!!
  .XtAddFunction: (Convert, convert)
  convert: .Xt_Eval: \#
  (
  ! .XtPrint: convert: w=^(%convertSelection.widget),
  ! .XtPrint: atom=^(%convertSelection.selection),
  ! .XtPrint: target=^(%convertSelection.target),
   .XtSet: (%convertSelection.string, ^(app.string))
  )
  #

  !!!
  !!! lose callback for noticing that the selection has changed
  !!!
  .XtAddFunction: (Lose, lose)
  lose: .Xt_Eval: \#
  (
  ! .XtPrint: lose: w=^(%loseSelection.widget),
  ! .XtPrint: atom=^(%loseSelection.selection)
  )
  #

  !!!
  !!! done callback for noticing when transfers have been completed
  !!!
  .XtAddFunction: (Done, done)
  done: .Xt_Eval: \#
  (
  ! .XtPrint: done: w=^(%doneSelection.widget),
  ! .XtPrint: atom=^(%doneSelection.selection)
  )
  #
.CN

.iS Xt_OwnSelection 0
xtent.Xt_OwnSelection: (^(atom),
                        ^(convert-callback-code),
                        ^(lose-callback-code),
                        ^(done-callback-code))
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code bodies prior
to evaluating it.  Otherwise this function behaves as
\f(CWXtOwnSelection\fP.

.iS XtParent 0
xtent.widget.XtParent: ^(parent-return)
.iE
This function places the parent widget name in the specified variable.
.XI "parent widget"

.iS XtPopdown 0
xtent.widget.XtPopdown:
.iE
This function pops down the specified widget.

.iS XtPopup 0
xtent.widget.XtPopup: ^(grab-type)
.iE
This function pops up the specified widget.  The value of
the argument must be \f(CWXtGrabExclusive\fP or
\f(CWXtGrabNonexclusive\fP.
.XI "popup"

.iS XtPopupSpringLoaded 0
xtent.widget.XtPopupSpringLoaded:
.iE
.XI "popup"
.XI "popdown"
This function attempts to popdown the specified widget as a spring
loaded widget.

.iS XtRealizeWidget 0
xtent.widget.XtRealizeWidget:
.iE
.XI "toplevel widget"
.XI "realizing widgets"
This function realizes the specified widget.  The interpreter will
automatically realize the toplevel widget so this function need not be
called in most applications.

.iS XtRemoveAllCallbacks 0
xtent.widget.callback-name.XtRemoveAllCallbacks:
.iE
This function removes all of the callbacks registered under the
specified callback name.
.XI "callback"

.iS XtRemoveCallback 0
xtent.widget.callback-name.XtRemoveCallback:: ^(callback-code)
.iE
This function removes the named callback.  The \f(CWcallback-code\fP
.XI "callback"
must match the code used to add the callback.  See
\f(CWXtAddCallback\fP above.

.iS XtRemoveEventHandler 0
xtent.widget.XtRemoveEventHandler: (^(event),
                                    ^(bool-nonmaskable-events),
                                    ^(bool-continue-to-dispatch),
                                    ^(event-code))
.iE
This function removes an application installed event handler.  The
.XI "event handler"
arguments to this function must match the arguments used to originally
install the handler.

.iS XtRemoveGrab 0
xtent.widget.XtRemoveGrab:
.iE
This function removes a previously installed grab.

.iS XtRemoveInput 0
xtent.XtRemoveInput: ^(input-source)
.iE
This function removes a previously installed input source.  The value
of the input source must match the value used to originally install the
source.

.iS XtRemoveRawEventHandler 0
xtent.widget.XtRemoveRawEventHandler: (^(event),
                                       ^(bool-nonmaskable-events),
                                       ^(bool-continue-to-dispatch),
                                       ^(event-code))
.iE
This function removes an application installed raw event handler.  The
.XI "event handler"
arguments to this function must match the arguments used to originally
install the handler.

.iS XtRemoveTimeOut 0
xtent.XtRemoveTimeOut: (^(interval), ^(timeout-code))
.iE
This function removes an application installed timeout.  The arguments
.XI "timeouts"
to this function must match the arguments used to originally install
the timeout.

.iS XtRemoveWorkProc 0
xtent.XtRemoveWorkProc: ^(work-proc-code)
.iE
This function removes an application installed work proc.  The
arguments to this function must match the arguments used to originally
install the work proc.
.XI "workprocs"

.iS XtReplaceTranslations 0
xtent.widget.XtReplaceTranslations: <translation table>
.iE
This function replaces the translation table for the specified widget.
.P
Translations may also be entered as resources with the following
operators, \f(CW#replace\fP, \f(CW#augment\fP, and \f(CWoverride\fP.
For historical reasons, these resources must be evaluated as is shown
in the following example:
.CW
 xtent.XtEval: (xtent.widget.translations: #override\\\\#
   <EnterNotify>: DoThis("xtent.XtPrint: <Enter>") OlAction()\\\\n
   <LeaveNotify>: DoThis("xtent.XtPrint: <Leave>") OlAction())
 #
.CN

.iS Xt_ReplaceTranslations 0
xtent.widget.Xt_ReplaceTranslations: <translation table>
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as
\f(CWXtReplaceTranslations\fP.

.iS XtResizeWidget 0
xtent.widget.XtResizeWidget: (^(x), ^(y),
                              ^(width), ^(height),
                              ^(borderwidth))
.iE
This function changes the widgets width, height, and borderwidth to
the specified values.  This function should be used sparingly, as it
was designed to be used by composite widgets on its children.

.iS XtSetKeyboardFocus 0
xtent.widget.XtSetKeyboardFocus: ^(descendant-widget-name)
.iE
This function sets the keyboard focus to the specified widget.  A
.XI "keyboard handling"
descendant widget may be specified or \f(CWNone\fP.

.iS XtSetMappedWhenManaged 0
xtent.widget.XtSetMappedWhenManaged: ^(boole-mapped)
.iE
This function sets the ``mapped when managed'' flag in the widget to
the value of the boolean argument.  The \f(CWboole-mapped\fP variable
should be either \f(CWTrue\fP or \f(CWFalse\fP.

.iS XtSetMultiClickTime 0
xtent.XtSetMultiClickTime: ^(click-interval)
.iE
This function sets the multi-click time in milliseconds.  Clicks
.XI "multi-click"
.XI "milliseconds"
separated by a time period longer than this value are seen as separate
events.

.iS XtSetSensitive 0
xtent.widget.XtSetSensitive: ^(boole-sensitive)
.iE
This function sets the sensitive flag in the specified widget.  The
argument should be either \f(CWTrue\fP or \f(CWFalse\fP.

.iS XtSetValue 0
xtent.widget.resource-name.XtSetValue: ^(value)
.iE
This function sets the named widget resource to the specified value.
All values are converted from strings to the type of the specified
resource.

.iS XtSetValues 0
xtent.widget.XtSetValues: (^(resource-name1), ^(value1),
                           ^(resource-name2), ^(value2),
                           ^(resource-name3), ^(value3),
                          ...
.iE
This is a VARARGS (i.e. unspecified argument count) interface to
\f(CWXtSetValue\fP.  This function sets the named widget resources to
the specified values.  All values are converted from strings to the
type of the specified resources.

.iS XtSetValueWithType 0
xtent.widget.resource-name.XtSetValueWithType: (^(variable-type),
                                                ^(value))
.iE
This function sets the named widget resource to the specified value.
The type of the variable is taken from the first variable, rather than
looking it up in the resource list of the widget.

.iS XtTranslateCoords 0
xtent.widget.XtTranslateCoords: (^(x), ^(y), ^(return-x), ^(return-y))
.iE
This function translates the specified (x,y) widget specific
coordinate to a root window specific coordinate.

.iS XtUngrabButton 0
xtent.widget.XtUngrabButton: (^(button), ^(modifiers))
.iE
This function releases a grab previously placed on a pointer button.
.XI "mouse pointer"

.iS XtUngrabKey 0
xtent.widget.XtUngrabKey: (^(keycode), ^(modifiers))
.iE
This function releases a grab previously placed on a key.

.iS XtUngrabKeyBoard 0
xtent.widget.XtUngrabKeyBoard: ^(time)
.iE
This function releases the keyboard from an earlier grab.
.XI "keyboard handling"

.iS XtUngrabPointer 0
xtent.widget.XtUngrabPointer: ^(time)
.iE
This function releases the pointer from an earlier grab.
.XI "mouse pointer"

.iS XtUninstallTranslations 0
xtent.widget.XtUninstallTranslations:
.iE
This function removes all of the translations for the specified
.XI "translations"
widget.

.iS XtUnmanageChild 0
xtent.widget.XtUnmanageChild:
.iE
This function sets the specified widget to be unmanaged.

.iS XtUnmanageChildren 0
xtent.widget.XtUnmanageChildren: (^(widget-list-name),
                                 ^(widget-count-name))
.iE
This function unmanages a list of widgets.  The widget list and the
length of the list are retrieved from the widgets resource list.  The
names provided are used to request the list and the count from the
widget.

.iS XtUnmapWidget 0
xtent.widget.XtUnmapWidget:
.iE
This function unmaps the specified widget.

.iS XtUnrealizeWidget 0
xtent.widget.XtUnrealizeWidget:
.iE
This function unrealizes the specified widget.

.iS XtVaCreateManagedWidget 0
xtent.widget.XtVaCreateManagedWidget: (^(widget-class),
                 ^(resource-name1), ^(resource-value1),
                 ^(resource-name2), ^(resource-value2),
                 ^(resource-name3), ^(resource-value3),
                 ...
.iE
This function creates a managed widget with the specified widget
class.  This function behaves in the same manner as
.XI "widget class"
\f(CWXtCreateManagedWidget\fP with the exception that initial values
for the widget are passed in as name/value pairs, rather than being
set as resource variables.

.iS XtVaCreatePopupShell 0
xtent.widget.XtVaCreatePopupShell: (^(widget-class),
                 ^(resource-name1), ^(resource-value1),
                 ^(resource-name2), ^(resource-value2),
                 ^(resource-name3), ^(resource-value3),
                 ...
.iE
This function creates a shell widget with the specified widget class.
.XI "popup"
.XI "widget class"
This function behaves in the same manner as
\f(CWXtCreatePopupShell\fP with the exception that initial values
for the widget are passed in as name/value pairs, rather than being
set as resource variables.

.iS XtVaCreateWidget 0
xtent.widget.XtVaCreateWidget: (^(widget-class),
                 ^(resource-name1), ^(resource-value1),
                 ^(resource-name2), ^(resource-value2),
                 ^(resource-name3), ^(resource-value3),
                 ...
.iE
This function creates an unmanaged widget with the specified widget
class.  This function behaves in the same manner as
.XI "widget class"
\f(CWXtCreateWidget\fP with the exception that initial values for the
widget are passed in as name/value pairs, rather than being set as
resource variables.

.iS XtWindow 0
xtent.widget.XtWindow: ^(widget-window-number),
.iE
This function returns the the window number of the specified widget.

.iS XtWindowToWidget 0
xtent.XtWindowToWidget: (^(window-number),
                         ^(widget-name-return))
.iE
This function returns widget name that is associated with a window ID.
If the window does not match that of any widget, the widget name is
set to \f(CWNone\fP.

.ne 10
.H 2 "Widget Manipulation Functions"
.XI "widget manipulation functions"
This set of functions is used to extend the widget manipulation
functions supplied by the X Toolkit (i.e. Xt).

.TS
center doublebox, tab(;);
l l l.

XtDragWidget;XtGetWidget;XtIsWidget;
XtLowerWidget;XtMapWindow;XtRaiseWidget;
XtReparentWindow;XtUnmapWindow;;

.TE
.ce 1
.TB "Widget Manipulation Functions"

.iS XtDragWidget 0
xtent.widget.XtDragWidget: (^(format), ^(font),
                            ^(bool-move-window),
                            ^(bool-use-setvalues),
                            ^(return-x), ^(return-y))
.iE
This function can be used to interactively drag a widget.  The format
variable specifies the prompting information.  A typical format is ``[
Move Widget (%d:%d) ].''  The format string must contain two or zero
occurrences of the integer format command \f(CW%d\fP.  The format is
displayed using the specified font.  The boolean value,
.XI "font"
\f(CWbool-move-window\fP, should be set to \f(CWTrue\fP if the
prompting window is to track or move with the pointer.
.XI "mouse pointer"
\f(CWbool-use-setvalues\fP should be \f(CWTrue\fP if the widget is to
be moved using calls to \f(CWXtSetValues()\fP.  If the value is
\f(CWFalse\fP, then the widget will be moved using
\f(CWXtMoveWidget()\fP.  The final position of the pointer will be
returned under the x and y return variables.

.iS XtGetWidget 0
xtent.widget.XtGetWidget: (^(format), ^(font),
                           ^(bool-move-window),
                           ^(cursor-name),
                           ^(return-widget-name))
.iE
This function allows the end user to select a widget that is a
descendant of the specified widget.  The format variable specifies the
prompting information.  A typical format is ``[ x=%d y=%d ].''  The
format string must contain two, or zero occurrences of the integer
format command \f(CW%d\fP.  The format is displayed using the
specified font.  The boolean value, \f(CWbool-move-window\fP, should
.XI "font"
be set to \f(CWTrue\fP if the prompting window is to track or move
with the pointer.  The cursor name is one of the standard X cursors.
.XI "mouse pointer"
.XI "cursor"
The name of the selected widget will be returned under the widget
return variable name.

.iS XtIsWidget 0
xtent.widget.XtIsWidget: ^(return-variable)
.iE
This function sets the return variable to \f(CWTrue\fP if the
specified widget is in fact a widget.  If the named widget does not
exist the variable is set to \f(CWFalse\fP.

.iS XtLowerWidget 0
xtent.widget.XtLowerWidget:
.iE
This function lowers the widget to the bottom of the window tree.

.iS XtMapWindow 0
xtent.widget.XtMapWindow:
.iE
This function causes the window of the specified widget to be mapped
or remapped.  This function tries to keep the window manager from
asking the end user to reposition the window.

.iS XtRaiseWidget 0
xtent.widget.XtRaiseWidget:
.iE
This function raises the specified widget to the top of the window
hierarchy.  If the toplevel widget is specified,
.XI "toplevel widget"
\f(CWxtent.XtRaiseWidget:\fP, then the application is raised on the
root window.

.iS XtReparentWindow 0
xtent.widget.XtReparentWindow: (^(window), ^(x), ^(y))
.iE
This function reparents the specified window to the window of the
specified widget.  \f(CWx\fP and \f(CWy\fP specify the new position of
the reparented window.  The window is added to the save set of the
application.

.iS XtUnmapWindow 0
xtent.widget.XtUnmapWindow:
.iE
This function unmaps the window associated with the specified widget.
See \f(CWXtMapWindow\fP.

.ne 20
.H 2 "Graphics Data Manipulation Functions"
.XI "graphics data  manipulation functions"
This group of functions is used to manipulate the data associated with
graphic applications.  These include colormaps, images, and cursors.
The type coercion machinery in xtent handles the majority of these
sorts of interactions.  For example, setting a widget pixel resource
to \f(CWred\fP will automatically allocate the color.  Some
applications may wish to call these routines to allow for finer
grained control.
.TS
center doublebox, tab(;);
l l l.

XtAllocColor;XtCreateColormap;XtCreateImageCursor;
XtDefineCursor;XtFreeColor;XtFreeColormap;
XtFreeImage;XtFreeImageCursor;XtFreePixmap;
XtGetImage;XtGetPixel;XtGetPoint;
XtGetRect;XtQueryPixel;XtQueryPointer;
XtReadImage;XtReadPixmap;XtScaleImage;
XtStringSize;XtSync;XtWarpPointer;
XtWriteImage;XtWritePixmap;;

.TE
.ce 1
.TB "Graphic Data Manipulation Functions"

.iS XtAllocColor 0
xtent.XtAllocColor: (^(color-map), ^(color-name),
                     ^(return-pixel))
.iE
This function allocates a color in a colormap and returns the pixel
.XI "pixel value"
.XI "color"
value.  If the \f(CWcolor-map\fP is a NULL string or is equal to
\f(CWXtDefaultColormap\fP, then the default colormap will be used.  The
.XI "colormap"
\f(CWcolor-name\fP may be a named color for the X color database or an
RGB color specification in the form #RRGGBB.
.XI "RGB"

.iS XtCreateColormap 0
xtent.XtCreateColormap: ^(colormap-name)
.iE
This function creates a new colormap that can be accessed with the
.XI "colormap"
specified name.

.iS XtCreateImageCursor 0
xtent.XtCreateImageCursor: (^(image-name),
                            ^(image-mask-name),
                            ^(foreground-color),
                            ^(background-color),
                            ^(x-hotspot),
                            ^(y-hotspot))
.iE
This function creates a cursor from am image and an optional image
mask.  The new cursor can be accessed with the specified image name.


.iS XtDefineCursor 0
xtent.widget.XtDefineCursor: ^(cursor-name)
.iE
This function allows an application to set the cursor for widgets that
do not have an application settable cursor resource.  The cursor type
converter supports all of the X, OpenLook cursors, and cursors from
images.  The OpenLook cursors are named after the silly function based
method of accessing them.  Use \f(CWOlGetMoveCursor\fP to specify the
\f(CWMove Cursor\fP.

.iS XtFreeColor 0
xtent.XtFreeColor: (^(color-map), ^(color-name))
.iE
This function frees the named color from the named colormap. If the
.XI "colormap"
.XI "color"
\f(CWcolor-map\fP is a NULL string or is equal to
\f(CWXtDefaultColormap\fP then the default colormap will be used.  The
\f(CWcolor-name\fP may be a named color from the X color database or
an RGB color specification in the form #RRGGBB.
.XI "RGB"

.iS XtFreeColormap 0
xtent.XtFreeColormap: ^(colormap-name)
.iE
This function frees the named colormap.
.XI "colormap"

.iS XtFreeImage 0
xtent.XtFreeImage: ^(image-name)
.iE
This function frees the named image.
.XI "images"

.iS XtFreeImageCursor 0
xtent.XtFreeImageCursor: ^(image-cursor-name)
.iE
This function frees the named image cursor.
.XI "cursor"
.XI "images"

.iS XtFreePixmap 0
xtent.XtFreePixmap: ^(pixmap-name)
.iE
This function frees the named pixmap.
.XI "pixmap"

.iS XtGetImage 0
xtent.widget.XtGetImage: (^(x), ^(y), ^(width), ^(height),
                          ^(return-image-name))
.iE
This function gets an image from the specified widget as it appears on
.XI "images"
the display.  If the widget name is \f(CWxtent.theRootWindow\fP, then
the image will be taken from the root window.  The
\f(CWreturn-image-name\fP is used to return the name of the image.
xtent generates unique image names for each get image to avoid value
caching problems found in some widgets.

.iS XtGetPixel 0
xtent.widget.XtGetPixel: (^(colormap), ^(x), ^(y),
                          ^(return-pixel), ^(red),
                          ^(green), ^(blue))
.iE
This function gets the single pixel value at the specified (x, y)
.XI "pixel value"
position of the named widget.  If the widget name is
\f(CWxtent.theRootWindow\fP, then the pixel will be taken from the
root window.  The \f(CWreturn-pixel\fP is used to return the screen
value at that position.  \f(CWred\fP, \f(CWgreen\fP, and \f(CWblue\fP
are used to return the colormap values for the pixel value.
.XI "colormap"

.iS XtGetPoint 0
xtent.widget.XtGetPoint: (^(format), ^(font),
                          ^(bool-move-window),
                          ^(cursor-name),
                          ^(return-x), ^(return-y))
.iE
This function allows the end user to select a point from the specified
widget.  If the widget name is \f(CWxtent.theRootWindow\fP, then the
point will be selected in the root window.  The format variable
specifies the prompting information.  A typical format is ``[ Select a
point (%d:%d) ].''  The format string must contain two or zero
occurrences of the integer format command \f(CW%d\fP.  The format is
displayed using the specified font.  The boolean value,
.XI "font"
\f(CWbool-move-window\fP, should be set to \f(CWTrue\fP if the
prompting window is to track or move with the pointer.  The cursor
.XI "mouse pointer"
.XI "cursor"
name is one of the standard X cursors.  The (x, y) position will be
returned under the x and y return variable names.

.iS XtGetRect 0
xtent.widget.XtGetRect: (^(format), ^(font),
                         ^(bool-move-window),
                         ^(return-x), ^(return-y),
                         ^(return-width), ^(return-height))
.iE
This function allows the end user to select a rectangle from the
specified widget.  If the widget name is \f(CWxtent.theRootWindow\fP,
then the rectangle will be selected in the root window.  The format
variable specifies the prompting information.  A typical format is ``[
x=%d y=%d width=%d height=%d ].''  The format string must contain
four, two, or zero occurrences of the integer format command
\f(CW%d\fP.  The format is displayed using the specified font.  The
.XI "font"
boolean value, \f(CWbool-move-window\fP, should be set to \f(CWTrue\fP
if the prompting window is to track or move with the pointer.  The
.XI "mouse pointer"
rectangle coordinates will be returned under the x, y, width, and
height return variable names.

.iS XtQueryPixel 0
xtent.XtQueryPixel: (^(colormap), ^(pixel),
                     ^(return-red),
                     ^(return-green),
                     ^(return-blue),
                     ^(flags))
.iE
This function allows the application to examine the RGB values for a
specified pixel.  This is a thin veneer on top of \f(CWXQueryColor()\fP.
If the \f(CWcolor-map\fP is a NULL string or is equal to
\f(CWXtDefaultColormap\fP then the default colormap will be used.
The pixel should be an integer within the range of the colormap.

.iS XtQueryPointer 0
xtent.widget.XtQueryPointer: (^(return-widget), 
                              ^(return-x), ^(return-y),
                              ^(return-state))
.iE
This function allows the application to examine the state of the
pointer (i.e. mouse).  This is a thin veneer on top of
\f(CWXQueryPointer()\fP.  If the widget name is
\f(CWxtent.theRootWindow\fP, then the (x, y) return values will be
relative to the root window.  The \f(CWstate\fP indicates the state of
the buttons on the pointing device.

.iS XtReadImage 0
xtent.XtReadImage: (^(image-file-name), ^(image-type),
                    ^(bool-new-colormap))
.iE
This function reads an image from a named file.  There are two
.XI "images"
supported image types for input: \f(CWbitmap\fP and \f(CWtif\fP.  If
.XI "bitmap"
no type is supplied \f(CWbitmap\fP is assumed.  If the
\f(CWbool-new-colormap\fP is \f(CWTrue\fP, then a new colormap will be
.XI "colormap"
created for the image.  The image is corrected to match the depth of
the display upon which the application is running.  Color images are
.XI "color"
dithered to one bit deep for monochrome displays and bitmaps and
.XI "monochrome"
.XI "dithered images"
pseudo color images are converted to the correct number of bits for
pseudo color displays.

.iS XtReadPixmap 0
xtent.XtReadPixmap: (^(image-file-name), ^(image-type),
                     ^(bool-new-colormap))
.iE
This function reads a pixmap from a named file.  There are two pixmap
.XI "pixmap"
types: \f(CWbitmap\fP and \f(CWtif\fP.  If no type is supplied
.XI "bitmap"
\f(CWbitmap\fP is assumed.  If the \f(CWbool-new-colormap\fP is
.XI "colormap"
\f(CWTrue\fP, then a new colormap will be created for the pixmap.  The
.XI "pixmap"
pixmap is corrected to match the depth of the display upon which the
application is running.  Color pixmaps are dithered to one bit deep
.XI "dithered images"
.XI "color"
for monochrome displays and bitmaps and pseudo color images are
.XI "monochrome"
converted to the correct number of bits for pseudo color displays.

.iS XtScaleImage 0
xtent.XtScaleImage: (^(image-name), ^(width), ^(height),
                     ^(return-image-name))
.iE
This function scales the specified image to the specified width and
.XI "images"
height.  The scaling is done by a simple sampling algorithm.  The name
of the new image is returned under the specified return image name.

.iS XtStringSize 0
xtent.XtStringSize: (^(font), ^(string),
                     ^(return-string-left), ^(return-string-width),
                     ^(return-string-height) ^(return-font-height))
.iE
This function is used to determine font information.  The font
.XI "font"
specific extents are calculated for the given string using the
specified font.  The left bearing of the string (left overhang) is
returned under the left variable.  The right bearing of the string is
returned under the width variable.  The string specific height is
returned under the string height variable and the font specific height
is returned under the font height variable.

.iS XtSync 0
xtent.XtSync: ^(discard-pending-events-boolean)
.iE
This ``function flushes the X output buffer and then waits until all
requests have been received and processed by the X server.''  This is
a thin veneer on top of \f(CWXSync()\fP.  If the argument is
\f(CWTrue\fP then all pending events in the event queue are discarded.

.iS XtWarpPointer 0
xtent.widget.XtWarpPointer: (^(x), ^(y))
.iE
This function moves the pointer to the position specified within the
.XI "mouse pointer"
widget.
.CW
 xtent.form.outwidth.XtWarpPointer: (^{xtent.form.outwidth.width},\\\\ 
                                     ^{xtent.form.outwidth.height})
.CN
The line above warps the pointer to the lower right hand corner of the
widget \f(CWxtent.form.outwidth\fP.

.iS XtWriteImage 0
xtent.XtWriteImage: (^(image-name), ^(output-file-name),
                     ^(image-type))
.iE
This function writes an image to a named file.  There are three output
.XI "images"
image formats: \f(CWbitmap\fP, \f(CWtif\fP, and \f(CWpostscript\fP.
.XI "bitmap"
If no type is supplied, \f(CWbitmap\fP is assumed.  Pseudocolor images
are converted to greyscale for \f(CWpostscript\fP format files.
.XI "greyscale"

.iS XtWritePixmap 0
xtent.XtWritePixmap: (^(pixmap-name), ^(output-file-name),
                      ^(pixmap-type))
.iE
This function writes a pixmap to a named file.  There are three output
pixmap formats: \f(CWbitmap\fP, \f(CWtif\fP, and \f(CWpostscript\fP.
.XI "pixmap"
.XI "bitmap"
If no type is supplied, \f(CWbitmap\fP is assumed.  Pseudocolor pixmaps
are converted to greyscale for \f(CWpostscript\fP format files.
.XI "greyscale"

.ne 10
.H 2 "Resource Database Access Functions"
.XI "resource database access functions"
This group of functions is used manipulate the resource database.
.TS
center doublebox, tab(;);
l l l.

XtGet;XtSet;;

XtConvertCtoResources;XtCreateResourceList;;

.TE
.ce 1
.TB "Resource Database Access Functions"

.iS XtGet 0
xtent.XtGet: (^(resource-name1), ^(return-variable1),
              ^(resource-name2), ^(return-variable2),
              ^(resource-name3), ^(return-variable3),
              ...)
.iE
This function is the \f(CWXtGetValues\fP equivalent for the resource
database.  \f(CWXtGet\fP retrieves values from the resource database
and stores them under specified variables.  This function can be used
to reduce the level of indirection required to access some data
element.
.CW
    a: 23
    b: a

    .XtGet: (b, c)
    .XtPrint: ^(c)
    \fIa\fP

    .XtGet: (^(b), c)
    .XtPrint: ^(c)
    \fI23\fP

    .XtPrint: ^(^(b))
    \fI23\fP
.CN

.iS XtSet 0
xtent.XtSet: (^(resource-name1), ^(value1),
              ^(resource-name2), ^(value2),
              ^(resource-name3), ^(value3),
              ...)
.iE
This function is the \f(CWXtSetValues\fP equivalent for the resource
database.  This function should be used when one needs to have the
right hand side of an X resource assignment macro expanded.
.CW
    a: 23
    b: ^(a)
    .XtPrint: ^(b)
    \fI^(a)\fP

    .XtSet: (c, ^(a))
    .XtPrint: ^(c)
    \fI23\fP

    .XtEval: (d: ^(a))
    .XtPrint: ^(d)
    \fI23\fP
.CN

.iS XtConvertCtoResources 0
xtent.XtConvertCtoResources: (^(C-pointer),
                              ^(C-data-type),
                              ^(resource-prefix))
.iE
This function converts a C data structure into entries in the resource
data base.  C data is available in event handlers and widget
callbacks.  See the section on ``Context Specific Variables''.  These
C data pointers may be converted into resources with the specified
resource prefix.  The description of the C data is accomplished with
\f(CWXtCreateResourceList\fP.  The following example is from an event
handler.
.CW
  !!!
  !!! add an event handler for button press events
  !!!
  xtent.message.XtAddEventHandler: (^(ButtonPressMask),
                                    False, .Xthandler:)
  ...

  !!!
  !!! a function for looking at the event structure
  !!!
  .XtAddFunction: (handler, handler)
  handler: .Xt_Eval: \#
  (
   .XtConvertCtoResources: (^(%event.pointer), ButtonEvent, e),

   .XtPrint: e.type=^(e.type),
   .XtPrint: e.x=^(e.x),
   .XtPrint: e.y=^(e.y),
   .XtPrint: e.x_root=^(e.x_root),
   .XtPrint: e.y_root=^(e.y_root),

   .XtPrint: e.display.major_version=^(e.display.major_version),
   .XtPrint: e.display.vendor=^(e.display.vendor),
   .XtPrint: e.display.display_name=^(e.display.display_name),

   %event.continue-to-dispatch: False
  )
  #

.ft R
The following output is from the event handler:
.ft P

.ft I
  e.type=4
  e.x=114
  e.y=11
  e.x_root=853
  e.y_root=313
  e.display.major_version=11
  e.display.vendor=X11/NeWS - Sun Microsystems Inc.
  e.display.display_name=cinnamon:0.0
.ft P
.CN

.iS XtCreateResourceList 0
xtent.XtCreateResourceList: (^(list-name),
                             ^(name1), ^(class1), ^(type1),
                             ^(size1), ^(offset1), ^(def1),

                             ^(name2), ^(class2), ^(type2),
                             ^(size2), ^(offset2), ^(def2),

                             ^(name3), ^(class3), ^(type3),
                             ^(size3), ^(offset3), ^(def3),

                             ...)
.iE
This function creates named resource lists that can be used by the
\f(CWXtConvertCtoResources\fP function and others.  A resource list is
an array of XtResource structures.  These are the structures that are
used to create widget resources by widget writers.  The first argument
is the name under which the resource list will be stored.  The next
six arguments specify the name, class, data type, size of the data
type, offset to this element in the data structure, and default value.
These six elements are entered once for each entry in the data
structure.
.P
The following example creates the resources that are used in the
\f(CWXtConvertCtoResources\fP event handler example above.  Notice
that a data type of the form \f(CWstruct:other type\fP causes the
conversion to chain off to the \f(CWother type\fP.
.CW
  !!!
  !!! some fields in the ButtonEvent
  !!!
  !!!    name, class, type, size, offset, default
  !!!
  .XtCreateResourceList: (ButtonEvent, \\\\#
                     type, , Int,            4,  0, 0,
                        x, , Int,            4, 32, 0,
                        y, , Int,            4, 36, 0,
                   x_root, , Int,            4, 40, 0,
                   y_root, , Int,            4, 44, 0,
                  display, , struct:Display, 4, 12, 0)
  #

  !!!
  !!! some fields in the Display
  !!!
  .XtCreateResourceList: (Display, \\\\#
                major_version, , Int,    4,  16, 0,
                vendor,        , String, 4,  24, 0,
                display_name,  , String, 4, 128, None)
  #
.CN

.ne 20
.H 2 "Functions for Program Control and Function Definition"
.XI "program control"
.XI "flow control"
.XI "function definition"
This group of functions contains program control and function
definition routines.  These implement a simple function oriented
application development environment.  \f(CWXt_Eval\fP is the construct
that allows expressions to be grouped together to construct
application supplied functions.  \f(CWXt_Eval\fP is similar to \(CW{
... }\fP in the C language.  Groups of expressions may be named with the
\f(CWXtAdd*Function\fP routines.  The rest of the functions provide
for control flow and simple function support.
.TS
center doublebox, tab(;);
l l l.

XtAddFunction;XtAddThisFunction;XtAddCFunction;
XtCase;Xt_Case;XtCopyFunction;
XtEval;Xt_Eval;XtExit;
XtForEach;Xt_ForEach;XtForEachArg;
Xt_ForEachArg;XtFunctionArg;XtIf;
Xt_If;XtInclude;XtIterate;
Xt_Iterate;XtLocalVariables;XtShellEscape;
Xt_ShellEscape;XtReturn;XtReturnN;
XtWhile;Xt_While;;

.TE
.ce 1
.TB "Program Control Functions"

.iS XtAddFunction 0
xtent.XtAddFunction: (^(function-name), ^(function-code),
                      ^(parameter-0), ^(parameter-1), ...)
.iE
This function allows applications to add ``builtin'' functions to
xtent.  The first argument is used to specify the name that will be
used to invoke the function.  The second parameter is the resource
name under which the code for the function is stored.  The rest of the
arguments are the list of formal parameters to the function.
.P
The following adds a a function that prints its last parameter N
.XI "print"
times.
.CW
 .XtAddFunction: (PrintN, PrintN-script, n, arg)
 PrintN-script: .Xt_Eval: \\\\#
 (
  .XtLocalVariables: (i),

  .Xt_Iterate: (i, <, 0, ^(n), 1, .XtPrint: ^(arg))
 )
 #
.CN
The body of the function is found under the resource database variable
.XI "resource database"
\f(CWPrintN-script\fP.  Entering \f(CWxtent.XtPrintN:(3, Bell Labs)\fP
will result in \f(CWBell Labs\fP being printed 3 times.
.CW
 .XtPrintN:(3, Bell Labs)
 \fIBell Labs\fP
 \fIBell Labs\fP
 \fIBell Labs\fP
.CN
Notice that the variable \f(CWn\fP is bound to the number 3 and the
variable \f(CWarg\fP is bound to the string \f(CWBell Labs\fP when
this command is issued.  These variables are reset to their former
values, if any, when the function returns.

.iS XtAddThisFunction 0
xtent.XtAddThisFunction: (^(function-name), ^(function-code),
                          ^(parameter-0), ^(parameter-1), ...)
.iE
This function allows applications to add ``builtin'' functions to
xtent in exactly the same manner as XtAddFunction.  When the
application supplied code is evaluated the resource variable
\f(CWthis\fP will be bound to the object or widget name.  In the
following example, the function \f(CWXtThisPrint\fP will print the
widget name:
.CW
resThisPrint: xtent.XtPrint: this=^(this)
xtent.XtAddThisFunction: (ThisPrint, resThisPrint)

xtent.a.b.c.XtThisPrint:
\fIthis=xtent.a.b.c\fP

xtent.x.XtThisPrint:
\fIthis=xtent.x\fP
.CN
If the \f(CWXtThisPrint\fP is invoked with
\f(CWxtent.a.b.c.XtThisPrint:\fP, it will produce \f(CWxtent.a.b.c\fP.

.iS XtAddCFunction 0
xtent.XtAddCFunction: (^(function-name), ^(C-function-pointer),
                       ^(parameter-0), ^(parameter-1), ...)
.iE
This function allows applications to add ``builtin'' C functions to
xtent.  The first argument is used to specify the name that will be
used to invoke the function.  The second parameter is the pointer to
the C function.  The rest of the arguments are the list of formal
parameters to the function.  Parameters with names that start with an
underscore (i.e. ``_'') will not be macro expanded.  If the last
argument is \f(CW...\fP or \f(CW_...\fP the function will be assumed
to have a variable number of arguments.
.P
There is also a C function interface for adding xtent builtin
commands.
.CW
 void
 print-list (args, count)
 Arg *args;
 int count;
 {
     int i;

     for (i = 0; i < count; i++)
         printf ("list print: (%s, %s)\\\\n",
                 args[i].name, args[i].value);
 }
 ...

    XtentAddCFunction (display, &toplevel, "PrintList",
                       print-list, "a, _b, c, _...");

.CN

.iS XtCase 0
xtent.XtCase: (^(target),
               ^(case-1), ^(code-body-1),
               ^(case-2), ^(code-body-2),
               ^(case-3), ^(code-body-3),
               ...
.iE
This is a simple case construct.  The code body of the case that
matches the target is executed.  The string \f(CWCaseDefault\fP acts
as a default and matches all target strings.

.iS Xt_Case 0
xtent.Xt_Case: (^(target),
                ^(case-1), ^(code-body-1),
                ^(case-2), ^(code-body-2),
                ^(case-3), ^(code-body-3),
                ...
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  Otherwise this function behaves as \f(CWXtCase\fP.

.iS XtCopyFunction 0
xtent.XtCopyFunction: (^(old-function), ^(new-function))
.iE
This function copies an existing function.  For example, the following
might be used to rename \f(CWXtCreateManagedWidget\fP to
\f(CWXtCMW\fP.
.CW
    .XtCopyFunction: (CreateManagedWidget, CMW)
.CN

.iS XtEval 0
xtent.XtEval: (^(line1), ^(line2), ...)
.iE
This function allows for groups of lines to be executed together
similar to a Lisp progn expression or a C function.  This is a very
.XI "Lisp lambda"
.XI "Lisp progn"
simple facility.  Lines are comma separated as are all arguments to
functions.  The following example sets the resource database
variables, \f(CWone, two, \fPand \f(CWthree\fP to 1, 2, and 3.
.CW
     .XtEval: (one: 1, two: 2, three: 3)
.CN
The following example shows how \f(CWXtEval\fP might be used for
a widget callback.
.XI "callback"
.CW
 .form.save.release.XtAddCallback: .XtEval: \\\\#
  (
   .form.outputfile.XtTextCopyBuffer: outputfile,
   .XtWriteImage: (^(image-name), ^(outputfile))
  )
#
.CN
Macro expansion is done a line at a time.
.XI "macro expansion"
This extra level of macro expansion can be quite confusing if the
application developer is not aware that it is being performed.

.iS Xt_Eval 0
xtent.Xt_Eval: (line1, line2, ...)
.iE
This function simply evaluates the character separated lines with no
macro expansion.  In most applications this is the preferred form.
.XI "macro expansion"

.iS XtExit 0
xtent.XtExit: ^(exit-value)
.iE
This function causes the application to exit with the supplied exit
.XI "exit"
code.

.iS XtForEach 0
xtent.XtForEach: (^(variable), ^(code-body),
                  ^(arg1), ^(arg2), ... )
.iE
This function provides a simple iteration mechanism.  It provides
.XI "iteration"
a control mechanism similar to the \f(CWfor var in\fP in the Bourne
shell.  The named variable is
.XI "loop"
set to each of the arguments and the code body is evaluated.
.CW
   print: .XtPrint: i=^(i)
   .XtForEach:(i, ^(print), a, b, c)
   \fIi=a\fP
   \fIi=b\fP
   \fIi=c\fP
.CN
The code body is macro expanded prior to entering the loop.
.XI "macro expansion"
.XI "loop"

.iS Xt_ForEach 0
xtent.Xt_ForEach: (^(variable), ^(code-body),
                   ^(arg1), ^(arg2), ... )
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  \f(CWXt_ForEach\fP otherwise behaves exactly as
\f(CWXtForEach\fP.
.CW
   .Xt_ForEach:(i, .XtPrint: i=^(i), a, b, c)
   \fIi=a\fP
   \fIi=b\fP
   \fIi=c\fP
.CN

.iS XtForEachArg 0
xtent.XtForEachArg: (^(variable), ^(code-body),
                     ^(arg-list))
.iE
This function provides a simple iteration mechanism.  It provides
.XI "iteration"
a control mechanism similar to the \f(CWfor var in\fP in the Bourne
shell.  The named variable is
.XI "loop"
set to each of the arguments and the code body is evaluated.  The last
argument is a comma separated list.
.CW
   print: .XtPrint: i=^(i)
   args: a, b, c
   .XtForEachArg:(i, ^(print), ^(args))
   \fIi=a\fP
   \fIi=b\fP
   \fIi=c\fP
.CN
The code body is macro expanded once, prior to entering the loop.
.XI "macro expansion"
.XI "loop"

.iS Xt_ForEachArg 0
xtent.Xt_ForEachArg: (^(variable), ^(code-body),
                      ^(arg-list))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  \f(CWXt_ForEachArg\fP otherwise behaves exactly as
\f(CWXtForEachArg\fP.

.iS XtFunctionArg 0
xtent.XtFunctionArg: (^(depth), ^(index), ^(expand-boolean),
                     ^(var-return), ^(eol-return))
.iE
This function allows an application to inspect any argument to any
function (i.e. any argument that is currently on the call stack).
This can be useful for producing functions with a variable number of
arguments, or that need to selectively macro expand arguments, or that
extend the functionality of xtent.  The depth argument specifies how
many evaluation blocks to look up the stack.  The index argument
specifies which argument to return.  An index of -1 specifies that the
argument may be presented without parenthesis, see \f(CWXtPrint:\fP.
The expand argument controls macro expansion.  If this argument is
\f(CWTrue\fP then the argument will be macro expanded.
\f(CWvar-return\fP specifies the variable name under which the
argument will be returned.  \f(CWeol-return\fP is \f(CWTrue\fP when
the end of the argument block has been encountered.
.P
The following example uses \f(CWXtFunctionArg\fP to produce a
function, \f(CWXtFunction\fP.  \f(CWXtFunction\fP allows functions to
be specified in one function call.
.CW
  !!!
  !!! XtFunction: (^(name), ^(args), ^(body))
  !!!
  .XtAddFunction: (Function, function)
  function: .Xt_Eval: \\\\#
  (
   .XtLocalVariables: (function-name, arguments,
                       body, eof, count),

   .XtFunctionArg: (1, 0, True, function-name, eof),
   .XtFunctionArg: (1, 1, True, arguments, eof),
   .XtStrGSub: ([\\\\(\\\\)], , ^(arguments), arguments, count),
   .XtFunctionArg: (1, 2, False, body, eof),
   .Xt_If: (^(eof), ==, True, .XtReturn:),

   .XtEval: (.XtAddFunction: (^(function-name),
                                ^(function-name), ^(arguments))),

   .XtSet: (^(function-name), ^(body))
  )
  #

  .XtFunction: (p3, (a, b, c), .XtPrint: a=^(a) b=^(b) c=^(c))

  .Xtp3: (1, 2, 3)
  \fIa=1 b=2 c=3\fP
  .Xtp3: (x, y, z)
  \fIa=x b=y c=z\fP
.CN

.iS XtIf 0
xtent.XtIf: (^(a-variable), ^(op), ^(b-variable),
             ^(then-code), ^(else-code))
.iE
This is a simple if-then-else construct.  Supported values for
\f(CWop\fP are >, >=, <, <=, ==, and !=.  Numbers (i.e. strings
starting with ``-'' or a number) are converted to longs for
comparison.  If either number contains a ``.'' then both numbers are
converted to doubles for the comparison.  All other comparisons are
handled as string comparisons.  The \f(CWthen-code\fP and
\f(CWelse-code\fP are macro once expanded prior to evaluation.
.XI "macro expansion"
.CW
    .XtIf: (X^(xtent.font)X, ==, XX, *font:fixed)
.CN
The example above sets \f(CW*font\fP to \f(CWfixed\fP if
\f(CW^(xtent.font)\fP is NULL.
.XI "font"

.iS Xt_If 0
xtent.Xt_If: (^(a-variable), ^(op), ^(b-variable),
             ^(then-code), ^(else-code))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the ``then'' or
``else'' code body prior to evaluating it.  \f(CWXt_If\fP otherwise
behaves exactly as \f(CWXtIf\fP.

.iS XtInclude 0
xtent.XtInclude: ^(input-file)
.iE
This function reads xtent commands from the specified input file until
an end of file is encountered.  The following command will read input
from the end user.
.CW
    xtent.XtInclude: /dev/tty
.CN
Input from a file will block all other activity in an application.  To
.XI "tty"
set up input from a device that has sporadic input use
\f(CWXtAppAddInput\fP.

.iS XtIterate 0
xtent.XtIterate: (^(variable), ^(op),
                  ^(start), ^(end), ^(step),
                  ^(code-body))
.iE
This function provides a simple iteration mechanism.  It provides
.XI "iteration"
something similar to the \f(CWfor\fP loop in C.  The named variable is
.XI "loop"
set to the start value and incremented by the value of step until
``variable OP end'' is False.  The comparison operations are the same
as those supported for the \f(CWXtIf\fP construct.  The loop
variables, start, end, and step, are all of type integer.  The
following example counts from 0 to 3.
.CW
   print: .XtPrint: i=^(i)
   .XtIterate:(i, <, 0, 4, 1, ^(print))
   \fIi=0\fP
   \fIi=1\fP
   \fIi=2\fP
   \fIi=3\fP
.CN
The code body is macro expanded once, prior to entering the loop.
.XI "macro expansion"
.XI "loop"

.iS Xt_Iterate 0
xtent.Xt_Iterate: (^(variable), ^(op),
                   ^(start), ^(end), ^(step),
                   ^(code-body))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
evaluating it.  \f(CWXt_Iterate\fP otherwise behaves exactly as
\f(CWXtIterate\fP.  The following example counts from 0 to 3.
.CW
   .Xt_Iterate:(i, <, 0, 4, 1, .XtPrint: i=^(i))
   \fIi=0\fP
   \fIi=1\fP
   \fIi=2\fP
   \fIi=3\fP
.CN

.iS XtLocalVariables 0
xtent.XtLocalVariables: (^(var-0), ^(var-1), ...)
.iE
This function creates local variables.  The variables are created and
set to the null string, "".  When the current evaluation frame is
exited the variables are reset to their former values, if any.

.iS XtShellEscape 0
xtent.XtShellEscape: [#] <shell command>
.iE
This function runs a shell command.  The shell command line is macro
.XI "macro expansion"
expanded and then run as a shell command.  If the first character of
the line is a ``#'' then the output of the command is read as xtent
input.  This allows an application to generate xtent commands from
another process.  This is somewhat like the notion of graves in the
.XI "shell graves"
Bourne shell.  The shell environment variable \f(CWSHELL\fP is used to
determine which shell to use to process the command.  \f(CWSHELL\fP is
not set then the command is processed using \f(CW/bin/sh\fP.

.iS Xt_ShellEscape 0
xtent.Xt_ShellEscape: [#] <shell command>
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the shell command
prior to executing it.  \f(CWXt_ShellEscape\fP otherwise behaves
exactly as \f(CWXtShellEscape\fP.

.iS XtReturn 0
xtent.XtReturn: ^(return-value)
.iE
This function will return from \f(CWXtForEach\fP, \f(CWXtEval:\fP,
\f(CWXtIterate\fP, and \f(CWXtWhile\fP constructs.

.iS XtReturnN 0
xtent.XtReturnN: (^(depth), ^(return-value))
.iE
This function will return from \f(CWXtForEach\fP, \f(CWXtEval:\fP,
\f(CWXtIterate\fP, and \f(CWXtWhile\fP constructs.  The depth argument
specifies the number of evaluation levels from which to return.  The
following is a code fragment that uses \f(CWXtReturnN\fP.  In this
example it is used to return from an \f(CWXt_Eval\fP from within an
\f(CWXt_If\fP, which in turn is being called from within a function,
another \f(CWXt_Eval\fP.  \f(CWXtReturnN\fP is required here to from
more than the first \f(CWXt_Eval\fP.
.CW
  .XtAddFunction: (Load, Load, input)
  LoadParameters: .Xt_Eval: \\\\#
  (
   .XtLocalVariables: (fp, i),
  
   .XtFOpen: (^(input), r, fp),
   .Xt_If: (^(fp), ==, False, .Xt_Eval:
   (
          .XtPrint: Cannot open the file "^(input)".,
          .XtBell: (100),
          .XtReturnN: 2
   )),
   ...
  )
  #
.CN

.iS XtWhile 0
xtent.XtWhile: (^(a-variable), ^(op), ^(b-variable),
                ^(while-code))
.iE
This is a simple while loop construct.  Supported values for
.XI "loop"
\f(CWop\fP are >, >=, <, <=, ==, and !=.  Numbers (i.e. strings
starting with ``-'' or a number) are converted to longs for
comparison.  If either number contains a ``.'' then both numbers are
converted to doubles for the comparison.  All other comparisons are
handled as string comparisons.  \f(CWwhile-code\fP is macro expanded
once \(en prior to the first
.XI "macro expansion"
evaluation.
.CW
    .XtWhile: (^(flag), ==, True, xtent.XtF:(x))
.CN
The example above loops running the function \f(CWXtF\fP, until the
value of \f(CWflag\fP is not equal to \f(CWTrue\fP.

.iS Xt_While 0
xtent.Xt_While: (^(a-variable), ^(op), ^(b-variable),
                 ^(while-code))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the while code body
prior to evaluating it.  \f(CWXt_While\fP otherwise behaves exactly
as \f(CWXtWhile\fP.

.ne 15
.H 2 "Calculation Functions"
.XI "calculation functions"
.XI "computation"
.XI "mathematics"
xtent is a good language for specifying and manipulating widgets.
These functions should be used sparingly \(en if at all.  Calculations
should be done in another process which is written in a language that
supports the calculations your application requires.
.P
The following table contains the names of the math functions that are
.XI "math"
currently implemented under xtent.  The functions are described in the
order in which they appear in this table.
.TS
center doublebox, tab(;);
l l l.

XtCalc;XtDoubleCalc;;

.TE
.ce 1
.TB "Calculation Functions"

.iS XtCalc 0
xtent.XtCalc: (^(arg-0), ^(arg-1), ...)
.iE
This function performs mathematical operations similar to those found
in a calculator or a threaded language such as Forth or PostScript.
.XI "PostScript"
Arguments are read from left to right and acted upon.  The action for
numbers or variable names is to simply place them on a stack.  The
action for operations is to consume values from the stack and place
the resultant value on the stack.
.P
To add one and two and assign the result to the resource database
variable \f(CWx\fP, one would do the following:
.CW
 xtent.XtCalc: (1, 2, +, x, =)
.CN
.P
The following table contains the list of operations accepted by
\f(CWXtCalc\fP.  The term \f(CWobject\fP refers to an argument that
can be a string, number, or boolean value (True or False).  The C
definitions of True and False are assumed for conversion of
non-boolean values when they are used with logical operators.  The
number zero and a NULL string are equivalent to False for \f(CW!\fP,
\f(CW&&\fP, and \f(CW||\fP.
.br
.ne 40
.TS
center box, tab(;);
l lB l l.

Stack Arguments; Operation; Stack Result; Description

_

number1 number2; +;number3; adds number1 and number2
number1 number2; -;number3; subtracts number2 from number1
number1 number2; *;number3; multiplies number1 by number2
number1 number2; /;number3; divides number1 by number2

number1; ++;number2; increment
number1; --;number2; decrement

number1 number2; %;number3; number1 modulo number2
number1 number2; &;number3; number1 and'ed with number2
number1 number2; |;number3; number1 or'ed with number2
number1 number2; <<;number3; number1 shifted left by number2
number1 number2; >>;number3; number1 shifted right by number2

number1; ABS;number2; absolute value of number1
number1 number2; EXP;number3; number1 to the number2 power
number1; NEG;number2; number1 multiplied by -1
number1; SQRT;number2; the square root of number1

number1; ACOS; arc cosine of number1 in radians
number1; ASIN; arc sin of number1 in radians
number1; ATAN; arc tangent of number1 in radians
number1 number2; ATAN2; atan2(y,x) of (number1,number2)
number1; COS; cosine of number1 in radians
number1; SIN; sin of number1 in radians
number1; TAN; tangent of number1 in radians

object; !; boolean; logical not
object1 object2; &&; boolean; logical and
object1 object2; ||; boolean; logical or
object1 object2; ==; boolean; equality
object1 object2; !=; boolean; not equal
object1 object2; <; boolean; less than
object1 object2; <=; boolean; less or equal
object1 object2; >; boolean; greater than
object1 object2; >=; boolean; greater or equal

object string; =;object; assign object to resource variable

object; DUP;object object; duplicate the top item
object; RET; object; set the return value

.TE
.ce 1
.TB ".XtCalc Operations"

.iS XtDoubleCalc 0
xtent.XtDoubleCalc: (^(double-arg-0), ^(double-arg-1), ...)
.iE
This is the floating point version of \f(CWXtCalc\fP.  All numbers are
interpreted as doubles.  This uses the same stack machine as
\f(CWXtCalc\fP and differs only in that the numeric operations are all
performed using double precision floating point numbers.

.ne 14
.H 2 "String Manipulation Functions"
.XI "functions for manipulating strings"
.XI "awk functions"
The following table contains the names of the string functions that
are
.XI "string"
currently implemented under xtent.  These functions are modeled after
those found in \f(CWawk\fP.  The functions are described in the order
in which they appear in this table.
.TS
center doublebox, tab(;);
l l l.

XtStrIndex;XtStrGSub;XtStrSub;
XtStrLength;XtStrMatch;XtStrSplitToArgList;
XtStrSplitToResource;XtStrSubstr;

.TE
.ce 1
.TB "String Functions"

.iS XtStrIndex 0
xtent.XtStrIndex: (^(string), ^(sub-string),
                   ^(return-position))
.iE
This function returns the starting position in which the sub-string
appears within the string.  If the sub-string is not contained within
the string, then -1 is returned.  Unlike \f(CWawk\fP, indexing starts
at zero.

.iS XtStrGSub 0
xtent.XtStrGSub: (^(exp), ^(replacement-string), ^(string),
                  ^(return-string), ^(return-count))
.iE
This procedure replaces all occurrences of the regular expression,
\f(CWexp\fP, found in the string with the replacement string.  The new
string is returned in \f(CWreturn-string\fP and the count of the
number of replacements is returned in \f(CWreturn-count\fP.

.iS XtStrSub 0
xtent.XtStrSub: (^(exp), ^(replacement-string), ^(string),
                 ^(return-string), ^(return-count))
.iE
This procedure replaces the first occurrence of the regular expression,
\f(CWexp\fP, found in the string with the replacement string.  The new
string is returned in \f(CWreturn-string\fP and the count of the
number of replacements is returned in \f(CWreturn-count\fP.

.iS XtStrLength 0
xtent.XtStrLength: (^(string), ^(return-length))
.iE
This function counts the number of characters in the specified string.

.iS XtStrMatch 0
xtent.XtStrMatch: (^(string), ^(exp),
                   ^(return-start), ^(return-length))
.iE
This procedure tests whether the regular expression is contained
within the specified string.  The starting index and length of the
matching substring are returned.  If no match is found the start index
is set to -1.  Unlike \f(CWawk\fP, indexing starts at zero.

.iS XtStrSplitToArgList 0
xtent.XtStrSplitToArgList: (^(string), ^(separator),
                            ^(return-string))
.iE
This function splits the specified string into a comma separated list
of strings within a new string.  If a null separator is specified
(i.e. just a comma and no string) then each character of the string
will be taken as a separate substring (e.g. \f(CWabc\fP produces
\f(CWa\fP, \f(CWb\fP, \f(CWc\fP).  The strings produced by this
function may be used as the arguments (plural) to other functions.
.P
The following example demonstrates how a line from the /etc/passwd
file might be manipulated using xtent.  First we use a shell escape to
create a \f(CWbin\fP resource variable.
.CW
  .Xt_ShellEscape: # echo "bin: `grep '^bin'  /etc/passwd`"
  .XtPrint: bin=^(bin)
  \fIbin=bin:*:3:3::/bin:\fP
.CN
Next we split the variable \f(CWbin\fP into a list contained within
the variable \f(CWbin-list\fP.
.CW
  .XtStrSplitToArgList: (^(bin), :, bin-list)
  .XtPrint: bin-list=^(bin-list)
  \fIbin-list=bin, *, 3, 3, , /bin,\fP
.CN
Next we use the list by macro expanding the \f(CWbin-list\fP variable
prior to evaluating the \f(CWxtent.Xt_ForEachArg:\fP.
.CW
  .Xt_ForEachArg: (i, .XtPrint: :^(i):, ^(bin-list))
.ft I
  :bin:
  :*:
  :3:
  :3:
  ::
  :/bin:
  ::
.ft P
.CN

.iS XtStrSplitToResource 0
xtent.XtStrSplitToResource: (^(string), ^(separator),
                             ^(resource-name),
                             ^(starting-index),
                             ^(return-count))
.iE
This function splits the specified string into numbered resource
variables.  If a null separator is specified (i.e. just a comma and no
string) then each character of the string will be taken as a separate
substring (e.g. \f(CWabc\fP produces \f(CWresource-name1:\ a\fP,
\f(CWresource-name2:\ b\fP, \f(CWresource-name3\: c\fP).  Numbering of
the resource variables starts with the specified starting index and is
incremented by one for each string.

.iS XtStrSubstr 0
  XtStrSubstr: (^(string), ^(start), ^(count),
                ^(return-string))
.iE
This function returns a substring from the specified string.  The
return string runs from the specified start position for \f(CWcount\fP
characters.  If \f(CWcount\fP is -1, the substring will run from the
start index to the end of the string.  Unlike \f(CWawk\fP, indexing
starts at zero.

.ne 20
.H 2 "Input and Output Functions"
.XI "I/O functions"
.XI "input and output functions"
This group of functions is used to handle input and output associated
with an xtent application.  This includes a C like standard I/O
package and print functions for inspecting the state of the
application.

.TS
center doublebox, tab(;);
l l l.

XtFOpen;XtFClose;XtFFlush;
XtFGetS;XtFPrintF;XtSPrintF;
XtPOpen;XtPClose;XtStatF;

XtSetStdin;XtSetStdout;XtSetStderr;

XtPrint;XtPrintOperations;XtPrintResources;
XtPrintWidgetClasses;XtPrintWidgetResources;XtPrintWidgets;

XtBell;

.TE
.ce 1
.TB "Input and Output Functions"

.iS XtFOpen 0
xtent.XtFOpen: (^(file-name), ^(read-write-type),
                ^(return-file-descriptor))
.iE
This function behaves as \f(CWfopen()\fP in the C library.  The first
argument is the name of the file to open.  The second argument is the
type of access for the file.  See the table below.  The file
descriptor is returned under the third argument.  \f(CWFalse\fP is
returned if the file cannot be opened.  Following is a table of legal
values for the \f(CWread-write-type\fP.
.br
.ne 20
.TS
center box, tab(;);
c l.

r;open for reading;
w;truncate or create for writing;
a;append: create or write at end of file;
r+;open for update (reading and writing);
w+;truncate or create for update;
a+;append; open or create for update at EOF;

.TE
.ce 1
.TB "File access types for XtFOpen"

.iS XtFClose 0
xtent.XtFClose: (^(file-descriptor), ^(return-code))
.iE
This function behaves as \f(CWfclose()\fP in the C library.  The file
descriptor is the descriptor returned from \f(CWXtFOpen\fP.  If the
file is closed without error \f(CWreturn-code\fP will be set to
\f(CWTrue\fP, otherwise it will be set to \f(CWFalse\fP.

.iS XtFFlush 0
xtent.XtFFlush: (^(file-descriptor), ^(return-code))
.iE
This function behaves as \f(CWfflush()\fP in the C library.  The file
descriptor is the descriptor returned from \f(CWXtFOpen\fP.  If the
file is flushed without error \f(CWreturn-code\fP will be set to
\f(CWTrue\fP, otherwise it will be set to \f(CWFalse\fP.  The strings
\f(CWstdout\fP and \f(CWstderr\fP maybe used to flush \f(CWstdout\fP
and \f(CWstderr\fP.

.iS XtFGetS 0
xtent.XtFGetS: (^(return-string-name), ^(size),
                ^(file-descriptor), ^(return-code))
.iE
This function behaves as \f(CWfgets()\fP in the C library.  The string
that is read will be returned under the return string name.
\f(CWXtFGetS\fP reads characters from the file descriptor until size -
1 characters are read, a newline character is read, or an end of file
condition is encountered.  The file descriptor is the descriptor
returned from \f(CWXtFOpen\fP.  The string \f(CWstdin\fP maybe used to
read \f(CWstdin\fP.  If an error or end of file occurred during the
read, \f(CWreturn-code\fP will be set to \f(CWTrue\fP, otherwise it
will be set to \f(CWFalse\fP.

.iS XtFPrintF 0
xtent.XtFPrintF: (^(file-descriptor), ^(format), ... )
.iE
This function behaves as \f(CWfprintf()\fP in the C library.  The file
descriptor is the descriptor returned from \f(CWXtFOpen\fP.  The
strings \f(CWstdout\fP and \f(CWstderr\fP maybe used to print
\f(CWstdout\fP and \f(CWstderr\fP.  The format string controls the
interpretation of the rest of the arguments.

.iS XtSPrintF 0
xtent.XtSPrintF: (^(return-string-name), ^(format), ... )
.iE
This function behaves as \f(CWsprintf()\fP in the C library.  The
format string controls the interpretation of the rest of the
arguments.  The string that is created will be returned under the
return string name.

.iS XtPOpen 0
xtent.XtPOpen: (^(process-name), ^(read-write-type),
                ^(return-file-descriptor))
.iE
This function behaves as \f(CWpopen()\fP in the C library.  The first
argument is the name of the process to open.  The second argument is
the type of access for the process.  See the table under
\f(CWXtFOpen\fP.  The file descriptor is returned under the third
argument.  \f(CWFalse\fP is returned if the process cannot be opened.
The shell environment variable \f(CWSHELL\fP is used to determine
which shell to use to process the command.  \f(CWSHELL\fP is not set
then the command is processed using \f(CW/bin/sh\fP.

.iS XtPClose 0
xtent.XtPClose: (^(process-file-descriptor), ^(return-code))
.iE
This function behaves as \f(CWpclose()\fP in the C library.  The file
descriptor is the descriptor returned from \f(CWXtPOpen\fP.  If the
process is closed without error \f(CWreturn-code\fP will be set to
\f(CWTrue\fP, otherwise it will be set to \f(CWFalse\fP.

.iS XtStatF 0
xtent.XtStatF: (^(file-name), ^(success), ^(mode), ^(size))
.iE
This function behaves as \f(CWstat()\fP in the C library.  However,
the mode fields reflect the access that is provided to this process.
For example, if the read bit is set, then this process can read the
file.  If the named file can be found, then success is set to
\f(CWTrue\fP otherwise, \f(CWFalse\fP.  The length of the file is
returned under the size parameter.  The following is a function that
provides an \f(CWaccess()\fP like interface using \f(CWXtStatF\fP.
.CW
  !!!
  !!! test script for XtStatF:
  !!!
  .XtAddFunction: (Access, _Access, file, type, return)
  _Access: .Xt_Eval:\#
  (
   .XtLocalVariables: (status, mode, size, mask),
  
   .XtStatF: (^(file), status, mode, size),

   .Xt_Case: (^(type),
      execute,     mask: 1,
      write,       mask: 2,
      read,        mask: 4,
      CaseDefault, mask: 0),

   .XtCalc: (^(mode), ^(mask), &, 0, !=, 
             ^(return), =, status, =),

   .XtReturn: ^(status)
  )
  #

  .XtPrint: ^[.XtAccess: (/etc/passwd, read)]
  \fITrue\fP

  .XtPrint: ^[.XtAccess: (/etc/passwd, write)]
  \fIFalse\fP
.CN

.iS XtSetStdin 0
xtent.XtSetStdin: ^(input-file-name)
.iE
This function resets the standard input device to the named file.

.iS XtSetStdout 0
xtent.XtSetStdout: ^(output-file-name)
.iE
This function resets the standard output device to the named file.

.iS XtSetStderr 0
xtent.XtSetStderr: ^(output-file-name)
.iE
This function resets the standard error output device to the named
file.

.iS XtPrint 0
xtent.widget.XtPrint: <line to be printed>
.iE
This function macro expands the line and prints the resultant string
.XI "print"
.XI "macro expansion"
and a newline to standard output.

.iS XtPrintOperations 0
xtent.XtPrintOperations: ^(output-file)
.iE
This function prints the names of all of the supported operations.  If
.XI "print"
no output file is specified the output is sent to standard out.  This
is the list of all of the builtin commands within \f(CWxtent\fP.
.XI "builtin functions"

.iS XtPrintResources 0
xtent.XtPrintResources: ^(output-file)
.iE
This function prints the current contents of the resource database to
.XI "print"
the named file.  If no output file is specified the output is sent to
standard out.

.iS XtPrintWidgetClasses 0
xtent.widget.XtPrintWidgetClasses: ^(output-file)
.iE
This function prints the class names of all of the supported widgets.
.XI "print"
.XI "widget class"
If no output file is specified the output is sent to standard out.
These are the names that are accepted by XtCreateWidget and
XtCreateManagedWidget.

.iS XtPrintWidgetResources 0
xtent.widget.XtPrintWidgetResources: ^(output-file)
.iE
This function prints the resources associated with the specified
.XI "print"
widget.  If no output file is specified the output is sent to standard
out.  Each resource is printed as a two line entry.
.CW
xtent.Hello.x: 659
xtent.Hello.x.XtRType: Position
.CN
The first line is a standard resource entry that contains the value of
the widget resource.  The second entry is a resource variable name
that ends in \f(CWXtRType\fP and has as its value the resource type.
These lines can be used to freeze dry the current state of a widget for
later reuse.

.iS XtPrintWidgets 0
xtent.widget.XtPrintWidgets: ^(output-file)
.iE
This function prints the widget tree starting with the specified
.XI "print"
widget.  If no output file is specified the output is sent to standard
output.

.iS XtBell 0
xtent.XtBell: ^(percent)
.iE
This function calls the Xlib XBell function.  The percent argument
determines the bell volume.  This parameter should be in the range
-100 though 100.

.ne 12
.H 2 "Application (Process) Data Access Functions"
.XI "process data functions"
.XI "application data functions"
.XI "argv"
.XI "argc"
.XI "shell environment"
.XO "shell variables"
This group of functions is used to manipulate data associated with a
running process.  This includes handling the arguments passed into the
process by the shell and manipulating shell variables.
.TS
center doublebox, tab(;);
l l l.

XtArgc;XtArgv;XtInternShellVariables;
XtSetShellVariables;XtUnsetShellVariables;;

.TE
.ce 1
.TB "Application (Process) Data Functions"

.iS XtArgc 0
xtent.XtArgc: ^(argc-return)
.iE
This function returns the number of command line arguments that were
given to the interpreter.

.iS XtArgv 0
xtent.XtArgv: (^(arg-index), ^(argv-return-variable))
.iE
This function returns one of the command line arguments.  The indexed
command line entry is returned under the return variable name.

.iS XtInternShellVariables 0
xtent.XtInternShellVariables: (^(var-0), ^(var-1), ...)
.iE
This function copies the specified shell environment variables into
the resource database.  If no arguments are provided then all of the
application's environment variables are copied into the resource
database.  The following line could be used to install the user's home
directory and username.
.CW
  xtent.XtInternShellVariables: (HOME, USER)
.CN

.iS XtSetShellVariables 0
xtent.XtSetShellVariables: (^(name1), ^(value1),
                            ^(name2), ^(value2),
                            ^(name3), ^(value3),
                           ...)
.iE
.XI "setenv"
This function creates or resets shell variables.  This function allows
the application to set multiple variables (VARARGS) at once.  The
specified name-value pairs are entered into the process's environment.
Subsequent shell escapes will include the new variables.

.iS XtUnsetShellVariables 0
xtent.XtUnsetShellVariables: (^(name1),
                              ^(name2),
                              ^(name3),
                              ...)
.iE
This function removes shell variables from the process's environment.
This function allows the application to remove multiple variables
(VARARGS) at once.  If the first argument is \f(CW-all\fP, then all of
the environment variables will be removed.  Subsequent shell escapes
will include the environment with the variables removed.

.ne 16
.H 2 "Debugging Support Functions"
.XI "debugging support functions"
This group of functions is used for trace and single step style
debugging of an xtent based application.  The functions
\f(CWXtPrint\fP, \f(CWXtPrintOperations\fP, \f(CWXtPrintResources\fP,
\f(CWXtPrintWidgetClasses\fP, \f(CWXtPrintWidgetResources\fP, and
\f(CWXtPrintWidgets\fP are all used to inspect the state of a running
application.  To that extent they also can be considered debugging
tools.  Trace and single step style debugging are both implemented by
specifying an action that will occur prior to the execution of every
statement.  This is done with the function \f(CWXtInternLines\fP.

.TS
center doublebox, tab(;);
l l l.

XtInternLines;;;

.TE
.ce 1
.TB "Debugging Functions"

.iS XtInternLines 0
xtent.XtInternLines: (^(bool-enable), ^(intern-code))
.iE
This function allows the application to be traced or singled stepped.
If \f(CWbool-enable\fP is \f(CWTrue\fP then the current command being
evaluated will be put in the resource database under the variable
.XI "evaluate"
\f(CWXtentLine\fP.  The current evaluation nesting or stack frame
number is under the variable \f(CWXtentFrame\fP.
.P
The default behavior for the interpreter if \f(CWXtInternLines\fP is
been enabled is to print the lines as they are being evaluated.  This
.XI "print"
.XI "evaluate"
is essentially a trace style output.  This is often quite useful for
.XI "debugging trace"
debugging macro expansion errors.
.XI "macro expansion"
.P
If code is supplied when \f(CWXtInternLines\fP is enabled then that
code will be executed prior to the evaluation of each line.  The
following bit of code implements a single stepper:
.XI "debugging stepper"
.CW
  !!!
  !!! single step function for debugging
  !!!
  !!! .Xtstepper: ^(expand-and-print-line)
  !!!
  .XtAddFunction: (stepper, _stepper, expand)
  _stepper: .Xt_Eval: \#
  (
   .XtPrint: >(^(XtentFrame))>  stepper evaluating:,
   .XtPrint: >(^(XtentFrame))> "^(XtentLine)",
   .XtIf: (^(expand), ==, True, 
           .XtPrint: >(^(XtentFrame))E "^(XtentLine)"),
   .XtPrint: >(^(XtentFrame))> stepper (enter EOF):,
   .XtInclude: /dev/tty,
   .XtPrint: >(^(XtentFrame))> stepper continues:
  )
  #

  !!!
  !!! install the stepper
  !!!
  .XtInternLines: (True, .Xtstepper: False)
.CN
The first set of lines creates a function,
.XI "tty"
\f(CWXtstepper\fP.  The second set of lines use \f(CWXtInternLines:\fP
to install the function.  The function will be called as each line is
evaluated.  Notice the use of \f(CWXtInclude\fP.
.XI "evaluate"
The following demonstrates how the code above responds to the entry of
an \f(CWXt_If\fP expression.
.CW
  .Xt_If: (1, =, 1, .Xt_Eval: (a: 1, b: 2))
.ft I
  >(1)>  stepper evaluating:
  >(1)> ".Xt_If: (1, =, 1, .Xt_Eval: (a: 1, b: 2))"
  >(1)> stepper (enter EOF): \fP^D\fI
  >(1)> stepper continues:

  >(2)>  stepper evaluating:
  >(2)> ".Xt_Eval: (a: 1, b: 2)"
  >(2)> stepper (enter EOF): \fP^D\fI
  >(2)> stepper continues:

  >(3)>  stepper evaluating:
  >(3)> "a: 1"
  >(3)> stepper (enter EOF): \fP^D\fI
  >(3)> stepper continues:

  >(3)>  stepper evaluating:
  >(3)> "b: 2"
  >(3)> stepper (enter EOF): \fP^D\fI
  >(3)> stepper continues:
.ft P
.CN

.ne 12
.H 2 "XIpc (interprocess communication) Functions"
.XI "IPC functions"
.XI "interprocess communication functions"
The following table contains the names of the interprocess
communication functions that are currently implemented under xtent.
.XI "communication"
The functions are described in the order in which they appear in this
table.  The first three functions are a simple and automatic interface
to the IPC system.  The remaining functions allow the process to have
fine control over IPC communication and allow the xtent process to
install itself as a server.

.TS
center doublebox, tab(;);
l l l.

XtAddXIpc;XtRemoveXIpc;XtSend;

XtXIpcSetupPortServer;Xt_XIpcSetupPortServer;XtXIpcCloseServer;
XtXIpcServerSetClientCleanup;Xt_XIpcServerSetClientCleanup;XtXIpcSendToClient;
XtXIpcFlushServer;XtXIpcServerClientSynchronize;XtXIpcIsServerClientActive;
XtXIpcServerProcessMessage;XtXIpcServerCloseClient;;

XtXIpcSetupKeyClient;Xt_XIpcSetupKeyClient;XtXIpcCloseClient;
XtXIpcSetClientCleanup;Xt_XIpcSetClientCleanup;XtXIpcSendToServer;
XtXIpcFlushClient;XtXIpcClientSynchronize;XtXIpcIsClientActive;

XtXIpcCatchErrors;

.TE
.ce 1
.TB "IPC Functions"
.iS XtAddXIpc 0
xtent.XtAddXIpc: ^(ipc-name)
.iE
This function establishes a simple connection to a server process.  If
the server name is not specified, then the server name is assumed to
be under the shell variable XIPC.

.iS XtRemoveXIpc 0
xtent.XtRemoveXIpc:
.iE
This function closes the simple IPC connection to the server.
.XI "IPC"

.iS XtSend 0
xtent.XtSend: (^(message-type), ^(message-body))
.iE
This function sends a message to a server process.  This function
.XI "sending messages"
assumes that the application has made a simple connection to a server
process with \f(CWXtAddXIpc\fP.

.iS XtXIpcSetupPortServer 0
xtent.XtXIpcSetupPortServer: (^(server-name), ^(port-number),
                              ^(message-handler-code),
                              ^(server-handle-return))
.iE
This function creates an XIpc style server and installs the server
token as a shell variable with the supplied server name.  If no server
name is supplied "XIPC" is assumed.  A port number can be supplied
to install the server on a particular socket port.  A port number of
zero (i.e. 0) will result in the system selecting the next available
port.  The server handle for use by other functions is returned under
the supplied handle return name.
.P
The following setups a simple server process:
.CW
  !!!
  !!! a simple message server
  !!!
  .Xt_XIpcSetupPortServer: (ThisServer, 0, .XtMsgHandler:, server)
  .XtXIpcCatchErrors: True

  !!!
  !!! print out the server id
  !!!
  .XtInternShellVariables: (ThisServer)
  .XtPrint: export XIPC=^(ThisServer)

  !!!
  !!! message handling function
  !!!
  count: 0
  .XtAddFunction: (MsgHandler, MsgHandler)
  MsgHandler: .Xt_Eval: \#
  (
   .XtPrint: (
    id=^(%message.client_id)
    type=^(%message.type)
    buffer=^(%message.buffer)),

   .XtXIpcServerProcessMessage: (^(server), %message)
  )
  #

  !!!
  !!! start up the main loop and receive messages
  !!!
  .XtAppMainLoop:

.CN

.iS Xt_XIpcSetupPortServer 0
xtent.Xt_XIpcSetupPortServer: (^(server-name), ^(port-number),
                               ^(message-handler-code),
                               ^(server-handle-return))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the message handler
code body prior to evaluating it.  Otherwise this function behaves
exactly as \f(CWXtXIpcSetupPortServer\fP.

.iS XtXIpcCloseServer 0
xtent.XtXIpcCloseServer: ^(server-handle)
.iE
This function will close down the specified server.

.iS XtXIpcServerSetClientCleanup 0
xtent.XtXIpcServerSetClientCleanup: (^(server-handle),
                                     ^(server-client-number),
                                     ^(cleanup-code))
.iE
This function installs code to be run when the specified server client
connection is ended.

.iS Xt_XIpcServerSetClientCleanup 0
xtent.Xt_XIpcServerSetClientCleanup: (^(server-handle),
                                      ^(server-client-number),
                                      ^(cleanup-code))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the cleanup code body
prior to evaluating it.  Otherwise this function behaves exactly as
\f(CWXtXIpcServerSetClientCleanup\fP.

.iS XtXIpcSendToClient 0
xtent.XtXIpcSendToClient: (^(server-handle),
                           ^(server-client-number),
                           ^(message-type),
                           ^(message),
                           ^(status-return))
.iE
This function sends a message of the specified type to the
server client.  The status return will be \f(CWTrue\fP if the call was
successful.  Success may mean that the message was sent.  If the
client has been setup for asynchronous (i.e. buffered) delivery or
the client has not been reading its input queue, success means that
the message was successfully queued for delivery.

.iS XtXIpcFlushServer 0
xtent.XtXIpcFlushServer: ^(server-handle)
.iE
This function attempts to send all pending server client messages.

.iS XtXIpcServerClientSynchronize 0
xtent.XtXIpcServerClientSynchronize: (^(server-handle),
                                      ^(server-client-number),
                                      ^(bool-synchronize),
                                      ^(bool-previous-return))
.iE
This function sets the buffering that will be used in sending messages
to the specified server client.  When buffering is enabled, messages
will not be sent until an implementation specific maximum is reached
or the messages are specifically flushed.  Messages can be flushed on
a client by client basis by toggling the buffering.  This can be done
by calling this function with synchronization \f(CWTrue\fP and then
\f(CWFalse\fP.

.iS XtXIpcIsServerClientActive 0
xtent.XtXIpcIsServerClientActive: (^(server-handle),
                                   ^(server-client-number),
                                   ^(bool-active-return))
.iE
This function can be used to check if a particular server client is
still active (i.e. connected or running).  The entry for
\f(CWXtXIpcSetServerClientCleanup\fP explains how applications can be
notified when a client process becomes inactive.

.iS XtXIpcServerProcessMessage 0
xtent.XtXIpcServerProcessMessage: (^(server-handle),
                                   ^(message-name))
.iE
This function handles bookkeeping messages.  The message name
parameter is used to \f(CW^(message-name).type\fP,
\f(CW^(message-name).client-id\fP, and \f(CW^(message-name).buffer\fP
resources.
.P
There are some messages from client processes that the system must
handle.  These messages include adding and deleting clients and the
debugging messages, echo and ping.  The following are the supported
message types.  Messages of these types should be given to
\f(CWXtXIpcServerProcessMessage\fP if the system is to behave
properly.
.CW
  XIPC_SERVER_NEW_CLIENT:            65531
  XIPC_SERVER_DELETE_CLIENT:         65532
  XIPC_SERVER_ECHO:                  65533
  XIPC_SERVER_PING:                  65534
.CN
.iS XtXIpcServerCloseClient 0
xtent.XtXIpcServerCloseClient: (^(server-handle),
                                ^(server-client-number))
.iE
This function closes the communication channel to the specified
server client.

.iS XtXIpcSetupKeyClient 0
xtent.XtXIpcSetupKeyClient: (^(ipc-token),
                             ^(ipc-key),
                             ^(message-handler-code),
                             ^(client-handle-return))
.iE
This function connects to an IPC server as a client and returns a
handle to the IPC client structure.  The IPC token is used to locate
the server, which may be running on another processor.  The IPC key is
an integer that may be used to identify this client.  The key is sent
to the server in a \f(CWXIPC_SERVER_NEW_CLIENT\fP message.  The message
handler is code that will be executed when each message arrives from
the server process.
.P
The following sets up a client connection to a server process.  Notice
that the token for finding the server is retrieved from the
\f(CWXIPC\fP shell variable.  The token need not be stored under any
shell variable name, but many of our applications use the \f(CWXIPC\fP
variable to communicate the token between processes.
.CW
  .XtInternShellVariables: (XIPC)
  .XtXIpcSetupKeyClient: (^(XIPC), 0, .XtCMsgHandler:, client)
  .XtXIpcSetClientCleanup: (^(client), .XtPrint: cleaning up)

  .XtAddFunction: (CMsgHandler, CMsgHandler)
  CMsgHandler: .Xt_Eval: \#
  (
   .XtPrint: (
    id=^(%message.client_id)
    type=^(%message.type)
    buffer=^(%message.buffer)),
  )
  #
.CN
.iS Xt_XIpcSetupKeyClient 0
xtent.Xt_XIpcSetupKeyClient
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the cleanup code body
prior to evaluating it.  Otherwise this function behaves exactly as
\f(CWXtXIpcSetupKeyClient\fP.

.iS XtXIpcCloseClient 0
xtent.XtXIpcCloseClient: ^(client-handle)
.iE
This function closes the connection to the server process.

.iS XtXIpcSetClientCleanup 0
xtent.XtXIpcSetClientCleanup: (^(client-handle),
                               ^(cleanup-code))
.iE
This function installs code to be run when the connection to the
server process is ended.

.iS Xt_XIpcSetClientCleanup 0
xtent.Xt_XIpcSetClientCleanup
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the cleanup code body
prior to evaluating it.  Otherwise this function behaves exactly as
\f(CWXtXIpcSetClientCleanup\fP.

.iS XtXIpcSendToServer 0
xtent.XtXIpcSendToServer: (^(client-handle),
                           ^(message-type),
                           ^(message),
                           ^(status-return))
.iE
This function sends a message of the specified type to the server
process.  The status return will be \f(CWTrue\fP if the call was
successful.  Success may mean that the message was sent.  If the
connection to the server has been setup for asynchronous (i.e.
buffered) delivery success means that the message was successfully
queued for delivery.

.iS XtXIpcFlushClient 0
xtent.XtXIpcFlushClient: ^(client-handle)
.iE
This function attempts to send all pending messages to the server
process.

.iS XtXIpcClientSynchronize 0
xtent.XtXIpcClientSynchronize: (^(client-handle),
                                ^(bool-synchronize),
                                ^(bool-previous-return))
.iE
This function sets the buffering that will be used in sending messages
to the server process.  When buffering is enabled, messages will not
be sent until an implementation specific maximum is reached or the
messages are specifically flushed.  Messages can be flushed by by
calling \f(CWXtXIpcFlushClient\fP or toggling the buffering.  This can
be done by calling this function with synchronization \f(CWTrue\fP and
then \f(CWFalse\fP.

.iS XtXIpcIsClientActive 0
xtent.XtXIpcIsClientActive: (^(client-handle),
                             ^(bool-active-return))
.iE
This function can be used to check if connection to the server is
still active (i.e. connected or running).  The entry for
\f(CWXtXIpcSetClientCleanup\fP explains how applications can be
notified when a client process becomes inactive.

.iS XtXIpcCatchErrors 0
xtent.XtXIpcCatchErrors: ^(bool-catch-errors)
.iE
This function traps signals that occur when a connection is broken.
This should be run in processes that should persist past the
termination of connections.

.ne 13
.H 2 "Backward Compatibility Functions"
.XI "obsolete functions"
The functions in this section are included for backward compatibility
with earlier versions of xtent.  These functions should be avoided in
new scripts.
.TS
center doublebox, tab(;);
l l l.

XtEvalLine;Xt_EvalLine;XtEvalLines;
Xt_EvalLines;;;

XtAdd;XtSub;XtMult;
XtDiv;XtHex;;

.TE
.ce 1
.TB "Backward Compatibility Functions"

.iS XtEvalLine 0
xtent.XtEvalLine: <xtent line>
.iE
This function is used to evaluate a single xtent line.  This function
.XI "evaluate"
is commonly used to force macro expansion.  In the following lines of
.XI "macro expansion"
code
.CW
    xtent.XtArgv: (2, image)
    xtent.XtEvalLine: xtent.w.rasterImage: ^(image)
.CN
the resource data base variable \f(CWimage\fP holds the name of an X
image.  The added call to \f(CWXtEvalLine\fP converts:
.CW
    xtent.w.rasterImage: ^(image)

\fRto\fP

    xtent.w.rasterImage: pjw.x
.CN
if the resource variable, \f(CWimage\fP contained the string
\f(CWpjw.x\fP.  \f(CWXtSet\fP should be used in place of
\f(CWXtEvalLine\fP.
.CW
    .XtArgv: (2, image)
    .XtSet: (xtent.w.rasterImage, ^(image))
.CN

.iS Xt_EvalLine 0
xtent.Xt_EvalLine: <xtent line>
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function simply evaluates its argument with no macro
expansion.

.iS XtEvalLines 0
xtent.XtEvalLines:<character> <lines>
.iE
This function allows for groups of lines to be executed together
similar to a Lisp progn expression or a C function.  This is a very
simple facility.  Lines are separated by the first non-white space
character on the line.  ``;'' is a common choice.  The following
example sets the resource database variables, \f(CWone, two, \fPand
\f(CWthree\fP to 1, 2, and 3.  Applications should now use
\f(CWXtEval\fP.
.CW
     xtent.XtEvalLines:; one: 1; two: 2; three: 3
     xtent.XtEval: (one: 1, two: 2, three: 3)
.CN
The following example shows how \f(CWXtEvalLines\fP might be used for
a widget callback.
.XI "callback"
.CW
xtent.form.save.release.XtAddCallback: \\\\# 
 xtent.XtEvalLines:;
   xtent.form.outputfile.XtTextCopyBuffer: outputfile;
   xtent.XtWriteImage: (^(image-name), ^(outputfile))
#
.CN
Macro expansion is done a line at a time.  This means that
.XI "macro expansion"
\f(CWXtEvalLines\fP first collects the line by searching for the
delimiting character and then macro expands it.  In the case of a
callback, the \f(CWXtAddCallback\fP function first macro expands its
callback code and then XtEvalLines performs its line at a time
expansion.  These extra levels of macro expansion can be quite
confusing if the application developer is not aware that they are
being performed.

.iS Xt_EvalLines 0
xtent.Xt_EvalLines:<character> <lines>
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function simply evaluates the character separated
lines with no macro expansion.

.iS XtAdd 0
xtent.XtAdd: (^(A), ^(B), ^(result))
.iE
This function adds the integer value of \f(CWA\fP to that of \f(CWB\fP
and stores the result.  Applications should now use \f(CWXtCalc\fP.

.iS XtSub 0
xtent.XtSub: (^(A), ^(B), ^(result))
.iE
This function subtracts the integer value of \f(CWB\fP from that of
\f(CWA\fP and stores the result.  Applications should now use
\f(CWXtCalc\fP.

.iS XtMult 0
xtent.XtMult: (^(A), ^(B), ^(result))
.iE
This function multiplies the integer value of \f(CWA\fP with that of
\f(CWB\fP and stores the result.  Applications should now use
\f(CWXtCalc\fP.

.iS XtDiv 0
xtent.XtDiv: (^(A), ^(B), ^(result))
.iE
This function divides the integer value of \f(CWA\fP by that of
\f(CWB\fP and stores the result.  Applications should now use
\f(CWXtCalc\fP.

.iS XtHex 0
xtent.XtHex: (^(integer-value), ^(hex-digits),
              ^(return-hex-string))
.iE
This function converts an integer value into a hex string.  This
.XI "hex numbers"
function is useful for creating RGB color names.  The
.XI "RGB"
.XI "color"
\f(CWhex-digits\fP specifies the length of the hex format string to be
created.  Applications should now use \f(CWXtSPrintF\fP.

.ne 40
.H 2 "Athena Widget Set Functions"
.XI "Athena widget set functions"
The following table contains the names of the Athena widget related
functions that are currently implemented under xtent.  The functions
are described in the order in which they appear in this table.  For a
detailed description of each function consult the Athena programmer's
reference manual.
.S 8 10
.TS
center doublebox, tab(;);
l l l.

XtXawListChange;XtXawListHighlight;XtXawListUnhighlight;
XtXawListShowCurrent;XtXawScrollbarSetThumb;XtXawStripChartAddValueProc;
Xt_XawStripChartAddValueProc;XtXawToggleChangeRadioGroup;XtXawToggleGetCurrent;
XtXawToggleSetCurrent;XtXawToggleUnsetCurrent;XtXawSimpleMenuAddGlobalActions;
XtXawSimpleMenuGetActiveEntry;XtXawSimpleMenuClearActiveEntry;XtXawTextSetSelection;
XtXawTextUnsetSelection;XtXawTextGetSelectionPos;XtXawTextReplace;
XtXawTextSearch;XtXawTextInvalidate;XtXawTextEnableRedisplay;
XtXawTextDisableRedisplay;XtXawTextDisplay;XtXawTextTopPosition;
XtXawTextSetSelectionArray;XtXawTextSetInsertionPoint;XtXawTextGetInsertionPoint;
XtXawTextSetSource;XtXawTextGetSource;XtXawTextDisplayCaret;
XtXawAsciiSourceFreeString;XtXawAsciiSave;XtXawAsciiSaveAsFile;
XtXawAsciiSourceChanged;XtXawDialogGetValueString;XtXawFormDoLayout;
XtXawPanedAllowResize;XtXawPanedSetMinMax;XtXawPanedGetMinMax;
XtXawPanedSetRefigureMode;XtXawPanedGetNumSub;XtXawTreeForceLayout;

.TE
.ce 1
.TB "Athena Widget Functions"
.S 10 12

.iS XtXawListChange 0
xtent.widget.XtXawListChange: (^(longest), ^(bool-resize),
                               ^(list-item-1),
                               ^(list-item-2),
                               ^(list-item-3),
                               ...)
.iE
This function replaces the list with the specified items.  The
\f(CWlongest\fP parameter specifies the length of the longest item in
pixels.  Specifying zero (i.e. 0) will cause the widget to calculate
the value.  The resize boolean specifies if the widget should resize
itself to fit the new list.

.iS XtXawListHighlight 0
xtent.widget.XtXawListHighlight: ^(list-item-number)
.iE
This function will highlight the specified item.

.iS XtXawListUnhighlight 0
xtent.widget.XtXawListUnhighlight:
.iE
This function will unhighlight the selected item.

.iS XtXawListShowCurrent 0
xtent.widget.XtXawListShowCurrent: (^(list-item-string-return),
                                    ^(list-item-index-return))
.iE
This function places the string and the index of the currently
selected item under the specified variable names.

.iS XtXawScrollbarSetThumb 0
xtent.widget.XtXawScrollbarSetThumb: (^(float-top), ^(float-shown))
.iE
This function sets the scrollbar thumb.  The \f(CWtop\fP parameter
specifies the position of the top of the thumb as a fraction of the
length of the scrollbar.  The \f(CWshown\fPp parameter specifies the
length of the thumb as a fraction of the scrollbar.  A value of -1 for
either parameter will result in the parameter being unchanged in the
widget.

.iS XtXawStripChartAddValueProc 0
xtent.widget.XtXawStripChartAddValueProc: ^(strip-chart-code)
.iE
This function adds installs xtent code that is used to update the
value of a strip chart.  This code will be called repatedly to update
the strip chart.  The following is an example of a strip chart widget.
.CW
  !!!
  !!! simple stripChart example
  !!!
  .chart.XtVaCreateManagedWidget: (stripChart, update, 1)
  chart.value: 0.0
  chart.incr: 0.5
  .chart.Xt_XawStripChartAddValueProc: .Xt_Eval: \#
  (
    .XtDoubleCalc: (^(chart.value), ^(chart.incr), +,
		    chart.value, =, %strip-chart.value, =),
    .Xt_If: (^(chart.value), >=, 5.0, chart.incr: -0.5),
    .Xt_If: (^(chart.value), <=, 0.0, chart.incr: 0.5)
  )
  #
.CN

.iS Xt_XawStripChartAddValueProc 0
xtent.widget.Xt_XawStripChartAddValueProc: ^(strip-chart-code)
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the cleanup code body
prior to evaluating it.  Otherwise this function behaves exactly as
\f(CWXtXawStripChartAddValueProc\fP.

.iS XtXawToggleChangeRadioGroup 0
xtent.widget.XtXawToggleChangeRadioGroup: ^(radio-group-widget-name)
.iE
This function adds the widget to the radio group of the toggle
\f(CWradio-group-widget\fP.  If no radio group widget is specified
then the widget will be removed for any radio group it has joined.

.iS XtXawToggleGetCurrent 0
xtent.widget.XtXawToggleGetCurrent: ^(current-toggle-return)
.iE
This function returns the name of the current widget in the radio
group.

.iS XtXawToggleSetCurrent 0
xtent.widget.XtXawToggleSetCurrent: ^(toggle-string)
.iE
This function sets the current widget in a radio group.  The widget
that matches the toggle string is set.

.iS XtXawToggleUnsetCurrent 0
xtent.widget.XtXawToggleUnsetCurrent:
.iE
This function unsets the current widget in the radio group.

.iS XtXawSimpleMenuAddGlobalActions 0
xtent.widget.XtXawSimpleMenuAddGlobalActions:
.iE
This function registers the Athena global actions.  It should be
called prior to first using the \f(CWXawPositionSimpleMenu\fP action.

.iS XtXawSimpleMenuGetActiveEntry 0
xtent.widget.XtXawSimpleMenuGetActiveEntry: ^(active-widget-name-return)
.iE
This function gets the currently highlighted menu entry (widget).

.iS XtXawSimpleMenuClearActiveEntry 0
xtent.widget.XtXawSimpleMenuClearActiveEntry:
.iE
This function clears the internal structures for the current entry in
a menu.  It does not change the graphical representation.

.iS XtXawTextSetSelection 0
xtent.widget.XtXawTextSetSelection: (^(start-position),
                                     ^(end-position))
.iE
This function highlights the text between the start and end positions
and makes them the current selection.

.iS XtXawTextUnsetSelection 0
xtent.widget.XtXawTextUnsetSelection:
.iE
This function will unhighlight previously selected text.

.iS XtXawTextGetSelectionPos 0
xtent.widget.XtXawTextGetSelectionPos: (^(start-position-return),
                                        ^(end-position-return))
.iE
This function returns the start and end positions of the currently
selected text.

.iS XtXawTextReplace 0
xtent.widget.XtXawTextReplace: (^(start-position),
                                ^(end-position),
                                ^(replacement-string),
                                ^(status-return),
.iE
This function replaces the text between the start and end positions
with the replacement string.  The status return will be XawEditDone,
XawPositionError, or XawEditError.

.iS XtXawTextSearch 0
xtent.widget.XtXawTextSearch: (^(direction),
                               ^(search-string),
                               ^(position-return))
.iE
This function searches for the specified string starting at the
insertion point currently set in the widget.  The direction should be
XawsdRight or XawsdLeft.  The position return is the position of the
first character of the string.

.iS XtXawTextInvalidate 0
xtent.widget.XtXawTextInvalidate: (^(start-position),
                                   ^(end-position))
.iE
This function causes the specified text to be redisplayed.

.iS XtXawTextEnableRedisplay 0
xtent.widget.XtXawTextEnableRedisplay:
.iE
This function enables the display processing in the widget.

.iS XtXawTextDisableRedisplay 0
xtent.widget.XtXawTextDisableRedisplay:
.iE
This function disables the display processing in the widget.

.iS XtXawTextDisplay 0
xtent.widget.XtXawTextDisplay:
.iE
This function 

.iS XtXawTextTopPosition 0
xtent.widget.XtXawTextTopPosition: ^(position-return)
.iE
This function returns the character position of the left most
character on the first line displayed in the widget.

.iS XtXawTextSetSelectionArray 0
xtent.widget.XtXawTextSetSelectionArray: (^(arg-1),
                                          ^(arg-2),
                                          ^(arg-3),
                                          ...)
.iE
This function sets the selection array for the text widget.
The arguments must be selected from the following:
.CW
XawselectPosition
XawselectChar
XawselectWord
XawselectLine
XawselectParagraph
XawselectAll
XawselectNull

.CN
A entry XawselectNull is added to the end of all arrays entered.

.iS XtXawTextSetInsertionPoint 0
xtent.widget.XtXawTextSetInsertionPoint: ^(insertion-position)
.iE
This function moves the insertion position.

.iS XtXawTextGetInsertionPoint 0
xtent.widget.XtXawTextGetInsertionPoint: ^(insertion-position-return)
.iE
This function returns the insertion position.

.iS XtXawTextSetSource 0
xtent.widget.XtXawTextSetSource: (^(source-widget), ^(position))
.iE
This function sets the source object for the text widget and the
character position for the upper left hand corner of the displayed
text.

.iS XtXawTextGetSource 0
xtent.widget.XtXawTextGetSource: ^(widget-name-return)
.iE
This function returns the text source that this text widget is
currently using.

.iS XtXawTextDisplayCaret 0
xtent.widget.XtXawTextDisplayCaret: ^(bool-display)
.iE
This function controls the display of the caret at the insertion point
of the widget.

.iS XtXawAsciiSourceFreeString 0
xtent.widget.XtXawAsciiSourceFreeString:
.iE
This function frees the memory that contains the pointer returned by
XtGetValues or by accessing the widgets resource list.  This memory
will normally be freed the next time the resource list is accessed or
when the widget is destroyed.

.iS XtXawAsciiSave 0
xtent.widget.XtXawAsciiSave: ^(bool-save-return)
.iE
This function saves changes that have been made in the text.  The
widget will return True if the save was successful.

.iS XtXawAsciiSaveAsFile 0
xtent.widget.XtXawAsciiSaveAsFile: (^(file-name-string),
                                    ^(bool-saved-return))
.iE
This function saves the contents of the widget to the specified file.
The widget will return True if the save was successful.

.iS XtXawAsciiSourceChanged 0
xtent.widget.XtXawAsciiSourceChanged: ^(bool-changed-return)
.iE
This function will return true if the text source was modified since
the last time it was queried or saved.

.iS XtXawDialogGetValueString 0
xtent.widget.XtXawDialogGetValueString: ^(dialog-string-return)
.iE
This function returns the character string of the text field of the
specified dialog widget.

.iS XtXawFormDoLayout 0
xtent.widget.XtXawFormDoLayout: ^(bool-do-layout)
.iE
This function will foce or defer the layout of child widgets.

.iS XtXawPanedAllowResize 0
xtent.widget.XtXawPanedAllowResize: ^(bool-allow-resize)
.iE
This function allows or disallows resizing based on child widget
requests for pane resizing.

.iS XtXawPanedSetMinMax 0
xtent.widget.XtXawPanedSetMinMax: (^(min-value),
                                   ^(max-value))
.iE
This function changes the minimum and maximum height settings for a
pane.

.iS XtXawPanedGetMinMax 0
xtent.widget.XtXawPanedGetMinMax: (^(min-value-return),
                                   ^(max-value-return))
.iE
This function returns the minimum and maximum height settings for a
pane.

.iS XtXawPanedSetRefigureMode 0
xtent.widget.XtXawPanedSetRefigureMode: ^(bool-refigure)
.iE
This function allows or disallows automatic recalculations of pane
sizes and positions.

.iS XtXawPanedGetNumSub 0
xtent.widget.XtXawPanedGetNumSub: ^(paned-num-sub-return)
.iE
This function returns the number of panes in the paned widget.

.iS XtXawTreeForceLayout 0
xtent.widget.XtXawTreeForceLayout:
.iE
This function forces the layout of a tree widget.  Applications
commonly set the \f(CWAutoReconfigure\fP resource to \f(CWFalse\fP and
call this function when layout is desired.

.ne 30
.H 2 "HP Textedit Widget Functions"
.XI "HP textedit widget functions"
The following table contains the names of the HP textedit widget
functions that are currently implemented under xtent.  The functions
are described in the order in which they appear in this table.  For a
detailed description of each function consult the HP Widget Set
programmer's reference manual.
.TS
center doublebox, tab(;);
l l l.

XtTextClearBuffer;XtTextCopyBuffer;XtTextReadSubString;
XtTextCopySelection;XtTextUnsetSelection;XtTextSetSelection;
XtTextGetSelectionPos;XtTextInsert;XtTextReplace;
XtTextRedraw;XtTextUpdate;XtTextGetLastPos;
XtTextSetInsertPos;XtTextGetInsertPos;

.TE
.ce 1
.TB "HP Textedit Widget Functions"
.iS XtTextClearBuffer 0
xtent.widget.XtTextClearBuffer:
.iE
This function clears the textedit widget's buffer.

.iS XtTextCopyBuffer 0
xtent.widget.XtTextCopyBuffer: ^(return-variable)
.iE
This function copies the contents of the textedit widgets buffer to
the resource database variable.  This is the preferred method for
examining the buffer.  The widget does not do the correct record
keeping if the contents of the buffer are viewed as a widget resource.

.iS XtTextReadSubString 0
xtent.widget.XtTextReadSubString: (^(start), ^(end), ^(return-string))
.iE
This function copies the substring to the resource database variable.

.iS XtTextCopySelection 0
xtent.widget.XtTextCopySelection: ^(return-variable)
.iE
This function copies the text that has been selected to the resource
database variable.

.iS XtTextUnsetSelection 0
xtent.widget.XtTextUnsetSelection:
.iE
This function clears the selection.

.iS XtTextSetSelection 0
xtent.widget.XtTextSetSelection: (^(start), ^(end))
.iE
This function sets the current selection between the two character
positions.

.iS XtTextGetSelectionPos 0
xtent.widget.XtTextGetSelectionPos: (^(return-start), ^(return-end))
.iE
This function returns the starting and ending positions (indices) of
the currently selected text.

.iS XtTextInsert 0
xtent.widget.XtTextInsert: ^(string)
.iE
This function inserts a string.  The specified string is inserted at
the current text insert position.  The insert position is advanced to
the end of the inserted string.

.iS XtTextReplace 0
xtent.widget.XtTextReplace: (^(start), ^(end), ^(string))
.iE
This function replaces an old string with a new one.  The characters
between the start and end positions are replaced with the new string.

.iS XtTextRedraw 0
xtent.widget.XtTextRedraw:
.iE
This function refreshes the textedit widget.

.iS XtTextUpdate 0
xtent.widget.XtTextUpdate: ^(bool-status)
.iE
This function enables or disables the updating of the widget.
\f(CWbool-status\fP should be \f(CWTrue\fP or \f(CWFalse\fP.

.iS XtTextGetLastPos 0
xtent.widget.XtTextGetLastPos: ^(return-variable)
.iE
This function places the index of the last text position under the
return variable name.

.iS XtTextSetInsertPos 0
xtent.widget.XtTextSetInsertPos: ^(insert-position)
.iE
This function sets the insertion position.

.iS XtTextGetInsertPos 0
xtent.widget.XtTextGetInsertPos: ^(return-variable)
.iE
This function places the index of the text insertion position under
the return variable name.

.H 2 "Motif  Widget Set Functions"
.XI "Motif  Widget Set Functions"
The following table contains the names of the Motif widget set
functions that are currently implemented under xtent.  The functions
are described in the order in which they appear in this table.  For a
detailed description of each function consult the Motif Widget set
programmer's reference manual.  The descriptions found here are terse
renditions of the explanations found in the programmer's reference
manaul.
.S 8 10
.TS
center doublebox, tab(;);
l l l.

XtXmActivateProtocol; XtXmActivateWMProtocol; XtXmAddProtocolCallback;
Xt_XmAddProtocolCallback; XtXmAddWMProtocolCallback; Xt_XmAddWMProtocolCallback;
XtXmAddProtocols; XtXmAddWMProtocols; XtXmAddTabGroup;
XtXmAddWMProtocolsCallback; XtXmCascadeButtonGadgetHighlight; XtXmCascadeButtonHighlight;
XtXmChangeColor; XtXmClipboardCancelCopy; XtXmClipboardCopy;
XtXmClipboardCopyByName; XtXmClipboardEndCopy; XtXmClipboardEndRetrieve;
XtXmClipboardInquireCount; XtXmClipboardInquireFormat; XtXmClipboardInquireLength;
XtXmClipboardInquirePendingItems; XtXmClipboardLock; XtXmClipboardRegisterFormat;
XtXmClipboardRetrieve; XtXmClipboardStartCopy; XtXmClipboardStartRetrieve;
XtXmClipboardUndoCopy; XtXmClipboardUnlock; XtXmClipboardWithdrawFormat;
XtXmCommandAppendValue; XtXmCommandError; XtXmCommandGetChild;
XtXmCommandSetValue; XtXmConvertUnits; XtXmCreateArrowButton;
XtXmCreateArrowButtonGadget; XtXmCreateBulletinBoard; XtXmCreateBulletinBoardDialog;
XtXmCreateCascadeButton; XtXmCreateCascadeButtonGadget; XtXmCreateCommand;
XtXmCreateDialogShell; XtXmCreateDragIcon; XtXmCreateDrawingArea;
XtXmCreateDrawnButton; XtXmCreateErrorDialog; XtXmCreateFileSelectionBox;
XtXmCreateFileSelectionDialog; XtXmCreateForm; XtXmCreateFormDialog;
XtXmCreateFrame; XtXmCreateInformationDialog; XtXmCreateLabel;
XtXmCreateLabelGadget; XtXmCreateList; XtXmCreateMainWindow;
XtXmCreateMenuBar; XtXmCreateMenuShell; XtXmCreateMessageBox;
XtXmCreateMessageDialog; XtXmCreateOptionMenu; XtXmCreatePanedWindow;
XtXmCreatePopupMenu; XtXmCreatePromptDialog; XtXmCreatePulldownMenu;
XtXmCreatePushButton; XtXmCreatePushButtonGadget; XtXmCreateQuestionDialog;
XtXmCreateRadioBox; XtXmCreateRowColumn; XtXmCreateScale;
XtXmCreateScrollBar; XtXmCreateScrolledList; XtXmCreateScrolledText;
XtXmCreateScrolledWindow; XtXmCreateSelectionBox; XtXmCreateSelectionDialog;
XtXmCreateSeparator; XtXmCreateSeparatorGadget; XtXmCreateSimpleCheckBox;
XtXmCreateSimpleMenuBar; XtXmCreateSimpleOptionMenu; XtXmCreateSimplePopupMenu;
XtXmCreateSimplePulldownMenu; XtXmCreateSimpleRadioBox; XtXmCreateTemplateDialog;
XtXmCreateText; XtXmCreateTextField; XtXmCreateToggleButton;
XtXmCreateToggleButtonGadget; XtXmCreateWorkArea; XtXmCreateWorkingDialog;
XtXmDeactivateProtocol; XtXmDeactivateWMProtocol; XtXmDestroyPixmap;
XtXmDragStart; XtXmDropSiteConfigureStackingOrder; XtXmDropSiteEndUpdate;
XtXmDropSiteQueryStackingOrder; XtXmDropSiteRegister; XtXmDropSiteRetrieve;
XtXmDropSiteStartUpdate; XtXmDropSiteUnregister; XtXmDropSiteUpdate;
XtXmDropTransferAdd; XtXmDropTransferStart; XtXmFileSelectionBoxGetChild;
XtXmFileSelectionDoSearch; XtXmGetColors; XtXmGetDestination;
XtXmGetDragContext; XtXmGetFocusWidget; XtXmGetMenuCursor;
XtXmGetPiXtXmap; XtXmGetPiXtXmapByDepth; XtXmGetPostedFromWidget;
XtXmGetTabGroup; XtXmGetTearOffControl; XtXmGetVisibility;
XtXmGetXtXmDisplay; XtXmGetXtXmScreen; XtXmInstallImage;
XtXmIsMotifWMRunning; XtXmIsTraversable	; XtXmListAddItem;
XtXmListAddItemUnselected; XtXmListAddItems; XtXmListAddItemsUnselected;
XtXmListDeleteAllItems; XtXmListDeleteItem; XtXmListDeleteItems;
XtXmListDeleteItemsPos; XtXmListDeletePos; XtXmListDeletePositions;
XtXmListDeselectAllItems; XtXmListDeselectItem; XtXmListDeselectPos;
XtXmListGetKbdItemPos; XtXmListGetMatchPos; XtXmListGetSelectedPos;
XtXmListItemExists; XtXmListItemPos; XtXmListPosSelected;
XtXmListPosToBounds; XtXmListReplaceItems; XtXmListReplaceItemsPos;
XtXmListReplaceItemsPosUnselected; XtXmListReplaceItemsUnselected; XtXmListReplacePositions;
XtXmListSelectItem; XtXmListSelectPos; XtXmListSetAddMode;
XtXmListSetBottomItem; XtXmListSetBottomPos; XtXmListSetHorizPos;
XtXmListSetItem; XtXmListSetKbdItemPos; XtXmListSetPos;
XtXmListUpdateSelectedList; XtXmListYToPos; XtXmMainWindowSep1;
XtXmMainWindowSep2; XtXmMainWindowSep3; XtXmMainWindowSetAreas;
XtXmMenuPosition; XtXmMessageBoxGetChild; XtXmOptionButtonGadget;
XtXmOptionLabelGadget; XtXmProcessTraversal; XtXmRemoveProtocolCallback;
XtXmRemoveProtocols; XtXmRemoveTabGroup; XtXmRemoveWMProtocolCallback;
XtXmRemoveWMProtocols; XtXmRepTypeAddReverse; XtXmRepTypeGetId;
XtXmRepTypeGetNameList; XtXmRepTypeGetRecord; XtXmRepTypeGetRegistered;
XtXmRepTypeInstallTearOffModelConverter; XtXmRepTypeRegister; XtXmRepTypeValidValue;
XtXmScaleGetValue; XtXmScaleSetValue; XtXmScrollBarGetValues;
XtXmScrollBarSetValues; XtXmScrollVisible; XtXmScrolledWindowSetAreas;
XtXmSelectionBoxGetChild; XtXmSetFontUnit; XtXmSetFontUnits;
XtXmTextClearSelection; XtXmTextCopy; XtXmTextCut;
XtXmTextDisableRedisplay; XtXmTextEnableRedisplay; XtXmTextFieldClearSelection;
XtXmTextFieldCopy; XtXmTextFieldCut; XtXmTextFieldGetBaseLine;
XtXmTextFieldGetEditable; XtXmTextFieldGetInsertionPosition; XtXmTextFieldGetLastPosition;
XtXmTextFieldGetMaxLength; XtXmTextFieldGetSelection; XtXmTextFieldGetSelectionPosition;
XtXmTextFieldGetString; XtXmTextFieldGetSubstring; XtXmTextFieldInsert;
XtXmTextFieldPaste; XtXmTextFieldPosToXY; XtXmTextFieldRemove;
XtXmTextFieldReplace; XtXmTextFieldSetAddMode; XtXmTextFieldSetEditable;
XtXmTextFieldSetHighlight; XtXmTextFieldSetInsertionPosition; XtXmTextFieldSetMaxLength;
XtXmTextFieldSetSelection; XtXmTextFieldSetString; XtXmTextFieldShowPosition;
XtXmTextFieldXYToPos; XtXmTextFindString; XtXmTextGetBaseLine;
XtXmTextGetEditable; XtXmTextGetInsertionPosition; XtXmTextGetLastPosition;
XtXmTextGetMaxLength; XtXmTextGetSelection; XtXmTextGetSelectionPosition;
XtXmTextGetSource; XtXmTextGetString; XtXmTextGetSubstring;
XtXmTextGetTopCharacter; XtXmTextInsert; XtXmTextPaste;
XtXmTextPosToXY; XtXmTextRemove; XtXmTextReplace;
XtXmTextScroll; XtXmTextSetAddMode; XtXmTextSetEditable;
XtXmTextSetHighlight; XtXmTextSetInsertionPosition; XtXmTextSetMaxLength;
XtXmTextSetSelection; XtXmTextSetSource; XtXmTextSetString;
XtXmTextSetTopCharacter; XtXmTextShowPosition; XtXmTextXYToPos;
XtXmToggleButtonGadgetGetState; XtXmToggleButtonGadgetSetState; XtXmToggleButtonGetState;
XtXmToggleButtonSetState; XtXmTrackingEvent; XtXmUninstallImage;
XtXmUpdateDisplay; XtXmWidgetGetBaselines; XtXmWidgetGetDisplayRect;

.TE
.S 10 12
.ce 1
.TB "Motif Widget Set Functions"

.iS XtXmActivateProtocol 0
xtent.widget.XtXmActivateProtocol: (^(property-atom-name),
                                    ^(protocol-atom-name))
.iE
This function activates the specified protocol.

.iS XtXmActivateWMProtocol 0
xtent.widget.XtXmActivateWMProtocol: ^(protocol-atom-name)
.iE
This function activates the specified protocol (with the property
WM_PROTOCOLS).

.iS XtXmAddProtocolCallback 0
xtent.widget.^(protocol).XtXmAddProtocolCallback:
                                   (^(property-atom-name),
                                    ^(callback-code))
.iE
This function adds client callbacks for a protocol.

.iS Xt_XmAddProtocolCallback 0
xtent.widget.^(protocol).Xt_XmAddProtocolCallback:
                                   (^(property-atom-name),
                                    ^(callback-code))
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the callback code body
prior to installing it.  Otherwise this function behaves exactly as
\f(CWXtXmAddProtocolCallback\fP.

.iS XtXmAddWMProtocolCallback 0
xtent.widget.^(protocol).XtXmAddWMProtocolCallback: ^(callback-code)
.iE
This function adds client callbacks for a protocol (with the property
WM_PROTOCOLS).

.iS Xt_XmAddWMProtocolCallback 0
xtent.widget.^(protocol).Xt_XmAddWMProtocolCallback: ^(callback-code)
.iE
In some cases applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the callback code body
prior to installing it.  Otherwise this function behaves exactly as
\f(CWAddWMProtocolCallback\fP.

.iS XtXmAddProtocols 0
xtent.widget.XtXmAddProtocols: (^(property-atom-name),
                                ^(protocol-atom-name1),
                                ^(protocol-atom-name2),
                                ^(protocol-atom-name3),
                                ...)
.iE
This function adds the protocols to the protocol manager and allocates
the internal tables.

.iS XtXmAddWMProtocols 0
xtent.widget.XtXmAddWMProtocols: (^(protocol-atom-name1),
                                  ^(protocol-atom-name2),
                                  ^(protocol-atom-name3),
                                   ...)
.iE
This function adds the protocols to the protocol manager and allocates
the internal tables (with the property WM_PROTOCOLS).

.iS XtXmAddTabGroup 0
xtent.widget.XtXmAddTabGroup:
.iE
This function establishes the named widget as a tab group for keyboard
traversal.

.iS XtXmCascadeButtonGadgetHighlight 0
xtent.widget.XtXmCascadeButtonGadgetHighlight: ^(bool-highlight)
.iE
This function sets the specified CascadeButtonGadget to be highlighted
or unhighlighted.

.iS XtXmCascadeButtonHighlight 0
xtent.widget.XtXmCascadeButtonHighlight: ^(bool-highlight)
.iE
This function sets the specified CascadeButtonWidget to be highlighted
or unhighlighted.

.iS XtXmChangeColor 0
xtent.widget.XtXmChangeColor: ^(background-color-name)
.iE
This function handles all color modification for the specified widget.

.iS XtXmClipboardCancelCopy 0
xtent.widget.XtXmClipboardCancelCopy: (^(item-id), ^(return-string))
.iE
This function cancels the copy to clipboard that is in progress and
frees up temporary storage.

.iS XtXmClipboardCopy 0
xtent.widget.XtXmClipboardCopy: (^(item-id), ^(format-name),
                                 ^(buffer), ^(status-return))
.iE
This function copies a data item to temporary storage.  The data item
is moved from temporary storage to the clipboard data structure when a
call to XtXmClipboardEndCopy: is made.  Additional calls to
XtXmClipboardCopy: before a call to XtXmClipboardEndCopy: add
additional data item formats to the same data item or append data to
an existing format.

.iS XtXmClipboardCopyByName 0
xtent.widget.XtXmClipboardCopyByName: (^(item-id),
                                       ^(buffer),
                                       ^(status-return))
.iE
This function copies the actual data for a data item that was
previously passed by name to the clipboard.

.iS XtXmClipboardEndCopy 0
xtent.widget.XtXmClipboardEndCopy: (^(item-id),
                                    ^(status-return))
.iE
This function locks the clipboard from access by other applications,
places data in the clipboard data structure, and unlocks the
clipboard.

.iS XtXmClipboardEndRetrieve 0
xtent.widget.XtXmClipboardEndRetrieve: ^(status-return)
.iE
This function tells the clipboard routines that the application is
through copying an item from the clipboard.  Until this function is
called, data items can be retrieved incrementally from the clipboard
by calling XtXmClipboardRetrieve.

.iS XtXmClipboardInquireCount 0
xtent.widget.XtXmClipboardInquireCount: (^(index),
                                         ^(count-return),
                                         ^(max-length-return),
                                         ^(status-return))
.iE
This function returns the number of data item formats available for
the data item in the clipboard.  This function also returns the
maximum name-length for all formats in which the data item is stored.

.iS XtXmClipboardInquireFormat 0
xtent.widget.XtXmClipboardInquireFormat: (^(index),
                                          ^(format-return),
                                          ^(copied-length-return),
                                          ^(status-return))
.iE
This function returns a specified format name for the data item in the
clipboard.

.iS XtXmClipboardInquireLength 0
xtent.widget.XtXmClipboardInquireLength: (^(format),
                                          ^(length-return),
                                          ^(status-return))
.iE
This function returns the length of the data stored under a specified
format name for the clipboard data item.

.iS XtXmClipboardInquirePendingItems 0
xtent.widget.XtXmClipboardInquirePendingItems: (^(format),
                                                ^(count-return),
                                                ^(status-return))
.iE
This function returns count of data_id/private_id pairs for the
specified format name.  A data item is considered pending if the
application originally passed it by name, the application has not yet
copied the data, and the item has not been deleted from the clipboard.

.iS XtXmClipboardLock 0
xtent.widget.XtXmClipboardLock: ^(status-return)
.iE
This function locks the clipboard from access by another application
until XtXmClipboardUnlock: is called.

.iS XtXmClipboardRegisterFormat 0
xtent.widget.XtXmClipboardRegisterFormat: (^(format),
                                           ^(status-return))
.iE
This function registers a new clipboard format.

.iS XtXmClipboardRetrieve 0
xtent.widget.XtXmClipboardRetrieve: (^(format-name),
                                     ^(buffer),
                                     ^(buffer-length),
                                     ^(byte-count-return),
                                     ^(private-id-return),
                                     ^(status-return))
.iE
This function retrieves the current data item from clipboard storage.

.iS XtXmClipboardStartCopy 0
xtent.widget.XtXmClipboardStartCopy: (^(clip-label),
                                      ^(time-stamp-id),
                                      ^(status-return))
.iE
This function sets up storage and data structures to receive clipboard
data.  An application calls this function during a cut or copy
operation.  The time stamp ID defaults to the value returned by
XtLastTimestamp() if the time stamp is \f(CW-\fP or null.

.iS XtXmClipboardStartRetrieve 0
xtent.widget.XtXmClipboardStartRetrieve: (^(time-stamp-id),
                                          ^(status-return))
.iE
This function tells the clipboard routines that the application is
ready to start copying an item from the clipboard.  The time stamp ID
defaults to the value returned by XtLastTimestamp() if the time stamp
is \f(CW-\fP or null.

.iS XtXmClipboardUndoCopy 0
xtent.widget.XtXmClipboardUndoCopy: ^(status-return)
.iE
This function deletes the last item placed on the clipboard if the
item was placed there by an application with the display and window
arguments that match those of the specified widget.

.iS XtXmClipboardUnlock 0
xtent.widget.XtXmClipboardUnlock: (^(bool-remove-all-locks),
                                   ^(status-return))
.iE
This function unlocks the clipboard, enabling it to be accessed by
other applications.

.iS XtXmClipboardWithdrawFormat 0
xtent.widget.XtXmClipboardWithdrawFormat: (^(format-name),
                                           ^(status-return))
.iE
This function indicates that the application no longer supplies a data
item to the clipboard that the application had previously passed by
name.

.iS XtXmCommandAppendValue 0
xtent.widget.XtXmCommandAppendValue: ^(append-string)
.iE
This function appends the string to the end of the string displayed in
the command area of the widget (Command).

.iS XtXmCommandError 0
xtent.widget.XtXmCommandError: ^(error-string)
.iE
This function displays an error message in the history area of the
widget (Command).

.iS XtXmCommandGetChild 0
xtent.widget.XtXmCommandGetChild: (^(child-name),
                                   ^(child-widget-name-return))
.iE
This function returns the name of the widget specified by the
\f(CWchild-name\fP.  \f(CWchild-name\fP should be one of the
following:
.BL
.LI
XmDIALOG_COMMAND_TEXT
.LI
XmDIALOG_PROMPT_LABEL
.LI
XmDIALOG_HISTORY_LIST
.LI
XmDIALOG_WORK_AREA
.LE

.iS XtXmCommandSetValue 0
xtent.widget.XtXmCommandSetValue: ^(command-string)
.iE
This function replaces the string displayed in the command area of the
Command widget with the specified string.

.iS XtXmConvertUnits 0
xtent.widget.XtXmConvertUnits: (^(orientation),
                                ^(from-type),
                                ^(from-value),
                                ^(to-type),
                                ^(to-value-return))
.iE
This function converts an integer value in one unit type to an integer
value in another unit type.  Orientation should be either XmHORIZONTAL
or XmVERTICAL.  XmHORIZONTAL is the default.  The following are the
strings allowed for the from and to types:
.BL
.LI
Xm100TH_MILLIMETERS
.LI
Xm1000TH_INCHES
.LI
Xm100TH_POINTS
.LI
Xm100TH_FONT_UNITS
.LI
XmPIXELS
.LE
XmPIXELS is the default.

.iS XtXmCreateArrowButton 0
xtent.parent-widget.XtXmCreateArrowButton: ^(widget-name)
.iE
This function creates an instance of an XmArrowButton.

.iS XtXmCreateArrowButtonGadget 0
xtent.parent-widget.XtXmCreateArrowButtonGadget: ^(widget-name)
.iE
This function creates an instance of an XmArrowButtonGadget.

.iS XtXmCreateBulletinBoard 0
xtent.parent-widget.XtXmCreateBulletinBoard: ^(widget-name)
.iE
This function creates an instance of an XmBulletinBoard.

.iS XtXmCreateBulletinBoardDialog 0
xtent.parent-widget.XtXmCreateBulletinBoardDialog: ^(widget-name)
.iE
This function creates an instance of an XmBulletinBoardDialog.

.iS XtXmCreateCascadeButton 0
xtent.parent-widget.XtXmCreateCascadeButton: ^(widget-name)
.iE
This function creates an instance of an XmCascadeButton.

.iS XtXmCreateCascadeButtonGadget 0
xtent.parent-widget.XtXmCreateCascadeButtonGadget: ^(widget-name)
.iE
This function creates an instance of an XmCascadeButtonGadget.

.iS XtXmCreateCommand 0
xtent.parent-widget.XtXmCreateCommand: ^(widget-name)
.iE
This function creates an instance of an XmCommand.

.iS XtXmCreateDialogShell 0
xtent.parent-widget.XtXmCreateDialogShell: ^(widget-name)
.iE
This function creates an instance of an XmDialogShell.

.iS XtXmCreateDragIcon 0
xtent.parent-widget.XtXmCreateDragIcon: ^(widget-name)
.iE
This function creates an instance of an XmDragIcon.

.iS XtXmCreateDrawingArea 0
xtent.parent-widget.XtXmCreateDrawingArea: ^(widget-name)
.iE
This function creates an instance of an XmDrawingArea.

.iS XtXmCreateDrawnButton 0
xtent.parent-widget.XtXmCreateDrawnButton: ^(widget-name)
.iE
This function creates an instance of an XmDrawnButton.

.iS XtXmCreateErrorDialog 0
xtent.parent-widget.XtXmCreateErrorDialog: ^(widget-name)
.iE
This function creates an instance of an XmErrorDialog.

.iS XtXmCreateFileSelectionBox 0
xtent.parent-widget.XtXmCreateFileSelectionBox: ^(widget-name)
.iE
This function creates an instance of an XmFileSelectionBox.

.iS XtXmCreateFileSelectionDialog 0
xtent.parent-widget.XtXmCreateFileSelectionDialog: ^(widget-name)
.iE
This function creates an instance of an XmFileSelectionDialog.

.iS XtXmCreateForm 0
xtent.parent-widget.XtXmCreateForm: ^(widget-name)
.iE
This function creates an instance of an XmForm.

.iS XtXmCreateFormDialog 0
xtent.parent-widget.XtXmCreateFormDialog: ^(widget-name)
.iE
This function creates an instance of an XmFormDialog.

.iS XtXmCreateFrame 0
xtent.parent-widget.XtXmCreateFrame: ^(widget-name)
.iE
This function creates an instance of an XmFrame.

.iS XtXmCreateInformationDialog 0
xtent.parent-widget.XtXmCreateInformationDialog: ^(widget-name)
.iE
This function creates an instance of an XmInformationDialog.

.iS XtXmCreateLabel 0
xtent.parent-widget.XtXmCreateLabel: ^(widget-name)
.iE
This function creates an instance of an XmLabel.

.iS XtXmCreateLabelGadget 0
xtent.parent-widget.XtXmCreateLabelGadget: ^(widget-name)
.iE
This function creates an instance of an XmLabelGadget.

.iS XtXmCreateList 0
xtent.parent-widget.XtXmCreateList: ^(widget-name)
.iE
This function creates an instance of an XmList.

.iS XtXmCreateMainWindow 0
xtent.parent-widget.XtXmCreateMainWindow: ^(widget-name)
.iE
This function creates an instance of an XmMainWindow.

.iS XtXmCreateMenuBar 0
xtent.parent-widget.XtXmCreateMenuBar: ^(widget-name)
.iE
This function creates an instance of an XmMenuBar.

.iS XtXmCreateMenuShell 0
xtent.parent-widget.XtXmCreateMenuShell: ^(widget-name)
.iE
This function creates an instance of an XmMenuShell.

.iS XtXmCreateMessageBox 0
xtent.parent-widget.XtXmCreateMessageBox: ^(widget-name)
.iE
This function creates an instance of an XmMessageBox.

.iS XtXmCreateMessageDialog 0
xtent.parent-widget.XtXmCreateMessageDialog: ^(widget-name)
.iE
This function creates an instance of an XmMessageDialog.

.iS XtXmCreateOptionMenu 0
xtent.parent-widget.XtXmCreateOptionMenu: ^(widget-name)
.iE
This function creates an instance of an XmOptionMenu.

.iS XtXmCreatePanedWindow 0
xtent.parent-widget.XtXmCreatePanedWindow: ^(widget-name)
.iE
This function creates an instance of an XmPanedWindow.

.iS XtXmCreatePopupMenu 0
xtent.parent-widget.XtXmCreatePopupMenu: ^(widget-name)
.iE
This function creates an instance of an XmPopupMenu.

.iS XtXmCreatePromptDialog 0
xtent.parent-widget.XtXmCreatePromptDialog: ^(widget-name)
.iE
This function creates an instance of an XmPromptDialog.

.iS XtXmCreatePulldownMenu 0
xtent.parent-widget.XtXmCreatePulldownMenu: ^(widget-name)
.iE
This function creates an instance of an XmPulldownMenu.

.iS XtXmCreatePushButton 0
xtent.parent-widget.XtXmCreatePushButton: ^(widget-name)
.iE
This function creates an instance of an XmPushButton.

.iS XtXmCreatePushButtonGadget 0
xtent.parent-widget.XtXmCreatePushButtonGadget: ^(widget-name)
.iE
This function creates an instance of an XmPushButtonGadget.

.iS XtXmCreateQuestionDialog 0
xtent.parent-widget.XtXmCreateQuestionDialog: ^(widget-name)
.iE
This function creates an instance of an XmQuestionDialog.

.iS XtXmCreateRadioBox 0
xtent.parent-widget.XtXmCreateRadioBox: ^(widget-name)
.iE
This function creates an instance of an XmRadioBox.

.iS XtXmCreateRowColumn 0
xtent.parent-widget.XtXmCreateRowColumn: ^(widget-name)
.iE
This function creates an instance of an XmRowColumn.

.iS XtXmCreateScale 0
xtent.parent-widget.XtXmCreateScale: ^(widget-name)
.iE
This function creates an instance of an XmScale.

.iS XtXmCreateScrollBar 0
xtent.parent-widget.XtXmCreateScrollBar: ^(widget-name)
.iE
This function creates an instance of an XmScrollBar.

.iS XtXmCreateScrolledList 0
xtent.parent-widget.XtXmCreateScrolledList: ^(widget-name)
.iE
This function creates an instance of an XmScrolledList.

.iS XtXmCreateScrolledText 0
xtent.parent-widget.XtXmCreateScrolledText: ^(widget-name)
.iE
This function creates an instance of an XmScrolledText.

.iS XtXmCreateScrolledWindow 0
xtent.parent-widget.XtXmCreateScrolledWindow: ^(widget-name)
.iE
This function creates an instance of an XmScrolledWindow.

.iS XtXmCreateSelectionBox 0
xtent.parent-widget.XtXmCreateSelectionBox: ^(widget-name)
.iE
This function creates an instance of an XmSelectionBox.

.iS XtXmCreateSelectionDialog 0
xtent.parent-widget.XtXmCreateSelectionDialog: ^(widget-name)
.iE
This function creates an instance of an XmSelectionDialog.

.iS XtXmCreateSeparator 0
xtent.parent-widget.XtXmCreateSeparator: ^(widget-name)
.iE
This function creates an instance of an XmSeparator.

.iS XtXmCreateSeparatorGadget 0
xtent.parent-widget.XtXmCreateSeparatorGadget: ^(widget-name)
.iE
This function creates an instance of an XmSeparatorGadget.

.iS XtXmCreateSimpleCheckBox 0
xtent.parent-widget.XtXmCreateSimpleCheckBox: ^(widget-name)
.iE
This function creates an instance of an XmSimpleCheckBox.

.iS XtXmCreateSimpleMenuBar 0
xtent.parent-widget.XtXmCreateSimpleMenuBar: ^(widget-name)
.iE
This function creates an instance of an XmSimpleMenuBar.

.iS XtXmCreateSimpleOptionMenu 0
xtent.parent-widget.XtXmCreateSimpleOptionMenu: ^(widget-name)
.iE
This function creates an instance of an XmSimpleOptionMenu.

.iS XtXmCreateSimplePopupMenu 0
xtent.parent-widget.XtXmCreateSimplePopupMenu: ^(widget-name)
.iE
This function creates an instance of an XmSimplePopupMenu.

.iS XtXmCreateSimplePulldownMenu 0
xtent.parent-widget.XtXmCreateSimplePulldownMenu: ^(widget-name)
.iE
This function creates an instance of an XmSimplePulldownMenu.

.iS XtXmCreateSimpleRadioBox 0
xtent.parent-widget.XtXmCreateSimpleRadioBox: ^(widget-name)
.iE
This function creates an instance of an XmSimpleRadioBox.

.iS XtXmCreateTemplateDialog 0
xtent.parent-widget.XtXmCreateTemplateDialog: ^(widget-name)
.iE
This function creates an instance of an XmTemplateDialog.

.iS XtXmCreateText 0
xtent.parent-widget.XtXmCreateText: ^(widget-name)
.iE
This function creates an instance of an XmText.

.iS XtXmCreateTextField 0
xtent.parent-widget.XtXmCreateTextField: ^(widget-name)
.iE
This function creates an instance of an XmTextField.

.iS XtXmCreateToggleButton 0
xtent.parent-widget.XtXmCreateToggleButton: ^(widget-name)
.iE
This function creates an instance of an XmToggleButton.

.iS XtXmCreateToggleButtonGadget 0
xtent.parent-widget.XtXmCreateToggleButtonGadget: ^(widget-name)
.iE
This function creates an instance of an XmToggleButtonGadget.

.iS XtXmCreateWorkArea 0
xtent.parent-widget.XtXmCreateWorkArea: ^(widget-name)
.iE
This function creates an instance of an XmWorkArea.

.iS XtXmCreateWorkingDialog 0
xtent.parent-widget.XtXmCreateWorkingDialog: ^(widget-name)
.iE
This function creates an instance of an XmWorkingDialog.

.iS XtXmDeactivateProtocol 0
xtent.widget.XtXmDeactivateProtocol: (^(property-atom-name),
                                      ^(protocol-atom-name))
.iE
This function deactivates a protocol without removing it.

.iS XtXmDeactivateWMProtocol 0
xtent.widget.XtXmDeactivateWMProtocol: ^(protocol-atom-name)
.iE
This function deactivates specified protocol (with the property
WM_PROTOCOLS).

.iS XtXmDestroyPixmap 0
xtent.widget.XtXmDestroyPixmap: (^(pixmap-index),
                                 ^(status-return))
.iE
This function frees pixmaps that are cached by the Motif pixmap
mechanism.

.iS XtXmDragStart 0
xtent.widget.XtXmDragStart: (^(event-id),
                             ^(drag-context-widget-return))
.iE
This function initiates a drag operation.

.iS XtXmDropSiteConfigureStackingOrder 0
xtent.widget.XtXmDropSiteConfigureStackingOrder:
                         (^(widget-sibling),
                          ^(stack-mode))
.iE
This function changes the stacking order of the specified widget and
widget sibling.  The stack mode parameter should be either XmABOVE or
XmBELOW.  XmABOVE is the default.

.iS XtXmDropSiteEndUpdate 0
xtent.widget.XtXmDropSiteEndUpdate:
.iE
This function and XmDropSiteStartUpdate: are used to process updates
to multiple drop sites within the same widget hierarchy.
XtXmDropSiteEndUpdate: and XmDropSiteStartUpdate: signal the beginning
and end respectively of a series of calls to XmDropSiteUpdate:.

.iS XtXmDropSiteQueryStackingOrder 0
xtent.widget.XtXmDropSiteQueryStackingOrder:
                       (^(parent-widget-return),
                        ^(drop-site-children-list),
                        ^(drop-site-count))
.iE
This functionobtains the parent widget and a list of drop site child
widgets for the specified widget.  The children are listed in stacking
order, from bottom-most (first child) to top-most (last child).  The
drop site count is the count in the child widget list.

.iS XtXmDropSiteRegister 0
xtent.widget.XtXmDropSiteRegister:
.iE
This function identifies the specified widget or gadget as a drop site
and sets resource values that define the behavior of the drop site.

.iS XtXmDropSiteRetrieve 0
xtent.widget.XtXmDropSiteRetrieve:
.iE
This function will be updated in the next point release (sure).

.iS XtXmDropSiteStartUpdate 0
xtent.widget.XtXmDropSiteStartUpdate:
.iE
This function and XmDropSiteEndUpdate: are used to process updates to
multiple drop sites within the same widget hierarchy.
XtXmDropSiteEndUpdate: and XmDropSiteStartUpdate: signal the beginning
and end respectively of a series of calls to XmDropSiteUpdate:.

.iS XtXmDropSiteUnregister 0
xtent.widget.XtXmDropSiteUnregister:
.iE
This function informs the toolkit that the specified widget is no
longer a registered drop site.  The function frees all associated drop
site information.

.iS XtXmDropSiteUpdate 0
xtent.widget.XtXmDropSiteUpdate:
.iE
This function will be updated in the next point release (sure).

.iS XtXmDropTransferAdd 0
xtent.widget.XtXmDropTransferAdd:
.iE
This function will be updated in the next point release (sure).

.iS XtXmDropTransferStart 0
xtent.widget.XtXmDropTransferStart: ^(drop-transfer-widget-return)
.iE
This function initiates a drop transfer.

.iS XtXmFileSelectionBoxGetChild 0
xtent.widget.XtXmFileSelectionBoxGetChild:  (^(child-name),
                              ^(child-widget-name-return))
.iE
This function is used to access a component within a
\f(CWFileSelectionBox\fP widget instance.  The \f(CWchild-name\fP
should be one of the following:
.BL
.LI
XmDIALOG_APPLY_BUTTON
.LI
XmDIALOG_CANCEL_BUTTON
.LI
XmDIALOG_DEFAULT_BUTTON
.LI
XmDIALOG_DIR_LIST
.LI
XmDIALOG_DIR_LIST_LABEL
.LI
XmDIALOG_FILTER_LABEL
.LI
XmDIALOG_FILTER_TEXT
.LI
XmDIALOG_HELP_BUTTON
.LI
XmDIALOG_LIST
.LI
XmDIALOG_LIST_LABEL
.LI
XmDIALOG_OK_BUTTON
.LI
XmDIALOG_SELECTION_LABEL
.LI
XmDIALOG_SEPARATOR
.LI
XmDIALOG_TEXT
.LI
XmDIALOG_WORK_AREA
.LE
.P
XmDIALOG_WORK_AREA is the default.

.iS XtXmFileSelectionDoSearch 0
xtent.widget.XtXmFileSelectionDoSearch: ^(directory-mask)
.iE
This function initiates a directory and file search in a
FileSelectionBox widget.

.iS XtXmGetColors 0
xtent.widget.XtXmGetColors: (^(background-color),
                             ^(foreground-return),
                             ^(top-shadow-return),
                             ^(bottom-shadow-return),
                             ^(select-return))
.iE
This function gets the pixel values for foreground, select, and shadow
colors for the specified background color using the screen and
colormap for the specified widget.

.iS XtXmGetDestination 0
xtent.XtXmGetDestination: ^(widget-name-return)
.iE
This function returns the name of the widget to be used as the current
destination for quick paste and certain clipboard operations

.iS XtXmGetDragContext 0
xtent.widget.XtXmGetDragContext: (^(timestamp-id),
                                  ^(reference-widget-return))
.iE
This function returns the widget name of the active drag context
associated with the display and timestamp.  The time stamp ID defaults
to the value returned by XtLastTimestamp() if the time stamp is
\f(CW-\fP or null.

.iS XtXmGetFocusWidget 0
xtent.widget.XtXmGetFocusWidget: ^(widget-name-return)
.iE
This function examines the hierarchy that contains the specified
widget and returns the name of the widget that has keyboard focus.

.iS XtXmGetPixmap 0
xtent.widget.XtXmGetPixmap: (^(image-name),
                             ^(foreground-color),
                             ^(background-color),
                             ^(pixmap-id-return))
.iE
This function looks up the image name in the Motif pixmap cache and
loads the named bitmap file if none is found.  Applications should use
XtXmDestroyPixmap: when the pixmap is no longer needed.

.iS XtXmGetPiXmapByDepth 0
xtent.widget.XtXmGetPiXmapByDepth: (^(image-name),
                                    ^(foreground-color),
                                    ^(background-color),
                                    ^(pixmap-depth),
                                    ^(pixmap-id-return))
.iE
This function looks up the image name and depth in the Motif pixmap
cache and loads the named bitmap file if none is found.  Applications
should use XtXmDestroyPixmap: when the pixmap is no longer needed.

.iS XtXmGetPostedFromWidget 0
xtent.widget.XtXmGetPostedFromWidget: ^(posting-widget-return)
.iE
This function returns the widget name from which a menu was posted.

.iS XtXmGetTabGroup 0
xtent.widget.XtXmGetTabGroup: ^(tab-group-widget-return)
.iE
This function returns the widget name of the tab group that contains
the specified widget.

.iS XtXmGetTearOffControl 0
xtent.widget.XtXmGetTearOffControl: ^(tear-off-widget-return)
.iE
This ia RowColumn widget function that returns the widget name of the
tear of control widget.

.iS XtXmGetVisibility 0
xtent.widget.XtXmGetVisibility: ^(visibility-return)
.iE
This function returns the visibility state of the specified widget.
The state will be one of the following:
.BL
.LI
XmVISIBILITY_FULLY_OBSCURED
.LI
XmVISIBILITY_UNOBSCURED
.LI
XmVISIBILITY_PARTIALLY_OBSCURED
.LE

.iS XtXmGetXmDisplay 0
xtent.widget.XtXmGetXmDisplay: ^(display-widget-return)
.iE
This function returns the \f(CWXmDisplay\fP object associated with
the specified widget.

.iS XtXmGetXmScreen 0
xtent.widget.XtXmGetXmScreen:
.iE
This function returns the \f(CWXmScreen\fP object associated with
the specified widget.

.iS XtXmInstallImage 0
xtent.XtXmInstallImage: (^(image-name), ^(boole-return))
.iE
This function stores an image in the Motif image cache that can later
referenced as an image or a pixmap.

.iS XtXmIsMotifWMRunning 0
xtent.widget.XtXmIsMotifWMRunning: ^(boole-return)
.iE
This function returns True is the Motif Window Manager is running on
the screen in which the widget is resident.

.iS XtXmIsTraversable 0
xtent.widget.XtXmIsTraversable: ^(boole-return)
.iE
This function returns True if the specified widget is eligible to
receive keyboard focus via keyboard traversal.

.iS XtXmListAddItem 0
xtent.widget.XtXmListAddItem: (^(new-item-string),
                               ^(item-position))
.iE
This function adds an item to the list at the given position.  When
the item is inserted into the list, it is compared with the current
XmNselectedItems list.  If the new item matches an item on the
selected list, it appears selected.  Indexing starts at 1.  An index
of zero adds to the end of the list.

.iS XtXmListAddItemUnselected 0
xtent.widget.XtXmListAddItemUnselected: (^(new-item-string),
                                         ^(item-position))
.iE
This function behaves as XtXmListAddItem: except that the new item is
not drawing as a selected item.

.iS XtXmListAddItems 0
xtent.widget.XtXmListAddItems: (^(item-position),
                                ^(item-a), ^(item-b),
                                ^(item-c), ...)
.iE
This function adds the specified items to the list at the given
position.  This function acts as a plural form of XtXmListAddItem:.

.iS XtXmListAddItemsUnselected 0
xtent.widget.XtXmListAddItemsUnselected: (^(item-position),
                                          ^(item-a), ^(item-b),
                                          ^(item-c), ...)
.iE
This function adds the specified items to the list at the given
position.  This function acts as a plural form of
XtXmListAddItemUnselected:.

.iS XtXmListDeleteAllItems 0
xtent.widget.XtXmListDeleteAllItems:
.iE
This function deletes all items from the list.

.iS XtXmListDeleteItem 0
xtent.widget.XtXmListDeleteItem: ^(item-string)
.iE
This function deletes the first item in the list that matches the
specified string.

.iS XtXmListDeleteItems 0
xtent.widget.XtXmListDeleteItems: (^(item-a), ^(item-b),
                                   ^(item-c), ...)
.iE
This function acts as a plural from of XtXmListDeleteItem:.

.iS XtXmListDeleteItemsPos 0
xtent.widget.XtXmListDeleteItemsPos: (^(item-count),
                                      ^(item-position))
.iE
This function deletes the specified number of items from the list
starting at the specified position.

.iS XtXmListDeletePos 0
xtent.widget.XtXmListDeletePos: ^(item-position)
.iE
This function deletes an item at a specified position.

.iS XtXmListDeletePositions 0
xtent.widget.XtXmListDeletePositions: (^(item-position-1),
                                       ^(item-position-2),
                                       ^(item-position-3),
                                       ...
.iE
This function deletes items at a specified positions.

.iS XtXmListDeselectAllItems 0
xtent.widget.XtXmListDeselectAllItems:
.iE
This function unhighlights and removes all items from the selected
list.

.iS XtXmListDeselectItem 0
xtent.widget.XtXmListDeselectItem: ^(item-string)
.iE
This function unhighlights and removes from the selected list the
first item in the list that matches specified string.

.iS XtXmListDeselectPos 0
xtent.widget.XtXmListDeselectPos: ^(item-position)
.iE
This function unhighlights the item at the specified position and
deletes it from the list of selected items.

.iS XtXmListGetKbdItemPos 0
xtent.widget.XtXmListGetKbdItemPos: ^(item-position-return)
.iE
This function returns the position of the list item currently under
the cursor.

.iS XtXmListGetMatchPos 0
xtent.widget.XtXmListGetMatchPos: (^(item-string),
                                   ^(boole-status-return),
                                   ^(return-list-string),
                                   ^(return-count))
.iE
This function returns a list of the positions at which the item string
occurs in the list.  boole-status-return is set to True if items have
been found.

.iS XtXmListGetSelectedPos 0
xtent.widget.XtXmListGetSelectedPos: (^(boole-status-return),
                                      ^(return-list-string),
                                      ^(return-count))
.iE
This function returns a list of the positions of the items that are
currently selected in the list.  boole-status-return is set to True if
items have been found.

.iS XtXmListItemExists 0
xtent.widget.XtXmListItemExists: (^(item-string),
                                  ^(boole-status-return))
.iE
This function returns True if the specified item is present in the
list.

.iS XtXmListItemPos 0
xtent.widget.XtXmListItemPos: (^(item-string),
                               ^(return-position))
.iE
This function returns the position of the first instance of the
specified item in a List.

.iS XtXmListPosSelected 0
xtent.widget.XtXmListPosSelected: (^(item-position),
                                   ^(boole-selected-return))
.iE
This function returns True if the item at the specified position is
currently selected.

.iS XtXmListPosToBounds 0
xtent.widget.XtXmListPosToBounds: (^(item-position),
                                   ^(boole-status-return),
                                   ^(return-x), ^(return-y),
                                   ^(return-width), ^(return-height))
.iE
This function the bounding box of the specified position in the list.

.iS XtXmListReplaceItems 0
xtent.widget.XtXmListReplaceItems: (^(old-item-a),
                                    ^(old-item-b),
                                    ^(old-item-c),
                                    ...
                                    ^(new-item-a),
                                    ^(new-item-b),
                                    ^(new-item-c),
                                    ...)
.iE
This function replaces each specified item of the list with a
corresponding new item.

.iS XtXmListReplaceItemsPos 0
xtent.widget.XtXmListReplaceItemsPos: (^(item-position),
                                       ^(item-a), ^(item-b),
                                       ^(item-c), ...)
.iE
This function replaces items of the List with new items, starting at
the specified position in the List.

.iS XtXmListReplaceItemsPosUnselected 0
xtent.widget.XtXmListReplaceItemsPosUnselected: (^(item-position),
                                                 ^(item-a),
                                                 ^(item-b),
                                                 ^(item-c),
                                                 ...)
.iE
This function replaces items of the List with new items, starting at
the specified position in the List.  The replacement items remain
unselected.

.iS XtXmListReplaceItemsUnselected 0
xtent.widget.XtXmListReplaceItemsUnselected:  (^(old-item-a),
                                               ^(old-item-b),
                                               ^(old-item-c),
                                               ...
                                               ^(new-item-a),
                                               ^(new-item-b),
                                               ^(new-item-c),
                                               ...)
.iE
This function replaces each specified item of the list with a
corresponding new item.  The replacement items remain unselected.

.iS XtXmListReplacePositions 0
xtent.widget.XtXmListReplacePositions: (^(pos-item-a),
                                        ^(new-item-a),
                                        ^(pos-item-b),
                                        ^(new-item-b),
                                        ^(pos-item-c),
                                        ^(new-item-c),
                                        ...)
.iE
This function replaces noncontiguous items in a list.

.iS XtXmListSelectItem 0
xtent.widget.XtXmListSelectItem: (^(item-string),
                                  ^(boole-status-return))
.iE
This function highlights and adds to the selected list the first item
in the list that matches the specified string.

.iS XtXmListSelectPos 0
xtent.widget.XtXmListSelectPos: (^(item-position),
               ^(call-selection-callback-boolean))
.iE
This function highlights the list item at the specified position and
adds it to the list of selected items.

.iS XtXmListSetAddMode 0
xtent.widget.XtXmListSetAddMode: ^(boole-activate-add-mode)
.iE
This function activates or deactivates add mode in the extended
selection model.

.iS XtXmListSetBottomItem 0
xtent.widget.XtXmListSetBottomItem: ^(item-string)
.iE
This function makes the first item in the list that matches the
specified string the last visible item in the list.

.iS XtXmListSetBottomPos 0
xtent.widget.XtXmListSetBottomPos: ^(item-position),
.iE
This function makes the item at the specified position the last
visible item in the list.

.iS XtXmListSetHorizPos 0
xtent.widget.XtXmListSetHorizPos: ^(position)
.iE
This function is equivalent to moving the horizontal ScrollBar to the
specified position.

.iS XtXmListSetItem 0
xtent.widget.XtXmListSetItem: ^(item-string)
.iE
This function makes the first item in the list that matches specified
string the first visible item in the list.

.iS XtXmListSetKbdItemPos 0
xtent.widget.XtXmListSetKbdItemPos: ^(item-position)
.iE
This function sets the location cursor at the specified item position.

.iS XtXmListSetPos 0
xtent.widget.XtXmListSetPos: ^(item-position)
.iE
This function moves of the cursor to the item at the specified
position.

.iS XtXmListUpdateSelectedList 0
xtent.widget.XtXmListUpdateSelectedList:
.iE
This function frees the contents of the \f(CWXmNselectedItems list\fP.

.iS XtXmListYToPos 0
xtent.widget.XtXmListYToPos: (^(y-position),
                              ^(item-position-return))
.iE
This function returns the position of the item at the given
y-coordinate within the list.

.iS XtXmMainWindowSep1 0
xtent.widget.XtXmMainWindowSep1: ^(return-widget-name)
.iE
This function returns the name of the first Separator widget in the
MainWindow.  The first Separator widget is located between the MenuBar
and the Command widget.

.iS XtXmMainWindowSep2 0
xtent.widget.XtXmMainWindowSep2: ^(return-widget-name)
.iE
This function returns the name of the second Separator widget in the
MainWindow.  The second Separator widget is located between the
Command widget and the ScrolledWindow.

.iS XtXmMainWindowSep3 0
xtent.widget.XtXmMainWindowSep3: ^(return-widget-name)
.iE
This function returns the name of the third Separator widget in the
MainWindow.  The third Separator widget is located between the message
window and the widget above it.

.iS XtXmMainWindowSetAreas 0
xtent.widget.XtXmMainWindowSetAreas: (^(menu-bar),
                                      ^(command-window),
                                      ^(horiz-scrollbar),
                                      ^(vert-scrollbar),
                                      ^(work-region))
.iE
This function identifies which of the valid children for each area
(such as the MenuBar and work region) are to be actively managed by
MainWindow.  This function also sets up or adds the MenuBar, work
window, command window, and ScrollBar widgets to the application's
main window widget.  Each area is optional.  The application can pass
an emptry argument to one or more of the arguments.

.iS XtXmMenuPosition 0
xtent.widget.XtXmMenuPosition: ^(event-id)
.iE
This function positions a Popup MenuPane using the information in the
specified event.  Unless an application is positioning the MenuPane
itself, it must first invoke this function before managing the
PopupMenu.  The event id is usually a context specific variable from
an event handler.

.iS XtXmMessageBoxGetChild 0
xtent.widget.XtXmMessageBoxGetChild: (^(component),
                                      ^(return-widget-name))
.iE
This function is used to access a widget within a MessageBox.  The
component variable must be one of the following:
.BL
.LI
XmDIALOG_CANCEL_BUTTON
.LI
XmDIALOG_DEFAULT_BUTTON
.LI
XmDIALOG_HELP_BUTTON
.LI
XmDIALOG_MESSAGE_LABEL
.LI
XmDIALOG_OK_BUTTON
.LI
XmDIALOG_SEPARATOR
.LI
XmDIALOG_SYMBOL_LABEL
.LE
The default is XmDIALOG_SYMBOL_LABEL.

.iS XtXmOptionButtonGadget 0
xtent.widget.XtXmOptionButtonGadget: ^(return-widget-name)
.iE
This function returns the widget name of the internally created
CascadeButtonGadget.  The application can use the name to adjust the
visuals for the CascadeButtonGadget.

.iS XtXmOptionLabelGadget 0
xtent.widget.XtXmOptionLabelGadget: ^(return-widget-name)
.iE
This function returns the widget name of the internally created
LabelGadget.  The application can use the name to adjust the
visuals for the LabelGadget.

.iS XtXmProcessTraversal 0
xtent.widget.XtXmProcessTraversal: (^(direction),
                                    ^(boole-return-status))
.iE
This function determines which component of a hierarchy receives
keyboard events when the hierarchy that contains the given widget has
keyboard focus.  It is not possible to use XmProcessTraversal to
traverse to MenuBars, Pulldown MenuPanes, or Popup MenuPanes.  The
hierarchy is only traversed up to the top of the shell.  If that shell
does not currently have the focus, any changes to the element with
focus within that shell will not occur until the next time the shell
receives focus.  Direction should be one of the following strings:
.BL
.LI
XmTRAVERSE_CURRENT
.LI
XmTRAVERSE_DOWN
.LI
XmTRAVERSE_HOME
.LI
XmTRAVERSE_LEFT
.LI
XmTRAVERSE_NEXT
.LI
XmTRAVERSE_NEXT_TAB_GROUP
.LI
XmTRAVERSE_PREV
.LI
XmTRAVERSE_PREV_TAB_GROUP
.LI
XmTRAVERSE_RIGHT
.LI
XmTRAVERSE_UP
.LE
The default is XmTRAVERSE_RIGHT.

.iS XtXmRemoveProtocolCallback 0
xtent.widget.^(protocol).XtXmRemoveProtocolCallback: (^(property),
         ^(callback-code))
.iE
This function removes a previously installed protocol callback.

.iS XtXmRemoveProtocols 0
xtent.widget.XtXmRemoveProtocols: (^(property-atom-name),
                                   ^(protocol-atom-name1),
                                   ^(protocol-atom-name2),
                                   ^(protocol-atom-name3),
                                   ...)
.iE
This function removes the protocols from the protocol manager and
deallocates the internal tables.  If any of the protocols are active,
it will update the handlers and update the property if shell is
realized.

.iS XtXmRemoveTabGroup 0
xtent.widget.XtXmRemoveTabGroup:
.iE
This function removes a widget from the list of tab groups associated
with a particular widget hierarchy and sets the widget's
XmNnavigationType to XmNONE.

.iS XtXmRemoveWMProtocolCallback 0
xtent.widget.^(protocol).XtXmRemoveWMProtocolCallback:
                                          ^(callback-code)
.iE
This function removes a previously installed window manager protocol
callback.  This function calls XtXmRemoveProtocolCallback: with the
property value set to the atom returned by interning WM_PROTOCOLS.

.iS XtXmRemoveWMProtocols 0
xtent.widget.XtXmRemoveWMProtocols: (^(protocol-atom-name1),
                                     ^(protocol-atom-name2),
                                     ^(protocol-atom-name3),
                                     ...)
.iE
This function removes the protocols from the protocol manager and
deallocates the internal tables.  If any of the protocols are active,
it will update the handlers and update the property if shell is
realized.  This function calls XmRemoveProtocols with the property
value set to the atom returned by interningWM_PROTOCOLS.

.iS XtXmRepTypeAddReverse 0
xtent.XtXmRepTypeAddReverse: ^(representation-id)
.iE
This function installs the reverse converter for a previously
registered representation type.

.iS XtXmRepTypeGetId 0
xtent.XtXmRepTypeGetId: (^(representation-name),
                                ^(representation-id-return))
.iE
This function returns the id of the specified representation.

.iS XtXmRepTypeGetNameList 0
xtent.XtXmRepTypeGetNameList: (^(representation-id),
                               ^(boole-use-uppercase),
                               ^(list-return)
.iE
This function generates a comma separated list of value names for the
representation type.

.iS XtXmRepTypeInstallTearOffModelConverter 0
xtent.widget.XtXmRepTypeInstallTearOffModelConverter:
.iE
This function installs the resource converter that allows values for
the XmTearOffModel resource to be specified with resources.

.iS XtXmRepTypeRegister 0
xtent.XtXmRepTypeRegister: (^(id-return),
                            ^(representation-name),
                            ^(name-1), ^(value-1),
                            ^(name-2), ^(value-2),
                            ^(name-3), ^(value-3),
                            ...)

xtent.XtXmRepTypeRegister: (^(id-return),
                            ^(representation-name),
                            ^(name-1),
                            ^(name-2),
                            ^(name-3),
                            ...)
.iE
This function registers a representation type resource with the
representation type manager.  Entries can be as name/value pairs or
simply as a list of names.  The values for the names only style are
assumed to be an enumeration starting at zero.

.iS XtXmRepTypeValidValue 0
xtent.XtXmRepTypeValidValue: (^(representation-id),
                              ^(test-value),
                              ^(warnings-widget),
                              ^(boole-return))
.iE
This function tests the validity of a numerical value for a given
representation type.

.iS XtXmScaleGetValue 0
xtent.widget.XtXmScaleGetValue: ^(scale-value-return)
.iE
This function returns the current slider position value displayed in
the specified Scale widget.

.iS XtXmScaleSetValue 0
xtent.widget.XtXmScaleSetValue: ^(scale-value)
.iE
This function sets the slider value for the specified the Scale
widget.

.iS XtXmScrollBarGetValues 0
xtent.widget.XtXmScrollBarGetValues: (^(value-return),
                                      ^(slider-size-return),
                                      ^(increment-return),
                                      ^(page-increment-return))
.iE
This function returns the the ScrollBar's increment values.

.iS XtXmScrollBarSetValues 0
xtent.widget.XtXmScrollBarSetValues: (^(value-return),
                                      ^(slider-size-return),
                                      ^(increment-return),
                                      ^(page-increment-return))
.iE
This function sets the the ScrollBar's increment values and the size
and position.

.iS XtXmScrollVisible 0
xtent.widget.XtXmScrollVisible: (^(widget-to-be-made-visible),
                                 ^(left-right-margins),
                                 ^(top-bottom-margins))
.iE
This function makes an obscured or partially obscured widget or gadget
descendant of a scrolledwindow work area visible.

.iS XtXmScrolledWindowSetAreas 0
xtent.widget.XtXmScrolledWindowSetAreas: (^(horizontal-scrollbar),
                                          ^(vertical-scrollbar),
                                          ^(work-region))
.iE
This function adds or changes the widgets within a scrolled area.
Each widget is optional and may be passed as an emptry string.

.iS XtXmSelectionBoxGetChild 0
xtent.widget.XtXmSelectionBoxGetChild: (^(widget-component-name),
                                        ^(widget-return))
.iE
This function is used to access a component within a SelectionBox.
The component name must be one of the following:
.BL
.LI
XmDIALOG_APPLY_BUTTON
.LI
XmDIALOG_CANCEL_BUTTON
.LI
XmDIALOG_DEFAULT_BUTTON
.LI
XmDIALOG_HELP_BUTTON
.LI
XmDIALOG_LIST
.LI
XmDIALOG_LIST_LABEL
.LI
XmDIALOG_OK_BUTTON
.LI
XmDIALOG_SELECTION_LABEL
.LI
XmDIALOG_SEPARATOR
.LI
XmDIALOG_TEXT
.LI
XmDIALOG_WORK_AREA
.LE
The default component is XmDIALOG_WORK_AREA.

.iS XtXmSetFontUnit 0
xtent.XtXmSetFontUnit: ^(font-unit-integer)
.iE
This function provides an external interface to initialize the font
unit values.

.iS XtXmSetFontUnits 0
xtent.XtXmSetFontUnits: (^(horiz-integer), ^(vert-integer))
.iE
This function provides an external interface to initialize the font
unit values.

.iS XtXmTextClearSelection 0
xtent.widget.XtXmTextClearSelection: ^(time-stamp-id)
.iE
This function clears the primary selection in the Text widget.  The
time stamp ID defaults to the value returned by XtLastTimestamp() if
the time stamp is \f(CW-\fP or null.

.iS XtXmTextCopy 0
xtent.widget.XtXmTextCopy: ^(time-stamp-id)
.iE
This function clears the primary selection in the Text widget.  The
time stamp ID defaults to the value returned by XtLastTimestamp() if
the time stamp is \f(CW-\fP or null.

.iS XtXmTextCut 0
xtent.widget.XtXmTextCut: ^(time-stamp-id)
.iE
This function copies the primary selected text to the clipboard and
then deletes the primary selected text.  The time stamp ID defaults to
the value returned by XtLastTimestamp() if the time stamp is \f(CW-\fP
or null.

.iS XtXmTextDisableRedisplay 0
xtent.widget.XtXmTextDisableRedisplay:
.iE
This function is used in conjunction with XtXmTextEnableRedisplay: to
disable and enable visual updates to the Text widget.

.iS XtXmTextEnableRedisplay 0
xtent.widget.XtXmTextEnableRedisplay:
.iE
This function is used in conjunction with XtXmTextDisableRedisplay: to
enable and disable visual updates to the Text widget.

.iS XtXmTextFieldClearSelection 0
xtent.widget.XtXmTextFieldClearSelection: ^(time-stamp-id)
.iE
This function clears the primary selection in the TextField widget.
The time stamp ID defaults to the value returned by XtLastTimestamp()
if the time stamp is \f(CW-\fP or null.

.iS XtXmTextFieldCopy 0
xtent.widget.XtXmTextFieldCopy: ^(time-stamp-id)
.iE
This function copies the primary selected text to the clipboard.  The
time stamp ID defaults to the value returned by XtLastTimestamp() if
the time stamp is \f(CW-\fP or null.

.iS XtXmTextFieldCut 0
xtent.widget.XtXmTextFieldCut: ^(time-stamp-id)
.iE
This function copies the primary selected text to the clipboard and
then deletes the primary selected text.  The time stamp ID defaults to
the value returned by XtLastTimestamp() if the time stamp is \f(CW-\fP
or null.

.iS XtXmTextFieldGetBaseLine 0
xtent.widget.XtXmTextFieldGetBaseLine: ^(baseline-return)
.iE
This function returns an integer value that indicates the \*Vx\*O
position of the first baseline in the TextField widget.  The
calculation takes into account the margin height, shadow thickness,
highlight thickness, and font ascent of the first font in the
fontlist.  In this calculation the \*Vx\*O position of the top of the
widget is 0.

.iS XtXmTextFieldGetEditable 0
xtent.widget.XtXmTextFieldGetEditable: ^(boole-editable-return)
.iE
This function returns a boolean value that indicates the state of the
XmNeditable resource.

.iS XtXmTextFieldGetInsertionPosition 0
xtent.widget.XtXmTextFieldGetInsertionPosition: ^(position-return)
.iE
This function returns an XmTextPosition value that indicates the state
of the XmNcursorPosition resource.  This is an integer number of
characters from the beginning of the text buffer.  The first character
position is 0.

.iS XtXmTextFieldGetLastPosition 0
xtent.widget.XtXmTextFieldGetLastPosition: ^(position-return)
.iE
This function returns an XmTextPosition value that indicates of the
last character in the text buffer.  This is an integer number of
characters from the beginning of the text buffer.  The first character
position is 0.

.iS XtXmTextFieldGetMaxLength 0
xtent.widget.XtXmTextFieldGetMaxLength: ^(length-return)
.iE
This function returns the integer value that indicates the maximum
allowable string length that can be entered from the keyboard.

.iS XtXmTextFieldGetSelection 0
xtent.widget.XtXmTextFieldGetSelection: ^(selection-string)
.iE
This function returns the string that is associated with the primary
selection.

.iS XtXmTextFieldGetSelectionPosition 0
xtent.widget.XtXmTextFieldGetSelectionPosition:
                    (^(left-position-return),
                     ^(right-position-return),
                     ^(boole-owns-selection-return))
.iE
This function returns the left and right position of the primary
selection in the text buffer of the TextField widget.  This function
returns True if the widget owns the primary selection; otherwise, it
returns False.

.iS XtXmTextFieldGetString 0
xtent.widget.XtXmTextFieldGetString: ^(string-return)
.iE
This function returns the string value of the TextField widget.

.iS XtXmTextFieldGetSubstring 0
xtent.widget.XtXmTextFieldGetSubstring: (^(start-position),
                                         ^(length), ^(buffer-size),
                                         ^(string-return),
                                         ^(status-return))
.iE
This function retrieves a copy of a portion of the internal text
buffer.  The status return will be one of the following values:
.BL
.LI
XmCOPY_SUCCEEDED
.LI
XmCOPY_FAILED
.LI
XmCOPY_TRUNCATED
.LE

.iS XtXmTextFieldInsert 0
xtent.widget.XtXmTextFieldInsert: (^(insert-position),
                                   ^(string))
.iE
This function inserts a character string into the text string in the
TextField widget.  The character positions begin at zero and are
numbered sequentially from the beginning of the text.

.iS XtXmTextFieldPaste 0
xtent.widget.XtXmTextFieldPaste: ^(boole-own-selection-return)
.iE
This function inserts the clipboard selection at the insertion cursor
position.  This function returns False if the widget doesn't own the
primary selection.

.iS XtXmTextFieldPosToXY 0
xtent.widget.XtXmTextFieldPosToXY: (^(text-position),
                                    ^(X-return), ^(Y-return),
                                    ^(boole-status-return))
.iE
This function returns the (X,Y) position of the a specified character
positions in the text field.  This function returns True if the
character position is displayed in the TextField widget; otherwise, it
returns False, and no X or Y values are returned.

.iS XtXmTextFieldRemove 0
xtent.widget.XtXmTextFieldRemove:
.iE
This function deletes the primary selected text.  This function
returns False if the primary selection is NULL or if the widget
doesn't own the primary selection.

.iS XtXmTextFieldReplace 0
xtent.widget.XtXmTextFieldReplace: (^(start-position), ^(end-position),
                                    ^(replacement-string))
.iE
This function replaces part of the text string in the TextField
widget.  The character positions begin at zero and are numbered
sequentially from the beginning of the text.

.iS XtXmTextFieldSetAddMode 0
xtent.widget.XtXmTextFieldSetAddMode: ^(boole-add-mode)
.iE
This function controls whether or not the TextField widget is in Add
Mode.  When the widget is in Add Mode, the insert cursor can be moved
without disturbing the primary selection.

.iS XtXmTextFieldSetEditable 0
xtent.widget.XtXmTextFieldSetEditable: ^(boole-editable)
.iE
This function sets the edit permission state of the TextField widget.
When set to True, the text string can be edited.

.iS XtXmTextFieldSetHighlight 0
xtent.widget.XtXmTextFieldSetHighlight: (^(start-position),
                                         ^(end-position),
                                         ^(highlight-mode))
.iE
This function highlights text between the two specified character
positions.  The mode parameter determines the type of highlighting.
Highlighting text merely changes the visual appearance of the text; it
does not set the selection.  The mode should be one of the following:
.BL
.LI
XmHIGHLIGHT_NORMAL \(en removes highlighting
.LI
XmHIGHLIGHT_SELECTED \(en reverse video
.LI
XmHIGHLIGHT_SECONDARY_SELECTED \(en underlining
.LE
The default is XmHIGHLIGHT_SECONDARY_SELECTED

.iS XtXmTextFieldSetInsertionPosition 0
xtent.widget.XtXmTextFieldSetInsertionPosition: ^(insert-position)
.iE
This function sets the insertion cursor position of the TextField
widget.

.iS XtXmTextFieldSetMaxLength 0
xtent.widget.XtXmTextFieldSetMaxLength: ^(max-length)
.iE
This function sets the value of the current maximum allowable length
of the text string in the TextField widget.  The maximum allowable
length prevents the user from entering a text string from the keyboard
that is larger than this limit.

.iS XtXmTextFieldSetSelection 0
xtent.widget.XtXmTextFieldSetSelection: (^(start-position),
                                         ^(end-position)
                                          ^(time-stamp-id))
.iE
This function sets the primary selection of the text in the widget.
The time stamp ID defaults to the value returned by XtLastTimestamp()
if the time stamp is \f(CW-\fP or null.

.iS XtXmTextFieldSetString 0
xtent.widget.XtXmTextFieldSetString: ^(new-string)
.iE
This function sets the string value of the TextField widget.

.iS XtXmTextFieldShowPosition 0
xtent.widget.XtXmTextFieldShowPosition: ^(text-position)
.iE
This function forces text at the specified position to be displayed.

.iS XtXmTextFieldXYToPos 0
xtent.widget.XtXmTextFieldXYToPos: (^(X), ^(Y),
                                    ^(position-return))
.iE
This function returns the character position nearest to the specified
x and y position, relative to the upper left corner of the TextField
widget.

.iS XtXmTextFindString 0
xtent.widget.XtXmTextFindString: (^(start-search-position),
                                  ^(search-string),
                                  ^(direction),
                                  ^(position-return),
                                  ^(boole-status-return))
.iE
This function locates the beginning position of the specified text
string.  The status return is set to True if the string is found.  The
direction parameter should be XmTEXT_FORWARD or XmTEXT_BACKWARD.

.iS XtXmTextGetBaseLine 0
xtent.widget.XtXmTextGetBaseLine: ^(baseline-X-return)
.iE
This function returns the first baseline in the Text widget, relative
to the x position of the top of the widget.

.iS XtXmTextGetEditable 0
xtent.widget.XtXmTextGetEditable: ^(boole-editable-return)
.iE
This function returns a boolean value that indicates the state of the
XmNeditable resource.

.iS XtXmTextGetInsertionPosition 0
xtent.widget.XtXmTextGetInsertionPosition: ^(position-return)
.iE
This function returns an XmTextPosition value that indicates the state
of the XmNcursorPosition resource.  This is an integer number of
characters from the beginning of the text buffer.  The first character
position is 0.

.iS XtXmTextGetLastPosition 0
xtent.widget.XtXmTextGetLastPosition: ^(last-position-return)
.iE
This function returns the last position in the text buffer.

.iS XtXmTextGetMaxLength 0
xtent.widget.XtXmTextGetMaxLength: ^(max-length-return)
.iE
This function returns the integer value that indicates the string's
maximum allowable length that can be entered from the keyboard.

.iS XtXmTextGetSelection 0
xtent.widget.XtXmTextGetSelection: ^(selection-string-return)
.iE
This function retrieves the value of the primary selection.  It
returns a NULL string if no text is selected in the widget.

.iS XtXmTextGetSelectionPosition 0
xtent.widget.XtXmTextGetSelectionPosition:
                    (^(left-position-return),
                     ^(right-position-return),
                     ^(boole-owns-selection-return))
.iE
This function returns the left and right position of the primary
selection in the text buffer of the TextField widget.  This function
returns True if the widget owns the primary selection; otherwise, it
returns False.

.iS XtXmTextGetSource 0
xtent.widget.XtXmTextGetSource: ^(source-return-id)
.iE
This function returns an XmTextSource value that represents the source
of the Text widget.

.iS XtXmTextGetString 0
xtent.widget.XtXmTextGetString: ^(string-return)
.iE
This function returns the string value of the Text widget.

.iS XtXmTextGetSubstring 0
xtent.widget.XtXmTextGetSubstring: (^(start-position),
                                    ^(length), ^(buffer-size),
                                    ^(string-return),
                                    ^(status-return))
.iE
This function retrieves a copy of a portion of the internal text
buffer.  The status return will be one of the following values:
.BL
.LI
XmCOPY_SUCCEEDED
.LI
XmCOPY_FAILED
.LI
XmCOPY_TRUNCATED
.LE

.iS XtXmTextGetTopCharacter 0
xtent.widget.XtXmTextGetTopCharacter: ^(character-position-return)
.iE
This function returns an XmTextPosition value that indicates the state
of the XmNtopCharacter resource.  This is an integer number of
characters from the beginning of the text buffer.  The first character
position is 0.

.iS XtXmTextInsert 0
xtent.widget.XtXmTextInsert: (^(insert-position),
                              ^(string))
.iE
This function inserts a character string into the text string in the
Text widget.  The character positions begin at zero and are numbered
sequentially from the beginning of the text.

.iS XtXmTextPaste 0
xtent.widget.XtXmTextPaste: ^(boole-own-selection-return)
.iE
This function inserts the clipboard selection at the insertion cursor
position.  This function returns False if the widget doesn't own the
primary selection.

.iS XtXmTextPosToXY 0
xtent.widget.XtXmTextPosToXY: (^(text-position),
                               ^(X-return), ^(Y-return),
                               ^(boole-status-return))

.iE
This function returns the (X,Y) position of the a specified character
positions in the text field.  This function returns True if the
character position is displayed in the TextField widget; otherwise, it
returns False, and no X or Y values are returned.

.iS XtXmTextRemove 0
xtent.widget.XtXmTextRemove:
.iE
This function deletes the primary selected text.  This function
returns False if the primary selection is NULL or if the widget
doesn't own the primary selection.

.iS XtXmTextReplace 0
xtent.widget.XtXmTextReplace: (^(start-position), ^(end-position),
                               ^(replacement-string))
.iE
This function replaces part of the text string in the Text widget.
The character positions begin at zero and are numbered sequentially
from the beginning of the text.

.iS XtXmTextScroll 0
xtent.widget.XtXmTextScroll: ^(lines-to-scroll)
.iE
This function scrolls text in a Text widget.  A positive value causes
text to scroll upward; a negative value causes text to scroll
downward.

.iS XtXmTextSetAddMode 0
xtent.widget.XtXmTextSetAddMode: ^(boole-add-mode)
.iE
This function controls whether or not the Text widget is in Add Mode.
When the widget is in Add Mode, the insert cursor can be moved without
disturbing the primary selection.

.iS XtXmTextSetEditable 0
xtent.widget.XtXmTextSetEditable: ^(boole-editable)
.iE
This function sets the edit permission state of the Text widget.  When
set to True, the text string can be edited.

.iS XtXmTextSetHighlight 0
xtent.widget.XtXmTextSetHighlight: (^(start-position),
                                    ^(end-position),
                                    ^(highlight-mode))
.iE
This function highlights text between the two specified character
positions.  The mode parameter determines the type of highlighting.
Highlighting text merely changes the visual appearance of the text; it
does not set the selection.  The mode should be one of the following:
.BL
.LI
XmHIGHLIGHT_NORMAL \(en removes highlighting
.LI
XmHIGHLIGHT_SELECTED \(en reverse video
.LI
XmHIGHLIGHT_SECONDARY_SELECTED \(en underlining
.LE
The default is XmHIGHLIGHT_SECONDARY_SELECTED

.iS XtXmTextSetInsertionPosition 0
xtent.widget.XtXmTextSetInsertionPosition: ^(insert-position)
.iE
This function sets the insertion cursor position of the Text widget.

.iS XtXmTextSetMaxLength 0
xtent.widget.XtXmTextSetMaxLength: ^(max-length)
.iE
This function sets the value of the current maximum allowable length
of the text string in the Text widget.  The maximum allowable length
prevents the user from entering a text string from the keyboard that
is larger than this limit.

.iS XtXmTextSetSelection 0
xtent.widget.XtXmTextSetSelection: (^(start-position),
                                    ^(end-position),
                                    ^(time-stamp-id))
.iE
This function sets the primary selection of the text in the widget.
The time stamp ID defaults to the value returned by XtLastTimestamp()
if the time stamp is \f(CW-\fP or null.

.iS XtXmTextSetSource 0
xtent.widget.XtXmTextSetSource: (^(source-id),
                                 ^(top-character-position),
                                 ^(cursor-position))
.iE
This function sets the source of the Text widget.  Text widgets can
share sources of text so that editing in one widget is reflected in
another.  This function sets the source of one widget so that it can
share the source of another widget.

.iS XtXmTextSetString 0
xtent.widget.XtXmTextSetString: ^(new-string)
.iE
This function sets the string value of the Text widget.

.iS XtXmTextSetTopCharacter 0
xtent.widget.XtXmTextSetTopCharacter: ^(top-character-position)
.iE
This function sets the position of the text at the top of the Text
widget.

.iS XtXmTextShowPosition 0
xtent.widget.XtXmTextShowPosition: ^(text-position)
.iE
This function forces text at the specified position to be displayed.

.iS XtXmTextXYToPos 0
xtent.widget.XtXmTextXYToPos: (^(X), ^(Y),
                               ^(position-return))
.iE
This function returns the character position nearest to the specified
x and y position, relative to the upper left corner of the Text
widget.

.iS XtXmToggleButtonGadgetGetState 0
xtent.widget.XtXmToggleButtonGadgetGetState: ^(boole-selected-return)
.iE
This function returns True if the button is selected and False if the
button is unselected.

.iS XtXmToggleButtonGadgetSetState 0
xtent.widget.XtXmToggleButtonGadgetSetState: (^(boole-selected),
                                 ^(boole-call-changed-callback))
.iE
This function sets or changes the ToggleButtonGadget's current state.

.iS XtXmToggleButtonGetState 0
xtent.widget.XtXmToggleButtonGetState: ^(boole-selected-return)
.iE
This function returns True if the button is selected and False if the
button is unselected.

.iS XtXmToggleButtonSetState 0
xtent.widget.XtXmToggleButtonSetState: (^(boole-selected),
                           ^(boole-call-changed-callback))
.iE
This function sets or changes the ToggleButton's current state.

.iS XtXmTrackingEvent 0
xtent.widget.XtXmTrackingEvent: (^(cursor),
                                 ^(boole-confine-to-widget),
                                 ^(widget-of-selection-return))
.iE
This function provides a modal interface for selection of a component.
It is intended to support context help.  The function grabs the
pointer and returns the widget in which a button press occurs.

.iS XtXmUninstallImage 0
xtent.widget.XtXmUninstallImage: (^(image-name), ^(boole-return))
.iE
This function removes an image from the Motif image cache.  The
function returns True when successful and returns False if the
image is NULL, or if it cannot be found to be uninstalled.

.iS XtXmUpdateDisplay 0
xtent.widget.XtXmUpdateDisplay:
.iE
This function provides the application with a mechanism for forcing
all pending exposure events to be removed from the input queue and
processed immediately.

.iS XtXmWidgetGetBaselines 0
xtent.widget.XtXmWidgetGetBaselines: (^(baselines-return),
                                      ^(line-count-return))
.iE
This function returns a comma separated list of the baseline values
associated with the specified widget.

.iS XtXmWidgetGetDisplayRect 0
xtent.widget.XtXmWidgetGetDisplayRect: (^(x-return),
                                        ^(y-return),
                                        ^(width-return),
                                        ^(height-return))
.iE
This function returns the display rectangle for the specified widget.

.iS XtXmCvtXmStringTableToString 0
xtent.XtXmCvtXmStringTableToString: (^(string-table-id),
                                   ^(string-table-count),
                                   ^(string-list-return))
.iE
This function converts a Motif string table id into a list of strings
separated by \\\\n (backslash and n).  The count parameters is the
size of the string table.  String tables are not NULL terminated.

.iS XtXmReinstallXtentConverters 0
xtent.XtXmReinstallXtentConverters:
.iE
This function reinstalls all of the xtent converters.  This allows an
application to use the xtent converters for loading image, using
dithers, naming widgets, etc. that may be overriden by the sometimes
less functional Motif converters.

.ne 45
.H 2 "OpenLook Widget Set Functions"
.XI "OpenLook widget set functions"
The following table contains the names of the OpenLook functions that
are currently implemented under xtent.  The functions are described in
the order in which they appear in this table.  For a detailed
description of each function consult the OpenLook Widget Set
programmer's reference manual.
.TS
center doublebox, tab(;);
l l l.

XtOlAddCallback;Xt_OlAddCallback;XtOlAddCallbackWithArgs;
Xt_OlAddCallbackWithArgs;;;

XtOlMMToPixel;XtOlPointToPixel;XtOlPixelToMM;
XtOlPixelToPoint;XtOl_MMToPixel;XtOl_PointToPixel;
XtOl_PixelToMM;XtOl_PixelToPoint;;

XtOlRegisterHelp;XtOlInitialize;;

XtOlCallAcceptFocus;XtOlGetCurrentFocusWidget;XtOlMoveFocus;
XtOlCanAcceptFocus;XtOlHasFocus;XtOlSetInputFocus;

XtTextClearBuffer;XtTextCopyBuffer;XtTextGetInsertPoint;
XtTextGetLastPos;XtTextInsert;XtTextReadSubString;
XtTextRedraw;XtTextReplace;XtTextSetInsertPoint;
XtTextUpdate;;;

XtOlTextEditClearBuffer;XtOlTextEditCopyBuffer;XtOlTextEditCopySelection;
XtOlTextEditGetCursorPosition;XtOlTextEditGetLastPosition;XtOlTextEditInsert;
XtOlTextEditPaste;XtOlTextEditReadSubString;XtOlTextEditRedraw;
XtOlTextEditSetCursorPosition;XtOlTextEditUpdate;;

XtOlTextFieldCopyString;XtOlTextFieldGetString;

XtOlMenuPopup;XtOlMenuPopdown;XtOlMenuPost;
XtOlMenuUnpost;;;

XtOlSLApplAddItem;XtOlSLApplDeleteItem;XtOlSLApplEditClose;
XtOlSLApplEditOpen;XtOlSLApplTouchItem;XtOlSLApplUpdateView;
XtOlSLApplViewItem;;;

.TE
.ce 1
.TB "OpenLook Widget Set Functions"

.iS XtOlAddCallback 0
xtent.widget.XtOlAddCallback: ^(callback-code)
.iE
This function operates similarly to XtAddCallback, but installs the
callback using OpenLook's OlAddCallback() function, which is needed when 
.XI "callback"
adding callbacks to the XtNwmProtocol callback list.  See the XtAddCallback 
function for more about adding callbacks.

.iS Xt_OlAddCallback 0
xtent.widget.callback-name.Xt_OlAddCallback: ^(callback-code)
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
installing it under the named callback state.  Otherwise this function
behaves as \f(CWXtOlAddCallback\fP.

.iS XtOlAddCallbackWithArgs 0
xtent.widget.XtOlAddCallbackWithArgs: (^(callback-code),
                                       ...)
.iE
This function operates similarly to XtAddCallbackWithArgs, but installs the
callback using OpenLook's OlAddCallback() function, which is needed when 
.XI "callback"
adding callbacks to the XtNwmProtocol callback list.  See the 
XtAddCallbackWithArgs function for more about adding callbacks.
.P
The following code catches the WM_PROTOCOL message, OL_WM_DELETE_WINDOW,
generated when ``Quit'' is selected from the window menu:
.XI "menus"
.CW
  .wmProtocol.XtOlAddCallbackWithArgs: (.XtCheckOlQuit:, \\\\
            CallDataPtr, OlWMProtocolMsgType, ol_wm_value)

  .XtAddFunction: (CheckOlQuit, _CheckOlQuit)
  _CheckOlQuit: \\\\#
      .Xt_If: (^(ol_wm_value), ==, OL_WM_DELETE_WINDOW,
            .XtPrint: DELETE CALLED)
  #
.CN

.iS Xt_OlAddCallbackWithArgs 0
xtent.widget.callback-name.Xt_OlAddCallbackWithArgs: (^(callback-code),
                                                   ...)
.iE
In some instances applications wish to have evaluation without macro
.XI "macro expansion"
expansion.  This function does not macro expand the code body prior to
installing it under the named callback state.  Otherwise this function
behaves as \f(CWXtOlAddCallbackWithArgs\fP.

.iS XtOlMMToPixel 0
xtent.XtOlMMToPixel: (^(axis), ^(mm-value), ^(return-variable))
.iE
This function converts the specified value from millimeters to pixels
.XI "millimeters"
and returns the result as an integer in the resource database
variable.  The \f(CWaxis\fP argument determines the direction in which
the measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOlPointToPixel 0
xtent.XtOlPointToPixel: (^(axis), ^(point-value), 
                         ^(return-variable))
.iE
This function converts the specified value from points to pixels and
returns the result as an integer in the resource database variable.
The \f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOlPixelToMM 0
xtent.XtOlPixelToMM: (^(axis), ^(pixel-value), 
                             ^(return-variable))
.iE
This function converts the specified value from pixels to millimeters
.XI "millimeters"
.XI "pixel size"
and returns the result as an integer in the resource database
variable.  The \f(CWaxis\fP argument determines the direction in which
the measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOlPixelToPoint 0
xtent.XtOlPixelToPoint: (^(axis), ^(pixel-value), 
                         ^(return-variable))
.iE
This function converts the specified value from pixels to points and
.XI "pixel size"
returns the result as an integer in the resource database variable.
The \f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOl_MMToPixel 0
xtent.XtOl_MMToPixel: (^(axis), ^(mm-value), 
                              ^(return-variable))
.iE
This function converts the specified value from millimeters to pixels
.XI "pixel size"
.XI "millimeters"
and returns the result as a double in the resource database variable.
The \f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOl_PointToPixel 0
xtent.XtOl_PointToPixel: (^(axis), ^(point-value), 
                          ^(return-variable))
.iE
This function converts the specified value from points to pixels and
.XI "pixel size"
returns the result as a double in the resource database variable.  The
\f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOl_PixelToMM 0
xtent.XtOl_PixelToMM: (^(axis), ^(pixel-value), 
                              ^(return-variable))
.iE
This function converts the specified value from pixels to millimeters
.XI "pixel size"
.XI "millimeters"
and returns the result as a double in the resource database variable.
The \f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOl_PixelToPoint 0
xtent.XtOl_PixelToPoint: (^(axis), ^(pixel-value), 
                          ^(return-variable))
.iE
This function converts the specified value from pixels to points and
.XI "pixel size"
returns the result as a double in the resource database variable.  The
\f(CWaxis\fP argument determines the direction in which the
measurement is made: OL_HORIZONTAL or OL_VERTICAL.

.iS XtOlRegisterHelp 0
xtent.object.XtOlRegisterHelp: (^(id-type, ^(source), ^(source-type),
                                 ^(tag))
.iE
This function associates help text contained in the specified source
with an object.  When the pointer is positioned over the object and
the Help key is depressed, a help window pops up containing the text.
If source-type is OL_STRING_SOURCE, a simple string with embedded
newlines is expected.  If source-type is OL_DISK_SOURCE, a file name
is expected.  Id-type can be OL_WIDGET_HELP (used for all widgets and
gadgets), OL_CLASS_HELP, or OL_FLAT_HELP (used for individual flat
widget items).  The \f(CWtag\fP value is shown in the title of the help 
window as \fIapp-name:\fP \f(CWtag\fP Help.  If the \f(CWtag\fP value is 
\f(CWNULL\fP, only \fIapp-name:\fP Help is printed.
.P
The following code associates help text from a string with all caption
widgets. The help window will have the tag \f(CWCaption Widget\fP.
.CW
     xtent.caption.XtOlRegisterHelp: (OL_CLASS_HELP,\\\\
        The Caption composite widget provides a convenient \\\\
        way to label an arbitrary widget.,\\\\
        OL_STRING_SOURCE, Caption Widget)
.CN
The following code associates help text from a string with a flat
widget container. The help window will have the tag \f(CW, FlatExclusives\fP.
.CW
     xtent.excl.XtOlRegisterHelp: (OL_WIDGET_HELP,\\\\
         The FlatExclusives container widget allows \\\\
         a user to select one of a series of choices.,\\\\
         OL_STRING_SOURCE , FlatExclusives)
.CN
The following code associates help text from the file helptxt with the
third flat widget item in the flat widget container excl.  The help window
will have no tag.
.CW
     xtent.excl.3.XtOlRegisterHelp: (OL_FLAT_HELP,\\\\
          helptxt, OL_DISK_SOURCE, NULL)
.CN

.iS XtOlInitialize 0
xtent.XtOlInitialize:
.iE
This function forces the initialization of the OpenLook toolkit.  The toplevel
.XI "toplevel widget"
.XI "toolkit"
.XI "initialization"
widget is guaranteed to exist after this call.  The interpreter will
automatically initialize the toplevel widget so this function need not
be called in most applications.

.iS XtOlCallAcceptFocus 0
xtent.widget.XtOlCallAcceptFocus: ^(bool-return)
.iE
This function assigns focus to the named widget and returns
\f(CWTrue\fP if successful, \f(CWFalse\fP if not.

.iS XtOlGetCurrentFocusWidget 0
xtent.widget.XtOlGetCurrentFocusWidget: ^(focus-widget) 
.iE
This function returns the name of the widget that has focus.

.iS XtOlMoveFocus 0
xtent.widget.XtOlMoveFocus: (^(direction), ^(focus-widget))
.iE
This function moves the focus according to the specified direction
relative to the named widget, and returns the name of widget that
received focus.  The following table lists of legal values for
direction.
.TS
center box, tab(;);
cB s
cB cB.
Direction Argument for OlMoveFocus
=
Direction String;Movement
_
.T&
l l.

OL_IMMEDIATE;the next widget that will accept
OL_MOVERIGHT;right or wrap left
OL_MOVELEFT;left or wrap right
OL_MOVEUP;up or wrap to the bottom
OL_MOVEDOWN;down or wrap to the top
OL_MULTIRIGHT;(XtNmultiObjectCount) right
OL_MULTILEFT;(XtNmultiObjectCount) left
OL_MULTIUP;(XtNmultiObjectCount) up
OL_MULTIDOWN;(XtNmultiObjectCount) down
OL_NEXTFIELD;next after this widget
OL_PREVFIELD;previous before this widget

.TE
.ce 1
.TB "Direction Argument for OlMoveFocus"

.iS XtOlCanAcceptFocus 0
xtent.widget.XtOlCanAcceptFocus: ^(bool-return)
.iE
This function returns \f(CWTrue\fP if the widget can accept focus,
\f(CWFalse\fP if not.

.iS XtOlHasFocus 0
xtent.widget.XtOlHasFocus: ^(bool-return)
.iE
This function returns \f(CWTrue\fP if the widget has focus,
\f(CWFalse\fP if not.

.iS XtOlSetInputFocus 0
xtent.widget.XtOlSetInputFocus: 
.iE
This function assigns focus to the named widget.

.iS XtTextClearBuffer 0
xtent.widget.XtTextClearBuffer:
.iE
This function clears the Text widget's buffer.

.iS XtTextCopyBuffer 0
xtent.widget.XtTextCopyBuffer: ^(return-variable)
.iE
This function copies the contents of the Text widget's buffer to a
resource database variable.

.iS XtTextGetInsertPoint 0
xtent.widget.XtTextGetInsertPoint: ^(return-variable)
.iE
This function returns the Text widget's insertion position.

.iS XtTextGetLastPos 0
xtent.widget.XtTextGetLastPos: ^(return-variable)
.iE
This function returns the last character position in the Text widget's buffer.

.iS XtTextInsert 0
xtent.widget.XtTextInsert: ^(string)
.iE
This function inserts the string at the Text widget's current insertion 
position and advances the insertion position to the end of the string.

.iS XtTextReadSubString 0
xtent.widget.XtTextReadSubString: (^(start), ^(end), 
                                   ^(return-variable))
.iE
This function reads a substring from the Text widget's buffer beginning at 
the start value and ending at the end value and places it in the resource 
database variable.

.iS XtTextRedraw 0
xtent.widget.XtTextRedraw:
.iE
This function redraws the Text widget's buffer.

.iS XtTextReplace 0
xtent.widget.XtTextReplace: (^(start), ^(end), ^(string))
.iE
This function removes text in the Text widget's buffer from the start
position to the end position and inserts the string at the start
position.  If the start and end positions are the same, the action is
an insertion.  If no string is given, the action is a deletion.

.iS XtTextSetInsertPoint 0
xtent.widget.XtTextSetInsertPoint: ^(insert-point)
.iE
This function sets the Text widget's insertion point.

.iS XtTextUpdate 0
xtent.widget.XtTextUpdate: ^(bool-update)
.iE
This function sets the \f(CWupdateState\fP of a Text widget.
The argument should be either \f(CWTrue\fP or \f(CWFalse\fP.

.iS XtOlTextEditClearBuffer 0
xtent.widget.XtOlTextEditClearBuffer:
.iE
This function clears the TextEdit widget's buffer.

.iS XtOlTextEditCopyBuffer 0
xtent.widget.XtOlTextEditCopyBuffer: (^(return-variable), ^(success))
.iE
This function copies the contents of the TextEdit widget's buffer to a
resource database variable.  The \f(CWsuccess\fP variable is set to
\f(CWTrue\fP or \f(CWFalse\fP to indicate the state of the copy.

.iS XtOlTextEditCopySelection 0
xtent.widget.XtOlTextEditCopySelection: ^(bool-delete)
.iE
This function cuts the TextEdit widget's selection to the clipboard
.XI "clipboard"
and deletes it from the buffer if \f(CWbool-delete\fP is \f(CWTrue\fP.
If \f(CWbool-delete\fP is \f(CWFalse\fP, the selection is not deleted.

.iS XtOlTextEditGetCursorPosition 0
xtent.widget.XtOlTextEditGetCursorPosition: (^(start), ^(end), 
                                             ^(cursorPosition))
.iE
This function returns the start, end, and cursor position of the TextEdit
.XI "cursor"
widget's selection in the resource database variables.  If no selection 
exists, all values will equal cursor position.

.iS XtOlTextEditGetLastPosition 0
xtent.widget.XtOlTextEditGetLastPosition: ^(lastpos)
.iE
This function returns the position of the last character in the TextEdit
widget's buffer. 

.iS XtOlTextEditInsert 0
xtent.widget.XtOlTextEditInsert: (^(new-text), ^(position),
                                  ^(bool-return))
.iE
This function inserts the argument string at the specified position
in the TextEdit widget's buffer.

.iS XtOlTextEditPaste 0
xtent.widget.XtOlTextEditPaste:
.iE
This function pastes the TextEdit widget's clipboard selection at the 
.XI "clipboard"
current cursor position.

.iS XtOlTextEditReadSubString 0
xtent.widget.XtOlTextEditReadSubString: (^(return-variable), ^(start), 
                                         ^(end))
.iE
This function reads a substring from the TextEdit widget's buffer
beginning at the start value and ending 
at the end value and places it in the resource database variable.

.iS XtOlTextEditRedraw 0
xtent.widget.XtOlTextEditRedraw:
.iE
This function redraws the TextEdit widget's buffer.

.iS XtOlTextEditSetCursorPosition 0
xtent.widget.XtOlTextEditSetCursorPosition: (^(start), ^(end), 
                                             ^(cursorPosition))
.iE
This function sets the selection to begin at the start value and end at the
end value, and places the cursor at the named cursor position.  The cursor 
position must equal either the start value or the end value.

.iS XtOlTextEditUpdate 0
xtent.widget.XtOlTextEditUpdate: ^(bool-update)
.iE
This function sets the \f(CWupdateState\fP of a TextEdit widget.  The
argument should be either \f(CWTrue\fP or \f(CWFalse\fP.

.iS XtOlTextFieldCopyString 0
xtent.widget.XtOlTextFieldCopyString: ^(return-string)
.iE
This function copies the string associated with the TextField widget
into the resource database variable.

.iS XtOlTextFieldGetString 0
xtent.widget.XtOlTextFieldGetString: (^(return-string), ^(size))
.iE
This function returns the string associated with the TextField widget
and its size in the resource database variables.

.iS XtOlMenuPopup 0
xtent.widget.XtOlMenuPopup: ( ^(emanate), ^(item-index), ^(state), 
                              ^(set-position), ^(x), ^(y))
.iE
This function maps a menu. \f(CWEmanate\fP specifies
.XI "menus"
the object that the menu is currently associated with.  If NULL, the
menu's parent object is used as the emanate object.  If \f(CWemanate\fP
.XI "parent widget"
is a flattened widget, \f(CWitem-index\fP specifies the particular item.
.XI "flattened widgets"
\f(CWState\fP can be OL_PINNED_MENU, OL_PRESS_DRAG_MENU, or OL_STAYUP_MENU.
\f(CWSet-position\fP indicates whether the last two arguments are used
to help position the menu, and can have the values \f(CWTrue\fP or 
\f(CWFalse\fP.

.iS XtOlMenuPopdown 0
xtent.widget.XtOlMenuPopdown:
.iE
This function unmaps a MenuShell widget.

.iS XtOlMenuPost 0
xtent.widget.XtOlMenuPost:
.iE
This function maps a MenuShell widget.  It is equivalent to 
.CW
    .XtOlMenuPopup: ( NULL, NULL, OL_STAYUP_MENU, False, 0, 0)
.CN
.XI "popup"
.iS XtOlMenuUnpost 0
xtent.widget.XtOlMenuUnpost: ^(bool-dismiss-pinned)
.iE
This function unmaps a MenuShell widget.  If the menu is pinned, a 
.XI "menus"
value of \f(CWTrue\fP for the argument is required to dismiss it.  If the 
menu does not have a pushpin or the menu is not pinned, the argument is 
.XI "pushpin"
ignored.

.iS XtOlSLApplAddItem 0
xtent.widget.XtOlSLApplAddItem: ( ^(parent), ^(reference), 
                                  ^(label-type), ^(label), ^(glyph),
                                  ^(attr), ^(return-token) )
.iE
This function adds a new item to the ScrollingList widget and returns
the token in the resource database variable.  \f(CWParent\fP should be
set to 0 for compatibility with future changes.  The \f(CWreference\fP
variable identifies the item before which to insert the new item.
This value can be 0 to append the new item to the list.
\f(CWLabel-type\fP can be String or Image.  The \f(CWglyph\fP variable
.XI "images"
is currently unused.  \f(CWAttr\fP can be OL_LIST_ATTRIB_APPL or
OL_LIST_ATTRIB_CURRENT.
.P
The following code sets up a list of five items.
.CW
xtent.SL.XtOlSLApplAddItem:(0, 0, String, Vermont, 0, 0, a_token)
xtent.SL.XtOlSLApplAddItem:(0, 0, String, New Hampshire, 0, 0, b_token)
xtent.SL.XtOlSLApplAddItem:(0, 0, String, Maine, 0, 0, c_token)
xtent.SL.XtOlSLApplAddItem:(0, 0, String, Rhode Island, 0, 0, d_token)
xtent.SL.XtOlSLApplAddItem:(0, 0, String, Massachusetts, 0, 0, e_token)
.CN
.P
The following table is a good way to store the names so that they may
be accessed by the tokens that the scrolling list associates with the
items.
.CW
token_list.^(a_token): Vermont
token_list.^(b_token): New Hampshire
token_list.^(c_token): Maine
token_list.^(d_token): Rhode Island
token_list.^(e_token): Massachusetts
.CN

.iS XtOlSLApplDeleteItem 0
xtent.widget.XtOlSLApplDeleteItem: ^(token)
.iE
This function deletes the specified item from the ScrollingList
widget.

.iS XtOlSLApplEditClose 0
xtent.widget.XtOlSLApplEditClose:
.iE
This function closes the ScrollingList widget's editable text field.

.iS XtOlSLApplEditOpen 0
xtent.widget.XtOlSLApplEditOpen: ( ^(bool-position), ^(token) )
.iE
This functions opens the ScrollingList widget's TextEdit widget for editing.
If the boolean argument is \f(CWTrue\fP, items will be scrolled down
and a new item will be inserted after the token.  If \f(CWFalse\fP,
the token will be edited in place.

.iS XtOlSLApplTouchItem 0
xtent.widget.XtOlSLApplTouchItem: ^(token)
.iE
This function is called after an item in the ScrollingList widget is changed. 

.iS XtOlSLApplUpdateView 0
xtent.widget.XtOlSLApplUpdateView: ^(bool-update)
.iE
This function is called to keep the ScrollingList widget from updating 
the view (\f(CWFalse\fP) or let it again update the view (\f(CWTrue\fP).

.iS XtOlSLApplViewItem 0
xtent.widget.XtOlSLApplViewItem: ^(token)
.iE
This function moves the named item into view in the ScrollingList widget's
scrolled window.

.ne 26
.H 2 "OpenLook Drag and Drop Functions"
.XI "OpenLook drag and drop functions"
The following table contains the names of the OpenLook drag and drop
related functions that are currently implemented under xtent.  The
functions are described in the order in which they appear in this
table.  The descriptions are a simple transcription of the Sun man
page.  For a detailed description of these functions consult the Sun
OLIT programmer's reference manual.
.TS
center doublebox, tab(;);
l l.

XtOlGrabDragPointer;XtOlUngrabDragPointer;

XtOlDnDAllocTransientAtom;XtOlDnDBeginSelectionTransaction;
XtOlDnDChangeDropSitePreviewHints;XtOlDnDClearDragState;
XtOlDnDDeliverPreviewMessage;XtOlDnDDeliverTriggerMessage;
XtOlDnDDestroyDropSite;XtOlDnDDisownSelection;
XtOlDnDDragAndDrop;XtOlDnDDragNDropDone;
XtOlDnDEndSelectionTransaction;XtOlDnDErrorDuringSelectionTransaction;
XtOlDnDFreeTransientAtom;XtOlDnDGetCurrentSelectionsForWidget;
XtOlDnDGetDropSitesOfWidget;XtOlDnDGetDropSitesOfWindow;
XtOlDnDGetWidgetOfDropSite;XtOlDnDGetWindowOfDropSite;
XtOlDnDInitializeDragState;XtOlDnDOwnSelection;
XtOlDnDQueryDropSiteInfo;XtOlDnDRegisterWidgetDropSite;
XtOlDnDRegisterWindowDropSite;XtOlDnDSetDropSiteInterest;
XtOlDnDSetInterestInWidgetHier;XtOlDnDUpdateDropSiteGeometry;
XtOlDnDWidgetConfiguredInHier;;

.TE
.TB "OpenLook Drag and Drop Functions"

.iS XtOlGrabDragPointer 0
xtent.widget.XtOlGrabDragPointer: (^(cursor), ^(window-id))
.iE
This function actively grabs the mouse pointer.  The cursor is changed
to the specified cursor.  Movement is confined to the specified
window.  Specifying \f(CWNone\fP for the window id allows free
movement of the pointer.
.CW
  ^(%event.widget).XtOlDnDDragAndDrop: (drop-window, x, y, rinfo,
        ^(%event.widget).Xtanimate:, test),
  ...

  !!!
  !!! simple animate procedure
  !!!
  .XtAddThisFunction: (animate, animate)
  animate: .Xt_Eval: \\\\#
  (
    .Xt_If: (^(%drag-and-drop.eventcode), ==, ^(EnterNotify),
          ^(this).XtOlGrabDragPointer: (OlGetTargetCursor, None),
          ^(this).XtOlGrabDragPointer: (OlGetDuplicateCursor, None))
  )
#
.CN

.iS XtOlUngrabDragPointer 0
xtent.widget.XtOlUngrabDragPointer:
.iE
This function relinquishes control of the pointer.

.iS XtOlDnDAllocTransientAtom 0
xtent.widget.XtOlDnDAllocTransientAtom: ^(return-atom)
.iE
This function allocates a reusable ``transient'' atom suitable for use
in a drag and drop selection transaction upon this widget.

.iS XtOlDnDBeginSelectionTransaction 0
xtent.widget.XtOlDnDBeginSelectionTransaction: (^(atom),
                                                ^(callback-code))
.iE
This function is used in conjunction with
\f(CWXtOlDnDEndSelectionTransaction\fP to provide a positive handshake
indicating a selection transaction.  It invokes the selection holder's
transaction state callback (specified by the XtOlDnDOwnSelection and
XtOlDnDOwnSelectionIncremental functions) with a state parameter of
XtOlDnDTransactionBegins.  The widget is the requesting widget or the
drop site owner.  The atom is the selection atom passed in the trigger
notify procedure.

.iS XtOlDnDChangeDropSitePreviewHints 0
xtent.XtOlDnDChangeDropSitePreviewHints: (^(dropsite-id),
                                          ^(hints-flag))
.iE
This function allows an application to change the preview behavior
associated with a drop site.  This function updates a drop site's
preview hints.  During the lifetime of a drop site it may be necessary
to alter the nature of its previewing interest.  Use
XtOlDnDChangeSitePreviewHints to overwrite the existing preview hints
for a drop site and update the drop site interest list appropriately.
The \f(CWdropsiteid\fP is the id of the drop site and \f(CWhints-flag\fP
is the new preview flag settings for this site

.iS XtOlDnDClearDragState 0
xtent.widget.XtOlDnDClearDragState:
.iE
This function function must be called upon completion of the
previewing phase of a drag and drop gesture to clear internal state
within the drag and drop system.  The widget is the widget id of the
selection holder.

.iS XtOlDnDDeliverPreviewMessage 0
xtent.widget.XtOlDnDDeliverPreviewMessage: (^(root-window),
                                            ^(root-x),
                                            ^(root-y),
                                            ^(found-site))
.iE
This function tries to deliver Enter, Leave, and Motion events to the
drop sites found at the specified position on the specified window.
The \f(CWfound-site\fP will be set to \f(CWTrue\fP if sites can be
found at this position.
.P
The use of the name \f(CWroot\fP was a poor choice on Sun's part.
This is in fact the target (application) window.

.iS XtOlDnDDeliverTriggerMessage 0
xtent.widget.XtOlDnDDeliverTriggerMessage: (^(root-window),
                                            ^(root-x),
                                            ^(root-y),
                                            ^(selection),
                                            ^(operation),
                                            ^(found-site))

.iE
This function is called by the dragging client to deliver a trigger
message to a target drop site on the root window at the coordinates
specified.  The calling client is responsible for establishing a
timeout period.  If the drop target doesn't send selection conversion
requests during this period it should take appropriate action.
.P
\f(CWroot-x\fP is the root relative x coordinate of the point to which
a trigger message should be dispatched.  \f(CWroot-y\fP is the root
relative y coordinate of the point to which a trigger message should
be dispatched.  \f(CWselection\fP is the selection atom that the
requester should use to effect the selection transfer.
\f(CWoperation\fP is a trigger operation that copies or moves the
selected data.  \f(CWfound-site\fP is set to \f(CWTrue\fP if it finds
a drop site to dispatch a trigger message to at the specified (x,y).
Otherwise it is set to \f(CWFalse\fP.
.P
The use of the name \f(CWroot\fP was a poor choice on Sun's part.
This is in fact the target (application) window.

.iS XtOlDnDDestroyDropSite 0
xtent.XtOlDnDDestroyDropSite: (^(dropsite-id))
.iE
This function explicitly destroys a drop site.  Note that when a drop
site's widget or window is destroyed, all drop sites associated with
that widget or window are automatically destroyed.

.iS XtOlDnDDisownSelection 0
xtent.widget.XtOlDnDDisownSelection: (^(atom))
.iE
This function is identical in semantics to the Xt function
XtDisownSelection.

.iS XtOlDnDDragAndDrop 0
xtent.widget.XtOlDnDDragAndDrop: (^(return-window),
                                  ^(return-x),
                                  ^(return-y),
                                  ^(root-info-name),
                                  ^(preview-callback-code),
                                  ^(return-code-boolean))
.iE
This function provides a simple interface for processing the mouse and
keyboard events during a drop and drop operation. Before calling this
function, you should call OlGrabDragCursor or XGrabPointer to
effectively grab pointer events.  XtOlDnDDragAndDrop: issues an
XGrabKeyboard to obtain keystrokes during the drag operation.  It then
inserts a raw event handler on the widget specified for the pointer
and key events and initializes the drag and drop system with
OlDnDInitializeDragState.  Then it proceeds to process the event
stream, delivering preview messages where appropriate via
OlDnDDeliverPreviewMessage until the drag completes or is aborted.  The
function returns the x, y location and the window that the pointer was
in when the operation completed.  It also returns the necessary root
information.
.P
\f(CWwidget\fP is the selection holder.  \f(CWwindow\fP is the window
id containing the pointer.  \f(CWx\fP returns the x-location of the
pointer relative to the containing window.  \f(CWy\fP returns the
y-location of the pointer relative to the containing window.
\f(CWroot-info\fP is the name under which the root info will be
stored.
.CW
    ^(root-info-name).root-window
    ^(root-info-name).root-x
    ^(root-info-name).root-y
    ^(root-info-name).time
.CN
Preview callback code may be supplied.  The success or failure of the
call is returned under the named boolean.

.iS XtOlDnDDragNDropDone 0
xtent.widget.XtOlDnDDragNDropDone: (^(selection-atom),
                                    ^(callback-code))
.iE
This function is poorly documented in the Sun OLIT documentation.  It
may be related to XtOlDnDEndSelectionTransaction.

.iS XtOlDnDEndSelectionTransaction 0
xtent.widget.XtOlDnDEndSelectionTransaction: (^(selection-atom),
                                              ^(callback-code))
.iE
This function provides a positive handshake between the selection
requester and holder.  It invokes the selection holders transaction
state callback (registered with the \f(CWXtOlDnDOwnSelection\fP and
\f(CWOlDnDOwnSelectionIncremental\fP functions) with a state parameter
of \f(CWOIDnDSelectionTransactionEnds\fP.
.P
The widget is the owner of the dropsite.  \f(CWselection-atom\fP is
the selection atom.  The callback code is used to inform the requester
that the holder has successfully received the end notification.  When
it is invoked, the OlDnDTransactionState parameter takes the value
\f(CWOlDnDTransactionEnds\fP.

.iS XtOlDnDErrorDuringSelectionTransaction 0
xtent.widget.XtOlDnDErrorDuringSelectionTransaction: (^(selection-atom),
                                                      ^(callback-code))
.iE
This function can be called at any time during the selection transfer
by the requester to inform the selection holder that there is an
error.  The subsequent behavior of the holder is undefined by this
protocol.  The function invokes the selection holder's protocol state
callback (registered with XtOlDnDOwnSelection: or
XtOlDnDOwnSelectionIncremental:) with a protocol state parameter value
of \f(CWOlDnDSelectionTransactionError\fP.
.P
The specified widget is the drop site owner.  The selection atom is
the selection atom for the transaction.  The callback code is used to
inform the requester that the selection holder has successfully
received the error notification.  When it is invoked the
OlDnDTransactionState parameter takes the value OlDnDTransactionError.

.iS XtOlDnDFreeTransientAtom 0
xtent.widget.XtOlDnDFreeTransientAtom: ^(atom)
.iE
This function frees the transient atom specified for use by other drop
sites.

.iS XtOlDnDGetCurrentSelectionsForWidget 0
xtent.widget.XtOlDnDGetCurrentSelectionsForWidget: ^(resource-name)
.iE
This function returns a list of atoms currently held as drag and drop
selections for the specified widget.  If any are found they are stored
in the resource database using the format ^(resource-name).^(number).
The resource variable ^(resource-name).num-sites contains the number
of selections that were found.

.iS XtOlDnDGetDropSitesOfWidget 0
xtent.widget.XtOlDnDGetDropSitesOfWidget: ^(resource-name)
.iE
This function obtains the currently registered list of drop sites for
a particular widget instance.  If any are found they are stored
in the resource database using the format ^(resource-name).^(number).
The resource variable ^(resource-name).num-sites contains the number
of drop sites that were found.

.iS XtOlDnDGetDropSitesOfWindow 0
xtent.XtOlDnDGetDropSitesOfWindow: (^(window-number), ^(resource-name))
.iE
This function obtains the currently registered list of drop sites for
specified window.  If any are found they are stored in the resource
database using the format ^(resource-name).^(number).  The resource
variable ^(resource-name).num-sites contains the number of drop sites
that were found.

.iS XtOlDnDGetWidgetOfDropSite 0
xtent.XtOlDnDGetWidgetOfDropSite: (^(drop-site-number), ^(widget-return))
.iE
This function returns the name of the widget associated with the
specified drop site.  If the drop site cannot be found the string
\f(CWNone\fP is returned.

.iS XtOlDnDGetWindowOfDropSite 0
xtent.XtOlDnDGetWindowOfDropSite: (^(drop-site-number), ^(window-return))
.iE
This function returns the window (i.e. number) associated with the
specified drop site.  If the drop site cannot be found the string
\f(CWNone\fP is returned.

.iS XtOlDnDInitializeDragState 0
xtent.widget.XtOlDnDInitializeDragState: ^(return-value)
.iE
This function is called prior to commencing delivery of preview
messages to cause the drag and drop system to download drop site
previewing information from the DSDM.  The widget is the selection
holder.  It returns True if the download was successful.  Otherwise it
returns False.

.iS XtOlDnDOwnSelection 0
xtent.widget.XtOlDnDOwnSelection: (^(atom),
                                   ^(convert-callback-code),
                                   ^(lose-callback-code),
                                   ^(done-callback-code),
                                   (^(state-cb))
.iE
This function is identical in semantics to the Xt function
XtOwnSelection: except for the additional parameter \f(CWstate-cb\fP.
The callback is invoked with the following
\f(CWOlDnDTransactionState\fP values when the requester of the
selection (i.e the drop site) invokes the following functions:
.BL
.LI
OlDnDBeginSelectionTransaction() - OlDnDTransactionBegins
.LI
OlDnDEndSelectionTransaction() - OlDnDTransactionEnds
.LI
OlDnDDragNDropDone() - OlDnDTransactionDone
.LE
A requester may notify the selection holder of an error by calling the
XtOlDnDErrorDuringSelectionTransaction: function.  This invokes the
callback with a state value of \f(CWOlDnDRequestorError\fP.
.P
If the requesting client is lost during the selection transfer because
its window dies, the state callback will be invoked with a state value
of \f(CWOlDnDTransactionRequestorWindowDeath\fP.

.iS XtOlDnDQueryDropSiteInfo 0
xtent.XtOlDnDQueryDropSiteInfo: (^(drop-site-id),
                                 ^(widget-return),
                                 ^(window-return),
                                 ^(preview-hints-return),
                                 ^(rects-resource-name),
                                 ^(num-rects),
                                 ^(on-interest),
                                 ^(return-status))
.iE
This function retrieves information about a particular drop site.  The
function returns a status of True if the query was successful.  The
drop site id is the id of the drop site to be queried.  The widget and
window returns are the widget and window of the specified drop site.
The preview hints returns the current hints for the drop site.  The
rectangles are placed in the resource database using the format
^(rects-resource-name).^(number).  The total number of rectangles is
returned in the ^(num-rects) variable.

.iS XtOlDnDRegisterWidgetDropSite 0
xtent.widget.XtOlDnDRegisterWidgetDropSite: (^(preview-hints),
                                             ^(rect-resource-name),
                                             ^(rect-count),
                                             ^(tm-notify-cb-code),
                                             ^(on-interest),
                                             ^(return-drop-site-id))
.iE
This function creates a drop site associated with a particular widget.
A widget must be realized, that is it must have an X Window associated
with it, before you can create a drop site for it.  Gadgets can
support drop sites and use their windowed ancestor's X Window in
association with the registered drop site.  Drop sites are
automatically destroyed when their owning widgets die.
.P
The preview hints is an enum of type OlDnDSitePreviewHints that
defines the type(s) of preview events this drop site is interested in
receiving during a drag across it.  ^(rect-resource-name) is used as
the prefix to the rectangle list.  ^(rect-count) is the number of
rectangles in the list.
.CW
 !!!
 !!! add drop sites - add a couple in the corners
 !!!
 rect.0.x: 0
 rect.0.y: 0
 rect.0.width: 30
 rect.0.height: 30
 rect.1.x: 45
 rect.1.y: 45
 rect.1.width: 30
 rect.1.height: 30

 .form.drop_color.XtOlDnDRegisterWidgetDropSite: (\\\\#
         ^(OlDnDSitePreviewDefaultSite), rect, 2,
         .XtmyTriggerNotify:, .XtPrint: preview, True,
         dropsite-id)
 #

.CN

.iS XtOlDnDRegisterWindowDropSite 0
xtent.XtOlDnDRegisterWindowtDropSite: (^(window-number),
                                       ^(preview-hints),
                                       ^(rect-resource-name),
                                       ^(rect-count),
                                       ^(tm-notify-cb-code),
                                       ^(on-interest),
                                       ^(return-drop-site-id))
.iE
This function registers a window-based drop site.  It creates a drop
site associated with a particular X Window and is useful for toolkit
applications that mix `raw' X windows with widgets.  Drop sites are
automatically destroyed when their owning windows die.  The window must
be an inferior of a widgets window.  It behaves in all other respects
as its widget counterpart above.

.iS XtOlDnDSetDropSiteInterest 0
xtent.XtOlDnDSetDropSiteInterest: (^(drop-site-id), ^(interest))
.iE
This function sets the on interest flag for the specified drop site.
This has the effect of activating or de-activating the drop site.
Interrest should be True or False.

.iS XtOlDnDSetInterestInWidgetHier 0
xtent.widget.XtOlDnDSetInterestInWidgetHier: ^(interest)
.iE
This function activates or de-activates all drop sites belonging to
this widget and its children.

.iS XtOlDnDUpdateDropSiteGeometry 0
xtent.XtOlDnDUpdateDropSiteGeometry: (^(drop-site-id),
                                      ^(rect-resource-name),
                                      ^(rect-count))
.iE
This function alters the geometry of a drop site.  Changes in the
geometry of a drop site are caused by changes in the geometry of the
widget or window that owns the drop site.  To reduce client-server
traffic, the Drag and Drop implementation does not automatically track
changes in the window that owns a drop site.  The creator of a drop
site is responsible for maintaining the geometry of the site to
reflect any changes in the widget or window that owns the site.  See
XtOlDnDRegisterWidgetDropSite: for a description of how rectangles are
represented.

.iS XtOlDnDWidgetConfiguredInHier 0
xtent.widget.XtOlDnDWidgetConfiguredInHier:
.iE
This function is used by developers of composite widgets.  See the
OLIT manual for a complete discussion on its use.

.H 1 "Using the xtent Systems"
.XI "using xtent"
xtent can be used in three forms: as a stand alone specification
interpreter, as a subroutine package for specifying widgets, or as a
subroutine package for use as a protocol converter.  The most popular
.XI "protocol"
use is as a stand alone specification interpreter.  The interpreter is
commonly used in concert with other programs via the IPC mechanisms.
.XI "IPC"
.P
xtent is contained in a library and is designed so that it can be
easily used in C programs.  When used as a library xtent can be used
as a specification system for creating widgets or as an IPC protocol
.XI "protocol"
.XI "IPC"
handler.  When used as a specification system, applications use xtent
to handle the drudgery of manipulating widgets.  Once the widgets are
.XI "drudgery"
created, C functions may be used for callbacks and other application
specific processing.  xtent and C coexist well together.
.P
As a protocol handler, xtent may be added to existing applications so
.XI "protocol"
that the applications may be more easily reused.  In the next three
sections we will discuss how xtent is invoked when used in the above
mentioned three forms.
.H 2 "The xtent Interpreter"
.XI "running xtent"
The xtent libraries are used in a small driver program to produce a
stand alone interpreter.  The interpreter expects to read xtent
commands from a file.  If no file is provided, the file defaults to the
standard input, usually the user's tty.  The flag \f(CW-input\fP can
.XI "tty"
be used to specify the file.  The file may also be specified as
.br
.ne 12
the first argument to the command.  The three most common methods for
invoking xtent look like the following:
.CW
        $ xtent application.xt

        $ xtent -input application.xt

        $ xtent
.CN
The first two methods above will read a specification from the file
\f(CWapplication.xt\fP.  The last method is used for interactive use.
.P
If the interpreter is going to be used interactively, then it is
common to also include the following line in the input stream.
.CW
    xtent.XtAppAddInput: /dev/tty
.CN
This line allows the user to enter commands after
\f(CWXtAppMainLoop\fP is running.
.XI "tty"
.P
C based Xt programs usually call four Xt functions in this order:
\f(CWXtInitialize()\fP, \f(CWXtCreateManagedWidget()\fP,
\f(CWXtRealizeWidget()\fP, and \f(CWXtAppMainLoop()\fP.
\f(CWXtInitialize()\fP initializes the connection to the X server and
initializes the Xt environment.  \f(CWXtInitialize()\fP may be called
by the application in an xtent program, but usually xtent calls it
automatically without any application supplied intervention.
\f(CWXtCreateManagedWidget()\fP is the work horse for creating
widgets.  Most xtent code includes many calls to this function.
\f(CWXtRealizeWidget()\fP causes a created widget to be realized \(en
a window created for it and other X initialization.
.XI "initialization"
\f(CWXtAppMainLoop\fP is the main event dispatching loop used in Xt
.XI "loop"
.XI "main Xt event loop"
based programs.  \f(CWXtRealizeWidget\fP and \f(CWXtAppMainLoop\fP are
called automatically by the interpreter after the end of file has been
encountered on the input stream.  These functions may be called in
xtent application code, but they are usually omitted.  From this list
of four functions, one can see that the majority of work in xtent
scripts involves calls to \f(CWXtCreateManagedWidget\fP.  The other
required Xt calls are supplied automatically.

.H 2 "Mixing C and xtent Code"
.XI "mixing C and xtent code"
Some Xt functions expect a pointer to a C function to be given as one
of their arguments.  When using xtent, these functions may all be
passed xtent code in lieu of a function pointer.  xtent code may be
supplied wherever the X Toolkit normally expects a pointer to a
.XI "C pointers"
.XI "toolkit"
function.  This includes Callbacks, translation tables, timeouts,
workprocs, actions and events, as well as alternate input sources*.
.XI "workprocs"
.XI "communication"
.XI "IPC"
.FS *
xtent adds two new input sources, XIpc interprocess communication
(IPC) and shell escapes.  We discuss each of these cases in our
coverage of the builtin functions.  The IPC will get some special
attention in the next section.
.FE
If xtent is used as a library, then in all cases where Xt expects C
functions, C and xtent code may be freely intermixed.  The xtent
mechanisms follow the standard C function interface rules.  If an
application, for example, needs to use some xtent code for callbacks,
the application may also use C code for callbacks.  xtent also allows
applications to add C functions that can be called from xtent scripts,
see \f(CWXtAddCFunction:\fP.

.H 2 "The xtent C Interface for Widget Creation"
.XI "xtent C interface for widget creation"
Some applications must include some C source.  In this case, a C
program may be written to call xtent functions.  The following example
illustrates how xtent may be used to produce a stand alone interpreter
that reads commands from standard input.
.CW
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "xtent.h"

main (argc, argv)
unsigned int argc;
char **argv;
{
        XtAppContext context;
        Display *display;
        Widget toplevel;

        /*
         * initialize xtent
         */
        XtentInitialize (argv[0], "Xtent", NULL, 0,
                         &argc, argv, &display, &context);

        /*
         * read and install the xtent resource file
         */
        toplevel = (Widget) NULL;

        Xtent (display, &toplevel, stdin);

        if (toplevel)
        {
                XtRealizeWidget (toplevel);
                XtAppMainLoop (context);
        }
}
.CN
In the example above we use two xtent functions.  First we initialize
the connection to the X server and the xtent specific variables with
the call to \f(CWXtentInitialize()\fP.  We then call \f(CWXtent()\fP
to interpret commands from the input stream.  In this example we use
\f(CWstdin\fP to avoid opening a file.  If \f(CWxtent\fP has created
any widgets then \f(CWtoplevel\fP, the toplevel widget, will contain a
.XI "toplevel widget"
handle for a widget which is the top of the widget tree.  If widgets
have been created, the application should eventually call
\f(CWXtRealizeWidget()\fP and \f(CWXtAppMainLoop()\fP to initialize
and run the widgets.
.P
.ne 16
The following function descriptions are the C application interface
for utilizing the xtent library for widget specification/manipulation.

.iS XtentInitialize() 0
void
XtentInitialize (program_name, class_name,
                 options, option_count, argc, argv,
                 return_display, return_context)
char *program_name;
char *class_name;
XrmOptionDescRec *options;
int option_count;
int *argc;
char *argv[];
Display **return_display;
XtAppContext *return_context;
.iE
This function handles all of the xtent specific initializations.  This
function calls \f(CWXtToolkitInitialize()\f and creates the
application context.  This function also sets up xtent to catch the
common signals, for example those created by segmentation violations
and bus errors.  If the application developer wishes to use the
standard high level initializations which create a toplevel widget,
.XI "toplevel widget"
then the developer should use \f(CWXtentInitializeForXIpcHandler()\fP
mentioned below.  \f(CWXtentInitialize\fP returns a pointer to the
.XI "C pointers"
connected X display and a pointer to the newly created application
context.
.P
.iS "xtent() C function" 0
void
Xtent (display, toplevel_ptr, fp)
Display *display;
Widget *toplevel_ptr;
FILE *fp;
.iE
This function interprets specifications from a file.  The file is read
from the FILE pointer, \f(CWfp\fP.  Along with the display pointer
.XI "C pointers"
returned from \f(CWXtentInitialize()\fP, this function takes as an
argument a pointer to the toplevel widget.  If the application expects
.XI "toplevel widget"
the toplevel widget to be created by xtent, then the pointer should
point to a NULL widget.
.P
.iS XtentEvalString() 0
void
XtentEvalString (display, toplevel_ptr, buffer)
Display *display;
Widget *toplevel_ptr;
char *buffer;
.iE
This function interprets specifications from a NULL terminated string.
Along with the display pointer returned from
.XI "C pointers"
\f(CWXtentInitialize()\fP, this function takes as an argument a
pointer to the toplevel widget.  If the application expects the
.XI "toplevel widget"
toplevel widget to be created by xtent, then the pointer should point
to a NULL widget.
.P
.iS XtentNameToWidget() 0
Widget
XtentNameToWidget (widget_name)
char *widget_name;
.iE
This function returns a \f(CWWidget\fP from its string name.

.H 2 "xtent as an IPC Protocol"
.XI "xtent as an IPC protocol"
.XI "protocol"
.XI "IPC"
We have been working on schemes for connecting graphics processes for
some time now.  The technique that we like best involves a
client/server model quite like the model upon which X and NeWS[7] is
.XI "client/server"
based.  The reusable graphics processes are clients of a server that
coordinates their activity.  This client/server model seems to fit the
AT&T Bell Labs application development process well.
.P
We have constructed a small IPC[8] library that allows us to use this
.XI "IPC"
client/server model.  Messages are transported as arbitrary length,
.XI "client/server"
asynchronous, datagrams.  We have used a number of ad hoc protocols
.XI "datagrams"
that sit above the basic message passing software level.  The scheme
that seems to work best is to send xtent code.
.P
xtent code has a number of benefits over fixed protocol techniques.
.XI "protocol"
First of all, it requires no architecture specific mechanisms for
interpreting the protocol.  Most other schemes we have used required
byte order hacking techniques to handle multiple architectures.  Next,
xtent is Xt complete.  We know that when we use xtent as the protocol
converter, anything that can be specified in an application can also
be specified remotely.  Last of all, xtent allows us to download
.XI "download"
complete functions into an application, thus reducing the amount of
interaction that is required between elements of a system.
.P
xtent may be used as the IPC protocol for an existing Xt based
.XI "protocol"
.XI "IPC"
application.  To do this, the application developer has to add two
lines of C to the application:
.CW
    XtentInitializeForXIpcHandler (argc, argv);
    XtAddXIpc (toplevel_ptr, ipc_name, XtentHandleIpcToClient);
.CN
The initialization line installs the xtent type converters and the
.XI "initialization"
\f(CWXtAddXIpc()\fP installs the IPC input and output sources.  The
.XI "IPC"
function \f(CWXtentHandleIpcToClient()\fP is the xtent protocol
.XI "protocol"
converter.  See the XIpc memo for more details on the IPC mechanisms.
.P
In xtent specifications the IPC may be installed with the following
line:
.CW
    xtent.XtAddXIpc: ^(ipc_name)
.CN
Once the IPC has been installed in the application, the interprocess
.XI "IPC"
communication is handled automatically.  When messages come in, they
.XI "communication"
are read and processed without any intervention from the application.

.H 2 "The xtent C Interface for IPC Protocol Handling"
.XI "xtent C interface for IPC protocol handling"
.XI "protocol"
.XI "IPC"
These functions are used by applications that wish to use xtent as the
interprocess communication protocol.  See the XIpc document for more
.XI "communication"
detail.
.iS XtAddXIpc() 0
int
XtAddXIpc (toplevel, ipc_name, ipc_handler)
Widget toplevel;
char *ipc_name;
void (*ipc_handler) ();
.iE
This function sets up the interprocess communication system so that
.XI "communication"
incoming messages will be handled automatically from within the
context of the Xt dispatch loop, \f(CWXtAppMainLoop()\fP.
.XI "main Xt event loop"
\f(CWipc_name\fP is the token used to determine the machine and IPC
.XI "IPC"
connection.  \f(CWipc_handler\fP is the protocol handling function.
.XI "protocol"
For xtent based IPC, \f(CWipc_handler\fP should be
\f(CWXtentHandleIpcToClient\fP.
.P
.iS XtRemoveXIpc() 0
void
XtRemoveXIpc ()
.iE
This function tears down a previously installed IPC connection.
.XI "IPC"
.P
.iS XtentInitializeForXIpcHandler() 0
void
XtentInitializeForXIpcHandler (argc, argv)
int argc;
char *argv;
.iE
This function handles all of the xtent specific initialization that is
.XI "initialization"
required for doing IPC.  \f(CWargc\fP and \f(CWargv\fP are the
.XI "IPC"
argument count and argument list for the running process.  This
function should be used in applications that do not use
\f(CWXtent()\fP or \f(CWXtentEvalString()\fP functions.

.H 2 "The xtent C Interface for Adding C Based Builtins"
.XI "C based builtins"
Applications that use the xtent library commonly wish to add builtins
to the xtent evaluator, but do not wish to recompile the xtent library
itself.  This functions satisfies that requirement.

.iS XtentAddCFunction() 0
void
XtentAddCFunction (display, toplevel_ptr, name, function, args)
Display *display;
Widget *toplevel_ptr;
char *name;
void (*function) ();
char *args;
.iE
This function allows applications to add new C based builtin functions
to the xtent evaluator.  The display and widget variables are the same
as those used with the \f(CWXtent()\fP function.  The name string is
the name that will be associated with the new function.  The
\f(CWargs\fP string contains the list of formal parameters (arguments)
it would be used by the interpreter.  Parameters with names that start
with an underscore (i.e. ``_'') will not be macro expanded.  If the
last argument is \f(CW...\fP or \f(CW_...\fP the function will be
assumed to have a variable number of arguments.
.CW
    void
    print_list (args, count)
    Arg *args;
    int count;
    {
        int i;

        for (i = 0; i < count; i++)
            printf ("list print: (%s, %s)\n",
                    args[i].name, args[i].value);
    }

    ...

    XtentAddCFunction (display, &toplevel, "PrintList",
                       print_list, "a, _b, c, _...");
.CN
The example above adds the C function \f(CWprint_list()\fP to xtent as
the function \f(CWXtPrintList\fP.  The parameters \f(CWa\fP and
\f(CWc\fP are macro expanded on the call.  The parameter \f(CW_b\fP is
not macro expanded.  The function ends with a variable number of
unexpanded arguments.

.SK
.H 1 "References"
.XI "references"
.RL
.LI
Scheifler, Robert W. and Jim Gettys, ``The X Window System,'' ACM
Transactions on Graphics, vol. 5, no. 2, pp. 79-109, April, 1986.
.LI
McCormack, Joel and Paul Asente, ``Using the X Toolkit or How to Write
a Widget,'' in Proceedings of the Summer, 1988 USENIX Conference, pp.
1-13.
.LI
``AT&T OPEN LOOK\(tm Graphical User Interface, Specification Guide,
Release 1.0,'' May 1, 1989.
.LI
``OSF Motif Toolkit External Specifications, Revision 1.11,'' June 28,
1989.
.LI
Peterson, Chris D., ``The Athena Widget Set - C Language Interface,''
X Window System, X Version 11, Release 4.
.LI
``Programming With the HP X Widgets, Professional Programmer's
Release,'' April, 1988.
.LI
Schaufler, Robin, ``X11/NeWS Design Overview,'' in Proceedings of the
Summer, 1988 USENIX Conference, pp. 23-35.
.LI
Blewett, Doug and Margaret Kilduff, ``A Simple IPC for Talking to X
Widgets and Keeping Workstations Busy,''  Draft paper.
.LI
Blewett, D., Anderson, S., Kilduff, M., Udovic, S., Wish, M., ``X
Widget Based Software Tools for UNIX\(tm,'' in Proceedings of the
Winter, 1992 USENIX Conference, pp. 111-123.
.LI
Abelson, Harold and Gerald Jay Sussman with Julie Sussman, ``Structure
and Interpretation of Computer Programs,'' The MIT Press 1985.
.LI
Pearson, Peter, ``Fast Hashing of Variable Length Text Strings,''
Communications of the ACM 33, 6 (June 1990), 677-681.
.LE
.TC 1 1 0 1
