static char TMCreateTile_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

/*
 * this is copied from the HP widget set so that it can be used with 
 * OpenLook based applications.  Also added Grey256Pixmap() to generate
 * dithered pixmaps.
 */

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        CreateTile.c
 **
 **   Project:     X Widgets
 **
 **   Description: This file contains source for the tile creation
 **                routine used for patterned area fills, tiled
 **                text writes, etc...
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/


#include <stdio.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "CreateTile.h"

/*
 *  Function prototypes used in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern Pixmap
XwCreateTile C_P_ARGS((Screen * screen, Pixel foreground, Pixel background,
		       int tileType));

extern Pixmap
_XwCreateTile C_P_ARGS((Screen * screen, Pixel foreground,
			Pixel background, int tileType, int dither));

static Pixmap
Grey256Pixmap C_P_ARGS((Display *display, int blackToWhiteScaleValue,
			long foreground, long background));

C_PROTOS_END_EXTERN

/*  Tile types that can be created  */

static unsigned short bitmaps [9][16] =
{
   {  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 		/*  Solid Foreground  */
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
      0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF  },

   {  0x0000, 0x0000, 0x0000, 0x0000, 		/*  Solid Background  */
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000, 
      0x0000, 0x0000, 0x0000, 0x0000  },

   {  0x8888, 0x2222, 0x8888, 0x2222,		/*  25 percent  */
      0x8888, 0x2222, 0x8888, 0x2222,
      0x8888, 0x2222, 0x8888, 0x2222,
      0x8888, 0x2222, 0x8888, 0x2222  },

   {  0x5555, 0xAAAA, 0x5555, 0xAAAA,		/*  50 percent  */
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA,
      0x5555, 0xAAAA, 0x5555, 0xAAAA  },

   {  0x5555, 0xFFFF, 0xAAAA, 0xFFFF,		/*  75 percent  */
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF,
      0x5555, 0xFFFF, 0xAAAA, 0xFFFF  },

   {  0x5555, 0x5555, 0x5555, 0x5555,		/*  Vertical  */
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555,
      0x5555, 0x5555, 0x5555, 0x5555  },

   {  0xffff, 0x0000, 0xffff, 0x0000,		/*  Horizontal  */ 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000, 
      0xffff, 0x0000, 0xffff, 0x0000  },

   {  0xeeee, 0xdddd, 0xbbbb, 0x7777,		/*  Slant Left  */
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777, 
      0xeeee, 0xdddd, 0xbbbb, 0x7777  },

   {  0x7777, 0xbbbb, 0xdddd, 0xeeee, 		/*  Slant Right  */
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee, 
      0x7777, 0xbbbb, 0xdddd, 0xeeee  }
};


/*  Tile caching structure  */

typedef struct _PixmapCache
{
   Screen * screen;
   Pixel    foreground;
   Pixel    background;
   int      dither;
   int      tileType;
   Pixmap   pixmap;
   struct _PixmapCache * next;
} CacheEntry;

static CacheEntry * pixmapCache = NULL;



/************************************************************************
 *
 *  XwCreateTile
 *	Create a tile of screen depth, using the foreground and 
 *      background colors specified.  Use the type parameter to
 *      select the particular tile to create.  Ensure that multiple
 *      tiles of the same attributes are not created by caching the
 *      tiles.
 *
 ************************************************************************/

Pixmap
XwCreateTile (screen, foreground, background, tileType)
Screen * screen;
Pixel    foreground;
Pixel    background;
int      tileType;
{
    extern Pixmap _XwCreateTile ();

    return _XwCreateTile (screen, foreground, background, tileType, 0);
}

Pixmap
_XwCreateTile (screen, foreground, background, tileType, dither)
Screen * screen;
Pixel    foreground;
Pixel    background;
int      tileType;
int      dither;
{
   register Display * display = DisplayOfScreen(screen);
   CacheEntry * cachePtr;
   Pixmap       tile;

    /*  Check for a matching pixmap  */
    for (cachePtr = pixmapCache; cachePtr; cachePtr = cachePtr -> next)
	if (cachePtr -> screen == screen         && 
            cachePtr -> foreground == foreground &&
            cachePtr -> background == background &&
            cachePtr -> tileType == tileType     &&
            cachePtr -> dither == dither)
		return (cachePtr -> pixmap);

   if (tileType == XwDITHER)
       tile = Grey256Pixmap (display, dither, foreground, background);
   else
       tile = XCreatePixmapFromBitmapData (display, RootWindowOfScreen(screen),
					   (char *) bitmaps[tileType], 16, 16,
					   foreground, background,
					   DefaultDepthOfScreen (screen));

    /*  Insert it at the head of the cache  */
    cachePtr = XtNew (CacheEntry);
    cachePtr -> screen = screen;
    cachePtr -> foreground = foreground;
    cachePtr -> background = background;
    cachePtr -> tileType = tileType;
    cachePtr -> dither = dither;
    cachePtr -> pixmap = tile;
    cachePtr -> next = pixmapCache;
    pixmapCache = cachePtr;

    return (tile);
}

#define LINE_WIDTH	16
#define LINE_COUNT	16

static unsigned char halftone [][LINE_WIDTH] =
 {
	{  170,  42, 138,  10,
	   162,  34, 130,   2,
	   168,  40, 136,   8,
	   160,  32, 128,   0 },
	  
	{  106, 234,  74, 202,
	    98, 226,  66, 194,
	   104, 232,  72, 200,
	    96, 224,  64, 192 },
	  
	{  154,  26, 186,  58,
	   146,  18, 178,  50,
	   152,  24, 184,  56,
	   144,  16, 176,  48 },
	  
	{   90, 218, 122, 250,
	    82, 210, 114, 242,
	    88, 216, 120, 248,
	    80, 208, 112, 240 },
	  
	{  166,  38, 134,   6,
	   174,  46, 142,  14,
	   164,  36, 132,   4,
	   172,  44, 140,  12 },
	  
	{  102, 230,  70, 198,
	   110, 238,  78, 206,
	   100, 228,  68, 196,
	   108, 236,  76, 204 },
	  
	{  150,  22, 182,  54,
	   158,  30, 190,  62,
	   148,  20, 180,  52,
	   156,  28, 188,  60 },
	  
	{   86, 214, 118, 246,
	    94, 222, 126, 254,
	    84, 212, 116, 244,
	    92, 220, 124, 252 },
	  
	{  169,  41, 137,   9,
	   161,  33, 129,   1,
	   171,  43, 139,  11,
	   163,  35, 131,   3 },
	  
	{  105, 233,  73, 201,
	    97, 225,  65, 193,
	   107, 235,  75, 203,
	    99, 227,  67, 195 },
	  
	{  153,  25, 185,  57,
	   145,  17, 177,  49,
	   155,  27, 187,  59,
	   147,  19, 179,  51 },
	  
	{   89, 217, 121, 249,
	    81, 209, 113, 241,
	    91, 219, 123, 251,
	    83, 211, 115, 243 },
	  
	{  165,  37, 133,   5,
	   173,  45, 141,  13,
	   167,  39, 135,   7,
	   175,  47, 143,  15 },
	  
	{  101, 229,  69, 197,
	   109, 237,  77, 205,
	   103, 231,  71, 199,
	   111, 239,  79, 207 },
	  
	{  149,  21, 181,  53,
	   157,  29, 189,  61,
	   151,  23, 183,  55,
	   159,  31, 191,  63 },
	  
	{   85, 213, 117, 245,
	    93, 221, 125, 253,
	    87, 215, 119, 247,
	    95, 223, 127, 255 },
	  
 };

static Pixmap
Grey256Pixmap (display, blackToWhiteScaleValue, foreground, background)
Display *display;
int blackToWhiteScaleValue;
long foreground, background;
{
    register int i, j, k, byte;
    Screen *screen = DefaultScreenOfDisplay(display);
    unsigned char bitmap[LINE_WIDTH * LINE_COUNT / 8];
    int bitmap_index;

    /*
     * check the thresold
     */
    if (blackToWhiteScaleValue < 0)
	blackToWhiteScaleValue = 0;
    else if (blackToWhiteScaleValue > (LINE_WIDTH * LINE_COUNT))
	blackToWhiteScaleValue = (LINE_WIDTH * LINE_COUNT);
    
    blackToWhiteScaleValue = (LINE_WIDTH * LINE_COUNT) -
	blackToWhiteScaleValue;

    /*
     * loop for each scan line
     */
    bitmap_index = 0;
    for (i = 0; i < LINE_COUNT; i++)
    {
	for (j = 0, k = 0, byte = 0; j < LINE_WIDTH; j++)
	{
	    if ((((unsigned int) halftone[i][j]) + 1) <= blackToWhiteScaleValue)
		byte |= 1 << k;

	    if (k == 7)
	    {
		bitmap[bitmap_index] = byte;
		bitmap_index++;
		byte = 0;
		k = 0;
	    }
	    else
		k++;
	}
	if (k)
	{
	    bitmap[bitmap_index] = byte;
	    bitmap_index++;
	}
    }
    
    /*
     * create the pixmap
     */
    return XCreatePixmapFromBitmapData (display, RootWindowOfScreen(screen),
					(char *) bitmap, LINE_WIDTH, LINE_COUNT,
					foreground, background,
					DefaultDepthOfScreen (screen));
}
