static char TMExpandFile_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <ctype.h>

/*
 *  Function prototypes used in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern char *
ExpandFileName C_P_ARGS((char *string));

C_PROTOS_END_EXTERN

#define TRUE	1
#define FALSE	0

char *
ExpandFileName (string)
register char *string;
{
    static char *expand_buffer = (char *) NULL;
    static int expand_length = 0;
    int length = 0;
    register char *ptr;
    int use_shell = FALSE;

    /*
     * step through the string replacing $var, $(var), ${var), ~ and
     * look for * and [...] that require shell intervention.
     */
    ptr = expand_buffer;
    do
    {
	if (length + 1 >= expand_length)
	{
	    expand_length += 64;
	    expand_buffer = (char *) XtRealloc (expand_buffer, expand_length);
	    ptr = expand_buffer + length;
	}

	*ptr = *string++;
	switch (*ptr)
	{
	case '*':
	case '[':
	    use_shell = TRUE;
	    break;
	case '$':
	case '~':
	{
	    char *token;
	    char mark;
	    char *env_ptr;
	    int env_length;
	    int parens;

	    if (*ptr == '~')			/* ~ for $HOME */
	    {
		parens = FALSE;
		token = "HOME";
	    }					/* $(var) or ${var} */
	    else if (*string == '(' || *string == '{')
	    {
		parens = TRUE;
		if (*string == '(')
		    mark = ')';
		else if (*string == '{')
		    mark = '}';
		string++;
		token = string;
		while (*string && *string != mark)
		    string++;
	    }
	    else				/* $var */
	    {
		parens = FALSE;
		token = string;
		while (*string && isalnum (*string))
		    string++;
	    }
	    mark = *string;
	    *string = '\0';
	    env_ptr = (char *) getenv (token);
	    *string = mark;
	    if (parens)
		string++;
	    if (env_ptr)
	    {
		env_length = strlen (env_ptr);
		if (length + env_length >= expand_length)
		{
		    expand_length += (env_length + 64);
		    expand_buffer = (char *) XtRealloc (expand_buffer,
							expand_length);
		    ptr = expand_buffer + length;
		}
		strcpy (ptr, env_ptr);
		ptr += env_length;
		length += env_length;
	    }
	    continue;
	}
	case '\\':
	    if (*string)
	    {
		ptr++;
		length++;
		*ptr = *string++;
	    }
	    break;
	}

	ptr++;
	length++;

    } while (*string);
    *ptr = '\0';

    /*
     * this string requires shell intervention - file name wild carding
     */
    if (use_shell)
    {
	FILE *fp;
	int buf_length = length + BUFSIZ;
	char *buf = (char *) XtMalloc (buf_length);
	char drain[64];

	sprintf (buf, "echo %s | tr \" \" \"\n\"", expand_buffer);

	if ((fp = popen (buf, "r")) != NULL)
	{
	    fgets (buf, buf_length, fp);
	    while (fgets (drain, 64, fp) != NULL)
		;
	    pclose (fp);
	    if (*buf == '\0' || *buf == '\n')
	    {
		XtFree (buf);
	    }
	    else
	    {
		length = strlen (buf);
		if (buf[length - 1] == '\n')
		{
		    buf[length - 1] = '\0';
		    length--;
		}
		if (length < expand_length)
		{
		    strcpy (expand_buffer, buf);
		    XtFree (buf);
		}
		else
		{
		    XtFree (expand_buffer);
		    expand_buffer = buf;
		    expand_length = buf_length;
		}
	    }
	}
	else
	    XtFree (buf);
    }

    return expand_buffer;
}
/*
XtMalloc (ptr, length)
char *ptr;
int length;
{
    return malloc (length);
}

XtRealloc (ptr, length)
char *ptr;
int length;
{
    if (ptr == (char *) NULL)
	return malloc (length);

    return realloc (ptr, length);
}

XtFree (ptr)
char *ptr;
{
    if (ptr)
	free (ptr);
}

main (argc, argv)
int argc;
char *argv[];
{
    char *ptr = argv[1];

    printf ("epand[%s]=%s\n", ptr, ExpandFileName (ptr));
}
*/
