static char TMXtDragWidget_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/*
 *  Function prototypes used in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern XPoint *
XtDragWidget C_P_ARGS((Widget w, char *format, char *font,
		       int move_window, int use_setvalues, XPoint *point));

C_PROTOS_END_EXTERN

#ifndef TRUE
#define TRUE			True
#endif
#ifndef FALSE
#define FALSE			False
#endif

#define BORDER_WIDTH		2

XPoint *
XtDragWidget (w, format, font, move_window, use_setvalues, point)
Widget w;
char *format;
char *font;
int move_window;
int use_setvalues;
XPoint *point;
{
	Cursor current_cursor;
	int ignore;
	int x, y;			/* location of mouse */
	int last_x = -1;
	int last_y = -1;
	Window root_window, sub_window;
	XEvent event;
	Window window = XtWindow (w);
	Display *display = XtDisplay (w);
	int screen = DefaultScreen (display);
	Widget parent = XtParent (w);
	Window parent_window = XtWindow (parent);
	XtAppContext context = XtWidgetToApplicationContext (w);
	int button_released;
	int selection_button = -1;
	Arg args[2];

	XFontStruct *prompt_font;	/* application specified font */
	char *text;
	int text_len, text_width;
	XGCValues xgc;
	GC prompt_gc;
	Window prompt_window;		/* prompt window creation */
	int prompt_window_width, prompt_window_height;
	XSetWindowAttributes attr;

	/*
	 * get a pointing cursor
	 */
	current_cursor = XCreateFontCursor (display, XC_crosshair);

	/*
	 * allocate space for the prompt string, load the application
	 * specified font, and create the prompt window.
	 */
	if (format)
	{
		/* take a guess at the largest possible formatted string */
		text_len = strlen (format) + 256;
		text = (char *) XtMalloc (text_len);
		sprintf (text, format, 0, 0);
		text_len = strlen (text);

		/* load the font */
		prompt_font = XLoadQueryFont (display, font);
		if (prompt_font == NULL)
		{
			fprintf (stderr, "GetRect: cannot open font: %s\n",
				 font);
			return point;
		}

		/* pixels for GC and windows */
		xgc.foreground = WhitePixel (display, screen);
		xgc.background = BlackPixel (display, screen);
	
		/* create the window with a size that is close */
		prompt_window_width =
			XTextWidth (prompt_font, text, text_len) +
			2 * BORDER_WIDTH;
		prompt_window_height = prompt_font -> ascent +
			prompt_font -> descent + 2 * BORDER_WIDTH;

		prompt_window = XCreateSimpleWindow (display, parent_window,
						     0, 0,
						     prompt_window_width,
						     prompt_window_height,
						     BORDER_WIDTH,
						     xgc.foreground,
						     xgc.background);
		XMapWindow (display, prompt_window);

		/* create the GC for writing to the window */
		xgc.font = prompt_font -> fid;
		prompt_gc = XCreateGC (display, prompt_window,
				       GCForeground | GCBackground | GCFont,
				       &xgc);
	}
	else
		text = (char *) NULL;
	
	/* 
	 * spin loop waiting to grab the mouse
	 */
	for (;;)
	{
		if (XtGrabPointer (parent, FALSE,
				   ButtonPressMask | ButtonReleaseMask |
				   PointerMotionMask,
				   GrabModeAsync, GrabModeAsync,
				   parent_window, current_cursor,
				   CurrentTime) == GrabSuccess)
			break;
		sleep (1);
	}

	/*
	 * get an initial (x, y) position to start the loop
	 */
	XQueryPointer (display, parent_window, &root_window, &sub_window,
		       &ignore, &ignore,  &x, &y, (unsigned int *) &ignore);

	if (use_setvalues)
	{
		XtSetArg (args[0], XtNx, x);
		XtSetArg (args[1], XtNy, y);
		XtSetValues (w, args, 2);
	}
	else
		XtMoveWidget (w, x, y);

	if (format)
	{
		sprintf (text, format, x, y);
		text_len = strlen (text);
		text_width = XTextWidth (prompt_font, text, text_len) +
			2 * BORDER_WIDTH;
		if (text_width != prompt_window_width)
		{
			prompt_window_width = text_width;
			XResizeWindow (display, prompt_window,
				       prompt_window_width,
				       prompt_window_height);
		}
		XDrawImageString (display, prompt_window, prompt_gc,
				  BORDER_WIDTH,
				  BORDER_WIDTH + prompt_font -> ascent,
				  text, text_len);
		if (move_window)
			XMoveWindow (display, prompt_window, x, y);
	}

	last_x = x; last_y = y;

	button_released = FALSE;
	while (button_released == FALSE)
	{

		XtAppNextEvent (context, &event);

		switch (event.type)
		{
		case ButtonPress:
			x = ((XButtonEvent *) & event) -> x;
			y = ((XButtonEvent *) & event) -> y;
			selection_button = ((XButtonEvent *) & event) -> button;
			break;
			
		case ButtonRelease:
			if ((((XButtonEvent *) & event) -> button) !=
			    selection_button)
				break;
			x = ((XButtonEvent *) & event) -> x;
			y = ((XButtonEvent *) & event) -> y;
			button_released = TRUE;
			break;

		case MotionNotify:
			x = ((XMotionEvent *) & event) -> x;
			y = ((XMotionEvent *) & event) -> y;
			break;
			
		default:
			XtDispatchEvent (&event);
		}

		if (last_x != x || last_y != y)
		{
			if (use_setvalues)
			{
				XtSetArg (args[0], XtNx, x);
				XtSetArg (args[1], XtNy, y);
				XtSetValues (w, args, 2);
			}
			else
				XtMoveWidget (w, x, y);

			if (format)
			{
				sprintf (text, format, x, y);
				text_len = strlen (text);
				text_width = XTextWidth (prompt_font, text,
							 text_len) + 2 *
								 BORDER_WIDTH;
				if (text_width != prompt_window_width)
				{
					prompt_window_width = text_width;
					XResizeWindow (display, prompt_window,
						       prompt_window_width,
						       prompt_window_height);
				}
				XDrawImageString (display, prompt_window,
						  prompt_gc,
						  BORDER_WIDTH,
						  BORDER_WIDTH +
						  prompt_font -> ascent,
						  text, text_len);
				if (move_window)
					XMoveWindow (display, prompt_window,
						     x, y);
			}

			last_x = x; last_y = y;
		}
	}

	XtUngrabPointer (XtParent (w), CurrentTime);
	
	XFreeCursor (display, current_cursor);
	if (format)
	{
	    XDestroyWindow (display, prompt_window);
	    XFree (text);
	    XFreeGC (display, prompt_gc);
	}

	point -> x = x;
	point -> y = y;

	return point;
}
