/* static char TMxtent_h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#ifndef xtent_h
#define xtent_h

#include "C_P_args.h"
/*
 * all operations are prefixed by OP_PREFIX
 */
#define OP_PREFIX		   "Xt"
#define OP_PREFIXLENGTH		   (2)	/* strlen (OP_PREFIX) */

/*
 * The initial size of the resource read buffer - this is
 * allocated one per call to xtent().
 */
#define RBUFSIZ		(3 * 1024)

/*
 * The initial size of the argument array
 */
#define XTENTMAXARGS 64

/*
 * supported widgets
 */
typedef struct
{
	char *string;
	WidgetClass *class;
} XtentWidgetClassName;

extern XtentWidgetClassName XtentWidgetClassNames[];

/*
 * toplevel shell widgets (instances)
 */
typedef struct XtentShellRecord
{
    struct XtentShellRecord *next;
    Widget w;
    int length;
    char name[1];		/* arbitrary length */
} XtentShellRecord;

extern XtentShellRecord *XtentShells;

typedef struct XtentNamedResourceList
{
    struct XtentNamedResourceList *next;
    int count;
    XtResource **resources;
    char list_name[1];		/* arbitrary length */
} XtentNamedResourceList;

/*
 * resource names that are undefined else where
 */
#ifndef XtRChar
#define XtRChar "Char"
#endif
#ifndef XtRCardinal
#define XtRCardinal "Cardinal"
#endif
#ifndef XtRFloat
#define XtRFloat "Float"
#endif
#ifndef XtRImage
#define XtRImage "Image"
#endif

extern XrmQuark XtQBoolean;
extern XrmQuark XtQCardinal;
extern XrmQuark XtQColormap;
extern XrmQuark XtQCursor;
extern XrmQuark XtQDimension;
extern XrmQuark XtQFloat;
extern XrmQuark XtQImage;
extern XrmQuark XtQInt;
extern XrmQuark XtQPixel;
extern XrmQuark XtQPosition;
extern XrmQuark XtQShort;
extern XrmQuark XtQString;

C_PROTOS_BEGIN_EXTERN

/*
 * function prototypes in ExpandFileName.c
 */
extern char *
ExpandFileName C_P_ARGS((char *string));

/*
 * function prototypes in XGetPoints.c
 */
extern XRectangle *
XGetPoints C_P_ARGS((Display *display, int screen, Window window,
		     XSizeHints *hints, char *format, char *font,
		     Cursor application_cursor, int move_window, int type,
		     XRectangle *rect, Window *return_window));

/*
 * function prototypes in XtDragWidget.c
 */
extern XPoint *
XtDragWidget C_P_ARGS((Widget w, char *format, char *font,
		       int move_window, int use_setvalues, XPoint *point));

/*
 * function prototypes in xtent.c
 */
extern void
Xtent C_P_ARGS((Display * display, Widget * toplevel_ptr, FILE * fp));

extern void
XtentEvalString C_P_ARGS((Display * display, Widget * toplevel_ptr,
			  char * buffer));

extern int
XtentEvalResourceLine C_P_ARGS((Display * display, Widget * toplevel_ptr,
				char * buffer));

extern  void
XtentAddCFunction C_P_ARGS((Display *display, Widget *toplevel_ptr, char *name,
			    void (*function) (Arg *, int), char *args));

extern void
XtentXrmPutStringResource C_P_ARGS((XrmDatabase * db, char *buffer,
				    char *value, int field_count));

extern Widget
XtentToplevel C_P_ARGS((Display * display, Widget * toplevel_ptr));

extern Widget *
XtentSetToplevelPtr C_P_ARGS((Widget * set_toplevel_ptr));

extern Widget *
XtentToplevelPtr C_P_NO_ARGS();

extern Display *
XtentSetDisplay C_P_ARGS((Display * set_display));

extern Display *
XtentDisplay C_P_NO_ARGS();

extern void
XtentStoreArgcArgv C_P_ARGS((int set_argc, char **set_argv));

extern int
XtentSetLineCount C_P_ARGS((int set_count));

extern int
XtentLineCount C_P_NO_ARGS();

extern int
XtentSetMessageCount C_P_ARGS((int set_count));

extern int
XtentMessageCount C_P_NO_ARGS();

extern void
XtentIPCServerClientInputProc C_P_ARGS((XtPointer client_data, int *source,
					XtInputId *id));


/*
 * function prototypes in xtent_cvt.c
 */
extern XImage *
XtentReadImage C_P_ARGS((Display *display, char *filename,
			 C_Promoted_Char type, int new_colormap));

extern Pixmap
XtentReadPixmap C_P_ARGS((Display *display, char *filename,
			  C_Promoted_Char type, int new_colormap));

extern void
XtentAddConverters C_P_NO_ARGS();

extern int
XtentScaleImage C_P_ARGS((Display *display, char *in_name, int out_width,
			  int out_height, char *out_name));

extern void
XtentWriteImage C_P_ARGS((Display *display, char *image_name, char *filename,
			  C_Promoted_Char type, char *colormap_name));

extern void
XtentWritePixmap C_P_ARGS((Display *display, char *pixmap_name, char *filename,
			   C_Promoted_Char type, char *colormap_name));

extern void
XtentFreeImage C_P_ARGS((Display *display, char *image_name));

extern void
XtentFreePixmap C_P_ARGS((Display *display, char *pixmap_name));

extern Cursor
XtentCreateImageCursor C_P_ARGS((Display *display, char *image_name,
				 char *image_mask_name,
				 char *fg_color, char *bg_color,
				 char *x, char *y));

extern void
XtentFreeImageCursor C_P_ARGS((Display *display, char *image_name,
			       char *image_mask_name,
			       char *fg_color, char *bg_color,
			       char *x, char *y));

extern void
XtentCreateColormap C_P_ARGS((Display *display, char *colormap_name));

extern void
XtentFreeColormap C_P_ARGS((Display *display, char *colormap_name));

extern char *
XtentNextImageName C_P_NO_ARGS();

extern XImage *
XtentGetImage C_P_ARGS((Display *display, Window root, XRectangle *rect,
			int store_image, char *out_name));

extern long
XtentAllocColor C_P_ARGS((Display* display, char *color_map_name,
			  char *color_name));

extern void
XtentQueryPixel C_P_ARGS((Display *display, char *colormap_name, char *pixel,
			  XColor *color));

extern int
XtentFreeColor C_P_ARGS((Display* display, char *color_map_name,
			 char *color_name));

#ifdef OPENLOOK

#ifdef NEED_XrmCompileResourceList
extern void
XrmCompileResourceList C_P_ARGS((XtResourceList resources,
				Cardinal num_resources));
#endif

#endif /* OPENLOOK */


#ifdef MOTIF

extern char *
xtentXmCvtXmStringTableToString C_P_ARGS((long list, int list_count));

#endif /* MOTIF */

/*
 * function prototypes in xtent_data.c
 */
extern int
XtentConvertCtoResources C_P_ARGS((Widget w, XtPointer ptr,
				   XtentNamedResourceList * NamedResourceLists,
				   char *c_data_type_name,
				   char *base_resource_name));

/*
 * function prototypes in xtent_error.c
 */
extern void
XtentSetProgramName C_P_ARGS((char *program_name));

extern char *
XtentProgramName C_P_NO_ARGS();

extern int
XtentProgramNameLength C_P_NO_ARGS();

extern void
XtentErrorMessage C_P_ARGS((char *string));

extern void
XtentWarningMessage C_P_ARGS((char *string));

extern void
XtentErrorMsgHandler C_P_ARGS((String name, String type, String class,
			       String defaultp, String *params,
			       int *num_params));

extern void
XtentXErrorHandler C_P_ARGS((Display *display, XEvent *event));

/*
 * function prototypes in xtent_init.c
 */
extern void
XtentInitialize C_P_ARGS((char *program_name, char *class_name,
			  XrmOptionDescRec *options, int option_count,
			  int *argc, char **argv,
			  Display **display, XtAppContext *return_context));

extern void
XtentInitializeForXIpcHandler C_P_ARGS((int argc, char **argv));

/*
 * function prototypes in xtent_name.c
 */
extern char *
XtentWidgetToName C_P_ARGS((Widget w));

extern void
XtentCompileParseQuarks C_P_ARGS((char *string_zero, XrmQuark *quark_array,
				  XrmBinding *binding_array, int *count));

extern Widget
_xtentNameToWidget C_P_ARGS((Display * display, Widget * toplevel_ptr,
			     char *buffer, char *element, char *string_one,
			     XrmQuark *quarks, XrmBinding *bindings,
			     int count));

extern Widget
XtentNameToWidget C_P_ARGS((char *widget_name));

/*
 * function prototypes in xtent_popen.c
 */
extern FILE *
XtentEnvPOpen C_P_ARGS((char *cmd, char *mode));

extern int
XtentEnvPClose C_P_ARGS((FILE *ptr));

extern int
XtentEnvSystem C_P_ARGS((char *s));

/*
 * function prototypes in xtent_signal.c
 */
extern void
XtentSetSignals C_P_NO_ARGS();

extern void
XtentUnSetSignals C_P_NO_ARGS();

/*
 * function prototypes in xtent_tif.c
 */
extern XImage *
LoadTifImage C_P_ARGS((Display *display, int screen, char *fname, int new_map,
		       Colormap *colormap_return));

extern Pixmap
LoadTifPixmap C_P_ARGS((Display *display, int screen, char *fname,
			int new_map, Colormap *colormap_return,
			int *rwidth, int *rheight));

extern void
ImageToTifFile C_P_ARGS((Display *display, XImage *image,
			 Colormap colormap, char *filename));

C_PROTOS_END_EXTERN

#endif /* xtent_h */
