static char TMxtent_error_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include "xtent.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
XtentSetProgramName C_P_ARGS((char *program_name));

extern char *
XtentProgramName C_P_NO_ARGS();

extern int
XtentProgramNameLength C_P_NO_ARGS();

extern void
XtentErrorMessage C_P_ARGS((char *string));

extern void
XtentWarningMessage C_P_ARGS((char *string));

extern void
XtentErrorMsgHandler C_P_ARGS((String name, String type, String class,
			       String defaultp, String *params,
			       int *num_params));

extern void
XtentXErrorHandler C_P_ARGS((Display *display, XEvent *event));

C_PROTOS_END_EXTERN

static char *_XtentProgramName = (char *) "xtent";
static int   _XtentProgramNameLength = 5;

void
XtentSetProgramName (program_name)
char *program_name;
{
    char *slash = (char *) NULL;
    register char *ptr = program_name;

    while (*ptr)
    {
	if (*ptr == '/')
	    slash = ptr;
	ptr++;
    }
    if (slash && *(++slash))
	program_name = slash;

    _XtentProgramName = XtNewString (program_name);
    _XtentProgramNameLength = ptr - program_name;
}

char *
XtentProgramName ()
{
    return _XtentProgramName;
}

int
XtentProgramNameLength ()
{
    return _XtentProgramNameLength;
}

void
XtentErrorMessage (string)
char *string;
{
    fprintf (stderr, "%s: %s\n", XtentProgramName (), string);
    exit (1);
}

void
XtentWarningMessage (string)
char *string;
{
    fprintf (stderr, "%s: %s\n", XtentProgramName (), string);
}

/*
 * copied form XtErrorMessage code
 */
void
XtentErrorMsgHandler (name, type, class, defaultp, params, num_params)
String name;
String type;
String class;
String defaultp;
String *params;
int *num_params;
{
    char buffer[1024], message[1024];

    fprintf (stderr,
	     "%s: fatal error encountered at line %d, message %d.\n",
	     XtentProgramName (), XtentLineCount (), XtentMessageCount ());
	
    XtGetErrorDatabaseText (name, type, class, defaultp, buffer, 1024);
	
    if (params == NULL || num_params == NULL || *num_params == 0)
	XtError(buffer);
    else {
	int i = *num_params;
	String par[10];
	if (i > 10) i = 10;
	memcpy ((char*) par, (char*) params, i * sizeof (String));
	memset (&par[i], '\0', (10-i) * sizeof (String));
	sprintf (message, buffer, par[0], par[1], par[2], par[3],
		 par[4], par[5], par[6], par[7], par[8], par[9]);
	XtError (message);
	if (i != *num_params)
	    XtWarning ("some arguments in previous message were lost" );
    }

    exit (1);	
}

void
XtentXErrorHandler (display, event)
Display *display;
XEvent *event;
{
    fprintf (stderr,
	     "%s: fatal error encountered at line %d, message %d.\n",
	     XtentProgramName (), XtentLineCount (), XtentMessageCount ());

    _XDefaultError (display, event);
}
