static char TMxtent_init_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#define USE_XTDEFAULTAPPCONTEXT
#ifndef USE_XTDEFAULTAPPCONTEXT
#include "IntrinsicI.h"		/* from $x/mit/lib/Xt to fix process */
#endif
#include "xtent.h"

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
XtentInitialize C_P_ARGS((char *program_name, char *class_name,
			  XrmOptionDescRec *options, int option_count,
			  int *argc, char **argv,
			  Display **display, XtAppContext *return_context));

extern void
XtentInitializeForXIpcHandler C_P_ARGS((int argc, char **argv));

C_PROTOS_END_EXTERN

void
XtentInitialize (program_name, class_name, options, option_count, argc, argv,
		 display, return_context)
char *program_name;
char *class_name;
XrmOptionDescRec *options;
int option_count;
int *argc;
char **argv;
Display **display;
XtAppContext *return_context;
{
	XtAppContext context;

	/*
	 * store away argc and argv for use in resource files
	 */
	XtentStoreArgcArgv (*argc, argv);
	XtentSetProgramName (argv[0]); /* for reporting errors */

	/*
	 * catch signals and bail out - without generating a core file
	 */
	XtentSetSignals ();

	/*
	 * initialize the toolkit and the connection to the X server
	 */
	XtToolkitInitialize ();

	/*
	 * open the connection to the server and parse the arguments
	 */
#ifdef USE_XTDEFAULTAPPCONTEXT
	context = (XtAppContext) _XtDefaultAppContext();
#else
	context = XtCreateApplicationContext ();
	if (context -> process -> defaultAppContext == NULL)
		context -> process -> defaultAppContext = context;
#endif
	*return_context = context;
	*display = XtOpenDisplay (context, (String) NULL, NULL,
				  class_name, options, option_count,
				  argc, argv);
	if (*display == NULL)
		XtentErrorMessage ("Cannot open the display.");

	/*
	 * set the error handlers - use the default handler for I/O errors
	 */
	XtSetErrorMsgHandler ((XtErrorMsgHandler) XtentErrorMsgHandler);
	XSetErrorHandler ((XErrorHandler) XtentXErrorHandler);

#ifdef OPENLOOK
	/*
	 * The OL comment in this routine reads:
	 * This function fixes all the external references that were
	 * supposed to get resolved at compile time, but couldn't because
	 * of static shared library.
	 */
	OlPreInitialize (class_name, options, option_count, argc, argv);

	OlRegisterConverters ();
#endif /* OPENLOOK */

#ifdef HP_WIDGETS

	/*
	 * add the HP widget specific converters - so that the loader
	 * picks the one in our library
	 */
	XwRegisterConverters ();
#endif /* HP_WIDGETS */

	/*
	 * add the xtent specific converters
	 */
	XtentAddConverters ();

	/*
	 * store away argc and argv for use in resource files
	 */
	XtentStoreArgcArgv (*argc, argv);
	XtentSetProgramName (argv[0]); /* for reporting errors */
}

void
XtentInitializeForXIpcHandler (argc, argv)
int argc;
char **argv;
{
    /*
     * store away argc and argv for use in resource files
     */
    XtentStoreArgcArgv (argc, argv);
    XtentSetProgramName (argv[0]); /* for reporting errors */

    /*
     * add the xtent specific converters
     */
    XtentAddConverters ();
}
