#include <stdio.h>
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <signal.h>
#include <sys/time.h>		/* getrlimit() */
#include <sys/resource.h>
#include <stdlib.h>
#include <string.h>

/*
 * This file contains implementations of popen(), pclose(), and system()
 * that use the shell variable SHELL as the command name for the shell
 * to be invoked to handle the command.  This work was done by
 * John Mocenigo (john@research.att.com)
 */

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static int
xtent_sys_fullpath C_P_ARGS((char *name));

extern FILE *
XtentEnvPOpen C_P_ARGS((char *cmd, char *mode));

extern int
XtentEnvPClose C_P_ARGS((FILE *ptr));

extern int
XtentEnvSystem C_P_ARGS((char *s));

C_PROTOS_END_EXTERN

#define	testmode(mode,a,b)	(*(mode) == 'r'? (b) : (a))
#define	RDFROM	0
#define	WRTO	1

typedef void (*PFV)();

static	int *popen_pid;
static	int nfiles;

static int
xtent_sys_fullpath(name)
char	*name;
{
	register int	n;

	if(name[0] == '/')
		return 1;
	n = strlen(name);
	if(n <= 2)
		return 0;
	if(name[0] == '.' && name[1] == '/')
		return 1;
	if(name[0] == '.' && name[1] == '.' && name[2] == '/')
		return 1;
	return 0;
}

FILE *
XtentEnvPOpen(cmd,mode)
	char *cmd;
	char *mode;
{
	int pdesc[2];
	int *poptr;
	int this_side, that_side, pid;

	if (nfiles <= 0) {
#ifdef _NFILE
		nfiles = _NFILE;
#else
#ifdef RLIMIT_NOFILE
		struct rlimit rl;

		getrlimit(RLIMIT_NOFILE, &rl);
		nfiles = (int) rl.rlim_cur;
#else
		nfiles = getdtablesize ();
#endif
#endif /* _NFILE */
	}
	if (popen_pid == (int *)NULL) {
		popen_pid = (int *)malloc(nfiles * sizeof(int *));
		if (popen_pid == (int *)NULL)
			return ((FILE *)NULL);
		for (pid = 0; pid < nfiles; pid++)
			popen_pid[pid] = -1;
	}
	if (pipe(pdesc) < 0)
		return ((FILE *)NULL);
	this_side = testmode(mode,pdesc[WRTO], pdesc[RDFROM]);
	that_side = testmode(mode,pdesc[RDFROM], pdesc[WRTO]);
	if ((pid = fork()) == 0) {
		int	stdio;
		register int *p;
		char *SHELL, *basename;
		char buf[BUFSIZ];

		/* close all pipes from other popen's */
		for (p = popen_pid; p < popen_pid+nfiles; p++) {
			if(*p >= 0)
				(void) close(p - popen_pid);
		}
		stdio = testmode(mode, 0, 1);
		(void) close(this_side);
		if (that_side != stdio) {
			(void) dup2(that_side, stdio);
			(void) close(that_side);
		}
		if((SHELL = getenv("SHELL")) == (char *)NULL) {
			SHELL = "/bin/sh";
		} else if(!xtent_sys_fullpath(SHELL)) {
			char *path = getenv("PATH"), *cp, c;

			for(cp = path; ; cp++) {
				if(*cp == ':' || *cp == '\0') {
					if(*path != ':') {
						c = *cp;
						*cp = '\0';
						(void) sprintf(buf,"%s/%s",path,SHELL);
						if(access(buf,01) == 0) {
							*cp = ':';
							break;
						}
						*cp = c;
					}
					path = cp + 1;
				}
				if(*cp == '\0') {
					break;
				}
			}
			if(*cp == '\0') {
				exit(-2);
			}
			SHELL = buf;
		}
		basename = ((basename = strrchr(SHELL,'/')) == (char *)NULL) ? SHELL : ++basename;
		(void) execl(SHELL, basename, "-c", cmd, (char *)NULL);
		_exit(127);
	}
	if (pid == -1) {
		close(this_side);
		close(that_side);
		return ((FILE *)NULL);
	}
	popen_pid[this_side] = pid;
	close(that_side);
	return (fdopen(this_side, mode));
}

int
XtentEnvPClose(ptr)
	FILE *ptr;
{
	int child = -1;
	int pid, status, save_sigmask;

	if (popen_pid != (int *)NULL) {
		child = popen_pid[fileno(ptr)];
		popen_pid[fileno(ptr)] = -1;
	}
	(void) fclose(ptr);
	if (child == -1)
		return (-1);
/*
	save_sigmask = sigblock (sigmask(SIGINT) | sigmask(SIGQUIT) |
				 sigmask(SIGHUP));
*/
	while ((pid = (int)wait(&status)) != child && pid != -1)
		;
/*
	(void) sigsetmask(save_sigmask);
*/
	return (pid == -1 ? -1 : status);
}

int
XtentEnvSystem(s)
char	*s;
{
	int	status;
	int	pid, w;
	char *SHELL, *basename;
	PFV prev_int, prev_quit;
	char buf[BUFSIZ];

	if((SHELL = getenv("SHELL")) == (char *)NULL) {
		SHELL = "/bin/sh";
	} else if(!xtent_sys_fullpath(SHELL)) {
		char *path = getenv("PATH"), *cp, c;

		for(cp = path; ; cp++) {
			if(*cp == ':' || *cp == '\0') {
				if(*path != ':') {
					c = *cp;
					*cp = '\0';
					(void) sprintf(buf,"%s/%s",path,SHELL);
					if(access(buf,01) == 0) {
						*cp = ':';
						break;
					}
					*cp = c;
				}
				path = cp + 1;
			}
			if(*cp == '\0') {
				break;
			}
		}
		if(*cp == '\0') {
			return(-1);
		}
	 	SHELL = buf;
	}
	basename = ((basename = strrchr(SHELL,'/')) == (char *)NULL) ? SHELL : ++basename;
	
	if ((pid = (int)fork()) == 0) {
		(void) execl(SHELL, basename, "-c", s, (char *)0);
		_exit(127);
	}
	if (pid == -1) {
		return (-1);
	}
	prev_int = signal(SIGINT, SIG_IGN);
	prev_quit = signal(SIGQUIT, SIG_IGN);
	w = (int)waitpid(pid, &status, 0);
	(void) signal(SIGINT, prev_int);
	(void) signal(SIGQUIT, prev_quit);
	return ((w == -1) ? -1: ((status & 0377) >> 8));
}
