/* static char TMxtent_xipc_h[] = "<%W%	%D% %T%>"; */
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */


#ifndef xtent_xipc_h
#define xtent_xipc_h

typedef struct IPCServerDescriptor
{
    XIpcServer *server;
    XtInputId read_id;
    char *message_handler_code;
    char name[1];		/* arbitrary length */
} IPCServerDescriptor;

typedef struct IPCClientDescriptor
{
    XIpcClient *client;
    char *message_handler_code;
    char name[1];		/* arbitrary length */
} IPCClientDescriptor;

typedef struct IPCClientData
{
    XtInputId read_id;
    XtInputId write_id;
    char using_write_id;
    char *client_cleanup_code;
} IPCClientData;

/*
 * function prototypes in this file
 */
#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

extern void
XtentHandleIpcToClient C_P_ARGS((XtPointer pointer));

extern void
XtentSendMessage C_P_ARGS((int type, unsigned char *buffer));

extern void
XtentIPCServerInputProc C_P_ARGS((XtPointer client_data_ptr, int *source, XtInputId *id));

extern void
XtentIPCClientCleanup C_P_ARGS((XIpcClient *client));

extern void
XtentIPCCloseServer C_P_ARGS((XIpcServer *server));

extern void
XtentIPCServerCloseClient C_P_ARGS((XIpcServer *server, int i));

C_PROTOS_END_EXTERN

#endif /* xtent_xipc_h */
