static char TMxtent_main_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include "xtent.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static void
Syntax C_P_ARGS((char *prog));

static void
print_list C_P_ARGS((Arg *args, int count));

extern void
main C_P_ARGS((int argc, char **argv));

C_PROTOS_END_EXTERN

static void
Syntax (prog)
char *prog;
{
    fprintf (stderr, "%s: usage\n", prog);
    fprintf (stderr, "\t%s\n", prog);
    fprintf (stderr, "or\n");
    fprintf (stderr, "\t%s <resource file>\n", prog);
    fprintf (stderr, "or\n");
    fprintf (stderr, "\t%s -input <resource file>\n", prog);
    fprintf (stderr, "or\n");
    fprintf (stderr, "\t%s -class <class name>\n", prog);
    fprintf (stderr, "or\n");
    fprintf (stderr, "\t%s (some combination of the above)>\n", prog);
    exit (1);
}

/*
 * code for adding a C function as an xtent builtin
 *
 *    XtentAddCFunction (display, &toplevel, "PrintList",
 *		       print_list, "a, _b, c, _...");
 *
 * static void
 * print_list (args, count)
 * Arg *args;
 * int count;
 * {
 *     int i;
 * 
 *     for (i = 0; i < count; i++)
 * 	printf ("list print: (%s, %s)\n", args[i].name, args[i].value);
 * }
 */

void
main (argc, argv)
int argc;
char **argv;
{
    char *name_buf;
    XrmString value_type;
    XrmValue value_return;
    char *inputfile;
    FILE *fp;
    XtAppContext context;
    Display *display;	   /* X variable for Xtent() */
    Widget toplevel =  (Widget) NULL;

    static XrmOptionDescRec options[] =
    {
	{
		"-input", "xtentInputfile", XrmoptionSepArg, NULL
	},
    };
    int i, j;
    char *thisClass;
    
    /*
     * initialize xtent - argv[0] determines the line prefix
     */
    argv[0] = "xtent";
    thisClass = "Xtent";
    for (i = 1; i < argc; i++)
    {
	if (strcmp (argv[i], "-class") == 0)
	{
	    if (i + 1 == argc)
		Syntax (argv[0]);
	    thisClass = argv[i + 1];
	    for (j = i + 2; j < argc; i++, j++)
		argv[i] = argv[j];
	    argc -= 2;
	    break;
	}
    }
    XtentInitialize (argv[0], thisClass, options, XtNumber (options),
		     (int *) &argc, argv, &display, &context);
    
    /*
     * unset ENV to avoid problems with ksh init files
     */
    {
	char buf[32];

	strcpy (buf, ".XtUnsetShellVariables: (ENV)");
	XtentEvalString (display, &toplevel, buf);
    }

    /*
     * get the input FILE *fp
     */
    inputfile = (char *) NULL;
    name_buf = (char *) XtMalloc (strlen (argv[0]) + 1 + 15);
    sprintf (name_buf, "%s.%s", argv[0], "xtentInputfile");
    if (XrmGetResource (XtDatabase (display),
			name_buf, "Inputfile",
			&value_type, &value_return))
	inputfile = value_return.addr;
    else if (argc > 1)
	inputfile = argv[1];
    else if (argc != 1)
	Syntax (argv[0]);
    
    if (inputfile)
    {
	if (inputfile[0] == '-' && inputfile[1] == '\0')
	    fp = stdin;
	else
	{
	    if ((fp = fopen (ExpandFileName (inputfile), "r")) == NULL)
	    {
		fprintf (stderr, "%s: Cannot open resource file: %s\n",
			 argv[0], inputfile);
		Syntax (argv[0]);
	    }
	}
    }
    else
	fp = stdin;
    
    /*
     * read and install the resource file
     */
    Xtent (display, &toplevel, fp);
    
    if (fp != stdin)
	fclose (fp);
    
    if (toplevel)
    {
	XtRealizeWidget (toplevel);
	XtAppMainLoop (context);
    }
}
