static char TMxtent_o_main_c[] = "<%W%	%D% %T%>";
/*
 * 			Copyright 1993, 1994 by AT&T
 * 
 * 			 All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of AT&T not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * AT&T DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * AT&T BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 * AT&T's dontation of this software does not imply a licence granted for
 * patents nor transfer of ownership of any patents which may inadvertently
 * be implemented in this code.
 * 
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include "xtent.h"

#include "C_P_args.h"

C_PROTOS_BEGIN_EXTERN

static void
Syntax C_P_ARGS((char *prog));

extern void
main C_P_ARGS((int argc, char **argv));

C_PROTOS_END_EXTERN

static void
Syntax (prog)
char *prog;
{
    fprintf (stderr,
     "%s: usage\n  %s <resource file>\nor\n  %s -input <resource file>\n",
	     prog, prog, prog);
    exit (1);
}

void
main (argc, argv)
int    argc;
char  **argv;
{
    static char name_buf[512];	/* file name retrieval variables */
    XrmString value_type;
    XrmValue value_return;
    char *inputfile;
    FILE *fp;
    XtAppContext context;
    Display *display;		/* X variable for Xtent() */
    Widget toplevel;
    static XrmOptionDescRec options[] =
    {
    {
	"-input", "xtentInputfile", XrmoptionSepArg, NULL
	},
    };

    /*
     * initialize xtent - argv[0] determines the line prefix
     */
    argv[0] = "xtent";
    XtentInitialize (argv[0], "Xtent", options, XtNumber (options),
		     (int *) &argc, argv, &display, &context);

    /*
     * get the input FILE *fp
     */
    inputfile = (char *) NULL;
    sprintf (name_buf, "%s.%s", argv[0], "xtentInputfile");
    if (XrmGetResource (XtDatabase (display),
			name_buf, "Inputfile",
			&value_type, &value_return))
	inputfile = value_return.addr;
    else if (argc > 1)
	inputfile = argv[1];
    else if (argc != 1)
	Syntax (argv[0]);

    if (inputfile)
    {
	if (inputfile[0] == '-' && inputfile[1] == '\0')
	    fp = stdin;
	else
	{
	    if ((fp = fopen (ExpandFileName (inputfile), "r"))
		== NULL)
	    {
		fprintf (stderr,
			 "%s: Cannot open resource file: %s\n",
			 argv[0], inputfile);
		Syntax (argv[0]);
	    }
	}
    }
    else
	fp = stdin;

    /*
     * read and install the resource file
     */
    toplevel = (Widget) NULL;

    Xtent (display, &toplevel, fp);

    if (fp != stdin)
	fclose (fp);

    if (toplevel)
    {
	XtRealizeWidget (toplevel);
	XtAppMainLoop (context);
    }
}
