#include <stdio.h>
#include <math.h>

#define XD(value)	(0.05 + (value / width * 0.9))
#define YD(value)	(0.05 + (value / height * 0.9))

#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif

typedef struct link_str
{
    struct link_str *next;
    double x, y;
    char name[1];
} link_str;

static char *
XtMalloc (length)
int length;
{
    char *ptr = (char *) malloc (length);

    if (ptr == (char *) NULL)
    {
	fprintf (stderr, "Cannot allocate memory for nodes and links.\n");
	exit (1);
    }
    return ptr;
}

main (argc, argv)
int argc;
char **argv;
{
    char *graph_name;
    char buffer[BUFSIZ];
    char *ptr;
    double scale_factor = 1.0;
    double width = 1.0;
    double height = 1.0;
    int link_count = 0;
    int i;
    link_str *nodes = (link_str *) NULL;
    link_str *node_ptr;
    link_str *links = (link_str *) NULL;
    link_str *link_ptr;

    if (argc < 2)
	graph_name = "dot";
    else
	graph_name = argv[1];

    while (fgets (buffer, BUFSIZ, stdin) != NULL)
    {
	if (strncmp (buffer, "graph ", 6) == 0)
	{
	    ptr = buffer + 6;
	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    scale_factor = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    width = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    height = atof (ptr);

	    printf ("\n!!! %s\n", graph_name);
	    printf ("%s.scale-factor: %.4f\n", graph_name, scale_factor);
	    printf ("%s.width: %.4f\n", graph_name, width);
	    printf ("%s.height: %.4f\n", graph_name, height);
	}
	else if (strncmp (buffer, "node ", 5) == 0)
	{
	    char *name;
	    double x, y, xsize, ysize;
	    char *label_text;

	    ptr = buffer + 5;
	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    if (*ptr == '"')
	    {
		ptr++;
		name = ptr;
		while (*ptr != '"')
		{
		    if (*ptr == ' ' || *ptr == '\t' ||
			*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';
		    ptr++;
		}
		i = -1;
		while (ptr[i] == '-')
		{
		    ptr[i] = '\0';
		    i--;
		}
	    }
	    else
	    {
		name = ptr;
		while (*ptr != ' ' && *ptr != '\t')
		{
		    if (*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';

		    ptr++;
		}
	    }
	    *ptr++ = '\0';

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    x = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    y = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    xsize = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    ysize = atof (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    if (*ptr == '"')
	    {
		ptr++;
		label_text = ptr;
		while (*ptr != '"')
		    ptr++;
		i = -1;
		while (ptr[i] == ' ' || ptr[i] == '\t')
		{
		    ptr[i] = '\0';
		    i--;
		}
	    }
	    else
	    {
		label_text = ptr;
		while (*ptr != ' ' && *ptr != '\t' && *ptr != '\n')
		    ptr++;
	    }
	    *ptr++ = '\0';

	    node_ptr = (link_str *) XtMalloc (sizeof (link_str) +
					      strlen (name));
	    strcpy (node_ptr -> name, name);
	    node_ptr -> x = XD (x);
	    node_ptr -> y = YD (y);
	    node_ptr -> next = nodes;
	    nodes = node_ptr;

	    printf ("\n!!! %s.node.%s\n", graph_name, name);
	    printf ("%s.node.%s.x: %.4f\n", graph_name, name, node_ptr -> x);
	    printf ("%s.node.%s.y: %.4f\n", graph_name, name, node_ptr -> y);
	    printf ("%s.node.%s.symbolLabel: %s.node.%s.label\n",
		    graph_name, name, graph_name, name);
	    printf ("%s.node.%s.label.name: %s\n", graph_name, name,
		    label_text);
	}
	else if (strncmp (buffer, "edge ", 5) == 0)
	{
	    char *tail_name;
	    char *head_name;
	    int found_tail, found_head;
	    int n;
	    double x;
	    double y;
	    double tail_x, tail_y;
	    double head_x, head_y;

	    ptr = buffer + 5;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    if (*ptr == '"')
	    {
		ptr++;
		tail_name = ptr;
		while (*ptr != '"')
		{
		    if (*ptr == ' ' || *ptr == '\t' ||
			*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';
		    ptr++;
		}
		i = -1;
		while (ptr[i] == '-')
		{
		    ptr[i] = '\0';
		    i--;
		}
	    }
	    else
	    {
		tail_name = ptr;
		while (*ptr != ' ' && *ptr != '\t')
		{
		    if (*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';
		    ptr++;
		}
	    }
	    *ptr++ = '\0';

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    if (*ptr == '"')
	    {
		ptr++;
		head_name = ptr;
		while (*ptr != '"')
		{
		    if (*ptr == ' ' || *ptr == '\t' ||
			*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';
		    ptr++;
		}
		i = -1;
		while (ptr[i] == '-')
		{
		    ptr[i] = '\0';
		    i--;
		}
	    }
	    else
	    {
		head_name = ptr;
		while (*ptr != ' ' && *ptr != '\t')
		{
		    if (*ptr == '.' ||  *ptr == '*' || *ptr == ':')
			*ptr = '-';
		    ptr++;
		}
	    }
	    *ptr++ = '\0';

	    printf ("\n!!! %s.link.%d\n", graph_name, link_count);
	    printf ("%s.link.%d.A: %s.node.%s\n", graph_name, link_count,
		    graph_name, tail_name);
	    printf ("%s.link.%d.B: %s.node.%s\n", graph_name, link_count,
		    graph_name, head_name);

	    link_ptr = (link_str *) XtMalloc (sizeof (link_str) + 32);
	    sprintf (link_ptr -> name, "%d", link_count);
	    link_ptr -> next = links;
	    links = link_ptr;

	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;
	    n = atoi (ptr);
	    while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		ptr++;
	    if (n < 2)
	    {
		link_count++;
		continue;
	    }

	    printf ("%s.link.%d.line: %s.link.%d.line\n",
		    graph_name, link_count, graph_name, link_count);
	    printf ("%s.link.%d.line.splinePoints: ", graph_name, link_count);

	    node_ptr = nodes;
	    found_tail = found_head = False;
	    while (node_ptr && (found_tail == False || found_head == False))
	    {
		if (found_head == False &&
		    strcmp (head_name, node_ptr -> name) == 0)
		{
		    head_x = node_ptr -> x;
		    head_y = node_ptr -> y;
		    found_head = True;
		}
		if (found_tail == False &&
		    strcmp (tail_name, node_ptr -> name) == 0)
		{
		    tail_x = node_ptr -> x;
		    tail_y = node_ptr -> y;
		    found_tail = True;
		}
		node_ptr = node_ptr -> next;
	    }
	    if (found_head == False)
		fprintf (stderr, "Could not find: %s\n", head_name);
	    if (found_tail == False)
		fprintf (stderr, "Could not find: %s\n", tail_name);

	    found_tail = found_head = False;
	    while (n > 0)
	    {
		while (*ptr == ' ' || *ptr == '\t')
		    ptr++;
		x = XD (atof (ptr));
		while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		    ptr++;

		while (*ptr == ' ' || *ptr == '\t')
		    ptr++;
		y = YD (atof (ptr));
		while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		    ptr++;

		if (found_tail == False)
		{
		    found_tail = True;

		    if (fabs (tail_x - x) + fabs (tail_y - y) <
			fabs (head_x - x) + fabs (head_y - y))
		    {
			printf (" %.4f %.4f ", tail_x, tail_y);
			found_head = False;
		    }
		    else
		    {
			printf (" %.4f %.4f ", head_x, head_y);
			found_head = True;
		    }
		}

		printf (" %.4f %.4f ", x, y);

		n--;
	    }
	    
	    if (found_head == False)
		printf (" %.4f %.4f ", head_x, head_y);
	    else
		printf (" %.4f %.4f ", tail_x, tail_y);

	    printf ("\n");

	    /*
	     * look for the optional label
	     */
	    while (*ptr == ' ' || *ptr == '\t')
		ptr++;

	    if (*ptr && *ptr != '\n')
	    {
		char *label_text;

		if (*ptr == '"')
		{
		    ptr++;
		    label_text = ptr;
		    while (*ptr != '"')
			ptr++;
		    i = -1;
		    while (ptr[i] == ' ' || ptr[i] == '\t')
		    {
			ptr[i] = '\0';
			i--;
		    }
		}
		else
		{
		    label_text = ptr;
		    while (*ptr != ' ' && *ptr != '\t' && *ptr != '\n')
			ptr++;
		}
		*ptr++ = '\0';

		while (*ptr == ' ' || *ptr == '\t')
		    ptr++;
		x = atof (ptr);
		while ((*ptr >= '0' && *ptr <= '9') || *ptr == '.')
		    ptr++;

		while (*ptr == ' ' || *ptr == '\t')
		    ptr++;
		y = atof (ptr);

		printf ("\n!!! %s.node.lineLabel.%d\n",
			graph_name, link_count);

		printf ("%s.node.lineLabel.%d.x: %.4f\n",
			graph_name, link_count, XD (x));

		printf ("%s.node.lineLabel.%d.y: %.4f\n",
			graph_name, link_count, YD (y));

	printf ("%s.node.lineLabel.%d.symbolLabel: %s.node.lineLabel.%d.label\n",
			graph_name, link_count, graph_name, link_count);


		printf ("%s.node.lineLabel.%d.label.name: %s\n",
			graph_name, link_count, label_text);

				/* lineLabel.%d */
		node_ptr = (link_str *) XtMalloc (sizeof (link_str) +
						  10 + 16);
		sprintf (node_ptr -> name, "lineLabel.%d", link_count);
		node_ptr -> next = nodes;
		nodes = node_ptr;
	    }

	    link_count++;
	}
	else if (strncmp (buffer, "stop", 4) == 0)
	{
	    printf ("\n");

	    if (nodes)
	    {
		printf ("%s.node-list: ", graph_name);

		node_ptr = nodes;
		while (node_ptr)
		{
		    printf (" %s.node.%s", graph_name, node_ptr -> name);
		    node_ptr = node_ptr -> next;
		}
		printf ("\n\n");
	    }

	    if (links)
	    {
		printf ("%s.link-list: ", graph_name);

		link_ptr = links;
		while (link_ptr)
		{
		    printf (" %s.link.%s", graph_name, link_ptr -> name);
		    link_ptr = link_ptr -> next;
		}
		printf ("\n");
	    }

	    exit (0);
	}
    }
}
