#!/bin/sh
#
# xtent.convert.sh
#
if [ $# != 2 ]
then
	echo "Usage: $0 <old xtent file name> <new xtent file name>"
	exit 1
fi

if [ ! -r $1 ]
then
	echo "$0: Cannot read the old xtent file: $1."
	echo "Usage: $0 <old xtent file name> <new xtent file name>"
	exit 1
fi

echo > $2
if [ ! -w $2 ]
then
	echo "$0: Cannot write to the new xtent output file: $2."
	echo "Usage: $0 <old xtent file name> <new xtent file name>"
	exit 1
fi

echo ".XtInclude: OldFunctions.xt" > $2
sed -f xtent.convert.sed < $1 >> $2
