undefine(`include')

define(MakeSubdirs,
all::
	for dir in $1 ; do (echo Build in $$dir; cd $$dir ; make ) ; done
clean::
	for dir in $1 ; do (echo Clean in $$dir; cd $$dir ; make  clean) ; done
install::
	for dir in $1; do (echo Install in $$dir; cd $$dir; make install); done
)

define(DependSubdirs,
depend::
	for dir in $1 ; do (cd $$dir ; make depend) ; done
)

define(NormalLibraryObjectRule,)

define(NormalLibraryTarget,
lib$1.a: $2
	rm -f lib$1.a
	ar r lib$1.a $2
	ranlib lib$1.a
clean::
	rm -f lib$1.a $2
)

define(LintLibraryTarget,)

define(CleanTarget,)

define(TagsTarget,
tags::
	etags *.c *.h
)

define(NormalLintTarget,)

define(NormalProgramTarget,
$1:     $2
	${CC} ${CFLAGS} -o $1 $2 $4 $5
	clean::
		rm -f $1 $2
)

define(SingleProgramTarget,
$1:     $(OBJS)
	${CC} ${CFLAGS} -o $1 $(OBJS) $(LDOPTIONS) $(LOCAL_LIBRARIES) $(SYSLIBS)
clean:: rm -f $1 $2
install::
	MakeDir($(BINDIR))
	install -c -s $1 $(BINDIR)
)

define(ComplexProgramTarget,
$1:     $(OBJS)
	${CC} ${CFLAGS} -o $1 $(OBJS)  $(LDOPTIONS) $(LOCAL_LIBRARIES) $(SYSLIBS)
clean::
	rm -f $1 $2
install::
	MakeDir($(BINDIR))
	install -c -s $1 $(BINDIR)
)

define(InstallProgram,
install:: $1
	MakeDir($2)
	install -c -s $1 $2
)

define(InstallNonExec,
install:: $1
	MakeDir($2)
	install -c $1 $2
)

define(InstallScript,
install:: $1.script
	MakeDir($2)
	install -c -m 555 $1.script $2/$1
)

define(InstallManPage,
install:: $1.man
	MakeDir($2)
	install -c $1.man $2/$1.1
)

define(InstallAppDefaults,
install:: $1.ad
	MakeDir($(RESOURCES))
	install -c $1.ad $(RESOURCES)/$1
)
define(DependTarget,)

define(XawClientLibs,$(XAWCLIENTLIBS))

define(MakeDir,
	@if [ -d $1  ]; then set +x; \
	else (set -x; mkdir $1 ); fi)

define(InstallSubdirs,
install::
	for dir in $1 ; \
	do (cd $$dir ; 	\
	echo "installing" "in $(CURRENT_DIR)/$$dir...";  \
	$(MAKE) $(MFLAGS) DESTDIR='$(DESTDIR)' install);  \
	done
)

define(CleanSubdirs,
clean::
	for i in $1 ; \
	do \
	(cd $$i ; echo "cleaning" "in $(CURRENT_DIR)/$$i..."; \
	$(MAKE) $(MFLAGS) RM_CMD='$(RM_CMD)' clean); \
	done
)

define(NamedTargetSubdirs,
$1::
	for i in $2 ;\
	do \
	(cd $$i ; echo $3 "in $(CURRENT_DIR)/$$i..."; \
	$(MAKE) $(MFLAGS) $4 $5); \
	done
)


define(MakefileSubdirs,
Makefile::
	echo "Makefile created with NoImake"
	echo "Rerun NoImake at the top level"
)

define(InstallMultipleFlags,
install:: $1
	MakeDir($(DESTDIR) $2)
	for i in $1; do \
	  (set -x; $(INSTALL) -c $3 $$i $(DESTDIR) $2); \
	done
)

define(MakeDirectories,
$1::
	for i in $2; do if [ -d $(DESTDIR)$$i ]; then \
	set +x; else  (set -x; $(MKDIRHIER) $(DESTDIR)$$i); fi \
	done
)
