/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/eval_command.c
 *
 * Steve Cole, Dave Nichols (SEP), September 9 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

/* This routine should evaluate a command using an appropriate shell
 * and return the data from stdout in the a character buffer.
 *
 * This implementation uses popen() to do this. There may be faster ways on
 * some systems but this is reasonably portable.
 */

#include <stdio.h>
#include <string.h>

#if defined _POSIX_SOURCE
#include <unistd.h>
#endif

#if defined __STDC__ || defined __stdc__
#include <stdlib.h>
#else
#if defined AIXV3 || defined sun || defined ultrix
#include <stdlib.h>
#else
extern char* malloc();
#endif
#endif     

#include "eval_command.h"
#include "string_buf.h"

/* evaluate a back-quoted command */
#define CBUF_LEN 2000
static char comm_buf[CBUF_LEN+1];

char* eval_command( comm )
char* comm;
{
FILE* in;
int num,pos;
char *ret;
string_buf *buffer;

if( (in = popen( comm, "r" )) == (FILE*)0 ) {
   perror("eval_command"); 
   exit(-1);
}

buffer = buf_start();

while( (num = fread( comm_buf, 1, CBUF_LEN, in )) != 0 ){
    buf_cat( buffer, comm_buf, num );   
};
pclose( in );

/* trim off trailing whitespace */
buf_trim( buffer, " \t\n" );

ret = buf_fetch( buffer );

buf_free( buffer );

return ret;
}
