
/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/item.c
 *
 * Steve Cole, Dave Nichols (SEP), August 31 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

#include <stdio.h>

#include <X11/Intrinsic.h>

#include "object.h"
#include "item.h"

/*
 * Function name: new_item
 * Description: creates a structure for a new list
 *	        or menubutton item.
 * Arguments: info - info structure of choice, list, or menubutton.
 * Returns: pointer to new structure of type itemdef
 */
struct itemdef* new_item(info)
     struct itemizedinfo* info;
{
    struct itemdef *a, *b;
    
    if( info->firstitem == (struct itemdef*)0 ){
	/* make the head of the list */
	info->firstitem = (struct itemdef*) malloc( sizeof( struct itemdef ) );
	info->firstitem->label = (char*)0;
	info->firstitem->value = (char*)0;
	info->firstitem->widgetname = (Widget)0;
	info->firstitem->object = (Objdef*)0;
	info->firstitem->next = (struct itemdef*)0;
    }
    
    a = (struct itemdef*) malloc( sizeof( struct itemdef ) );
    a->label = (char*)0;
    a->value = (char*)0;
    a->widgetname = (Widget)0;
    a->object = (Objdef*)0;
    a->next = (struct itemdef*)0;
    
    /* find the tail of the list */
    for( b=info->firstitem; b->next != (struct itemdef*)0; b = b->next );
    
    b->next = a;
    
    return a;
}
/*
 * Function name: find_item
 * Description: loop over all items for a menubutton or list.
 *		find the one with the right label.
 * Arguments: obj - object structure of menubutton or list.
 *	      label - label to match	
 * Returns: pointer to item structure for matching item
 */
struct itemdef*
  find_item(obj,label)
Objdef* obj;
char* label;
{
    struct itemdef* item;
    
    /* loop over items */
    for ( item=((struct itemizedinfo *) obj->info)->firstitem; 
	 item != (struct itemdef*) 0; item=item->next )
      {
	  if (!strcmp(item->label,label)) {
	      return item;
	  }
      }
    
    fprintf(stderr,"find_item cannot find item with label %s\n",
	    (char *) label);
    exit(-1);  
}
