/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/message.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>

#include "object.h"
#include "tree.h"
#include "builders.h"

void build_message(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    char *name,*label;
    Widget message;
    Arg args[20];
    int narg;
    char defname[12];
    static int numess=1;
    extern void message_update();
    
    /* create new object */
    object = new_object();

    /* construct default dialog name */
    sprintf(defname,"message%d",numess++);
    
    /* find label, name in tree */
    object->name = get_value(root,"name",defname);
    object->value = get_value(root,"value","");

    /* messages do not have a border drawn around them */
    narg = 0;
    XtSetArg(args[narg], XtNborderWidth, 0); narg++;
    XtSetArg(args[narg], XtNlabel, object->value); narg++;
    /* common parameters */
    common_tags(parent,root,args,&narg,SET_ALL);
    
    message = XtCreateManagedWidget(object->name,labelWidgetClass,
					parent,args,narg);

    object->widgetname = message;
    object->updater = message_update;
}

void message_update(object,value)
Objdef* object;
char* value;
{
    Arg args[20];
    int narg;

    narg = 0;
    XtSetArg(args[narg], XtNlabel, value); narg++;
    XtSetValues(object->widgetname,args,narg);
}

