/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/builders.c
 *
 * Steve Cole, Dave Nichols (SEP), November 20 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), January 14 1993
 *     Added support for boolean resources state and sensitive.
 * Steve Cole, Dave Nichols (SEP), February 23 1993
 *     Entries in list can now be redefined.
 *     Added support for x and y coordinates in form widget.
 * Steve Cole (SEP), February 24 1993
 *     Added position (in text widget) to list of known attributes.
 * Bob Craycroft (craycrof@rtp.semi.harris.com), March 23 1993
 *     Added support for form fromHoriz and fromVert constraint resources.
 * Bob Craycroft (craycrof@rtp.semi.harris.com), April 28 1993
 *     Added a bunch of nasty code to control list dimensions.
 * Steve Cole, Dave Nichols (SEP), May 5 1993
 *     Added backgroundPixmap and backgroundBitmap support.
 * Steve Cole (SEP), May 10 1993
 *     List updating now uses the supplied itemlist separator.
 * Dave Nichols (SEP), May 12 1993
 *     Don't use "" inside XtNewString.
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Text.h>
#include <X11/Xmu/Converters.h>

#ifdef XPM
#include <X11/xpm.h>
#endif

#include "object.h" 
#include "item.h" 
#include "tree.h"
#include "builders.h"

#include <stdio.h>

extern Widget toplevel;
char empty[] = "";

void common_tags(w, root, args, pnarg, mask )
Widget w;
entry *root;
Arg *args;
int *pnarg;
int mask;
{
    char *value;
    
    /* height and width */
    if( mask & SET_SIZE ) {
      if (is_specified(root,"width")) {
        value = get_value(root,"width","0");
	SetTag( w,args,pnarg,"width",value );
      }
      if (is_specified(root,"height")) {
        value = get_value(root,"height","0");
	SetTag( w,args,pnarg,"height",value );
      }
      if (is_specified(root,"borderWidth")) {
        value = get_value(root,"borderWidth","0");
	SetTag( w,args,pnarg,"borderWidth",value );
      }
    }

    /* orientation */
    if( mask & SET_ORIENT )
    if (is_specified(root,"orientation")) {
        value = get_value(root,"orientation","0");
	SetTag( w,args,pnarg,"orientation",value );
    }

    /* foreground, background, and border colors */
    if( mask & SET_COLOR ) {
      if (is_specified(root,"foreground")) {
        value = get_value(root,"foreground","0");
	SetTag( w,args,pnarg,"foreground",value );
      }
      if (is_specified(root,"background")) {
        value = get_value(root,"background","0");
	SetTag( w,args,pnarg,"background",value );
      }
      if (is_specified(root,"borderColor")) {
        value = get_value(root,"borderColor","0");
	SetTag( w,args,pnarg,"borderColor",value );
      }
    }

    /* font */
    if( mask & SET_FONT )
    if (is_specified(root,"font")) {
        value = get_value(root,"font","0");
	SetTag( w,args,pnarg,"font",value );
    }

    /* bitmap */
    if( mask & SET_BITMAP ) 
    if (is_specified(root,"bitmap")) {
        value = get_value(root,"bitmap","0");
	SetTag( w,args,pnarg,"bitmap",value );
    }

    /* editType of text objects */
    if( mask & SET_EDIT )
    if (is_specified(root,"editType")) {
        value = get_value(root,"editType","0");
	SetTag( w,args,pnarg,"editType",value );
    }

    /* object sensitivity */
    if( mask & SET_SENSE )
    if (is_specified(root,"sensitive")) {
        value = get_value(root,"sensitive","0");
	SetTag( w,args,pnarg,"sensitive",value );
    }

    /* position */
    if( mask & SET_POSITION ) {
      if (is_specified(root,"x")) {
        value = get_value(root,"x","0");
	SetTag( w,args,pnarg,"x",value );
      }
      if (is_specified(root,"y")) {
        value = get_value(root,"y","0");
	SetTag( w,args,pnarg,"y",value );
      }
      if (is_specified(root,"fromHoriz")) {
        value = get_value(root,"fromHoriz","0");
        SetTag( w,args,pnarg,"fromHoriz",value );
      }
      if (is_specified(root,"fromVert")) {
        value = get_value(root,"fromVert","0");
        SetTag( w,args,pnarg,"fromVert",value );
      }
    }

    /* command and toggle widget parameters */
    if( mask & SET_STATE ) {
      if (is_specified(root,"state")) {
        value = get_value(root,"state","0");
	SetTag( w,args,pnarg,"state",value );
      }
    }

    /* backgroundPixmap */
    if( mask & SET_PIXMAP ) {
      if (is_specified(root,"backgroundPixmap")) {
        value = get_value(root,"backgroundPixmap","0");
        SetTag( w,args,pnarg,"backgroundPixmap",value );
      }
    if (is_specified(root,"backgroundBitmap")) {
        value = get_value(root,"backgroundBitmap","0");
	SetTag( w,args,pnarg,"backgroundBitmap",value );
    }
    }

}

/*	Function Name: SetTag
 *	Description: Does an XtSetArg to set the value for a given tag
 *	Arguments: w = widget name, arg = argument list
 *		   narg = # of arguments set in list
 *		   tag = to be set, value = string to set tag to
 *	Returns: 1 if successful, 0 otherwise
 */
int SetTag(w, args, pnarg, tag, value )
Widget w;
Arg *args;
int *pnarg;
char *tag;
char *value;
{
    XrmValue from, to;
    Pixmap pixmap, bitmap, shapemask;
    unsigned int    bm_h, bm_w;
    int             dhx, dhy;
    Objdef *object;
    struct itemdef *listitem;
    struct itemizedinfo *list_info;
    String * liststring = NULL;
    int allocated_items = 0;
    int nitem = 0;
    char *item;
    int retcode;
    extern void XmuCvtStringToPixmap();
    static XtConvertArgRec screenConvertArg[] = {
    { XtWidgetBaseOffset, (caddr_t) XtOffset(Widget, core.screen), 
        sizeof(Screen *) }
	};

    Widget viewport;
    Dimension width, height, vp_width, vp_height, int_width, int_height;
    Dimension row_spacing, col_spacing;
    XFontStruct *font;
    int row_height, num_rows, num_cols, len, max_len, ii, col_width;
    Boolean force_cols;

    from.size = strlen(value) + 1;  
    from.addr = value;

    /* type String */
    if (!strcmp(tag,"label")) {
      XtSetArg(args[(*pnarg)], tag, value); (*pnarg)++;
      return(1);

    /* list */
    } else if (!strcmp(tag,"list")) {
	/* find the object name for the list widget */
	object = find_by_widget(w);
	/* remove old list definition */
        list_info = object->info;
	list_info->firstitem = (struct itemdef*) 0;
	/* parse the list and add items */
	for (item = strtok(value,list_info->separator), nitem=0; 
  	   item != (char*)0; 
	   item = strtok( (char*)0, list_info->separator), nitem++) {
	     if (nitem == allocated_items) {
	       allocated_items += 5;
	       liststring = (String *) XtRealloc((char *) liststring,
			sizeof(String) * allocated_items);
	       }
	     liststring[nitem] = XtNewString(item);
             /* allocate structure to hold item info */
             listitem =  new_item(list_info);
	     /* here we assume labels and values are the same */
             listitem->value = strdupl(item);
             listitem->label = strdupl(item);
             listitem->widgetname = w;
             /* callback routine needs to know the object name */
             listitem->object = object;
             /* info structure points to first item for find_item */
             if (nitem == 0) list_info->firstitem = listitem;
	}

  	/* Compute and set the new size of the list.  Assume that we do NOT
  	 * want the size of the viewport to change.  We accomplish this
  	 * by ensuring that the size of the list is >= the size of the
  	 * viewport.
  	 */
  
  	/* get the dimensions of the parent ViewPort widget */
  	viewport=XtParent(w);
  	XtVaGetValues(viewport,
  	    XtNwidth, &vp_width,
  	    XtNheight, &vp_height,
  	    NULL
  	);
  
  	/* get list widget info */
  	XtVaGetValues(w,
  	    XtNinternalWidth, &int_width,
  	    XtNinternalHeight, &int_height,
  	    XtNfont, &font,
  	    XtNrowSpacing, &row_spacing,
  	    XtNcolumnSpacing, &col_spacing,
  	    XtNdefaultColumns, &num_cols,
  	    XtNforceColumns, &force_cols,
  	    NULL
  	);
  
  	/* compute column width */
  	max_len = 0;
  	for(ii = 0; ii < nitem; ++ii)
  	{
  	    len = XTextWidth(font, liststring[ii], strlen(liststring[ii]));
  	    if (len > max_len) max_len = len;
  	}
  	col_width = max_len + col_spacing;
  
  	/* compute number of columns */
  	/* the defaultColumns resource is ALWAYS used by the internal List
  	 * code, at least as far as publicly accessed geometry management.
  	 * Therefore, the following code is commented out and the value
  	 * of the defaultCols resource is ALWAYS used as num_cols here.
  	 */
  	/*
  	if (!force_cols)
  	{
  	    num_cols = (vp_width - 2 * int_width) / col_width;
  	    if (!num_cols) num_cols = 1;
  	}
  	*/
  
  	/* compute width */
  	width = num_cols * col_width + 2 * int_width;
  
  	/* compute max_len needed to keep the width from shrinking */
  	if (width < vp_width)
  	    max_len = (vp_width - 2 * int_width) / num_cols - col_spacing;
  
  	/* compute row height */
  	row_height = font->max_bounds.ascent + font->max_bounds.descent
  		+ row_spacing;
  
  	/* compute number of rows */
  	num_rows = (nitem - 1) / num_cols + 1; /* integer math */
  
  	/* compute height */
  	height = num_rows * row_height + 2 * int_height;
  
  	/* compute nitems needed to keep the height from shrinking */
  	if (height < vp_height)
  	{
  	    for ( ; nitem < num_cols * (vp_height - 2 * int_height)
  		    / row_height; ++nitem)
  	    {
  		if (nitem == allocated_items)
  		{
  		   allocated_items += 5;
  		   liststring = (String *) XtRealloc((char *) liststring,
  			    sizeof(String) * allocated_items);
  	        }
  	        liststring[nitem] = XtNewString(empty);
                  /* allocate structure to hold item info */
                  listitem =  new_item(list_info);
  	        /* here we assume labels and values are the same */
                  listitem->value = strdupl("");
                  listitem->label = strdupl("");
                  listitem->widgetname = w;
                  /* callback routine needs to know the object name */
                  listitem->object = object;
                  /* info structure points to first item for find_item */
                  if (nitem == 0) list_info->firstitem = listitem;
  	    }
  	}
  
  	/* install the new list data */
  	XawListChange(w, liststring, nitem, max_len, TRUE);
  
    /* position in text object */
    } else if (!strcmp(tag,"position")) {
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRInt, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
        XawTextSetInsertionPoint(w, (XawTextPosition) *((XawTextPosition *)
		  to.addr));
        return(1);
      }

    /* type Dimension */
    } else if (!strcmp(tag,"width") || 
	       !strcmp(tag,"height") ||
	       !strcmp(tag,"borderWidth")) {
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRDimension, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (Dimension) *((Dimension *) to.addr)); 
             (*pnarg)++;
        return(1);
      }

    /* type Position */
    /* we actually use the horizDistance and vertDistance resources */
    } else if (!strcmp(tag,"x") || 
	       !strcmp(tag,"y")) {
      if (!strcmp(tag,"x")) tag = strdupl("horizDistance");
      if (!strcmp(tag,"y")) tag = strdupl("vertDistance");
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRInt, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (int) *((int *) 
                  to.addr)); (*pnarg)++;
        return(1);
      }


    /* type widget */
    } else if (!strcmp(tag,"fromHoriz") ||
             !strcmp(tag,"fromVert")) {
      object = find_by_name(value);
      XtSetArg(args[(*pnarg)], tag, object->widgetname); (*pnarg)++;
      return(1);

    /* type Pixel */
    } else if (!strcmp(tag,"foreground") || 
	       !strcmp(tag,"background") || 
	       !strcmp(tag,"borderColor")) {
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRPixel, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (Pixel) *((Pixel *) to.addr)); 
                 (*pnarg)++;
        return(1);
      }

    /* type font */
    } else if (!strcmp(tag,"font")) {
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRFontStruct, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (XFontStruct*) *((XFontStruct **) 
                  to.addr)); (*pnarg)++;
        return(1);
      }

    /* type Bitmap */
    } else if (!strcmp(tag,"bitmap")) {
      XtAddConverter(XtRString, XtRBitmap,XmuCvtStringToBitmap,
                 screenConvertArg, XtNumber(screenConvertArg));
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRBitmap, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	  XtSetArg(args[(*pnarg)], tag, (Pixmap) *((Pixmap *) to.addr)); 
                 (*pnarg)++;
          return(1);
      }

    /* type backgroundBitmap */
    } else if (!strcmp(tag,"backgroundBitmap")) {
          /* backgroundPixmap is what we really set */
          tag = strdupl("backgroundPixmap");
 	  bitmap = XmuLocateBitmapFile(XtScreen(w),
                        value, NULL, 0, &bm_w, &bm_h,
                        &dhx, &dhy);
	  if (bitmap == (Pixmap) NULL) {
		fprintf(stderr,"Unable to locate bitmap file\n");
		return(0);
	  }
	  pixmap = XmuCreatePixmapFromBitmap(XtDisplay(w),
			DefaultRootWindow(XtDisplay(w)),
			bitmap, bm_w, bm_h,
			XDefaultDepthOfScreen(XtScreen(w)),
			BlackPixelOfScreen(XtScreen(w)),
			WhitePixelOfScreen(XtScreen(w)));
	  if (pixmap == (Pixmap) NULL) {
		fprintf(stderr,"Unable to convert bitmap to pixmap\n");
		return(0);
	  }
	  XtSetArg(args[(*pnarg)], tag, (Pixmap) pixmap); 
                 (*pnarg)++;
      	  return(1);

    /* type Orientation */
    } else if (!strcmp(tag,"orientation")) {
      XtAddConverter(XtRString, XtROrientation, XmuCvtStringToOrientation,
		NULL,(Cardinal) 0);
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtROrientation, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (XtOrientation) *((XtOrientation **) 
                  to.addr)); (*pnarg)++;
        return(1);
      }

    /* type XawEditType */
    } else if (!strcmp(tag,"editType")) {
	XtSetArg(args[(*pnarg)], tag, (XawTextEditType) *((XawTextEditType *) 
                  value)); (*pnarg)++;
        return(1);

    /* type Boolean */
    } else if (!strcmp(tag,"state") ||
	       !strcmp(tag,"sensitive")) {
      XtConvert(w, XtRString, (XrmValuePtr) &from, XtRBoolean, 
                (XrmValuePtr) &to);
      if (to.addr == NULL) {
      	return(0);
      } else {
	XtSetArg(args[(*pnarg)], tag, (Boolean*) *((Boolean *) 
                  to.addr)); (*pnarg)++;
        return(1);
      }

    /* type Pixmap */
    } else if (!strcmp(tag,"pixmap") ||
               !strcmp(tag,"backgroundPixmap")) {
#ifdef XPM
        retcode = XpmReadFileToPixmap(XtDisplay(w), 
                     RootWindowOfScreen(XtScreen(toplevel)),
                     value,&pixmap,&shapemask,NULL);
        if (!retcode) {
            XtSetArg(args[(*pnarg)], tag, pixmap); (*pnarg)++;
	    /* for buttons, turn off the highlight border.
	     * The Xaw unhighlight routine does not redraw the pixmap */
            XtSetArg(args[(*pnarg)], XtNhighlightThickness, 0); (*pnarg)++;
        } else {
          fprintf(stderr,"XpmReadFileToPixmap failed, return code %d\n",retcode);
      }
#endif /* XPM */
    }

return 1;

}
