.TH XTPANEL l "6 May 1993"
.SH NAME
xtpanel \- build an interactive program, from the command line
or using a simple scripting language
.SH SYNOPSIS
\fBxtpanel\fP [-help] [-tty] [-cpp] [cpp_args] [-file script_file] 
[-message] [-text] [-field] [-dialog] [-button] [-toggle] [-slider] 
[-scrollbar] [-choice] [-list] [-menubutton] [-timer] [-var] [-startup] 
[-graph] [-grid] [-togglegrid] [-quit]
< script_file

.SH DESCRIPTION

\fIxtpanel\fP provides a quick and easy way of producing a panel
containing interactive objects such as buttons, sliders, and text
fields, either from the command line or from an xtpanel script file.
Each panel object maintains a string representation of its value. When
the object is modified it updates its value and it can also perform one
or more actions such as printing its value or calling a system command. 
Objects can make use of the values of other objects in constructing their
actions and they can set the values of other objects as the result of
an action. The result is an interactive X windows program, without the
need for conventional programming.

.PP

Three utilities are provided with xtpanel. The first is a script
generator. This is a collection of xtpanel scripts that can be used to
generate, examine and test xtpanel script files. It is invoked using
the command \fIxtpanel-generator\fP.  The second utility is a
collection of example scripts and a master script that can be use to
view and run the examples. It is invoked using the command
\fIxtpanel-examples\fP.  A particularly powerful demo is the "lister"
script example, which is a tool for maneuvering through a Unix
filesystem and viewing files at any level. The third is a set of
xtpanel scripts that present information about xtpanel, mostly taken
from this manual page, in an interactive, menu-driven form. This
is invoked by doing \fIxtpanel -help\fP.

.SH OBJECT TYPES
xtpanel supports the following objects: 
 
.IP message 10
Displays a single line of text. Read only.

.IP text 10
Displays multiple lines of text in a scrollable area. Can be read/write
or read only. 

.IP field 10
Same as text, but for only a single line of text. Always read-write.

.IP dialog 10
Like field, with a label and an OK button that performs some action.

.IP button 10
A single button.

.IP toggle 10
A button that can be toggled between two states.

.IP slider 10
Allows the user to choose a value from a range of integer
or floating point values. 

.IP scrollbar 10
Similar to a slider, but simpler in appearance.

.IP choice 10
A group of buttons, only one of which may be selected at a time.

.IP menubutton 10
A button with a menu attached.

.IP list 10
A list of character strings, only one of which may be selected at a time.

.IP var 10
A variable that has no screen representation but stores a value.
A variable's actions, if it has any, are executed whenever the value
stored in the variable is modified.

.IP timer 10
An object that has no screen representation but executes its action[s]
at set intervals, without user interaction.

.IP startup 10
An object that has no screen representation but executes its action[s]
at startup time.

.IP graph 10
An object containing a number of scrollbars, each of which controls
the value for one sample of a list of numbers. 

.IP grid 10
An object containing a two-dimensional matrix of buttons. 
Pressing one of the buttons executes the grid's action[s],
optionally making use of the coordinates of the selected button.

.IP togglegrid 10
Like grid, except the buttons are replaced by toggles.
A bitmap of the states of all the toggles can be generated.

.PP
In addition there are several objects that group
other objects together in boxes. Grouping objects in this
way allows greater control of the panel layout. See
the section below on BOXES AND FORMS.

.SH CONTROLLING XTPANEL
The rest of this manual page describes
how to write xtpanel script files or run xtpanel from the command
line. If you just want to use it, and don't want to write script
files or learn the command line syntax, then run the automatic
script generator described above. The generator is also a good
way to learn about the script language, since it allows you to
view, edit, and test a script file as it is being built.

.SH SCRIPT VS. COMMAND LINE
The typical xtpanel script contains lines of the form:

.br
object_type={ parameter1=value1 parameter2=value2 ... }

.br
This format is very flexible; the parameters can be supplied in 
any order, or omitted and defaults will be provided. Line breaks can 
occur anywhere.
.PP
From the command line, all objects and all their parameters must
be specified on the same line in a precise order:

.br
-object_type value1 value2 value3... -object_type value1 ...

.PP
Some parameters can be omitted; the "-" on the beginning
of the next object tells xtpanel to stop reading parameters
for one object and begin the next. However, in order to 
specify a particular parameter, all those up to it in the
sequence must be specified. (For instance, in the case above,
to specify value3 for the first object, one must also specify
value1 and value2, while in a script they could be omitted and left to
default.)
.PP
For these reasons, and because the command line format
(where the entire panel is specified on a single line)
is more difficult to read, it is recommended that a script file be
used for all but the smallest examples. The following section
describes the objects in greater detail, along with the
script language syntax. If you wish instead to use the
command line interface, see the COMMAND LINE SYNTAX
section below.
.PP
Note that scripts and the command line interface can be mixed, and multiple
script files can be read using the "-file" option (see GENERAL COMMAND 
LINE OPTIONS, below.) 
So the following is a valid xtpanel command:
.br
xtpanel <script1 -file script2 -quit.
.PP
Standard input is read after all the command line
options have been parsed so you cannot refer to a variable defined in the
file on stdin in an object defined on the command line, but the opposite
is OK (and useful). 

 
.SH DESCRIPTION OF OBJECTS AND SCRIPT SYNTAX
Here is a more detailed description of the objects,
the parameters relevant to each, and the syntax for
building these objects in a script file.

The general format for specifying an object in a script file is:

.br
object_type={ parameter=value ... }

Note that no spaces are allowed between
the object_type and the "{".

Each "value" can take one of four forms:
A single word, a string enclosed in single quotes, a string enclosed in
double quotes or a string enclosed in backquotes. See the section
"SCRIPT SYNTAX DETAILS" for more information on the syntax. 

.PP
There are five parameters that many objects have in common, these are:
name, label, action, test and value.

\fIname\fP is the name of the object. 
The name serves two purposes, it can be referred to by other objects who wish
to obtain the or modify the string representation of the object. 

The name can also be used in modifying the appearance of an object using 
the X-toolkit resource mechanism. 

When names are referred to by other objects they start with a dollar 
sign and optionally an opening parenthesis. They are assumed to end at
the next space or closing parenthesis. Therefore a name may 
not contain spaces, parentheses or dollar signs.

\fIlabel\fP is the label that appears on the object. By default it
is the set to the name. It will appear in an "appropriate" place
which depends on the object type. Some objects do not have labels. The
label parameter is ignored for these objects.

\fIvalue\fP is the initial string value associate with the object.
If the object is modified this string value will change. It defaults to
be the same as label.

\fIaction\fP is an action that occurs when the object is modified -
when a button is pressed, a scrollbar is moved, etc. Some objects
(slider and dialog) have separate buttons to trigger the action.
Defaults to "NONE", which means that the object simply maintains a
string, containing its value, for use by other objects.  Other actions
are PRINT (print string to standard output), SYSTEM (execute a
command), STRING (reformat the internal representation of the object's
value, where the string can contain more than just the object's value)
, ASSIGN (set another object's value to a given string), SET (set an
attribute of an object; e.g. color ) and QUIT (quit xtpanel). 
See the section below on ACTIONS for more
details. If more than one action is present the actions will be performed 
in the order that they are specified.

\fItest\fP is a composite object that contains a condition and two sets 
of actions.  One set is performed if the condition is true the other if 
it is false.  See the section below on ACTIONS for more details.

.IP \fImessage\fP 3
A message displays a single line of text on a panel.
Messages are used to give short instructions or bits of
information to the user. The script syntax for a message is:

.br
message={  value=.... name=.... }

The most important variable in a message object is the \fIvalue\fP. 
The value is the text that is displayed on the screen. 
The \fIname\fP is relevant for tailoring the appearance of
this message object using resources or assigning new values to the
message. If a new value is assigned to the message the text will change
to reflect the new value.

.br
example:
.br
message={ value=" hello world, I am a message object " }

Assigning a new value to a message object (using an ASSIGN
action) will change the text that is displayed. Multi-line
messages are possible if carriage returns are included in
the value, but for such messages the text object may be
more appropriate.

.IP \fItext\fP 3
A text object displays any number of lines of text in
a multi-line scrollable region.

.br
text={ action=... name=.... value=... editType=... }

The \fIvalue\fP is the text to be displayed on the screen.
Newlines in the value will cause the text to start a new line.
The \fIname\fP is relevant for tailoring the appearance of
this text object using resources  or assigning new values to the
message. If a new value is assigned to the text the text will change
to reflect the new value.
\fIaction\fP: The text object can have an action. The action
occurs when the cursor leaves the text object.
\fIeditType\fP is used to select whether editing of the text
is allowed. Choices are read (read-only), append (can add to text
but not modify existing text), edit (read-write).

Assigning a new value to a text object will change the text
that is displayed.

.br
examples:
.br
text={ value="I am a multiline \\n text object \\n with three lines" }
.br
text={ value=`cat README` }

.IP \fIfield\fP 3
A field is a single line of editable text. Syntax:

.br
field={ value=... name=... action=... }

\fIname\fP  defaults to "field1", "field2" etc.
\fIvalue\fP is the text that initially appears in the text field.
A value of "" means that the text field will initially be blank.
\fIaction\fP: The field object can have an action. The action
occurs when the return key is pressed in the field. Actions
of type STRING and NONE also take place whenever the cursor
leaves the field. 

Assigning a new value to a field changes the displayed string 
to the new value.

.br
example:
.br
field={ value="" action="xterm -e vi $val" }

.IP \fIdialog\fP 3
A dialog displays an editable line of text. 
A label is shown above the text, and an OK button is added
to perform an action. Syntax:

.br
dialog={ label=... value=... name=... action=... }

\fIname\fP  defaults to "dialog1", "dialog2" etc.
\fIlabel\fP appears above the text field.
\fIvalue\fP is the text that initially appears in the text field.
A value of "" means that the text field will initially be blank.
\fIaction\fP: An "OK" button is added to the
panel, and the dialog object is activated when this button is
pressed. The action also occurs if the return key is pressed
while the cursor is positioned in the dialog.

Assigning a new value to a dialog changes the displayed string 
to the new value.

The OK button of a dialog is omitted if all of its actions
are of type STRING or NONE. Actions of type STRING and NONE
automatically take place whenever the cursor leaves the dialog, 
so there is no need for the button in these cases.

.br
example:
.br
dialog={ label="Filename to edit" value="" action="xterm -e vi $val" }

.IP \fIbutton\fP 3
A button can be pressed, then returns to its intial state. 
Pressing the button will cause a specified action to take place.

.br
button={ label=... value=... name=... action=... }

\fIname\fP defaults to "button1", "button2" etc.
\fIlabel\fP is the text  that appears on the button. 
\fIvalue\fP is the string value associated with the button.
\fIaction\fP is an action that occurs when the button is pressed. 

Assigning a new value to a button does not change the appearance of the
button but it will change the value used in an action.

.br
example:
.br
button={ label="Press me" action="PRINT Aargh! I was pressed" }

.IP \fItoggle\fP 3
A toggle object is similar to a button except that it
can be toggled between its on (highlighted) and off states,
while a button returns to its off state immediately. The
value of a toggle object is blank when the toggle is in
its off state.

The state of a toggle can be changed using the SET action.
For a toggle object named "mytoggle" the following object
will set the toggle to its off state:
.nf
action="SET mytoggle state False"
.fi

See the section on ACTIONS for more details on using the
SET action.

.IP \fIslider\fP 3
A slider lets the user choose a value from a range of integer
or floating point values. Syntax:

.br
slider={ label=... value=... name=... action=... min=... max=... \
format=... width=... height=... }

A slider object has a label, a slider and a text field that
displays the current slider value, and
an "OK" button to allow the user to trigger the slider's
action. 

\fIname\fP defaults to "slider1", "slider2" etc. 
\fIlabel\fP appears above the slider.
\fIvalue\fP is the starting value for the slider; defaults to the minimum.
\fIaction\fP: For action types SYSTEM and PRINT the action occurs when 
the "ok" button is pressed. For action type STRING the action occurs when 
the slider position changes.

Assigning a new value to a slider changes the slider position to match the
new value. If the new value string is not a number (as interpreted by the
routine atof() ) the slider will be set to zero.

\fImin\fP is the minimum value for the slider; defaults to 0. 
\fImax\fP is the maximum value for the slider; defaults to 1. 

\fIformat\fP is the format with which the slider label and its internal 
string 
will be printed. The slider value is stored internally as a floating point
number; the default value for format is %f, which prints the value
with five decimal places. You can specify a different format, according
to the format specification for the C programming language. To obtain
in integer-only slider, use a format of %.0f (the 0 indicates no digits
after the decimal point).

\fIwidth\fP and \fIheight\fP are the lengths of the major and minor
axes of the slider. By default, sliders are oriented horizontally.
This can be changed by using the orientation parameter described
below in the MISCELLANEOUS PARAMETERS section.

The OK button of a slider is omitted if all of its actions
are of type STRING or NONE. Actions of type STRING and NONE
automatically take place whenever the slider is moved, so there
is no need for the button in these cases.

.br
example
.br
slider={ label=Velocity min=1000 max=4000 value=2000 format=%4.0f }

.IP \fIscrollbar\fP 3
A scrollbar object is similar to a slider, except that it has
no label or ok button. A scrollbar's actions are performed
whenever the scrollbar is changed. (This may be more often than
you would like. It may be better to supply a separate button
that acts based on the scrollbar's value, rather than having
the scrollbar act on its own.)

.IP \fIchoice\fP 3
A choice object is a set of toggle buttons. Each button may
be set on or off, but only one button may be active at a time. Syntax:

.br
choice={ label=... value=... name=... action=... item=... itemlist=... }

The choice object consists of a text label and a set of buttons.
The value of the object on output is set to the value associated with 
the active button.

\fIname\fP  defaults to "choice1", "choice2" etc.
\fIlabel\fP  appears adjacent to the buttons.
\fIvalue\fP is the initial value associated with the 
choice. It must match the value of one of the buttons, or by default
it is set to the value of the first button.
\fIaction\fP is an action that occurs when a button is pressed. 

Assigning a new value to a choice changes the choice to match the new
value. If the new value does not match any item's value the choice will be
unchanged.

\fIitem\fP and \fIitemlist\fP are used to describe the buttons
contained in a choice. You can either specify buttons one at a
time with item, or in groups with itemlist. See the detailed
descriptions of item and itemlist below. There is no limit on
the number of items or itemlists used in a choice object.

.br
example:
.nf
choice={ label="english colors" action="PRINT use $val " 
		item={ label=red } item={ label=green } item={ label=blue }
            }
.fi

.IP \fImenubutton\fP 3
A button with a pulldown menu. Syntax:

menubutton={ label=... value=... name=... action=... item=... itemlist=... }

\fIname\fP  defaults to "menubutton1", "menubutton2" etc.  
\fIlabel\fP  appears on the button.
\fIvalue\fP is the initial value associated with the menu. 
It must match the value of one of the menu items, or it
defaults to be the same as the value of the first menu item. 
\fIaction\fP  occurs when a menu item is selected. 

\fIitem\fP and \fIitemlist\fP are used to describe the options
contained in a menu. You can either specify buttons one at a
time with item, or in groups with itemlist. See the detailed
descriptions of item and itemlist below. There is no limit on
the number of items or itemlists used in a menubutton object.

Assigning a new value to a menubutton changes the menubutton to match 
the new value. If the new value does not match any item's value the 
menubutton will be unchanged.

.br
example
.nf
menubutton={ label="french color" action="PRINT utilisez $val " 
	item={ label=red value=rouge } 
        item={ label=green value=vert } 
        item={ label=blue value=bleu }
            }
.fi

.IP \fIlist\fP 3
A list of items; the user clicks on one of the items to select it.
Syntax:

.br
list={ label=... value=... name=... action=... item=... itemlist=... \
       columns=... height=... width=... }

The list object has a text label and a list of items.

\fIname\fP  defaults to "list1", "list2" etc.
\fIlabel\fP appears adjacent to the list.
\fIvalue\fP is the initial value associated with the list. It must
match the value of one of the list items, or it defaults to be
the same as the value of the first list item.
\fIaction\fP occurs when an item is selected. 

\fIitem\fP and \fIitemlist\fP are used to describe the items
contained in a list. You can either specify items one at a
time with item, or in groups with itemlist. See the detailed
descriptions of item and itemlist below. There is no limit on
the number of items or itemlists used in a list object.
\fIcolumns\fP is the number of columns in the list. The
default is two.
It may be useful to specify \fIheight\fP and \fIwidth\fP
for lists with many entries. These parameters will determine
the size of the scrollable area within which the list will
be displayed. Otherwise, the area will be made big enough
to encompass all items.

Assigning a new value to a list changes the list value to match the new
value. If the new value does not match any item's value the list will be
unchanged.

The entries in a list can be changed using the SET action.
For example, suppose an action were of the form:
.nf
action="SET mylist list "a b c d"
.fi

This would cause the list of an object named mylist to be reset
to the four entries a, b, c, d. The string containing the list
values must have the individual list entries, separated by spaces
or newlines. When the list entries are reset in this way, the
values corresponding to the entries are assumed to be the same
as the entries themselves. There is no way to have distinct labels
and values as there is when the list is first created.

.br
example:
.nf
list={ label="german color" action="PRINT benutze $val " 
	item={ label=red value=rot } 
        item={ label=green value=gruen } 
        item={ label=blue value=blau }
            }
.fi


.IP \fIitem\fP 3
Item is used to specify a single item for a choice, menu or list.
Syntax:

.br
item={ label=... value=... }

\fIlabel\fP is the label that appears on the screen,
as the name of the button (for choice) or on the menu or list.
Defaults to "item1", "item2" etc.
\fIvalue\fP is the value that is set in the parent object when this
item is selected. Defaults to be the same as label.
Item is preferred over itemlist when the text displayed
on the screen for an item and that used for its value differ.

.br
example:
.br
item={ label=Two value=2 }

.IP \fIitemlist\fP 3
Itemlist is used to specify several items for a choice, menu or list.
Syntax:

.br
itemlist={ list=... separator=... }

\fIlist\fP is a single string containing a list of items. The string 
will be parsed to obtain the individual items. The label and value
of each item will be the same, set to the string taken from the list.
Thus itemlist is not appropriate when the text displayed on
the screen for an item (the label) and that used for the value 
are to differ.
\fIseparator\fP is a string of characters that is used to separate different 
items in the list string. Defaults to separator=" " (the blank character.)

.br
examples:
.nf
itemlist={ list="red white blue" } 
itemlist={ list=`ls -aF` separator=" \\n" }
.fi

.IP \fIvar\fP 3
Var is an xtpanel variable, an object that has a value and no 
screen representation. If a variable
has an action specified this action is performed \fIevery time\fP the
variables value is changed. It is a side effect of another object changing
the variable's value. Obviously a variable should never change its own value
since a loop would result.

Syntax:
var={ name=... value=... action=... }

\fIname\fP  defaults to "var1", "var2" etc.  
\fIvalue\fP is the value of the var. 
\fIactions\fP are performed whenever the value of the variable
is changed.


Variables can be used for adding arbitrary arguments on the command line. 
See the command line syntax below. The values of var objects may be used
in the definition of other objects so that an xtpanel's behavior can be
modified without changing the script file. Also the value of a var may be 
changed by the ASSIGN action. Thus a var can be used to pass
information from one object to another.


Here is an example of how you might use an xtpanel variable.
Suppose that you have one script file that asks the user for
a file name, then calls a second script to display the file in
a text window. Here is the first script:
.nf
button={ label=QUIT action=QUIT }
dialog={ label="Filename" action="xtpanel -var file $val -file script2" }
.fi
and here is the second script, script2. The $file variable from
script1 is used in two places in script2:
.nf
button={ label=QUIT action=QUIT }
message={ value="$file" }
text={ value=`cat $file` }
.fi

.IP \fIstartup\fP 3
A startup is an object that has a value and no screen representation. 
Its action is performed at the time it is created. A startup's value
may be refered to and changed but it will never perform its action
again.

Syntax:
startup={ name=... value=... action=... test=... }

\fIname\fP  defaults to "startup1", "startup2" etc.  

Startups are very useful when used in conjunction with conditional
actions, see TESTS below. They can be used to set the initial state 
of a panel in a manner that can depend on external factors.

The startup object in this script tests to see if the file fred_save exists. 
If it does, it sets the initial value of fred to the contents of that file. 
The SAVE button will save the current contents of fred in a file fred_save. 
The REMOVE button will remove the current save file.

.nf
field={ name=fred value=" " }
startup={ 
     test={ 
        condition=" test -f fred_save " 
	true={ action="ASSIGN fred `cat fred_save` " }
     }
}
button={ name=SAVE action="echo $fred >fred_save" }
button={ name=REMOVE action="/bin/rm fred_save" }
button={ label=QUIT action=QUIT }
.fi


.IP \fItimer\fP 3
A timer is another object that has a value but no screen representation. 
Its action is performed at regular intervals.

Syntax:
startup={ name=... value=... interval=...  running=... action=...  }

\fIname\fP  defaults to "timer1", "timer2" etc.  

A timer has two special parameters, interval and running.
\fIinterval\fP is a floating point number that specifies the interval 
(in seconds) at which the timer's actions will be performed.
\fIrunning\fP is an integer that specifies whether the timer is
running. Running defaults to 1, i.e. it defaults to be running.
Using SET a timer can be turned off by setting its running
parameter to 0.

A very simple script can generate a digital clock. The message
object is initially set the the output of the "date" program. The
timer object runs its action every second. Its action is to update the
message field with the current output of the "date" program.

.nf
message={ name=disp value=`date` }
timer={ interval=1 action="ASSIGN disp `date`" }
.fi

Another common use for timers is to check the status of a job that has been
run in the background. There is an example script to do this in the
section on TESTS below.

.SH COMPOSITE OBJECTS
The remaining three objects - graph, grid, and togglegrid,
are composite objects. That is, they are made up of a number
of simpler objects. A graph is made up of sliders. Moving the
sliders changes the values of the samples in a one-dimensional
function. You might want to use it to display and edit data.
A grid is a two-dimensional matrix of buttons. When you click
on one of the buttons, actions can be performed, using the
coordinates of the button. This can be useful for choosing
the values of two independent parameters (x and y position)
simultaneously instead of using two sliders. A togglegrid
is similar except the elements can be toggled between two
samples. You might use this, for example, to edit a bitmap.

.PP
An interesting use for these composite objects is to add
a background pixmap or bitmap (see the MISCELLANEOUS PARAMETERS section).
The pixmap or bitmap appears behind the sliders or buttons, which are
then used to "pick" points or curves in the data.

.PP
Composite objects consist of a form object containing the
buttons or toggles. There is no label or other annotation.

.IP \fIgraph\fP 3
A graph is a composite object, made up of a number of scrollbars.
Syntax:

.br
graph={ nsamp=... value=... name=... action=... min=... max=... \
format=... width=... height=... }

A graph object has \fInsamp\fP scrollbars, each of
which sets the value of one sample in the graph. The value of
a graph is a string containing the sample values, separated by
spaces.

\fInsamp\fP number of samples in the graph.
\fIname\fP defaults to "graph1", "graph2" etc. 
\fIvalue\fP is the starting value for the graph; defaults to the minimum.
You can specify up to nsamp values in a blank-separated list. If
you specify fewer than nsamp, the last value specified is re-used
as needed. Thus you can use value=0 to set all samples to zero.
\fIaction\fP: Graph objects cannot do PRINT or SYSTEM actions by
themselves. You must supply another button that uses the graph's
value to perform an action.

\fImin\fP, \fImax\fP, and \fIformat\fP are the same as for sliders.

\fIwidth\fP and \fIheight\fP are the lengths of the major and minor
axes of the scrollbars in the graph. These are the dimensions of
each scrollbar, not the graph as a whole.

By default, the scrollbars are oriented horizontally.
This can be changed by using the orientation parameter; see the
MISCELLANEOUS PARAMETERS section below.

Assigning a new value to a graph will change the value of 
the samples. You can specify up to nsamp values in a blank-separated list. 
If you specify fewer than nsamp, the last value specified is re-used
as needed.

Holding down the meta key (with no mouse buttons pressed) 
while the cursor is inside a graph object
allows the user to "draw" the graph without having to press mouse
buttons. This drawing can be slow for graphs with a large number
of samples, because of the number of widgets involved.

.br
example
.br
graph={ nsamp=100 min=-100 max=100 value=0 format=%4.0f }

.IP \fIgrid\fP 3
A grid is a composite object, like a graph, but made up of a number of 
buttons rather than scrollbars.
Syntax:

.br
grid={ nx=... ny=... value=... name=... action=... xmin=... ymin=... \
dx=... dy=... format=... width=... height=...  }

A grid object is a form containing nx by ny buttons.
Clicking on one of the buttons invokes the grid's actions.
The value of the grid is a string containing the x and
y coordinates of the selected button.

\fInx\fP and \fIny\fP number of samples in the grid in the horizontal
and vertical directions.
\fIname\fP defaults to "grid1", "grid2" etc. 
\fIvalue\fP are the x and y coordinates of a selected button. 
\fIaction\fP: The actions take place whenever a grid button
is selected.

\fIxmin\fP, \fIymin\fP, \fIdx\fP and \fIdy\fP are used to
compute the coordinates of a selected button for output
purposes. By default, xmin and ymin are 0 and dx and dy
are 1. This means that the coordinates reported will be
(0,0) if the upper left button is selected and (nx-1,ny-1) if
the lower right button is selected.

\fIwidth\fP and \fIheight\fP are the dimensions of the
individual buttons in a grid. These default to 10 pixels.

The output is formatted according to \fIformat\fP.
The default is "%.0f %.0f". This will print the two coordinates
as integers, separated by a space.

.br
example
.br
grid={ nx=20 ny=20 format="x=%.0f y=%.0f" }

.IP \fItogglegrid\fP 3
A togglegrid is a similar to a grid, but with toggles instead
of buttons.

Syntax:

.br
togglegrid={ nx=... ny=... value=... name=... action=... \
 xmin=... ymin=... dx=... dy=... format=... width=... height=... \
 formtype=... }

A togglegrid is a form containing nx by ny toggles.
Clicking on one of the toggles changes its state.
The value of the grid is a string containing either the x and
y coordinates of all toggles that are highlighted, or
a string of 0's and 1's describing the state of all the toggles.
The formtype parameter specifies which output format is
to be used.

\fInx\fP and \fIny\fP number of samples in the grid in the horizontal
and vertical directions.
\fIname\fP defaults to "togglegrid1", "togglegrid2" etc. 
\fIvalue\fP depends on formtype; see below.
\fIaction\fP: The actions take place whenever the cursor
leaves the togglegrid. You may wish to give the togglegrid
no actions, and instead supply a button to do something
with the togglegrid's value.

\fIxmin\fP, \fIymin\fP, \fIdx\fP and \fIdy\fP are the
same as for grid.

\fIwidth\fP and \fIheight\fP are the dimensions of the
individual toggles. Default is 10.

\fIformtype\fP determines what goes into the value of the
togglegrid. formtype=xy will result in a string containing the
x and y coordinates of all the toggles that are highlighted,
each formatted according to \fIformat\fP. formtype=bits
will result in a string of 0's and 1's being output for
each row of the togglegrid, indicating the state of the
entire grid. In this case, format is not used.

\fIformat\fP is the same as for grids.

Assigning a new value to a togglegrid will change the state of 
the samples. If formtype=bits, the new value should be a string
of 0's and 1's. It can be up to nx*ny characters long.
If you specify fewer than nx*ny, the value string is used
repeatedly. Thus you can turn on every third sample in
a togglegrid by doing action="ASSIGN xxx 100", where xxx
is the name of the togglegrid.

Holding down the meta key (with no mouse buttons pressed) 
while the cursor is inside a togglegrid object
allows the user to "draw" without having to press mouse
buttons. This drawing can be slow for graphs with a large number
of samples, because of the number of widgets involved.
Similarly, hold down the control key while moving
to "erase".

.br
example
.br
togglegrid={ nx=50 ny=50 formtype=bits }

.SH SCRIPT SYNTAX DETAILS
The general format for specifying an object in a script file is:

.br
object_type={ parameter=value ... }

Note that no spaces are allowed between
the object_type and the "{".

A line with an exclamation "!" in column one is treated as a comment line,
the rest of the line will be ignored.

Each "value" can take one of three forms:

.IP 1) 3 
A single word. 
.br
e.g. label=fred

.IP 2) 3 
zero or more words enclosed in single quotes 
.br
e.g. label='fred in quotes'
.br
The quotes are stripped before the value is stored. Two consecutive
single quotes within the quotes will produce a single quote in the
stored value. Any other type of quotes pass through unchanged.
.nf
e.g. ' ''fred'' is happy' is stored as -> 'fred' is happy<-
       '"fred" is happy' is stored as ->"fred" is happy<-
.fi

.IP 3) 3
zero or more words enclosed in double quotes
.br
e.g. label="fred in quotes"
.br
The quotes are stripped before the value is stored. Two consecutive
double quotes within the quotes will produce one double quote in the
stored value. Any other type of quotes pass through unchanged.
.nf
e.g. " ""fred"" is happy" is stored as -> "fred" is happy<-
     " ""fred"" is 'happy'" is stored as -> "fred" is 'happy'<-
.fi
.PP
Within either single or double quotes the following transformations are
applied to handle newlines:
.br
.nf
 newline                ->              newline
 backslash newline      ->              is removed 
 \\n                     ->              newline
.fi
.PP
A string may contain zero or more words enclosed in backquotes.
.br
e.g. label=`echo my name is fred`
.br
or   label="This user's name is `whoami` "
.br

The value stored is the output produced by running the command using
the user's shell. Any trailing whitespace is stripped from the output.
.br
In these examples the values stored are ->my name is fred<- 
and ->This user's name is dave <- (assuming I ran it.)

A double backquote "``" is used to generate a single backquote in
the value string.
.br
e.g. ``this string is in backquotes`` "
.br


The value string specified can contain xtpanel variables. An xtpanel
variable is the name of an object preceded
by a dollar "$" sign. The string associated with the object
is substituted in the value string. An object name can
be enclosed in brackets to avoid syntactic ambiguity. 
For an object named "myobj", you can refer to its value elsewhere
in an xtpanel using "$(myobj)" or "$myobj". The first form is
recommended. If you do not enclose the name in
brackets it will be assumed to end at the next space, dollar sign or quote.
It makes no sense to reference an object before it is defined. A double
dollar sign "$$" is used to generate a single dollar in the value
string. 

The rule for expanding strings is as follows. The string is read
from the start, when a reference to another object is found it is replaced
by the value of the object, without expansion. When a backquote is found 
the string inside the backquotes is expanded before the command is executed.
This means that the commands in backquotes may
contain the values of other objects. Strings in actions are
expanded at the time the action is performed, not at the time that they are
read. This means that you will not be informed of any errors in 
expanding an action string until the action is performed. See ACTIONS below.

.nf
e.g. This script lists a directory and puts the result in a text field.

field={ name=dir value=`echo $$HOME` }
button={ label="list" action="ASSIGN txt `ls $home`" }
text={ name=txt height=200 width=400 }
.fi

Note that the interpretation of variables is not recursive. Within
an xtpanel variable that is evaluated, a new variable will be left as 
is rather than being replaced with its current value. 
Similarly, any backquoted
strings stored in the variable (using double backquotes) are not 
recursively expanded.

.nf
i.e. With this script,

var={ name=fred value=" I am $$fred " }
var={ name=joe value=" ``echo hello`` " }
message={ value=" The value of fred is $fred " }
message={ value=" The value of joe is $joe " }

The two message field will display:
"The value of fred is  I am $fred  "
"The value of joe is  `echo hello`  "
.fi


.SH MISCELLANEOUS PARAMETERS
In addition to the parameters described above, there are a number
of general parameters that apply to many objects that customize
the appearance of the object. These are listed below, along with
a list for each of the objects it can be applied to. These
general parameters can also be modified by xtpanel using the SET
action. See the section on ACTIONS.

.IP height 10
height of object, in pixels.
.IP width 10
width in pixels. Height and width can be used for most objects.
.IP foreground 10
foreground color. Colors are appropriate for most object types.
.IP background 10
background color
.IP borderColor 10
border color. 
.IP borderWidth 10
border width in pixels. 
.IP font 10
text font. Appropriate for message objects only.
.IP orientation 10
for boxes, scrollbars, choice objects. Choices are horizontal and vertical.
.IP bitmap 10
for message, button, and toggle objects. Specify a file name.
The bitmap will be displayed in place of the label.
.IP backgroundPixmap 10
For many objects, a pixmap can be displayed in the background.
This requires that the XPM library was available at xtpanel
compilation time.
.IP backgroundBitmap 10
Background pixmaps do not require the XPM library, thus they
are a useful alternative if XPM is not available at your
site.
.IP editType 10
for text objects only, to indicate whether they are read-only
are not. Choices are read (read-only), append (can add to text
but not modify existing text), edit (read-write).
.IP position 10
For text objects only, you can set the position of the
cursor. The value to use is the position in number of characters
from the start of the file. This is useful if you are sending the
output of a long job to a text object. Using a timer to
periodically position the text object to the end of the
file ensures that you will be displaying the most recent output.
It can be done with a timer of the form:
timer={ action="SET xxx position `echo $xxx | wc -c`" }
where xxx is the name of the text object.
.IP x,y 10
for use only with objects that are contained in a form object
(see section on BOXES AND FORMS for more details). These are
the coordinates of the upper-left corner of the object, relative
to the upper-left corner of the form. Inside a form object, ALL
objects must have x and y specified or the objects will be
poorly positioned and some may be obscured. If you combine
these with fromHoriz and fromVert (below), then x and y are
relative to the position of some other object, not to the
upper left corner of the form.
.IP fromHoriz 10
.IP fromVert 10
For use in form objects. This makes the x and y values described
above relative not to the upper-left corner of the form, but to
the upper-left corner of another object within the form.
After fromHoriz or fromVert, specify the object name of the
other object. If you use just fromHoriz or fromVert with no
x or y, a default separation between objects of 4 pixels
is used.
.IP state 10
for toggle objects, this is the state of the toggle, true
(highlighted) or false. Should be set to true or false; case
is not important.
.IP sensitive 10
set to true or false. Objects whose sensitivity is set to false
will be grayed out and will not be selectable.
.IP list 10
list objects can have the contents of the list reset using
the SET action. The argument to SET should be a character
string containing the new list entries, with spaces or newlines
separating the entries.
.IP columns 10
This is the number of columns in a list.

.PP
These parameters are just some of the many resources defined
for Athena widgets. In the future we hope xtpanel will provide
a more general method that allows the user to access all
resources, not just those on this list.

.SH ACTIONS
An action is a command performed when a user interface object has changed
its state. e.g. a button is pushed, a list item is chosen, a slider is
moved. Actions ca be specified in two forms, the simple "action={}" syntax
or the conditional "test={}" syntax. If more than one action or test is 
specified for an object then the separate actions are performed in the order 
in which they are specified in the script file.

There are seven basic types of action NONE, QUIT, SYSTEM, PRINT, STRING, 
ASSIGN, and SET.

If no action is specified (or the action is specified as "NONE")
the action type is NONE. In this case an object 
will just maintain its string representation.  For dialogs, the string
is the contents of the text field; for sliders, the slider value;
for choice, menubutton and list objects, the value associated with
the selected item. When an object with action=NONE is modified, 
its string is kept up to date, but nothing else happens.


The next five action types (QUIT, SYSTEM, PRINT, STRING and ASSIGN) are more 
complicated.  Each uses the format specified in the action command to 
generate a string.

If the action is QUIT, the string is converted to an integer (using "atoi").
The xtpanel program then quits using the integer as its exit code.
The simple quit button
is written as: 
.br
button={ label=QUIT action=QUIT }

If the action is SYSTEM, then that string is executed. If the action type
is PRINT then the string is printed to the standard output. If the action
is STRING then the string is stored as the internal string representation
of the object.

If the action type is ASSIGN the value of the other
object is set to the string. Additionally the screen representation of the
object is updated to reflect the new value (if it makes sense to do so).
For example if the value of a dialog is updated the text field of the
dialog will contain the updated string. If a slider is updated the
slider thumb will be moved to the corresponding position.

The format specified can contain the names of objects preceded
by a dollar "$" sign. The value of the string associated with the object
is substituted in the generated string. The special symbol "$val" is used
to refer to the string associated with the current object. An object name can
be enclosed in brackets to avoid syntactic ambiguity. You can use "$(val)" or
"$val", the first form is recommended. If you do not enclose the name in
brackets it will be assumed to end at the next space, dollar sign or quote.
You should give an object a name if you intend to use its string in the 
action of another object.
A double
dollar sign "$$" is used to generate a single dollar in the generated
string. 

The rules for expanding a format string are the same as those
described above for general strings in scripts. First the values of
other objects are expanded and then any backquoted strings are
evaluated. The major difference in actions is that the format string
is expanded at action time. This means that the object value in the
string is the value at action time. However it also means that you
won't be informed of any errors until action time.

The ASSIGN action is special because the word immediately following 
the word ASSIGN (separated by blanks) is the name of an object that 
will have its value modified.
The format is thus assumed to start at the second word after ASSIGN. 

The SET action is another special case. The set action allows you
to modify not the value of an object, but one of its resources,
such as foreground or background color, font, orientation, etc.
The word immediately following the word SET is the name of the
object; the next word is the resource you wish to set. Following
that is the resource specification.
See the section above on MISCELLANEOUS PARAMETERS to see which attributes
can be changed with the SET action.

An action type of PRINT is used for any action command that begins with
PRINT (It must be in upper case and start at the first character of the action
string). An action type of STRING is used for any command that begins with
STRING. An action type of ASSIGN is used for any command that begins with
the word ASSIGN. An action type of SET is used for any command that
begins with SET.
An action type of SYSTEM is used for any command that doesn't
begin with QUIT, STRING, PRINT, SET or ASSIGN or if it begins with SYSTEM.


Following are two examples of using actions.

Here is a choice object that uses its value as a parameter
for an imaginary system command, showcolor:

.nf
choice={ label=colors value="255 0 0" action="showcolor -rgb $(val)"
         item={ label=red value="255 0 0" }
         item={ label=green value="0 255 0" }
         item={ label=blue value="0 0 255" }
       }
.fi

In this next example, the list item has no action specified. Actions
default to type NONE; the list will maintain a string containing
the value of the selected list item, but will do nothing more.
Here a separate button is used to do something with the list's
output:

.nf
message={ label="press button to find out which item is selected" }
list={ label=numbers name=listout
         itemlist={ list="1 2 3"
       }
button={ label="press for answer" 
         action="PRINT list selection is $(listout)" }
.fi

In this example the assign action is used to reset the value of a dialog
to a known string (fred). The reset button assigns the string to the dialog.
The dialog itself has two actions, the first prints the value of the
text field and the second action quits xtpanel.

.nf
dialog={ label=dialog value="fred" 
         action="PRINT I am $(val)" 
         action=QUIT 
       }

button={ label=RESET action="ASSIGN dialog fred" }
.fi


In the final example the user can select a file from all the ".ps" files
in the current directory. The file is then viewed with the ghostview program:

.nf
button={ label=QUIT action=QUIT }
list={ label="Choose a file" action="ghostview $(val)" 
         itemlist={ list=`echo *.ps`  }
       }
.fi

.SH TESTS
A test consists of a condition and two sets of actions. The syntax is:
.nf
test={  condition="command string"
	true={ action=... action=.... test={ ... }  }
	false={ action=... action=.... }
}
.fi

The string specified in the \fIcondition\fP
is expanded in the usual way. It is then
passed to the system as a command to be executed. The return code from running
the command is then examined. If the return code is zero then the action[s]
specified in the \fItrue\fP construct are executed. 
If the return code is non-zero
then the action[s] specified in the \fIfalse\fP construct are executed.
The actions within the true and false objects may be simple actions or
more test objects.

The system command "test" is very useful for use in conditions. It will
evaluate its arguments and return zero if they evaluate to true and one if they
are false. See "man test" for more details.

This example compares the values of two sliders:
.nf
button={ name=QUIT action=QUIT }
slider={ name=val1 min=0 max=100 format="%.0f" }
slider={ name=val2 min=0 max=100 format="%.0f" }
button={ label=testme
     test={ condition=" test $val1 -eq $val2 "
            true={ action="PRINT values are equal \n" }
            false={ action="PRINT values are not equal \n" }
     }
}
.fi

Here is a more complicated example. It uses a test in a timer object to 
check on the
status of a background task. In this example the background task just sleeps
but it could be performing a time consuming sequnce of actions. 
Pressing the button starts the timer and runs a task in the background.
If the lockfile is present the test condition in the timer will evaluate 
to true. In this case
the button will be set to an insensitive state with a red background and
a label that says "RUNNING". When the lock file disappears the button
will be reset to its original state, and the timer will turn itself off.

.nf
button={ name=QUIT action=QUIT }
button={ name=doit
    action="SET lockcheck running 1"
    action="( touch busy.lck; sleep 6; rm busy.lck )& "
}

timer={
    name=lockcheck
    interval=1
    running=0
    test={
        condition="test -f busy.lck"
        true={
                action="SET doit label RUNNING"
                action="SET doit sensitive 0"
                action="SET doit background red"
        }
        false={
                action="SET doit label doit"
                action="SET doit sensitive 1"
                action="SET doit background white"
                action="SET lockcheck running 0"
        }
    }
}
.fi


.SH BOXES AND FORMS
Several objects are provided to manage the appearance
of the panel. These include box and  form
objects. Box objects handle the layout of the objects
within them; the form object requires the user to specify
the position of each object, either relative to the upper-left
corner of the form, or relative to another object in the form.
Whether you should use a box
or a form depends on how much control you need to have
over the panel layout.

Box objects group other objects
into boxes that are oriented either vertically or
horizontally. In a vertically oriented box, 
the objects are arranged in a single column, and then
a box is drawn around them. If space is available next
to one object (because an earlier object is very wide)
then the new object will be placed on the same row rather
than starting a new one.

A vertically oriented box
(vbox) is specified as follows:

.nf
vbox={ name=
object_type={ parameter=value ... }
object_type={ parameter=value ... }
}
.fi

All of the objects bounded by the starting and ending braces
of a box will be grouped together in the box. In addition
to vbox, there is hbox, which is oriented horizontally,
and vpane and hpane, where the objects within the box are
separated by movable partitions (these use the Athena
paned widget). There is also box and pane; these default
to vbox and vpane, but could be overridden from a resource
file.

Boxes can be nested. In this way, fairly precise control
over a panel's layout can be obtained.

Box objects can have a \fIname\fP.
Two special names are recognized by the resource
file; boxes with name=\fInoborder\fP will have no
border drawn around them. If you use boxes extensively
to arrange objects on the panel, using noborder can help
avoid the tunnel-like appearance of multiple nested boxes.
Also, one of the examples makes use of a special
box name \fIsqueezebox\fP.
This name triggers definitions in
the resource file that "squeeze out" the annotation
of sliders, choices, and buttons that are grouped together
in such a box. Boxes may also use most of the parameters
described in MISCELLANEOUS PARAMETERS, such as height,
width, and color.

Form objects group other objects into a rectangular area.
The position of each object within the area must be specified
by the user in the script file. There are two ways to
do this.
The parameters x and y can be used to
specify the location of the object's upper left corner, with
respect to the upper left corner of the form. 
Alternatively, the parameters "fromHoriz" and "fromVert" can
be used to indicated that an object is to be placed relative
to some other object. If fromHoriz or fromVert is used, then
x or y may also be specified to give the distance separating
the object from the other object to which it is connected.
If fromHoriz or fromVert are used alone, a minimum separation
of 4 pixels will be maintained between objects.

.PP
It is important
to note that when you use a form, the position \fIMUST\fP be specified
for ALL objects contained in the form. Otherwise, objects
may be placed on top of one another, and some may be invisible.

The form object provides a greater degree of control over the
panel layout. However, because it does not do default positioning
in a reasonable way as the box objects do, the form object may
yield unexpected results if not used carefully. You should
avoid the form object unless the layout obtainable with boxes
is not sufficiently accurate. 
There is an example of a script
using a form in the xtpanel-examples example demo. Under
the script examples, see the example named "form".

If a form contains a box, coordinates must be specified for the
box itself, but are not needed for objects within the box, as the
box object manages the layout within itself.

The top-level xtpanel object is by default a box, within which
the user-specified objects are contained. By beginning a script
file with "form={", the user can effectively make the top-level
object a form instead.

Both boxes and forms are only available through xtpanel scripts.
They are not available from the command line. Boxes are supported
in the xtpanel generator, but not forms.

.SH COMMAND LINE INTERFACE
On the command line, objects are specified in the following
format:

xtpanel -object_type value value ... -object_type value...

The values must be specified in a prescribed order, as described
below for each object type. You can specify as many of the
values for a given object as you wish; the "-" on the object
type is the signal to xtpanel to stop reading parameters for
one object and begin the next. But in
order to specify a value for one parameter, you MUST specify values 
all those that precede it, in exactly the order specified here.

The values for each object are described in the section
above named DESCRIPTION OF OBJECTS AND SCRIPT SYNTAX.
Here we simply list them in the order that they
must be specified from the command line.

.nf
\-message    [value]
\-text       [action name value width height editType]
\-field      [action name value]
\-dialog     [label action name value]
\-button     [label action name value]
\-toggle     [label action name value]
\-slider     [label action name value min max format width height]
\-scrollbar  [action name value min max format width height]
\-choice     [label action name value numchoice label value ...]
\-menubutton [label action name value numchoice label value ...]
\-list       [label action name value numchoice label value ...]
\-var        [name value action]
\-startup    [action name value]
\-timer      [action interval name value running]
\-graph      [nsamp action name value min max format width height]
\-grid       [nx ny action name value xmin ymin dx dy format width height]
\-togglegrid [nx ny action name value xmin ymin dx dy format formtype \
   width height]
\-quit	     
.fi

For the multiple-choice objects (choice, menubutton, and list),
you must specify a label (which gets displayed on the screen)
and a value (used on output) for each item, and you must
precede these by the number of items in the choice,
menubutton, or list (which is not required in a script).
There is no analog
to the script "itemlist" object, which lets you specify only
one string for each item instead of two.

Note that the box and form objects described above (see BOXES AND FORMS),
used to group objects into horizontally or vertically
oriented boxes or forms, are not available from the command line.

.SH COMMAND LINE EXAMPLES
The following examples illustrate the use of xtpanel from the
command line:

This example contains a quit button and a message:

.nf
xtpanel -quit -message "this is a message"
.fi

This example contains a choice:

.nf
xtpanel -choice "this is a choice" 'PRINT choice is $val' name 1 \
3 one 1 two 2 three 3  
.fi

This example contains a slider and a button that outputs the slider's value:

.nf
xtpanel -quit -slider "this is a slider" 'PRINT slider value is $val' 
name 5 0 10 "%.0f" 100 20 -button "press me" 'PRINT slider value is $name'
.fi

Be careful with quoting on the command line. In most shells if you want to 
pass a backquoted string to xtpanel you have to put it inside single quotes
not double quotes.

This command will not work, the shell will complain about an undefined variable.
.nf
xtpanel -field  "PRINT `cat $val`" joe myfile.c 
.fi
But this should,
.nf
xtpanel -field  'PRINT `cat $val`' joe myfile.c 
.fi

.SH GENERAL COMMAND LINE OPTIONS
.TP
.B \-file filename
Read in the script file "filename". Xtpanel also looks for
a script file on stdin. The filename specified in this way is searched
for in a number of possible directories.
If the environment variable "XTPANEL_PATH" is set it is assumed to be
a colon separated list of directories to be searched. If the file is not found
in these directories the program will search a directory called .xtpanel in
the users home directory and then the system xtpanel directory.

If the environment variable is not
set the program will search the current directory, followed by ~/.xtpanel
followed by the system xtpanel directory.

The system directory is specified in the Makefile used to compile the
xtpanel program. At compilation time on this system it was set to
SYS_XTPANELDIR.

.TP
.B \-cpp [cpp_args]
If the -cpp flag is specified then all files read using the "-file" flag
will be passed though the C-preprocessor before being parsed. The preprocessor
will be invoked using any command line arguments that look like they might be
C-preprocessor arguments. Currently this is interpreted as being any argument
that starts with "-I" or "-D". Note the standard input is never passed through
cpp. If you wish to to this you should pipe the output of cpp into xtpanel
yourself.

This option can be very useful in designing system wide xtpanel scripts
where a few key words may be changed at each invocation. These words may
be redefined with "-Doldname=newname". This can also be done using variables
and it is probaly more efficient to do so. The -cpp option can also be used to
define macros for repeated parts of script files or even including prebuilt
pieces of script files from elsewhere. The following example illustrates
some of these possibilities.

.nf
#ifndef NAME
#define NAME "default name"
#endif

#define mkslid(VAL) slider={ label="" min=0 max=100 value=VAL 
width=300 height=25 format="%.0f" action="STRING $val" }

label={ value=NAME }

mkslid(0)
mkslid(10)
mkslid(20)
.fi

.TP
.B \-help
Invokes a series of xtpanel scripts that present information
about xtpanel, mostly taken from this manual page, in an
interactive, menu-driven form.

.TP
.B \-tty
Read a script from the terminal. Generally not recommended;
it is better to save the script in a file first. If this option
is not set the program will not accept input from standard input if
it is a terminal. You can redirect standard input and pipe data to
xtpanel without setting this option.

.SH RESOURCES
All widgets are constructed using the "name" parameter of the object.
The X-toolkit resource mechanism can be used to control the appearance
of an object based on either its class or its name.
The xtpanel objects are constructed from Xaw widget classes as follows:

.IP message 10 
is a Label widget
.IP button 10
is a Command widget
.IP toggle 10
is a Toggle widget
.IP text 10
is a Text widget
.IP field 10
is a Text widget
.IP dialog 10
is a Dialog widget
.IP scrollbar 10
is a Scrollbar widget.
.IP slider 10
is a Box containing three Labels and a Scrollbar.
.IP choice 10
is a Box containing a Label and a number of Toggles.
.IP menubutton 10
is a MenuButton. Attached to it is a SimpleMenu, with a
number of SmeBSB menu entries.
.IP list 10
is a Form containing a Label and a List.
.IP graph 10
is a Form containing a number of Scollbars
.IP grid 10
is a Form containing a number of Command widgets
.IP togglegrid 10
is a Form containing a number of Toggle widgets
.IP box 10
is a Box widget.
.IP form 10
is a Form widget.

If I have the following xtpanel script file:

button={ label=QUIT action=QUIT }

box={ name=bigfont
      button={ label=fred action="PRINT fred" }
      button={ label=joe name=curs action="PRINT joe" }
}

and the following resources:

XTpanel*Command.Font: fixed
XTpanel*bigfont*Command.Font: 8x16
XTpanel*bigfont*curs.Font: cursor

Then the quit button will use the "fixed" font, fred will use "8x16" and
joe will use "cursor" (and thus be unreadable).

.SH COPYRIGHT
Although xtpanel is not in the public domain, its copyright is not
very restrictive. Here is the official xtpanel copyright notice (the one
that all the source files tell you about):
.PP
Copyright 1992, 1993 the Board of Trustees of the Leland Stanford Junior
University.  All Rights Reserved.  Permission is hereby given
to use, copy, modify, and distribute this software provided
that (1) copyright and proprietary notices are retained in
each copy, (2) any files which are modified are identified as such,
and (3) you do not copy or distribute the software for payment or
for commercial use without prior written consent from Stanford.
STANFORD MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND
concerning this software or its use.

.SH BUGS
Probably many. Please send bug reports, suggestions,
interesting xtpanel scripts, code to support new widgets, etc.
to the authors.


.SH AUTHORS
Steve Cole (steve@sep.stanford.edu)
.br
Dave Nichols (dave@sep.stanford.edu)
.br
Stanford Exploration Project, Department of Geophysics
.br
Stanford University, Stanford, CA, 94305-2215
