extern char *malloc(), *realloc();

# line 43 "gram.y"
#include <stdio.h>
#include <ctype.h>
#include "twm.h"
#include "menus.h"
#include "list.h"
#include "util.h"
#include "screen.h"
#include "parse.h"
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>

static char *Action = "";
static char *Name = "";
static MenuRoot	*root, *pull = NULL;
static char *curWorkSpc;
static char *client, *workspace;
static MenuItem *lastmenuitem = (MenuItem*) 0;

static MenuRoot *GetRoot();

static Bool CheckWarpScreenArg(), CheckWarpRingArg();
static Bool CheckColormapArg();
static void GotButton(), GotKey(), GotTitleButton();
static char *ptr;
static name_list **list;
static int cont = 0;
static int color;
int mods = 0;
unsigned int mods_used = (ShiftMask | ControlMask | Mod1Mask);

extern int do_single_keyword(), do_string_keyword(), do_number_keyword();
extern name_list **do_colorlist_keyword();
extern int do_color_keyword(), do_string_savecolor();
extern int yylineno;

# line 79 "gram.y"
typedef union 
{
    int num;
    char *ptr;
} YYSTYPE;
# define LB 257
# define RB 258
# define LP 259
# define RP 260
# define MENUS 261
# define MENU 262
# define BUTTON 263
# define DEFAULT_FUNCTION 264
# define PLUS 265
# define MINUS 266
# define ALL 267
# define OR 268
# define CURSORS 269
# define PIXMAPS 270
# define ICONS 271
# define COLOR 272
# define SAVECOLOR 273
# define MONOCHROME 274
# define FUNCTION 275
# define ICONMGR_SHOW 276
# define ICONMGR 277
# define WINDOW_FUNCTION 278
# define ZOOM 279
# define ICONMGRS 280
# define ICONMGR_GEOMETRY 281
# define ICONMGR_NOSHOW 282
# define MAKE_TITLE 283
# define ICONIFY_BY_UNMAPPING 284
# define DONT_ICONIFY_BY_UNMAPPING 285
# define NO_ICON_TITLE 286
# define NO_TITLE 287
# define AUTO_RAISE 288
# define NO_HILITE 289
# define ICON_REGION 290
# define META 291
# define SHIFT 292
# define LOCK 293
# define CONTROL 294
# define WINDOW 295
# define TITLE 296
# define ICON 297
# define ROOT 298
# define FRAME 299
# define COLON 300
# define EQUALS 301
# define SQUEEZE_TITLE 302
# define DONT_SQUEEZE_TITLE 303
# define START_ICONIFIED 304
# define NO_TITLE_HILITE 305
# define TITLE_HILITE 306
# define MOVE 307
# define RESIZE 308
# define WAITC 309
# define SELECT 310
# define KILL 311
# define LEFT_TITLEBUTTON 312
# define RIGHT_TITLEBUTTON 313
# define NUMBER 314
# define KEYWORD 315
# define NKEYWORD 316
# define CKEYWORD 317
# define CLKEYWORD 318
# define FKEYWORD 319
# define FSKEYWORD 320
# define SKEYWORD 321
# define DKEYWORD 322
# define JKEYWORD 323
# define WINDOW_RING 324
# define WARP_CURSOR 325
# define ERRORTOKEN 326
# define NO_STACKMODE 327
# define WORKSPACE 328
# define WORKSPACES 329
# define WORKSPCMGR_GEOMETRY 330
# define OCCUPYALL 331
# define OCCUPYLIST 332
# define MAPWINDOWCURRENTWORKSPACE 333
# define MAPWINDOWDEFAULTWORKSPACE 334
# define OPAQUEMOVE 335
# define NOOPAQUEMOVE 336
# define OPAQUERESIZE 337
# define NOOPAQUERESIZE 338
# define STRING 339
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 792 "gram.y"

yyerror(s) char *s;
{
    twmrc_error_prefix();
    fprintf (stderr, "error in input file:  %s\n", s ? s : "");
    ParseError = 1;
}
RemoveDQuote(str)
char *str;
{
    register char *i, *o;
    register n;
    register count;

    for (i=str+1, o=str; *i && *i != '\"'; o++)
    {
	if (*i == '\\')
	{
	    switch (*++i)
	    {
	    case 'n':
		*o = '\n';
		i++;
		break;
	    case 'b':
		*o = '\b';
		i++;
		break;
	    case 'r':
		*o = '\r';
		i++;
		break;
	    case 't':
		*o = '\t';
		i++;
		break;
	    case 'f':
		*o = '\f';
		i++;
		break;
	    case '0':
		if (*++i == 'x')
		    goto hex;
		else
		    --i;
	    case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		n = 0;
		count = 0;
		while (*i >= '0' && *i <= '7' && count < 3)
		{
		    n = (n<<3) + (*i++ - '0');
		    count++;
		}
		*o = n;
		break;
	    hex:
	    case 'x':
		n = 0;
		count = 0;
		while (i++, count++ < 2)
		{
		    if (*i >= '0' && *i <= '9')
			n = (n<<4) + (*i - '0');
		    else if (*i >= 'a' && *i <= 'f')
			n = (n<<4) + (*i - 'a') + 10;
		    else if (*i >= 'A' && *i <= 'F')
			n = (n<<4) + (*i - 'A') + 10;
		    else
			break;
		}
		*o = n;
		break;
	    case '\n':
		i++;	/* punt */
		o--;	/* to account for o++ at end of loop */
		break;
	    case '\"':
	    case '\'':
	    case '\\':
	    default:
		*o = *i++;
		break;
	    }
	}
	else
	    *o = *i++;
    }
    *o = '\0';
}

static MenuRoot *GetRoot(name, fore, back)
char *name;
char *fore, *back;
{
    MenuRoot *tmp;

    tmp = FindMenuRoot(name);
    if (tmp == NULL)
	tmp = NewMenuRoot(name);

    if (fore)
    {
	int save;

	save = Scr->FirstTime;
	Scr->FirstTime = TRUE;
	GetColor(COLOR, &tmp->highlight.fore, fore);
	GetColor(COLOR, &tmp->highlight.back, back);
	Scr->FirstTime = save;
    }

    return tmp;
}

static void GotButton(butt, func)
int butt, func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0)
	    continue;

	if (Scr->Mouse[butt][i][mods] == NULL)
	    Scr->Mouse[butt][i][mods] = (MouseButton*) malloc (sizeof (MouseButton));
	Scr->Mouse[butt][i][mods]->func = func;
	if (func == F_MENU)
	{
	    pull->prev = NULL;
	    Scr->Mouse[butt][i][mods]->menu = pull;
	}
	else
	{
	    root = GetRoot(TWM_ROOT, NULLSTR, NULLSTR);
	    Scr->Mouse[butt][i][mods]->item = AddToMenu(root,"x",Action,
		    NULLSTR, func, NULLSTR, NULLSTR);
	}
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}

static void GotKey(key, func)
char *key;
int func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0) 
	  continue;
	if (!AddFuncKey(key, i, mods, func, Name, Action)) 
	  break;
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}


static void GotTitleButton (bitmapname, func, rightside)
    char *bitmapname;
    int func;
    Bool rightside;
{
    if (!CreateTitleButton (bitmapname, func, Action, pull, rightside, True)) {
	twmrc_error_prefix();
	fprintf (stderr, 
		 "unable to create %s titlebutton \"%s\"\n",
		 rightside ? "right" : "left", bitmapname);
    }
    Action = "";
    pull = NULL;
}

static Bool CheckWarpScreenArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0 ||
	strcmp (s,  WARPSCREEN_BACK) == 0)
      return True;

    for (; *s && isascii(*s) && isdigit(*s); s++) ; /* SUPPRESS 530 */
    return (*s ? False : True);
}


static Bool CheckWarpRingArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0)
      return True;

    return False;
}


static Bool CheckColormapArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s, COLORMAP_NEXT) == 0 ||
	strcmp (s, COLORMAP_PREV) == 0 ||
	strcmp (s, COLORMAP_DEFAULT) == 0)
      return True;

    return False;
}


twmrc_error_prefix ()
{
    fprintf (stderr, "%s:  line %d:  ", ProgramName, yylineno);
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 0,
-1, 17,
	257, 20,
	-2, 22,
-1, 18,
	257, 23,
	-2, 25,
-1, 19,
	257, 26,
	-2, 28,
-1, 20,
	257, 29,
	-2, 31,
-1, 21,
	257, 32,
	-2, 34,
-1, 30,
	257, 47,
	-2, 49,
-1, 33,
	257, 54,
	-2, 56,
-1, 34,
	257, 57,
	-2, 59,
-1, 35,
	257, 60,
	-2, 62,
-1, 36,
	257, 63,
	-2, 65,
-1, 37,
	257, 66,
	-2, 68,
-1, 40,
	257, 73,
	-2, 75,
-1, 49,
	257, 91,
	-2, 93,
-1, 54,
	257, 178,
	-2, 177,
-1, 55,
	257, 181,
	-2, 180,
-1, 200,
	257, 194,
	-2, 193,
-1, 315,
	257, 165,
	-2, 164,
	};
# define YYNPROD 254
# define YYLAST 512
int yyact[]={

    25,    79,   208,   297,   298,   361,   214,   201,   353,   340,
    58,    59,    60,   295,   337,    66,   308,   264,   262,    83,
   259,   252,   246,    76,    77,    78,   236,   296,   222,   220,
   198,   290,   291,   292,   293,   294,   288,    81,    82,   169,
    57,   167,   103,   104,   204,    57,   317,   166,   119,   110,
   111,    66,   331,   114,   311,   335,   336,    57,    81,    82,
   171,   302,   133,   122,   365,   123,   217,   255,   196,   153,
   132,   329,   319,   318,    85,    57,   357,   205,   249,   209,
   348,   326,   303,   134,   301,   211,    57,    57,    57,    57,
    57,   192,   193,   194,   195,    57,   127,    57,    57,    57,
   197,    57,    57,    57,    66,   196,   164,    57,   173,    57,
    57,    57,    81,    82,   174,    81,    82,   159,   184,   180,
    57,   157,    57,   168,   170,   143,   258,   257,   192,   193,
   194,   195,   108,   179,   188,   189,    65,   190,    91,   200,
    88,   203,    70,    68,    64,    62,   158,   309,   250,   312,
   251,   135,   177,   178,   207,   176,   253,   212,   354,   343,
   341,   216,   323,   181,   182,   183,   185,   186,   325,   221,
   305,   223,   304,   243,   224,   202,   140,   225,   226,   227,
   228,   229,   230,   231,   232,   233,   234,   235,   238,   237,
   115,   187,   338,   118,   322,   300,   120,   121,   242,   199,
   138,   247,   206,   117,   218,   244,   245,   248,   116,   362,
   358,   215,   160,   254,   347,   286,   287,   332,   256,   260,
   213,   175,   263,   125,   265,   284,   266,   267,   268,   269,
   270,   271,   272,   273,   274,   275,   276,   136,   172,   285,
   124,   289,   299,   279,   280,   281,   282,   283,   277,   306,
   307,   310,   278,   313,   191,   314,   161,   241,   315,   316,
   239,   113,   112,   109,   107,   106,   156,   105,   210,   155,
   154,   345,   102,   101,   100,    99,    98,    97,    96,   320,
    95,    94,   142,    93,    92,    90,    89,    87,    86,    75,
   321,    74,    73,    72,    71,    69,    67,    63,    61,     8,
     7,     6,     5,   219,     3,     2,     1,   328,    84,    80,
   333,    24,   330,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   339,   342,     0,     0,     0,     0,   240,
     0,     0,   346,     0,     0,     0,     0,     0,     0,     0,
   352,     0,     0,     0,   355,     0,     0,     0,   356,     0,
     0,     0,     0,   359,     0,     4,   261,     0,   360,   363,
   364,    41,    56,    47,   366,   367,   324,   368,    16,    15,
    43,    44,    45,    46,    42,    32,     0,    48,    14,    31,
    10,    30,    38,    17,    26,    36,    37,    40,    34,     9,
     0,     0,     0,   126,     0,     0,     0,     0,     0,     0,
     0,    54,    55,    39,    33,     0,     0,     0,     0,     0,
     0,    22,    23,     0,    51,    53,     0,     0,     0,     0,
    52,     0,     0,    50,    49,     0,    35,     0,    27,    11,
    28,    29,    12,    13,    18,    19,    20,    21,    57,     0,
     0,     0,     0,   327,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   334,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   344,   128,   129,   130,   131,
   349,     0,   350,   351,     0,     0,     0,     0,     0,     0,
   137,     0,     0,   139,     0,     0,   141,     0,   144,   145,
   146,   147,   148,   149,   150,   151,   152,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   162,   163,     0,     0,
     0,   165 };
int yypact[]={

 -1000, -1000,    99, -1000, -1000, -1000, -1000, -1000, -1000,  -294,
  -294,  -294,  -112,  -113,  -263,  -114,  -115, -1000, -1000, -1000,
 -1000, -1000,  -294,  -294,  -282,  -227, -1000,  -117, -1000,  -119,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,  -294,  -294, -1000, -1000,  -125, -1000,  -261,  -261, -1000,
 -1000, -1000,  -294,  -263, -1000, -1000,  -263, -1000,  -274,  -263,
  -263, -1000,  -294, -1000,  -294, -1000, -1000, -1000, -1000, -1000,
 -1000,  -161,  -161,  -161,  -161,  -161,  -231,  -239, -1000, -1000,
 -1000, -1000,  -294, -1000, -1000, -1000,  -161, -1000, -1000,  -161,
 -1000, -1000,  -161,  -132,  -161,  -161,  -161,  -161,  -161,  -161,
  -161,  -161,  -161,  -190, -1000,  -136,  -140, -1000, -1000,  -140,
 -1000, -1000,  -161,  -161, -1000, -1000,  -151,  -161, -1000,  -275,
 -1000, -1000,  -217,  -219,  -198,  -144, -1000, -1000, -1000, -1000,
 -1000, -1000,  -261,  -261, -1000,  -163,  -200, -1000,  -228, -1000,
  -251, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -294,  -178,  -172, -1000, -1000, -1000, -1000,
  -252, -1000, -1000, -1000, -1000, -1000,  -263, -1000,  -229, -1000,
  -230, -1000, -1000,  -294, -1000, -1000,  -294,  -294,  -294,  -294,
  -294,  -294,  -294,  -294,  -294,  -294,  -294,  -232, -1000, -1000,
 -1000, -1000,  -263, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -294,  -294,  -236,  -222, -1000, -1000,
 -1000, -1000,  -237,  -191, -1000, -1000, -1000, -1000,  -238,  -263,
 -1000,  -240, -1000,  -241, -1000,  -294,  -294,  -294,  -294,  -294,
  -294,  -294,  -294,  -294,  -294,  -294, -1000, -1000, -1000,   -52,
 -1000,  -264,  -173,  -175, -1000, -1000, -1000, -1000,  -294,  -294,
  -242,  -204, -1000, -1000,  -294, -1000, -1000,  -294,  -294, -1000,
  -277, -1000, -1000,  -185, -1000,  -186, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -261, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -261, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -175,  -176,  -299,  -189, -1000, -1000,
  -207, -1000, -1000, -1000, -1000, -1000, -1000,  -210, -1000, -1000,
 -1000, -1000,  -244,  -249, -1000, -1000, -1000, -1000,  -263, -1000,
 -1000,  -294,  -177,  -263, -1000,  -263,  -263, -1000, -1000,  -294,
 -1000, -1000, -1000,  -250, -1000,  -178,  -224, -1000, -1000, -1000,
 -1000, -1000,  -294, -1000, -1000, -1000, -1000,  -294,  -253,  -294,
  -196, -1000, -1000,  -294,  -294,  -261, -1000, -1000, -1000 };
int yypgo[]={

     0,     0,     1,   311,   136,   310,   309,   308,   306,   305,
   304,   302,   301,   300,   299,   298,   297,   296,   295,   294,
   393,   293,   292,   291,   289,   288,   287,   286,   285,   284,
   283,   282,   281,   280,   278,   277,   276,   275,   274,   273,
   272,   271,     2,   270,   269,   268,   267,   266,   265,   146,
   264,   263,   262,   261,   151,   260,   257,   254,   252,   241,
   240,   238,   223,   221,   220,   218,   217,   214,   212,   211,
   210,   209,   208,   204,   203,   202,   201,   200,   199,   198,
   195,   194,   192,   191,   189,   176,   175,   173,    61,   172,
   170,   168,   162,   160,   159,   158,   157,   156,   150,   149,
   148,   147 };
int yyr1[]={

     0,     8,     9,     9,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    19,    10,    10,    21,    10,    10,    22,    10,    10,    23,
    10,    10,    24,    10,    10,    10,    10,    10,    10,    10,
    10,    25,    10,    10,    27,    10,    10,    29,    10,    10,
    30,    10,    32,    10,    33,    10,    10,    34,    10,    10,
    35,    10,    10,    36,    10,    10,    37,    10,    10,    38,
    10,    39,    10,    40,    10,    10,    41,    10,    43,    10,
    44,    10,    46,    10,    48,    10,    10,    51,    10,    10,
    10,    52,    10,    10,    53,    10,    11,    12,    13,     6,
     7,    54,    54,    57,    57,    57,    57,    57,    57,    55,
    55,    58,    58,    58,    58,    58,    58,    58,    58,    58,
    56,    56,    59,    59,    59,    59,    59,    59,    59,    59,
    59,    59,    17,    60,    60,    61,    18,    62,    62,    63,
    63,    63,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    63,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    49,    64,    64,    65,    66,    65,    65,    50,    68,
    68,    69,    69,    67,    70,    70,    71,    14,    72,    14,
    14,    74,    14,    73,    73,    31,    75,    75,    76,    76,
    26,    77,    77,    78,    79,    78,    80,    81,    81,    82,
    82,    82,    82,    82,    15,    15,    15,    15,    16,    16,
    16,    16,    20,    83,    83,    84,    28,    85,    85,    87,
    86,    89,    86,    90,    86,    88,    92,    92,    93,    91,
    94,    94,    95,    47,    96,    96,    97,    45,    98,    98,
    99,    42,   100,   100,   101,   101,     2,     2,     5,     5,
     5,     3,     1,     4 };
int yyr2[]={

     0,     2,     0,     4,     2,     2,     2,     2,     2,    13,
     7,     5,     7,     5,     4,     4,     5,     3,     5,     5,
     1,     6,     3,     1,     6,     3,     1,     6,     3,     1,
     6,     3,     1,     6,     3,     9,     9,     5,     5,     5,
     5,     1,     6,     4,     1,     6,     4,     1,     6,     3,
     1,     6,     1,     6,     1,     6,     3,     1,     6,     3,
     1,     6,     3,     1,     6,     3,     1,     6,     3,     1,
     6,     1,     6,     1,     6,     3,     1,    19,     1,     9,
     1,     8,     1,     6,     1,     6,     4,     1,     6,     5,
     5,     1,     6,     3,     1,     6,     3,     5,     5,    13,
    13,     0,     4,     3,     3,     3,     3,     5,     3,     0,
     4,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     0,     4,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     6,     0,     4,     5,     6,     0,     4,     7,
     5,     7,     5,     7,     5,     7,     5,     7,     5,     7,
     5,     7,     5,     7,     5,     7,     5,     7,     5,     7,
     5,     6,     0,     4,     5,     1,     8,     5,     6,     0,
     4,     3,     3,     6,     0,     4,     5,     3,     1,    10,
     3,     1,     6,     0,    11,     6,     0,     4,     7,     9,
     6,     0,     4,     3,     1,     6,     6,     0,     4,     3,
     5,     7,     9,    11,     7,     9,    11,    13,     7,     9,
    11,    13,     6,     0,     4,     3,     6,     0,     4,     1,
     6,     1,     8,     1,     8,     6,     0,     4,     3,     6,
     0,     4,     3,     6,     0,     4,     5,     6,     0,     4,
     3,     7,     0,     4,     5,    15,     3,     5,     3,     5,
     5,     5,     3,     3 };
int yychk[]={

 -1000,    -8,    -9,   -10,   256,   -11,   -12,   -13,   -14,   290,
   281,   330,   333,   334,   279,   270,   269,   284,   335,   336,
   337,   338,   312,   313,    -3,    -1,   285,   329,   331,   332,
   282,   280,   276,   305,   289,   327,   286,   287,   283,   304,
   288,   262,   275,   271,   272,   273,   274,   264,   278,   325,
   324,   315,   321,   316,   302,   303,   263,   339,    -1,    -1,
    -1,   -15,   257,   -16,   257,    -4,   314,   -17,   257,   -18,
   257,   -19,   -21,   -22,   -23,   -24,    -1,    -1,    -1,    -2,
    -6,   319,   320,   301,    -7,   301,   -25,   -26,   257,   -27,
   -28,   257,   -29,   -30,   -32,   -33,   -34,   -35,   -36,   -37,
   -38,   -39,   -40,    -1,    -1,   -46,   -48,   -50,   257,   -51,
    -2,    -2,   -52,   -53,    -1,    -4,   -72,   -74,    -4,   322,
    -4,    -4,    -1,    -1,   -60,   -62,   -20,   257,   -20,   -20,
   -20,   -20,   301,   301,    -1,   -54,   -54,   -20,   -77,   -20,
   -85,   -20,   -31,   257,   -20,   -20,   -20,   -20,   -20,   -20,
   -20,   -20,   -20,   259,   -43,   -44,   -47,   257,   -49,   257,
   -68,   -49,   -20,   -20,   257,   -20,   322,   258,    -1,   258,
    -1,   258,   -61,   306,   258,   -63,   299,   296,   297,   277,
   263,   307,   308,   309,   262,   310,   311,   -83,    -2,    -2,
   300,   -57,   291,   292,   293,   294,   268,   300,   258,   -78,
    -1,   258,   -86,    -1,   295,   328,   -75,    -1,   -42,   257,
   -45,   257,   -96,   -64,   258,   -69,    -1,   318,   -73,    -4,
   258,    -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   258,   -84,    -1,   -55,
    -4,   -56,   -79,   -87,    -1,    -1,   258,   -76,    -1,   300,
  -100,   -98,   258,   -97,    -1,   258,   -65,   318,   317,   258,
    -1,    -4,   258,    -1,   258,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   300,   -58,   295,
   296,   297,   298,   299,   277,   291,   267,   268,   300,   -59,
   295,   296,   297,   298,   299,   277,   291,   267,   268,    -1,
   -80,   257,   -88,   257,   -89,   -90,    -1,    -1,   258,  -101,
    -1,   258,   -99,    -2,    -1,    -1,    -1,   323,   258,   258,
    -2,    -2,   -81,   -92,   -88,   -91,   257,    -4,    -1,   260,
    -2,   259,   -66,    -5,    -4,   265,   266,   258,   -82,    -1,
   258,   -93,    -1,   -94,    -4,   -41,    -1,   -67,   257,    -4,
    -4,    -4,    -1,   258,   -95,    -1,   -42,   300,   -70,    -1,
    -1,   258,   -71,    -1,    -1,   260,    -1,    -1,    -2 };
int yydef[]={

     2,    -2,    -2,     3,     4,     5,     6,     7,     8,     0,
     0,     0,     0,     0,    17,     0,     0,    -2,    -2,    -2,
    -2,    -2,     0,     0,     0,     0,    41,     0,    44,     0,
    -2,    50,    52,    -2,    -2,    -2,    -2,    -2,    69,    71,
    -2,     0,     0,    82,    84,     0,    87,     0,     0,    -2,
    94,    96,     0,     0,    -2,    -2,     0,   252,     0,    11,
    13,    14,     0,    15,     0,    16,   253,    18,   133,    19,
   137,     0,     0,     0,     0,     0,     0,     0,    37,    38,
    40,   246,     0,   101,    39,   101,     0,    43,   191,     0,
    46,   217,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    78,    80,     0,     0,    86,   169,     0,
    89,    90,     0,     0,    97,    98,     0,     0,   251,     0,
    10,    12,     0,     0,     0,     0,    21,   213,    24,    27,
    30,    33,     0,     0,   247,     0,     0,    42,     0,    45,
     0,    48,    51,   186,    53,    55,    58,    61,    64,    67,
    70,    72,    74,     0,     0,     0,    83,   234,    85,   162,
     0,    88,    92,    95,   183,   182,     0,   204,     0,   208,
     0,   132,   134,     0,   136,   138,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
   109,   102,   103,   104,   105,   106,   108,   120,   190,   192,
    -2,   216,   218,   219,     0,     0,     0,     0,    79,   242,
    81,   238,     0,     0,   168,   170,   171,   172,     0,     0,
   205,     0,   209,     0,   135,   140,   142,   144,   146,   148,
   150,   152,   154,   156,   158,   160,   212,   214,   215,     0,
   107,     0,     0,     0,   221,   223,   185,   187,     0,     0,
     0,     0,   233,   235,     0,   161,   163,     0,     0,   179,
     0,     9,   206,     0,   210,     0,   139,   141,   143,   145,
   147,   149,   151,   153,   155,   157,   159,     0,   110,   111,
   112,   113,   114,   115,   116,   117,   118,   119,     0,   121,
   122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
   195,   197,   220,   226,     0,     0,     0,     0,   241,   243,
     0,   237,   239,   240,   236,    -2,   167,     0,   207,   211,
    99,   100,     0,     0,   222,   224,   230,   188,     0,    76,
   244,     0,     0,     0,   248,     0,     0,   196,   198,   199,
   225,   227,   228,     0,   189,     0,     0,   166,   174,   184,
   249,   250,   200,   229,   231,   232,    77,     0,     0,   201,
     0,   173,   175,     0,   202,     0,   176,   203,   245 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"LB",	257,
	"RB",	258,
	"LP",	259,
	"RP",	260,
	"MENUS",	261,
	"MENU",	262,
	"BUTTON",	263,
	"DEFAULT_FUNCTION",	264,
	"PLUS",	265,
	"MINUS",	266,
	"ALL",	267,
	"OR",	268,
	"CURSORS",	269,
	"PIXMAPS",	270,
	"ICONS",	271,
	"COLOR",	272,
	"SAVECOLOR",	273,
	"MONOCHROME",	274,
	"FUNCTION",	275,
	"ICONMGR_SHOW",	276,
	"ICONMGR",	277,
	"WINDOW_FUNCTION",	278,
	"ZOOM",	279,
	"ICONMGRS",	280,
	"ICONMGR_GEOMETRY",	281,
	"ICONMGR_NOSHOW",	282,
	"MAKE_TITLE",	283,
	"ICONIFY_BY_UNMAPPING",	284,
	"DONT_ICONIFY_BY_UNMAPPING",	285,
	"NO_ICON_TITLE",	286,
	"NO_TITLE",	287,
	"AUTO_RAISE",	288,
	"NO_HILITE",	289,
	"ICON_REGION",	290,
	"META",	291,
	"SHIFT",	292,
	"LOCK",	293,
	"CONTROL",	294,
	"WINDOW",	295,
	"TITLE",	296,
	"ICON",	297,
	"ROOT",	298,
	"FRAME",	299,
	"COLON",	300,
	"EQUALS",	301,
	"SQUEEZE_TITLE",	302,
	"DONT_SQUEEZE_TITLE",	303,
	"START_ICONIFIED",	304,
	"NO_TITLE_HILITE",	305,
	"TITLE_HILITE",	306,
	"MOVE",	307,
	"RESIZE",	308,
	"WAITC",	309,
	"SELECT",	310,
	"KILL",	311,
	"LEFT_TITLEBUTTON",	312,
	"RIGHT_TITLEBUTTON",	313,
	"NUMBER",	314,
	"KEYWORD",	315,
	"NKEYWORD",	316,
	"CKEYWORD",	317,
	"CLKEYWORD",	318,
	"FKEYWORD",	319,
	"FSKEYWORD",	320,
	"SKEYWORD",	321,
	"DKEYWORD",	322,
	"JKEYWORD",	323,
	"WINDOW_RING",	324,
	"WARP_CURSOR",	325,
	"ERRORTOKEN",	326,
	"NO_STACKMODE",	327,
	"WORKSPACE",	328,
	"WORKSPACES",	329,
	"WORKSPCMGR_GEOMETRY",	330,
	"OCCUPYALL",	331,
	"OCCUPYLIST",	332,
	"MAPWINDOWCURRENTWORKSPACE",	333,
	"MAPWINDOWDEFAULTWORKSPACE",	334,
	"OPAQUEMOVE",	335,
	"NOOPAQUEMOVE",	336,
	"OPAQUERESIZE",	337,
	"NOOPAQUERESIZE",	338,
	"STRING",	339,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"twmrc : stmts",
	"stmts : /* empty */",
	"stmts : stmts stmt",
	"stmt : error",
	"stmt : noarg",
	"stmt : sarg",
	"stmt : narg",
	"stmt : squeeze",
	"stmt : ICON_REGION string DKEYWORD DKEYWORD number number",
	"stmt : ICONMGR_GEOMETRY string number",
	"stmt : ICONMGR_GEOMETRY string",
	"stmt : WORKSPCMGR_GEOMETRY string number",
	"stmt : WORKSPCMGR_GEOMETRY string",
	"stmt : MAPWINDOWCURRENTWORKSPACE curwork",
	"stmt : MAPWINDOWDEFAULTWORKSPACE defwork",
	"stmt : ZOOM number",
	"stmt : ZOOM",
	"stmt : PIXMAPS pixmap_list",
	"stmt : CURSORS cursor_list",
	"stmt : ICONIFY_BY_UNMAPPING",
	"stmt : ICONIFY_BY_UNMAPPING win_list",
	"stmt : ICONIFY_BY_UNMAPPING",
	"stmt : OPAQUEMOVE",
	"stmt : OPAQUEMOVE win_list",
	"stmt : OPAQUEMOVE",
	"stmt : NOOPAQUEMOVE",
	"stmt : NOOPAQUEMOVE win_list",
	"stmt : NOOPAQUEMOVE",
	"stmt : OPAQUERESIZE",
	"stmt : OPAQUERESIZE win_list",
	"stmt : OPAQUERESIZE",
	"stmt : NOOPAQUERESIZE",
	"stmt : NOOPAQUERESIZE win_list",
	"stmt : NOOPAQUERESIZE",
	"stmt : LEFT_TITLEBUTTON string EQUALS action",
	"stmt : RIGHT_TITLEBUTTON string EQUALS action",
	"stmt : button string",
	"stmt : button action",
	"stmt : string fullkey",
	"stmt : button full",
	"stmt : DONT_ICONIFY_BY_UNMAPPING",
	"stmt : DONT_ICONIFY_BY_UNMAPPING win_list",
	"stmt : WORKSPACES workspc_list",
	"stmt : OCCUPYALL",
	"stmt : OCCUPYALL win_list",
	"stmt : OCCUPYLIST occupy_list",
	"stmt : ICONMGR_NOSHOW",
	"stmt : ICONMGR_NOSHOW win_list",
	"stmt : ICONMGR_NOSHOW",
	"stmt : ICONMGRS",
	"stmt : ICONMGRS iconm_list",
	"stmt : ICONMGR_SHOW",
	"stmt : ICONMGR_SHOW win_list",
	"stmt : NO_TITLE_HILITE",
	"stmt : NO_TITLE_HILITE win_list",
	"stmt : NO_TITLE_HILITE",
	"stmt : NO_HILITE",
	"stmt : NO_HILITE win_list",
	"stmt : NO_HILITE",
	"stmt : NO_STACKMODE",
	"stmt : NO_STACKMODE win_list",
	"stmt : NO_STACKMODE",
	"stmt : NO_ICON_TITLE",
	"stmt : NO_ICON_TITLE win_list",
	"stmt : NO_ICON_TITLE",
	"stmt : NO_TITLE",
	"stmt : NO_TITLE win_list",
	"stmt : NO_TITLE",
	"stmt : MAKE_TITLE",
	"stmt : MAKE_TITLE win_list",
	"stmt : START_ICONIFIED",
	"stmt : START_ICONIFIED win_list",
	"stmt : AUTO_RAISE",
	"stmt : AUTO_RAISE win_list",
	"stmt : AUTO_RAISE",
	"stmt : MENU string LP string COLON string RP",
	"stmt : MENU string LP string COLON string RP menu",
	"stmt : MENU string",
	"stmt : MENU string menu",
	"stmt : FUNCTION string",
	"stmt : FUNCTION string function",
	"stmt : ICONS",
	"stmt : ICONS icon_list",
	"stmt : COLOR",
	"stmt : COLOR color_list",
	"stmt : SAVECOLOR save_color_list",
	"stmt : MONOCHROME",
	"stmt : MONOCHROME color_list",
	"stmt : DEFAULT_FUNCTION action",
	"stmt : WINDOW_FUNCTION action",
	"stmt : WARP_CURSOR",
	"stmt : WARP_CURSOR win_list",
	"stmt : WARP_CURSOR",
	"stmt : WINDOW_RING",
	"stmt : WINDOW_RING win_list",
	"noarg : KEYWORD",
	"sarg : SKEYWORD string",
	"narg : NKEYWORD number",
	"full : EQUALS keys COLON contexts COLON action",
	"fullkey : EQUALS keys COLON contextkeys COLON action",
	"keys : /* empty */",
	"keys : keys key",
	"key : META",
	"key : SHIFT",
	"key : LOCK",
	"key : CONTROL",
	"key : META number",
	"key : OR",
	"contexts : /* empty */",
	"contexts : contexts context",
	"context : WINDOW",
	"context : TITLE",
	"context : ICON",
	"context : ROOT",
	"context : FRAME",
	"context : ICONMGR",
	"context : META",
	"context : ALL",
	"context : OR",
	"contextkeys : /* empty */",
	"contextkeys : contextkeys contextkey",
	"contextkey : WINDOW",
	"contextkey : TITLE",
	"contextkey : ICON",
	"contextkey : ROOT",
	"contextkey : FRAME",
	"contextkey : ICONMGR",
	"contextkey : META",
	"contextkey : ALL",
	"contextkey : OR",
	"contextkey : string",
	"pixmap_list : LB pixmap_entries RB",
	"pixmap_entries : /* empty */",
	"pixmap_entries : pixmap_entries pixmap_entry",
	"pixmap_entry : TITLE_HILITE string",
	"cursor_list : LB cursor_entries RB",
	"cursor_entries : /* empty */",
	"cursor_entries : cursor_entries cursor_entry",
	"cursor_entry : FRAME string string",
	"cursor_entry : FRAME string",
	"cursor_entry : TITLE string string",
	"cursor_entry : TITLE string",
	"cursor_entry : ICON string string",
	"cursor_entry : ICON string",
	"cursor_entry : ICONMGR string string",
	"cursor_entry : ICONMGR string",
	"cursor_entry : BUTTON string string",
	"cursor_entry : BUTTON string",
	"cursor_entry : MOVE string string",
	"cursor_entry : MOVE string",
	"cursor_entry : RESIZE string string",
	"cursor_entry : RESIZE string",
	"cursor_entry : WAITC string string",
	"cursor_entry : WAITC string",
	"cursor_entry : MENU string string",
	"cursor_entry : MENU string",
	"cursor_entry : SELECT string string",
	"cursor_entry : SELECT string",
	"cursor_entry : KILL string string",
	"cursor_entry : KILL string",
	"color_list : LB color_entries RB",
	"color_entries : /* empty */",
	"color_entries : color_entries color_entry",
	"color_entry : CLKEYWORD string",
	"color_entry : CLKEYWORD string",
	"color_entry : CLKEYWORD string win_color_list",
	"color_entry : CKEYWORD string",
	"save_color_list : LB s_color_entries RB",
	"s_color_entries : /* empty */",
	"s_color_entries : s_color_entries s_color_entry",
	"s_color_entry : string",
	"s_color_entry : CLKEYWORD",
	"win_color_list : LB win_color_entries RB",
	"win_color_entries : /* empty */",
	"win_color_entries : win_color_entries win_color_entry",
	"win_color_entry : string string",
	"squeeze : SQUEEZE_TITLE",
	"squeeze : SQUEEZE_TITLE",
	"squeeze : SQUEEZE_TITLE LB win_sqz_entries RB",
	"squeeze : DONT_SQUEEZE_TITLE",
	"squeeze : DONT_SQUEEZE_TITLE",
	"squeeze : DONT_SQUEEZE_TITLE win_list",
	"win_sqz_entries : /* empty */",
	"win_sqz_entries : win_sqz_entries string JKEYWORD signed_number number",
	"iconm_list : LB iconm_entries RB",
	"iconm_entries : /* empty */",
	"iconm_entries : iconm_entries iconm_entry",
	"iconm_entry : string string number",
	"iconm_entry : string string string number",
	"workspc_list : LB workspc_entries RB",
	"workspc_entries : /* empty */",
	"workspc_entries : workspc_entries workspc_entry",
	"workspc_entry : string",
	"workspc_entry : string",
	"workspc_entry : string workapp_list",
	"workapp_list : LB workapp_entries RB",
	"workapp_entries : /* empty */",
	"workapp_entries : workapp_entries workapp_entry",
	"workapp_entry : string",
	"workapp_entry : string string",
	"workapp_entry : string string string",
	"workapp_entry : string string string string",
	"workapp_entry : string string string string string",
	"curwork : LB string RB",
	"curwork : LB string string RB",
	"curwork : LB string string string RB",
	"curwork : LB string string string string RB",
	"defwork : LB string RB",
	"defwork : LB string string RB",
	"defwork : LB string string string RB",
	"defwork : LB string string string string RB",
	"win_list : LB win_entries RB",
	"win_entries : /* empty */",
	"win_entries : win_entries win_entry",
	"win_entry : string",
	"occupy_list : LB occupy_entries RB",
	"occupy_entries : /* empty */",
	"occupy_entries : occupy_entries occupy_entry",
	"occupy_entry : string",
	"occupy_entry : string occupy_workspc_list",
	"occupy_entry : WINDOW string",
	"occupy_entry : WINDOW string occupy_workspc_list",
	"occupy_entry : WORKSPACE string",
	"occupy_entry : WORKSPACE string occupy_window_list",
	"occupy_workspc_list : LB occupy_workspc_entries RB",
	"occupy_workspc_entries : /* empty */",
	"occupy_workspc_entries : occupy_workspc_entries occupy_workspc_entry",
	"occupy_workspc_entry : string",
	"occupy_window_list : LB occupy_window_entries RB",
	"occupy_window_entries : /* empty */",
	"occupy_window_entries : occupy_window_entries occupy_window_entry",
	"occupy_window_entry : string",
	"icon_list : LB icon_entries RB",
	"icon_entries : /* empty */",
	"icon_entries : icon_entries icon_entry",
	"icon_entry : string string",
	"function : LB function_entries RB",
	"function_entries : /* empty */",
	"function_entries : function_entries function_entry",
	"function_entry : action",
	"menu : LB menu_entries RB",
	"menu_entries : /* empty */",
	"menu_entries : menu_entries menu_entry",
	"menu_entry : string action",
	"menu_entry : string LP string COLON string RP action",
	"action : FKEYWORD",
	"action : FSKEYWORD string",
	"signed_number : number",
	"signed_number : PLUS number",
	"signed_number : MINUS number",
	"button : BUTTON number",
	"string : STRING",
	"number : NUMBER",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 9:
# line 121 "gram.y"
{ AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num); } break;
case 10:
# line 122 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->iconmgr->geometry= yypvt[-1].ptr;
						    Scr->iconmgr->columns=yypvt[-0].num;
						  }
						} break;
case 11:
# line 128 "gram.y"
{ if (Scr->FirstTime)
						    Scr->iconmgr->geometry = yypvt[-0].ptr;
						} break;
case 12:
# line 131 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->workSpaceMgr.workspaceWindow.geometry= yypvt[-1].ptr;
						    Scr->workSpaceMgr.workspaceWindow.columns=yypvt[-0].num;
						  }
						} break;
case 13:
# line 137 "gram.y"
{ if (Scr->FirstTime)
						    Scr->workSpaceMgr.workspaceWindow.geometry = yypvt[-0].ptr;
						} break;
case 16:
# line 146 "gram.y"
{ if (Scr->FirstTime)
					  {
						Scr->DoZoom = TRUE;
						Scr->ZoomCount = yypvt[-0].num;
					  }
					} break;
case 17:
# line 152 "gram.y"
{ if (Scr->FirstTime) 
						Scr->DoZoom = TRUE; } break;
case 18:
# line 154 "gram.y"
{} break;
case 19:
# line 155 "gram.y"
{} break;
case 20:
# line 156 "gram.y"
{ list = &Scr->IconifyByUn; } break;
case 22:
# line 158 "gram.y"
{ if (Scr->FirstTime) 
		    Scr->IconifyByUnmapping = TRUE; } break;
case 23:
# line 161 "gram.y"
{ list = &Scr->OpaqueMoveList; } break;
case 25:
# line 163 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueMove = TRUE; } break;
case 26:
# line 164 "gram.y"
{ list = &Scr->NoOpaqueMoveList; } break;
case 28:
# line 166 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueMove = FALSE; } break;
case 29:
# line 167 "gram.y"
{ list = &Scr->OpaqueMoveList; } break;
case 31:
# line 169 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueResize = TRUE; } break;
case 32:
# line 170 "gram.y"
{ list = &Scr->NoOpaqueResizeList; } break;
case 34:
# line 172 "gram.y"
{ if (Scr->FirstTime) Scr->DoOpaqueResize = FALSE; } break;
case 35:
# line 174 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, False);
					} break;
case 36:
# line 177 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, True);
					} break;
case 37:
# line 180 "gram.y"
{
		    root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR);
			if (Scr->Mouse[yypvt[-1].num][C_ROOT][0] == NULL)
			Scr->Mouse[yypvt[-1].num][C_ROOT][0] = (MouseButton*) malloc (sizeof (MouseButton));
			Scr->Mouse[yypvt[-1].num][C_ROOT][0]->func = F_MENU;
			Scr->Mouse[yypvt[-1].num][C_ROOT][0]->menu = root;
		} break;
case 38:
# line 187 "gram.y"
{
			if (Scr->Mouse[yypvt[-1].num][C_ROOT][0] == NULL)
			Scr->Mouse[yypvt[-1].num][C_ROOT][0] = (MouseButton*) malloc (sizeof (MouseButton));
			Scr->Mouse[yypvt[-1].num][C_ROOT][0]->func = yypvt[-0].num;
			if (yypvt[-0].num == F_MENU) {
			    pull->prev = NULL;
			    Scr->Mouse[yypvt[-1].num][C_ROOT][0]->menu = pull;
			}
			else {
			    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
			    Scr->Mouse[yypvt[-1].num][C_ROOT][0]->item = 
					AddToMenu(root,"x",Action,
					NULLSTR,yypvt[-0].num,NULLSTR,NULLSTR);
			}
			Action = "";
			pull = NULL;
		} break;
case 39:
# line 204 "gram.y"
{ GotKey(yypvt[-1].ptr, yypvt[-0].num); } break;
case 40:
# line 205 "gram.y"
{ GotButton(yypvt[-1].num, yypvt[-0].num); } break;
case 41:
# line 207 "gram.y"
{ list = &Scr->DontIconify; } break;
case 44:
# line 211 "gram.y"
{ list = &Scr->OccupyAll; } break;
case 47:
# line 215 "gram.y"
{ list = &Scr->IconMgrNoShow; } break;
case 49:
# line 217 "gram.y"
{ Scr->IconManagerDontShow = TRUE; } break;
case 50:
# line 218 "gram.y"
{ list = &Scr->IconMgrs; } break;
case 52:
# line 220 "gram.y"
{ list = &Scr->IconMgrShow; } break;
case 54:
# line 222 "gram.y"
{ list = &Scr->NoTitleHighlight; } break;
case 56:
# line 224 "gram.y"
{ if (Scr->FirstTime)
						Scr->TitleHighlight = FALSE; } break;
case 57:
# line 226 "gram.y"
{ list = &Scr->NoHighlight; } break;
case 59:
# line 228 "gram.y"
{ if (Scr->FirstTime)
						Scr->Highlight = FALSE; } break;
case 60:
# line 230 "gram.y"
{ list = &Scr->NoStackModeL; } break;
case 62:
# line 232 "gram.y"
{ if (Scr->FirstTime)
						Scr->StackMode = FALSE; } break;
case 63:
# line 234 "gram.y"
{ list = &Scr->NoIconTitle; } break;
case 65:
# line 236 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoIconTitlebar = TRUE; } break;
case 66:
# line 238 "gram.y"
{ list = &Scr->NoTitle; } break;
case 68:
# line 240 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoTitlebar = TRUE; } break;
case 69:
# line 242 "gram.y"
{ list = &Scr->MakeTitle; } break;
case 71:
# line 244 "gram.y"
{ list = &Scr->StartIconified; } break;
case 73:
# line 246 "gram.y"
{ list = &Scr->AutoRaise; } break;
case 75:
# line 248 "gram.y"
{ Scr->AutoRaiseDefault = TRUE; } break;
case 76:
# line 249 "gram.y"
{
					root = GetRoot(yypvt[-5].ptr, yypvt[-3].ptr, yypvt[-1].ptr); } break;
case 77:
# line 251 "gram.y"
{ root->real_menu = TRUE;} break;
case 78:
# line 252 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 79:
# line 253 "gram.y"
{ root->real_menu = TRUE; } break;
case 80:
# line 254 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 82:
# line 256 "gram.y"
{ list = &Scr->IconNames; } break;
case 84:
# line 258 "gram.y"
{ color = COLOR; } break;
case 87:
# line 262 "gram.y"
{ color = MONOCHROME; } break;
case 89:
# line 264 "gram.y"
{ Scr->DefaultFunction.func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->DefaultFunction.menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->DefaultFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 90:
# line 280 "gram.y"
{ Scr->WindowFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->WindowFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 91:
# line 288 "gram.y"
{ list = &Scr->WarpCursorL; } break;
case 93:
# line 290 "gram.y"
{ if (Scr->FirstTime) 
					    Scr->WarpCursor = TRUE; } break;
case 94:
# line 292 "gram.y"
{ list = &Scr->WindowRingL; } break;
case 96:
# line 297 "gram.y"
{ if (!do_single_keyword (yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
					"unknown singleton keyword %d\n",
						     yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 97:
# line 307 "gram.y"
{ if (!do_string_keyword (yypvt[-1].num, yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown string keyword %d (value \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 98:
# line 317 "gram.y"
{ if (!do_number_keyword (yypvt[-1].num, yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown numeric keyword %d (value %d)\n",
						     yypvt[-1].num, yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 99:
# line 329 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 100:
# line 332 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 103:
# line 339 "gram.y"
{ mods |= Mod1Mask; } break;
case 104:
# line 340 "gram.y"
{ mods |= ShiftMask; } break;
case 105:
# line 341 "gram.y"
{ mods |= LockMask; } break;
case 106:
# line 342 "gram.y"
{ mods |= ControlMask; } break;
case 107:
# line 343 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Mod1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 108:
# line 353 "gram.y"
{ } break;
case 111:
# line 360 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 112:
# line 361 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 113:
# line 362 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 114:
# line 363 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 115:
# line 364 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 116:
# line 365 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 117:
# line 366 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 118:
# line 367 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 119:
# line 368 "gram.y"
{  } break;
case 122:
# line 375 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 123:
# line 376 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 124:
# line 377 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 125:
# line 378 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 126:
# line 379 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 127:
# line 380 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 128:
# line 381 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 129:
# line 382 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 130:
# line 383 "gram.y"
{ } break;
case 131:
# line 384 "gram.y"
{ Name = yypvt[-0].ptr; cont |= C_NAME_BIT; } break;
case 135:
# line 395 "gram.y"
{ SetHighlightPixmap (yypvt[-0].ptr); } break;
case 139:
# line 406 "gram.y"
{
			NewBitmapCursor(&Scr->FrameCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 140:
# line 408 "gram.y"
{
			NewFontCursor(&Scr->FrameCursor, yypvt[-0].ptr); } break;
case 141:
# line 410 "gram.y"
{
			NewBitmapCursor(&Scr->TitleCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 142:
# line 412 "gram.y"
{
			NewFontCursor(&Scr->TitleCursor, yypvt[-0].ptr); } break;
case 143:
# line 414 "gram.y"
{
			NewBitmapCursor(&Scr->IconCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 144:
# line 416 "gram.y"
{
			NewFontCursor(&Scr->IconCursor, yypvt[-0].ptr); } break;
case 145:
# line 418 "gram.y"
{
			NewBitmapCursor(&Scr->IconMgrCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 146:
# line 420 "gram.y"
{
			NewFontCursor(&Scr->IconMgrCursor, yypvt[-0].ptr); } break;
case 147:
# line 422 "gram.y"
{
			NewBitmapCursor(&Scr->ButtonCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 148:
# line 424 "gram.y"
{
			NewFontCursor(&Scr->ButtonCursor, yypvt[-0].ptr); } break;
case 149:
# line 426 "gram.y"
{
			NewBitmapCursor(&Scr->MoveCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 150:
# line 428 "gram.y"
{
			NewFontCursor(&Scr->MoveCursor, yypvt[-0].ptr); } break;
case 151:
# line 430 "gram.y"
{
			NewBitmapCursor(&Scr->ResizeCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 152:
# line 432 "gram.y"
{
			NewFontCursor(&Scr->ResizeCursor, yypvt[-0].ptr); } break;
case 153:
# line 434 "gram.y"
{
			NewBitmapCursor(&Scr->WaitCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 154:
# line 436 "gram.y"
{
			NewFontCursor(&Scr->WaitCursor, yypvt[-0].ptr); } break;
case 155:
# line 438 "gram.y"
{
			NewBitmapCursor(&Scr->MenuCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 156:
# line 440 "gram.y"
{
			NewFontCursor(&Scr->MenuCursor, yypvt[-0].ptr); } break;
case 157:
# line 442 "gram.y"
{
			NewBitmapCursor(&Scr->SelectCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 158:
# line 444 "gram.y"
{
			NewFontCursor(&Scr->SelectCursor, yypvt[-0].ptr); } break;
case 159:
# line 446 "gram.y"
{
			NewBitmapCursor(&Scr->DestroyCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 160:
# line 448 "gram.y"
{
			NewFontCursor(&Scr->DestroyCursor, yypvt[-0].ptr); } break;
case 164:
# line 460 "gram.y"
{ if (!do_colorlist_keyword (yypvt[-1].num, color,
								     yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled list color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 165:
# line 469 "gram.y"
{ list = do_colorlist_keyword(yypvt[-1].num,color,
								      yypvt[-0].ptr);
					  if (!list) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color list keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 167:
# line 480 "gram.y"
{ if (!do_color_keyword (yypvt[-1].num, color,
								 yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 171:
# line 498 "gram.y"
{ do_string_savecolor(color, yypvt[-0].ptr); } break;
case 172:
# line 499 "gram.y"
{ do_var_savecolor(yypvt[-0].num); } break;
case 176:
# line 509 "gram.y"
{ if (Scr->FirstTime &&
					      color == Scr->Monochrome)
					    AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 177:
# line 514 "gram.y"
{ 
				    if (HasShape) Scr->SqueezeTitle = TRUE;
				} break;
case 178:
# line 517 "gram.y"
{ list = &Scr->SqueezeTitleL; 
				  if (HasShape && Scr->SqueezeTitle == -1)
				    Scr->SqueezeTitle = TRUE;
				} break;
case 180:
# line 522 "gram.y"
{ Scr->SqueezeTitle = FALSE; } break;
case 181:
# line 523 "gram.y"
{ list = &Scr->DontSqueezeTitleL; } break;
case 184:
# line 528 "gram.y"
{
				if (Scr->FirstTime) {
				   do_squeeze_entry (list, yypvt[-3].ptr, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
				}
			} break;
case 188:
# line 543 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-2].ptr, (char *)
						AllocateIconManager(yypvt[-2].ptr, NULLSTR,
							yypvt[-1].ptr,yypvt[-0].num));
					} break;
case 189:
# line 549 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-3].ptr, (char *)
						AllocateIconManager(yypvt[-3].ptr,yypvt[-2].ptr,
						yypvt[-1].ptr, yypvt[-0].num));
					} break;
case 193:
# line 563 "gram.y"
{
			AddWorkSpace (yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 194:
# line 566 "gram.y"
{
			curWorkSpc = yypvt[-0].ptr;
		} break;
case 199:
# line 579 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 200:
# line 582 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR, NULLSTR, NULLSTR);
		} break;
case 201:
# line 585 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR, NULLSTR);
		} break;
case 202:
# line 588 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr, NULLSTR);
		} break;
case 203:
# line 591 "gram.y"
{
			AddWorkSpace (curWorkSpc, yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, yypvt[-0].ptr);
		} break;
case 204:
# line 596 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-1].ptr, NULL, NULL, NULL);
		} break;
case 205:
# line 599 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-2].ptr, yypvt[-1].ptr, NULL, NULL);
		} break;
case 206:
# line 602 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, NULL);
		} break;
case 207:
# line 605 "gram.y"
{
		    WMapCreateCurrentBackGround (yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr);
		} break;
case 208:
# line 610 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-1].ptr, NULL, NULL, NULL);
		} break;
case 209:
# line 613 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-2].ptr, yypvt[-1].ptr, NULL, NULL);
		} break;
case 210:
# line 616 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr, NULL);
		} break;
case 211:
# line 619 "gram.y"
{
		    WMapCreateDefaultBackGround (yypvt[-4].ptr, yypvt[-3].ptr, yypvt[-2].ptr, yypvt[-1].ptr);
		} break;
case 215:
# line 631 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-0].ptr, 0);
					} break;
case 219:
# line 643 "gram.y"
{client = yypvt[-0].ptr;} break;
case 221:
# line 645 "gram.y"
{client = yypvt[-0].ptr;} break;
case 223:
# line 647 "gram.y"
{workspace = yypvt[-0].ptr;} break;
case 228:
# line 658 "gram.y"
{
				AddToClientsList (yypvt[-0].ptr, client);
			  } break;
case 232:
# line 669 "gram.y"
{
				AddToClientsList (workspace, yypvt[-0].ptr);
			  } break;
case 236:
# line 680 "gram.y"
{ if (Scr->FirstTime) AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 240:
# line 690 "gram.y"
{ AddToMenu(root, "", Action, NULLSTR, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					} break;
case 241:
# line 696 "gram.y"
{lastmenuitem = (MenuItem*) 0;} break;
case 244:
# line 703 "gram.y"
{
			if (yypvt[-0].num == F_SEPARATOR) {
			    if (lastmenuitem) lastmenuitem->separated = 1;
			}
			else {
			    lastmenuitem = AddToMenu(root, yypvt[-1].ptr, Action, pull, yypvt[-0].num, NULLSTR, NULLSTR);
			    Action = "";
			    pull = NULL;
			}
		} break;
case 245:
# line 713 "gram.y"
{
			if (yypvt[-0].num == F_SEPARATOR) {
			    if (lastmenuitem) lastmenuitem->separated = 1;
			}
			else {
			    lastmenuitem = AddToMenu(root, yypvt[-6].ptr, Action, pull, yypvt[-0].num, yypvt[-4].ptr, yypvt[-2].ptr);
			    Action = "";
			    pull = NULL;
			}
		} break;
case 246:
# line 725 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 247:
# line 726 "gram.y"
{
				yyval.num = yypvt[-1].num;
				Action = yypvt[-0].ptr;
				switch (yypvt[-1].num) {
				  case F_MENU:
				    pull = GetRoot (yypvt[-0].ptr, NULLSTR,NULLSTR);
				    pull->prev = root;
				    break;
				  case F_WARPRING:
				    if (!CheckWarpRingArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.warptoring argument \"%s\"\n",
						 Action);
					yyval.num = F_NOP;
				    }
				  case F_WARPTOSCREEN:
				    if (!CheckWarpScreenArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr, 
			"ignoring invalid f.warptoscreen argument \"%s\"\n", 
					         Action);
					yyval.num = F_NOP;
				    }
				    break;
				  case F_COLORMAP:
				    if (CheckColormapArg (Action)) {
					yyval.num = F_COLORMAP;
				    } else {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.colormap argument \"%s\"\n", 
						 Action);
					yyval.num = F_NOP;
				    }
				    break;
				} /* end switch */
				   } break;
case 248:
# line 767 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 249:
# line 768 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 250:
# line 769 "gram.y"
{ yyval.num = -(yypvt[-0].num); } break;
case 251:
# line 772 "gram.y"
{ yyval.num = yypvt[-0].num;
					  if (yypvt[-0].num == 0)
						yyerror("bad button 0");

					  if (yypvt[-0].num > MAX_BUTTONS)
					  {
						yyval.num = 0;
						yyerror("button number too large");
					  }
					} break;
case 252:
# line 784 "gram.y"
{ ptr = (char *)malloc(strlen(yypvt[-0].ptr)+1);
					  strcpy(ptr, yypvt[-0].ptr);
					  RemoveDQuote(ptr);
					  yyval.ptr = ptr;
					} break;
case 253:
# line 789 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
	}
	goto yystack;		/* reset registers in driver code */
}
