.\" t
.\" @(#)FvwmPrompt.1	1/12/94
.TH FvwmPrompt 1.00 "Jan 28 1994"
.UC
.SH NAME
FvwmPrompt \- the FVWM prompter module
.SH SYNOPSIS
FvwmPrompt is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
The FvwmPrompt module presents the user with a simple Athena-based
Yes/No prompter box.  If the user selects yes, then what ever action
was listed in the invocation command will be executed, otherwise
no further action will take place.

FvwmPrompt reads the same .fvwmrc file as fvwm reads when it starts up,
and looks for lines similar to "*FvwmPromptFore green".

.SH COPYRIGHTS
The FvwmPrompt program is the original work of Drew Moseley.

Copyright 1994, Drew Moseley.  The author makes no guarantees
or warranties of any kind about the use of this module.  Use
at your own risk.  You may freely use this module or any portion
of it for any purpose as long as the copyright is kept intact.

The concept for interfacing this module to the Window Manager is
the original work of Robert Nation.

Copyright 1994, Robert Nation. No guarantees or warranties or anything 
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 


.SH INITIALIZATION
During initialization, \fIFvwmPrompt\fP will eventually search a 
configuration file which describes the colors and font to use.
The configuration file is the same file that fvwm used during initialization.

If the FvwmPrompt executable is linked to another name, ie ln -s
FvwmPrompt MorePrompt, then another module called MorePrompt can be
started, with a completely different configuration than FvwmPrompt,
simply by changing the keyword  FvwmPrompt to MorePrompt.

.SH INVOCATION
FvwmPrompt can be invoked by binding the action 'Module
FvwmPrompt "prompt" action' to a menu or key-stroke in the .fvwmrc file.
The "prompt" field will be presented in the label window.  The entire
prompt must be enclosed in quotation marks.  The action field can
contain any valid Fvwm action.

Fvwm will search directory specified in the ModulePath configuration 
option to attempt to locate FvwmPrompt. Although nothing keeps 
you from launching FvwmPrompt at start-up time, you probably don't want to.

.SH CONFIGURATION OPTIONS
FvwmPrompt reads the same .fvwmrc file as fvwm reads when it starts up,
and looks for lines as listed below:

.IP "*FvwmPromptFore \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of black for text.

.IP "*FvwmPromptBack \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of black for the window
background.

.IP "*FvwmPromptFont \fIfontname\fP"
Tells the module to use \fIfontname\fP instead of fixed for text.


.SH AUTHOR
Drew Moseley (ddm@cis.ufl.edu)
