# Awk Script for use in the 
# 3EIT Music Library Catalogue Project 1994-1995
#
# It searches a database of the following format:
# :
# *COMPOSER1
# TITLE1 | OTHER | OTHER | OTHER | OTHER
# TITLE2 | OTHER | OTHER | OTHER | OTHER
# :
# *COMPOSER2
# TITLE1 | OTHER | OTHER | OTHER | OTHER
# :
#
# Requires criteria given in the variables 
# COMPOSER, TITLE, OTHER.
#
# Example command line:
#	awk -f libmod.awk COMPOSER="MOZART" TITLE="Requiem" records.rfd
#
# If COMPOSER="|" then a list of composers is returned.
# If TITLE="|" then a list of titles is returned.
#
# Written by Paul D. Sharpe 

BEGIN { FS="|" }

# Set flags for available data
{ 	if ((COMPOSER=="|") || (TITLE=="|")) all=1;	else all=0 	}
{ 	if (length(COMPOSER)!=0) composer=1; 		else composer=0 }
{ 	if (length(TITLE)!=0) title=1; 			else title=0	}
{ 	if (length(OTHER)!=0) other=1; 			else other=0	}


# Checks on the Composers
/\*/ { 
	if (!(composer)) cmatch=1; else \
	if ( !(all) && (COMPOSER==substr($1,2,length(COMPOSER))) )\
		cmatch=1; else cmatch=0;
	compName=substr($1,2,length($1))
      }


# Checks on the Titles
!/\*/  {
	if (!(title)) tmatch=1; else \
	if ( !(all) && (TITLE==substr($1,1,length(TITLE))) )\
		tmatch=1; else tmatch=0;
	}
# Checks on other
!/\*/  { 
	if (!(other)) omatch=1; else	\
	for (i=2;i<=NF;i++) {
	if ( !(all) && (OTHER==substr($i,1,length(OTHER))) )\
		omatch=1; else omatch=0;
	 }  
	}

# various cases

# The Composer List
(all==1) && (composer==1) && !/\*/ { inrange=0 }
(all==1) && (composer==1) && /\*/ { inrange=1 }

#The Title List
(all==1) && (title==1) && /\*/ { inrange=0 }
(all==1) && (title==1) && !/\*/ { inrange=1 }

#The List
(cmatch==1) && (omatch==1) && (tmatch==1) && /\*/ { inrange =1; next }
(cmatch==1) && (omatch==1) && (tmatch==1) && !/\*/ { inrange =1 }
(all==0) &&  ((cmatch==0) || (omatch==0) || (tmatch==0)) { inrange=0 }
  


# The Statement
(inrange==1) { print "{{"compName"} {"$1"} {"$2"} {"$3"} {"$4"} {"$5"} {"$6"} {"$7"}}" }
 
#END { print "all",all,"composer",cmatch,"title",tmatch,"other",omatch}
