/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

void
gui_openBrowseCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	OPENMODE=OPENIT;
	/* Invoke the file selection box dialog */
	XtManageChild(fileD);
}

void
gui_insertBrowseCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	OPENMODE=INSERTIT;
	/* Invoke the file selection box dialog */
	XtManageChild(fileD);
}

void
gui_cancelBrowseCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	/* Get rid of the file selection box dialog */
	XtUnmanageChild(fileD);
}

void
gui_browseFileCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	XmFileSelectionBoxCallbackStruct	*cbd = 
		(XmFileSelectionBoxCallbackStruct *)call_data;
	char	*filename =NULL;
	char 	answer;	
	
	/* Get the filename from the file selection box */
	filename = gui_XmStringToText(cbd->value);
	/* Make sure the user doesn't lose data accidentally */
	if (OPENMODE==OPENIT)
	{
		if (TextChanged)
		{
			answer = gui_query("Unsaved Text. Are you sure about this?");
			if (answer == YES)
			{
				set_title_message("Attempting to open file");
				time_cursor(fileD);
				if (loadfile(filename))
	  			{
					FileName=filename;
					XmTextSetCursorPosition(text_canvas,0); 	
					LastOp=OPENOP;
				}
				else
				{
					set_title_message("Sorry! Unable to open file");
				}
				undo_time_cursor(fileD);
			}
		}
		else
		{
			set_title_message("Attempting to open file");
			time_cursor(fileD);
			if (loadfile(filename))
			{
				FileName=filename;
  				XmTextSetCursorPosition(text_canvas,0); 
				LastOp=OPENOP;
			}
			else
			{	
				set_title_message("Sorry! Unable to open file");
			}
			undo_time_cursor(fileD);
		}
	}
	else
	{
		set_title_message("Attempting to insert file");
		time_cursor(fileD);
		if (loadfile(filename))
		{
			LastOp=OPENOP;
		}
		else
		{	
			set_title_message("Sorry! Unable to open file");
		}
		undo_time_cursor(fileD);
	}
}

/* Reads in the file */
Boolean
loadfile(filename)
char *filename;
{
	struct stat	stat_val;
	char 		*filecontents;
	FILE    	*fpointer;
	int		f_length;
		
	if (stat(filename,&stat_val) == 0)
	{
		f_length = stat_val.st_size;
		fpointer=fopen(filename,"r+");
		if (fpointer==NULL)
			fpointer=fopen(filename,"r");
		if (fpointer!=NULL)
		{
		  	filecontents = (char*) malloc((unsigned)(f_length+1));
			*filecontents = '\0';
			fread(filecontents,sizeof(char),f_length,fpointer);
		   	filecontents[f_length]='\0';
	        	fclose(fpointer);
			EditEvent=True;
			/* Put data  read in into the text widget wiping out old text*/
			if (OPENMODE==OPENIT)
			{
				/* Put data  read in into the text widget */
				XmTextSetString(text_canvas,filecontents);
				FileName=filename;
				set_title_message("");
				set_icon_name(filename);
				TextChanged=False;
			}
			else /* Insert data read in into current text */
			{
				XmTextInsert(text_canvas,XmTextGetInsertionPosition(text_canvas),filecontents);
				set_title_message("");
				TextChanged=True;
			}	
			XtFree(filecontents);
			return True;
		}
		else 
			return False;
	}
	else 
		return False;
}

/* Save the contents of the text widget to file */
void
gui_saveAsCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	char    *filename;
	int 	reply;

	filename=gui_prompt("Please enter the filename",getenv("PWD"));
	if(filename!=NULL)
	{
		set_title_message("Attempting to save file");
		FileName=filename;
		time_cursor(toplevel);
		if(gui_saveFile(filename))
		{	
			TextChanged=False;
			LastOp=SAVEOP;
			set_title_message("Ok file saved");
		}
		else
			if (gui_error("Sorry! Unable to save file ")==HELP)
				gui_info("You may not have specified a valid file name.\nOr you may not have write permission to that file.");
		undo_time_cursor(toplevel);
	}
}

/* Save the contents of the text widget to file */
void
gui_saveCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
        char    *filename=NULL;
	int	reply;

        if ((strcmp(FileName,"")==0) || (strcmp(FileName,"Untitled.gloe")==0))
        {
                filename=gui_prompt("Please enter the filename",getenv("PWD"));
		if(filename!=NULL)
		{
			set_title_message("Attempting to save file");
			time_cursor(toplevel);
			if(gui_saveFile(filename))
			{	
				FileName=filename;
				TextChanged=False;
				LastOp=SAVEOP;
				set_title_message("Ok file saved");
			}
			else
				if (gui_error("Sorry! Unable to save file ")==HELP)
					gui_info("You may not have specified a valid file name.\nOr you may not have write permission to that file.");
			undo_time_cursor(toplevel);
		}	
	}
	else
	{
		set_title_message("Attempting to save file");
		time_cursor(toplevel);
		if(gui_saveFile(FileName))
		{	
			TextChanged=False;
			LastOp=SAVEOP;
			set_title_message("Ok file saved");
		}
		else
			if (gui_error("Sorry! Unable to save file ")==HELP)
				gui_info("You may not have specified a valid file name.\nOr you may not have write permission to that file.");
		undo_time_cursor(toplevel);
	}
}

void
gui_saveSelectionCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	char    *filename=NULL;
	int	reply;
	
	filename=gui_prompt("Please enter the filename",getenv("PWD"));
	if(filename!=NULL)
	{
		set_title_message("Attempting to save file");
		time_cursor(toplevel);
		if(gui_saveSelection(filename))
		{	
			TextChanged=False;
			LastOp=SAVEOP;
			set_title_message("Ok file saved");
		}
		else
			if (gui_error("Sorry! Unable to save file ")==HELP)
				gui_info("You may not have specified a valid file name.\nOr you may not have write permission to that file.");
		undo_time_cursor(toplevel);
	}
}


Boolean
gui_saveFile(filename)
char *filename;
{
	char	*backup=(char *) malloc(strlen(filename)*2+16);
        char 	*textcontents=NULL;
        FILE	*filepointer;

	/* Check to see if the file is accessible */
	if (strcmp(filename,"")==0)
	{
		free(backup);
		return False;
	}
	else
	{
		if (AutoBackup)
		{
			if ((filepointer=fopen(filename,"r"))!=NULL)
			{
				/* FILE EXISTS BACKING UP */
				fclose(filepointer);
				sprintf(backup,"cp %s %s.gloebackup",filename,filename);
				system(backup);
				system("sync");
			}
			else
			{
				/* NO NEED TO BACKUP */
			}
		}
		free(backup);
		if ((filepointer=fopen(filename,"w+"))!=NULL)
		{
			/* Get the contents of the text widget text_canvas. */  
			textcontents=(char *)XmTextGetString(text_canvas);
			/* Write out the file */
			fwrite(textcontents,sizeof(char),strlen(textcontents),filepointer);
			if (textcontents[strlen(textcontents)-1]!='\n')
				fprintf(filepointer,"\n");
			fflush(filepointer);
			fclose(filepointer);
			system("sync");
			if (textcontents!=NULL)
				XtFree(textcontents);
			return True;
		}
		else  
		{
			return False;
		}
	}
}

Boolean
gui_saveSelection(filename)
char *filename;
{
	char	*backup=(char *) malloc(strlen(filename)*2+16);
        char 	*textcontents=NULL;
        FILE	*filepointer;

	/* Check to see if the file is accessible */
	if (strcmp(filename,"")==0)
	{
		free(backup);
		return False;
	}
	else
	{
		if (AutoBackup)
		{
			if ((filepointer=fopen(filename,"r"))!=NULL)
			{
				/* FILE EXISTS BACKING UP */
				fclose(filepointer);
				sprintf(backup,"cp %s %s.gloebackup",filename,filename);
				system(backup);
				system("sync");
			}
			else
			{
				/* NO NEED TO BACKUP */
			}
		}
		free(backup);
		if ((filepointer=fopen(filename,"w+"))!=NULL)
		{
			/* Get the contents of the text widget text_canvas. */  
			textcontents=(char *)XmTextGetSelection(text_canvas);
			/* Write out the file */
			fwrite(textcontents,sizeof(char),strlen(textcontents),filepointer);
			if (textcontents[strlen(textcontents)-1]!='\n')
				fprintf(filepointer,"\n");
			fflush(filepointer);
			fclose(filepointer);
			system("sync");
			if (textcontents!=NULL)
				XtFree(textcontents);
			return True;
		}
		else  
		{
			return False;
		}
	}
}

void
gui_newCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	char 	answer;	
	/* Check to see if text has changed first before wiping it out */
	if (TextChanged)
	{
		answer = gui_query("Unsaved Text. Are you sure about this?");
		if (answer == YES)
		{
			/* Now blank out the text_canvas and the file name fields */
			EditEvent=True;
			FileName="Untitled.gloe";
			XmTextSetString(text_canvas,"");
			set_title_message("");
			/* Now blank out the variables */
			LastOp=NEWOP;
			TextChanged=False;
			SelectedOnly = False;
			OldCanvasPosition=0;
			CurrentLine="";
			CurrentLineNumber=0;
			CurrentTab=0;
			StartOfLine=0;
			EndOfLine=0;
		}
	}
	else
	{
		/* Now blank out the text_canvas and the file name fields */
		EditEvent=True;
		FileName="Untitled.gloe";
		XmTextSetString(text_canvas,"");
		set_title_message("");
		/* Now blank out the variables*/
		LastOp=NEWOP;
		TextChanged=False;
		SelectedOnly = False;
		OldCanvasPosition=0;
		CurrentLine="";
		CurrentLineNumber=0;
		CurrentTab=0;
		StartOfLine=0;
		EndOfLine=0;
	}
}


void
gui_printCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	int result;
	char* printcommand= (char*) malloc(strlen(DefaultPrinter)+strlen(FileName)+8);
	char* printfile=(char*) malloc(strlen(FileName)+7);
	
	set_title_message("Ok attempting to print file");
	sprintf(printfile,"/tmp/.%s",FileName);
	sprintf(printcommand,"%s %s",DefaultPrinter,printfile);
	if (gui_saveFile(printfile))
	{
		result=system(printcommand);
		if (result==0)
			set_title_message("Print succesfull");
		else
			gui_info("Sorry unable to print file\nMaybe you have specified an invalid printer");
		if (printcommand!=NULL)
			XtFree(printcommand);
		printcommand=(char*) malloc(strlen(printfile)+4);
		sprintf(printcommand,"rm %s",printfile);
		system (printcommand);
	}
	else
	{
		if (gui_error("Sorry unable to print file ")==HELP)
			gui_info("Sorry unable to write temporary file needed for printing\nI need write permission for your working directory to do this");
	};
	if (printcommand!=NULL)
		XtFree(printcommand);
}

void
gui_printSelectionCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	int result;
	char* printcommand= (char*) malloc(strlen(DefaultPrinter)+strlen(FileName)+16);
	char* printfile=(char*) malloc(strlen(FileName)+15);
	
	set_title_message("Ok attempting to print file");
	sprintf(printfile,"/tmp/.%s-Extract",FileName);
	sprintf(printcommand,"%s %s",DefaultPrinter,printfile);
	if (gui_saveSelection(printfile))
	{
		result=system(printcommand);
		if (result==0)
			set_title_message("Print succesfull");
		else
			gui_info("Sorry unable to print file\nMaybe you have specified an invalid printer");
		if (printcommand!=NULL)
			XtFree(printcommand);
		printcommand=(char*) malloc(strlen(printfile)+4);
		sprintf(printcommand,"rm %s",printfile);
		system (printcommand);
	}
	else
	{
		if (gui_error("Sorry unable to save file ")==HELP)
			gui_info("Sorry unable to write temporary file needed for printing\nI need write permission for your working directory to do this");
	};
	if (printcommand!=NULL)
		XtFree(printcommand);
}

void
gui_quitCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	char 	answer;	
	/* Check to see if text has changed first before wiping it out */
	if (TextChanged)
	{
		answer = gui_query("Unsaved text. Are you sure you wish to Quit?");
		if (answer == YES)
		{
			exit(0);
		}
	}
	else
	{
		exit(0);
	}
}

