/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

/*************EVENT CALLBACKS AND HANDLERS*************/
/******************************************************/


/* Stuff Relating mainly to the formatter */
/******************************************/

void
adjustLineAccordingTo(value,CurrentTab,cbd)
int value;
int CurrentTab;
XmTextVerifyCallbackStruct *cbd;
{
	char *temp =(char*) malloc(100);
	int count;
	int i;

	/* Format according to the current Language */
	switch (CurrentLanguage)
	{
		case 1: /* C */
			/* Look up format rule for value */
			switch(value)
			{
				case 0: /* Line has no value */
					break;
				case 1: /* The C begin symbol */
					cbd->text->ptr=XtRealloc(cbd->text->ptr,CurrentTab+3);
					cbd->text->length=CurrentTab+3;
					cbd->text->ptr[0]='{';
					cbd->text->ptr[1]='\n';
					for (i=0;i<CurrentTab;i++)
					{
						cbd->text->ptr[i+2]='\t';
					}
					cbd->text->ptr[CurrentTab+2]='\t';
					EndOfLine=EndOfLine+CurrentTab+4;
					break;
				case 2: /* New line */
					cbd->text->ptr=XtRealloc(cbd->text->ptr,CurrentTab+1);
					cbd->text->length=CurrentTab+1;
					cbd->text->ptr[0]='\n';
					for (i=0;i<CurrentTab;i++)
					{
						cbd->text->ptr[i+1]='\t';
					}
					break;
				case 3: /*The  } symbol when stuck on the end of a line */
					cbd->text->ptr=XtRealloc(cbd->text->ptr,CurrentTab+1);
					cbd->text->length=CurrentTab+1;
					cbd->text->ptr[0]='\n';
					for (i=0;i<CurrentTab-1;i++)
					{
						cbd->text->ptr[i+1]='\t';
					}
					cbd->text->ptr[CurrentTab]='}';
					break;
			}
			break;
		default:
			break;
	}
	XtFree(temp);
}

int
valueOf(line,cbd)
char *line;
XmTextVerifyCallbackStruct *cbd;
{
	/* strip white space from beggining of line */
	int count=0;
	int length;
	char *temp1 =(char*) malloc(100);
	char *temp;
	char *word;
	strcpy(temp1,line);
	temp=temp1;
	length=strlen(temp);
	/* Look for words according to the current language */
	switch(CurrentLanguage)
	{
		case 1: /* C */
			/* Look for a main word which gives the line its value */
			if (temp!=NULL)
			{
				word = strtok(temp," .,?\"\t");
				if (strncmp(word,"{",1)==0)
				{
					XtFree(temp1);
					return 1;
				}
				if (strncmp(word,"\n",1)==0)
				{	
					XtFree(temp1);
					return 2;
				}
				if (strncmp(word,"}",1)==0)
				{	
					XtFree(temp1);
					return 3;
				}
			}
		default: break;
	}
	XtFree(temp1);
	return 0;
}

int
subValueOf(line,cbd)
char *line;
XmTextVerifyCallbackStruct *cbd;
{
	/* No Main word found So look for sub word */
	switch(CurrentLanguage)
	{
		case 1: /* C */
			if (cbd->text->length==1)
			{
				if (cbd->text->ptr[0]=='{')
				{
					return 1;
				}
				if (cbd->text->ptr[0]=='\n')
				{
					return 2;
				}
				if (cbd->text->ptr[0]=='}')
				{
					return 3;
				}
			}
			return 0;
			break;
		default: break;
	}
}

/* Combine the data input with the current line */
void 
updateLine(CurrentLine,text,length)
char *CurrentLine;
char *text;
int   length;
{
	char *temp=(char*) malloc(1000);
	char *temp2;	
	
	strcpy(temp,"");
	strncat(temp,CurrentLine,(XmTextGetInsertionPosition(text_canvas)-StartOfLine));
	temp2=CurrentLine+(XmTextGetInsertionPosition(text_canvas)-StartOfLine);
	strncat(temp,text,length);
	strcat(temp,temp2);
	strcpy(CurrentLine,temp);
	XtFree(temp);
}

/* Work out the tab factor of the line given */
void
tabFactor(line)
char *line;
{
	/* strip white space from beggining of line */
	int count=0;
	CurrentTab=0;
	while((line[count]=='\t')&&(count<=strlen(line)))
	{
		count++;
		CurrentTab++;
	}
}	


/* Shift line if not in correct position */
void
makeSureLineStartsAtCorrectPosition()
{
	int count=0;
	int count1;
	char *temp=(char*) malloc(1000);
	char *word;	

	word = strtok(CurrentLine," .,?\"\t");
	count=word-CurrentLine;
	count1=0;
	strcpy(temp,"");
	while(count1<CurrentTab)
	{
		strcat(temp,"\t");
		count1++;
	}
	XmTextReplace(text_canvas,StartOfLine,StartOfLine+count,temp);
	XtFree(temp);
}

/**************************************************************************************/
/**************************************************************************************/
