/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

void
gui_setUpCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	/* Take a copy of the current values before allowing changes */
	autoBackup=AutoBackup;
	formatOn=FormatOn;
	autoSave=AutoSave;
	autoSaveTime=AutoSaveTime;
	strcpy(defaultPrinter,DefaultPrinter);
	XtManageChild(configPopUp);
}

void
saveConfigCB()
{
	FILE   *fpointer;
	char   *filename=(char*) malloc(12+strlen(getenv("HOME"))+1);
	
	sprintf(filename,"%s/.gloeConfig",getenv("HOME"));
	fpointer=fopen(filename,"w");
	if (fpointer!=NULL)
	{
		fprintf(fpointer,"%d %d %d %d %s\n",(int)AutoSaveTime,(int)AutoSave,(int)AutoBackup,(int)FormatOn,DefaultPrinter);	
	}
	fclose(fpointer);
	if (filename!=NULL) 
		XtFree(filename);
	return;
}

/* Fallback default values for setup */
void
setDefaults()
{
	AutoBackup=True;
	AutoSave=True;
	FormatOn=False;
	AutoSaveTime=100;
	strcpy(DefaultPrinter,"No printer identified");
	strcpy(RootDirectory,getenv("HOME"));
}	

/* Attempt to load user defined values for setup */
Boolean
loadConfig()
{
	FILE   *fpointer;
	char   *filename=(char*) malloc(12+strlen(getenv("HOME"))+1);
	
	sprintf(filename,"%s/.gloeConfig",getenv("HOME"));
	fpointer=fopen(filename,"rt");
	if (fpointer!=NULL)
	{
		fscanf(fpointer,"%d %d %d %d %s\n",&AutoSaveTime,&AutoSave,&AutoBackup,&FormatOn,DefaultPrinter);
		strcpy(RootDirectory,getenv("HOME"));
		fclose(fpointer);
		if (filename!=NULL)
			XtFree(filename);
		return True;
	}
	else
	{	
		fclose(fpointer);
		if (filename!=NULL)
			XtFree(filename);
		return False;
	}
}

/* Callbacks for the config popUp */
/**********************************/

/* Restore original values of the configuration */
void
gui_restoreConfigCB()
{
	char *item=(char*) malloc(100);
	/* Try to load them first */
	if (!loadConfig())
		setDefaults();
	/* Now set the values in the setup popUp */
	XmTextSetString(printerText,DefaultPrinter);
	sprintf(item,"%d",AutoSaveTime);
	XmTextSetString(autosavetimeText,item);
	/*XtVaSetValues(formatterOnTB,XmNset,FormatOn,NULL);	
	XtVaSetValues(formatterOffTB,XmNset,!FormatOn,NULL);	*/
	XtVaSetValues(backupOnTB,XmNset,AutoBackup,NULL);	
	XtVaSetValues(backupOffTB,XmNset,!AutoBackup,NULL);	
	XtVaSetValues(autosaveOnTB,XmNset,AutoSave,NULL);	
	XtVaSetValues(autosaveOffTB,XmNset,!AutoSave,NULL);	
	XtFree(item);
};

void 	
gui_cancelConfigCB()
{
	char *item=(char*) malloc(100);
	/* return setup to values before the user made changes */
	AutoBackup=autoBackup;
	AutoSave=autoSave;
	AutoSaveTime=autoSaveTime;
	FormatOn=formatOn;
	strcpy(DefaultPrinter,defaultPrinter);

	/* Should undo changes made and quit popUpconfig dialog */
	sprintf(item,"%d",AutoSaveTime);
	XmTextSetString(autosavetimeText,item);
	XmTextSetString(printerText,DefaultPrinter);
	/*XtVaSetValues(formatterOnTB,XmNset,FormatOn,NULL);	
	XtVaSetValues(formatterOffTB,XmNset,!FormatOn,NULL);*/	
	XtVaSetValues(backupOnTB,XmNset,AutoBackup,NULL);	
	XtVaSetValues(backupOffTB,XmNset,!AutoBackup,NULL);	
	XtVaSetValues(autosaveOnTB,XmNset,AutoSave,NULL);	
	XtVaSetValues(autosaveOffTB,XmNset,!AutoSave,NULL);	
	XtUnmanageChild(configPopUp);
	XtFree(item);
};

void
gui_okConfigCB()
{
	XtUnmanageChild(configPopUp);
};

void
gui_autosavetimeTextCB()
{
	char *temp;
	/* Get new period between autosaves */
	temp=XmTextGetString(autosavetimeText);
	AutoSaveTime=atoi(temp);
	if (temp!=NULL) 
		XtFree(temp);
};

void 	
gui_rootTextCB()
{
	/*RootDirectory=XmTextGetString(rootText);*/
};


void
gui_printerTextCB()
{
	char* temp;

	/* Get new default printer */
	temp=XmTextGetString(printerText);
	strcpy(DefaultPrinter,temp);
	if (temp!=NULL) 
		XtFree(temp);
};

void 	
gui_formatterOnCB()
{
	/* Formatter turned on */
 	FormatOn=True;
};
void 	
gui_formatterOffCB()
{
	/* Formatter turned off */ 
	FormatOn=False;
};

void 
gui_backupOnCB()
{
	/* Backup turned on */
	AutoBackup=True;
};
void 
gui_backupOffCB()
{
	/* Backup turned off */
	AutoBackup=False;
};

void 
gui_autosaveOnCB()
{
	/* Autosave turned on */
	AutoSave=True;
};
void 
gui_autosaveOffCB()
{
	/* Autosave turned off */
	AutoSave=False;
};
