/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

void
gui_enterTextCB(w,client_data,call_data)
Widget	w;
XtPointer client_data;
XtPointer call_data;
{
	Cursor c1;
	
	CURRENT_CURSOR=XC_pencil;
	c1= XCreateFontCursor(XtDisplay(toplevel),XC_pencil);
	XDefineCursor(XtDisplay(toplevel),XtWindow(toplevel),c1);
	XFlush(XtDisplay(toplevel));
}

void
gui_leaveTextCB(w,client_data,call_data)
Widget	w;
XtPointer client_data;
XtPointer call_data;
{
	XUndefineCursor(XtDisplay(toplevel),XtWindow(toplevel));
	XFlush(XtDisplay(toplevel));
	default_cursor(toplevel);
}

void
keyPressedCB(w,client_data,call_data)
Widget	w;
XtPointer client_data;
XtPointer call_data;
{
}

void
gui_cursorMotionCB(w,client_data,call_data)
Widget	w;
XtPointer client_data;
XtPointer call_data;
{}

void gui_keypressCB(w,client_data,call_data)
Widget	w;
XtPointer client_data;
XtPointer call_data;	
{
	char 	*text,*temp;
	int 	linenum;
	int 	linecount;
	int 	charcount;
	int 	i;
	int	textpos;
	int	Old,New;
	XmTextVerifyCallbackStruct *cbd =(XmTextVerifyCallbackStruct *) call_data;
	
	/* Deal with very large documents */
	if ((XmTextGetLastPosition(text_canvas)+cbd->text->length)>MAX_DOCUMENT_LENGTH)
	{
		if (gui_error("Warning you have exceeded the maximum length for a document\nText entry ignored.\nDo not continue to enter code or a crash could occur.")==HELP)
			gui_info("This is a bug I haven't managed to iron out yet sorry");
		cbd->doit=False;
	}
	else
	{
		TextChanged=True;
		if (EditEvent)
		{
			EditEvent=False;
		}
		else
		{
			if (LastOp!=KEYPRESSOP)
			{
				snapshot();
				LastOp=KEYPRESSOP;
			}
			/* Only if the formatter is turned on */
		}
	}
	/*if (text!=NULL) XtFree(text);*/
}


