/* x11_windowsys.h -- X11 window-system data and macros
   Copyright (C) 1993, 1994 John Harper <jsh@ukc.ac.uk>

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _X11_WINDOWSYS_H
#define _X11_WINDOWSYS_H

typedef struct {
    Window		ws_Window;
    GC			ws_TextFontGC, ws_BlkFontGC;
    int			ws_PenX, ws_PenY;
    XFontStruct	       *ws_Font;
    int			ws_Width, ws_Height;
} VW_WindowSys;

#define vw_Window	vw_WindowSys.ws_Window
#define vw_Font		vw_WindowSys.ws_Font
#define WINDOW_NIL	(0)

#if 0
typedef struct {
    /* ... */
} ScrollBar;
#endif

/* Pen colours. */
#define P_TEXT	0
#define P_BLOCK 1

/*
 * Macros for drawing operations. These are mainly used in render.c for
 * system-independant rendering.
 */

/* Move to position (X,Y). The next DRAW() will happen at this position. */
#define MOVE(vw,x,y) \
    do { \
	(vw)->vw_WindowSys.ws_PenX = (x); \
	(vw)->vw_WindowSys.ws_PenY = (y); \
    } while(0)

#define PEN_X(vw) ((vw)->vw_WindowSys.ws_PenX)
#define PEN_Y(vw) ((vw)->vw_WindowSys.ws_PenY)

/* Draw LEN bytes of the string STR with colour COL (P_TEXT or P_BLOCK)
   at the position set by the MOVE() macro.  */
#define TEXT(vw,col,str,len) \
    do { \
	XDrawImageString(x11_display, (vw)->vw_Window, \
			 ((col) == P_TEXT) \
			  ? (vw)->vw_WindowSys.ws_TextFontGC \
			  : (vw)->vw_WindowSys.ws_BlkFontGC, \
			 (vw)->vw_WindowSys.ws_PenX, (vw)->vw_WindowSys.ws_PenY, \
			 (str), (len)); \
	(vw)->vw_WindowSys.ws_PenX += (len) * vw->vw_FontX; \
    } while(0)

/* Clear a rectangle from (X,Y) to (X+W,Y+H).  */
#define CLR_AREA(vw,x,y,w,h) \
    XClearArea(x11_display, (vw)->vw_Window, (x), (y), (w), (h), False)

#define CLR_RECT(vw,x1,y1,x2,y2) \
    XClearArea(x11_display, (vw)->vw_Window, (x1), (y1), \
	       (x2) - (x1), (y2) - (y1), False)

/* Fill a rectangle from (X,Y) to (X+W,Y+H).  */
#define SET_AREA(vw,x,y,w,h) \
    XFillRectangle(x11_display, (vw)->vw_Window, (vw)->vw_WindowSys.ws_TextFontGC, \
		   (x), (y), (w), (h))

#define SET_RECT(vw,x1,y1,x2,y2) \
    XFillRectangle(x11_display, (vw)->vw_Window, (vw)->vw_WindowSys.ws_TextFontGC, \
		   (x1), (y1), (x2) - (x1), (y2) - (y1))

/* Copy pixels from (X1,Y1),(X1+W,Y1+H) to (X2,Y2)  */
#define COPY_AREA(vw,x1,y1,w,h,x2,y2) \
    do { \
	XCopyArea(x11_display, (vw)->vw_Window, (vw)->vw_Window, \
		  (vw)->vw_WindowSys.ws_TextFontGC, \
		  (x1), (y1), (w), (h), (x2), (y2)); \
	x11_handle_gexposures(vw); \
    } while(0)

/* Number of pixels from top of font to its baseline.  */
#define FONT_ASCENT(vw) ((vw)->vw_Font->ascent)

/* Draw a line from (x1,y1) to (x2,y2)  */
#define DRAW_LINE(vw,x1,y1,x2,y2) \
    XDrawLine(x11_display, vw->vw_Window, vw->vw_WindowSys.ws_TextFontGC, \
	      x1, y1, x2, y2)

#endif /* _X11_WINDOWSYS_H */
