#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "config.h"
#include "atodim.h"

float atodim( const char *string)
{
  char *str;
  float bp=strtod(string,&str);

  if(*str!='\0')
    {
      if(!strncmp(str,"pt",2))
	bp*=72.0/72.27; /* Point */
      else if(!strncmp(str,"cm",2))
	bp*=72.0/2.54; /* Centimeter */
      else if(!strncmp(str,"in",2))
	bp*=72.0; /* Inch */
      else if(!strncmp(str,"mm",2))
	bp*=72.0/25.4; /* Millimeter */
      else if(!strncmp(str,"dm",2))
	bp*=10.0*72/2.54; /* Decimeter */
      else if(!strncmp(str,"km",2))
	bp*=1000.0*100*72/2.54; /* Kilometer */
      else if(!strncmp(str,"yd",2))
	bp*=3.0*12*72; /* Yard */
      else if(!strncmp(str,"ft",2))
	bp*=12.0*72; /* Foot */
      else if(!strncmp(str,"ly",2))
	bp*=3000000.0*1000*86400*365*100*72/2.54; /* Light Year */
      else if(!strncmp(str,"pc",2))
	bp*=1.0/12*72.0/72.27; /* Pica */
      else if(!strncmp(str,"bp",2))
	bp*=1.0; /* Big Point */
      else if(!strncmp(str,"dd",2))
	bp*=1157.0/1238*72.0/72.27; /* Didot */
      else if(!strncmp(str,"cc",2))
	bp*=1157.0/1238/12*72.0/72.27; /* Cicero */
      else if(!strncmp(str,"ld",2))
	bp*=384600.0*1000*100*72.0/2.54; /* Average Lunar Distance */
      else if(!strncmp(str,"m",1))
	bp*=100*72.0/2.54; /* Meter */
      else
	bp*=1.0;
    }
  return(bp);
}

