#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "config.h"
#include "myword.h"
#include "atodim.h"
#include "debug.h"

Flag CalcLine(Line*,Flag);

static
float WidthOfSpecial(LineP *lp,float w)
{
  float tab=atodim("1.5cm");

  if(lp->special!=NULL)
    switch(lp->special->type)
      {
      case 1:
	return(tab-fmod(w,tab));
	break;
      default:
	return(0);
      }
  return(0);
}

static
void ShiftToNextLine(LineP *lp)
{
  Line *l=lp->line->next;
  LineP *lp1;

  for(lp1=lp;lp1->next!=NULL;lp1=lp1->next)
    lp1->line=l;
  lp1->line=l;
  lp1->next=l->first; lp1->next->previous=lp1;
  l->first=lp; lp->previous=NULL;
  lp1=lp1->previous; DeleteLineP(lp1->next);
}
 
Flag GetLineHeight(Line *l)
{
  Flag f=0;
  LineP *lp;
  float h=l->first->height,d=l->first->depth; /*l->height,d=l->depth;*/

  for(lp=l->first;lp!=NULL;lp=lp->next)
    {
      if((lp->clength>0)||(lp->c[0]!=0)||(lp->special!=NULL))
	{
	  if(lp->height>h)
	    h=lp->height;
	  if(lp->depth>d)
	    d=lp->depth;
	}
    }
  if(l->height+l->depth>h+d)
    f=4;
  if(l->height!=h)
    {
      f|=1;
      l->height=h;
    }
  if(l->depth!=d)
    {
      f|=2;
      l->depth=d;
    }
  return(f);
}

void FormatLine(Line *l)
{
  float w,wt,hyphen;
/*  Pos p;*/
  Flag f=0,break1=0,break2=0/*,change*/;
  LineP *lp,/**oldlp,*/*lp_bup;
  int index=0/*,oldindex*/;
  Tpos bt1,bt2,t2,*oldtpos=&bookmark[4];
  char c1=0;

/*  fprintf(stderr,"*%d\n",l->page->change);*/
  CleanLine(l);
  f=GetLineHeight(l);
  /* f>4 iff lineheight smaller than before */
  if(f>4)
    l->page->change=1;
  f=f|GetLinePos(l);

/* This is to prevent unnecessary redisplaying of the whole page */
/*  change=l->page->change;*/
  if(l->next==NULL)
    lp_bup=NULL;
  else
    {
      lp_bup=l->next->first;
/*      fprintf(stderr,"  %d\n",(int)lp_bup);*/
    }

  w=l->width;
  l->width=GetLineWidth(l,l->height,l->depth);
  if(w!=l->width) f=f|8;
  lp=l->first; hyphen=GetWidth('-',lp->finfo);
  lp->pos=l->pos; c1=lp->c[0];
  w=l->width-l->pos.x; wt=0.0;
  do
    {
      oldtpos->linep=lp; oldtpos->index=index;
      if(index<lp->clength)
	{
	  IncrementXPos(wt,lp,index,lp->finfo,0.0);
	  index++;
	  c1=lp->c[index];
	}
      else
	{
	  if(lp->special!=NULL)
	    {
	      wt+=WidthOfSpecial(lp,wt);
	      lp=lp->next;
	      index=0; c1=0;
	    }
	  else
	    {
	      lp=lp->next; index=0;
	      if(lp==NULL)
		{
		  Line *lnext=oldtpos->linep->line->next;
		  LineP *lpnext;
		  if((lnext!=NULL)&&(lnext->newline==0))
		    {
		      lpnext=lnext->first;
		      if(GetLineHeight(lnext)>0)
			SetEval(lnext);
		      if((lnext->height!=l->height)||(lnext->depth!=l->depth))
			{
			  if((lpnext->height<=l->height)
			     &&(lpnext->depth<=l->depth))
			    {
			      CleanLine(l->next);
			      /*f|*/lp=MergeNextLineP(oldtpos->linep);
			      /*lp=lp->next;*/
			    }
			  else
			    {
			      float h=l->height,d=l->depth,y=l->pos.y-h,width;
			      Flag flag=0;
			      if(lpnext->height>l->height) 
				l->height=lpnext->height;
			      if(lpnext->depth>l->depth)
				l->depth=lpnext->depth;
			      flag|=GetLinePos(l);
			      if((l->pos.y-l->height==y)
				 &&((width=GetLineWidth(l,h,d))>wt))
				{
				  l->width=w=width;
				  CleanLine(l->next);
				  lp=MergeNextLineP(oldtpos->linep);
				  /*lp=lp->next;*/
				}
			      else
				{
				  l->height=h;
				  l->depth=d;
				  flag|=GetLinePos(l);
				}
			    }
			}
		      else
			{
			  CleanLine(l->next);
			  /*f|*/lp=MergeNextLine(oldtpos->linep);
			  /*lp=lp->next;*/
			}
		    }
		}
/*	      fprintf(stderr,"*%f %d* ",wt,c1);*/
	      wt+=GetWidth(c1,oldtpos->linep->finfo);	
/*	      fprintf(stderr,"*%f* ",wt);*/
	      if(lp!=NULL)
		{
		  if(lp->previous->finfo==lp->finfo)
		    wt+=(GetKern(c1,lp->c[0],lp->finfo));
		  c1=lp->c[0];
		  wt+=lp->kern;
		  lp->pos.y=lp->pos.y; lp->pos.x=wt+l->pos.x;
		  hyphen=GetWidth('-',lp->finfo);
		}
	    }
	}
      if((wt>w)&&(break1==0))
	{
	  break1=1;
 	  bt1.linep=oldtpos->linep; bt1.index=oldtpos->index;
	}
      if((break2==0)&&(wt>(w-hyphen)))
	{
	  break2=1;
 	  bt2.linep=oldtpos->linep; bt2.index=oldtpos->index;
	}
/*      fprintf(stderr,"LineP: %d,%d\n",oldlp,lp);
      LineTree(act_page->first);*/
/*      fprintf(stderr,"%f ",wt);*/
/*      fprintf(stderr,"%c",c1);*/
    } while((lp!=NULL)&&(wt<=w));
/*  fprintf(stderr,"!%f!,%f\n",wt,w);*/
  /* The line is to long: break */
  if((wt>=w)&&(bt1.linep->next!=NULL))
    {
      /* Search break point */
      if(bt1.linep->c[bt1.index]==' ')
      	 bt1=NextTpos(bt1);
      *oldtpos=bt1;
      if((break2!=0)&&(bt2.linep==bt1.linep)&&(bt2.index==bt1.index))
	break2=0;
      if(bt1.linep->line==l)
	{
	  char c;
	  break1=0;
	  do
	    {
	      t2=PreviousTpos(bt1);
	      if((t2.index==bt1.index)&&(t2.linep==bt1.linep))
		break1=1;
	      if(t2.linep->line!=l)
		break1=1;
	      else
		bt1=t2;
	      if((break2!=0)&&(bt2.linep==bt1.linep)&&(bt2.index==bt1.index))
		break2=0;
	      c=bt1.linep->c[bt1.index];
	    } while((break1==0)&&(c!=' ')&&((c!='-')||(break2!=0)));

	  /* Here is the location of the hyphenation in spe */

#if 0
	  /* And now, if no split point to the left was found,*/
	  /* search the next to the right. */
	  if((break1>0))
	    {
	      break1=0;
	      do
		{
		  t2=NextTpos(bt1);
		  if((t2.index==bt1.index)&&(bt1.linep==t2.linep))
		    break1=1;
		  if(t2.linep->line!=l)
		    break1=1;
		  else
		    bt1=t2;
		  c=bt1.linep->c[bt1.index];
		} while((c!=' ')&&(c!='-')&&(break1==0));
	    }
#endif
	  /* If no split point was found, split here. */
	  if(break1>0) 
	    {
	      break1=0;
	      bt1=NextTpos(*oldtpos);
	    }
/*	  else*/
	    bt1=NextTpos(bt1);
	  lp=bt1.linep; index=bt1.index;

	  /* And now, if any changes happened: Split the Line! */
	  if((break1==0)&&(lp->next!=NULL))
	    {
	      Line *l1;
/*	      LineP *lp1;*/
	      if(index>0)
		{
		  SplitLineP(lp,index);
		  lp=lp->next;
		}
	      lp=lp->previous;
	      if((l->next==NULL)||(l->next->newline>0))
		{
		  l1=MakeLine(l,lp->next);
		  lp->next=NULL;
		  AppendChar(lp,0);
		  InsertLine(l,l1);
		  SetEval(l1); l->clean=1;
		}
	      else
		{
		  ShiftToNextLine(lp->next);
		  lp->next=NULL;
		  AppendChar(lp,0);
		  SetEval(l->next); l->clean=1;
		}
	    }
	  /* f&4 should be !=0 now, iff LinePos has changed. */
/*	  if(((f&4)==0)&&(change==0)&&(l->next!=NULL)
	     &&(l->next->first==lp_bup))
	    l->page->change=0;*/
	}
    }
  if(l->eval>0)
    {
      l->eval=0; l->page->eval--; l->page->text->eval--;
    }
  if((lp_bup!=NULL)&&(l->next==NULL))
    {
      l->page->change=1;
/*      fprintf(stderr," format.c:226\n");
      PrintAsciiLine(l);
      LineTree(l);*/
    }
  if(GetLineHeight(l)>0)
    FormatLine(l);
/*  else*/
    {
      if(f>0)
	SetEval(l->next);
      if((l->format==0)&&((l->next==NULL)||(l->next->newline>0)))
	CalcLine(l,3);
      else
	CalcLine(l,l->format);
      /*  fprintf(stderr,"%d*\n",l->page->change);*/
    }
}


Flag CalcLine(Line *l,Flag type)
{
  LineP *lp,*last_lp;
  FontInfo *font;
  Pos pos;
  Flag f=0,f1=0;
  float space_width=0;
  int i,j=0;

  CleanLine(l);
  l->space_num=0;
  pos=l->pos;
  for(lp=l->first;(lp!=NULL);lp=lp->next)
    {
/*      lp->softhyph&=(-1^1);*/
      j=0;
      lp->pos=pos;
      if(lp->special!=NULL)
	{
	  pos.x+=WidthOfSpecial(lp,pos.x-l->pos.x);
	}
      else
	{
	  if(lp->softhyph>1)
	    lp->softhyph=2;
	  else
	    lp->softhyph=0;
	  font=lp->finfo;
	  for(i=0;i<=lp->clength;i++)
	    {
	      if(lp->c[i]==' ')
		j++;
	      if((i==lp->clength)&&(lp->next!=NULL)&&(lp->next->finfo==font))
		pos.x+=GetWidth(lp->c[i],font)
		  +GetKern(lp->c[i],lp->next->c[0],font);
	      else
		IncrementXPos(pos.x,lp,i,font,0.0);
	    }
	  if(lp->next!=NULL)
	    {
	      if(lp->c[lp->clength]==' ')
		{
		  f1=1;
		  space_width=GetWidth(lp->c[lp->clength],font);
		  last_lp=lp;
		}
	      else if((lp->c[0]!=0)||(lp->clength>0))
		f1=0;
	    }
	}
      lp->space_num=j;
      l->space_num+=j;
    }
  if(f1>0)
    {
      last_lp->softhyph|=1;
      last_lp->space_num--;
      l->space_num--;
      pos.x-=space_width;
    }
  l->actualwidth=pos.x-l->first->pos.x;
  if(l->actualwidth>l->width)
    f|=64;
  else
    {
      if(f>0) SetEval(l->next);
      
      if(type<3)
	{
	  float delta,i1;
	  
	  delta=l->width-l->actualwidth;
	  if(type==1)
	    delta=delta/2;
	  if(type>0)
	    for(lp=l->first;lp!=NULL;lp=lp->next)
	      lp->pos.x+=delta;
	  else
	    {
	      if(l->space_num>0)
		{
		  delta/=l->space_num;
		  i1=0.0;
		  for(lp=l->first;lp!=NULL;lp=lp->next)
		    {
		      lp->pos.x+=i1;
		      i1+=lp->space_num*delta;
		    }
		}
	    }
	}
    }
  l->change=1;
  return(f);
}
