#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "mySelFile.h"

static char *PopupTranslations = "\
  <Key>Return: show() \n\
  <Key>Up: up() \n\
  <Key>Down: down() \n\
  <Key>Escape: escape() \n\
  <Key>Tab: complete()";

static char *ListTranslations = "\
  <Btn1Down>: select()\n\
  <Btn1Down>(2): show()";

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

#define MAXENT 1024
static Widget popup,form,dir,core,view,vscroll,text,buttonbox;
static Display *display;
static String list[MAXENT]={"MMMMMMMMMMMMMMMMMMMMMM",
	   "","","","","","","","","","","","","","",};
static int number=0,act_index;
static unsigned int dirw,dirh,dirb,dire,coreh=1,corew=1;
static int wid=0;
static char inp[MAXPATHLEN],modal;

static void centerlist(int i);

static int compare(char **a, char **b)
{
  return(strcmp(*a,*b));
}

static int readlist(char *name)
{
  DIR *dirp;
  struct dirent *de;
  struct stat st;
  static int i=0;
  
  for(i=0;i<number;i++)
    free(list[i]);
  i=0;
  
  dirp=opendir(name);
  if(!dirp) return(0);
  de=readdir(dirp); /* "." */
  while((de=readdir(dirp)))
    {
      stat(de->d_name,&st);
      if(S_ISDIR(st.st_mode))
	{
	  list[i]=(char*)malloc(strlen(de->d_name)+2);
	  strcpy(list[i],de->d_name);
	  strcat(list[i],"/");
	}
      else
	{
	  list[i]=strdup(de->d_name);
	}
      i++;
    }
  closedir(dirp);
  qsort(list,i,sizeof(String),(comparison_fn_t)compare);
  act_index=-1;
  XawListHighlight(dir,-1);
  inp[0]=0;
  number=i;
    
  XtVaSetValues(text,XtNstring,inp,NULL);
  XtVaSetValues(core,XtNwidth,corew,XtNheight,coreh,NULL);
  XtVaSetValues(dir,XtNnumberStrings,number,XtNlist,list,
		NULL);

  if(wid>0) 
    centerlist(0);
  return(1);
}

static void escape(Widget w,XEvent *e,String *s,Cardinal *n)
{
  inp[0]=0;
  modal=1;
}

static void centerlist(int i)
{
  float y;
  y=i*dirh/number;
  y-=(dire-dirb)/2;
  y/=dirh;
  if(y<0) y=0;
  else if(y>1) y=1;
  XtCallCallbacks(vscroll,XtNjumpProc,(XtPointer)&y);
}

static void up(Widget w, XEvent *ev, String *s, Cardinal *n)
{
  if(act_index>0)
    {
      act_index--;
      XawListHighlight(dir,act_index);
      strcpy(inp,list[act_index]);
      if(inp[strlen(inp)-1]=='/') inp[strlen(inp)-1]=0;
      centerlist(act_index);
      XtVaSetValues(text,XtNstring,inp,NULL);
      XawTextSetInsertionPoint(text,strlen(inp));
    }
  
}

static void down(Widget w, XEvent *ev, String *s, Cardinal *n)
{
  if(act_index<number-1) 
    {
      act_index++;
      XawListHighlight(dir,act_index);
      strcpy(inp,list[act_index]);
      if(inp[strlen(inp)-1]=='/') inp[strlen(inp)-1]=0;
      centerlist(act_index);
      XtVaSetValues(text,XtNstring,inp,NULL);
      XawTextSetInsertionPoint(text,strlen(inp));
    }
}

/* gets the last DialogString and rearranges selection */
static void defaultkey(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  int i=0;

  XawListUnhighlight(dir);
  i=strlen(inp);
  if((i>0)&&(inp[i-1]=='/'))
    {
      chdir(inp);
      readlist(".");
    }
  else
    {
      if(i>0)
	for(i=0;(i<number)&&(strcmp(inp,list[i])>=0);i++);
      if((strncmp(inp,list[i],strlen(inp))==0)&&(list[i][strlen(inp)]=='/'))
	i++;
      centerlist(i-1);
      act_index=i-1;
      if(strcmp(inp,list[i-1])==0)
	XawListHighlight(dir,i-1);
    }
}

static void show(Widget w, XEvent *ev, String *s, Cardinal *n)
{
  struct stat st;

  stat(inp,&st);
  if(S_ISDIR(st.st_mode))
    {
      chdir(inp);
      readlist(".");
    }
  else
    modal=1;
}

static void select(Widget w, XEvent *ev, String *s, Cardinal *n)
{
  XButtonEvent *event=(XButtonEvent*)ev;
  int i;
  if(dirh>0)
    {
      i=event->y*number/dirh;
      if((i<0)||(i>=number)) i=-1;
      XawListHighlight(dir,i);
      act_index=i;
      strcpy(inp,list[i]);
      if(inp[strlen(inp)-1]=='/') inp[strlen(inp)-1]=0;
      XtVaSetValues(text,XtNstring,inp,NULL);
    }
}

static void complete(Widget w, XEvent *ev, String *s, Cardinal *n)
{
  int i,j=strlen(inp),k,l;

  for(i=0;(i<number)&&(strncmp(inp,list[i],j)!=0);i++);
  if(i<number)
    {
      if((i==number-1)||(strncmp(inp,list[i+1],j)!=0))
	{
	  strcpy(inp,list[i]);
	  if(inp[strlen(inp)-1]=='/') inp[strlen(inp)-1]=0;
	  XtVaSetValues(text,XtNstring,inp,NULL);
	  XawTextSetInsertionPoint(text,strlen(inp));
	  act_index=i;
	  XawListHighlight(dir,i);
	}
      else
	{
	  act_index=i-1;
	  for(l=i+1;(strncmp(inp,list[l],j)==0);l++);
	  l--; k=j; j=strlen(list[i]);
	  if(strlen(list[l])<j) j=strlen(list[l]);
	  while((k<j)&&(list[i][k]==list[l][k]))
	    inp[k]=list[i][k++];
	  inp[k]=0;
	  XtVaSetValues(text,XtNstring,inp,NULL);
	  XawTextSetInsertionPoint(text,strlen(inp));
	}
      centerlist(act_index);
    }
}

static void WasWeissIch(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  XawPannerReport *r=(XawPannerReport*)ca_d;
  int x;

  dirh=r->canvas_height; dirb=r->slider_y; dire=r->slider_height+dirb;
  coreh=r->slider_height; corew=r->slider_width;
  x=r->slider_width;
  XtVaSetValues(text,XtNwidth,x,NULL);
}

static XtActionsRec actions[]= {
  {"up",up},
  {"down",down},
  {"show",show},
  {"select",select},
  {"escape",escape},
  {"complete",complete},
};

static void doDone(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  modal=1;
}

static void doCancel(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  inp[0]=0;
  modal=1;
}

static void doRescan(Widget w, XtPointer cl_d, XtPointer ca_d)
{
  int i=act_index;
  readlist(".");
  act_index=i;
}

static void CreateWidgets(Widget topLevel, XtAppContext *ap)
{
  Widget asciisrc,cancel,done,rescan,form1;
  Arg arglist[1];

  if(wid==0)
    {
      display=XtDisplay(topLevel);
      XtSetArg(arglist[0],XtNtransientFor,topLevel);
      popup=XtAppCreateShell("mySelFile","mySelFile",
			     transientShellWidgetClass,display,arglist,1);
      *ap=XtWidgetToApplicationContext(popup);
      form=XtVaCreateManagedWidget("form",formWidgetClass,popup,NULL);
      text=XtVaCreateManagedWidget("text",asciiTextWidgetClass,form,
				   XtNstring,inp,XtNlength,MAXPATHLEN,
				   XtNeditType,XawtextEdit,
				   XtNwrap, XawtextWrapWord,
				   XtNresizable,True,
				   XtNresize,XawtextResizeHeight,
				   XtNuseStringInPlace,True,
				   XtNtop,XtChainTop,
				   XtNbottom,XtChainTop,
				   NULL);
      view=XtVaCreateManagedWidget("view",viewportWidgetClass,form,
				   XtNfromVert,text,
				   XtNforceBars,True,
				   XtNallowHoriz,True,
				   XtNuseBottom,True,
				   XtNallowVert,True,
				   XtNuseRight,True,
				   XtNright,XtChainRight,
				   XtNresizable,True,
				   NULL);
      XtAddCallback(view,XtNreportCallback,WasWeissIch,NULL);
      vscroll=XtNameToWidget(view,"vertical");
      form1=XtVaCreateManagedWidget("form1",formWidgetClass,view,
				    XtNresizable,True,NULL);
      dir=XtVaCreateManagedWidget("list",listWidgetClass,form1,
				  XtNdefaultColumns,1,
				  XtNforceColumns,True,
				  XtNlist,list,XtNnumberStrings,15,
				  XtNresizable,True,
				  XtNborderColor,
				     WhitePixelOfScreen(XtScreen(topLevel)),
				  NULL);
      core=XtVaCreateManagedWidget("core",coreWidgetClass,form1,
				   XtNresizable,True,
				   XtNwidth,corew,XtNheight,coreh,
				   XtNborderColor,
				     WhitePixelOfScreen(XtScreen(topLevel)),
				   NULL);
      buttonbox=XtVaCreateManagedWidget("buttonbox",boxWidgetClass,form,
					XtNfromVert,view,
					XtNorientation,XtorientHorizontal,
					XtNtop,XtChainBottom,
					XtNbottom,XtChainBottom,
					NULL);
      cancel=XtVaCreateManagedWidget("cancel",commandWidgetClass,buttonbox,
				     NULL);
      done=XtVaCreateManagedWidget("done",commandWidgetClass,buttonbox,
				   NULL);
      rescan=XtVaCreateManagedWidget("rescan",commandWidgetClass,buttonbox,
				     NULL);
      XtAddCallback(done,XtNcallback,doDone,NULL);
      XtAddCallback(cancel,XtNcallback,doCancel,NULL);
      XtAddCallback(rescan,XtNcallback,doRescan,NULL);
      
      XtAppAddActions(*ap,actions,XtNumber(actions));
      XtSetKeyboardFocus(form,text);
      XtOverrideTranslations(text,XtParseTranslationTable(PopupTranslations));
      XtOverrideTranslations(dir,XtParseTranslationTable(ListTranslations));
      XtVaGetValues(text,XtNtextSource,&asciisrc,NULL);
      XtAddCallback(asciisrc,XtNcallback,defaultkey,NULL);
      XtSetMappedWhenManaged(popup,False);
      XtRealizeWidget(popup);
      wid=1;
      readlist(".");
    }
}

char *mySelFile(Widget topLevel,Dimension x, Dimension y)
{
  XtAppContext ap;
  Window w1;
  unsigned int d;
  int d1;

  if(wid==0)
    {
      CreateWidgets(topLevel,&ap);
      XtVaSetValues(popup,XtNx,x,XtNy,y,NULL);
      XtMapWidget(popup);
    }
  else
    {
      readlist(".");
      XtVaSetValues(popup,XtNx,x,XtNy,y,NULL);
    }

  modal=0;

  XGetGeometry(display,XtWindow(buttonbox),&w1,&d1,&d1,&dirw,&d,&d,&d);
  XtVaSetValues(view,XtNwidth,dirw,NULL);

  XtPopup(popup,XtGrabNonexclusive);
  while(modal==0)
    {
      XEvent event;
      XtAppNextEvent(ap,&event);
      XtDispatchEvent(&event);
    }
  XtPopdown(popup);
  return(inp);
}
