#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "myword.h"
#include "ftoa.h"
#include "debug.h"
#include "status.h"
#include "psinternal.h"

static float s=1; /* number precision of PS-points */

void PSHeader(Text *t,FILE *f)
{
  FontInfo *fi=finfo,*fi2;
  Page *p=t->first;
  int pages=1,i;
  float width=t->width,height=t->height;

  while((p=p->next)!=NULL)
    {
      pages++;
      if(width<p->width)
	width=p->width;
      if(height<p->height)
	height=p->height;
    }
  fprintf(f,"%%!PS-Adobe-3.0\n");
  fprintf(f,"%%%%Creator: %s\n",myword_version);
  fprintf(f,"%%%%Title: %s\n",t->name);
  fprintf(f,"%%%%Pages: %d\n",pages);
  fprintf(f,"%%%%PageOrder: Ascend\n");
  fprintf(f,"%%%%BoundingBox: 0 0 %s %s",ftoa(width,s),ftoa(height,s));
  i=1000;
  for(fi=finfo;fi!=NULL;fi=fi->next)
    {
      for(fi2=finfo;strcmp(fi->name,fi2->name);fi2=fi2->next);
      if(fi2==fi)
	{
	  if(i+strlen(fi->name)>80)
	    {
	      fprintf(f,"\n%%%%DocumentFonts: ");
	      i=strlen("%%%%DocumentFonts: ")+strlen(fi->fontname)+1;
	    }
	  else
	    i+=strlen(fi->fontname+1);
	  fprintf(f,"%s ",fi->fontname);
	}
    }
  fprintf(f,"\n%%%%EndComments\n%%%%BeginProcSet: \n");
  fprintf(f,"/s { show } def\n");
  fprintf(f,"/k { 0 rmoveto } def\n");
  fprintf(f,"/m { moveto } def\n");
  fprintf(f,"/eop { showpage } def\n");
  fprintf(f,"/ff { findfont } def\n");
  fprintf(f,"/sf { scalefont setfont } def\n");
  fprintf(f,"%%%%EndProcSet\n");
  fprintf(f,"%%%%Feature: *Resolution 300dpi\n");
  fprintf(f,"%%%%BeginSetup\n%%%%EndSetup\n");
}

void PSFooter(Text *t,FILE *f)
{
  fprintf(f,"eop\n%%%%Trailer\n%%end\n%%%%EOF\n");
}

int PSPutString(const char *c,Pos x,FILE *f)
{
  char *str1, /* *str=calloc(1,2*sizeof(char)*strlen(c)); */
         str[LLine];

  str1=str;
  for(;*c!='\0';c++,str1++)
    {
      if((*c==')')||(*c=='('))
	{
	  *str1='\\';
	  str1++;
	}
      *str1=*c;
    }
  *str1='\0';

  fprintf(f,"(%s)s",str);
  return(strlen(str)+3);
/*  free(str);*/
}

void PSWriteLineP(LineP *lp,Pos pos,FontInfo **act_font,FILE *f)
{
  char str[LLine],c,*str1=str;
  float kern;
  int i=0,j=0;

  if((lp->previous!=NULL)&&(*act_font==lp->finfo))
    c=lp->previous->c[lp->previous->clength];
  else
    c='\0';

  if(*act_font!=lp->finfo)
    {
      sprintf(str," /%s ff %s sf",lp->finfo->fontname,ftoa(lp->finfo->size,s));
      fprintf(f,"%s",str);
      j+=strlen(str);
    }
  *act_font=lp->finfo;

  kern=GetKern(c,lp->c[0],lp->finfo)+lp->kern;
  if(kern!=0)
    {
      sprintf(str," %s k",ftoa(kern,s));
      fprintf(f,"%s",str);
      j+=strlen(str);
    }
/*  *str1=lp->c[0]; str1++;*/
  for(i=0;i<lp->clength;i++)
    {
      kern=GetKern(lp->c[i],lp->c[i+1],lp->finfo);
      if(kern>0)
	{
	  *str1='\0';
	  j+=PSPutString(str,pos,f);
	  str1=str;

	  sprintf(str," %s k",ftoa(kern,s));
	  fprintf(f,"%s",str);
	  j+=strlen(str);
	  if(j>80)
	    {
	      fprintf(f,"\n");
	      j=0;
	    }
	}
      *str1=lp->c[i]; str1++;
    }
  *str1=lp->c[lp->clength]; str1++; *str1='\0';
  j+=PSPutString(str,pos,f);
}

void PSWriteLine(Line *l,Pos pos,FontInfo **act_font,FILE *f)
{
  LineP *lp;

  fprintf(f," %s %s m\n",ftoa(l->pos.x,s),ftoa(l->page->height-l->pos.y,s));
  for(lp=l->first;lp!=NULL;lp=lp->next)
    if((lp->clength>0)||(lp->c[0]!=0))
      PSWriteLineP(lp,pos,act_font,f);
    else if(lp->special!=NULL)
      switch(lp->special->type)
	{
	case 1:
	  fprintf(f," %s %s m\n",ftoa(lp->next->pos.x,s),
		           ftoa(l->page->height-lp->next->pos.y,s));
	  break;
	default:
	  fprintf(stderr,"Unimplemented Special to print\n");
	}
  fprintf(f,"\n");
}

void PSWriteText(Text *t,FILE *f)
{
  Pos pos={0,0};
  FontInfo *font;
  Page *p;
  Line *l;
  int pagen=0;

  PSHeader(t,f);
  for(l=t->first->first;l!=NULL;l=l->next)
    {
      if(p!=l->page)
	{
	  if(pagen>0)
	    fprintf(f,"eop\n");
	  pagen++;
	  fprintf(f,"%%%%Page: %d %d\n",pagen,pagen);
	  p=l->page;
	}
      PSWriteLine(l,pos,&font,f);
    }
  PSFooter(t,f);
}

void PSPrintTextToFile(const char *name)
{
  FILE *file;

  WriteStatus("Formatting Text.");
  FormatText(act_text);
  WriteStatus("Printing Text.");
  file=fopen(name,"wb");
  PSWriteText(act_text,file);
  fclose(file);
  WriteStatus("Done.");
}
