/* XInternal.h */
/* Header File for */
/* internal routines to visualize text on X */
#ifndef XINTERNAL_H
#define XINTERNAL_H

#include <X11/Intrinsic.h>
#include "myword.h"

typedef struct {
  Flag cursor_on;
  XtIntervalId id;
  Pos p1;
  Pos p2;
} Cursor_status;

#ifdef XINTERNAL_C
Cursor_status cursor_status;
Flag redisplay;
#else
extern Cursor_status cursor_status;
extern Flag redisplay;
#endif

/* char based operation */
extern void XPutChar(char,long,long);
extern void XPutInverseChar(long,long,int,int);

/* line based operations */
extern void WriteLineP(LineP*,float,float,int,int,float);
extern void WriteLine(Line*,float,float);
extern void RewriteLine(Line*,float,float);

/* page based operations */
extern void WritePage(Page*);
extern void CleanPage(Page*);
extern void DrawMargins(Page*);
extern void RewritePage(Page*);
extern void RewriteWholePage(Page*);
extern void CenterPage(Pos);

/* cursor operations */
extern void CursorBlink(void);
extern void CursorUnblink(void);
extern void FollowCursor(void);

/* miscellanea */
extern void myViewAreaChange(Widget,XtPointer,XtPointer);

extern void DelayedRewritePage(void);
extern void InitText(void);

#if 0
/* obsolete */
extern void myResizeBitmap(Widget,XtPointer,XtPointer);
#endif

#endif /* #ifndef XINTERNAL_H */
