/* #########################################################################

			       XCORAL SMAC

   File: keydef-ext.sc

   Created: Tue Dec 14 07:45:48 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:26:02 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: global set key utilities

   Requires: 

   Defines: globalize_mode, global_key_def

   Suggested bindings: 

   Procedure: call global_key_def instead of key_def to define a key in all
	      `modes'.

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   vector of all mode names
   ------------------------------------------------------------------------- */

char* modes [256];

/* -------------------------------------------------------------------------
   number of modes (size of `modes' vector)
   ------------------------------------------------------------------------- */

int nb_modes=0;

/* -------------------------------------------------------------------------
   make mode <mode_name> global : add it to the `modes' vector
   ------------------------------------------------------------------------- */

void globalize_mode(char* mode_name) {
  
  modes[nb_modes++] = mode_name;
}

/* -------------------------------------------------------------------------
   define key in all `modes'
   ------------------------------------------------------------------------- */

void global_key_def(char* key_name, char* command_name) {
  
  int index;
  
  for (index=0; index<nb_modes; ++index)
    key_def(modes[index],key_name,command_name);
}

