/* #########################################################################

			       XCORAL SMAC

   File: utilities.sc

   Created: Tue Nov 30 19:00:12 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:26:56 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: general SMAC programmer and XCORAL user utilities

   Defines: window_substring, insert_chars, transpose_chars,
	    delete_chars, delete_region, delete_to_end_of_line,
	    delete_to_beginning_of_line, delete_previous_char,
	    delete_line_blanks, just_one_blank,
	    center_line_within, center_line,
	    recenter
   
   Suggested bindings: "^xt"  "transpose_chars"
		       "^[\\" "delete_line_blanks"
		       "^[ "  "just_one_blank"
		       "^[k"  "delete_to_beginning_of_line"
		       "^xc"  "center_line"
		       "^[l"  "recenter"

   Procedure: call or execute the defined functions ...
	      (see comments below)

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   extract a string in current window from <beg> to <end> (malloc)
   ------------------------------------------------------------------------- */

char* window_substring(int beg, int end) {

  int start=current_position(), len=end-beg, index;
  char* str;
  
  str = (char*) malloc(len+1);
  
  goto_char(beg);
  
  for (index=0;index<len;++index)
    {
      str[index]=current_char();
      goto_next_char();
    }
  str[len] = 0;
  
  goto_char(start);

  return str;
}

/* -------------------------------------------------------------------------
   insert <n> times <repeated_char>
   ------------------------------------------------------------------------- */

void insert_chars(int n, char repeated_char) {

  int n_ins;
  
  for (n_ins=0;n_ins<n;++n_ins)
    insert_char(repeated_char);
}

/* -------------------------------------------------------------------------
   transpose current and preceding char
   ------------------------------------------------------------------------- */

void transpose_chars() {

  char current=current_char();
  
  delete_char();
  goto_previous_char();
  insert_char(current);
}

/* -------------------------------------------------------------------------
   delete <ndel> chars
   ------------------------------------------------------------------------- */

void delete_chars(int ndel) {

  while (ndel--) delete_char();
}

/* -------------------------------------------------------------------------
   delete chars from <beg> to <end>
   ------------------------------------------------------------------------- */

void delete_region(int beg, int end) {

  int origin=current_position();
  
  goto_char(beg);
  delete_chars(end-beg);

  if (origin<beg)
    goto_char(origin);
  else
    if (origin>end)
      goto_char(origin-end+beg);
}

/* -------------------------------------------------------------------------
   delete to end of line
   ------------------------------------------------------------------------- */

void delete_to_end_of_line() {

  delete_chars(end_of_line()-current_position());
}

/* -------------------------------------------------------------------------
   delete back to beginning of line
   ------------------------------------------------------------------------- */

void delete_to_beginning_of_line() {

  delete_region(beginning_of_line(), current_position());
}

/* -------------------------------------------------------------------------
   delete previous char
   ------------------------------------------------------------------------- */

void delete_previous_char() {

  goto_previous_char();
  delete_char();
}

/* -------------------------------------------------------------------------
   delete blank space to left and right
   ------------------------------------------------------------------------- */

void delete_line_blanks() {

  while (previous_char() == ' ' || previous_char() == '\t')
    delete_previous_char();

  while (current_char() == ' ' || current_char() == '\t')
    delete_char();
}

/* -------------------------------------------------------------------------
   delete blank space to left and right, leaving just one blank space
   ------------------------------------------------------------------------- */

void just_one_blank() {

  delete_line_blanks();
  insert_char(' ');
}

/* -------------------------------------------------------------------------
   center line within <width>
   ------------------------------------------------------------------------- */

void center_line_within(int width) {

  int tab_width = 8, line_width, indent, n_tabs, n_spaces, n_ins;
  
  goto_end_of_line();
  delete_line_blanks();
  goto_beginning_of_line();
  delete_line_blanks();
  
  line_width = end_of_line() - current_position();
  
  if (line_width < width)
    {
      goto_beginning_of_line();
      indent = (width - line_width) / 2;
      n_tabs = indent / tab_width;
      for (n_ins=0;n_ins<n_tabs;++n_ins)
	insert_char('\t');
      n_spaces = indent % tab_width;
      for (n_ins=0;n_ins<n_spaces;++n_ins)
	insert_char(' ');
    }
}

/* -------------------------------------------------------------------------
   center line within width of 80
   ------------------------------------------------------------------------- */

void center_line() {

  center_line_within(80);
}

/* -------------------------------------------------------------------------
   recenter current position in window
   ------------------------------------------------------------------------- */

void recenter() {

  int origin=current_position(), up_lines=window_height()/2;
  
  while (up_lines--) goto_previous_line();
  current_line_to_top();
  
  goto_char(origin);
}

