/*
 *     Contour Union Alghorithm   c-union1.h  
 *     (recursive algorithm, recursive data structure)
 *     Copyright (c) 1993,1994 T.Hruz, I.Povazan, R.Gosiorovsky
 */

/*
 *      recursive data structure
 */

typedef struct tree  {  CHAR busy;          /* is the node busy ? */
                        INT l,r;            /* left and right value */
                        struct tree *left;
                        struct tree *right; }  TREE;

/*
 *      structure for each scan line
 */

TREE *XI[XMaxRES]; 
TREE *YI[YMaxRES]; 

/*
 *     create and init one cell of tree
 */

TREE *create(INT a,INT b)    
 {
   TREE *s;
   
   s=(TREE *)malloc(sizeof(TREE));

   s->l=a;
   s->r=b;
   s->busy=0;
   s->left = NULL; 
   s->right= NULL;

   return(s);
 }

/*
 *     destroy a tree 
 */

VOID free_I(TREE *s)            
 {
   if (s->left)  free_I(s->left);
   if (s->right) free_I(s->right);
   free(s);
 }

/*
 *    auxliary function for CU 
 */

CHAR spy_left1(TREE *node)    
 {
   if (node->busy) return(TRUE);
   if (node->left) return(spy_left1(node->left));
   return(FALSE);
 }  

CHAR spy_right1(TREE *node)     
 {
   if (node->busy)  return(TRUE);
   if (node->right) return(spy_right1(node->right));
   return(FALSE);
 }  

/*
 *      union of interval with a tree
 */

CHAR onion1(INT a,INT b,TREE *s)    
 {
   INT center;
   CHAR L,R;

   if (s->busy) return( TRUE );

   if ((a<=s->l)&&(s->r<=b)) 
     {
       if (a==s->l) if (!spy_left1(s))   Point(XL,YL); 
       if (b==s->r) if (!spy_right1(s))  Point(XR,YR);  
       return( s->busy = TRUE ); 
     }
   else
     { 
        center = (s->l + s->r) >> 1;
        if (a<center) 
           {
             if (s->left==NULL)  s->left = create(s->l,center);
             L = onion1(a,b,s->left);
	   }
        else 
           {
             if (s->left==NULL)  L = FALSE;
             else  L = (s->left)->busy;
           }

        if (b>center)
           { 
             if (s->right==NULL) s->right = create(center,s->r);
             R = onion1(a,b,s->right);
	   }
        else 
           {
             if (s->right==NULL) R = FALSE;                         
             else R = (s->right)->busy;
           }
        return(s->busy=(L&&R));
     }
 }

/*
 *    initialization of structures
 */

VOID init_CU()  
  {
     INT x,y;
     for(y=0;y<Win_H;y++) XI[y] = create(0,Win_W);
     for(x=0;x<Win_W;x++) YI[x] = create(0,Win_H); 
  }

/*
 *    destroying of each scan line structure
 */

VOID clear_CU()    
  {
     INT x,y;
     for(y=0;y<Win_H;y++) if (XI[y]) free_I(XI[y]);
     for(x=0;x<Win_W;x++) if (YI[x]) free_I(YI[x]);
  }

/*---------------------------------------------------------------------*/
