/*
 *       Cursor Modul  -   cursor.c
 *       Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"

VOID coord_values(POINT *B)
 {
    CHAR str[20];
    GColor(1);
    sprintf(str,"%f",B->x);
    TextXY(MinX+32,MaxY-52,str);
    sprintf(str,"%f",B->y);
    TextXY(MinX+32,MaxY-42,str);
    sprintf(str,"%f",B->z);
    TextXY(MinX+32,MaxY-32,str);
 }

VOID coordinates()
 {
    FillRectangle(MinX+3,MaxY-65,MinX+120,MaxY-18,f->work);
    GColor(f->line);
    TextXY(MinX+15,MaxY-52,"x=");
    TextXY(MinX+15,MaxY-42,"y=");
    TextXY(MinX+15,MaxY-32,"z=");
 }

VOID cross(POINT2 *b)
 {
    Line(b->x-3,b->y,b->x+3,b->y,1);
    Line(b->x,b->y-3,b->x,b->y+3,1);
 }

VOID cursor_line(POINT *A,POINT *B,INT c)
 {
    POINT2 a,b;
    a= *proj_ortho(A);
    b= *proj_ortho(B);
    Line(a.x,a.y,b.x,b.y,c);
 }

POINT a_proj(INT x,INT y,INT z)
 {
   POINT B;

   B.x = ((FLOAT)(x - (MaxX+MinX)/2 ))/(70*c->dist) + c->P.x;
   B.y = ((FLOAT)(y - (MaxY+MinY)/2 ))/(70*c->dist) + c->P.y;
   B.z = z;

   return(B);
 }

POINT sipka(POINT *S,INT u)
 {
   POINT B;
   POINT2 b;
   INT x=0,y=0,but;

   Kurzor(1);
   coordinates();
   Line_mode(1);  

   B= *S;
   coord_values(&B);
   if (u) cursor_line(S,&B,1);

   while(check_mouse(&x,&y,&but))
    {
      coord_values(&B);
      if (u) cursor_line(S,&B,1);

      B = a_proj(x,y,S->z);

      coord_values(&B);
      if (u) cursor_line(S,&B,1); 
    }

   b.x=x;  
   b.y=y;
   cross(&b);

   Line_mode(0);
   Kurzor(0);

   return(B);
 }
/*-------------------------------------------------------------------------*/











