/*
 *      X Window System Interface  griface.c                
 *      (Xlib functions are called from this modul only)
 *
 *      Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"
#include <X11/Xlib.h>
#include <X11/cursorfont.h>

/*
 *     variables
 */

Display             *disp;
Window               root,win;
GC                   gc;
INT                  scr;
XEvent               event;
KeySym               keysym;
XWindowAttributes    watt;
XSetWindowAttributes satt;
Drawable             DRAW;
Pixmap               menumap,map;
Cursor               cursor1,cursor2;
Colormap             cmap,dmap;
XImage              *image;
INT                 depth;

CHAR                *Idata;        /* image data */
INT                 Image_F;       /* color for image */
INT                 Cur_Out;       /* current output */
FILE                *output_file; 

/*
 *    keybord and mouse interface
 */

VOID IfKey(CHAR *ch)
  {
    if (XCheckWindowEvent(disp,win,KeyPressMask|ButtonPressMask,&event))
       if (event.type==ButtonPress) *ch=27;
       else XLookupString((XKeyEvent *)&event,ch,1,NULL,NULL);  
  }

INT check_mouse(INT *x,INT *y,INT *but)
  {
      XButtonEvent *bev;
      XMotionEvent *mev;

      XSelectInput(disp,win,ButtonPressMask|PointerMotionMask);
      XWindowEvent(disp,win,ButtonPressMask|PointerMotionMask,&event);
      XSelectInput(disp,win,KeyPressMask|ButtonPressMask|StructureNotifyMask);

      if (event.type==ButtonPress)
            { bev= (XButtonEvent *)&event;
              *x=bev->x;
              *y=bev->y;
              *but=bev->button;  
              return(0); }

      if (event.type==MotionNotify)
            { mev= (XMotionEvent *)&event;
              *x=mev->x;
              *y=mev->y;
              *but=0;
              return(1); }

      printf("Warning - mysterious event has occured in check_mys \n"); 
      return(999);
  }

INT catch_mouse(INT *x,INT *y)
  {
      XButtonEvent *bev;

      XWindowEvent(disp,win,ButtonPressMask|StructureNotifyMask,&event);

      while (event.type!=ButtonPress)
        {
          if ((Win_W!=GetMaxX())||(Win_H!=GetMaxY()))
             {
                Win_W=GetMaxX();
                Win_H=GetMaxY();
                init_screen(); 
                go();
             }
          XWindowEvent(disp,win,ButtonPressMask|StructureNotifyMask,&event);
        } 

      if (event.type==ButtonPress)
        {
          bev= (XButtonEvent *)&event;
          *x=bev->x;
          *y=bev->y;
          return(bev->button);
         }

      printf("Warning - mysterious event has occured %d \n",event.type); 
      return(999);
  }

CHAR GetKey()
    {
      CHAR *s;
      INT index=0;

      XWindowEvent(disp,win,KeyPressMask|ButtonPressMask,&event);

      if (event.type==ButtonPress)
        {
          if (((XButtonEvent *)&event)->button==1) return(GO);
          return(ESCAPE);
        }

      keysym=XLookupKeysym((XKeyEvent *)&event,index);
      s=XKeysymToString(keysym);
      if (s==NULL) printf("Get Key unexpected !\n",s);
      if (strlen(s)==1) return(s[0]);
      switch (s[0])
        { 
           case 'U' : if (s[1]=='p') return(UP);
	   case 'D' : if (s[1]=='o') return(DOWN);
                 else if (s[1]=='e') return(BACK);
           case 'L' : if (s[1]=='e') return(LEFT);
           case 'R' : if (s[1]=='i') return(RIGHT);
                 else if (s[1]=='e') return(GO); 
           case 'p' : if (s[1]=='e') return('.'); 
           case 's' : if (s[1]=='l') return('/');
           case 'E' : if (s[1]=='s') return(ESCAPE);
        }
      return('0');  
    }

/*
 *     Set Cursor Shape
 */

VOID Kurzor(int kurzor)
  {
    if (kurzor) XDefineCursor(disp,win,cursor2);
           else XDefineCursor(disp,win,cursor1);
  }

/*
 *     Set Palette 
 */

VOID Palette()
  {
     INT i;  
     static XColor ccc;
     static struct { unsigned short r,g,b; } fff[16]=
       {
         0x00,0x00,0x00,  0xff,0xff,0xff,  0xb0,0x70,0x70,  0xb0,0xb0,0x40,
         0xc0,0x60,0x60,  0x40,0x80,0x40,  0x60,0xa0,0x80,  0x40,0xa0,0xa0, 
       };

     static COLOR color;
     f= &color;

     dmap = XDefaultColormap(disp,scr);

     for(i=0;i<5;i++)
       {
          ccc.pixel = i;
          ccc.red   = fff[i].r << 8;
          ccc.green = fff[i].g << 8;
          ccc.blue  = fff[i].b << 8;   
          ccc.flags = DoRed|DoGreen|DoBlue;
          ccc.pad   = 0xff;  

          if (!XAllocColor(disp,dmap,&ccc))
               { printf("Can not alloc color:  colormap is full\n");
                 ccc.pixel=i; }   

          switch(i)
            {
	      case 0:     f->frame  = ccc.pixel;
                          f->shadow = ccc.pixel;   
                          f->text   = ccc.pixel;
                          f->work   = ccc.pixel;  break;
   	      case 1:     f->window = ccc.pixel;
                          f->header_text= ccc.pixel;
                          f->line   = ccc.pixel;  break;
              case 2:     f->header = ccc.pixel;  break;
              case 3:     f->bottom = ccc.pixel;  break;
              case 4:     f->border = ccc.pixel;  break;
            }               
     }
 }

/*
 *      Graphics startup Procedure
 */

VOID init_graph(int WX,int WY)
  {
       if ((disp=XOpenDisplay(NULL))==NULL)
          { printf(" Can not open XDisplay \n Bye. \n"); exit(0); }

       printf("\n");
       printf("       Welcome to 3D Laboratory version 1.0      \n");
       printf("            Copyright (c) 1994,1995 by           \n");
       printf("   Richard Gosiorovsky, Tomas Hruz, Ivo Povazan  \n\n");

       printf("display: %s\n",XDisplayString(disp));

       if (WX<200) WX=600;
       if (WY<200) WY=400;
       printf("window size: %dx%d\n",WX,WY);

       root=XDefaultRootWindow(disp);
       scr=XDefaultScreen(disp);
       gc=XDefaultGC(disp,scr);
 
       depth = XDefaultDepth(disp,scr);
       printf("depth of screen: %d\n",depth);
    
       cursor1 = XCreateFontCursor(disp,XC_arrow);
       cursor2 = XCreateFontCursor(disp,XC_tcross);

       satt.background_pixmap     = ParentRelative;
       satt.background_pixel      = 0x0L;
       satt.border_pixmap         = CopyFromParent;
       satt.border_pixel          = 0x0;
       satt.bit_gravity           = StaticGravity;;
       satt.win_gravity           = NorthWestGravity;   
       satt.backing_store         = Always;
       satt.backing_planes        = 0x1L;
       satt.backing_pixel         = 0x1L; 
       satt.save_under            = True;
       satt.event_mask            = KeyPressMask | ButtonPressMask |
                                    StructureNotifyMask;
       satt.do_not_propagate_mask = 0;
       satt.override_redirect     = False;
       satt.colormap              = CopyFromParent;
       satt.cursor                = cursor1;
 
       win=XCreateWindow(disp,root,0,0,WX,WY,8,depth,CopyFromParent,
                         XDefaultVisual(disp,scr),0xffffffffL,&satt);

         XStoreName(disp,win,"3D Lab"); 
       XSetIconName(disp,win,"3D Laboratory");

       XAutoRepeatOn(disp);
       XBell(disp,20);

       XMapWindow(disp,win);
       XSetLineAttributes(disp,gc,0,LineSolid,CapNotLast,JoinMiter);  
       
       Palette();    

       menumap=XCreatePixmap(disp,win,300,200,depth);
           map=XCreatePixmap(disp,win,XMaxRES,YMaxRES,depth); 

       Idata = (char *)malloc( XMaxRES * YMaxRES );
       image = XCreateImage(disp,XDefaultVisual(disp,scr),depth,
                            ZPixmap,0,Idata,XMaxRES,YMaxRES,8,0); 

       GColor(f->line);
       Output(SCREEN);
       XSync(disp,1);
  }

VOID close_graph()
  {
     INT i;
     XFreePixmap(disp,menumap);
     XFreePixmap(disp,map);
     XDestroyImage(image);
     close_CU3();
     close_ZBF();
     close_CU2();
     for(i=0;i<pt;i++) free_object(&object[i]);
     XFlush(disp);
     XCloseDisplay(disp);
     printf("\n   Thanks for your usage.\n\n");
  }

/*
 *     get window heigtht and width
 */

INT GetMaxX()
  {
     XGetWindowAttributes(disp,win,&watt);
     return(watt.width);
  }
INT GetMaxY()
  {
 /*  XGetWindowaAttributes(disp,win,&watt); */ 
     return(watt.height);
  }

/*
 *    output device interface
 */

VOID GColor(INT Color) 
  {
     XSetForeground(disp,gc,Color);  
     if (Cur_Out==IMAGE) Image_F = Color;
  }

/*
 *    point interface
 */

VOID GPoint(INT x,INT y)   /* image point */
  {
    XPutPixel(image,x,y,Image_F);  
  }

VOID FPoint(INT x,INT y)   /* file point */
  {
    fprintf(output_file,"%d %d\n",x,y);   
  }

VOID X_Point(INT x,INT y)   /* drawable point */
  {
     XDrawPoint(disp,DRAW,gc,x,y); 
  }

VOID X_Line(INT x1,INT y1,INT x2,INT y2,INT Color)
  {
     GColor(Color);
     XDrawLine(disp,win,gc,x1,y1,x2,y2);
  } 

VOID X_Poly(INT N,POINT2 point[])
  {
     XDrawLines(disp,DRAW,gc,(XPoint *)point,N,CoordModeOrigin);  
  } 

VOID X_FillPoly(INT N,POINT2 point[],INT CO,INT CV)
  {
    GColor(CV); 
    XFillPolygon(disp,DRAW,gc,(XPoint *)point,N,Convex,CoordModeOrigin);  

    if (CO) 
       { GColor(CO);
         point[N]=point[0];
         XDrawLines(disp,DRAW,gc,(XPoint *)point,N+1,CoordModeOrigin); }
  }  

VOID Line_mode(INT Mod)
  {
     if (Mod==0) XSetFunction(disp,gc,GXcopy);
            else XSetFunction(disp,gc,GXxor);   
  }

VOID FillRectangle(INT x1,INT y1,INT x2,INT y2,INT Color)
  {
      GColor(Color);
      XFillRectangle(disp,win,gc,x1,y1,x2-x1+1,y2-y1+1);
  }

VOID Rectangle(INT x1,INT y1,INT x2,INT y2,INT Color)
  {
      GColor(Color);
      XDrawRectangle(disp,win,gc,x1,y1,x2-x1,y2-y1);
  } 

/*
 *    Output Selection
 */

extern VOID GLine(INT x1,INT y1,INT x2,INT y2,INT F);  
extern VOID GFillPoly(INT N,POINT2 point[],INT F1,INT F2);
extern VOID GPoly(INT N,POINT2 point[]);  

VOID Output(INT O)
 {
   char *name;   

   Cur_Out = O;

   switch (O)
     {
        case SCREEN:  DRAW = win;
                      FillPoly    = X_FillPoly;
                      Poly        = X_Poly;
                      Point       = X_Point;
                      Line        = X_Line;
                      break;
	case PIXMAP:  DRAW = map;
                      FillPoly    = X_FillPoly;
                      Poly        = X_Poly;
                      Point       = X_Point;
                      Line        = X_Line;
                      break;
        case IMAGE:   DRAW = win;
                      FillPoly    = GFillPoly;
                      Poly        = GPoly;
                      Point       = GPoint;
                      Line        = GLine;
                      break;
        case GFILE:   name=input(100,200,"File","file name:");
   		      output_file=fopen(name,"w");
                      DRAW = win;
                      FillPoly    = GFillPoly;
                      Poly        = GPoly;
                      Point       = FPoint;
                      Line        = GLine;
                      break;
       }
 }

/*
 *      text functions
 */

INT TextHeight(CHAR *Text)
  {
    return(12);
  }

INT TextWidth(CHAR *Text)
  {
    return(6*strlen(Text));
  } 

VOID TextXY(INT x,INT y,CHAR *Text)
  {
    INT Hi;
    Hi=TextHeight("I")-3;
    XDrawString(disp,win,gc,x,y+Hi,Text,strlen(Text));  
  } 

/*
 *      save under 
 */

VOID GetArea(INT x1,INT y1,INT x2,INT y2)
  { 
    XCopyArea(disp,win,menumap,gc,x1,y1,x2-x1+1,y2-y1+1,0,0);   
  }

VOID PutArea(INT x1,INT y1,INT x2,INT y2)
  {
    XCopyArea(disp,menumap,win,gc,0,0,x2-x1+1,y2-y1+1,x1,y1);  
  } 

/*
 *     Clear & Put
 */

VOID Clear(INT x1,INT y1,INT x2,INT y2,INT Color)
  {
    INT i;
    GColor(Color);
    if (Cur_Out==SCREEN) XFillRectangle(disp,win,gc,x1,y1,x2-x1+1,y2-y1+1);
    if (Cur_Out==PIXMAP) XFillRectangle(disp,map,gc,x1,y1,x2-x1+1,y2-y1+1); 
    if (Cur_Out==IMAGE)  for(i=0;i<XMaxRES*YMaxRES;i++) *(Idata+i)=Color;
  }

VOID PutPixmap(INT x1,INT y1,INT x2,INT y2)
 {
  if (Cur_Out==PIXMAP) XCopyArea(disp,map,win,gc,x1,y1,x2-x1+1,y2-y1+1,x1,y1); 
  if (Cur_Out==IMAGE) XPutImage(disp,win,gc,image,x1,y1,x1,y1,x2-x1+1,y2-y1+1);
 }

/*--------------------------------------------------------------------------*/

