/* diw_map.h : Digital Image Warping graphical user interface header
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#ifndef _DIW_MAP__INCLUDED_
#define _DIW_MAP__INCLUDED_

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "my_malloc.h"

#include "image.h"

typedef struct diw_map_ {
  /* in lieu of making the DIW its own widget... */
  Pixmap       pixmap;
  XImage       *ximage;
  int          width, height; /* X pixmap/image geometry */
  Widget       widget;  /* core widget, for drawing images in */
  Widget       form;    /* geometry widget, parent of all diw_map widgets */
  Widget       smp, sml,  dmp, dml,  tmp, tml;
  Widget       dissolve_sb, warp_sb; /* scrollbars */

  rgba_image_t src_img;
  rgba_image_t dst_img;
  double       img_t; /* RGBA crossfade parameter */
  double       img_brightness; /* brightness factor of image */
  int          mesh_num_x, mesh_num_y;
  double       *mesh_xs, *mesh_ys;
  double       *mesh_xd, *mesh_yd;
  double       mesh_t; /* parameter between 0.0 and 1.0 for s or d map */
  Boolean      meshpoint_selected;
  int          meshpoint_selected_loc[2]; /* i,j indices */
  Boolean      meshpoints_t_draw; /* draw interp mesh points over image */
  Boolean      meshlines_t_draw; /* draw interp mesh lines over image */
  Boolean      meshpoints_src_draw; /* draw src mesh points over image */
  Boolean      meshlines_src_draw; /* draw src mesh lines over image */
  Boolean      meshpoints_dst_draw; /* draw dst mesh points over image */
  Boolean      meshlines_dst_draw; /* draw dst mesh lines over image */
} diw_map_t;

#define NUM_DIW_MAPS 4
extern diw_map_t global_diw_map[];

extern XColor diw_xcolors[];

extern diw_map_t *diw_map_of_widget(Widget widget);

/* DrawMeshes: action to draw src, dst, and tween meshes of a widget */
extern void DrawMeshes(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* DrawAllMeshes: action to draw all meshes of all diw_maps */
extern void DrawAllMeshes(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* RefreshImage: action to draw image in diw_map image panel */
extern void RefreshImage(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* FakeExpose: action to fake an expose event to a diw_map widget */
extern void FakeExpose(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* FakeAllExpose: action to fake an expose event to all diw_map's */
extern void FakeAllExpose(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* ReditherImage: action to redither diw_map images into an image panel */
extern void
ReditherImage(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* ReditherAllImages: action to redither all diw_map images into image panel */
extern void ReditherAllImages(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* WarpImage: action to apply digital image warp algorithm to images */
extern void WarpImage(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* ChangeMeshLine: action to add or delete a mesh line */
extern void ChangeMeshLine(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* PickMeshpoint: action to grab a meshpoint */
extern void PickMeshpoint(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* UnpickMeshpoint: action to release meshpoint after drag */
extern void UnpickMeshpoint(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* DragMeshpoint: action to set meshpoint drag "to" location */
extern void DragMeshpoint(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* StartDragMeshpoint: action to set meshpoint drag "from" location */
extern void StartDragMeshpoint(Widget widget, XEvent *evt, String *prms, Cardinal *n_prms);

/* dp_menu_cb: callback for diw_map properties menu entries */
extern void dp_menu_cb(Widget widget, XtPointer client_data, XtPointer call_data);

extern int allocate_x_images(Widget widget, Pixmap *pxP, XImage **xiP, int nx, int ny);

extern Widget create_diw_widget(Widget parent, diw_map_t *dmP, int width, int height);

extern void init_diw_stuff(Widget toplevel);
#endif /* _DIW_MAP__INCLUDED_ */
