static char rcsid[] = "@(#)$Id: cvtoppm.c,v 2.6.2.1 1995/01/26 04:40:54 peter Exp $";
/*
 *  cvtoppm - a program to generate p?m depth maps from various data.

 * A depth map is created from 3D data and saved in P*M format.
 * Also the PC SIRDS program MindImage's rle format can be converted.
 * The data can be piped to another filter, such as sisgen.

 * Copyright 1994 and 1995, 26th January.
 * By Peter Chang
 * peterc@a3.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: cvtoppm.c,v $
 * Revision 2.6.2.1  1995/01/26  04:40:54  peter
 * Fixed bug with non-initialization of oname[].
 *
 * Comment changed in ppm output.
 *
 * Revision 2.6  1994/11/18  04:03:04  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:27  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:20  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define SIRDS_STUFF
#include "pgs.h"
#include "polyh.h"
#include "pxmio.h"
#include "zbuffer.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

Object *shapes = NULL;
usint nobj = 0;
float theta, phi;

int   width, height;
int   buf_h = ZBLINES, buf_top, buf_bot;

/* float zshift = 1.0, zfactor = 1.0; */
int fineness = 0;
int reverse = 1;
float background = -1.0;
float pmm = 3.9385;
float enlarge = 1.0;

Myrgb  *palette = NULL;
int    nocols, zmax, coloured = 0;
usshort *tile = NULL;
int tw, th;

static int input, output, ocoloured = 0;
static float mag = 1.0;

int main(int argc, char **argv)
{
   int x, y, colour;
   int **ztop = NULL; /* z-buffer */
   int *zline;
   int  *imap = NULL; /* integer depth map */
   Myrgb *pixarray, *pline;
   FILE  *fo;
   int of, dmax, omax;
   Affine globalaf;
   float ratio;
   char fname[NLEN], oname[NLEN];

   void pcl(int , char **, char *, char *);
   int *pcrle(char [NLEN], int ); /* from pcrle.c */
   void rescale(int , int **, int *);

   input = 0;
   output = 1;
   width = -1;
   height = -1;
   zmax = 255;
   oname[0] = '\0';

   pcl(argc, argv, fname, oname);
   omax = zmax;
   switch(input) {
    case 1:
      imap = (int *)loadpxm(fname, LDPXMDMAP);
      if (width <= 0 || height <= 0) {
	 width = tw;
	 height = th;
      }
      break;
    case 2:
      imap = pcrle(fname, output);
      if (width <= 0 || height <= 0) {
	 width = tw;
	 height = th;
      }
      break;
    case 0: default:
      if (width <= 0 || height <= 0) {
	 width = 320;
	 height = 198;
      }
      DIEIF3(loadshapes(fname, output) < 0,
	     "ERROR: something wrong with %s\n", fname);
      break;
   }
   ztop = zmema();

   DIEIF((pixarray = (Myrgb *)malloc(width*sizeof(Myrgb))) == NULL,
               "Unable to allocate memory for array\n");

   if (output && strlen(oname) < 1) {
      printf("Enter name for output ppm file: ");
      scanf("%50s", oname);
      printf("\n");
   }
#ifndef VMS
   if (output) {
      DIEIF3((fo = fopen(oname, "w")) == NULL,
	    "Unable to open file : %s\n", oname);
   } else
      fo = stdout;
#else
   DIEIF3((fo = fopen(oname, "w")) == NULL,
	  "Unable to open file : %s\n", oname);
#endif

   dmax = zmax + 1;
   if (coloured) dmax *= dmax*dmax;
   if (ocoloured) {
      nocols = omax + 1;
      nocols *= nocols*nocols;
   } else {
      nocols = omax + 1;
   }
   coloured = ocoloured;
   switch(input) {
    case 1: case 2:
      of = 0;
      ratio = enlarge*nocols/(float) dmax;
      break;
    case 0: default:
      of = (int) (OY*enlarge*(1<<fineness));
      ratio = nocols / (float) (2.0*of);
      break;
   }

   zmax = omax;
   pxmstart(fo);
   if (output) fprintf(fo, "# %s made by cvtoppm from %s\n", oname, fname);
   fprintf(fo, "%d %d\n%d\n",width, height, zmax);
   
   dmax = zmax + 1;
   buf_bot = 0;
   if (input == 0) initaffine(&globalaf);

   for (y=0; y<height; y++) {
      if (y == buf_bot) {
	 switch(input) {
	  case 1: case 2:
	    rescale(y, ztop, imap);
	    break;
	  case 0: default:
	    zfillall(y, ztop, mag, &globalaf);
	    break;
	 }
      }
      zline = ztop[y%buf_h];
      pline = pixarray;
      for (x=0; x<width; x++, pline++) {
	 colour = *zline++;
	 colour += of;
	 colour = (int) (colour * ratio);
	 if (colour < 0) colour = 0;
	 else if (colour >= nocols) colour = nocols - 1;
	 if (coloured) {
	    pline->b = colour % dmax;
	    colour /= dmax;
	    pline->g = colour % dmax;
	    colour /= dmax;
	    pline->r = colour;
	 } else {
	    pline->r = colour;
	 }
      }
      pxmline(fo, pixarray);
   }
   pxmline(fo, NULL);

   if (output) {
      fclose(fo);
      printf("\nSaved %s\n", oname);
   }
   zmemf(ztop);
   free(pixarray);
   if (input == 0) killallshapes();
   else free(imap);

   return EXIT_SUCCESS;
}


/* now scale up image to fit screen size */
void rescale(int yy, int **zbuf, int *itop)
{
   int i, j, y;
   float xratio, yratio;
   int *iline;
   int *zline;

   buf_top = yy;
   buf_bot = yy + buf_h;

   xratio = tw / (float) width;
   yratio = th / (float) height;

#ifdef MYDEBUG
   printf("ratios %f %f size %d %d\n", xratio, yratio, tw, th);
#endif
   for (j=0; j<buf_h; j++) {
      zline = zbuf[j];
      y = (int) (yratio * (j+yy) + 0.5);
      iline = &itop[(y % th) * tw];
      for (i=0; i<width; i++, zline++) {
	 *zline = iline[(int) (xratio * i + 0.5)];
      }
   }
}


/*
 * Parse the command line set the filename and the appropriate flags
 */
void pcl(int argc, char **argv, char *iname, char *oname)
{
   static const char *options[] = {
      "-help                     print this message",
      "-geometry <wxh>             picture geometry (320x198)",
      "-background <b>             background plane (-1.0)",
      "-enlarge <ef>       set Z enlargement factor (1.0)",
      "-mag <mf>             magnification of scene (1.0)",
      "-pmm <res>           resolution in pixels/mm (4.0)",
      "-zmax <zm>           max colour value in p*m (255)",
      "-colour                        set colouring",
      "-xss                  load xss or polyh file (default)",
      "-dmap                 load p*m depthmap file",
      "-mind                load mindimage rle file",
      "-zblines <zb>  lines to use in each z buffer (256)",
#ifndef VMS
      "-output    use stdout for resultant p*m file",
#endif
      NULL
   };

   static const char usage1[] =
      "usage:  cvtoppm [options] <input file> [output p*m file]";
   static const char usage2[] = " try cvtoppm -help for a list of option";

   int i, optno, fvalid = 0, olen;
   const char **sptr;

   for (i = 1; i < argc; i++) {
      olen = strlen(argv[i]);
      for (sptr = options, optno = 0; *sptr != NULL; sptr++, optno++)
      	 if (strncmp(argv[i], *sptr, olen) == 0) break;

      switch(optno) {
       case 0:
         printf("%s\n", usage1);
         printf("Options (defaults in parenthesis):\n");
	 for (sptr = options; *sptr != NULL; sptr++) printf(" %s\n", *sptr);
	 printf("\n");
         exit(EXIT_SUCCESS);
         break;

       case 1:
	 sscanf(argv[++i], "%dx%d", &width, &height);
         break;

       case 2:
         background = atof(argv[++i]);
         break;

       case 3:
         enlarge = atof(argv[++i]);
         break;

       case 4:
	 mag = atof(argv[++i]);
	 break;

       case 5:
         pmm = atof(argv[++i]);
         break;

       case 6:
         zmax = atoi(argv[++i]);
         break;

       case 7:
         ocoloured = 1;
         break;

       case 8:
         input = 0;
         break;

       case 9:
         input = 1;
         break;

       case 10:
         input = 2;
         break;

       case 11:
         buf_h = atoi(argv[++i]);
         break;

#ifndef VMS
       case 12:
         output = 0;
	 break;
#endif

       default:
         if (fvalid  < 2 && *argv[i] != '-') {
	    switch (fvalid) {
	     case 0:
	       strcpy(iname, argv[i]);
	       break;
	     case 1:
	       strcpy(oname, argv[i]);
	       break;
	    }
            fvalid++;
         } else {
            DIE4("%s\n%s\n", usage1, usage2);
         }
         break;
      }
   }

   DIEIF4(fvalid < 1, "%s\n%s\n", usage1, usage2);
}
